/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util.excel;

import com.efuture.business.util.excel.RecordValue;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class WorkBookService {
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public void fillData4Map(Sheet sheet, List<Map<String, Object>> dataList) {
        this.fillData4Map(0, sheet, dataList);
    }

    public void fillData4Map(int headerStart, Sheet sheet, List<Map<String, Object>> dataList) {
        if (dataList.size() == 0) {
            return;
        }
        int rowIdx = headerStart;
        Row row = sheet.createRow(rowIdx++);
        Set<String> headerSet = dataList.get(0).keySet();
        String[] headerNames = new String[headerSet.size()];
        int columnIdx = 0;
        for (String string : headerSet) {
            sheet.autoSizeColumn(columnIdx);
            Cell cell = row.createCell(columnIdx);
            cell.setCellValue(string);
            headerNames[columnIdx++] = string;
        }
        for (Map map : dataList) {
            Row dataRow = sheet.createRow(rowIdx++);
            for (int i = 0; i < headerNames.length; ++i) {
                Object content = map.get(headerNames[i]);
                Cell cell = dataRow.createCell(i);
                cell.setCellValue(WorkBookService.getStringValue(content));
            }
        }
    }

    public void fillData4Map(Sheet sheet, String[] headerNames, List<Map<String, Object>> dataList) {
        this.fillData4Map(0, sheet, headerNames, dataList);
    }

    public void fillData4Map(int headerStart, Sheet sheet, String[] headerNames, List<Map<String, Object>> dataList) {
        int rowIdx = headerStart;
        Row row = sheet.createRow(rowIdx++);
        int columnIdx = 0;
        for (String key : headerNames) {
            Cell cell = row.createCell(columnIdx++);
            cell.setCellValue(key);
        }
        if (CollectionUtils.isEmpty(dataList)) {
            return;
        }
        for (Map map : dataList) {
            Row dataRow = sheet.createRow(rowIdx++);
            for (int i = 0; i < headerNames.length; ++i) {
                Object content = map.get(headerNames[i]);
                Cell cell = dataRow.createCell(i);
                cell.setCellValue(WorkBookService.getStringValue(content));
            }
        }
    }

    public void fillData4RecordValue(int headerStart, Sheet sheet, String[] headerNames, List<RecordValue> dataList) {
        CellStyle centerStyle = sheet.getWorkbook().createCellStyle();
        centerStyle.setVerticalAlignment((short)1);
        centerStyle.setWrapText(true);
        int rowIdx = headerStart;
        String[] realHeaderNames = headerNames;
        Row headerRow = null;
        if (realHeaderNames == null) {
            headerRow = sheet.getRow(rowIdx++);
            realHeaderNames = new String[headerRow.getLastCellNum() - headerRow.getFirstCellNum()];
            int i = 0;
            for (int cellNum = headerRow.getFirstCellNum(); cellNum < headerRow.getLastCellNum(); ++cellNum) {
                Cell cell = headerRow.getCell(cellNum);
                String stringCellValue = cell.getStringCellValue();
                stringCellValue = stringCellValue == null ? "" : stringCellValue.trim();
                realHeaderNames[i++] = stringCellValue;
            }
        } else {
            headerRow = sheet.createRow(rowIdx++);
            int columnIdx = 0;
            for (String key : realHeaderNames) {
                sheet.autoSizeColumn(columnIdx, true);
                Cell cell = headerRow.createCell(columnIdx++);
                cell.setCellValue(key);
            }
        }
        if (CollectionUtils.isEmpty(dataList)) {
            return;
        }
        for (RecordValue parentRecord : dataList) {
            List<RecordValue> secondChildList;
            List<RecordValue> childValueList = parentRecord.getChildValueList();
            if (CollectionUtils.isEmpty(childValueList)) {
                Row dataRow = sheet.createRow(rowIdx++);
                for (int i = 0; i < realHeaderNames.length; ++i) {
                    Cell cell = dataRow.createCell(i);
                    String currentHeader = realHeaderNames[i];
                    cell.setCellValue(parentRecord.getValue(currentHeader));
                    cell.setCellStyle(centerStyle);
                }
                continue;
            }
            Set<String> parentHeaders = parentRecord.headerSet();
            int startRow = rowIdx;
            boolean parentFirstRow = true;
            int parentRecordsNum = 0;
            for (RecordValue childRecord : childValueList) {
                secondChildList = childRecord.getChildValueList();
                parentRecordsNum += CollectionUtils.isEmpty(secondChildList) ? 1 : secondChildList.size();
            }
            for (RecordValue childRecord : childValueList) {
                secondChildList = childRecord.getChildValueList();
                if (CollectionUtils.isEmpty(secondChildList)) {
                    Row dataRow = sheet.createRow(rowIdx++);
                    for (int i = 0; i < realHeaderNames.length; ++i) {
                        Cell cell = dataRow.createCell(i);
                        String currentHeader = realHeaderNames[i];
                        if (parentHeaders.contains(currentHeader)) {
                            if (!parentFirstRow) continue;
                            CellRangeAddress range = new CellRangeAddress(startRow, startRow + childValueList.size() - 1, i, i);
                            sheet.addMergedRegion(range);
                            cell.setCellValue(parentRecord.getValue(currentHeader));
                            cell.setCellStyle(centerStyle);
                            continue;
                        }
                        cell.setCellValue(childRecord.getValue(currentHeader));
                    }
                    parentFirstRow = false;
                    continue;
                }
                Set<String> childHeaders = childRecord.headerSet();
                int childStart = rowIdx;
                boolean secondFirstRow = true;
                for (RecordValue secondChild : secondChildList) {
                    Row dataRow = sheet.createRow(rowIdx++);
                    for (int i = 0; i < realHeaderNames.length; ++i) {
                        CellRangeAddress range;
                        Cell cell = dataRow.createCell(i);
                        String currentHeader = realHeaderNames[i];
                        if (parentHeaders.contains(currentHeader)) {
                            if (!parentFirstRow) continue;
                            range = new CellRangeAddress(startRow, startRow + parentRecordsNum - 1, i, i);
                            sheet.addMergedRegion(range);
                            cell.setCellValue(parentRecord.getValue(currentHeader));
                            cell.setCellStyle(centerStyle);
                            continue;
                        }
                        if (childHeaders.contains(currentHeader)) {
                            if (!secondFirstRow) continue;
                            range = new CellRangeAddress(childStart, childStart + secondChildList.size() - 1, i, i);
                            sheet.addMergedRegion(range);
                            cell.setCellValue(childRecord.getValue(currentHeader));
                            cell.setCellStyle(centerStyle);
                            continue;
                        }
                        cell.setCellValue(secondChild.getValue(currentHeader));
                    }
                    parentFirstRow = false;
                    secondFirstRow = false;
                }
            }
        }
        if (headerNames != null) {
            for (int columnIdx2 = 0; columnIdx2 < realHeaderNames.length; ++columnIdx2) {
                sheet.autoSizeColumn(columnIdx2, true);
            }
        }
    }

    public void fillData4RecordValue(Sheet sheet, String[] headerNames, List<RecordValue> dataList) {
        this.fillData4RecordValue(0, sheet, headerNames, dataList);
    }

    private static String getStringValue(Object content) {
        if (content == null) {
            return "";
        }
        if (content instanceof String) {
            return (String)content;
        }
        if (content instanceof Number) {
            return String.valueOf(content);
        }
        if (content instanceof Date) {
            return DateFormatUtils.format((Date)((Date)content), (String)DATE_FORMAT);
        }
        return String.valueOf(content);
    }
}

