/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util.moho;

import com.alibaba.fastjson.JSONObject;
import com.efuture.business.util.moho.MohoHttpRequest;
import com.efuture.business.util.moho.MohoHttpRequestEnum;
import com.google.common.collect.ImmutableMap;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUtil {
    private static final Logger log = LoggerFactory.getLogger(SignUtil.class);
    private static final String SIGN_TYPE = "MD5";
    private static final String HTTP_POST_METHOD = "POST";
    private static final String HTTP_GET_METHOD = "GET";
    private static final String LF = "\n";
    private static final String SPACE = " ";
    private static final String APPID = "wx2380cba19b24c36d";
    private static final String SECRET = "wx2380cba19b24c36d";

    public static void main(String[] args) throws Exception {
        JSONObject map = new JSONObject();
        String s = "{\"orderId\":\"020199991663569605722\"}";
        map = JSONObject.parseObject((String)s);
        System.out.println(map.toJSONString());
        String reponse = MohoHttpRequest.doRequest(MohoHttpRequestEnum.ROLLBACKCONSUMEORDERCOUPON, map.toJSONString());
        System.out.println(reponse);
    }

    private static List<NameValuePair> covertParams2NVPS(Map<String, Object> params) {
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
        for (Map.Entry<String, Object> param : params.entrySet()) {
            pairs.add((NameValuePair)new BasicNameValuePair(param.getKey(), String.valueOf(param.getValue())));
        }
        return pairs;
    }

    public static String getAuthorizationInf(String type, String canonicalUrl, String body) {
        String nonceStr = UUID.randomUUID().toString().replace("-", "");
        long timestamp = System.currentTimeMillis() / 1000L;
        String signature = SignUtil.doSign(type, canonicalUrl, timestamp, nonceStr, body, "wx2380cba19b24c36d");
        Object signInfo = ImmutableMap.of((Object)"appid", (Object)"wx2380cba19b24c36d", (Object)"nonce_str", (Object)nonceStr, (Object)"signature", (Object)signature, (Object)"timestamp", (Object)String.valueOf(timestamp)).entrySet().stream().map(n -> (String)n.getKey() + "=\"" + (String)n.getValue() + "\"").collect(Collectors.joining(","));
        signInfo = "MD5 " + (String)signInfo;
        return signInfo;
    }

    public static String doSign(String method, String canonicalUrl, long timestamp, String nonceStr, String body, String secret) {
        String signStr = SignUtil.buildMessage(method, canonicalUrl, timestamp, nonceStr, body, secret);
        System.out.println("\u5f85\u7b7e\u540d\u5b57\u7b26\u4e32:" + signStr);
        String sign = SignUtil.MD5_32(signStr);
        log.info("\u7b7e\u540d\u7ed3\u679csign={}", (Object)sign);
        System.out.println("\u7b7e\u540d\u7ed3\u679csign:" + sign);
        return sign;
    }

    private static String buildMessage(String method, String canonicalUrl, long timestamp, String nonceStr, String body, String secret) {
        return method + LF + canonicalUrl + LF + timestamp + LF + nonceStr + LF + body + LF + secret + LF;
    }

    public static String MD5_32(String src) {
        try {
            byte[] bytes = SignUtil.encryptMD5(src);
            return SignUtil.byte2hex(bytes);
        }
        catch (Exception e) {
            log.error("MD5_32 error: {}", (Object)e.getMessage());
            return "";
        }
    }

    public static byte[] encryptMD5(String info) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md5 = MessageDigest.getInstance(SIGN_TYPE);
        byte[] infoBytes = info.getBytes(Charset.forName("UTF-8"));
        md5.update(infoBytes);
        return md5.digest();
    }

    public static String byte2hex(byte[] bytes) {
        StringBuilder sign = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex.toLowerCase());
        }
        return sign.toString();
    }
}

