/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util.mqtt;

import com.efuture.business.util.mqtt.MqttConfigBean;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MqttConsumer {
    private static final Logger log = LoggerFactory.getLogger(MqttConsumer.class);
    private static MqttClient mqttClient;
    @Autowired
    private MqttConfigBean mqttConfigBean;

    public static MqttClient getClient() {
        return mqttClient;
    }

    public void connect(String clientid) throws Exception {
        if (null != mqttClient) {
            System.out.println("mqttClient.isConnected()" + mqttClient.isConnected());
            if (mqttClient.isConnected()) {
                return;
            }
        }
        mqttClient = new MqttClient(this.mqttConfigBean.getUrl(), clientid, (MqttClientPersistence)new MemoryPersistence());
        MqttConnectOptions options = new MqttConnectOptions();
        options.setCleanSession(false);
        options.setUserName(this.mqttConfigBean.getUsername());
        options.setPassword(this.mqttConfigBean.getPasssword().toCharArray());
        options.setConnectionTimeout(10);
        options.setKeepAliveInterval(300);
        options.setAutomaticReconnect(false);
        try {
            mqttClient.connect(options);
            log.info("MQTT\u8fde\u63a5\u6210\u529f:" + this.mqttConfigBean.getClientid() + ":" + mqttClient);
        }
        catch (Exception e) {
            log.error("MQTT\u8fde\u63a5\u5f02\u5e38", (Throwable)e);
        }
    }

    public void close() {
        try {
            mqttClient.close();
        }
        catch (MqttException mqttException) {
            // empty catch block
        }
    }
}

