/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util.mqtt;

import com.efuture.business.util.mqtt.MqttConsumer;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;

public class MqttSender {
    private static final Logger log = LoggerFactory.getLogger(MqttSender.class);
    @Autowired(required=false)
    private MqttConsumer mqttConsumer;

    @Async
    public void send(String queueName, String msg, String clientid) {
        log.info("=====================>>>>\u53d1\u9001\u4e3b\u9898" + queueName);
        log.info("=====================>>>>\u53d1\u9001\u5185\u5bb9" + msg);
        this.publish(0, queueName, msg, clientid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(int qos, boolean retained, String topic, String pushMessage, String clientid) {
        MqttMessage message = new MqttMessage();
        message.setQos(qos);
        message.setRetained(retained);
        message.setPayload(pushMessage.getBytes());
        try {
            this.mqttConsumer.connect(clientid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MqttSender mqttSender = this;
        MqttTopic mTopic = mqttSender.mqttConsumer.getClient().getTopic(topic);
        if (null == mTopic) {
            log.error("===================>>>MQTT topic \u4e0d\u5b58\u5728<<=================");
        }
        try {
            MqttDeliveryToken token = mTopic.publish(message);
            token.waitForCompletion();
        }
        catch (MqttPersistenceException e) {
            log.error("============>>>publish fail", (Throwable)e);
            e.printStackTrace();
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public void publish(int qos, String topic, String pushMessage, String clientid) {
        this.publish(qos, false, topic, pushMessage, clientid);
    }
}

