/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.efuture.business.bean.CheckDetailPageVO;
import com.efuture.business.bean.CheckDetailVO;
import com.efuture.business.bean.CheckHeadPageVO;
import com.efuture.business.bean.CheckPlanModelPageVO;
import com.efuture.business.bean.CheckPlanModelVO;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.dao.CheckDetaiService;
import com.efuture.business.dao.CheckHeadService;
import com.efuture.business.dao.CheckPlanDetailService;
import com.efuture.business.dao.CheckPlanService;
import com.efuture.business.exception.EfutureException;
import com.efuture.business.model.CheckDetailModel;
import com.efuture.business.model.CheckHeadModel;
import com.efuture.business.model.CheckPlanDetailModel;
import com.efuture.business.model.CheckPlanHeadModel;
import com.efuture.business.model.CheckPlanModel;
import com.efuture.business.service.CheckPlanServiceBS;
import com.efuture.business.util.ArrayUtils;
import com.efuture.business.util.DateHelpUtil;
import com.efuture.business.util.RandomNum;
import com.efuture.business.util.ReflectUtils;
import com.product.model.ServiceSession;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class CheckPlanServiceBSImpl
implements CheckPlanServiceBS {
    private static final Logger log = LoggerFactory.getLogger(CheckPlanServiceBSImpl.class);
    @Autowired
    private CheckPlanService checkPlanServic;
    @Autowired
    private CheckHeadService checkHeadService;
    @Autowired
    private CheckDetaiService checkDetaiService;
    @Autowired
    private CheckPlanDetailService checkPlanDetailService;

    @Transactional(rollbackFor={Exception.class})
    public RespBase<Boolean> saveCheckPlan(ServiceSession session, CheckPlanModelPageVO inVo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        int seqNo = this.checkPlanServic.countCheckPlan((Wrapper)queryWrapper) + 1;
        inVo.setId(ReflectUtils.getUUID()).setSeqNo(Long.valueOf(seqNo)).setStatus("0").setCreateDate(new Date());
        String errorMessage = ReflectUtils.checkParam((Object)inVo);
        if (!StringUtils.isEmpty((String)errorMessage)) {
            return Code.CODE_70013.getRespBase(new Object[]{errorMessage});
        }
        if (ArrayUtils.isEmpty((List)inVo.getCheckPlanDetailModels())) {
            return Code.CODE_70013.getRespBase(new Object[]{"\u95e8\u5e97"});
        }
        boolean save = this.checkPlanServic.saveCheckPlan((CheckPlanModel)inVo);
        if (!save) {
            throw new EfutureException(Code.CODE_70037.getRespBase(new Object[]{"\u76d8\u70b9\u8ba1\u5212\u6dfb\u52a0\u9519\u8bef"}));
        }
        List list = this.buildSessionCheckPlanDetailModelList(inVo);
        this.checkPlanDetailService.saveBatch((Collection)list, "checkplandetil");
        return new RespBase(Code.SUCCESS, (Object)true);
    }

    public RespBase<Boolean> updateCheckPlan(ServiceSession session, CheckPlanModelPageVO inVo) {
        if (StringUtils.isEmpty((String)inVo.getId())) {
            return Code.CODE_70013.getRespBase(new Object[]{"\u4e3b\u952eid"});
        }
        CheckPlanModel checkPlanModel = this.checkPlanServic.queryCheckPlanById((CheckPlanModel)inVo);
        if (null == checkPlanModel) {
            return Code.CODE_70037.getRespBase(new Object[]{"\u76d8\u70b9\u5355\u3010" + inVo.getSeqNo() + "\u3011\u4e0d\u5b58\u5728"});
        }
        String status = checkPlanModel.getStatus();
        if ("-1".equals(status)) {
            return Code.CODE_70037.getRespBase(new Object[]{"\u5355\u636e\u5df2\u53d6\u6d88\u4e0d\u5141\u8bb8\u7f16\u8f91"});
        }
        if ("1".equals(status)) {
            return Code.CODE_70037.getRespBase(new Object[]{"\u5355\u636e\u5df2\u5ba1\u6838\u4e0d\u5141\u8bb8\u7f16\u8f91"});
        }
        if ("2".equals(status)) {
            return Code.CODE_70037.getRespBase(new Object[]{"\u5355\u636e\u5df2\u5b8c\u6210\u4e0d\u5141\u8bb8\u7f16\u8f91"});
        }
        boolean update = this.checkPlanServic.updateCheckPlanById((CheckPlanModel)inVo);
        if (!update) {
            throw new EfutureException(Code.CODE_70037.getRespBase(new Object[]{"\u76d8\u70b9\u8ba1\u5212\u7f16\u8f91\u9519\u8bef"}));
        }
        if (ArrayUtils.isNotEmpty((List)inVo.getCheckPlanDetailModels())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"checkplanId", (Object)checkPlanModel.getId());
            this.checkPlanDetailService.removeCheckPlanDetail((Wrapper)queryWrapper);
            List list = this.buildSessionCheckPlanDetailModelList(inVo);
            this.checkPlanDetailService.saveBatch((Collection)list, "checkplandetail");
        }
        return new RespBase(Code.SUCCESS, (Object)true);
    }

    private List<CheckPlanDetailModel> buildSessionCheckPlanDetailModelList(CheckPlanModelPageVO inVo) {
        List list = inVo.getCheckPlanDetailModels();
        for (CheckPlanDetailModel shopCode : list) {
            CheckPlanModelVO checkPlanModelVO = new CheckPlanModelVO();
            checkPlanModelVO.setShopCode(shopCode.getShopCode());
            checkPlanModelVO.setCheckDate(inVo.getCheckDate());
            checkPlanModelVO.setStatus("-1");
            int num = this.checkPlanServic.queryCheckPlanStatus(checkPlanModelVO);
            if (num > 0) {
                throw new EfutureException(Code.CODE_70037.getRespBase(new Object[]{"\u95e8\u5e97:\u3010" + shopCode.getShopCode() + "\u3011\u7684\u76d8\u70b9\u8ba1\u5212\u5df2\u5b58\u5728"}));
            }
            shopCode.setId(ReflectUtils.getUUID()).setCheckDate(inVo.getCheckDate()).setCheckPlanId(inVo.getId());
        }
        return list;
    }

    public RespBase<IPage<CheckPlanModelPageVO>> queryCheckPlanList(ServiceSession session, CheckPlanModelPageVO inVo) {
        log.info("\u67e5\u8be2\u76d8\u70b9\u8ba1\u5212\u5217\u8868:{}", (Object)inVo.toString());
        QueryWrapper queryWrapper = new QueryWrapper();
        if (null != inVo.getCheckDate()) {
            queryWrapper.apply("checkDate = {0}", new Object[]{DateHelpUtil.getDateStringFromMillisecond((Long)inVo.getCheckDate().getTime())});
        }
        if (null != inVo.getCreateDate()) {
            queryWrapper.apply("createDate = {0}", new Object[]{DateHelpUtil.getDateStringFromMillisecond((Long)inVo.getCreateDate().getTime())});
        }
        if (null != inVo.getCancelDate()) {
            queryWrapper.apply("cancelDate = {0}", new Object[]{DateHelpUtil.getDateStringFromMillisecond((Long)inVo.getCancelDate().getTime())});
        }
        if (!StringUtils.isEmpty((String)inVo.getOperuser())) {
            queryWrapper.eq((Object)"operuser", (Object)inVo.getOperuser());
        }
        if (!StringUtils.isEmpty((String)inVo.getStatus())) {
            queryWrapper.eq((Object)"status", (Object)inVo.getStatus());
        }
        queryWrapper.select(new String[0]).orderByDesc((Object)"checkDate");
        if (null == inVo.getPageCurrent() || null == inVo.getPageSize()) {
            inVo.setPageCurrent(Integer.valueOf(1)).setPageSize(Integer.valueOf(20));
        }
        Page page = new Page((long)inVo.getPageCurrent().intValue(), (long)inVo.getPageSize().intValue());
        IPage list = this.checkPlanServic.queryCheckPlanPage(page, (Wrapper)queryWrapper);
        for (int i = 0; i < list.getRecords().size(); ++i) {
            CheckPlanModelPageVO checkPlanModel = (CheckPlanModelPageVO)list.getRecords().get(i);
            QueryWrapper planDetailModelQueryWrapper = new QueryWrapper();
            planDetailModelQueryWrapper.eq((Object)"checkPlanId", (Object)checkPlanModel.getId());
            List checkPlanDetailModelList = this.checkPlanDetailService.list((Wrapper)planDetailModelQueryWrapper);
            checkPlanModel.setCheckPlanDetailModels(checkPlanDetailModelList);
            checkPlanModel.setSeqNo(Long.valueOf(i + 1));
        }
        return new RespBase(Code.SUCCESS, (Object)list);
    }

    public RespBase<Boolean> auditCheckPlan(ServiceSession session, CheckPlanModel inVo) {
        if (StringUtils.isEmpty((String)inVo.getId())) {
            return Code.CODE_70013.getRespBase(new Object[]{"\u4e3b\u952eid"});
        }
        if (StringUtils.isEmpty((String)inVo.getChecker())) {
            return Code.CODE_70013.getRespBase(new Object[]{"\u5ba1\u6838\u4eba"});
        }
        if (null == inVo.getApproveDate()) {
            return Code.CODE_70013.getRespBase(new Object[]{"\u5ba1\u6838\u65f6\u95f4"});
        }
        CheckPlanModel queryCheckPlan = this.checkPlanServic.queryCheckPlanById(inVo);
        if (null == queryCheckPlan) {
            return Code.CODE_70037.getRespBase(new Object[]{"\u5ba1\u6838\u5355\u636e\u4e0d\u5b58\u5728"});
        }
        String status = queryCheckPlan.getStatus();
        if (!"0".equals(status)) {
            return Code.CODE_70037.getRespBase(new Object[]{"\u4ec5\u5141\u8bb8\u5bf9\u672a\u5ba1\u6838\u7684\u76d8\u70b9\u8ba1\u5212\u8fdb\u884c\u5ba1\u6838\u64cd\u4f5c!"});
        }
        queryCheckPlan.setStatus("1").setChecker(inVo.getChecker()).setApproveDate(inVo.getApproveDate());
        boolean update = this.checkPlanServic.updateCheckPlanById(queryCheckPlan);
        if (!update) {
            throw new EfutureException(Code.CODE_70037.getRespBase(new Object[]{"\u76d8\u70b9\u8ba1\u5212\u5ba1\u6838\u9519\u8bef"}));
        }
        return new RespBase(Code.SUCCESS, (Object)true);
    }

    public RespBase<Boolean> cancelCheckPlan(ServiceSession session, CheckPlanModel inVo) {
        if (StringUtils.isEmpty((String)inVo.getId())) {
            return Code.CODE_70013.getRespBase(new Object[]{"\u4e3b\u952eid"});
        }
        if (StringUtils.isEmpty((String)inVo.getCanceluser())) {
            return Code.CODE_70013.getRespBase(new Object[]{"\u53d6\u6d88\u4eba"});
        }
        if (null == inVo.getCancelDate()) {
            return Code.CODE_70013.getRespBase(new Object[]{"\u53d6\u6d88\u65f6\u95f4"});
        }
        CheckPlanModel queryCheckPlan = this.checkPlanServic.queryCheckPlanById(inVo);
        String status = queryCheckPlan.getStatus();
        if ("2".equals(status)) {
            return Code.CODE_70037.getRespBase(new Object[]{"\u5f53\u524d\u5355\u636e\u5df2\u5b8c\u6210\u65e0\u6cd5\u53d6\u6d88!"});
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"checkPlanId", (Object)queryCheckPlan.getId());
        List list = this.checkHeadService.list((Wrapper)queryWrapper, "checkhead");
        if (ArrayUtils.isNotEmpty((List)list)) {
            return Code.CODE_70037.getRespBase(new Object[]{"\u8be5\u5355\u636e\u5df2\u76d8\u70b9\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88!"});
        }
        queryCheckPlan.setStatus("-1").setCanceluser(inVo.getCanceluser()).setCancelDate(inVo.getCancelDate());
        boolean update = this.checkPlanServic.updateCheckPlanById(queryCheckPlan);
        if (!update) {
            throw new EfutureException(Code.CODE_70037.getRespBase(new Object[]{"\u76d8\u70b9\u8ba1\u5212\u53d6\u6d88\u9519\u8bef"}));
        }
        return new RespBase(Code.SUCCESS, (Object)true);
    }

    public RespBase<Boolean> completeCheckPlan(ServiceSession session, CheckPlanModel inVo) {
        if (StringUtils.isEmpty((String)inVo.getId())) {
            return Code.CODE_70013.getRespBase(new Object[]{"\u4e3b\u952eid"});
        }
        CheckPlanModel queryCheckPlan = this.checkPlanServic.queryCheckPlanById(inVo);
        if (null == queryCheckPlan) {
            return Code.CODE_70037.getRespBase(new Object[]{"\u67e5\u8be2\u76d8\u70b9\u8ba1\u5212\u5931\u8d25!"});
        }
        String status = queryCheckPlan.getStatus();
        if (!"1".equals(status)) {
            return Code.CODE_70037.getRespBase(new Object[]{"\u5f53\u524d\u5355\u636e\u672a\u5ba1\u6838\u65e0\u6cd5\u5b8c\u6210!"});
        }
        queryCheckPlan.setStatus("2");
        queryCheckPlan.setCompletionDate(new Date());
        boolean update = this.checkPlanServic.updateCheckPlanById(queryCheckPlan);
        if (!update) {
            throw new EfutureException(Code.CODE_70037.getRespBase(new Object[]{"\u76d8\u70b9\u8ba1\u5212\u5b8c\u6210\u9519\u8bef"}));
        }
        CheckHeadModel checkHeadModel = new CheckHeadModel().setCheckDate(new Date()).setChecker(queryCheckPlan.getChecker());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"checkPlanId", (Object)queryCheckPlan.getId());
        this.checkHeadService.updateCheckHead(checkHeadModel, (Wrapper)queryWrapper);
        return new RespBase(Code.SUCCESS, (Object)true);
    }

    public RespBase<List<CheckPlanModel>> queryCheckPlanListTimeLow(ServiceSession session, CheckPlanModelVO inVo) {
        if (null == inVo.getCheckDate()) {
            return Code.CODE_70013.getRespBase(new Object[]{"\u76d8\u70b9\u65f6\u95f4"});
        }
        inVo.setStatus("1");
        List list = this.checkPlanServic.queryCheckPlan(inVo);
        return new RespBase(Code.SUCCESS, (Object)list);
    }

    public RespBase<CheckHeadModel> saveCheckHead(ServiceSession session, CheckHeadModel inVo) {
        inVo.setBillno(RandomNum.getTime() + RandomNum.generateString((int)5)).setId(ReflectUtils.getUUID()).setBillDate(new Date());
        String errorMessage = ReflectUtils.checkParam((Object)inVo);
        if (!StringUtils.isEmpty((String)errorMessage)) {
            return Code.CODE_70013.getRespBase(new Object[]{errorMessage});
        }
        boolean save = this.checkHeadService.saveCheckHead(inVo);
        if (!save) {
            throw new EfutureException(Code.CODE_70037.getRespBase(new Object[]{"\u76d8\u70b9\u5355\u6dfb\u52a0\u9519\u8bef"}));
        }
        return new RespBase(Code.SUCCESS, (Object)inVo);
    }

    public RespBase<IPage<List<CheckPlanHeadModel>>> queryCheckHead(ServiceSession session, CheckHeadPageVO inVo) {
        IPage list = this.checkHeadService.queryCheckPlanHeadList(inVo);
        return new RespBase(Code.SUCCESS, (Object)list);
    }

    public RespBase<Boolean> saveCheckDetail(ServiceSession session, CheckDetailVO inVo) {
        if (StringUtils.isEmpty((String)inVo.getCheckPlanId())) {
            return Code.CODE_70013.getRespBase(new Object[]{"\u76d8\u70b9\u8ba1\u5212id"});
        }
        List checkDetailModelList = inVo.getCheckDetailModelList();
        for (CheckDetailModel checkDetailModel : checkDetailModelList) {
            String errorMessage = ReflectUtils.checkParam((Object)checkDetailModel);
            if (!StringUtils.isEmpty((String)errorMessage)) {
                return Code.CODE_70013.getRespBase(new Object[]{errorMessage});
            }
            if (!"N".equals(inVo.getCheckBarNo())) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("checkPlanId", inVo.getCheckPlanId());
                map.put("barNo", checkDetailModel.getBarNo());
                List list = this.checkDetaiService.queryCheckDetailId(map);
                if (!ArrayUtils.isEmpty((List)list)) {
                    return Code.CODE_70038.getRespBase(new Object[]{"\u5546\u54c1\u7f16\u7801\u3010" + checkDetailModel.getBarNo() + "\u3011\u5df2\u5b58\u5728\u5176\u4ed6\u76d8\u70b9\u5355\u662f\u5426\u8865\u5f55!"});
                }
            }
            checkDetailModel.setId(ReflectUtils.getUUID());
        }
        boolean save = this.checkDetaiService.saveBatch((Collection)inVo.getCheckDetailModelList(), "checkdetail");
        if (!save) {
            throw new EfutureException(Code.CODE_70037.getRespBase(new Object[]{"\u76d8\u70b9\u5546\u54c1\u6dfb\u52a0\u9519\u8bef"}));
        }
        return new RespBase(Code.SUCCESS, (Object)true);
    }

    public RespBase<IPage<List<CheckDetailModel>>> queryCheckDetail(ServiceSession session, CheckDetailPageVO inVo) {
        IPage list = this.checkDetaiService.queryCheckDetail(inVo);
        return new RespBase(Code.SUCCESS, (Object)list);
    }

    public RespBase<CheckDetailModel> updateCheckDetailById(ServiceSession session, CheckDetailModel inVo) {
        if (StringUtils.isEmpty((String)inVo.getId())) {
            return Code.CODE_70013.getRespBase(new Object[]{"\u4e3b\u952eid"});
        }
        if (null == inVo.getQty() || 0.0 > inVo.getQty()) {
            this.checkDetaiService.deleteCheckDetailById(inVo);
            return new RespBase(Code.SUCCESS, (Object)inVo);
        }
        boolean update = this.checkDetaiService.updateCheckDetailById(inVo);
        if (!update) {
            throw new EfutureException(Code.CODE_70037.getRespBase(new Object[]{"\u4fee\u6539\u76d8\u70b9\u5546\u54c1\u9519\u8bef"}));
        }
        return new RespBase(Code.SUCCESS, (Object)inVo);
    }

    public RespBase<CheckPlanHeadModel> queryCheckDetailById(ServiceSession session, CheckDetailPageVO checkDetailPageVO) {
        if (StringUtils.isEmpty((String)checkDetailPageVO.getCheckHeadId())) {
            return Code.CODE_70013.getRespBase(new Object[]{"\u76d8\u70b9\u5355\u636eid"});
        }
        CheckHeadPageVO checkHeadModel = new CheckHeadPageVO();
        checkHeadModel.setId(checkDetailPageVO.getCheckHeadId());
        IPage list = this.checkHeadService.queryCheckPlanHeadList(checkHeadModel);
        if (ArrayUtils.isEmpty((List)list.getRecords())) {
            return new RespBase(Code.SUCCESS, (Object)new CheckPlanHeadModel());
        }
        CheckPlanHeadModel checkPlanHeadModel = (CheckPlanHeadModel)list.getRecords().get(0);
        CheckDetailPageVO checkDetailModel = new CheckDetailPageVO();
        checkDetailModel.setCheckHeadId(checkPlanHeadModel.getId());
        checkDetailModel.setPageSize(checkDetailPageVO.getPageSize());
        checkDetailModel.setPageCurrent(checkDetailPageVO.getPageCurrent());
        RespBase checkDetailModelList = this.queryCheckDetail(session, checkDetailModel);
        if (Code.SUCCESS.getIndex() != checkDetailModelList.getRetflag()) {
            return new RespBase(checkDetailModelList.getRetflag(), checkDetailModelList.getRetmsg());
        }
        checkPlanHeadModel.setCheckDetailModelList((IPage)checkDetailModelList.getData());
        return new RespBase(Code.SUCCESS, (Object)checkPlanHeadModel);
    }
}

