package com.efuture.business.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;


@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("operuser")
public class OperUserModel {

	private static final long serialVersionUID = 1L;

	/**
	 * 员工卡号
	 */
	private String cardno;
	/**
	 * 工号
	 */
	private String gh;
	/**
	 * 姓名
	 */
	private String name;
	/**
	 * 密码
	 */
	private String passwd;
	/**
	 * 门店号
	 */
	private String mkt;
	/**
	 * 经营公司
	 */
	@TableField("erpCode")
	private String erpCode;
	/**
	 * 密码标识
	 */
	private String passwdflg;
	/**
	 * 员工类别，1-收银员，2-营业员，3-维护员，4-授权员工
	 */
	private String ghtype;
	/**
	 * 卡号类型(1-临时卡,0-正常卡)
	 */
	private String cardtype;
	/**
	 * 有效期
	 */
	private Date maxdate;
	/**
	 * 是否允许登录pos（y/n）
	 */
	private String isloginpos;
	/**
	 * 是否允许登录erp（y/n）
	 */
	private String isloginerp;
	/**
	 * pos角色
	 */
	private String posrole;
	/**
	 * 永旺专用 level=1,2对应经理（manager),3,8对应主管（supervisor),4对应收银员(cashier)
	 */
	private Long level;
	/**
	 * erp角色
	 */
	private String erprole;
	/**
	 * 营业员营业柜组
	 */
	private String yyygz;
	/**
	 * 备注
	 */
	private String memo;
	private Long phKey;
	/**
	 * 删除状态标记
	 */
	private String statu;
	private Long phTimestamp;
	/**
	 * 渠道id
	 */
	@TableField("entId")
	private Long entId;
	/**
	 * 时间戳
	 */
	private Long tmdd;
	/**
	 * 员工工号
	 */
	private String employeeno;
	/**
	 * 修改密码时间
	 */
	private Date pwddate;
	@TableField("updateDate")
	private Date updateDate;
	/**
	 * 授权角色
	 */
	private String authrole;
	/**
	 * 每日随机码。每天日结时更新
	 */
//	@TableField("randomCode")
//	private String randomCode;
	/**
	 * 序列号(用户同步使用)
	 */
//	@TableField("seqNum")
//	private Long seqNum;
}