package com.efuture.business.service.impl;

import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.mapper.CashierMoneyRecordExtMapper;
import com.efuture.business.model.CashierMoneyRecordModel;
import com.efuture.business.service.CashierMoneyRecordExtService;
import com.efuture.business.util.db.DbTools;
import com.efuture.business.util.db.MultipleDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CashierMoneyRecordExtServiceImpl extends FunctionBaseServiceImpl<CashierMoneyRecordExtMapper, CashierMoneyRecordModel> implements CashierMoneyRecordExtService {
    @Autowired
    private DbTools dbTools;
    @Override
    public boolean updateCashierMoneyRecord(CashierMoneyRecordModel model) {
        if ("Y".equals(GlobalInfo.centrally) && model.getMkt()!=null) {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("cashiermoneyrecord", model.getMkt()));
        } else {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("cashiermoneyrecord"));
        }
        return this.updateCashierMoneyRecord(model);
    }
}
