package com.efuture.business.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.service.FunctionBaseService;
import com.efuture.business.util.db.DbTools;
import com.efuture.business.util.db.MultipleDataSource;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Map;

public class FunctionBaseServiceImpl<M extends BaseMapper<T>, T> extends  ServiceImpl<M, T> implements FunctionBaseService<T> {
    @Autowired
    private DbTools dbTools;

    @Override
    public List<T> listByMap(Map<String, Object> columnMap,String tableName){
        if ("Y".equals(GlobalInfo.centrally) && columnMap.containsKey("mkt")) {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc(tableName, columnMap.get("mkt").toString()));
        } else {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc(tableName));
        }

        return getBaseMapper().selectByMap(columnMap);
    }

    @Override
    public List<T> list(Wrapper<T> queryWrapper, String tableName) {

        MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc(tableName));

        return getBaseMapper().selectList(queryWrapper);
    }
}
