package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.efuture.business.annotation.HessianService;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.constant.FunctionSoaUrl;
import com.efuture.business.constant.InitializeSoaUrl;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.OperUser;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.posManager.request.OperUserIn;
import com.efuture.business.javaPos.struct.posManager.response.OperUserOut;
import com.efuture.business.javaPos.struct.request.FindGhIn;
import com.efuture.business.model.PosWorkAcountModel;
import com.efuture.business.model.PosWorkLogModel;
import com.efuture.business.service.FunctionRemoteService;
import com.efuture.business.service.InitializationRemoteService;
import com.efuture.business.util.ReflectUtils;
import com.efuture.business.util.UniqueID;
import com.efuture.business.vo.FindOperUserInVo;
import com.product.exception.ServiceRuntimeException;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Slf4j
@HessianService(value = FunctionSoaUrl.FUNCTION_SERVICE_URL, interf = FunctionRemoteService.class)
@Service
public class FunctionRemoteServiceImpl implements FunctionRemoteService {
    //private static Logger log = LoggerFactory.getLogger(FunctionRemoteServiceImpl.class);
    @SoaAnnotation(value = InitializeSoaUrl.INITIALIZE_SERVICE_URL)
    private InitializationRemoteService initializationRemoteService;

    @Autowired
    private SyjMainExpServiceImpl syjMainServiceImpl;

    @Autowired
    private SyjCashLogServiceImpl syjCashLogService;

    @Autowired
    private PosWorkLogServiceImpl posWorkLogService;

    @Autowired
    private PosWorkAcountServiceImpl posWorkAcountService;

    @Autowired
    private OperUserExpServiceImpl operUserExpService;


    @Override
    public RespBase getOperUser(ServiceSession session, FindOperUserInVo inVo) {
        log.debug("授权request==>{}",JSONObject.toJSON(inVo));
        String nullParam =  ReflectUtils.checkNotNull(inVo);

        if(StringUtils.isNotBlank(nullParam)){
            return Code.CODE_100001.getRespBase(nullParam);
        }

        // 根据卡号字段判断调用的接口
        if (inVo.getType() == 0 && StringUtils.isBlank(inVo.getCardNo())) {
            log.info("工号授权");
            return getGh(session, inVo);
        }

        CacheModel cacheModel = inVo.getCacheModel();
        Order order = null;

        if (inVo.getType() == 1 && StringUtils.isBlank(inVo.getCardNo())) {

//            cacheModel = cacheModelService.getCacheModelByFlowNo(inVo.getFlowNo());
            // 检验缓存是否获取成功
//            if (cacheModel == null)
//                return ServiceResponse.buildFailure(session, PosReturnCode.RESPONSE_FAILURE,
//                        "订单[{0}]已失效，请重新生成订单!", inVo.getFlowNo());

            cacheModel.setCurYyyInfo(new OperUser());

//            cacheModelService.saveOrUpdateCacheModel(cacheModel);

            // 返回会员信息
            return new RespBase(Code.SUCCESS,cacheModel);
        }

        // 订单中授权
        if (StringUtils.isNotBlank(inVo.getFlowNo())) {

            if (inVo.getType() == 0 && !"Y".equals(inVo.getIsAllowSelf())
                    && (inVo.getCardNo().equals(cacheModel.getOrder().getTerminalOperator())
//                    || inVo.getCardNo().equals(cacheModel.getOrder().getScanGoodOperator())
            )) {
               return Code.CODE_100026.getRespBase();
            }
            // 获取order
            order = cacheModel.getOrder();
            // 检验order
            if (order == null) {
                return Code.CODE_100025.getRespBase();
            }
            // 将entId放进session中
            session.setEnt_id(order.getEntId());
            inVo.setErpCode(order.getErpCode());
        }

        // 转换为授权认证接口的入参bean
        OperUserIn posManagerOperUserIn = new OperUserIn();
        posManagerOperUserIn.setCardno(inVo.getCardNo());
        posManagerOperUserIn.setMkt(inVo.getShopCode());
        posManagerOperUserIn.setErpCode(inVo.getErpCode());
        posManagerOperUserIn.setSyjh(inVo.getTerminalNo());
        posManagerOperUserIn.setRandomCode(inVo.getAuthCode());

        if (0 == inVo.getType()) {
            posManagerOperUserIn.setFlag("Y");
        } else if (1 == inVo.getType()) {
            posManagerOperUserIn.setFlag("N");
        }
        // flag = N 收银 Y 授权
        JSONObject response = initializationRemoteService.empower(session,posManagerOperUserIn);

        if(null == response){

            return Code.CODE_100023.getRespBase("收银员或授权人员信息");
        }
        OperUserOut posManagerOperUserOut = JSONObject.parseObject(response.toJSONString(), OperUserOut.class);

        if (null == posManagerOperUserOut.getOperuser()
                || org.apache.commons.lang.StringUtils.isBlank(posManagerOperUserOut.getOperuser().getCardno())) {
            return Code.CODE_100023.getRespBase("当前人员信息");
        }
        if (!"Y".equals(inVo.getIsBasic())) {
            if (null == posManagerOperUserOut.getPosrole()) {
//                return ServiceResponse.buildFailure(session, PosReturnCode.RESPONSE_FAILURE,
//                        "该人员没有对应角色信息");
                return Code.CODE_100023.getRespBase("当前人员角色信息");
            }

            if (0 == inVo.getType()
                    && !"Y".equals(posManagerOperUserOut.getPosrole().getIsgrant())) {
                return Code.CODE_100028.getRespBase();
//                return ServiceResponse.buildFailure(session, PosReturnCode.RESPONSE_FAILURE, "该人员没有授权权限");
            }

            if (1 == inVo.getType()
                    && !"2".equals(posManagerOperUserOut.getOperuser().getGhtype())) {
//                return ServiceResponse.buildFailure(session, PosReturnCode.RESPONSE_FAILURE, "该人员非营业员");
                return Code.CODE_100031.getRespBase();
            }
        }
        OperUser operUser = new OperUser(posManagerOperUserOut);

        if (null != cacheModel) {
            if (0 == inVo.getType()) {
                if (!"Y".equals(inVo.getIsAllowSelf())
                        && (operUser.getGh().equals(cacheModel.getOrder().getTerminalOperator())
//                        || operUser.getGh().equals(cacheModel.getOrder().getScanGoodOperator())
                )) {
//                    return ServiceResponse.buildFailure(session, PosReturnCode.REFUSE_GRANT, "自己不能给自己授权");
                    return Code.CODE_100029.getRespBase();
                }
                if (!cacheModel.getIsGrant()) {
                    cacheModel.setCurTempGrant(cacheModel.getCurGrant());
                    cacheModel.setIsGrant(true);
                }
                cacheModel.setCurGrant(operUser);
            } else if (1 == inVo.getType()) {
                cacheModel.setCurYyyInfo(operUser);
            }

//             order.setTerminalOperatorAuthzCardNo(operUser.getGh());
//            cacheModelService.saveOrUpdateCacheModel(cacheModel, true);
        }

//        FindOperUserOut OperUserOut = new FindOperUserOut(operUser);
        // 返回会员信息
        return new RespBase(Code.SUCCESS,cacheModel);
    }




    /**
     * 接收操作日志
     * @param session
     * @param paramsObject
     * @return
     */
    @Override
    public RespBase posWorkLog(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        if (paramsObject.containsKey("delOrder")) {// 清除整单特殊处理

            JSONObject result = new JSONObject();
            JSONArray deailResult = new JSONArray();
            JSONObject allResult = null;

            JSONArray delOrders = paramsObject.getJSONArray("delOrder");
            Double allAmount = 0.0;
            for (int i = 0; i < delOrders.size(); i++) {
                PosWorkAcountModel delOrder = (PosWorkAcountModel) delOrders.get(i);

                delOrder.setLogtype("24_detail");
                delOrder.setRqsj(new Date());
                boolean issaved = posWorkAcountService.save(delOrder);

                if(issaved==false){
                    return  new RespBase(-1,"保存posworkacount失败！");
                }
                deailResult.add(delOrder);

                Double amount = delOrder.getAmount();
                allAmount = ManipulatePrecision.add(allAmount, amount);
                if (i == delOrders.size() - 1) {
                    if (!paramsObject.containsKey("delAllOrder")) {
                        PosWorkAcountModel allDelOder = new PosWorkAcountModel();
                        allDelOder.setRqsj(new Date());
                        allDelOder.setMkt(delOrder.getMkt());
                        allDelOder.setErpCode(delOrder.getErpCode());
                        allDelOder.setSyjh(delOrder.getSyjh());
                        allDelOder.setSyyh(delOrder.getSyyh());
                        allDelOder.setRowno(delOrder.getRowno());
                        allDelOder.setBillno(delOrder.getBillno());
                        allDelOder.setLogdesc(delOrder.getLogdesc());
                        allDelOder.setAuthorizeGh(delOrder.getAuthorizeGh());
                        allDelOder.setLogtype("24");
                        allDelOder.setCount(1);
                        allDelOder.setAmount(allAmount);
                        boolean issaved2 = posWorkAcountService.save(allDelOder);
                        if(issaved2==false){
                            return  new RespBase(-1,"保存posworkacount失败！");
                        }
                        allResult = (JSONObject) JSON.toJSON(allDelOder);

                        PosWorkLogModel workLogModel = new PosWorkLogModel();
                        workLogModel.setRqsj(allDelOder.getRqsj());
                        workLogModel.setMkt(allDelOder.getMkt());
                        workLogModel.setErpCode(allDelOder.getErpCode());
                        workLogModel.setSyjh(allDelOder.getSyjh());
                        workLogModel.setSyyh(allDelOder.getSyyh());
                        workLogModel.setRowno(allDelOder.getRowno());
                        workLogModel.setBillno(allDelOder.getBillno());
                        workLogModel.setLogdesc(allDelOder.getLogdesc());
                        workLogModel.setLogtype(allDelOder.getLogtype());

                        posWorkLogService.saveEntity(workLogModel);// 为了web端统计，记录冗余数据
                    } else {
                        // 重复调用时，汇总从参数中获取。避免主键重复
                        posWorkAcountService.save((PosWorkAcountModel) paramsObject.get("delAllOrder"));
                        posWorkLogService.saveEntity((PosWorkLogModel) paramsObject.get("delAllOrder"));
                    }
                }
            }

            result.put("delOrder", deailResult);
            result.put("delAllOrder", allResult);
            result.put("localRepeatLog", "y");
            ResqVo resqVo = ResqVo.buildReqVo(null,result);

            return new RespBase(Code.SUCCESS,resqVo,"SENDLOGCERTIFY");
        } else {
            // 校验必填参数
            if (!paramsObject.containsKey("syjh")) {
                return  new RespBase(-1,"参数缺少收银机号,请检查参数!");
            }
            if (!paramsObject.containsKey("logtype")) {
                return  new RespBase(-1,"参数缺少操作日志类型,请检查参数!");
            }
            if (!paramsObject.containsKey("mkt")) {
                return  new RespBase(-1,"参数缺少门店编码,请检查参数!");
            }
            if (!paramsObject.containsKey("erpCode")) {
                return  new RespBase(-1,"参数缺少经营公司编码,请检查参数!");
            }

            PosWorkLogModel workLogModel = new PosWorkLogModel();
            workLogModel.setRqsj(new Date());
            workLogModel.setSyjh(paramsObject.getString("syjh"));
            workLogModel.setLogtype(paramsObject.getString("logtype"));
            workLogModel.setMkt(paramsObject.getString("mkt"));
            workLogModel.setErpCode(paramsObject.getString("erpCode"));
            workLogModel.setRowno(paramsObject.getString("rowno"));

            PosWorkAcountModel workAcountModel = new PosWorkAcountModel();
            workAcountModel.setRqsj(new Date());
            workAcountModel.setSyjh(paramsObject.getString("syjh"));
            workAcountModel.setLogtype(paramsObject.getString("logtype"));
            workAcountModel.setMkt(paramsObject.getString("mkt"));
            workAcountModel.setErpCode(paramsObject.getString("erpCode"));
            workAcountModel.setRowno(paramsObject.getString("rowno"));

            String logtype = paramsObject.getString("logtype");
            boolean needAcount = "17".equals(logtype) || "18".equals(logtype) || "20".equals(logtype)
                    || "23".equals(logtype) || "24".equals(logtype) || "34".equals(logtype) || "35".equals(logtype)
                    || "38".equals(logtype) || "39".equals(logtype) || "40".equals(logtype) || "41".equals(logtype)
                    || "42".equals(logtype) || "43".equals(logtype) || "45".equals(logtype);

            if (needAcount) {

                if ("18".equals(logtype)) {
                    String rowno = paramsObject.getString("rowno");
                    // 查询出rowno对应的(日期最大的)挂单记录, 将挂单主键记录到解挂batchNo字段中
                    Long phkey = this.getPhkey(session, paramsObject);
//                    workLogModel.setPendBillId(phkey);
                    workAcountModel.setPendBillId(phkey);

                    boolean issaved = posWorkAcountService.save(workAcountModel);
                    posWorkLogService.saveEntity(workLogModel);// 为了web端统计，记录冗余数据

                    return new RespBase(Code.SUCCESS,null,"SENDLOGCERTIFY");
                }

                //批量删除挂单
                if ("20".equals(logtype)) {
                    String rowno = paramsObject.getString("rowno");
                    workLogModel.setRowno(null);
                    workAcountModel.setRowno(null);

                    posWorkAcountService.save(workAcountModel);
                    posWorkLogService.saveEntity(workLogModel);

                    String[] arr=rowno.split(",");
                    for(int i=0;i<arr.length;i++){
                        workLogModel.setRowno(arr[i]);
                        workLogModel.setPh_key(UniqueID.getUniqueID());
                        workLogModel.setLogtype("20_detail");

                        workAcountModel.setRowno(arr[i]);
                        workAcountModel.setPh_key(UniqueID.getUniqueID());
                        workAcountModel.setLogtype("20_detail");
                        workAcountModel.setCount(1);

                        paramsObject.put("rowno",arr[i]);
                        paramsObject.put("ph_key", UniqueID.getUniqueID());
                        paramsObject.put("count",1);
                        paramsObject.put("logtype","20_detail");
                        posWorkAcountService.save(workAcountModel);
                        posWorkLogService.saveEntity(workLogModel);
                    }
                    return new RespBase(Code.SUCCESS,null,"SENDLOGCERTIFY");
                }

                // 删除单品将posId放到billno中 TODO 后续没用则删除
//				if (logtype.equals("23")){
//					paramsObject.put("rowno",paramsObject.getString("posId"));
//				}

                posWorkAcountService.save(workAcountModel);
                posWorkLogService.saveEntity(workLogModel);
                return new RespBase(Code.SUCCESS,null,"SENDLOGCERTIFY");
            }
            posWorkLogService.saveEntity(workLogModel);
            return new RespBase(Code.SUCCESS,null,"SENDLOGCERTIFY");
        }
    }

    /**
     * 授权
     *
     * @param session
     * @param inVo
     * @return
     */
    public RespBase getGh(ServiceSession session, FindOperUserInVo inVo) {

        CacheModel cacheModel = null;
        Order order = null;

        if (StringUtils.isNotBlank(inVo.getFlowNo())) {
            // 获取缓存
            cacheModel = inVo.getCacheModel();
//            // 检验缓存是否获取成功
//            if (cacheModel == null)
//                return ServiceResponse.buildFailure(session, PosReturnCode.RESPONSE_FAILURE,
//                        "订单[{0}]已失效，请重新生成订单!", ghIn.getFlowNo());

//            if ("Y".equals(inVo.getIsAllowSelf())
//                    && inVo.getGh().equals(cacheModel.getOrder().getGh())) {
////                return ServiceResponse.buildFailure(session, PosReturnCode.REFUSE_GRANT, "自己不能给自己授权");
//                  return Code.CODE_100024.getRespBase();
//            }

            // 获取order
            order = cacheModel.getOrder();
            // 检验order
            if (order == null) {
//                return ServiceResponse.buildFailure(session, PosReturnCode.RESPONSE_FAILURE, "订单主体不能为空！");
                return Code.CODE_100025.getRespBase();
            }
            // 将entId放进session中
            session.setEnt_id(order.getEntId());
            inVo.setErpCode(order.getErpCode());
        }

        // 转换为授权认证接口的入参bean
//        inVo.setMkt(ghIn.getShopCode());

        inVo.setRandomCode(inVo.getAuthCode());
        if (null == inVo.getPasswd()) {
            inVo.setPasswd("");
        }
//        ServiceResponse response = posManagerService.getGh(restTemplate, session, ghIn);
        FindGhIn findGhIn =new FindGhIn();
        findGhIn = JSONObject.parseObject(JSONObject.toJSONString(inVo),FindGhIn.class);
        findGhIn.setMkt(inVo.getShopCode());
        RespBase response = initializationRemoteService.checkAndGetGh(session,findGhIn);
        log.debug("initializationRemoteService.checkAndGetGh response=>{}",JSONObject.toJSON(response));
        if (0==response.getRetflag()) {
            // 接口返回数据CrminfoAuthOut转换为MemberLoginOut
            JSONObject responseData =  (JSONObject) response.getData();
//            OperUserOut posManagerOperUserOut = (OperUserOut) response.getData();
            OperUserOut posManagerOperUserOut = JSONObject.parseObject(responseData.toJSONString(),OperUserOut.class);

            if (responseData.getJSONObject("operuser").getString("cardno").length()==0) {
//                return ServiceResponse.buildFailure(session, PosReturnCode.RESPONSE_FAILURE, "该人员信息无法找到");
                return Code.CODE_100027.getRespBase();
            }
            JSONObject posrole = responseData.getJSONObject("posrole");
            if (!"Y".equals(findGhIn.getIsBasic())) {
                if (null == posrole) {
//                    return ServiceResponse.buildFailure(session, PosReturnCode.RESPONSE_FAILURE, "该人员没有授权权限");
                    log.debug("授权失败:该人员没有授权权限");
                    return  Code.CODE_100028.getRespBase();
                }
                if (0 == findGhIn.getType() && !"Y".equals(posrole.getString("isgrant"))) {
//                    return ServiceResponse.buildFailure(session, PosReturnCode.RESPONSE_FAILURE, "该人员没有授权权限");
                    log.debug("授权失败:该人员没有授权权限!!!!!");
                    return  Code.CODE_100028.getRespBase();
                }

                if (1 == findGhIn.getType() && !"2".equals(responseData.getJSONObject("operuser").getString("ghtype"))) {
                    log.debug("授权失败:该人员非营业员");
                    return Code.CODE_100028.getRespBase();
                }
            }
           OperUser operUser = new OperUser(posManagerOperUserOut);

            if (null != cacheModel) {
                if (!"Y".equals(findGhIn.getIsAllowSelf())
                        && (operUser.getCardno().equals(cacheModel.getOrder().getTerminalOperator())
                )) {
                    return Code.CODE_100029.getRespBase();
                }
                if (!cacheModel.getIsGrant()) {
                    cacheModel.setIsGrant(true);
                    cacheModel.setCurTempGrant(cacheModel.getCurGrant());
                }
                cacheModel.setCurGrant(operUser);
            }
            else
            {
                 cacheModel = new CacheModel();
                 cacheModel.setCurGrant(operUser);
            }
            // 返回会员信息
            return new RespBase(Code.SUCCESS,cacheModel);
        } else {
            return response;
        }
    }



    /**
     * 更新收银机状态
     * @param session
     * @param jsonObject
     * @return
     * @throws Exception
     */
    @Override
    public RespBase update(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        try {
            ServiceResponse response = syjMainServiceImpl.update(session,jsonObject);
            if("0".equals(response.getReturncode())){
                return new RespBase(Code.SUCCESS,response.getData(),"UPDATECASHIERSTATUSCERTIFY");
            }else {
                return Code.FAIL.getRespBase(response.getReturncode(), response.getData());
            }
        }catch (Exception e){
            log.error(e.getMessage(),e);
            return Code.FAIL.getRespBase("-1", e.getMessage());
        }

    }



    // 获取主键
    private long getPhkeyByAcountResp(ServiceResponse resp) {
        JSONObject d = (JSONObject) resp.getData();
        return d.getLong("ph_key");
    }

    public Long getPhkey(ServiceSession session, JSONObject paramsObject){
        List<PosWorkAcountModel> posWorkAcountModels = new ArrayList<>();
        QueryWrapper<PosWorkAcountModel> pwaqueryWrapper = new QueryWrapper<>();
        pwaqueryWrapper.eq("rowno",paramsObject.get("rowno"))
                    .eq("logtype","17")
                    .eq("erpCode",paramsObject.getString("erpCode"))
                    .eq("order_field","rqsj")
                    .eq("order_direction","desc");
        posWorkAcountModels = posWorkAcountService.list(pwaqueryWrapper);
        if(posWorkAcountModels.size()!=0){
            PosWorkAcountModel posWorkAcount= posWorkAcountModels.get(0);
            return posWorkAcount.getPh_key();
        }
        /*if (ResponseCode.SUCCESS.equals(onQuery.getReturncode())) {
            JSONObject data = (JSONObject) onQuery.getData();
            JSONArray jsonArray = data.getJSONArray(posWorkAcountService.getCollectionName());
            if (null != jsonArray && !jsonArray.isEmpty()) {
                JSONObject jsonObject = jsonArray.getJSONObject(0);
                return jsonObject.getString("ph_key");
            }
        }*/
        throw new ServiceRuntimeException("查询挂单信息失败,流水号:" + paramsObject.get("rowno") + "请检查数据!");
    }



    @Override
    public RespBase doUpdate(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        try {
            ServiceResponse response = syjMainServiceImpl.doUpdate(session,jsonObject);
            if("0".equals(response.getReturncode())){
                return new RespBase(Code.SUCCESS,response.getData(),"PREMONEYCERTIFY");
            }else {
                return Code.FAIL.getRespBase(response.getReturncode(), response.getData());
            }
        }catch (Exception e){
            log.error(e.getMessage(),e);
            return Code.FAIL.getRespBase("-1", e.getMessage());
        }

    }

    /**
     * 登出接口
     *
     * @param session
     * @param paramsObject {mkt syjh}
     * @return
     * @throws Exception
     */
    @Override
    public RespBase syjLoginOut(ServiceSession session,ResqVo vo,JSONObject paramsObject){
    try{
        // 0-收银员登出 1-扫描员登出 默认收银员登出
        if (!paramsObject.containsKey("empLoginType")) {
            paramsObject.put("empLoginType", "0");
        }
        String empLoginType = paramsObject.getString("empLoginType");
        if (!empLoginType.equals("0") && !empLoginType.equals("1")) {
            return new RespBase(-1,"登陆类型错误");
        }

        if (empLoginType.equals("0")) {
            // 收银员登出
            ServiceResponse response = syjMainServiceImpl.syyLoginOut(session, paramsObject);
            if(response.getReturncode().equals("0")){
                return new RespBase(Code.SUCCESS,response.getData(),"SYJLOGOUT");
            }else {
                return new RespBase(-1,"收银员登出报错");
            }

        } else if (empLoginType.equals("1")) {
            // 扫描员登出
            ServiceResponse response = syjMainServiceImpl.smyLoginOut(session, paramsObject);;
            if(response.getReturncode().equals("0")){
                return new RespBase(Code.SUCCESS,response.getData(),"SYJLOGOUT");
            }else {
                return new RespBase(-1,"扫描员登出报错");
            }
        } else {
            return new RespBase(-1,"登陆类型错误");
        }
    }catch (Exception e){
        log.error(e.getMessage(),e);
        return Code.FAIL.getRespBase("-1", e.getMessage());
    }

    }




    @Override
    public String getClearTime(String erpCode, String mkt, String syjh) {
        return syjMainServiceImpl.getClearTime(null,erpCode,mkt,syjh);
    }

    /**
     * 修改密码
     *
     * @param session
     * @param paramsObject
     * @return
     * @throws Exception
     */
    @Override
    public RespBase changePassword(ServiceSession session, JSONObject paramsObject) {
        try {
            ServiceResponse response = operUserExpService.changePassword(session,paramsObject);
            if("0".equals(response.getReturncode())){
                return new RespBase(Code.SUCCESS,response.getData(),"CHANGEPASSWORD");
            }else {
                return new RespBase(Code.FAIL,response.getData(),"CHANGEPASSWORD");
            }
        }catch (Exception e){
            log.error(e.getMessage(),e);
            return Code.FAIL.getRespBase("-1", e.getMessage());
        }
    }

    /**
     * 收银机解锁（针对收银员离开后重新进入收银机）
     *
     * @param session
     * @param paramsObject {mkt syjh}
     * @return
     * @throws Exception
     */
    @Override
    public RespBase posUnlock(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        try {
            // 收银员解锁
            RespBase response = syjMainServiceImpl.posUnlock(session, paramsObject);
            if (response.getRetflag() == 0) {
                return new RespBase(Code.SUCCESS, response.getData(), "SYJUNLOCK");
            } else {
                return new RespBase(Code.CODE_70015, response.getRetmsg());
            }
        }catch (Exception e){
            log.error(e.getMessage(),e);
            return Code.CODE_70015.getRespBase();
        }
    }

    /**
     * 收银机关机
     *
     * @param session
     * @param paramsObject {mkt syjh}
     * @return
     * @throws Exception
     */
    @Override
    public RespBase syjClose(ServiceSession session,ResqVo vo, JSONObject paramsObject){
    try{
        RespBase response = syjMainServiceImpl.syjClose(session, paramsObject);
        if(response.getRetflag()==0){
            return new RespBase(Code.SUCCESS,response.getData(),"POSCLOSE");
        }else {
            return new RespBase(-1,response.getRetmsg());
        }
    }catch (Exception e){
        log.error(e.getMessage(),e);
        return Code.FAIL.getRespBase("-1", e.getMessage());
    }
    }




}
