package com.efuture.business.service.impl;


import com.efuture.business.util.MD5Util;
import com.product.util.ParamValidateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.mapper.OperUserModelMapper;
import com.efuture.business.model.OperUserModel;
import com.efuture.business.service.OperUserExpService;
import com.efuture.business.util.db.DbTools;
import com.efuture.business.util.db.MultipleDataSource;
import com.product.model.ResponseCode;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.text.SimpleDateFormat;
import java.util.*;

@Service
public class OperUserExpServiceImpl extends FunctionBaseServiceImpl<OperUserModelMapper, OperUserModel> implements OperUserExpService {
	private static final Logger logger = LoggerFactory.getLogger(OperUserExpServiceImpl.class);
	@Autowired
	private DbTools dbTools;

	public boolean getOperRange(ServiceSession session, JSONObject paramsObject) {
		logger.info("getOperRange"+paramsObject.toJSONString());
		// 必须字段检查
		if (org.springframework.util.StringUtils.isEmpty(paramsObject.getString("mkt"))) {
			return false;
		}
		if (org.springframework.util.StringUtils.isEmpty(paramsObject.getString("syjh"))) {
			return false;
		}
		if (org.springframework.util.StringUtils.isEmpty(paramsObject.getString("erpCode"))) {
			return false;
		}
		if (org.springframework.util.StringUtils.isEmpty(paramsObject.getString("syjcursyyh"))) {
			return false;
		}
		List<Map> list = getOperRangeByGH(paramsObject);
		logger.info("getOperRangeByGH===list"+JSONObject.toJSONString(list));
		for (int i = 0; i < list.size(); i++) {
			Map map = list.get(i);
			if ("Y".equals(map.get("operrange"))) {
				return true;
			}
		}
		return false;
	}

	public List<Map> getOperRangeByGH(JSONObject paramsObject){
		Map<String, Object> param = new HashMap<>();
		param.put("gh",paramsObject.getString("gh"));
		param.put("mkt",paramsObject.getString("shopCode"));
		param.put("erpCode",paramsObject.getString("erpCode"));
		if ("Y".equals(GlobalInfo.centrally) && paramsObject.getString("shopCode")!=null) {
			MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("operuser", paramsObject.getString("shopCode")));
		} else {
			MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("operuser"));
		}
		List<Map> list = this.baseMapper.getOperRangeByGH(param);
		return list;
	}

	public ServiceResponse checkPasswd(ServiceSession session, JSONObject paramsObject) {
		// 首先判断2个密码是否相同
		if (!Objects.equals(paramsObject.getString("newPassword"), paramsObject.getString("confirmPassword"))) {
			return ServiceResponse.buildFailure(session, ResponseCode.FAILURE, "新密码和确认密码不一致");
		}
		if (Objects.equals(paramsObject.getString("oldPassword"), paramsObject.getString("confirmPassword"))) {
			return ServiceResponse.buildFailure(session, ResponseCode.FAILURE, "新密码不能修改为原始密码");
		}
		List<OperUserModel> operusers = new ArrayList<>();

		List<Map> list = getOperRangeByGH(paramsObject);

		if (list.size()<=0) {
			return ServiceResponse.buildFailure(session, ResponseCode.FAILURE, "不存在此工号");
		}
		if (list != null && list.size() > 0) {
			JSONObject ob = new JSONObject();
			ob.put("gh",paramsObject.getString("gh"));
			ob.put("passwd", MD5Util.MD5(paramsObject.getString("oldPassword")));
			operusers = this.listByMap(ob,"operuser");
		}
		if (Objects.isNull(operusers) || operusers.isEmpty()) {
			return ServiceResponse.buildFailure(session, ResponseCode.FAILURE, "原始密码错误");
		}
		return ServiceResponse.buildSuccess("验证成功");
	}


	public ServiceResponse changePassword(ServiceSession session, JSONObject paramsObject) {
		boolean flag = true;
		logger.info("changePassword   "+JSONObject.toJSONString(paramsObject));
		ServiceResponse checkReponse = ParamValidateUtil.checkParam(session, paramsObject, "gh", "oldPassword", "newPassword",
				"confirmPassword");
		logger.info("changePassword  校验参数 "+JSONObject.toJSONString(checkReponse));
		if (!Objects.equals(ResponseCode.SUCCESS, checkReponse.getReturncode())) {
			return checkReponse;
		}
		ServiceResponse checkPasswdResponse = checkPasswd(session, paramsObject);
		logger.info("changePassword  校验密码 "+JSONObject.toJSONString(checkPasswdResponse));
		if (!Objects.equals(ResponseCode.SUCCESS, checkPasswdResponse.getReturncode())) {
			return checkPasswdResponse;
		}
		try {
//			if (routeMode.equals("2")) {
//				String url = environment.getProperty("pos.operuser.changePasswordIDC");
//				String resp = HttpUtils.onPost(url, session, paramsObject.toJSONString());
//				logger.info("收到响应报文="+resp);
//				if(resp==null || resp.equals("") ){
//					return ServiceResponse.buildFailure(session, ResponseCode.FAILURE, "调用IDC修改密码接收响应数据失败");
//				}
//				JSONObject response = JSONObject.parseObject(resp);
//				String retcode = response.getString(Constants.RESPONSE_RETURNCODE);
//				if (!Objects.equals(ResponseCode.SUCCESS, retcode)) {
//					String msg=response.getString(Constants.RESPONSE_DATA);
//					return ServiceResponse.buildFailure(session, ResponseCode.FAILURE, "更新IDC密码失败"+msg);
//				}
//			}
			ServiceResponse sr = changePassword2(session,paramsObject);
			logger.info("changePassword  修改密码 "+JSONObject.toJSONString(sr));
			return sr;
		} catch (Exception e) {
			return ServiceResponse.buildFailure(session, ResponseCode.EXCEPTION, e.getMessage());
		}
	}


	public ServiceResponse changePassword2(ServiceSession session, JSONObject paramsObject) {
		/**
		 * 修改operUser表的数据 传参 gh oldPassword newPassword confirmPassword 先在operuser中验证工号
		 * 密码。通过 先修改 pos总部，再 修改 用户中心， @param session  * @param paramsObject @return
		 * com.product.model.ServiceResponse @throws
		 */

		// 修改pos总部密码
		updatePwdByGh(paramsObject);
		return ServiceResponse.buildSuccess("修改成功");
	}

	private void updatePwdByGh(JSONObject paramsObject) {
		logger.info("updatePwdByGh===");
		JSONObject updateObjects = new JSONObject();
		updateObjects.put("gh", paramsObject.get("gh"));
		updateObjects.put("passwd", MD5Util.MD5(paramsObject.getString("newPassword")));
		updateObjects.put("pwddate", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
		updateObjects.put("updateDate", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
		if ("Y".equals(GlobalInfo.centrally) && paramsObject.getString("shopCode")!=null) {
			MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("operuser", paramsObject.getString("shopCode")));
		} else {
			MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("operuser"));
		}
		try {
			this.baseMapper.updateUserNameAndPasswd(updateObjects);
		}catch (Exception e){
			e.printStackTrace();
		}
		logger.info("updateUserNameAndPasswd");
	}

//	/*
//	 * 更新用户中心密码
//	 */
//	private void updateUserPwd(ServiceSession session, JSONObject paramsObject) {
//		String url = (String) environment.getProperty("usercenter.account.changePasswdByGH");
//		String response = HttpUtils.onPost(url, session, paramsObject.toJSONString());
//		if (Objects.isNull(response)) {
//			throw new RuntimeException("修改用户中心密码错误");
//		}
//		JSONObject resultSync = JSONObject.parseObject(response);
//		String retcode = resultSync.getString(Constants.RESPONSE_RETURNCODE);
//		if (!Objects.equals(ResponseCode.SUCCESS, retcode)) {
//			throw new RuntimeException("修改用户中心密码错误");
//		}
//	}
}