package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.efuture.business.annotation.HessianService;
import com.efuture.business.constant.FunctionSoaUrl;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.model.PosWorkAcountModel;
import com.efuture.business.service.PosWorkAcountRemoteService;
import com.product.model.ServiceSession;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.*;
@Slf4j
@HessianService(value = FunctionSoaUrl.POSWORKACOUNT_SERVICE_URL, interf = PosWorkAcountRemoteService.class)
@Service
public class PosWorkAcountRemoteServiceImpl implements PosWorkAcountRemoteService {

    @Autowired
    PosWorkAcountServiceImpl posWorkAcountServiceImpl;
    @Override
    public List<Map> countPosWork(ServiceSession session, JSONObject param) {
        String mkt = param.getString("mkt");
        String erpCode = param.getString("erpCode");
        String syjh = param.getString("syjh");
        String clearTime = param.getString("clearTime");

        // 获取统计总数据
//        JSONObject findP = new JSONObject();
        QueryWrapper<PosWorkAcountModel> queryWrapper=new QueryWrapper<>();
        String searchType = param.getString("searchType");
        if("1".equals(searchType)){//x报:某收银员所有款机统计
            String syyh = param.getString("operuserGh");
//            findP.put("syyh",syyh);
            queryWrapper.eq("syyh",syyh);
        }
        if("2".equals(searchType)){//z报：某收银机所有收银员
//            findP.put("syjh",syjh);
            queryWrapper.eq("syjh",syjh);
        }
        if("3".equals(searchType)){//新x报：某收银员当前款机统计
            String syyh = param.getString("operuserGh");
//            findP.put("syyh",syyh);
//            findP.put("syjh",syjh);
            queryWrapper.eq("syyh",syyh);
            queryWrapper.eq("syjh",syjh);
        }
//        findP.put("erpCode",erpCode);
//        findP.put("logtype",new String[]{"17","23","24","35"});
//        findP.put("mkt",mkt);
        queryWrapper.eq("erpCode",erpCode);
//        queryWrapper.eq("logtype",new String[]{"17","23","24","35"});
        queryWrapper.in("logtype","17","23","24","35");
        queryWrapper.eq("mkt",mkt);
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = sdf.parse(clearTime);
            queryWrapper.gt("rqsj",date);
        }catch (Exception e){
            log.error("清机时间转换异常："+e.getMessage());
        }
        queryWrapper.lt("rqsj",new Date());
        List<PosWorkAcountModel> workList = posWorkAcountServiceImpl.list(queryWrapper, "posworkacount");

        // 统计各类型数据
        HashMap<String,Integer> countNumber = new HashMap();//商品个数，暂时不需要，为后续产品保留逻辑
        HashMap<String,Double> countAmount = new HashMap();//金额
        HashMap<String,Integer> countEveryType = new HashMap();//操作次数
        Set<String> types = new HashSet<>();
        for (PosWorkAcountModel log : workList) {

            String logtype = log.getLogtype();
            double amount = log.getAmount();
            Integer count = log.getCount();

            if(countNumber.get(logtype) == null){
                countNumber.put(logtype,count);
            }else {
                Integer counded = countNumber.get(logtype);
                countNumber.put(logtype,counded+count);
            }

            if(countAmount.get(logtype) == null){
                countAmount.put(logtype,amount);
            }else {
                Double amounted = countAmount.get(logtype);
                countAmount.put(logtype, ManipulatePrecision.add(amounted,amount));
            }

            if(countEveryType.get(logtype) == null){
                countEveryType.put(logtype,1);
            }else {
                Integer c = countEveryType.get(logtype);
                Integer cN = c + 1;
                countEveryType.put(logtype,cN);
            }
            types.add(logtype);
        }

        List<Map> results = new ArrayList<>();
        for (String type : types) {
            HashMap ontType =  new HashMap();
            ontType.put("logType",type);
            ontType.put("count",countEveryType.get(type));
            ontType.put("amount",countAmount.get(type));
            results.add(ontType);
        }
        return results;
    }

    @Override
    public boolean onInsert(JSONObject param) {

        return posWorkAcountServiceImpl.saveEntity(JSON.toJavaObject(param,PosWorkAcountModel.class));
    }
}
