package com.efuture.business.service.impl;

import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.mapper.PosWorkAcountMapper;
import com.efuture.business.model.PosWorkAcountModel;
import com.efuture.business.service.PosWorkAcountService;
import com.efuture.business.util.db.DbTools;
import com.efuture.business.util.db.MultipleDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PosWorkAcountServiceImpl extends FunctionBaseServiceImpl<PosWorkAcountMapper, PosWorkAcountModel> implements PosWorkAcountService {

    @Autowired
    private DbTools dbTools;

    @Override
    public boolean saveEntity(PosWorkAcountModel posWorkAcountModel) {
        if ("Y".equals(GlobalInfo.centrally) && posWorkAcountModel.getMkt()!=null) {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("posworkacount", posWorkAcountModel.getMkt()));
        } else {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("posworkacount"));
        }
        return this.save(posWorkAcountModel);
    }

}
