package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.HessianService;
import com.efuture.business.constant.FunctionSoaUrl;
import com.efuture.business.model.PosWorkLogModel;
import com.efuture.business.service.PosWorkLogRemoteService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@HessianService(value = FunctionSoaUrl.POSWORKLOG_SERVICE_URL, interf = PosWorkLogRemoteService.class)
@Service
public class PosWorkLogRemoteServiceImpl implements PosWorkLogRemoteService {

    @Autowired
    PosWorkLogServiceImpl posWorkLogServiceImpl;
    @Override
    public boolean onInsert(JSONObject param) {
        return posWorkLogServiceImpl.saveEntity(JSON.toJavaObject(param, PosWorkLogModel.class));
    }
}
