package com.efuture.business.service.impl;


import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.mapper.PosWorkLogMapper;
import com.efuture.business.model.PosWorkLogModel;
import com.efuture.business.service.PosWorkLogService;
import com.efuture.business.util.db.DbTools;
import com.efuture.business.util.db.MultipleDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PosWorkLogServiceImpl extends FunctionBaseServiceImpl<PosWorkLogMapper, PosWorkLogModel> implements PosWorkLogService {
    @Autowired
    private DbTools dbTools;

    @Override
    public boolean saveEntity(PosWorkLogModel posWorkLogModel) {
        if ("Y".equals(GlobalInfo.centrally) && posWorkLogModel.getMkt()!=null) {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("posworklog", posWorkLogModel.getMkt()));
        } else {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("posworklog"));
        }
        return this.save(posWorkLogModel);
    }
}
