package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.HessianService;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.constant.FunctionSoaUrl;
import com.efuture.business.javaPos.struct.posManager.RebateCodeHead;
import com.efuture.business.service.RebateCodeHeadRemoteService;
import com.product.model.ServiceSession;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
@Slf4j
@HessianService(value = FunctionSoaUrl.REBATECODEHEAD_SERVICE_URL, interf = RebateCodeHeadRemoteService.class)
@Service
public class RebateCodeHeadRemoteServiceImpl  implements RebateCodeHeadRemoteService {

    //是否启用本地缓存
    @Value("${localcache.enabled}")
    private Boolean localcache;
    @Autowired
    RebateCodeServiceImpl rebateCodeService;

    @Override
    public RespBase search(ServiceSession session, JSONObject paramsObject) {
        // 只有在线状态才能调用学子卡
        if (localcache) {
            return Code.CODE_70012.getRespBase();
        }

        if (!paramsObject.containsKey("erpCode") || paramsObject.getString("erpCode").equals("")) {
            return Code.CODE_70013.getRespBase("erpCode");
        }
        if (!paramsObject.containsKey("mkt") || paramsObject.getString("mkt").equals("")) {
            return Code.CODE_70013.getRespBase("mkt");
        }
        //有效日期
        Calendar now = Calendar.getInstance();
        String effectivedate = new SimpleDateFormat("yyyy-MM-dd").format(now.getTime());
        paramsObject.put("effectivedate", effectivedate);

        //启用状态
        paramsObject.put("rhstatus", "Y");

//        List<Map> list = this.getTemplate().getSqlSessionTemplate()
//                .selectList("com.demo.dao.RebateCodeHeadModelMapper.search", paramsObject);
        List<Map> list = rebateCodeService.search(paramsObject);
        JSONObject result = new JSONObject();
        JSONArray resultArray = new JSONArray();
        if (list.size() == 0) {
            result.put("rebatecodehead", resultArray);
            result.put("total_results", resultArray.size());
            return new RespBase(Code.SUCCESS,result);
        } else {
            JSONArray rhids = new JSONArray();
            for (Map map : list) {
                String rhid = map.get("rhid").toString();
                rhids.add(rhid);
            }
            paramsObject.put("rhids", rhids);
            //查询这些活动中的排除门店是否包含上传门店
            List<Map> list2 = rebateCodeService.searchMfid(paramsObject);
            JSONArray rmids = new JSONArray();
            if (list2.size() != 0) {
                for (Map map : list2) {
                    String rmid = map.get("rmid").toString();
                    rmids.add(rmid);
                }
            }
            if (rmids.size() == 0) {
                result.put("rebatecodehead", list);
                result.put("total_results", list.size());
                return new RespBase(Code.SUCCESS,result);
            }
            paramsObject.put("rmids", rmids);
            //查询移除门店后的活动
            List<Map> list3 = rebateCodeService.searchHead(paramsObject);
            result.put("rebatecodehead", list3);
            result.put("total_results", list3.size());
            return new RespBase(Code.SUCCESS,result);
        }
    }

    @Override
    public RespBase detail(ServiceSession session, JSONObject paramsObject) {
        //查询表头
        JSONObject object = new JSONObject();
        object.put("hid", paramsObject.getString("hid"));
//        object.put("fields", "rhid,rhtype,rhrate,rhzkfd,erpCode");
        List<RebateCodeHead> rebateCodeHeads = rebateCodeService.listByMap(object,"rebatecodehead");
//        JSONArray headArray = jsonObject.getJSONArray(getCollectionName());
//        JSONObject head = headArray.getJSONObject(0);
//        String rhid = head.getString("rhid");
//        String erpCode = head.getString("erpCode");
        if(rebateCodeHeads.size() ==0 ){
            return Code.CODE_70014.getRespBase();
        }

        RebateCodeHead head = rebateCodeHeads.get(0);
        String rhid = head.getRhid();
        String erpCode = head.getErpCode();

        //查询明细
        JSONObject object2 = new JSONObject();
        object2.put("rhid", rhid);
        object2.put("erpCode", erpCode);
        object2.put("pdcode", paramsObject.getString("pdcode"));
        //截止日期
        Calendar now = Calendar.getInstance();
        String pdedate = new SimpleDateFormat("yyyy-MM-dd").format(now.getTime());
        object2.put("pdedate", pdedate);

        List<Map> list = rebateCodeService.detail(object2);
        if (list.size() == 0) {
            return Code.CODE_70014.getRespBase();
        }

        //查询排除类别
        List<Map> list2 = rebateCodeService.searchRemovecat(object2);
        JSONObject result = new JSONObject();
        result.put("rebatecodehead", rebateCodeHeads);
        result.put("rebatecodedetail", list);
        result.put("rebateremovecat", list2);
        return new RespBase(Code.SUCCESS,result);
    }
}
