package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.efuture.business.javaPos.struct.posManager.RebateCodeHead;
import com.efuture.business.mapper.RebateCodeHeadModelMapper;
import com.efuture.business.service.RebateCodeService;
import com.efuture.business.util.db.DbTools;
import com.efuture.business.util.db.MultipleDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
@Service
public class RebateCodeServiceImpl extends FunctionBaseServiceImpl<RebateCodeHeadModelMapper, RebateCodeHead> implements RebateCodeService {
    @Autowired
    private RebateCodeHeadModelMapper rebateCodeHeadModelMapper;

    @Autowired
    private DbTools dbTools;

    @Override
    public List<Map> searchMfid(JSONObject paramsObject) {
        MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("rebatecode"));
        return rebateCodeHeadModelMapper.searchMfid(paramsObject);
    }

    @Override
    public List<Map> searchHead(JSONObject paramsObject) {
        MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("rebatecode"));
        return rebateCodeHeadModelMapper.searchHead(paramsObject);
    }

    @Override
    public List<Map> search(JSONObject paramsObject) {
        MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("rebatecode"));
        return rebateCodeHeadModelMapper.search(paramsObject);
    }

    @Override
    public List<Map> detail(JSONObject paramsObject) {
        MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("rebatecode"));
        return rebateCodeHeadModelMapper.detail(paramsObject);
    }

    @Override
    public List<Map> searchRemovecat(JSONObject paramsObject) {
        MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("rebatecode"));
        return rebateCodeHeadModelMapper.searchRemovecat(paramsObject);
    }
}
