package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.mapper.SyjCashDetailMapper;
import com.efuture.business.model.SyjCashDetailModel;
import com.efuture.business.service.SyjPreCashDetailService;
import com.efuture.business.util.UniqueID;
import com.efuture.business.util.db.DbTools;
import com.efuture.business.util.db.MultipleDataSource;
import com.product.model.ResponseCode;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.*;

@Slf4j
@Service
public class SyjCashDetailServiceImpl extends FunctionBaseServiceImpl<SyjCashDetailMapper, SyjCashDetailModel> implements SyjPreCashDetailService {
    private static final Logger logger = LoggerFactory.getLogger(SyjCashDetailServiceImpl.class);
    @Autowired
    private DbTools dbTools;

    public ServiceResponse add(ServiceSession session, JSONObject paramsObject, long Cashid){

        logger.info("SyjCashDetailServiceImpl :"+paramsObject.toJSONString());
        logger.info("Cashid :"+Cashid);
       if(StringUtils.isEmpty(paramsObject.getString("syjprecashtemplate"))){
           return   ServiceResponse.buildSuccess("");
       }
        List list= paramsObject.getJSONArray("syjprecashtemplate");
        if(list.size()==0){
            return   ServiceResponse.buildSuccess("");
        }
        if ("Y".equals(GlobalInfo.centrally) && paramsObject.getString("mkt")!=null) {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("syjcashdetail", paramsObject.getString("mkt")));
        } else {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("syjcashdetail"));
        }

        for(int i=0;i<list.size();i++){
            JSONObject obj=((JSONArray) list).getJSONObject(i);
            obj.put("detailId", UniqueID.getUniqueID());
            obj.put("cashId",Cashid);
            obj.put("createDate",new Date());
            obj.put("updateDate",new Date());
            SyjCashDetailModel syjCashDetailModel = JSONObject.parseObject(obj.toJSONString(), SyjCashDetailModel.class);
            try {
                this.baseMapper.insert(syjCashDetailModel);
                logger.info("syjCashDetailModel :"+JSONObject.toJSONString(syjCashDetailModel));
            }catch (Exception e){
                e.printStackTrace();
            }
        }
        return   ServiceResponse.buildSuccess("插入成功");
    }

    public   ServiceResponse searchList(ServiceSession session, JSONObject paramsObject){
        if(StringUtils.isEmpty(paramsObject.getString("cashId"))){
            return ServiceResponse.buildFailure(session, ResponseCode.FAILURE,"入金主表id不能为空");
        }
        if ("Y".equals(GlobalInfo.centrally) && paramsObject.getString("mkt")!=null) {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("syjcashdetail", paramsObject.getString("mkt")));
        } else {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("syjcashdetail"));
        }

        JSONObject object1 = new JSONObject();
        List<SyjCashDetailModel> list = new LinkedList<>();
        try {
            object1.put("cashId",paramsObject.getString("cashId"));
            list = this.listByMap(object1,"syjcashdetail");
            log.info("syjcashdetail=="+JSONObject.toJSONString(list));
        }catch (Exception e){
            e.printStackTrace();
        }

        JSONObject  object  =new JSONObject();
        object.put("syjprecashtemplate",list);
        object.put("total_results",list.size());
        return ServiceResponse.buildSuccess(object);
    }



}
