package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.efuture.business.annotation.HessianService;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.constant.FunctionSoaUrl;
import com.efuture.business.model.SyjCashLogModel;
import com.efuture.business.model.SyjMainLogModel;
import com.efuture.business.service.SyjCashLogRemoteService;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

@Slf4j
@HessianService(value = FunctionSoaUrl.SYJCASHLOG_SERVICE_URL, interf = SyjCashLogRemoteService.class)
@Service
public class SyjCashLogRemoteServiceImpl implements SyjCashLogRemoteService {
    @Autowired
    SyjCashLogServiceImpl syjCashLogServiceImpl;

    @Autowired
    SyjMainLogServiceImpl syjMainLogServiceImpl;

    @Autowired
    SyjPreMoneyServiceImpl syjPreMoneyService;

    @Autowired
    private SyjCashDetailServiceImpl syjCashDetailService;
    @Override
    public List<Map> countCashLog(ServiceSession session, JSONObject param) {

        // 得到统计开始时间点
        String mkt = param.getString("mkt");
        String erpCode = param.getString("erpCode");
        String syjh = param.getString("syjh");
        String clearTime = param.getString("clearTime");

        // 获取统计数据
        JSONObject findP = new JSONObject();
//        QueryWrapper<SyjCashLogModel> syjCashLogWrapper = new QueryWrapper<>();
        QueryWrapper<SyjMainLogModel> syjCashLogWrapper = new QueryWrapper<>();

        String searchType = param.getString("searchType");
        if("1".equals(searchType)){//x报:某收银员所有款机统计
            String syyh = param.getString("operuserGh");
//            findP.put("syjcursyyh",syyh);
            syjCashLogWrapper.eq("syjcursyyh",syyh);
        }
        if("2".equals(searchType)){//z报：某收银机所有收银员
            syjCashLogWrapper.eq("syjh",syjh);
//            findP.put("syjh",syjh);
        }
        if("3".equals(searchType)){//新x报：某收银员当前款机统计
            String syyh = param.getString("operuserGh");
//            findP.put("syjcursyyh",syyh);
//            findP.put("syjh",syjh);
            syjCashLogWrapper.eq("syjcursyyh",syyh);
            syjCashLogWrapper.eq("syjh",syjh);
        }
//        findP.put("erpCode",erpCode);
//        findP.put("mkt",mkt);
        syjCashLogWrapper.eq("erpCode",erpCode);
        syjCashLogWrapper.eq("mkt",mkt);
//        findP.put("page_no",1);
//        findP.put("page_size",999999);
        syjCashLogWrapper.in("status",new String[]{"4","11","3","14","12","13","15"});
//        findP.put("status",new String[]{"4","11","3","14","12","13","15"});
//        Map<String,Object> paramsGL = new LinkedHashMap<String,Object>();
//        paramsGL.put(">", clearTime);
//        paramsGL.put("<", new Date());
//        findP.put("syjcurtime",paramsGL);
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = sdf.parse(clearTime);
            syjCashLogWrapper.gt("syjcurtime",date);
        }catch (Exception e){
            log.error("清机时间转换异常："+e.getMessage());
        }
        syjCashLogWrapper.lt("syjcurtime",new Date());
        List<SyjMainLogModel> cashLogList = syjMainLogServiceImpl.list(syjCashLogWrapper,"syjcashlog");

        // 统计可项数据   不同操作，记录不同的字段，无法统一获取
        HashMap<String,Object> countEnterCash = new HashMap();
        HashMap<String,Object> countCancelEnter = new HashMap();
        HashMap<String,Object> countMidEnter = new HashMap();
        HashMap<String,Object> countCancelMidEnter = new HashMap();
        HashMap<String,Object> countMidConvert = new HashMap();
        HashMap<String,Object> countLastPayment = new HashMap();
        HashMap<String,Object> countCancelLastPayment = new HashMap();
        for (SyjMainLogModel log : cashLogList) {

            String status = log.getStatus();
            BigDecimal curpreje = log.getSyjcurpreje();
            BigDecimal paychashje = log.getSyjpaycashje();
            //入金
            if ("4".equals(status)){
                countEnterCash.put("status","4");
                if(countEnterCash.get("syjcurpreje") == null){
                    countEnterCash.put("syjcurpreje",curpreje);
                    countEnterCash.put("count",1);
                }else {
                    BigDecimal cAmount = (BigDecimal)countEnterCash.get("syjcurpreje");
                    Integer cNumber = (Integer)countEnterCash.get("count");
                    countEnterCash.put("syjcurpreje",cAmount.add(curpreje));
                    countEnterCash.put("count",cNumber+1);
                }
            }
            //入金消单
            if("11".equals(status)){
                countCancelEnter.put("status","11");
                if(countCancelEnter.get("syjcurpreje") == null){
                    countCancelEnter.put("syjcurpreje",curpreje);
                    countCancelEnter.put("count",1);
                }else {
                    BigDecimal cAmount = (BigDecimal)countCancelEnter.get("syjcurpreje");
                    Integer cNumber = (Integer)countCancelEnter.get("count");
                    countCancelEnter.put("syjcurpreje",cAmount.add(curpreje));
                    countCancelEnter.put("count",cNumber+1);
                }
            }
            //中间回收
            if("3".equals(status)){
                countMidEnter.put("status","3");
                if(countMidEnter.get("syjpaycashje") == null){
                    countMidEnter.put("syjpaycashje",paychashje);
                    countMidEnter.put("count",1);
                }else {
                    BigDecimal cAmount = (BigDecimal)countMidEnter.get("syjpaycashje");
                    Integer cNumber = (Integer) countMidEnter.get("count");
                    countMidEnter.put("syjpaycashje",cAmount.add(paychashje));
                    countMidEnter.put("count",cNumber+1);
                }
            }
            //中间回收取消
            if("13".equals(status)){
                countCancelMidEnter.put("status","13");
                if(countCancelMidEnter.get("syjpaycashje") == null){
                    countCancelMidEnter.put("syjpaycashje",paychashje);
                    countCancelMidEnter.put("count",1);
                }else {
                    BigDecimal cAmount = (BigDecimal)countCancelMidEnter.get("syjpaycashje");
                    Integer cNumber = (Integer)countCancelMidEnter.get("count");
                    countCancelMidEnter.put("syjpaycashje",cAmount.add(paychashje));
                    countCancelMidEnter.put("count",cNumber+1);
                }
            }
            //中间兑换
            if("14".equals(status)){
                countMidConvert.put("status","14");
                if(countMidConvert.get("syjpaycashje") == null){
                    countMidConvert.put("syjpaycashje",paychashje);
                    countMidConvert.put("count",1);
                }else {
                    BigDecimal cAmount = (BigDecimal)countMidConvert.get("syjpaycashje");
                    Integer cNumber = (Integer) countMidConvert.get("count");
                    countMidConvert.put("syjpaycashje",cAmount.add(paychashje));
                    countMidConvert.put("count",cNumber+1);
                }
            }
            //缴款
            if("12".equals(status)){
                countLastPayment.put("status","12");
                if(countLastPayment.get("syjpaycashje") == null){
                    countLastPayment.put("syjpaycashje",paychashje);
                    countLastPayment.put("count",1);
                }else {
                    BigDecimal cAmount = (BigDecimal)countLastPayment.get("syjpaycashje");
                    Integer cNumber = (Integer) countLastPayment.get("count");
                    countLastPayment.put("syjpaycashje",cAmount.add(paychashje));
                    countLastPayment.put("count",cNumber+1);
                }
            }
            //缴款取消
            if("15".equals(status)){
                countCancelLastPayment.put("status","15");
                if(countCancelLastPayment.get("syjpaycashje") == null){
                    countCancelLastPayment.put("syjpaycashje",paychashje);
                    countCancelLastPayment.put("count",1);
                }else {
                    BigDecimal cAmount = (BigDecimal)countCancelLastPayment.get("syjpaycashje");
                    Integer cNumber = (Integer)countCancelLastPayment.get("count");
                    countCancelLastPayment.put("syjpaycashje",cAmount.add(paychashje));
                    countCancelLastPayment.put("count",cNumber+1);
                }
            }
        }

        ArrayList<Map> result = new ArrayList<>();
        if(countEnterCash.entrySet().size()!=0) {
            result.add(countEnterCash);
        }
        if(countCancelEnter.entrySet().size()!=0){
            result.add(countCancelEnter);
        }
        if(countMidEnter.entrySet().size()!=0){
            result.add(countMidEnter);
        }
        if(countCancelMidEnter.entrySet().size()!=0) {
            result.add(countCancelMidEnter);
        }
        if(countMidConvert.entrySet().size()!=0){
            result.add(countMidConvert);
        }
        if(countLastPayment.entrySet().size()!=0) {
            result.add(countLastPayment);
        }
        if(countCancelLastPayment.entrySet().size()!=0) {
            result.add(countCancelLastPayment);
        }
        return result;

    }

    @Override
    public RespBase insertCash(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        log.info("[{}]--[{}]入参->{}", jsonObject.getString("flowNo"), "入金", jsonObject.toJSONString());
        ServiceResponse response = syjCashLogServiceImpl.insertCash(session,jsonObject);
        log.info("[{}]--[{}]出参->{}", jsonObject.getString("flowNo"), "入金", JSONObject.toJSONString(response));
        if("0".equals(response.getReturncode())){
            return new RespBase(Code.SUCCESS,response.getData(),"PREMONEYCERTIFY");
        }else {
            return new RespBase(Code.FAIL,response.getData(),"PREMONEYCERTIFY");
        }
    }

    @Override
    public RespBase getTemporaryPayLog(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        try {
            ServiceResponse response = syjCashLogServiceImpl.getTemporaryPayLog(session,jsonObject);

            if("0".equals(response.getReturncode())){
                return new RespBase(Code.SUCCESS,response.getData(),"GETTEMPORARYPAYLOG");
            }else {
                return new RespBase(Code.FAIL,response.getData(),"GETTEMPORARYPAYLOG");
            }
        }catch (Exception e){
            return Code.FAIL.getRespBase("-1", e.getMessage());
        }
    }

    @Override
    public long getMaxPreCount(JSONObject jsonObject) {
        return syjCashLogServiceImpl.getMaxPreCount(jsonObject);
    }

    @Override
    public boolean updateCashLog(JSONObject jsonObject) {
        return syjCashLogServiceImpl.updateCashLog(jsonObject);
    }

    @Override
    public String getCashList(ServiceSession session, JSONObject param) {
        return syjCashLogServiceImpl.getCashList(param);
    }

    @Override
    public int saveEntity(JSONObject jsonObject) {
        return syjCashLogServiceImpl.saveEntity(JSONObject.toJavaObject(jsonObject,SyjCashLogModel.class));
    }

    @Override
    public RespBase getInsertCashLog(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        log.info("getInsertCashLog==>"+jsonObject.toJSONString());
        try {
            ServiceResponse response = syjCashLogServiceImpl.getInsertCashLog(session,jsonObject);
            log.info("getInsertCashLog==>response:"+response.toString());
            if("0".equals(response.getReturncode())){
                return new RespBase(Code.SUCCESS,response.getData(),"GETINSERTCASHLOG");
            }else {
                return new RespBase(Code.FAIL,response.getData(),"GETINSERTCASHLOG");
            }
        }catch (Exception e){
            log.error(e.getMessage(),e);
            return Code.FAIL.getRespBase("-1", e.getMessage());
        }

    }

    @Override
    public RespBase getCashDetail(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        try {
            ServiceResponse response = syjCashDetailService.searchList(session,jsonObject);

            if("0".equals(response.getReturncode())){
                return new RespBase(Code.SUCCESS,response.getData(),"PRECASHLOGDETAIL");
            }else {
                return Code.FAIL.getRespBase(response.getReturncode(), response.getData());
            }
        }catch (Exception e){
            return Code.FAIL.getRespBase("-1", e.getMessage());
        }

    }

    @Override
    public RespBase insertPreMoney(ServiceSession session, ResqVo vo, JSONObject jsonObject){
        log.info("[{}]--[{}]入参->{}", jsonObject.getString("flowNo"), "备用金", jsonObject.toJSONString());
        try {
            ServiceResponse response = syjPreMoneyService.insertPreMoney(session,jsonObject);
            log.info("[{}]--[{}]出参->{}", jsonObject.getString("flowNo"), "备用金", JSONObject.toJSONString(response));
            if("0".equals(response.getReturncode())){
                return new RespBase(Code.SUCCESS,response.getData(),"PREMONEYCERTIFY");
            }else {
                return new RespBase(Code.FAIL,response.getData(),"PREMONEYCERTIFY");
            }
        }catch (Exception e){
            e.printStackTrace();
            return new RespBase(Code.FAIL,e.getMessage(),"PREMONEYCERTIFY");
        }


    }
}
