package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.mapper.SyjCashLogMapper;
import com.efuture.business.model.*;
import com.efuture.business.service.SyjCashLogService;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.db.DbTools;
import com.efuture.business.util.db.MultipleDataSource;
import com.product.model.ResponseCode;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.*;


@Service
public class SyjCashLogServiceImpl extends FunctionBaseServiceImpl<SyjCashLogMapper, SyjCashLogModel> implements SyjCashLogService {
    private static final Logger logger = LoggerFactory.getLogger(SyjCashLogServiceImpl.class);
    @Autowired
    SyjMainExpServiceImpl syjMainServiceImpl;
    @Autowired
    OperUserExpServiceImpl operUserServiceImpl;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SyjCashLogMapper syjCashLogMapper;
    @Autowired
    private DbTools dbTools;

    /***
     //     * 收银员当日入金记录
     //     *
     //     * @param session
     //     * @param paramsObject
     //     * @return
     //     * @throws Exception
     //     */
    public ServiceResponse getInsertCashLog(ServiceSession session, JSONObject paramsObject) throws Exception {
        logger.info("getInsertCashLog");
        String paravalue = "1";

        String obj = redisUtil.get(RedisKey.CACHEID+paramsObject.get("mkt")+paramsObject.get("syjh"));
        if(null==obj){
            return ServiceResponse.buildFailure(session,"-1","收银机缓存为空");
        }
        ModeDetailsVo modeDetailsVo = JSONObject.parseObject(obj,ModeDetailsVo.class);
        JSONArray array = new JSONArray();
        List<Syspara> sysParaList = modeDetailsVo.getSyspara();
        JSONArray  sysParaArray = JSONArray.parseArray(JSON.toJSONString(sysParaList));
        if (sysParaArray.size() != 0) {
            for (int i = 0; i < sysParaArray.size(); i++) {
                JSONObject sys = sysParaArray.getJSONObject(i);
                if (sys.get("code").equals("RJZS")) {
                    array.add(sys);
                }
            }
        }
        if (array.size() != 0) {
            JSONObject object3 = array.getJSONObject(0);
            if (object3.containsKey("paravalue")) {
                paravalue = object3.getString("paravalue");
            }
        }
        String clearTime =syjMainServiceImpl.getClearTime(session,paramsObject.getString("erpCode"),paramsObject.getString("mkt"),paramsObject.getString("syjh"));
        if(!paramsObject.containsKey("clearTime")){
            paramsObject.put("clearTime", clearTime);
        }
        String  accountDate =syjMainServiceImpl.getOutLineTime();
        paramsObject.put("accountDate", accountDate);
        if (paravalue.equals("1")) {
            // 查询是否有全部数据权限
            boolean flag =operUserServiceImpl.getOperRange(session,paramsObject);
            logger.info("收银员查看数据权限" + flag);
            List<Map> list;
            if(flag==false){
                //查询当前款机+款员
                list =  getPreCashTodayHistory(paramsObject);
            }else{
                //查询当前款机所有款员
                list =  getPreCashTodayHistory3(paramsObject);
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("todayhistory", list);
            return ServiceResponse.buildSuccess(jsonObject);
        }
        if (paravalue.equals("0")) {
            // 获取当日录入备用金情况（收银员）收银员在所有收银机
            paramsObject.remove("syjh");
            List<Map> list =  getPreCashTodayHistory2(paramsObject);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("todayhistory", list);
            return ServiceResponse.buildSuccess(jsonObject);
        }
        else {
            // 获取当日录入备用金情况（收银机）收银机上所有收银员
            List<Map> list =  getPreCashTodayHistory3(paramsObject);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("todayhistory", list);
            return ServiceResponse.buildSuccess(jsonObject);
        }
    }



    @Override
    public int saveEntity(SyjCashLogModel SyjCashLogModel) {
        if ("Y".equals(GlobalInfo.centrally) && SyjCashLogModel.getMkt()!=null) {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("syjcashlog", SyjCashLogModel.getMkt()));
        } else {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("syjcashlog"));
        }
        return this.baseMapper.insertSelective(SyjCashLogModel);
    }

    @Override
    public boolean updateCashLog(JSONObject jsonObject) {
        if ("Y".equals(GlobalInfo.centrally) && jsonObject.containsKey("mkt")) {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("syjcashlog", jsonObject.get("mkt").toString()));
        } else {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("syjcashlog"));
        }
        this.getBaseMapper().updateByPrimaryKey(jsonObject);
        return true;
    }

    @Override
    public long getMaxPreCount(JSONObject paramsObject) {
        if ("Y".equals(GlobalInfo.centrally) && paramsObject.getString("mkt")!=null) {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("syjcashlog", paramsObject.getString("mkt")));
        } else {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("syjcashlog"));
        }
        return this.baseMapper.getMaxPreCount(paramsObject);
    }

    @Override
    public List<Map> getPreCashTodayHistory(JSONObject paramsObject) {
        if ("Y".equals(GlobalInfo.centrally) && paramsObject.getString("mkt")!=null) {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("syjcashlog", paramsObject.getString("mkt")));
        } else {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("syjcashlog"));
        }

        List<Map> list = new LinkedList<>();
        try {
            list = this.baseMapper.getPreCashTodayHistory(paramsObject);
            logger.info("===>getPreCashTodayHistory"+JSONObject.toJSONString(list));
        }catch (Exception e){
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public List<Map> getPreCashTodayHistory2(JSONObject paramsObject) {
        if ("Y".equals(GlobalInfo.centrally) && paramsObject.getString("mkt")!=null) {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("syjcashlog", paramsObject.getString("mkt")));
        } else {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("syjcashlog"));
        }
        logger.info("===>getPreCashTodayHistory2");
        List<Map> list = new LinkedList<>();
        try {
            list = this.baseMapper.getPreCashTodayHistory2(paramsObject);
            logger.info("===>getPreCashTodayHistory"+JSONObject.toJSONString(list));
        }catch (Exception e){
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public List<Map> getPreCashTodayHistory3(JSONObject paramsObject) {
        if ("Y".equals(GlobalInfo.centrally) && paramsObject.getString("mkt")!=null) {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("syjcashlog", paramsObject.getString("mkt")));
        } else {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("syjcashlog"));
        }
        logger.info("===>getPreCashTodayHistory3");
        List<Map> list = new LinkedList<>();
        try {
            list = this.baseMapper.getPreCashTodayHistory3(paramsObject);
            logger.info("===>getPreCashTodayHistory"+JSONObject.toJSONString(list));
        }catch (Exception e){
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public List<Map> getPayTodayHistory(JSONObject paramsObject) {
        if ("Y".equals(GlobalInfo.centrally) && paramsObject.getString("mkt")!=null) {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("syjcashlog", paramsObject.getString("mkt")));
        } else {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("syjcashlog"));
        }
        List<Map> list = new LinkedList<>();
        try {
            list = this.baseMapper.getPayTodayHistory(paramsObject);
        }catch (Exception e){
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public List<Map> getPayTodayHistory2(JSONObject paramsObject) {
        if ("Y".equals(GlobalInfo.centrally) && paramsObject.getString("mkt")!=null) {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("syjcashlog", paramsObject.getString("mkt")));
        } else {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("syjcashlog"));
        }
        List<Map> list = new LinkedList<>();
        try {
            list = this.baseMapper.getPayTodayHistory2(paramsObject);
        }catch (Exception e){
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public List<Map> getPayTodayHistory3(JSONObject paramsObject) {
        if ("Y".equals(GlobalInfo.centrally) && paramsObject.getString("mkt")!=null) {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("syjcashlog", paramsObject.getString("mkt")));
        } else {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("syjcashlog"));
        }
        List<Map> list = new LinkedList<>();
        try {
            list = this.baseMapper.getPayTodayHistory3(paramsObject);
        }catch (Exception e){
            e.printStackTrace();
        }
        return list;
    }

    public boolean chkInsertCash(ServiceSession session, JSONObject paramsObject) {
        // 录入备用金
        if (paramsObject.getString("cashflag").equals("1")) {
            paramsObject.put("cashlog_status", "4");
            paramsObject.put("worklog_logtype", "2");
            paramsObject.put("worklog_logdesc", "录入备用金");
        }

        // 入金取消
        if (paramsObject.getString("cashflag").equals("2")) {
            paramsObject.put("cashlog_status", "11");
            paramsObject.put("worklog_logtype", "30");
            paramsObject.put("worklog_logdesc", "入金取消");
        }
        // 零钱金兑换
        if (paramsObject.getString("cashflag").equals("3")) {
            paramsObject.put("cashlog_statu","14");
            paramsObject.put("worklog_logtype","31");
            paramsObject.put("worklog_logdesc","零钱金兑换");
        }

        if (paramsObject.getString("cashflag").equals("1") || paramsObject.getString("cashflag").equals("3")) {
            return true;
        }

        // 检查是否入金取消
        paramsObject.put("cancelph_key", paramsObject.getString("ph_key"));
        Map map = new HashMap();
        map.put("ph_key",paramsObject.getString("ph_key"));

        List<SyjCashLogModel> list = this.listByMap(map,"syjcashlog");
        if (list.size() > 0) {
            if (StringUtils.isEmpty(list.get(0).getCancelph_key())) {
                return true;
            }
        }
        return false;
    }

    /***
     * 录入现金存量（备用金）
     *
     * @param session
     * @param paramsObject
     * @return
     * @throws Exception
     */
    @SuppressWarnings("rawtypes")
    public ServiceResponse insertCash(ServiceSession session, JSONObject paramsObject) {

        JSONObject  requstParam =(JSONObject)paramsObject.clone();
        if (StringUtils.isEmpty(paramsObject.getString("cashflag"))) {
            return ServiceResponse.buildFailure(session, ResponseCode.FAILURE, "交易类型不能为空");
        }
        if (paramsObject.getString("cashflag").equals("2")) {
            if (StringUtils.isEmpty(paramsObject.getString("ph_key"))) {
                return ServiceResponse.buildFailure(session, ResponseCode.FAILURE, " 入金取消ph_key不能为空");
            }
        }

        boolean flag = this.chkInsertCash(session, paramsObject);
        if (false == flag) {
            return ServiceResponse.buildFailure(session, ResponseCode.FAILURE, "不能重复入金取消");
        }
        paramsObject.remove("ph_key");
        try {
            Date startTime = new Date();
            paramsObject.put("startTime", startTime);

            String clearTime =syjMainServiceImpl.getClearTime(session,paramsObject.getString("erpCode"),paramsObject.getString("mkt"),paramsObject.getString("syjh"));
            String accountDate = syjMainServiceImpl.getOutLineTime();

            if (paramsObject.containsKey("clearTime")) {
                clearTime =paramsObject.getString("clearTime");
            }

            paramsObject.put("accountDate", accountDate);

            // 获取当前现金存量+录入备用金总和
            BigDecimal cashje = paramsObject.getBigDecimal("syjcurpreje");
            BigDecimal syjcurcashje=paramsObject.getBigDecimal("syjcurcashje");
            String obj = redisUtil.get(RedisKey.CACHEID+paramsObject.get("mkt")+paramsObject.get("syjh"));
            ModeDetailsVo modeDetailsVo = JSONObject.parseObject(obj,ModeDetailsVo.class);
            JSONArray array = new JSONArray();
            List<Syspara> sysParaList = modeDetailsVo.getSyspara();
            JSONArray  sysParaArray = JSONArray.parseArray(JSON.toJSONString(sysParaList));
            if (sysParaArray.size() != 0) {
                for (int i = 0; i < sysParaArray.size(); i++) {
                    JSONObject sys = sysParaArray.getJSONObject(i);
                    if (sys.get("code").equals("4C")) {
                        array.add(sys);
                    }
                }
            }
            Syjmain syjmain = modeDetailsVo.getSyjmain();
            String syjcursyyh = "";
            JSONObject b = new JSONObject();
            b.put("erpCode", paramsObject.get("erpCode"));
            b.put("mkt", paramsObject.get("mkt"));
            b.put("syjh", paramsObject.get("syjh"));
            if (paramsObject.containsKey("syjcursyyh")) {
                syjcursyyh = paramsObject.getString("syjcursyyh");
                b.put("syjcursyyh", syjcursyyh);
            } else {
                syjcursyyh = syjmain.getSyjcursyyh();
                b.put("syjcursyyh", syjcursyyh);
            }
            paramsObject.put("syjcursyyh", syjcursyyh);
            BigDecimal je = syjmain.getSyjcurcashje();

            // 查询收银员当天在该收银机上的入金次数
            b.put("clearTime", clearTime);
            long insertprecashcount = this.getMaxPreCount(b);

            BigDecimal syjcurpreje = syjmain.getSyjcurpreje();
            BigDecimal newprecashje = syjcurpreje.add(cashje);
            paramsObject.put("insertprecashcount", insertprecashcount + 1);
            paramsObject.put("syjcurpreje", newprecashje);
            paramsObject.put("cashje", cashje);


            // 当前门店未设置现金存量限制时不控制
            if (array.size() == 0) {
                ServiceResponse re = syjMainServiceImpl.doUpdates(session, paramsObject);
                JSONObject redata = (JSONObject) re.getData();
                long ph_key = Long.valueOf(redata.get("ph_key").toString());

                // 获取当日录入备用金情况
                logger.info("查询当日入金参数：" + b);
                ServiceResponse response = this.getInsertCashLog(session, b);
                JSONObject json = (JSONObject) response.getData();
                JSONArray array3 = json.getJSONArray("todayhistory");

                // 查询该收银员当天总入金金额
                BigDecimal totalpreje = new BigDecimal(0.00);
                for (int i = 0; i < array3.size(); i++) {
                    BigDecimal curpreje = array3.getJSONObject(i).getBigDecimal("syjcurpreje");
                    totalpreje = totalpreje.add(curpreje);
                }

                JSONObject jsonObject = new JSONObject();
                jsonObject.put("ph_key", ph_key);
                jsonObject.put("insertprecashcount", paramsObject.get("insertprecashcount"));
                jsonObject.put("totalinsertcash", totalpreje);
                jsonObject.put("todayhistory", array3);
                jsonObject.put("requstParam", requstParam);
                jsonObject.put("clearTime", clearTime);
                logger.info("入银头--->记账日期accountDate：" + accountDate);
                return ServiceResponse.buildSuccess(jsonObject);
            }

            BigDecimal paravalue = new BigDecimal(0.00);
            for (int j = 0; j < array.size(); j++) {
                JSONObject map2 = array.getJSONObject(j);
                logger.info("map2==="+map2.toJSONString());
                if (!map2.containsKey("paravalue")) {
                    // 当前门店未设置现金存量限制时不控制
                    ServiceResponse re = syjMainServiceImpl.doUpdates(session, paramsObject);
                    JSONObject redata = (JSONObject) re.getData();
                    long ph_key = Long.valueOf(redata.get("ph_key").toString());

                    // 获取当日录入备用金情况
                    logger.info("查询当日入金参数：" + b);
                    ServiceResponse response = this.getInsertCashLog(session, b);
                    JSONObject json = (JSONObject) response.getData();
                    JSONArray array3 = json.getJSONArray("todayhistory");

                    // 查询该收银员当天总入金金额
                    BigDecimal totalpreje = new BigDecimal(0.00);
                    for (int i = 0; i < array3.size(); i++) {
                        BigDecimal curpreje = array3.getJSONObject(i).getBigDecimal("syjcurpreje");
                        totalpreje = totalpreje.add(curpreje);
                    }

                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("ph_key", ph_key);
                    jsonObject.put("insertprecashcount", paramsObject.get("insertprecashcount"));
                    jsonObject.put("totalinsertcash", totalpreje);
                    jsonObject.put("todayhistory", array3);
                    jsonObject.put("requstParam", requstParam);
                    jsonObject.put("clearTime", clearTime);
                    logger.info("入银头--->记账日期accountDate：" + accountDate);
                    return ServiceResponse.buildSuccess(jsonObject);

                }

                if(!map2.getBigDecimal("paravalue").equals(null)){
                    paravalue = map2.getBigDecimal("paravalue");
                }
                logger.info("paravalue"+paravalue);
                // 当前门店设置现金存量限制为0时同未不控制
                if (paravalue.compareTo(BigDecimal.ZERO) == 0) {
                    ServiceResponse re = syjMainServiceImpl.doUpdates(session, paramsObject);
                    JSONObject redata = (JSONObject) re.getData();
                    long ph_key = Long.valueOf(redata.get("ph_key").toString());

                    // 获取当日录入备用金情况
                    logger.info("查询当日入金参数：" + b);
                    ServiceResponse response = this.getInsertCashLog(session, b);
                    JSONObject json = (JSONObject) response.getData();
                    JSONArray array3 = json.getJSONArray("todayhistory");

                    // 查询该收银员当天总入金金额
                    BigDecimal totalpreje = new BigDecimal(0.00);
                    for (int i = 0; i < array3.size(); i++) {
                        BigDecimal curpreje = array3.getJSONObject(i).getBigDecimal("syjcurpreje");
                        totalpreje = totalpreje.add(curpreje);
                    }

                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("ph_key", ph_key);
                    jsonObject.put("insertprecashcount", paramsObject.get("insertprecashcount"));
                    jsonObject.put("totalinsertcash", totalpreje);
                    jsonObject.put("todayhistory", array3);
                    jsonObject.put("requstParam", requstParam);
                    jsonObject.put("clearTime", clearTime);
                    logger.info("入银头--->记账日期accountDate：" + accountDate);
                    return ServiceResponse.buildSuccess(jsonObject);
                }

            }
            logger.info("当前款机现金存量：" + je);
            logger.info("参数设置收银台最高现金存量(元):" + paravalue);
            logger.info("入金金额：" + cashje);
            if (je.compareTo(paravalue) == 1) {
                logger.info("当前款机现金存量：" + je);
                logger.info("参数设置收银台最高现金存量(元):" + paravalue);
                logger.info("入金金额：" + cashje);
                if (cashje.compareTo(BigDecimal.ZERO) == 1) {
                    return ServiceResponse.buildFailure(session, ResponseCode.FAILURE, "现金存量大于门店限制现金存量");
                }
            }
            ServiceResponse re = syjMainServiceImpl.doUpdates(session, paramsObject);
            JSONObject redata = (JSONObject) re.getData();
            long ph_key = Long.valueOf(redata.get("ph_key").toString());

            // 获取当日录入备用金情况
            logger.info("查询当日入金参数：" + b);
            ServiceResponse response = this.getInsertCashLog(session, b);
            JSONObject json = (JSONObject) response.getData();
            JSONArray array3 = json.getJSONArray("todayhistory");

            // 查询该收银员当天总入金金额
            BigDecimal totalpreje = new BigDecimal(0.00);
            for (int i = 0; i < array3.size(); i++) {
                BigDecimal curpreje = array3.getJSONObject(i).getBigDecimal("syjcurpreje");
                totalpreje = totalpreje.add(curpreje);
            }

            JSONObject jsonObject = new JSONObject();
            jsonObject.put("ph_key", ph_key);
            jsonObject.put("insertprecashcount", paramsObject.get("insertprecashcount"));
            jsonObject.put("totalinsertcash", totalpreje);
            jsonObject.put("clearTime", clearTime);
            jsonObject.put("todayhistory", array3);
            jsonObject.put("requstParam", requstParam);
            logger.info("入银头--->记账日期accountDate：" + accountDate);
            return ServiceResponse.buildSuccess(jsonObject);
        } catch (Exception e) {
            // TODO: handle exception
            e.printStackTrace();
            logger.info(e.toString());
            return ServiceResponse.buildFailure(session, ResponseCode.FAILURE, "入金失败-->" + e);
        }

    }

    public int updateCash(JSONObject paramsObject,long ph_key) {
        if ("Y".equals(GlobalInfo.centrally) && paramsObject.getString("mkt")!=null) {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("syjcashlog", paramsObject.getString("mkt")));
        } else {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("syjcashlog"));
        }
        JSONObject ob = new JSONObject();
        ob.put("cancelph_key",ph_key);
        ob.put("ph_key",paramsObject.getLong("cancelph_key"));
        return this.baseMapper.updateByPrimaryKey(ob);
    }

    /***
     * 收银员当日中途缴收记录
     *
     * @param session
     * @param paramsObject
     * @return
     * @throws Exception
     */
    public ServiceResponse getTemporaryPayLog(ServiceSession session, JSONObject paramsObject) throws Exception {
        String paravalue = "0";

        String obj = redisUtil.get(RedisKey.CACHEID+paramsObject.get("mkt")+paramsObject.get("syjh"));
        ModeDetailsVo modeDetailsVo = JSONObject.parseObject(obj,ModeDetailsVo.class);
        JSONArray array = new JSONArray();
        List<Syspara> sysParaList = modeDetailsVo.getSyspara();
        JSONArray  sysParaArray = JSONArray.parseArray(JSON.toJSONString(sysParaList));
        if (sysParaArray.size() != 0) {
            for (int i = 0; i < sysParaArray.size(); i++) {
                JSONObject sys = sysParaArray.getJSONObject(i);
                if (sys.get("code").equals("RJZS")) {
                    array.add(sys);
                }
            }
        }
        if (array.size() != 0) {
            JSONObject object3 = array.getJSONObject(0);
            if (object3.containsKey("paravalue")) {
                paravalue = object3.getString("paravalue");
            }
        }
        String clearTime="";
        if (paramsObject.containsKey("clearTime")) {
            clearTime =paramsObject.getString("clearTime");
        }else{
            clearTime =syjMainServiceImpl.getClearTime(session,paramsObject.getString("erpCode"),paramsObject.getString("mkt"),paramsObject.getString("syjh"));
            paramsObject.put("clearTime", clearTime);
        }
        String  accountDate =syjMainServiceImpl.getOutLineTime();
        paramsObject.put("accountDate", accountDate);
        if (paravalue.equals("1")) {
            // 获取当日中途缴收情况（人+机）查询本人当前款机
            boolean flag =operUserServiceImpl.getOperRange(session,paramsObject);
            logger.info("收银员查看数据权限" + flag);
            List<Map> list;
            if(flag==false){
                //查询当前款机+款员
                list =  this.getPayTodayHistory(paramsObject);
            }else{
                //查询当前款机所有款员
                list =  this.getPayTodayHistory3(paramsObject);
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("todayhistory", list);
            return ServiceResponse.buildSuccess(jsonObject);
        }
        if (paravalue.equals("0")) {
            // 获取当日中途缴收情况（收银员）--所有款机
            paramsObject.remove("syjh");
            List<Map> list = this.getPayTodayHistory2(paramsObject);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("todayhistory", list);
            return ServiceResponse.buildSuccess(jsonObject);
        }
        else {
            // 获取当日中途缴收情况（款机下所有收银员）
            List<Map> list = getPayTodayHistory3(paramsObject);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("todayhistory", list);
            return ServiceResponse.buildSuccess(jsonObject);
        }
    }

    public String getCashList(JSONObject param) {
        JSONObject ob = new JSONObject();
        ob.put("ph_key",Long.valueOf(param.getString("ph_key")));
        if ("Y".equals(GlobalInfo.centrally) && param.containsKey("mkt")) {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("syjcashlog", param.get("mkt").toString()));
        } else {
            MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("syjcashlog"));
        }
        return JSONObject.toJSONString(this.baseMapper.getCashlog(ob));
    }
}
