package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.constant.*;
import com.efuture.business.model.*;
import com.efuture.business.service.*;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.UniqueID;
import com.efuture.common.utils.MD5Utils;
import com.efuture.redis.util.DateUtils;
import com.product.model.*;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SyjMainExpServiceImpl implements SyjMainExpService {

	private static final Logger logger = LoggerFactory.getLogger(SyjMainExpServiceImpl.class);

	@Autowired
	private SyjCashLogServiceImpl syjCashLogServiceImpl;
	@Autowired
	private PosWorkLogServiceImpl posWorkLogServiceImpl;
	@Autowired
	private SyjCashDetailServiceImpl syjCashDetailServiceImpl;
	@Autowired
	private PosWorkAcountServiceImpl posWorkAcountServiceImpl;
	@Autowired
	PosNewsServiceImpl posNewsServiceImpl;
	@Autowired
	private CashierMoneyRecordExtServiceImpl cashierMoneyRecordService;
	@Autowired
	private SyjMainLogServiceImpl syjMainLogService;
	@Autowired
	private OperUserExpServiceImpl operUserExpService;
	@Autowired
	private RedisUtil redisUtil;

	//是否启用本地缓存
	@Value("${localcache.enabled}")
	private Boolean localcache;

	//是否启用hazelcast缓存
	@Value("${hazelcast.enabled}")
	private Boolean hazelcast;

	@SoaAnnotation(value = SyjmainSoaUrl.SYJMAIN_SERVICE_URL)
	private SyjMainRemoteService syjmainRemoteService;

	@SoaAnnotation(value = TempCardRelationSoaUrl.TEMPCARDRELATION_SERVICE_URL)
	private TempCardRelationRemoteService tempCardRelationRemoteService;

	@SoaAnnotation(value = PosRoleSoaUrl.POSROLE_SERVICE_URL)
	private PosRoleRemoteService posRoleRemoteService;
	/*
	 * 获取清机时间
	 */
	String getClearTime(ServiceSession session, String erpCode, String mkt, String syjh) {

		Calendar now = Calendar.getInstance();
		String dataTimestr;
		String obj = redisUtil.get(RedisKey.CACHEID + mkt + syjh);
		ModeDetailsVo modeDetailsVo = JSONObject.parseObject(obj, ModeDetailsVo.class);
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		try {
			dataTimestr = getOutLineTime() + " 05:00:00";
			Syjmain syjMain = modeDetailsVo.getSyjmain();

			Date today = sdf.parse(dataTimestr);
			Date syjcleartime = syjMain.getSyjcleartime();
			//清机时间为空返回记账凌晨5点
			if (syjcleartime == null) {
				return dataTimestr;
			}
			//上次清机时间大于记账凌晨5点，返回当前清机时间
			if (syjcleartime.getTime() > today.getTime()) {
				return sdf.format(syjcleartime);
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			return "";
		}

		return dataTimestr;
	}


	/**
	 * 获取离线记账日期
	 *
	 * @return
	 * @throws Exception
	 */
	public String getOutLineTime() throws Exception {
		SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
		String time = "05:00:00";

		Date date = new Date();
		String newDate = format.format(date);
		Date newDate1 = format.parse(newDate);
		Date newDate2 = format.parse(time);
		// 比较时间大小
		if (newDate1.compareTo(newDate2) == 1 || newDate1.compareTo(newDate2) == 0) {
			// 大于等于5点，记账日期为当天日期
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			String resultDate = sdf.format(date);
			return resultDate;
		} else {
			// 小于5点，记账日期为前一天日期
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			Calendar calendar = Calendar.getInstance();
			calendar.setTime(date);
			calendar.add(Calendar.DAY_OF_MONTH, -1);
			date = calendar.getTime();
			String resultDate = sdf.format(date);
			return resultDate;
		}
	}

	public ServiceResponse doUpdates(ServiceSession session, JSONObject paramsObject) throws Exception {
		logger.info("doUpdates=="+JSONObject.toJSONString(paramsObject));
		String netType = "0";
		if (hazelcast||localcache) {//本地缓存状态一个为true就是脱机
			netType = "1";
		}
		Syjmain syjmain = new Syjmain();
		if (paramsObject.containsKey("mkt")) {
			syjmain.setMkt(paramsObject.getString("mkt"));
		}
		if (paramsObject.containsKey("syjh")) {
			syjmain.setSyjh(paramsObject.getString("syjh"));
		}
		if (paramsObject.containsKey("erpCode")) {
			syjmain.setErpCode(paramsObject.getString("erpCode"));
		}
		if (paramsObject.containsKey("syjcurinvje")) {
			syjmain.setSyjcurinvje(paramsObject.getBigDecimal("syjcurinvje"));
		}
		if (paramsObject.containsKey("syjcurcashje")) {
			syjmain.setSyjcurcashje(paramsObject.getBigDecimal("syjh"));
		}
		if (paramsObject.containsKey("syjcurinvbs")) {
			syjmain.setSyjcurinvbs(paramsObject.getLong("syjcurinvbs"));
		}
		if (paramsObject.containsKey("syjcurnum")) {
			syjmain.setSyjcurnum(paramsObject.getLong("syjcurnum"));
		}
		if (paramsObject.containsKey("syjcurstatus")) {
			syjmain.setSyjcurstatus(paramsObject.getString("syjcurstatus"));
		}
		if (paramsObject.containsKey("syjcursyyh")) {
			syjmain.setSyjcursyyh(paramsObject.getString("syjcursyyh"));
		}

		long ph_key;
		paramsObject.put("syjcurtime", new Date());
		boolean flag = syjmainRemoteService.updateByMKTAndSYJH(syjmain);
		logger.info("flag:"+flag);
		if (flag) {
			//从缓存中取系统参数
			String obj = redisUtil.get(RedisKey.CACHEID+paramsObject.get("mkt")+paramsObject.get("syjh"));
			ModeDetailsVo modeDetailsVo = JSONObject.parseObject(obj,ModeDetailsVo.class);
			// 获取收银机信息
			Syjmain syjMainData = modeDetailsVo.getSyjmain();

			String syjcursyyh = "";
			if (paramsObject.containsKey("syjcursyyh")) {
				syjcursyyh = paramsObject.getString("syjcursyyh");
			} else {
				syjcursyyh = syjMainData.getSyjcursyyh();
			}

			// 插入收银机日志
			JSONObject ob = new JSONObject();
			ob.put("mkt", paramsObject.get("mkt"));
			ob.put("erpCode", paramsObject.get("erpCode"));
			ob.put("syjh", paramsObject.get("syjh"));
			ob.put("syjcursyyh", syjcursyyh);
			ob.put("syjopentime", syjMainData.getSyjopentime());
			ob.put("syjcleartime", syjMainData.getSyjcleartime());
			ob.put("syjcurstatus", syjMainData.getSyjcurstatus());
			ob.put("syjcurtime", paramsObject.get("syjcurtime"));
			ob.put("syjcurinvbs", syjMainData.getSyjcurinvbs());
			ob.put("syjcurinvje", syjMainData.getSyjcurinvje());
			ob.put("syjcurcashje", syjMainData.getSyjcurcashje());
			ob.put("syjcurpreje", syjMainData.getSyjcurpreje());
			ob.put("syjcurnum", syjMainData.getSyjcurnum());
			// 录入备用金状态，更新收银机状态
			if (paramsObject.containsKey("insertprecashcount")) {
				ob.put("authsyyh", paramsObject.getString("authsyyh"));
				ob.put("status", paramsObject.get("cashlog_status"));
				ob.put("accountDate", paramsObject.get("accountDate"));
				ob.put("syjcurpreje", paramsObject.get("cashje"));
				ob.put("insertprecashcount", syjMainData.getInsertprecashcount());
				// 插入工作日志
				JSONObject worklog = new JSONObject();
				worklog.put("erpCode", paramsObject.get("erpCode"));
				worklog.put("mkt", paramsObject.get("mkt"));
				worklog.put("syjh", paramsObject.get("syjh"));
				worklog.put("syyh", syjcursyyh);
				worklog.put("rqsj", new Date());
				worklog.put("logtype", paramsObject.get("worklog_logtype"));
				worklog.put("logdesc", paramsObject.get("worklog_logdesc"));
				worklog.put("authorizeGh", paramsObject.getString("authsyyh"));

				if (paramsObject.containsKey("ph_key1")) {
					ob.put("ph_key", paramsObject.get("ph_key1"));
					worklog.put("ph_key", paramsObject.get("ph_key1"));
				} else {
					long ph_key1 = UniqueID.getUniqueID();
					ob.put("ph_key", ph_key1);
					worklog.put("ph_key", ph_key1);
				}
				SyjCashLogModel syjCashLogModel = JSONObject.parseObject(ob.toJSONString(), SyjCashLogModel.class);
				syjCashLogServiceImpl.saveEntity(syjCashLogModel);
				ph_key = syjCashLogModel.getPh_key();

				// 入金取消更新入金记录
				if (paramsObject.getString("cashflag").equals("2")) {
					syjCashLogServiceImpl.updateCash(paramsObject, ph_key);
					PosWorkAcountModel posWorkAcountModel = JSONObject.parseObject(worklog.toJSONString(), PosWorkAcountModel.class);
					posWorkAcountServiceImpl.saveEntity(posWorkAcountModel);
				}
				syjCashDetailServiceImpl.add(session, paramsObject, ph_key);
			} else {
				ob.put("status", "5");
				// 插入工作日志
				JSONObject worklog = new JSONObject();
				worklog.put("erpCode", paramsObject.get("erpCode"));
				worklog.put("mkt", paramsObject.get("mkt"));
				worklog.put("syjh", paramsObject.get("syjh"));
				worklog.put("syyh", syjcursyyh);
				worklog.put("rqsj", new Date());
				worklog.put("logtype", "4");
				worklog.put("logdesc", "更新收银机状态");
				worklog.put("entId", session.getEnt_id());
				PosWorkLogModel posWorkLogModel = JSONObject.parseObject(worklog.toJSONString(), PosWorkLogModel.class);
				//暂时不使用posworklog
				ph_key = 0;
			}

			JSONObject data = new JSONObject();
			data.put("syjcurstatus", syjMainData.getSyjcurstatus());
			data.put("netType", netType);
			data.put("ph_key", ph_key);
			Date startTime = paramsObject.getDate("startTime");
			Date endTime = new Date();
			logger.info("更新收银机状态netType:" + netType);
			logger.error("{更新收银机状态时间} -->" + (endTime.getTime() - startTime.getTime()));
			return ServiceResponse.buildSuccess(data);
		}

		logger.info("更新收银机状态netType:" + netType);
		return ServiceResponse.buildFailure(session, ResponseCode.FAILURE, "没有此收银机数据，更新失败");
	}


	public ServiceResponse update(ServiceSession session, JSONObject paramsObject) throws Exception {

		String mktcode = "";
		String syjhcode = "";
		if (paramsObject.containsKey("mkt")) {
			mktcode = paramsObject.getString("mkt");
		}
		if (paramsObject.containsKey("syjh")) {
			syjhcode = paramsObject.getString("syjh");
		}

		Date startTime = new Date();
		paramsObject.put("startTime", startTime);

		// 修改现金存量后要判断是否现金存量过量
		if (paramsObject.containsKey("syjcurcashje")) {

			// 现金存量超量限制，现金存量阔值限制,查询系统参数小票位数
			String obj = redisUtil.get(RedisKey.CACHEID + mktcode + syjhcode);
			ModeDetailsVo modeDetailsVo = JSONObject.parseObject(obj.toString(), ModeDetailsVo.class);
			paramsObject.put("sysobj", obj);

			List<Syspara> sysParaList = modeDetailsVo.getSyspara();
			JSONArray array = JSONArray.parseArray(JSON.toJSONString(sysParaList));

			String paravalue1 = "";// 现金存量参数值
			String paravalue2 = "";// 现金存量阀值参数值

			if (array.size() != 0) {
				for (int i = 0; i < array.size(); i++) {
					JSONObject sys = array.getJSONObject(i);
					if (sys.get("code").equals("4C")) {
						paravalue1 = sys.getString("paravalue");
					}
					if (sys.get("code").equals("4N")) {
						paravalue2 = sys.getString("paravalue");
					}
				}
			}

			BigDecimal syjcurcashje = paramsObject.getBigDecimal("syjcurcashje");
			BigDecimal cashjexz = new BigDecimal(paravalue1);

			// 当前门店未设置现金存量限制与阔值限制时,直接更新收银机
			if (paravalue1.equals("") && paravalue2.equals("")) {
				return this.doUpdates(session, paramsObject);
			}

			// 当前门店设置现金存量限制,未设置阔值限制时
			if (!paravalue1.equals("") && paravalue2.equals("")) {
				// 现金存量大于限制，“8” 警告提醒
				if (1 == syjcurcashje.compareTo(cashjexz)) {
					paramsObject.put("syjcurstatus", "8");
					return this.doUpdates(session, paramsObject);
				}
				return this.doUpdates(session, paramsObject);
			}

			// 当前门店未设置现金存量限制,设置阔值限制时
			if (paravalue1.equals("") && !paravalue2.equals("")) {
				if (!"Y".equals(paravalue2)) {
					BigDecimal isSale = new BigDecimal(paravalue2.split(",")[1]);
					if (1 == syjcurcashje.compareTo(isSale)) {
						// "0" 超出参数阈值 , 不可销售
						paramsObject.put("syjcurstatus", "0");
						return this.doUpdates(session, paramsObject);
					}
				}
				return this.doUpdates(session, paramsObject);
			}
			// 当前门店设置现金存量限制与阔值限制时
			else {
				// 先与阀值比较判断，如果超出了直接为不可销售
				if (!"Y".equals(paravalue2)) {
					BigDecimal isSale = new BigDecimal(paravalue2.split(",")[1]);
					if (1 == syjcurcashje.compareTo(isSale)) {
						// "0" 超出参数阈值 , 不可销售
						paramsObject.put("syjcurstatus", "0");
						return this.doUpdates(session, paramsObject);
					}
				}
				// 与现金存量限制比较判断
				if (1 == syjcurcashje.compareTo(cashjexz)) {
					paramsObject.put("syjcurstatus", "8");
					return this.doUpdates(session, paramsObject);
				}
				return this.doUpdates(session, paramsObject);

			}

		}

		if (paramsObject.containsKey("syjcurstatus")) {

			JSONObject worklog = new JSONObject();
			worklog.put("erpCode", paramsObject.get("erpCode"));
			worklog.put("mkt", paramsObject.get("mkt"));
			worklog.put("syjh", paramsObject.get("syjh"));
			worklog.put("syyh", paramsObject.get("syjcursyyh"));
			worklog.put("rqsj", new Date());
			worklog.put("entId", session.getEnt_id());

			// 关机清收营员号
			if (paramsObject.get("syjcurstatus").equals("5")) {
				// 插入工作日志
				worklog.put("logtype", "13");
				worklog.put("logdesc", "收银员关机");
				PosWorkLogModel posWorkLogModel = JSONObject.parseObject(worklog.toJSONString(), PosWorkLogModel.class);
				//暂时不使用posworklog
				// posWorkLogServiceImpl.saveEntity(posWorkLogModel);
				// 清空工号
				paramsObject.put("syjcursyyh", "");
				return this.doUpdates(session, paramsObject);
			}

			String status = paramsObject.getString("syjcurstatus");

			if (status.equals("4")) {
				// 插入工作日志
				worklog.put("logtype", "6");
				worklog.put("logdesc", "收银员离开");
				PosWorkLogModel posWorkLogModel = JSONObject.parseObject(worklog.toJSONString(), PosWorkLogModel.class);
				//暂时不使用posworklog
				//posWorkLogServiceImpl.saveEntity(posWorkLogModel);
			}
			if (status.equals("3")) {
				// 插入工作日志
				worklog.put("logtype", "19");
				worklog.put("logdesc", "收银机主动脱网");
				PosWorkLogModel posWorkLogModel = JSONObject.parseObject(worklog.toJSONString(), PosWorkLogModel.class);
				//暂时不使用posworklog
				//posWorkLogServiceImpl.saveEntity(posWorkLogModel);
			}
		}

		return this.doUpdates(session, paramsObject);

	}

	/***
	 * 收银机心跳
	 *
	 * @param session
	 * @param paramsObject
	 * @return
	 * @throws Exception
	 */
	public ServiceResponse doUpdate(ServiceSession session, JSONObject paramsObject) throws Exception {

		SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
		String time1 = "02:00:00";
		String time2 = "02:30:00";

		Date date = new Date();
		String newDate = format.format(date);
		Date newDate1 = format.parse(newDate);
		Date newDate2 = format.parse(time1);
		Date newDate3 = format.parse(time2);
		logger.info("nowDate:" + newDate1);
		logger.info("newDate1:" + newDate2);
		logger.info("newDate2:" + newDate3);

		String netType = "0";
		if (hazelcast||localcache) {//本地缓存状态一个为true就是脱机
			netType = "1";
		}
		// 比较时间大小,两点到两点半之间不心跳
		if (newDate1.compareTo(newDate2) == -1 || newDate1.compareTo(newDate3) == 1) {

			Syjmain syjmain = new Syjmain();
			if (paramsObject.containsKey("mkt")) {
				syjmain.setMkt(paramsObject.getString("mkt"));
			}
			if (paramsObject.containsKey("syjh")) {
				syjmain.setSyjh(paramsObject.getString("syjh"));
			}
			if (paramsObject.containsKey("erpCode")) {
				syjmain.setErpCode(paramsObject.getString("erpCode"));
			}
			if (paramsObject.containsKey("syjcurinvje")) {
				syjmain.setSyjcurinvje(paramsObject.getBigDecimal("syjcurinvje"));
			}
			if (paramsObject.containsKey("syjcurcashje")) {
				syjmain.setSyjcurcashje(paramsObject.getBigDecimal("syjh"));
			}
			if (paramsObject.containsKey("syjcurinvbs")) {
				syjmain.setSyjcurinvbs(paramsObject.getLong("syjcurinvbs"));
			}
			if (paramsObject.containsKey("syjcurnum")) {
				syjmain.setSyjcurnum(paramsObject.getLong("syjcurnum"));
			}
			if (paramsObject.containsKey("syjcurstatus")) {
				syjmain.setSyjcurstatus(paramsObject.getString("syjcurstatus"));
			}
			if (paramsObject.containsKey("syjcursyyh")) {
				syjmain.setSyjcursyyh(paramsObject.getString("syjcursyyh"));
			}

			paramsObject.put("syjcurtime", new Date());
			boolean flag = syjmainRemoteService.updateByMKTAndSYJH(syjmain);

			if (flag) {
				// 查询款机未接收的消息
				JSONObject object = new JSONObject();
				object.put("erpCode", paramsObject.get("erpCode"));
				object.put("mkt", paramsObject.get("mkt"));
				object.put("syjh", paramsObject.get("syjh"));
				object.put("status", "N");
				object.put("statu", "1");

				List<PosNewsModel> list = posNewsServiceImpl.listByMap(object,"posnews");
				JSONArray jsonArray = JSONArray.parseArray(JSON.toJSONString(list));
				// 心跳返回消息
				JSONObject data = new JSONObject();
				data.put("posnews", jsonArray);
				data.put("command_id", paramsObject.getString("command_id"));
				data.put("netType", netType);
				logger.info("心跳netType:" + netType);
				return ServiceResponse.buildSuccess(data);
			} else {
				JSONObject data = new JSONObject();
				data.put("command_id", paramsObject.getString("command_id"));
				data.put("netType", netType);
				logger.info("心跳netType:" + netType);
				return ServiceResponse.buildSuccess(data);
			}
		} else {
			JSONObject data = new JSONObject();
			data.put("command_id", paramsObject.getString("command_id"));
			data.put("netType", netType);
			logger.info("心跳netType:" + netType);
			return ServiceResponse.buildSuccess(data);
		}

	}

	/**
	 * 收银员登出接口
	 *
	 * @param session
	 * @param paramsObject {mkt syjh}
	 * @return
	 * @throws Exception
	 */
	public ServiceResponse syyLoginOut(ServiceSession session, JSONObject paramsObject) {

		//从缓存中取系统参数
		String obj = redisUtil.get(RedisKey.CACHEID+paramsObject.getString("mkt")+paramsObject.getString("syjh"));
		ModeDetailsVo modeDetailsVo = JSONObject.parseObject(obj.toString(),ModeDetailsVo.class);

		// 获取收银机信息
		Syjmain syjMainData = modeDetailsVo.getSyjmain();

		if (syjMainData == null) {
			return ServiceResponse.buildFailure(session, ResponseCode.FAILURE, "找不到该收银机信息");
		}

		long ph_key = 0;

		ph_key = syjMainData.getPhKey();
		String erpCode = syjMainData.getErpCode();
		String mkt =syjMainData.getMkt();
		String syjh = syjMainData.getSyjh();
		String syjcursyyh = "";
		if (!paramsObject.containsKey("syjcursyyh")) {
			syjcursyyh = syjMainData.getSyjcursyyh();
		} else {
			syjcursyyh = paramsObject.getString("syjcursyyh");
		}
		BigDecimal syjcurcashje = syjMainData.getSyjcurcashje();
		BigDecimal syjcurpreje = syjMainData.getSyjcurpreje();
		long insertprecashcount = syjMainData.getInsertprecashcount();
		long syjpaycount = syjMainData.getSyjpaycount();

		//收银机参数syspara从缓存中取

		List<Syspara> sysparaData  = modeDetailsVo.getSyspara();

		if (sysparaData.size()==0) {
			// 修改收银机状态
			syjMainData.setSyjcurstatus("7");
			syjMainData.setSyjcurtime(new Date());
			syjMainData.setSyjcursyyh("");
			boolean flag = syjmainRemoteService.updateSyjmain(syjMainData);

			// 登出解绑临时卡
			// JSONObject ob = new JSONObject();
			// ob.put("erpCode", paramsObject.get("erpCode"));
			// ob.put("mkt", paramsObject.get("mkt"));
			// ob.put("gh", syjcursyyh);
			// ob.put("statu", 0);
			// template.getSqlSessionTemplate().update("com.demo.dao.TempCardRelationModelMapper.updateBycardno",
			// ob);

			// 插入工作日志 posworklog暂时屏蔽不用
/*			JSONObject worklog = new JSONObject();
			worklog.put("erpCode", paramsObject.get("erpCode"));
			worklog.put("mkt", paramsObject.get("mkt"));
			worklog.put("syjh", paramsObject.get("syjh"));
			worklog.put("syyh", syjcursyyh);
			worklog.put("rqsj", new Date());
			worklog.put("logtype", "5");
			worklog.put("logdesc", "收银员登出");
			worklog.put("entId", session.getEnt_id());
			posWorkLogServiceImpl.onInsert(session, worklog);*/

		}
		if (sysparaData.size()!=0) {

			String paravalue = null;
			// 当前门店未设置现金存量跟谁默认跟机
			if (StringUtils.isNotBlank(sysparaData.get(0).getParavalue())) {
				// 修改收银机状态
				syjMainData.setSyjcurstatus("7");
				syjMainData.setSyjcurtime(new Date());
				syjMainData.setSyjcursyyh("");
				boolean flag = syjmainRemoteService.updateSyjmain(syjMainData);

				// 插入工作日志 posworklog暂时不用
/*				JSONObject worklog = new JSONObject();
				worklog.put("erpCode", paramsObject.get("erpCode"));
				worklog.put("mkt", paramsObject.get("mkt"));
				worklog.put("syjh", paramsObject.get("syjh"));
				worklog.put("syyh", syjcursyyh);
				worklog.put("rqsj", new Date());
				worklog.put("logtype", "5");
				worklog.put("logdesc", "收银员登出");
				worklog.put("entId", session.getEnt_id());
				posWorkLogServiceImpl.onInsert(session, worklog);*/
			}
			paravalue = sysparaData.get(0).getParavalue();
			// 当前门店设置现金存量跟人
			if (paravalue.equals("0")) {
				// 清空收营员号，现金存量，备用金
				syjMainData.setPhKey(paramsObject.getLong("ph_key"));
				syjMainData.setSyjcurstatus("7");
				syjMainData.setSyjcurtime(new Date());
				syjMainData.setSyjcursyyh("");
				syjMainData.setSyjcurcashje(BigDecimal.ZERO);
				syjMainData.setSyjcurpreje(BigDecimal.ZERO);
				syjMainData.setInsertprecashcount((long) 0);
				syjMainData.setSyjpaycount((long) 0);
				boolean flag = syjmainRemoteService.updateSyjmain(syjMainData);

				// 临时备用金表插入数据
				// 如果当前收银机现金存量为0，则不插临时表；不为0时，先查临时表，有数据则覆盖，无数据则插入
				if (syjcurcashje.compareTo(BigDecimal.ZERO) != 0) {
					CashierMoneyRecordModel cashiermodel = new CashierMoneyRecordModel();
					cashiermodel.setEntId(session.getEnt_id());
					cashiermodel.setErpCode(erpCode);
					cashiermodel.setMkt(mkt);
					cashiermodel.setCashierNo(syjcursyyh);
					cashiermodel.setSyjh(syjh);
					cashiermodel.setSyjCashCurNum(syjcurcashje);
					cashiermodel.setCreateDate(new Date());
					cashiermodel.setCreator(syjcursyyh);
					cashiermodel.setPreMoney(syjcurpreje);
					cashiermodel.setPreMoneyCount(insertprecashcount);
					cashiermodel.setSyjPayCount(syjpaycount);

					QueryWrapper<CashierMoneyRecordModel> cwrapper = new QueryWrapper<>();
					cwrapper.eq("syjh",syjh)
							.eq("mkt",mkt)
							.eq("erpCode",erpCode)
							.eq("cashierNo",syjcursyyh);
					long count = cashierMoneyRecordService.count(cwrapper);

					if (count > 0) {
						cashierMoneyRecordService.updateCashierMoneyRecord(cashiermodel);
					}
				}

				// 插入工作日志 posworklog暂时不用
/*				JSONObject worklog = new JSONObject();
				worklog.put("erpCode", paramsObject.get("erpCode"));
				worklog.put("mkt", paramsObject.get("mkt"));
				worklog.put("syjh", paramsObject.get("syjh"));
				worklog.put("syyh", syjcursyyh);
				worklog.put("rqsj", new Date());
				worklog.put("logtype", "5");
				worklog.put("logdesc", "收银员登出");
				worklog.put("entId", session.getEnt_id());
				posWorkLogServiceImpl.onInsert(session, worklog);*/

			}
			// 当前门店设置现金存量跟机
			else {
				// 修改收银机状态
				syjMainData.setSyjcurstatus("7");
				syjMainData.setSyjcurtime(new Date());
				syjMainData.setSyjcursyyh("");
				boolean flag = syjmainRemoteService.updateSyjmain(syjMainData);

				// 插入工作日志 暂时不用
/*				JSONObject worklog = new JSONObject();
				worklog.put("erpCode", paramsObject.get("erpCode"));
				worklog.put("mkt", paramsObject.get("mkt"));
				worklog.put("syjh", paramsObject.get("syjh"));
				worklog.put("syyh", syjcursyyh);
				worklog.put("rqsj", new Date());
				worklog.put("logtype", "5");
				worklog.put("logdesc", "收银员登出");
				worklog.put("entId", session.getEnt_id());
				posWorkLogServiceImpl.onInsert(session, worklog);*/
			}

		}

		// 插入收银机日志
		SyjMainLogModel syjMainLogModel = new SyjMainLogModel();
		long ph_key1 = UniqueID.getUniqueID();
		syjMainLogModel.setPh_key(ph_key1);
		syjMainLogModel.setMkt(mkt);
		syjMainLogModel.setErpCode(erpCode);
		syjMainLogModel.setSyjh(syjh);
		syjMainLogModel.setSyjcursyyh(syjcursyyh);
		syjMainLogModel.setSyjopentime(syjMainData.getSyjopentime());
		syjMainLogModel.setSyjcurstatus(syjMainData.getSyjcurstatus());
		syjMainLogModel.setSyjcurtime(syjMainData.getSyjcurtime());
		syjMainLogModel.setSyjcurinvbs(syjMainData.getSyjcurinvbs());
		syjMainLogModel.setSyjcurinvje(syjMainData.getSyjcurinvje());
		syjMainLogModel.setSyjcurcashje(syjcurcashje);
		syjMainLogModel.setSyjcurpreje(syjcurpreje);
		syjMainLogModel.setSyjcurnum(syjMainData.getSyjcurnum());
		syjMainLogModel.setStatus("7");
		syjMainLogModel.setInsertprecashcount(insertprecashcount);
		syjMainLogModel.setSyjpaycount(syjpaycount);
		syjMainLogService.saveEntity(syjMainLogModel);

		JSONObject retdata = new JSONObject();
		retdata.put("ph_key", ph_key);
		return ServiceResponse.buildSuccess(retdata);
	}

	/**
	 * 扫描员登出接口
	 *
	 * @param session
	 * @param paramsObject {mkt syjh}
	 * @return
	 * @throws Exception
	 */
	public ServiceResponse smyLoginOut(ServiceSession session, JSONObject paramsObject) {
		//从缓存中取系统参数
		String obj = redisUtil.get(RedisKey.CACHEID+paramsObject.getString("mkt")+paramsObject.getString("syjh"));
		ModeDetailsVo modeDetailsVo = JSONObject.parseObject(obj.toString(), ModeDetailsVo.class);

		// 获取收银机信息
		Syjmain syjMainData = modeDetailsVo.getSyjmain();

		if (syjMainData == null) {
			return ServiceResponse.buildFailure(session, ResponseCode.FAILURE, "找不到该收银机信息");
		}
		long ph_key = syjMainData.getPhKey();
		String erpCode = syjMainData.getErpCode();
		String mkt = syjMainData.getMkt();
		String syjh = syjMainData.getSyjh();

		String syjcursmy ="";
		if (!paramsObject.containsKey("syjcursmy")) {
			syjcursmy = syjMainData.getSyjcursmy();
		} else {
			syjcursmy = paramsObject.getString("syjcursmy");
		}

		// 修改收银机状态
		syjMainData.setSyjcursmy("");
		syjMainData.setSyjcurtime(new Date());
		boolean flag = syjmainRemoteService.updateSyjmain(syjMainData);

		// 插入工作日志posworklog暂时不用
/*
		JSONObject worklog = new JSONObject();
		worklog.put("erpCode", paramsObject.get("erpCode"));
		worklog.put("mkt", paramsObject.get("mkt"));
		worklog.put("syjh", paramsObject.get("syjh"));
		worklog.put("syyh", syjcursmy);
		worklog.put("rqsj", new Date());
		worklog.put("logtype", "5");
		worklog.put("logdesc", "扫描员登出");
		worklog.put("entId", session.getEnt_id());
		posWorkLogServiceImpl.onInsert(session, worklog);
*/

		JSONObject retdata = new JSONObject();
		retdata.put("ph_key", ph_key);
		return ServiceResponse.buildSuccess(retdata);
	}

	public RespBase syjClose(ServiceSession session, JSONObject paramsObject){
		//从缓存中取系统参数
		String obj = redisUtil.get(RedisKey.CACHEID+paramsObject.getString("mkt")+paramsObject.getString("syjh"));
		ModeDetailsVo modeDetailsVo = JSONObject.parseObject(obj.toString(), ModeDetailsVo.class);

		// 获取收银机信息
		Syjmain syjMainData = modeDetailsVo.getSyjmain();

		if (syjMainData == null) {
			return new RespBase(-1,"找不到该收银机信息");
		}

		long ph_key = 0;
		ph_key = syjMainData.getPhKey();
		String erpCode = syjMainData.getErpCode();
		String mkt = syjMainData.getMkt();
		String syjh = syjMainData.getSyjh();
		String syjcursyyh = "";
		if (paramsObject.containsKey("syjcursyyh")) {
			syjcursyyh = paramsObject.getString("syjcursyyh");
		} else {
			syjcursyyh = syjMainData.getSyjcursyyh();
		}
		BigDecimal syjcurcashje = syjMainData.getSyjcurcashje();
		BigDecimal syjcurpreje = syjMainData.getSyjcurpreje();
		long insertprecashcount = syjMainData.getInsertprecashcount();
		long syjpaycount = syjMainData.getSyjpaycount();

		// 获取收银机信息
		List<Syspara> sysparaList = modeDetailsVo.getSyspara();

		// 清机后退出系统解绑临时卡
		JSONObject b = new JSONObject();
		b.put("erpCode", paramsObject.get("erpCode"));
		b.put("mkt", paramsObject.get("mkt"));
		b.put("syjh", paramsObject.get("syjh"));
		b.put("syjcursyyh", syjcursyyh);
		Date today = new Date();
		b.put("today", DateUtils.formatDateTime(today));

		int syjClearCount = syjMainLogService.getPosClearCount(b);

		if (sysparaList.size() == 0) {
			// 修改收银机状态
			syjMainData.setSyjcurstatus("5");
			syjMainData.setSyjcurtime(new Date());
			syjMainData.setSyjcursyyh("");
			boolean flag = syjmainRemoteService.updateSyjmain(syjMainData);

			// 退出系统解绑临时卡
			if (syjClearCount != 0) {
				Tempcardrelation tempcardrelation = new Tempcardrelation();
				tempcardrelation.setErpCode(paramsObject.getString("erpCode"));
				tempcardrelation.setMkt(paramsObject.getString("mkt"));
				tempcardrelation.setGh(syjcursyyh);
				tempcardrelation.setStatu(0);
				tempCardRelationRemoteService.updateBycardno(tempcardrelation);
			}

			// 插入收银机日志
			SyjMainLogModel syjMainLogModel = new SyjMainLogModel();
			syjMainLogModel.setMkt(mkt);
			syjMainLogModel.setErpCode(erpCode);
			syjMainLogModel.setSyjh(syjh);
			syjMainLogModel.setSyjcursyyh(syjcursyyh);
			syjMainLogModel.setSyjopentime(syjMainData.getSyjopentime());
			syjMainLogModel.setSyjcleartime(syjMainData.getSyjcleartime());
			syjMainLogModel.setSyjcurstatus(syjMainData.getSyjcurstatus());
			syjMainLogModel.setSyjcurtime(syjMainData.getSyjcurtime());
			syjMainLogModel.setSyjcurinvbs(syjMainData.getSyjcurinvbs());
			syjMainLogModel.setSyjcurinvje(syjMainData.getSyjcurinvje());
			syjMainLogModel.setSyjcurcashje(syjcurcashje);
			syjMainLogModel.setSyjcurpreje(syjcurpreje);
			syjMainLogModel.setSyjcurnum(syjMainData.getSyjcurnum());
			syjMainLogModel.setStatus("9");
			syjMainLogModel.setInsertprecashcount(insertprecashcount);
			syjMainLogModel.setSyjpaycount(syjpaycount);
			syjMainLogService.saveEntity(syjMainLogModel);

			// 插入工作日志
/*			JSONObject worklog = new JSONObject();
			worklog.put("erpCode", paramsObject.get("erpCode"));
			worklog.put("mkt", paramsObject.get("mkt"));
			worklog.put("syjh", paramsObject.get("syjh"));
			worklog.put("syyh", syjcursyyh);
			worklog.put("rqsj", new Date());
			worklog.put("logtype", "13");
			worklog.put("logdesc", "收银机关机");
			worklog.put("entId", session.getEnt_id());
			posWorkLogServiceImpl.onInsert(session, worklog);*/

		}

		String paravalue = null;

		// 当前门店未设置现金存量跟谁默认跟机
		if (StringUtils.isNotBlank(sysparaList.get(0).getParavalue())) {
			// 修改收银机状态
			syjMainData.setSyjcurstatus("5");
			syjMainData.setSyjcurtime(new Date());
			syjMainData.setSyjcursyyh("");
			boolean flag = syjmainRemoteService.updateSyjmain(syjMainData);

			// 退出系统解绑临时卡
			if (syjClearCount != 0) {
				Tempcardrelation tempcardrelation = new Tempcardrelation();
				tempcardrelation.setErpCode(paramsObject.getString("erpCode"));
				tempcardrelation.setMkt(paramsObject.getString("mkt"));
				tempcardrelation.setGh(syjcursyyh);
				tempcardrelation.setStatu(0);
				tempCardRelationRemoteService.updateBycardno(tempcardrelation);
			}

			// 插入收银机日志
			SyjMainLogModel syjMainLogModel = new SyjMainLogModel();
			syjMainLogModel.setMkt(mkt);
			syjMainLogModel.setErpCode(erpCode);
			syjMainLogModel.setSyjh(syjh);
			syjMainLogModel.setSyjcursyyh(syjcursyyh);
			syjMainLogModel.setSyjopentime(syjMainData.getSyjopentime());
			syjMainLogModel.setSyjcleartime(syjMainData.getSyjcleartime());
			syjMainLogModel.setSyjcurstatus(syjMainData.getSyjcurstatus());
			syjMainLogModel.setSyjcurtime(syjMainData.getSyjcurtime());
			syjMainLogModel.setSyjcurinvbs(syjMainData.getSyjcurinvbs());
			syjMainLogModel.setSyjcurinvje(syjMainData.getSyjcurinvje());
			syjMainLogModel.setSyjcurcashje(syjcurcashje);
			syjMainLogModel.setSyjcurpreje(syjcurpreje);
			syjMainLogModel.setSyjcurnum(syjMainData.getSyjcurnum());
			syjMainLogModel.setStatus("9");
			syjMainLogModel.setInsertprecashcount(insertprecashcount);
			syjMainLogModel.setSyjpaycount(syjpaycount);
			syjMainLogService.saveEntity(syjMainLogModel);

			// 插入工作日志
/*			JSONObject worklog = new JSONObject();
			worklog.put("erpCode", paramsObject.get("erpCode"));
			worklog.put("mkt", paramsObject.get("mkt"));
			worklog.put("syjh", paramsObject.get("syjh"));
			worklog.put("syyh", syjcursyyh);
			worklog.put("rqsj", new Date());
			worklog.put("logtype", "13");
			worklog.put("logdesc", "收银机关机");
			worklog.put("entId", session.getEnt_id());
			posWorkLogServiceImpl.onInsert(session, worklog);*/
		}
		paravalue = sysparaList.get(0).getParavalue();
		// 当前门店设置现金存量跟人
		if (paravalue.equals("0")) {
			// 清空收营员号，现金存量，备用金
			Syjmain syjmain = new Syjmain();
			syjmain.setPhKey(ph_key);
			syjmain.setSyjcursyyh("");
			syjmain.setSyjcurcashje(BigDecimal.ZERO);
			syjmain.setSyjcurpreje(BigDecimal.ZERO);
			syjmain.setSyjcurstatus("5");
			syjmain.setSyjcurtime(new Date());
			syjmain.setInsertprecashcount(Long.valueOf(0));
			syjmain.setSyjpaycount(Long.valueOf(0));

			boolean flag = syjmainRemoteService.updateSyjmain(syjMainData);


			// 临时备用金表插入数据
			// 如果当前收银机现金存量为0，则不插临时表；不为0时，先查临时表，有数据则覆盖，无数据则插入
			if (syjcurcashje.compareTo(BigDecimal.ZERO) != 0) {
				CashierMoneyRecordModel cashiermodel = new CashierMoneyRecordModel();
				cashiermodel.setEntId(session.getEnt_id());
				cashiermodel.setErpCode(erpCode);
				cashiermodel.setMkt(mkt);
				cashiermodel.setCashierNo(syjcursyyh);
				cashiermodel.setSyjh(syjh);
				cashiermodel.setSyjCashCurNum(syjcurcashje);
				cashiermodel.setCreateDate(new Date());
				cashiermodel.setCreator(syjcursyyh);
				cashiermodel.setPreMoney(syjcurpreje);
				cashiermodel.setPreMoneyCount(insertprecashcount);
				cashiermodel.setSyjPayCount(syjpaycount);

				QueryWrapper<CashierMoneyRecordModel> cwrapper = new QueryWrapper<>();
				cwrapper.eq("syjh",syjh)
						.eq("mkt",mkt)
						.eq("erpCode",erpCode)
						.eq("cashierNo",syjcursyyh);
				long count = cashierMoneyRecordService.count(cwrapper);

				if (count > 0) {
					cashierMoneyRecordService.updateCashierMoneyRecord(cashiermodel);
				}
			}
			// 清机后退出系统解绑临时卡

			if (syjClearCount != 0) {
				Tempcardrelation tempcardrelation = new Tempcardrelation();
				tempcardrelation.setErpCode(paramsObject.getString("erpCode"));
				tempcardrelation.setMkt(paramsObject.getString("mkt"));
				tempcardrelation.setGh(syjcursyyh);
				tempcardrelation.setStatu(0);
				tempCardRelationRemoteService.updateBycardno(tempcardrelation);
			}

		}
		// 当前门店设置现金存量跟机
		else {

			// 修改收银机状态
			syjMainData.setPhKey(ph_key);
			syjMainData.setSyjcurstatus("5");
			syjMainData.setSyjcurtime(new Date());
			syjMainData.setSyjcursyyh("");
			boolean flag = syjmainRemoteService.updateSyjmain(syjMainData);

			// 退出系统解绑临时卡
			if (syjClearCount != 0) {
				Tempcardrelation tempcardrelation = new Tempcardrelation();
				tempcardrelation.setErpCode(paramsObject.getString("erpCode"));
				tempcardrelation.setMkt(paramsObject.getString("mkt"));
				tempcardrelation.setGh(syjcursyyh);
				tempcardrelation.setStatu(0);
				tempCardRelationRemoteService.updateBycardno(tempcardrelation);
			}

		}

		// 插入收银机日志
		SyjMainLogModel syjMainLogModel = new SyjMainLogModel();
		syjMainLogModel.setMkt(mkt);
		syjMainLogModel.setErpCode(erpCode);
		syjMainLogModel.setSyjh(syjh);
		syjMainLogModel.setSyjcursyyh(syjcursyyh);
		syjMainLogModel.setSyjopentime(syjMainData.getSyjopentime());
		syjMainLogModel.setSyjcleartime(syjMainData.getSyjcleartime());
		syjMainLogModel.setSyjcurstatus(syjMainData.getSyjcurstatus());
		syjMainLogModel.setSyjcurtime(syjMainData.getSyjcurtime());
		syjMainLogModel.setSyjcurinvbs(syjMainData.getSyjcurinvbs());
		syjMainLogModel.setSyjcurinvje(syjMainData.getSyjcurinvje());
		syjMainLogModel.setSyjcurcashje(syjcurcashje);
		syjMainLogModel.setSyjcurpreje(syjcurpreje);
		syjMainLogModel.setSyjcurnum(syjMainData.getSyjcurnum());
		syjMainLogModel.setStatus("9");
		syjMainLogModel.setInsertprecashcount(insertprecashcount);
		syjMainLogModel.setSyjpaycount(syjpaycount);
		syjMainLogService.saveEntity(syjMainLogModel);

		// 插入工作日志
/*			JSONObject worklog = new JSONObject();
			worklog.put("erpCode", paramsObject.get("erpCode"));
			worklog.put("mkt", paramsObject.get("mkt"));
			worklog.put("syjh", paramsObject.get("syjh"));
			worklog.put("syyh", syjcursyyh);
			worklog.put("rqsj", new Date());
			worklog.put("logtype", "13");
			worklog.put("logdesc", "收银机关机");
			worklog.put("entId", session.getEnt_id());
			posWorkLogServiceImpl.onInsert(session, worklog);*/

		JSONObject retdata = new JSONObject();
		retdata.put("ph_key", ph_key);
		return new RespBase(Code.SUCCESS,retdata);
	}

	/**
	 * 收银机解锁（针对收银员离开后重新进入收银机）
	 *
	 * @param session
	 * @param paramsObject {mkt syjh}
	 * @return
	 * @throws Exception
	 */
	public RespBase posUnlock(ServiceSession session, JSONObject paramsObject){

		//从缓存中取系统参数
		String obj = redisUtil.get(RedisKey.CACHEID+paramsObject.getString("mkt")+paramsObject.getString("syjh"));
		ModeDetailsVo modeDetailsVo = JSONObject.parseObject(obj.toString(), ModeDetailsVo.class);
		Syjmain model = modeDetailsVo.getSyjmain();

		Long ph_key = model.getPhKey();
		String syjcursyyh = model.getSyjcursyyh();

		// 刷工卡解锁
		if (paramsObject.containsKey("cardno")) {
			QueryWrapper<OperUserModel> ouwrapper = new QueryWrapper<>();
			ouwrapper.eq("erpCode",paramsObject.getString("erpCode"))
					.eq("mkt",paramsObject.getString("mkt"))
					.eq("cardno",paramsObject.getString("cardno"));
			List<OperUserModel> list = operUserExpService.list(ouwrapper);

			if (list.size() != 0) {

				// 获取卡中的工号信息和收银机挂机工号做比对（同卡号数据库有多条数据取第一条）
				String gh = "";
				String authrole = "";
				for (OperUserModel map : list) {
					gh = (String) map.getGh();
					authrole = (String) map.getAuthrole();
					break;
				}

				// 工号比对正确直接解锁
				if (syjcursyyh.equals(gh)) {
					// 修改收银机状态
					model.setPhKey(ph_key);
					model.setSyjcurstatus("2");
					model.setSyjcurtime(new Date());
					model.setSyjcursyyh("");


					// 插入工作日志
					JSONObject worklog = new JSONObject();
					worklog.put("erpCode", paramsObject.get("erpCode"));
					worklog.put("mkt", paramsObject.get("mkt"));
					worklog.put("syjh", paramsObject.get("syjh"));
					worklog.put("syyh", syjcursyyh);
					worklog.put("rqsj", new Date());
					worklog.put("logtype", "7");
					worklog.put("logdesc", "收银机解锁");
					worklog.put("authorizeGh","");
					//worklog.put("entId", session.getEnt_id());
					/*posWorkLogServiceImpl.onInsert(session, worklog);*/
					PosWorkAcountModel posWorkAcountModel = JSONObject.parseObject(worklog.toJSONString(), PosWorkAcountModel.class);
					posWorkAcountServiceImpl.saveEntity(posWorkAcountModel);
					boolean flag = syjmainRemoteService.updateSyjmain(model);
					if(flag){
						return new RespBase(Code.SUCCESS,"解锁成功");
					}else {
						return new RespBase(-1,"解锁失败，修改收银机状态失败");
					}
				}

				// 该工卡未授权
				if (authrole == null || authrole.equals("")) {
					return new RespBase(-1,"该工卡不具备管理员权限，无法解锁该收银机");
				}
				// 工号比对不正确看权限
				Map<String,Object> map = new HashMap<>();
				map.put("roleid", authrole);
				List<Posrole> posroles = posRoleRemoteService.listByMap(map);
				String privqt1 = posroles.get(0).getPrivqt1();
				// 具备管理员权限即可解锁
				if (privqt1.equals("Y")) {
					// 修改收银机状态
					model.setPhKey(ph_key);
					model.setSyjcurstatus("2");
					model.setSyjcurtime(new Date());
					model.setSyjcursyyh("");

					// 插入工作日志
					JSONObject worklog = new JSONObject();
					worklog.put("erpCode", paramsObject.get("erpCode"));
					worklog.put("mkt", paramsObject.get("mkt"));
					worklog.put("syjh", paramsObject.get("syjh"));
					worklog.put("syyh", syjcursyyh);
					worklog.put("rqsj", new Date());
					worklog.put("logtype", "7");
					worklog.put("logdesc", "收银机解锁");
					worklog.put("entId", session.getEnt_id());
					worklog.put("authorizeGh",gh);
					//worklog.put("entId", session.getEnt_id());
					/*posWorkLogServiceImpl.onInsert(session, worklog);*/
					PosWorkAcountModel posWorkAcountModel = JSONObject.parseObject(worklog.toJSONString(), PosWorkAcountModel.class);
					posWorkAcountServiceImpl.saveEntity(posWorkAcountModel);
					boolean flag = syjmainRemoteService.updateSyjmain(model);
					if(flag){
						return new RespBase(Code.SUCCESS,"解锁成功");
					}else {
						return new RespBase(-1,"解锁失败，修改收银机状态失败");
					}
				}
				return new RespBase(-1,"该工卡信息不匹配且不具备管理员权限，无法解锁该收银机");
			}
			return new RespBase(-1,"門店下無此工號信息，无法解锁该收银机");
		}

		// 输入工号密码解锁
		String syyh = paramsObject.getString("syjcursyyh");

		QueryWrapper<OperUserModel> ouwrapper1 = new QueryWrapper<>();
		ouwrapper1.eq("erpCode",paramsObject.getString("erpCode"))
				.eq("mkt",paramsObject.getString("mkt"))
				.eq("gh",syyh);
 		List<OperUserModel> operUserModellist = operUserExpService.list(ouwrapper1,"operuser");

		// 获取工号信息和收银机挂机工号做比对（同卡号数据库有多条数据取第一条）
		if (operUserModellist.size() != 0) {
			String passwd = "";
			String authrole = "";
			for (OperUserModel map : operUserModellist) {
				passwd = (String) map.getPasswd();
				authrole = (String) map.getAuthrole();
				break;
			}

			// 输入工号与密码进行解锁
			String password = paramsObject.getString("passwd");
			password = MD5Utils.MD5(password);
			// 输入工号为收银机挂机工号且密码正确
			if (syjcursyyh.equals(syyh) && password.equals(passwd)) {
				// 修改收银机状态
				model.setPhKey(ph_key);
				model.setSyjcurstatus("2");
				model.setSyjcurtime(new Date());
				model.setSyjcursyyh("");

				// 插入工作日志
				JSONObject worklog = new JSONObject();
				worklog.put("erpCode", paramsObject.get("erpCode"));
				worklog.put("mkt", paramsObject.get("mkt"));
				worklog.put("syjh", paramsObject.get("syjh"));
				worklog.put("syyh", syjcursyyh);
				worklog.put("rqsj", new Date());
				worklog.put("logtype", "7");
				worklog.put("logdesc", "收银机解锁");
				worklog.put("entId", session.getEnt_id());
				worklog.put("authorizeGh","");
				/*posWorkLogServiceImpl.onInsert(session, worklog);*/
				PosWorkAcountModel posWorkAcountModel = JSONObject.parseObject(worklog.toJSONString(), PosWorkAcountModel.class);

				//中百版本没有posofflinedata.posworkacount表，屏蔽
				/*posWorkAcountServiceImpl.saveEntity(posWorkAcountModel);*/
				boolean flag = syjmainRemoteService.updateSyjmain(model);
				if(flag){
					return new RespBase(Code.SUCCESS,"解锁成功");
				}else {
					return new RespBase(-1,"解锁失败，修改收银机状态失败");
				}
			}
			// 输入工号为收银机挂机工号，密码不正确
			if (syjcursyyh.equals(syyh) && !password.equals(passwd)) {
				return new RespBase(-1,"该工号密码输入错误");
			}
			// 输入工号不是收银机挂机工号，密码不正确
			if (!syjcursyyh.equals(syyh) && !password.equals(passwd)) {
				return new RespBase(-1,"该工号密码输入错误");
			}
			// 该工号未授权
			if (authrole == null || authrole.equals("")) {
				return new RespBase(-1,"该工号不具备管理员权限，无法解锁该收银机");
			}

			// 输入工号不是收银机挂机工号，密码正确，则判断权限
			if (!syjcursyyh.equals(syyh) && password.equals(passwd)) {
				Map<String,Object> map = new HashMap<>();
				map.put("roleid", authrole);
				List<Posrole> posroles = posRoleRemoteService.listByMap(map);
				String privqt1 = posroles.get(0).getPrivqt1();
				// 具备管理员权限即可解锁
				if (privqt1.equals("Y")) {
					// 修改收银机状态
					model.setPhKey(ph_key);
					model.setSyjcurstatus("2");
					model.setSyjcurtime(new Date());
					model.setSyjcursyyh("");

					// 插入工作日志
					JSONObject worklog = new JSONObject();
					worklog.put("erpCode", paramsObject.get("erpCode"));
					worklog.put("mkt", paramsObject.get("mkt"));
					worklog.put("syjh", paramsObject.get("syjh"));
					worklog.put("syyh",syjcursyyh);
					worklog.put("rqsj", new Date());
					worklog.put("logtype", "7");
					worklog.put("logdesc", "收银机解锁");
					worklog.put("entId", session.getEnt_id());
					worklog.put("authorizeGh",syyh);
					/*posWorkLogServiceImpl.onInsert(session, worklog);*/
					PosWorkAcountModel posWorkAcountModel = JSONObject.parseObject(worklog.toJSONString(), PosWorkAcountModel.class);
					//中百版本没有posofflinedata.posworkacount表，屏蔽
					/*posWorkAcountServiceImpl.saveEntity(posWorkAcountModel);*/
					boolean flag = syjmainRemoteService.updateSyjmain(model);
					if(flag){
						return new RespBase(Code.SUCCESS,"解锁成功");
					}else {
						return new RespBase(-1,"解锁失败，修改收银机状态失败");
					}
				}
				return new RespBase(-1,"该工号密码输入错误或该工号不具备管理员权限无法解锁收银机");
			}

		}
		return new RespBase(-1,"该工号密码输入错误或该工号不具备管理员权限无法解锁收银机");
	}


}


