package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.HessianService;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.constant.FunctionSoaUrl;
import com.efuture.business.model.SyjMainLogModel;
import com.efuture.business.service.SyjMainLogRemoteService;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;


@Slf4j
@HessianService(value = FunctionSoaUrl.SYJMAINLOG_SERVICE_URL, interf = SyjMainLogRemoteService.class)
@Service
public class SyjMainLogRemoteServiceImpl implements SyjMainLogRemoteService {
    @Autowired
    SyjMainLogServiceImpl syjMainLogServiceImpl;

    @Override
    public long getMaxPreCount(JSONObject jsonObject) {
        return syjMainLogServiceImpl.getMaxPreCount(jsonObject);
    }

    @Override
    public int saveEntity(JSONObject jsonObject) {
        return syjMainLogServiceImpl.saveEntity(JSONObject.toJavaObject(jsonObject, SyjMainLogModel.class));
    }
    @Override
    public String getCashList(JSONObject param) {
        JSONObject j =new JSONObject();
        j.put("ph_key",Long.valueOf(param.getString("ph_key")));
        return JSON.toJSONString(syjMainLogServiceImpl.listByMap(j,"syjmainlog"));
    }
    @Override
    public BigDecimal getTotalPreje(JSONObject jsonObject) {
        return syjMainLogServiceImpl.getTotalPreje(jsonObject);
    }

    @Override
    public BigDecimal getTotalPay(JSONObject jsonObject) {
        return syjMainLogServiceImpl.getTotalPay(jsonObject);
    }

    @Override
    public RespBase getTemporaryPayLog(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        try {
            ServiceResponse response = syjMainLogServiceImpl.getTemporaryPayLog(session,jsonObject);

            if("0".equals(response.getReturncode())){
                return new RespBase(Code.SUCCESS,response.getData(),"GETTEMPORARYPAYLOG");
            }else {
                return new RespBase(Code.FAIL,response.getData(),"GETTEMPORARYPAYLOG");
            }
        }catch (Exception e){
            return Code.FAIL.getRespBase("-1", e.getMessage());
        }
    }

    @Override
    public RespBase getInsertCashLog(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        log.info("getInsertCashLog==>"+jsonObject.toJSONString());
        try {
            ServiceResponse response = syjMainLogServiceImpl.getInsertCashLog(session,jsonObject);
            log.info("getInsertCashLog==>response:"+response.toString());
            if("0".equals(response.getReturncode())){
                return new RespBase(Code.SUCCESS,response.getData(),"GETINSERTCASHLOG");
            }else {
                return new RespBase(Code.FAIL,response.getData(),"GETINSERTCASHLOG");
            }
        }catch (Exception e){
            log.error(e.getMessage(),e);
            return Code.FAIL.getRespBase("-1", e.getMessage());
        }

    }

    @Override
    public RespBase insertCash(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        log.info("[{}]--[{}]入参->{}", jsonObject.getString("flowNo"), "入金", jsonObject.toJSONString());
        ServiceResponse response = syjMainLogServiceImpl.insertCash(session,jsonObject);
        log.info("[{}]--[{}]出参->{}", jsonObject.getString("flowNo"), "入金", JSONObject.toJSONString(response));
        if("0".equals(response.getReturncode())){
            return new RespBase(Code.SUCCESS,response.getData(),"PREMONEYCERTIFY");
        }else {
            return new RespBase(Code.FAIL,response.getData(),"PREMONEYCERTIFY");
        }
    }

}
