package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.mapper.SyjPreMoneyMapper;
import com.efuture.business.model.SyjPreMoneyModel;
import com.efuture.business.model.SyjPreMoneyOut;
import com.efuture.business.service.SyjPreMoneyService;
import com.efuture.business.util.db.DbTools;
import com.efuture.business.util.db.MultipleDataSource;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.Date;

@Service
public class SyjPreMoneyServiceImpl extends FunctionBaseServiceImpl<SyjPreMoneyMapper, SyjPreMoneyModel> implements SyjPreMoneyService {

	@Autowired
	private DbTools dbTools;

	/**
	 * 录入备用金
	 * @param session
	 * @param paramsObject
	 * @return
	 * @throws Exception
	 */
	@SuppressWarnings({ "unchecked" })
	public ServiceResponse insertPreMoney(ServiceSession session, JSONObject paramsObject) throws Exception {

		if ("Y".equals(GlobalInfo.centrally) && paramsObject.getString("mkt") !=null) {
			MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("syjpremoney", paramsObject.getString("mkt")));
		} else {
			MultipleDataSource.setDataSourceKey(dbTools.FilterDatesrc("syjpremoney"));
		}
		SyjPreMoneyModel syjPreMoneyModel = new SyjPreMoneyModel();
		syjPreMoneyModel.setCreatedate(new Date());
		syjPreMoneyModel.setSyjh(paramsObject.getString("syjh"));
		syjPreMoneyModel.setGh(paramsObject.getString("gh"));
		syjPreMoneyModel.setMkt(paramsObject.getString("mkt"));
		syjPreMoneyModel.setPh_key(paramsObject.getLong("ph_key"));
		syjPreMoneyModel.setPremoney(paramsObject.getFloat("premoney"));
		this.save(syjPreMoneyModel);

		SyjPreMoneyOut syjPreMoneyOut = new SyjPreMoneyOut();
		syjPreMoneyOut.setSyjPreMoneyModel(syjPreMoneyModel);
		syjPreMoneyOut.setCommand_id(paramsObject.getString("command_id"));
		return ServiceResponse.buildSuccess(syjPreMoneyOut);
	}

}
