/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.localize;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.bean.WorkLogType;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.Convert;
import com.efuture.business.javaPos.commonkit.CountZZK;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.ConsumersData;
import com.efuture.business.javaPos.struct.DelGoodsInfo;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.OrderForPos;
import com.efuture.business.javaPos.struct.mainDataCentre.GoodsInfo;
import com.efuture.business.javaPos.struct.mainDataCentre.request.GetGoodsDetailIn;
import com.efuture.business.javaPos.struct.myshopr10.LsGroupRes;
import com.efuture.business.javaPos.struct.myshopr10.R10PointsExchange;
import com.efuture.business.javaPos.struct.request.GetSaleGoodsInfoIn;
import com.efuture.business.javaPos.struct.request.UpdateCartGoodsIn;
import com.efuture.business.javaPos.struct.response.GetSaleGoodsInfoOut;
import com.efuture.business.javaPos.struct.response.UpdateCartGoodsOut;
import com.efuture.business.service.R10PayRemoteService;
import com.efuture.business.service.localize.GoodsSaleBSImpl_MSR10;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.DataExchageUtils;
import com.efuture.business.util.HttpClientUtil;
import com.efuture.business.util.HttpUtils;
import com.efuture.business.util.ParamsValidateUtils;
import com.efuture.business.util.UUIDUtils;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.util.Utils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GoodsSaleBSImpl_MSR10_2
extends GoodsSaleBSImpl_MSR10 {
    private static final Logger log = LoggerFactory.getLogger(GoodsSaleBSImpl_MSR10_2.class);
    public static String POINTEXCHANGE = "sale.memberintswap.get";
    @Autowired
    PosLogicCompoment posLogicCompoment;
    @SoaAnnotation(value="/apiR10PayRemoteService.do")
    private R10PayRemoteService r10PayRemoteService;

    public RespBase getGroupInfo(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"groupnum") || paramsObject.getString("groupnum").isEmpty()) {
            return new RespBase(Code.CODE_20100.getIndex(), "\u56e2\u8d2d\u5165\u53c2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u56e2\u8d2d\u5355\u53f7]");
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60.getIndex(), "\u7f13\u5b58\u5df2\u5931\u6548");
        }
        if (cacheModel.getGoodsList() != null && cacheModel.getGoodsList().size() > 0) {
            cacheModel.getGoodsList().clear();
        }
        ServiceResponse response = null;
        String token = "";
        String groupnum = paramsObject.getString("groupnum");
        try {
            JSONObject jsonResponse;
            JSONObject tokenObj = new JSONObject();
            tokenObj.put("usercode", (Object)GlobalInfo.myshopTokenUseName);
            tokenObj.put("password", (Object)GlobalInfo.myshopTokenPassWord);
            log.info("\u6821\u9a8c\u8bb8\u53ef\u8bc1\u5f00\u59cb:{}", JSONObject.toJSON((Object)tokenObj));
            String res = HttpClientUtil.postJson((String)(GlobalInfo.myShopGroupUrl + "?method=" + GETTOKEN), (String)tokenObj.toJSONString());
            log.info("\u6821\u9a8c\u8bb8\u53ef\u8bc1\u8fd4\u56de:{}", (Object)res);
            if (StringUtils.isNotBlank((String)res) && "0".equals((jsonResponse = JSONObject.parseObject((String)res)).getString("returncode"))) {
                token = jsonResponse.getJSONObject("data").getString("access_token");
            }
            if (StringUtils.isBlank((String)token)) {
                return new RespBase(Code.CODE_20104.getIndex(), "\u56e2\u8d2d\u4ea4\u6613\u672a\u83b7\u53d6\u5230token");
            }
            log.info("token:" + token);
            JSONObject groupDataIn = new JSONObject();
            groupDataIn.put("mkt", (Object)cacheModel.getOrder().getShopCode());
            groupDataIn.put("sheetid", (Object)groupnum);
            log.info("\u56e2\u8d2d\u5355\u8be6\u60c5\u8bf7\u6c42\u4e2d\u53f0  \u5165\u53c2 ==>{}", (Object)groupDataIn);
            response = this.httpUtils.doMyshopPost(this.restTemplate, HttpUtils.RemoteService.MYSHOPGROUP, GETGROUPINFO, session, groupDataIn.toJSONString(), null, "myShop\u56e2\u8d2d", "\u67e5\u8be2\u56e2\u8d2d\u5355", token);
            log.info("\u56e2\u8d2d\u5355\u8be6\u60c5\u8bf7\u6c42\u4e2d\u53f0  \u8fd4\u56de ==>{}", (Object)JSON.toJSONString((Object)response));
            if ("0".equals(response.getReturncode())) {
                JSONArray groupRes = JSONArray.parseArray((String)JSON.toJSONString((Object)response.getData()));
                if (null != groupRes && groupRes.size() > 0) {
                    log.info("\u8c03\u51fa\u56e2\u8d2d\u5546\u54c1");
                    cacheModel = this.getGroupDetail(session, cacheModel, groupRes);
                    if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                        return Code.CODE_64.getRespBase(new Object[]{cacheModel.getErrCode(), cacheModel.getErrMsg()});
                    }
                }
            } else {
                return new RespBase(Code.CODE_20104.getIndex(), response.getData().toString());
            }
            Order order = cacheModel.getOrder();
            order.setAllowEditGoods(false);
            order.setIdSheetNo(groupnum);
            order.setGroupBuyNumber(groupnum);
            order.setR10GroupBuy(true);
            cacheModel.setOrder(order);
            this.posLogicCompoment.calcOrderAmount(cacheModel);
            vo.setCacheModel(cacheModel);
            log.info("\u7535\u5b50\u5355\u6dfb\u52a0\u5546\u54c1end");
        }
        catch (Exception e) {
            log.error("\u56e2\u8d2d\u5355\u5f02\u5e38", (Throwable)e);
            return new RespBase(Code.CODE_20104.getIndex(), e.getLocalizedMessage());
        }
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        vo.setJsonObject((JSONObject)JSON.toJSON((Object)out));
        return new RespBase(Code.SUCCESS, (Object)vo);
    }

    public CacheModel getGroupDetail(ServiceSession session, CacheModel cacheModel, JSONArray groupRes) {
        log.info("\u56e2\u8d2d\u590d\u5236\u5546\u54c1-start");
        String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getSyjmain().getMkt() + cacheModel.getSyjmain().getSyjh());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String cmjy = modeDetailsVo.getSysparaValue("CMJY");
        List syspara = modeDetailsVo.getSyspara();
        if (null == cacheModel.getGoodsList() || cacheModel.getGoodsList().size() == 0) {
            LocalDateTime dateTime = LocalDateTime.now();
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String nowDateTime = dateTime.format(df).toString();
            cacheModel.getOrder().setSaleDate(nowDateTime);
            cacheModel = this.changeSaleDate(cacheModel, syspara);
        }
        Order order = cacheModel.getOrder();
        ArrayList<String> guidList = new ArrayList<String>();
        try {
            String guestid = "";
            String guestname = "";
            if (null != groupRes && groupRes.size() > 0) {
                log.info("\u8c03\u51fa\u56e2\u8d2d\u5546\u54c1");
                for (Object resObj : groupRes) {
                    log.info(JSONObject.toJSONString(resObj));
                    LsGroupRes lsGroupRes = (LsGroupRes)JSON.parseObject((String)JSONObject.toJSONString(resObj), LsGroupRes.class);
                    log.info(" \u524d\uff1a" + JSONObject.toJSONString((Object)cacheModel.getGoodsList().size()));
                    guestid = lsGroupRes.getGuestid();
                    guestname = lsGroupRes.getGuestname();
                    Goods goods = new Goods();
                    GoodsInfo goodsInfo = null;
                    GetGoodsDetailIn getGoodsDetailIn = new GetGoodsDetailIn();
                    List goodsInfos = null;
                    boolean isNeedFindMdm = true;
                    boolean priceMode = false;
                    String originalBarNo = lsGroupRes.getBarcodeid();
                    boolean disMode = false;
                    double disValue = 0.0;
                    String serchType = "1";
                    getGoodsDetailIn.setEntId(session.getEnt_id());
                    getGoodsDetailIn.setShopCode(order.getShopCode());
                    getGoodsDetailIn.setTerminalNo(order.getTerminalNo());
                    getGoodsDetailIn.setCode(lsGroupRes.getBarcodeid());
                    getGoodsDetailIn.setSearchType(serchType);
                    getGoodsDetailIn.setErpCode(cacheModel.getOrder().getErpCode());
                    if (isNeedFindMdm && (null == (goodsInfos = this.GetGoodsInfo(getGoodsDetailIn, session, cmjy)) || goodsInfos.size() == 0)) {
                        if (disValue == 0.0 && getGoodsDetailIn.getCode().length() < 13) {
                            getGoodsDetailIn.setCode(Convert.padLeft((String)getGoodsDetailIn.getCode(), (char)'0', (int)13));
                            goodsInfos = this.GetGoodsInfo(getGoodsDetailIn, session, cmjy);
                            if (null == goodsInfos || goodsInfos.size() == 0) {
                                cacheModel.setErrCode("20087");
                                cacheModel.setErrMsg("\u672a\u67e5\u627e\u5230\u8be5\u5546\u54c1");
                                return cacheModel;
                            }
                        } else {
                            cacheModel.setErrCode("20087");
                            cacheModel.setErrMsg("\u672a\u67e5\u627e\u5230\u8be5\u5546\u54c1");
                            return cacheModel;
                        }
                    }
                    if (goodsInfos.size() <= 0) {
                        cacheModel.setErrCode("20104");
                        cacheModel.setErrMsg("\u8bf7\u6c42\u4e3b\u6570\u636e\u4e2d\u5fc3\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25");
                        return cacheModel;
                    }
                    goodsInfo = (GoodsInfo)goodsInfos.get(0);
                    goodsInfo.fixGoodsInfoStr();
                    goods.setEscaleFlag("N");
                    goodsInfo.setEscaleFlag(0);
                    this.goodsTransfer.transferGoodsInfoToGoods(goodsInfo, goods, lsGroupRes.getQty());
                    String guid = UUIDUtils.buildGuid();
                    guidList.add(guid);
                    goods.setGuid(guid);
                    goods.setGoodsNo(originalBarNo);
                    goods.setFlowId(cacheModel.getGoodsList().size() + 1);
                    goods.setFlowNo(cacheModel.getFlowNo());
                    goods.setGoodsNo(lsGroupRes.getGoodsid());
                    goods.setColourCode(lsGroupRes.getGuestid());
                    goods.setColourName(lsGroupRes.getGuestname());
                    double tmpZk = 0.0;
                    if (lsGroupRes.getPromprice() >= goods.getSalePrice()) {
                        goods.setSalePrice(ManipulatePrecision.getDetailOverFlow((double)lsGroupRes.getPromprice(), (String)goods.getPrcutMode()));
                    } else {
                        tmpZk = ManipulatePrecision.sub((double)goods.getSalePrice(), (double)lsGroupRes.getPromprice());
                    }
                    if (!"Y".equals(goods.getEscaleFlag())) {
                        goods.setSaleValue(ManipulatePrecision.getDetailOverFlow((double)(goods.getQty() * goods.getSalePrice()), (String)goods.getPrcutMode()));
                    } else {
                        goods.setQty(ManipulatePrecision.doubleConvert((double)(goods.getEWCCodeAmount() / goods.getSalePrice()), (int)4, (int)1));
                        goods.setQtyrecalc(0);
                        goods.setSaleValue(goods.getEWCCodeAmount());
                        goods.setPopDiscountValue(0.0);
                    }
                    goods.setTempZkl(100.0);
                    goods.setDiscAmount(0.0);
                    goods.setTempZkDiscount(0.0);
                    goods.setTempZrDiscount(0.0);
                    goods.setTempZzkDiscount(0.0);
                    goods.setTempZzrDiscount(0.0);
                    goods.setFixedDiscountValue(0.0);
                    goods.setFlag("Z");
                    log.info("tmpZk\uff1a" + tmpZk);
                    if (tmpZk > 0.0) {
                        goods.setTempZkDiscount(ManipulatePrecision.mul((double)tmpZk, (double)goods.getQty()));
                    }
                    goods.setAdjustDiscountValue(this.posLogicCompoment.getAdjustDiscount(goods));
                    goods.setPopDiscountValue(0.0);
                    goods.setTotalDiscountValue(CountZZK.getZZK((Goods)goods));
                    goods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert((double)(goods.getTotalDiscountValue() - goods.getNoDisAmountValue())));
                    goods.setSaleAmount(goods.getSaleValue() - goods.getTotalDiscountValue());
                    goods.setFlowId(cacheModel.getGoodsList().size() + 1);
                    cacheModel.getGoodsList().add(goods);
                    log.info(" \u4e2d\uff1a" + JSONObject.toJSONString((Object)cacheModel.getGoodsList()));
                }
            }
            order.setGroupBuyerCode(guestid);
            order.setGroupBuyerName(guestname);
            JSONObject paramsObject = new JSONObject();
            paramsObject.put("calcMode", (Object)"0");
            paramsObject.put("count", (Object)cacheModel.getGoodsList().size());
            paramsObject.put("qty", (Object)cacheModel.getGoodsList().size());
            paramsObject.put("guidList", guidList);
            RespBase respBase = this.calcPopRemoteService.calcSinglePopAll(session, "0", cacheModel, false);
            if (respBase.getRetflag() != 0) {
                cacheModel.setErrCode("-1");
                cacheModel.setErrMsg(((CacheModel)respBase.getData()).toString());
                return cacheModel;
            }
            cacheModel = (CacheModel)respBase.getData();
            log.info("\u91cd\u7b97\u6539\u4ef7\u91d1\u989d-end");
        }
        catch (Exception e) {
            log.error("\u56e2\u8d2d\u8c03\u51fa\u5f02\u5e38{}", (Throwable)e);
            cacheModel.setErrMsg("\u56e2\u8d2d\u8c03\u51fa\u5f02\u5e38");
            cacheModel.setErrCode("-1");
            return cacheModel;
        }
        return cacheModel;
    }

    public Goods getGoods(ConsumersData consumersData, Goods goods, CacheModel cacheModel) {
        return this.getErpcustdiscount(consumersData, goods, 0.0, cacheModel.getOrder());
    }

    private Goods getErpcustdiscount(ConsumersData consumersData, Goods goods, double marketzk, Order order) {
        log.info("\u4e3b\u6863\u4f1a\u5458\u4ef7");
        if (null == consumersData || StringUtils.isEmpty((String)consumersData.getConsumersType()) || order.isHasGroupBuy()) {
            return goods;
        }
        if (goods.getMemberPrice() > 0.0) {
            log.info("\u5f00\u59cb\u8bb0\u5f55\u4f1a\u5458\u4ef7");
            String precisionMode = DataExchageUtils.exchangePrecisionMode((String)goods.getPrcutMode());
            goods.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow((double)(goods.getSalePrice() - goods.getMemberPrice()), (String)precisionMode));
            goods.setDisMode(3);
            goods.setDisValue(goods.getMemberPrice());
            goods.setDiscType("0");
            marketzk = goods.getShareDiscount2();
        }
        goods.setAdjustDiscountValue(this.posLogicCompoment.getAdjustDiscount(goods));
        goods.setTotalDiscountValue(CountZZK.getZZK((Goods)goods));
        goods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert((double)(goods.getTotalDiscountValue() - goods.getNoDisAmountValue())));
        goods.setSaleAmount(goods.getSaleValue() - goods.getTotalDiscountValue());
        goods.setFdmode("3");
        goods.setVipfdzkfd(ManipulatePrecision.doubleConvert((double)(marketzk / 100.0), (int)4, (int)1));
        return goods;
    }

    public RespBase getSaleGoodsInfo(ServiceSession session, ResqVo vo) {
        JSONObject paramsObject = vo.getJsonObject();
        GetSaleGoodsInfoIn getSaleGoodsInfoIn = (GetSaleGoodsInfoIn)JSONObject.toJavaObject((JSON)paramsObject, GetSaleGoodsInfoIn.class);
        RespBase respBase = super.getSaleGoodsInfo(session, vo);
        if (0 != respBase.getRetflag()) {
            return respBase;
        }
        vo = (ResqVo)respBase.getData();
        JSONObject jsonObject2 = vo.getJsonObject();
        GetSaleGoodsInfoOut out = (GetSaleGoodsInfoOut)JSONObject.parseObject((String)jsonObject2.toJSONString(), GetSaleGoodsInfoOut.class);
        log.info("SaleGoodsType>>>>>>" + out.getSaleGoodsType());
        if (null != vo.getCacheModel().getGoodsList() && 0 < vo.getCacheModel().getGoodsList().size() && null != vo.getCacheModel().getOrder().getConsumersData() && !"".equals(vo.getCacheModel().getOrder().getConsumersData().getConsumersCard()) && null != vo.getCacheModel().getOrder().getConsumersData().getConsumersCard() && !"3".equals(out.getSaleGoodsType())) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("code", (Object)((Goods)vo.getCacheModel().getGoodsList().get(vo.getCacheModel().getGoodsList().size() - 1)).getGoodsCode());
            jsonObject.put("shopid", (Object)getSaleGoodsInfoIn.getShopCode());
            jsonObject.put("flowNo", (Object)vo.getCacheModel().getFlowNo());
            log.info("\u8c03\u7528\u79ef\u5206\u6362\u8d2d\u63a5\u53e3: " + jsonObject.toJSONString());
            RespBase respBase2 = this.r10PayRemoteService.pointsExchange(session, jsonObject);
            log.info("\u8c03\u7528\u79ef\u5206\u6362\u8d2d\u8fd4\u56de: " + JSONObject.toJSONString((Object)respBase2));
            if (0 == respBase2.getRetflag()) {
                R10PointsExchange r10PointsExchange = (R10PointsExchange)respBase2.getData();
                Goods goods = (Goods)vo.getCacheModel().getGoodsList().get(vo.getCacheModel().getGoodsList().size() - 1);
                if (0.0 < r10PointsExchange.getPoint() && goods.getSaleValue() - goods.getTotalDiscountValue() >= r10PointsExchange.getPrice() - r10PointsExchange.getCash()) {
                    goods.setOrgR10ExchangeAmount(ManipulatePrecision.sub((double)r10PointsExchange.getPrice(), (double)r10PointsExchange.getCash()));
                    goods.setOrgR10ExchangeAmountViwe(r10PointsExchange.getCash());
                    goods.setOrgR10ExchangePoint(r10PointsExchange.getPoint());
                    goods.setR10ExchangeAmount(goods.getOrgR10ExchangeAmount());
                    goods.setR10ExchangePoint(goods.getOrgR10ExchangePoint());
                    goods.setR10ExchangeAmountViwe(goods.getOrgR10ExchangeAmountViwe());
                    goods.setR10ExchangeRate(ManipulatePrecision.doubleConvert((double)ManipulatePrecision.div((double)r10PointsExchange.getPoint(), (double)(r10PointsExchange.getPrice() - r10PointsExchange.getCash())), (int)2, (int)1));
                    OrderForPos order = this.orderTransfer.toOrderForPosSingle(vo.getCacheModel());
                    out.setOrder(order);
                    ResqVo resqVo = ResqVo.buildReqVo((CacheModel)vo.getCacheModel(), (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                    return new RespBase(Code.SUCCESS, (Object)resqVo, "FINDGOODSTIFY");
                }
            } else {
                return respBase2;
            }
        }
        return respBase;
    }

    public RespBase updateCartGoods2(ServiceSession session, ResqVo vo) {
        try {
            JSONObject object3;
            JSONObject paramsObject = vo.getJsonObject();
            log.info("updateCartGoods2===>{}", (Object)paramsObject.toJSONString());
            ParamsValidateUtils paramsValidate = new ParamsValidateUtils(session, paramsObject);
            if (!paramsValidate.validate()) {
                return Code.CODE_20030.getRespBase(new Object[0]);
            }
            if (!paramsObject.containsKey((Object)"barNo") || paramsObject.getString("barNo").isEmpty()) {
                return Code.CODE_20031.getRespBase(new Object[0]);
            }
            if (!paramsObject.containsKey((Object)"guid") || paramsObject.getString("guid").isEmpty()) {
                return Code.CODE_20032.getRespBase(new Object[0]);
            }
            if (!paramsObject.containsKey((Object)"calcMode") || paramsObject.getString("calcMode").isEmpty()) {
                return Code.CODE_20033.getRespBase(new Object[0]);
            }
            String flag = paramsObject.getString("flag");
            if ("0".equals(flag) && (!paramsObject.containsKey((Object)"qty") || paramsObject.getDouble("qty") == 0.0)) {
                return Code.CODE_20034.getRespBase(new Object[0]);
            }
            UpdateCartGoodsIn updateGoodsIn = (UpdateCartGoodsIn)JSON.toJavaObject((JSON)paramsObject, UpdateCartGoodsIn.class);
            String obj = this.redisUtil.get(RedisKey.CACHEID + updateGoodsIn.getShopCode() + updateGoodsIn.getTerminalNo());
            obj = this.reCacheMode(obj, paramsObject);
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
            String fkcxs = "";
            String paravalue = "1";
            JSONArray array = new JSONArray();
            List sysParaList = modeDetailsVo.getSyspara();
            JSONArray sysParaArray = JSONArray.parseArray((String)JSON.toJSONString((Object)sysParaList));
            if (sysParaArray.size() != 0) {
                for (int i = 0; i < sysParaArray.size(); ++i) {
                    JSONObject sys = sysParaArray.getJSONObject(i);
                    if (sys.get((Object)"code").equals("OZ")) {
                        array.add((Object)sys);
                    }
                    if (!sys.get((Object)"code").equals("41")) continue;
                    fkcxs = sys.getString("paravalue");
                }
            }
            if (array.size() != 0 && (object3 = array.getJSONObject(0)).containsKey((Object)"paravalue")) {
                paravalue = object3.getString("paravalue");
            }
            String[] temp = paravalue.split(",");
            double maxBusinessVolume = CastUtil.castDouble((Object)temp[4]);
            String flowNo = updateGoodsIn.getFlowNo();
            CacheModel cacheModel = vo.getCacheModel();
            session.setEnt_id(cacheModel.getOrder().getEntId());
            if (cacheModel == null) {
                return Code.CODE_20035.getRespBase(new Object[0]);
            }
            if ("Y12".equals(cacheModel.getOrder().getOrderType())) {
                return Code.CODE_20096.getRespBase(new Object[0]);
            }
            if (!cacheModel.getOrder().getAllowEditGoods()) {
                return Code.CODE_20036.getRespBase(new Object[]{flowNo});
            }
            if (cacheModel.getGoodsList() == null || cacheModel.getGoodsList().size() == 0) {
                return Code.CODE_20037.getRespBase(new Object[0]);
            }
            Goods existGoods = this.goodsTransfer.findGoods(updateGoodsIn.getGuid(), cacheModel.getGoodsList());
            double tempzkl = existGoods.getTempZkl();
            double tempzr = existGoods.getTempZrDiscount();
            double discamount = existGoods.getDiscAmount();
            if (existGoods == null) {
                return Code.CODE_20038.getRespBase(new Object[0]);
            }
            if ((!SellType.ISBACK((String)cacheModel.getOrder().getOrderType()) || null != cacheModel.getOrder().getOriginTerminalSno() && cacheModel.getOrder().getOriginTerminalSno().length() > 0) && existGoods.getGoodsType().equals("15")) {
                return Code.CODE_20097.getRespBase(new Object[0]);
            }
            if ("99".equals(existGoods.getGoodsType()) || "98".equals(existGoods.getGoodsType())) {
                return Code.CODE_20098.getRespBase(new Object[0]);
            }
            if (StringUtils.isNotBlank((String)existGoods.getEBillFlowNo())) {
                return Code.CODE_20113.getRespBase(new Object[0]);
            }
            if ("9".equals(existGoods.getFlag()) && !"0".equals(updateGoodsIn.getFlag())) {
                return Code.CODE_20107.getRespBase(new Object[0]);
            }
            if (StringUtils.isNotBlank((String)existGoods.getEBillFlowNo())) {
                return Code.CODE_20138.getRespBase(new Object[0]);
            }
            String accreditNo = paramsObject.getString("accreditNo");
            if (StringUtils.isBlank((String)accreditNo)) {
                accreditNo = cacheModel.getCurGrant().getGh();
            }
            Goods updateGoods = existGoods.deepClone();
            double oldAmount = existGoods.getSaleAmount();
            double orderTempZzk = cacheModel.getOrder().getTempZzk();
            double orderTempZzr = cacheModel.getOrder().getTempZzr();
            if ("3".equals(updateGoodsIn.getCalcMode())) {
                existGoods.setEatWay(updateGoodsIn.getEatWay());
                updateGoodsIn.setCalcMode("0");
                if (null != updateGoodsIn.getCategoryPropertys() && updateGoodsIn.getCategoryPropertys().size() > 0) {
                    existGoods.setCategoryPropertys(updateGoodsIn.getCategoryPropertys());
                } else {
                    existGoods.setCategoryPropertys(new ArrayList());
                }
            }
            if ("4".equals(updateGoodsIn.getCalcMode())) {
                if (null == cacheModel.getOrder().getConsumersData().getConsumersId() || cacheModel.getOrder().getConsumersData().getConsumersId().length() <= 0) {
                    return Code.CODE_20040.getRespBase(new Object[0]);
                }
                if (!existGoods.getFlag().equals("1") && !existGoods.getFlag().equals("7")) {
                    return Code.CODE_20041.getRespBase(new Object[0]);
                }
                if (existGoods.getFlag().equals("1")) {
                    existGoods.setFlag("7");
                } else {
                    existGoods.setFlag("1");
                    existGoods.setPopFlag("");
                }
                updateGoodsIn.setCalcMode("0");
            }
            if ("0".equals(flag)) {
                if (cacheModel.getMaxSaleGoodsQuantity() > 0.0 && (updateGoodsIn.getQty() > cacheModel.getMaxSaleGoodsQuantity() || updateGoodsIn.getQty() < 0.0)) {
                    return Code.CODE_20042.getRespBase(new Object[0]);
                }
                if ("T".equals(cacheModel.getCurGrant().getPrivqt9())) {
                    Goods sg = (Goods)cacheModel.getGoodsList().get(existGoods.getFlowId() - 1);
                    if (updateGoodsIn.getQty() < sg.getQty()) {
                        return Code.CODE_20116.getRespBase(new Object[0]);
                    }
                }
                RespBase resp = this.isAllowEditQty(cacheModel, existGoods.getFlowId(), updateGoodsIn.getQty());
                if (Code.SUCCESS.getIndex() != resp.getRetflag()) {
                    return resp;
                }
                if ((cacheModel = this.posLogicService.EditGoodsQtyBeforeSingle(cacheModel, existGoods.getFlowId(), accreditNo, updateGoodsIn.getQty())).getCalcResult() == -1) {
                    String errCode = "100000";
                    if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                        errCode = cacheModel.getErrCode();
                    }
                    for (Code code : Code.values()) {
                        if (code.getIndex() != Integer.parseInt(errCode)) continue;
                        return code.getRespBase(new Object[]{cacheModel.getErrMsg()});
                    }
                    return Code.CODE_20090.getRespBase(new Object[]{cacheModel.getErrMsg()});
                }
                log.info("\u4fee\u6539\u6570\u91cf\u7ed3\u675f");
                existGoods = (Goods)cacheModel.getGoodsList().get(existGoods.getFlowId() - 1);
            }
            if ("1".equals(flag) || "3".equals(flag)) {
                if (cacheModel.getMaxSaleGoodsMoney() > 0.0 && updateGoodsIn.getRefPrice() > cacheModel.getMaxSaleGoodsMoney()) {
                    return Code.CODE_20043.getRespBase(new Object[0]);
                }
                if (updateGoodsIn.getRefPrice() < 0.0) {
                    return Code.CODE_20128.getRespBase(new Object[0]);
                }
                if ("3".equals(flag)) {
                    log.info("2\u4fee\u6539\u6210\u4ea4\u4ef7,popFlag\u6539\u4e3aJ");
                    existGoods.setPopFlag("J");
                    existGoods.setBarcodeDiscount(0.0);
                    existGoods.setAdjustDiscountValue(this.posLogicCompoment.getAdjustDiscount(existGoods));
                    existGoods.setTotalDiscountValue(CountZZK.getZZK((Goods)existGoods));
                    existGoods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert((double)(existGoods.getTotalDiscountValue() - existGoods.getNoDisAmountValue())));
                    existGoods.setSaleAmount(existGoods.getSaleValue() - existGoods.getTotalDiscountValue());
                }
                for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
                    Code[] goods = (Code[])cacheModel.getGoodsList().get(i);
                    String guid = updateGoodsIn.getGuid();
                    if (!guid.equals(goods.getGuid())) continue;
                    log.info("\u66f4\u65b0goods2==>{}", (Object)existGoods);
                    cacheModel.getGoodsList().set(i, existGoods);
                }
                if (-1 == (cacheModel = this.posLogicService.EditGoodsPriceBeforeSingle(cacheModel, existGoods.getFlowId(), accreditNo, updateGoodsIn.getRefPrice())).getCalcResult()) {
                    String errCode = "100000";
                    if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                        errCode = cacheModel.getErrCode();
                    }
                    for (Code code : Code.values()) {
                        if (code.getIndex() != Integer.parseInt(errCode)) continue;
                        return code.getRespBase(new Object[]{cacheModel.getErrMsg()});
                    }
                    return new RespBase(Integer.parseInt(errCode), cacheModel.getErrMsg(), (Object)vo);
                }
                existGoods = (Goods)cacheModel.getGoodsList().get(existGoods.getFlowId() - 1);
                log.info(">>>>existGoods==>{}", (Object)JSONObject.toJSONString((Object)existGoods));
            }
            if ("2".equals(flag) || "4".equals(flag)) {
                if (cacheModel.getMaxSaleGoodsMoney() > 0.0 && updateGoodsIn.getRefPrice() > cacheModel.getMaxSaleGoodsMoney()) {
                    return Code.CODE_20044.getRespBase(new Object[0]);
                }
                if ("4".equals(flag)) {
                    existGoods.setPopFlag("J");
                    if (StringUtils.isNotBlank((String)updateGoodsIn.getFdmode())) {
                        existGoods.setFdmode(updateGoodsIn.getFdmode());
                        existGoods.setFdresult(updateGoodsIn.getFdresult());
                        existGoods.setPopzkfd(updateGoodsIn.getPopzkfd());
                    }
                }
                if (-1 == (cacheModel = this.posLogicService.FixGoodsPriceBeforeSingle(cacheModel, existGoods.getFlowId(), accreditNo, updateGoodsIn.getRefPrice())).getCalcResult()) {
                    String errCode = "100000";
                    if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                        errCode = cacheModel.getErrCode();
                    }
                    for (Code code : Code.values()) {
                        if (code.getIndex() != Integer.parseInt(errCode)) continue;
                        return code.getRespBase(new Object[]{cacheModel.getErrMsg()});
                    }
                    return new RespBase(Integer.parseInt(errCode), cacheModel.getErrMsg(), (Object)vo);
                }
                existGoods = (Goods)cacheModel.getGoodsList().get(existGoods.getFlowId() - 1);
            }
            if (cacheModel.getPopMode() == 1) {
                log.info("\u5f00\u59cb\u8ba1\u7b97\u5355\u884c!");
                vo.setCacheModel(cacheModel);
                RespBase respBase = this.calcPopRemoteService.calcSinglePopService(session, updateGoodsIn.getCalcMode(), updateGoodsIn.getGuid(), existGoods, vo, null, false, false, true);
                if (respBase.getRetflag() != 0) {
                    return respBase;
                }
                ResqVo resqVo = (ResqVo)respBase.getData();
                cacheModel = resqVo.getCacheModel();
                this.posLogicCompoment.calcOrderAmount(cacheModel);
            } else if (cacheModel.getPopMode() == 2) {
                String calcMode = "0";
                Code[] guidList = new ArrayList();
                for (Goods goods1 : cacheModel.getGoodsList()) {
                    guidList.add(goods1.getGuid());
                }
                cacheModel = this.calcOrderPop(session, calcMode, cacheModel, vo, (List)guidList);
                this.posLogicCompoment.calcOrderAmount(cacheModel);
            } else {
                this.posLogicCompoment.calcOrderAmount(cacheModel);
            }
            if (cacheModel.getCalcResult() == -1) {
                String errCode = "100000";
                if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                    errCode = cacheModel.getErrCode();
                }
                for (Code code : Code.values()) {
                    if (code.getIndex() != Integer.parseInt(errCode)) continue;
                    return code.getRespBase(new Object[]{cacheModel.getErrMsg()});
                }
                return Code.CODE_20092.getRespBase(new Object[]{cacheModel.getErrMsg()});
            }
            if ("0".equals(updateGoodsIn.getFlag())) {
                if (ManipulatePrecision.doubleCompare((double)tempzkl, (double)100.0, (int)2) < 0) {
                    cacheModel = this.posLogicCompoment.calcGoodsRebateByRate(cacheModel, existGoods.getFlowId(), accreditNo, tempzkl);
                } else if (ManipulatePrecision.doubleCompare((double)tempzr, (double)0.0, (int)2) > 0) {
                    cacheModel = ManipulatePrecision.doubleCompare((double)discamount, (double)0.0, (int)2) > 0 ? this.posLogicCompoment.calcGoodsRebateByAmount(cacheModel, existGoods.getFlowId(), accreditNo, discamount, 1) : this.posLogicCompoment.calcGoodsRebateByAmount(cacheModel, existGoods.getFlowId(), accreditNo, tempzr);
                }
            }
            if (cacheModel.getMaxSaleMoney() > 0.0 && cacheModel.getOrder().getOughtPay() > maxBusinessVolume) {
                return Code.CODE_20045.getRespBase(new Object[0]);
            }
            Goods returnGoods = this.goodsTransfer.findGoods(updateGoodsIn.getGuid(), cacheModel.getGoodsList());
            returnGoods.setCategoryPropertys(existGoods.getCategoryPropertys());
            if (orderTempZzk != 0.0) {
                cacheModel = this.posLogicCompoment.calcOrderRebateByRate(cacheModel, cacheModel.getCurGrant().getGh(), orderTempZzk);
            }
            if (orderTempZzr != 0.0) {
                cacheModel = this.posLogicCompoment.calcOrderRebateByAmount(cacheModel, cacheModel.getCurGrant().getGh(), orderTempZzr);
            }
            double newAmount = returnGoods.getSaleAmount();
            if ("1".equals(flag) || "3".equals(flag)) {
                this.goodsTask.sendWorkLog(session, cacheModel.getOrder(), WorkLogType.editPrice, existGoods.getQty(), ManipulatePrecision.doubleConvert((double)(oldAmount - newAmount)), existGoods.getGoodsName(), existGoods.getGoodsCode());
            } else if ("2".equals(flag)) {
                this.goodsTask.sendWorkLog(session, cacheModel.getOrder(), WorkLogType.rebate, existGoods.getQty(), ManipulatePrecision.doubleConvert((double)(oldAmount - newAmount)), existGoods.getGoodsName(), existGoods.getGoodsCode());
            } else if ("0".equals(flag) && oldAmount > newAmount) {
                this.goodsTask.sendWorkLog(session, cacheModel.getOrder(), WorkLogType.editQty, existGoods.getQty(), ManipulatePrecision.doubleConvert((double)(oldAmount - newAmount)), existGoods.getGoodsName(), existGoods.getGoodsCode());
            }
            UpdateCartGoodsOut out = new UpdateCartGoodsOut();
            out.setOrder(this.orderTransfer.toOrderForPosSingle(cacheModel));
            if ("0".equals(flag)) {
                DelGoodsInfo updateGood = new DelGoodsInfo();
                updateGood.setBarNo(updateGoods.getBarNo());
                updateGood.setGoodsCode(updateGoods.getGoodsCode());
                updateGood.setGoodsDisplayName(updateGoods.getGoodsDisplayName());
                updateGood.setGoodsName(updateGoods.getGoodsName());
                updateGood.setGoodsNo(updateGoods.getGoodsNo());
                updateGood.setQty(updateGoods.getQty());
                updateGood.setSaleAmount(ManipulatePrecision.doubleConvert((double)(oldAmount - newAmount)));
                out.setUpdateGood(updateGood);
            }
            if (updateGoods.getQty() < existGoods.getQty() && "N".equals(fkcxs) && 0 == updateGoods.getIsExcessSale() && "1".equals(updateGoods.getGbmanamode())) {
                HashSet<String> goodsCodes = new HashSet<String>();
                goodsCodes.add(existGoods.getGoodsCode());
                RespBase response = this.searchShopStock(session, cacheModel, goodsCodes);
                if (Code.SUCCESS.getIndex() != response.getRetflag()) {
                    return response;
                }
            }
            ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
            return new RespBase(Code.SUCCESS, (Object)resqVo, "CHANGEGOODSTIFY");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            return Code.CODE_20046.getRespBase(new Object[]{Utils.getLastExceptionMessage((Exception)e)});
        }
    }

    public RespBase updateCartGoods(ServiceSession session, ResqVo vo) {
        UpdateCartGoodsIn updateGoodsIn = (UpdateCartGoodsIn)JSON.toJavaObject((JSON)vo.getJsonObject(), UpdateCartGoodsIn.class);
        ResqVo resqVo = null;
        RespBase respBase = null;
        if (!"998".equals(updateGoodsIn.getFlag()) && !"999".equals(updateGoodsIn.getFlag())) {
            respBase = this.updateCartGoods2(session, vo);
            if (0 != respBase.getRetflag()) {
                return respBase;
            }
            resqVo = (ResqVo)respBase.getData();
        } else {
            resqVo = vo;
        }
        Goods existGoods = this.goodsTransfer.findGoods(updateGoodsIn.getGuid(), resqVo.getCacheModel().getGoodsList());
        existGoods.setR10ExchangeAmountViwe(ManipulatePrecision.mul((double)existGoods.getOrgR10ExchangeAmountViwe(), (double)existGoods.getQty()));
        existGoods.setR10ExchangeAmount(ManipulatePrecision.mul((double)existGoods.getOrgR10ExchangeAmount(), (double)existGoods.getQty()));
        existGoods.setR10ExchangePoint(ManipulatePrecision.mul((double)existGoods.getOrgR10ExchangePoint(), (double)existGoods.getQty()));
        UpdateCartGoodsOut out = (UpdateCartGoodsOut)JSONObject.parseObject((String)resqVo.getJsonObject().toJSONString(), UpdateCartGoodsOut.class);
        log.info("existGoods>>>>>" + JSONObject.toJSONString((Object)existGoods));
        if (0.0 < existGoods.getR10ExchangePoint() && null != resqVo.getCacheModel().getGoodsList() && 0 < resqVo.getCacheModel().getGoodsList().size() && null != resqVo.getCacheModel().getOrder().getConsumersData() && !"".equals(resqVo.getCacheModel().getOrder().getConsumersData().getConsumersCard()) && null != vo.getCacheModel().getOrder().getConsumersData().getConsumersCard()) {
            if (("1".equals(updateGoodsIn.getFlag()) || "2".equals(updateGoodsIn.getFlag()) || "3".equals(updateGoodsIn.getFlag())) && existGoods.isR10isJFHG()) {
                return new RespBase(Code.CODE_50132.getIndex(), "\u5f53\u524d\u5546\u54c1\u5df2\u53c2\u4e0e\u79ef\u5206\u6362\u8d2d\uff0c\u4e0d\u5141\u8bb8\u6539\u4ef7", (Object)vo.getCacheModel().getFlowNo(), "CHANGEGOODSTIFY");
            }
            if ("998".equals(updateGoodsIn.getFlag())) {
                if (existGoods.getR10ExchangeAmountViwe() > existGoods.getSaleValue() - existGoods.getTotalDiscountValue()) {
                    return new RespBase(Code.CODE_50133.getIndex(), "\u6362\u8d2d\u91d1\u989d\u5927\u4e8e\u5f53\u524d\u5546\u54c1\u9500\u552e\u91d1\u989d", (Object)vo.getCacheModel().getFlowNo(), "CHANGEGOODSTIFY");
                }
                if (existGoods.getR10ExchangePoint() > resqVo.getCacheModel().getOrder().getConsumersData().getPoint()) {
                    return new RespBase(Code.CODE_50134.getIndex(), "\u6362\u8d2d\u79ef\u5206\u5927\u4e8e\u5f53\u524d\u4f1a\u5458\u603b\u79ef\u5206", (Object)vo.getCacheModel().getFlowNo(), "CHANGEGOODSTIFY");
                }
                if (0.0 != existGoods.getAdjustDiscountValue()) {
                    log.info("existGoods.getAdjustDiscountValue>>>>>>>>" + existGoods.getAdjustDiscountValue());
                    return new RespBase(Code.CODE_50137.getIndex(), "\u5f53\u524d\u5546\u54c1\u5b58\u5728\u624b\u5de5\u6298\u6263\u4e0d\u5141\u8bb8\u79ef\u5206\u6362\u8d2d", (Object)vo.getCacheModel().getFlowNo(), "CHANGEGOODSTIFY");
                }
                existGoods.setR10isJFHG(true);
                existGoods.setFlag("Z");
                existGoods.setR10PointPaycode(updateGoodsIn.getR10PointPaycode());
                updateGoodsIn.setFlag("1");
                updateGoodsIn.setGuid(existGoods.getGuid());
                updateGoodsIn.setRefPrice(existGoods.getListPrice());
                log.info("\u6362\u8d2d\u8bf7\u6c42\u6539\u4ef7\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)updateGoodsIn));
                vo.setCacheModel(resqVo.getCacheModel());
                vo.setJsonObject(JSONObject.parseObject((String)JSONObject.toJSONString((Object)updateGoodsIn)));
                respBase = super.updateCartGoods(session, vo);
                if (0 != respBase.getRetflag()) {
                    return respBase;
                }
                resqVo = (ResqVo)respBase.getData();
                out = (UpdateCartGoodsOut)JSONObject.parseObject((String)resqVo.getJsonObject().toJSONString(), UpdateCartGoodsOut.class);
                log.info("1\u8bbe\u7f6e\u6362\u8d2d\u6807\u8bc6\u5b8c\u6210" + vo.getCacheModel().getFlowNo());
            }
            if ("999".equals(updateGoodsIn.getFlag())) {
                existGoods.setR10isJFHG(false);
                existGoods.setFlag("1");
                log.info("2\u8bbe\u7f6e\u6362\u8d2d\u6807\u8bc6\u5b8c\u6210" + vo.getCacheModel().getFlowNo());
            }
        }
        out.setOrder(this.orderTransfer.toOrderForPosSingle(resqVo.getCacheModel()));
        resqVo = ResqVo.buildReqVo((CacheModel)resqVo.getCacheModel(), (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "CHANGEGOODSTIFY");
    }

    public CacheModel loginMemberForRefund(ServiceSession session, ResqVo vo, CacheModel cacheModel) {
        return cacheModel;
    }
}

