/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.localize;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.bean.WorkLogType;
import com.efuture.business.bean.YPopStatusType;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.Convert;
import com.efuture.business.javaPos.commonkit.CountZZK;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.struct.AnalyzeBarcodeDef;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.ConsumersData;
import com.efuture.business.javaPos.struct.DelGoodsInfo;
import com.efuture.business.javaPos.struct.DzcGoodsDetail;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.GoodsForPos;
import com.efuture.business.javaPos.struct.OperUser;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.OrderForPos;
import com.efuture.business.javaPos.struct.SysParaInfo;
import com.efuture.business.javaPos.struct.mainDataCentre.GoodsInfo;
import com.efuture.business.javaPos.struct.mainDataCentre.request.GetGoodsDetailIn;
import com.efuture.business.javaPos.struct.mainDataCentre.response.GetGoodsDetailOut;
import com.efuture.business.javaPos.struct.posManager.request.ElecScaleCodeRuleIn;
import com.efuture.business.javaPos.struct.promotionCentre.BillDetail;
import com.efuture.business.javaPos.struct.promotionCentre.SellDetail;
import com.efuture.business.javaPos.struct.promotionCentre.SellPopDetail;
import com.efuture.business.javaPos.struct.promotionCentre.request.CalcsingleIn;
import com.efuture.business.javaPos.struct.promotionCentre.response.CalcsingleOut;
import com.efuture.business.javaPos.struct.request.GetSaleGoodsInfoIn;
import com.efuture.business.javaPos.struct.request.QueryGoodIn;
import com.efuture.business.javaPos.struct.request.UpdateCartGoodsIn;
import com.efuture.business.javaPos.struct.response.GetSaleGoodsInfoOut;
import com.efuture.business.javaPos.struct.response.UpdateCartGoodsOut;
import com.efuture.business.javaPos.struct.sjgw.Posdispara;
import com.efuture.business.model.Elecscalecoderule;
import com.efuture.business.model.Syjgroup;
import com.efuture.business.model.Syspara;
import com.efuture.business.service.localize.GoodsSaleBSImpl_WSLF;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.DataExchageUtils;
import com.efuture.business.util.DateUtils;
import com.efuture.business.util.ParamsValidateUtils;
import com.efuture.business.util.TimeZoneUtil;
import com.efuture.business.util.UUIDUtils;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.util.Utils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoodsSaleBSImpl_SJGW
extends GoodsSaleBSImpl_WSLF {
    private static final Logger log = LoggerFactory.getLogger(GoodsSaleBSImpl_SJGW.class);

    public Goods getGoods(ConsumersData consumersData, Goods goods, CacheModel cacheModel) {
        return this.getErpGoodsdiscount(consumersData, goods, 0.0);
    }

    protected List<GoodsInfo> GetGoodsInfo(GetGoodsDetailIn in, ServiceSession session, String cmjy) {
        try {
            ServiceResponse resp = this.searcheSaleGoodsDetails(session, (JSONObject)JSON.toJSON((Object)in));
            log.info("searcheSaleGoodsDetails response==>{}", (Object)JSONObject.toJSONString((Object)resp));
            if (null != resp && "0".equals(resp.getReturncode())) {
                GetGoodsDetailOut getGoodsDetailOut = (GetGoodsDetailOut)JSONObject.parseObject((String)JSONObject.toJSONString((Object)resp.getData()), GetGoodsDetailOut.class);
                List goodsInfos = getGoodsDetailOut.getGoods();
                if (null != goodsInfos && goodsInfos.size() > 0) {
                    for (GoodsInfo goodsInfo : goodsInfos) {
                        goodsInfo.setGoodsUid(goodsInfo.getGuCode());
                    }
                    return goodsInfos;
                }
            } else if (13 == in.getCode().length() && in.getCode().startsWith("0")) {
                log.info("\u5546\u54c1\u4e3a0\u5f00\u5934,\u91cd\u65b0\u67e5\u8be2\u4e00\u904d");
                while (in.getCode().startsWith("0")) {
                    in.setCode(in.getCode().replaceFirst("0", ""));
                }
                return this.GetGoodsInfo(in, session, cmjy);
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            log.info("\u67e5\u8be2\u5546\u54c1\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    private Goods getErpGoodsdiscount(ConsumersData consumersData, Goods goods, double marketzk) {
        String precisionMode = DataExchageUtils.exchangePrecisionMode((String)goods.getPrcutMode());
        if (!(null == consumersData || StringUtils.isEmpty((String)consumersData.getConsumersCard()) || !(goods.getMemberPrice() > 0.0) || "Y".equals(goods.getNoPricing()) || goods.getGoodsNo().startsWith("Z") || goods.getGoodsNo().startsWith("D") || goods.getGoodsNo().startsWith("B") && goods.getGoodsNo().contains(","))) {
            if ("Y".equals(goods.getEscaleFlag())) {
                goods.setCustomDiscountValue(ManipulatePrecision.getDetailOverFlow((double)((goods.getSalePrice() - goods.getMemberPrice()) * (goods.getQty() / 1.0)), (String)precisionMode));
            } else {
                goods.setCustomDiscountValue(ManipulatePrecision.getDetailOverFlow((double)((goods.getSalePrice() - goods.getMemberPrice()) * goods.getQty()), (String)precisionMode));
            }
        }
        if (goods.getGoodsNo().startsWith("Z") || goods.getGoodsNo().startsWith("D")) {
            String zkl = goods.getGoodsNo().substring(1, 3);
            goods.setDisMode(2);
            goods.setDisValue(ManipulatePrecision.div((double)Double.valueOf(zkl), (double)100.0));
            goods.setDiscType("0");
        } else if (goods.getGoodsNo().startsWith("B") && goods.getGoodsNo().contains(",")) {
            String zkl = goods.getGoodsNo().split(",")[1];
            goods.setDisMode(2);
            goods.setDisValue(Double.valueOf(zkl).doubleValue());
            goods.setDiscType("0");
        }
        goods.setAdjustDiscountValue(this.posLogicCompoment.getAdjustDiscount(goods));
        goods.setTotalDiscountValue(CountZZK.getZZK((Goods)goods));
        goods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert((double)(goods.getTotalDiscountValue() - goods.getNoDisAmountValue())));
        goods.setSaleAmount(goods.getSaleValue() - goods.getTotalDiscountValue());
        return goods;
    }

    protected void custDzcMethod(CacheModel cacheModel, DzcGoodsDetail dzc, GoodsInfo goodsInfo) {
        if (null != dzc && dzc.getDzcmsl() == 0.001) {
            dzc.setDzcmsl(1.0);
        }
        cacheModel.setErrCode("");
        cacheModel.setErrMsg("");
        if (goodsInfo != null && "3".equals(goodsInfo.getGbdzcmlx())) {
            if (dzc.getDzcmsl() == 0.0) {
                dzc.setDzcmsl(1.0);
            } else {
                dzc.setDzcmsl(Double.parseDouble(dzc.getOriDzcmsl()));
            }
        }
        if (goodsInfo != null && !"3".equals(goodsInfo.getGbdzcmlx()) && dzc.getDzcmsl() == 0.0) {
            cacheModel.setErrCode("20101");
            cacheModel.setErrMsg("\u4e0d\u7b26\u5408\u79e4\u7801\u89c4\u5219");
        }
    }

    public RespBase getSaleGoodsInfo(ServiceSession session, ResqVo vo) {
        try {
            String errCode;
            JSONObject object3;
            long startTime = System.currentTimeMillis();
            JSONObject paramsObject = vo.getJsonObject();
            ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
            if (!paramsValidateUtils.validate()) {
                return Code.CODE_20000.getRespBase(new Object[0]);
            }
            GetSaleGoodsInfoIn getSaleGoodsInfoIn = (GetSaleGoodsInfoIn)JSONObject.toJavaObject((JSON)paramsObject, GetSaleGoodsInfoIn.class);
            log.info("\u6dfb\u52a0\u5546\u54c1\u5f00\u59cb...>{}", (Object)JSONObject.toJSONString((Object)getSaleGoodsInfoIn));
            if (getSaleGoodsInfoIn.getBarNo().length() >= 18 && getSaleGoodsInfoIn.getBarNo().contains("J")) {
                return this.getSaleGoodsByBatch(session, vo);
            }
            String type = "A";
            CacheModel cacheModel = vo.getCacheModel();
            if (cacheModel == null) {
                return Code.CODE_20001.getRespBase(new Object[0]);
            }
            if (!cacheModel.getOrder().getAllowEditGoods()) {
                return Code.CODE_20002.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
            }
            String jyms = "";
            String yyygzMode = "";
            String fkcxs = "";
            String cmjy = null;
            log.info("\u83b7\u53d6\u7cfb\u7edf\u7f13\u5b58");
            String obj = this.redisUtil.get(RedisKey.CACHEID + getSaleGoodsInfoIn.getShopCode() + getSaleGoodsInfoIn.getTerminalNo());
            log.info("\u83b7\u53d6\u7cfb\u7edf\u7f13\u5b58\u7ed3\u675f");
            obj = this.reCacheMode(obj, paramsObject);
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
            List syspara = modeDetailsVo.getSyspara();
            String grantMode = ModeDetailsVo.getSysParaValue((List)syspara, (String)"SQMS");
            String paravalue = "1";
            JSONArray array = new JSONArray();
            JSONArray sysParaArray = JSONArray.parseArray((String)JSON.toJSONString((Object)syspara));
            if (sysParaArray.size() != 0) {
                for (int i = 0; i < sysParaArray.size(); ++i) {
                    JSONObject sys = sysParaArray.getJSONObject(i);
                    if (sys.get((Object)"code").equals("OZ")) {
                        array.add((Object)sys);
                    }
                    if (sys.get((Object)"code").equals("JYMS")) {
                        jyms = sys.getString("paravalue");
                    }
                    if (sys.get((Object)"code").equals("40")) {
                        yyygzMode = sys.getString("paravalue");
                    }
                    if (sys.get((Object)"code").equals("41")) {
                        fkcxs = sys.getString("paravalue");
                    }
                    if (!sys.get((Object)"code").equals("CMJY")) continue;
                    cmjy = sys.getString("paravalue");
                }
            }
            if (array.size() != 0 && (object3 = array.getJSONObject(0)).containsKey((Object)"paravalue")) {
                paravalue = object3.getString("paravalue");
            }
            String[] temp = paravalue.split(",");
            double maxGoodsCount = CastUtil.castDouble((Object)temp[0]);
            double maxBusinessVolume = CastUtil.castDouble((Object)temp[4]);
            double maxSaleGoodsQuantity = cacheModel.getMaxSaleGoodsQuantity();
            if (maxSaleGoodsQuantity > 0.0 && (double)cacheModel.getOrder().getQty() >= maxSaleGoodsQuantity) {
                return Code.CODE_20042.getRespBase(new Object[0]);
            }
            if (StringUtils.isNotBlank((String)cacheModel.getOrder().getStaffNo())) {
                if (!(cacheModel.getOrder().getStaffSale() || cacheModel.getOrder().getTempZzr() != 0.0 || cacheModel.getOrder().getTempZzk() != 100.0 && cacheModel.getOrder().getTempZzk() != 0.0)) {
                    log.info("\u5458\u5de5\u5361\u6298\u6263\u6539\u4e3a\u53ef\u7528");
                    cacheModel.getOrder().setStaffSale(true);
                } else if (cacheModel.getOrder().getDiscAmount() != 0.0 || cacheModel.getOrder().getTempZzr() != 0.0 || cacheModel.getOrder().getTempZzk() != 0.0 && cacheModel.getOrder().getTempZzk() != 100.0) {
                    log.info("\u5458\u5de5\u5361\u6298\u6263\u6539\u4e3a\u4e0d\u53ef\u7528");
                    cacheModel.getOrder().setStaffSale(false);
                }
            }
            Order order = cacheModel.getOrder();
            session.setEnt_id(cacheModel.getOrder().getEntId());
            Goods goods = null;
            boolean isdzcm = false;
            boolean isNeedFindDzc = true;
            boolean isNeedFindMdm = true;
            boolean isHaveQty = false;
            int priceMode = 0;
            Object originalBarNo = getSaleGoodsInfoIn.getBarNo();
            if (StringUtils.isNotBlank((String)getSaleGoodsInfoIn.getScanCode())) {
                originalBarNo = getSaleGoodsInfoIn.getScanCode();
            }
            int disMode = 0;
            double disValue = 0.0;
            int barNoMode = 0;
            String discType = "0";
            AnalyzeBarcodeDef codeInfo = null;
            if ("Y".equals(yyygzMode) && StringUtils.isNotBlank((String)cacheModel.getCurYyyInfo().getYyygz()) && !this.checkYyyRange(cacheModel.getCurYyyInfo(), yyygzMode, getSaleGoodsInfoIn.getOrgCode())) {
                return Code.CODE_20003.getRespBase(new Object[0]);
            }
            if ("1".equals(cacheModel.getEleCodeMode())) {
                barNoMode = 1;
            }
            if ("1".equals(jyms)) {
                barNoMode = 2;
            }
            DzcGoodsDetail dzc = new DzcGoodsDetail();
            GoodsInfo goodsInfo = null;
            GetGoodsDetailIn queryGoodIn = new GetGoodsDetailIn();
            String splitCode = null;
            if (vo.getJsonObject().containsKey((Object)"splitCode")) {
                splitCode = vo.getJsonObject().getString("splitCode");
            }
            List goodsInfos = null;
            if ("1".equals(getSaleGoodsInfoIn.getCalcMode())) {
                isNeedFindMdm = false;
            }
            if (isNeedFindMdm) {
                boolean b;
                log.info("\u89e3\u6790code\u5f00\u59cb");
                if (getSaleGoodsInfoIn.getBarNo().startsWith("Y")) {
                    b = DateUtils.inTimeFrame((String)getSaleGoodsInfoIn.getBarNo().substring(1, 5));
                    if (!b) {
                        return Code.CODE_20101.getRespBase(new Object[]{"\u8be5\u5546\u54c1\u5df2\u8fc7\u4fdd\u8d28\u671f\uff0c\u4e0d\u5141\u8bb8\u9500\u552e\uff01"});
                    }
                    getSaleGoodsInfoIn.setBarNo(getSaleGoodsInfoIn.getBarNo().substring(5));
                }
                codeInfo = this.analyzeCodeInfo(barNoMode, getSaleGoodsInfoIn.getBarNo(), getSaleGoodsInfoIn.getCalcMode());
                log.info("\u89e3\u6790code\u7ed3\u675f==>{}", (Object)JSONObject.toJSONString((Object)codeInfo));
                if (!codeInfo.getValidate()) {
                    return Code.CODE_20004.getRespBase(new Object[0]);
                }
                getSaleGoodsInfoIn.setBarNo(codeInfo.getBarNo());
                isNeedFindDzc = codeInfo.getIsNeedFindDzc();
                priceMode = codeInfo.getPriceMode();
                disMode = codeInfo.getDisMode();
                disValue = codeInfo.getDisValue();
                barNoMode = codeInfo.getBarNoMode();
                if (getSaleGoodsInfoIn.getBarNo().startsWith("Z")) {
                    getSaleGoodsInfoIn.setBarNo(getSaleGoodsInfoIn.getBarNo().substring(3));
                    priceMode = 2;
                } else if (getSaleGoodsInfoIn.getBarNo().startsWith("D")) {
                    priceMode = 2;
                    b = DateUtils.inTimeFrame1((String)getSaleGoodsInfoIn.getBarNo().substring(3, 8));
                    if (!b) {
                        return Code.CODE_20101.getRespBase(new Object[]{"\u8be5\u5546\u54c1\u5df2\u8fc7\u4fdd\u8d28\u671f"});
                    }
                    getSaleGoodsInfoIn.setBarNo(getSaleGoodsInfoIn.getBarNo().substring(7));
                } else if (getSaleGoodsInfoIn.getBarNo().startsWith("B")) {
                    String dqrq = getSaleGoodsInfoIn.getBarNo().substring(5, 9);
                    boolean b2 = DateUtils.inTimeFrame1((String)dqrq);
                    if (!b2) {
                        return Code.CODE_20101.getRespBase(new Object[]{"\u8be5\u5546\u54c1\u5df2\u8fc7\u4fdd\u8d28\u671f"});
                    }
                    int bzq = CastUtil.castInt((Object)getSaleGoodsInfoIn.getBarNo().substring(1, 5));
                    JSONObject j = new JSONObject();
                    j.put("erpCode", (Object)getSaleGoodsInfoIn.getErpCode());
                    j.put("shopCode", (Object)getSaleGoodsInfoIn.getShopCode());
                    j.put("expDay", (Object)bzq);
                    RespBase res = this.getPosdispara(session, j);
                    if (Code.SUCCESS.getIndex() == res.getRetflag()) {
                        List list = (List)res.getData();
                        long id = 0L;
                        double zkl = 0.0;
                        for (int i = 0; i < list.size(); ++i) {
                            Posdispara bzqVo = (Posdispara)list.get(i);
                            double zkl1 = DateUtils.getZkl((int)bzq, (String)dqrq, (Posdispara)bzqVo);
                            if (!(zkl1 > 0.0) || bzqVo.getId() <= id) continue;
                            zkl = zkl1;
                            id = bzqVo.getId();
                        }
                        if (zkl > 0.0) {
                            priceMode = 2;
                            originalBarNo = (String)originalBarNo + "," + zkl;
                        }
                    }
                    getSaleGoodsInfoIn.setBarNo(getSaleGoodsInfoIn.getBarNo().substring(9));
                }
                if (disValue > 0.0 && getSaleGoodsInfoIn.getQty() > 0.0) {
                    return Code.CODE_20005.getRespBase(new Object[0]);
                }
                if (codeInfo.getBarNo().length() <= 13) {
                    queryGoodIn = GetGoodsDetailIn.transferQueryGoodIn((ServiceSession)session, (GetSaleGoodsInfoIn)getSaleGoodsInfoIn, (int)barNoMode);
                    queryGoodIn.setChannel(order.getChannel());
                    queryGoodIn.setOrderType(order.getOrderType());
                    goodsInfos = this.GetGoodsInfo(queryGoodIn, session, cmjy);
                    if (null != goodsInfos && goodsInfos.size() > 0 && codeInfo.getBarNo().equals(((GoodsInfo)goodsInfos.get(0)).getBarNo())) {
                        isNeedFindMdm = false;
                        isNeedFindDzc = false;
                    }
                }
                if (isNeedFindDzc) {
                    List elecCodeRules = modeDetailsVo.getElecscalecoderule();
                    if (isNeedFindDzc && elecCodeRules.size() > 0) {
                        log.info("\u7535\u5b50\u79e4\u7801\u89e3\u6790\u89c4\u5219\uff1a" + JSONObject.toJSONString((Object)elecCodeRules));
                        log.info("\u7535\u5b50\u79e4\u7801\u89e3\u6790\u89c4\u5219EleCodeMode\uff1a" + cacheModel.getEleCodeMode());
                        log.info("\u89e3\u6790\u7535\u5b50\u79e4\u7801");
                        dzc = this.posLogicCompoment.analyzeBarcode(getSaleGoodsInfoIn.getBarNo(), elecCodeRules, ((Elecscalecoderule)elecCodeRules.get(0)).getExpModeMMDDDays(), ((Elecscalecoderule)elecCodeRules.get(0)).getExpModeDDHHDays(), cacheModel.getEleCodeMode());
                        log.info("\u89e3\u6790\u7535\u5b50\u79e4\u7801\u7ed3\u675f==>{}", (Object)JSONObject.toJSONString((Object)dzc));
                        if (!SellType.ISBACK((String)order.getOrderType()) && dzc.getRetCode() == 2) {
                            return Code.CODE_20006.getRespBase(new Object[0]);
                        }
                        if (dzc.getRetCode() == 1) {
                            isdzcm = true;
                        }
                    }
                }
                if (isdzcm) {
                    queryGoodIn = GetGoodsDetailIn.transferQueryGoodInByDZC((ServiceSession)session, (GetSaleGoodsInfoIn)getSaleGoodsInfoIn, (DzcGoodsDetail)dzc, (int)barNoMode);
                    queryGoodIn.setChannel(order.getChannel());
                    queryGoodIn.setOrderType(order.getOrderType());
                    if (StringUtils.isNotBlank((String)splitCode)) {
                        queryGoodIn.setSplitCode(splitCode);
                    }
                    goodsInfos = this.GetGoodsInfo(queryGoodIn, session, cmjy);
                } else if (isNeedFindMdm) {
                    queryGoodIn = GetGoodsDetailIn.transferQueryGoodIn((ServiceSession)session, (GetSaleGoodsInfoIn)getSaleGoodsInfoIn, (int)barNoMode);
                    if (StringUtils.isNotBlank((String)splitCode)) {
                        queryGoodIn.setSplitCode(splitCode);
                    }
                    queryGoodIn.setChannel(order.getChannel());
                    queryGoodIn.setOrderType(order.getOrderType());
                    goodsInfos = this.GetGoodsInfo(queryGoodIn, session, cmjy);
                }
            }
            if (!"1".equals(getSaleGoodsInfoIn.getCalcMode())) {
                Object resqVo;
                List goodsForCoice;
                if (goodsInfos == null || goodsInfos.size() == 0) {
                    return Code.CODE_20009.getRespBase(new Object[0]);
                }
                if ("h".equalsIgnoreCase(cacheModel.getOrder().getOrderType()) && !"33".equals(((GoodsInfo)goodsInfos.get(0)).getGoodsType())) {
                    return Code.CODE_20111.getRespBase(new Object[0]);
                }
                if (!"h".equals(cacheModel.getOrder().getOrderType()) && "33".equals(((GoodsInfo)goodsInfos.get(0)).getGoodsType())) {
                    return Code.CODE_20112.getRespBase(new Object[0]);
                }
                if (goodsInfos.size() >= 1) {
                    List syjOrg = new ArrayList();
                    Syjgroup syjgroup = cacheModel.getSyjgroup();
                    if (StringUtils.isNotBlank((String)syjgroup.getSourceitem()) && !"ALL".equals(syjgroup.getSourceitem()) && !"0".equals(syjgroup.getSourceitem())) {
                        syjOrg.addAll(syjgroup.getSourceitems());
                    }
                    if ("Y".equals(yyygzMode)) {
                        List yyyOrg = new ArrayList();
                        OperUser curYyyInfo = cacheModel.getCurYyyInfo();
                        if (StringUtils.isNotBlank((String)curYyyInfo.getYyygz()) && !"ALL".equals(curYyyInfo.getYyygz()) && !"0".equals(curYyyInfo.getYyygz())) {
                            yyyOrg = curYyyInfo.getYyygzs();
                        }
                        log.info("syjOrg:{}", (Object)JSONArray.toJSONString(syjOrg));
                        log.info("yyyOrg:{}", (Object)JSONArray.toJSONString(yyyOrg));
                        if (syjOrg.size() <= 0 && yyyOrg.size() > 0) {
                            syjOrg = yyyOrg;
                        } else if (syjOrg.size() > 0 && yyyOrg.size() > 0) {
                            syjOrg.retainAll(yyyOrg);
                        }
                        log.info("syjOrg:{}", (Object)JSONArray.toJSONString(syjOrg));
                    }
                    for (int i = 0; i < goodsInfos.size(); ++i) {
                        GoodsInfo g = (GoodsInfo)goodsInfos.get(i);
                        if (SellType.ISSALE((String)cacheModel.getOrder().getOrderType()) && !g.isAllowSale() || SellType.ISBACK((String)cacheModel.getOrder().getOrderType()) && !g.isAllowRefund()) {
                            goodsInfos.remove(i);
                            --i;
                            continue;
                        }
                        log.info("yyygzMode:{}", (Object)yyygzMode);
                        log.info("syjOrg:{}", (Object)JSONArray.toJSONString(syjOrg));
                        log.info("g.orgCode:{}", (Object)g.getOrgCode());
                        log.info("grantMode:{}", (Object)grantMode);
                        if (this.checkGzRange(g, yyygzMode, syjOrg, grantMode)) continue;
                        goodsInfos.remove(i);
                        --i;
                    }
                    if (goodsInfos.size() == 0) {
                        if (SellType.ISSALE((String)cacheModel.getOrder().getOrderType())) {
                            return Code.CODE_20010.getRespBase(new Object[0]);
                        }
                        if (SellType.ISBACK((String)cacheModel.getOrder().getOrderType())) {
                            return Code.CODE_20011.getRespBase(new Object[0]);
                        }
                    }
                }
                if (goodsInfos.size() > 1) {
                    Object g;
                    int i;
                    boolean isNeedChoice = true;
                    int mainCodeNum = 0;
                    int mainCodeRow = 0;
                    for (i = 0; i < goodsInfos.size(); ++i) {
                        g = (GoodsInfo)goodsInfos.get(i);
                        if (!g.getMainBarcodeFlag()) continue;
                        ++mainCodeNum;
                        mainCodeRow = i;
                    }
                    if (mainCodeNum == 1) {
                        boolean isHaveUnit = false;
                        for (GoodsInfo g2 : goodsInfos) {
                            if ((codeInfo.getBarNo().startsWith("Z") || codeInfo.getBarNo().startsWith("D") || codeInfo.getBarNo().startsWith("B")) && g2.getPartsNum() > 1.0) {
                                return Code.CODE_20190.getRespBase(new Object[0]);
                            }
                            if (g2.getPartsNum() > 1.0) {
                                g2.setSalePrice(ManipulatePrecision.mul((double)g2.getSalePrice(), (double)g2.getPartsNum()));
                            }
                            if (!g2.getMultiUnitFlag()) continue;
                            isHaveUnit = true;
                            break;
                        }
                        if (!isHaveUnit) {
                            goodsInfo = (GoodsInfo)goodsInfos.get(mainCodeRow);
                            isNeedChoice = false;
                        }
                    }
                    if (isNeedChoice) {
                        if (mainCodeNum > 1) {
                            for (i = 0; i < goodsInfos.size(); ++i) {
                                g = (GoodsInfo)goodsInfos.get(i);
                                if (g.getMainBarcodeFlag()) continue;
                                goodsInfos.remove(i);
                                --i;
                            }
                        }
                        GetSaleGoodsInfoOut out = new GetSaleGoodsInfoOut();
                        goodsForCoice = this.goodsTransfer.transferGoodsList(goodsInfos, getSaleGoodsInfoIn.getBarNo());
                        out.setOrder(this.toGoodsForChoice(goodsForCoice));
                        out.setSaleGoodsType("3");
                        if (mainCodeNum == 0 || mainCodeNum > 1) {
                            out.setSaleGoodsType("C");
                        }
                        resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                        return new RespBase(Code.SUCCESS, resqVo, "FINDGOODSTIFY");
                    }
                } else {
                    goodsInfo = (GoodsInfo)goodsInfos.get(0);
                }
                if (StringUtils.isNotBlank((String)goodsInfo.getColourCode()) && StringUtils.isNotBlank((String)goodsInfo.getSizeCode()) && goodsInfo.getGoodsType().equals("6")) {
                    goodsInfos = this.getGoodsInfoForParentCode((JSONObject)JSON.toJSON((Object)queryGoodIn));
                    if (goodsInfos == null || goodsInfos.size() == 0) {
                        return Code.CODE_20009.getRespBase(new Object[0]);
                    }
                    GetSaleGoodsInfoOut out = new GetSaleGoodsInfoOut();
                    List goodsForCoice2 = this.goodsTransfer.transferGoodsList(goodsInfos, getSaleGoodsInfoIn.getBarNo());
                    out.setOrder(this.toGoodsForChoice(goodsForCoice2));
                    out.setSaleGoodsType("B");
                    ResqVo resqVo2 = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                    return new RespBase(Code.SUCCESS, (Object)resqVo2, "FINDGOODSTIFY");
                }
                RespBase allowSale = this.isAllowSale(cacheModel, goodsInfo);
                if (Code.SUCCESS.getIndex() != allowSale.getRetflag()) {
                    log.info("allowSale===>{}", (Object)JSONObject.toJSONString((Object)allowSale));
                    return allowSale;
                }
                if (!this.checkSyjRange(cacheModel, goodsInfo)) {
                    return Code.CODE_20018.getRespBase(new Object[0]);
                }
                if (goodsInfo.getGoodsType().equals("41") && SellType.ISSALE((String)cacheModel.getOrder().getOrderType())) {
                    JSONObject object = new JSONObject();
                    object.put("erpCode", (Object)order.getErpCode());
                    object.put("shopCode", (Object)order.getShopCode());
                    object.put("code", (Object)goodsInfo.getGoodsCode());
                    log.info("\u7279\u5356\u7801\u67e5\u8be2\u5165\u53c20\uff1a" + object.toJSONString());
                    ServiceResponse res = this.querySpecialSale(object);
                    log.info("\u7279\u5356\u7801\u67e5\u8be2\u8fd4\u56de\uff1a" + JSON.toJSONString((Object)res));
                    if ("0".equals(res.getReturncode())) {
                        JSONObject j = (JSONObject)res.getData();
                        if ("N".equals(j.getString("status"))) {
                            return Code.CODE_20110.getRespBase(new Object[0]);
                        }
                        Double price = j.getDouble("price");
                        goodsInfo.setSalePrice(price.doubleValue());
                    }
                }
                if (isdzcm) {
                    this.custDzcMethod(cacheModel, dzc, goodsInfo);
                    if (vo.getCacheModel().getErrCode().equals("20101")) {
                        return Code.CODE_20101.getRespBase(new Object[]{vo.getCacheModel().getErrMsg()});
                    }
                    goodsInfo.setEWCCodeAmount(dzc.getDzcmjg());
                    goodsInfo.setEWCCodeNum(dzc.getDzcmsl());
                    goodsInfo.setExpTime(dzc.getExpTime());
                }
                log.info("SALEPRICE=" + goodsInfo.getSalePrice() + "PRICEMODE=" + priceMode);
                log.info("goodsInfo==>{}", (Object)JSONObject.toJSONString((Object)goodsInfo));
                if ((priceMode != 2 || disMode != 3) && !"2".equals(getSaleGoodsInfoIn.getCalcMode()) && goodsInfo.getSalePrice() == 0.0 && (priceMode == 1 || goodsInfo.getEscaleFlag() != 1 || goodsInfo.getEscaleFlag() == 1 && dzc.getDzcmjg() <= 0.0)) {
                    goodsInfo.setSalePrice(0.0);
                    GetSaleGoodsInfoOut out = new GetSaleGoodsInfoOut();
                    List goodsForCoice3 = this.goodsTransfer.transferGoodsList(goodsInfos, getSaleGoodsInfoIn.getBarNo());
                    out.setOrder(this.toGoodsForChoice(goodsForCoice3));
                    for (GoodsForPos sg : out.getOrder().getGoodsList()) {
                        sg.setSalePrice(0.0);
                    }
                    out.setSaleGoodsType("0");
                    ResqVo resqVo3 = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                    return new RespBase(Code.SUCCESS, (Object)resqVo3, "FINDGOODSTIFY");
                }
                if ("9".equals(goodsInfo.getGoodsType())) {
                    if (getSaleGoodsInfoIn.getQty() > 0.0) {
                        return Code.CODE_20021.getRespBase(new Object[0]);
                    }
                    GetSaleGoodsInfoOut out = new GetSaleGoodsInfoOut();
                    List goodsForCoice4 = this.goodsTransfer.transferGoodsList(goodsInfos, getSaleGoodsInfoIn.getBarNo());
                    out.setOrder(this.toGoodsForChoice(goodsForCoice4));
                    out.setSaleGoodsType("1");
                    ResqVo resqVo4 = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                    return new RespBase(Code.SUCCESS, (Object)resqVo4, "FINDGOODSTIFY");
                }
                if ("U".equalsIgnoreCase(cacheModel.getOrder().getOrderType()) && !"31".equals(goodsInfo.getGoodsType())) {
                    return Code.CODE_20102.getRespBase(new Object[0]);
                }
                if (!"U".equals(cacheModel.getOrder().getOrderType()) && "31".equals(goodsInfo.getGoodsType())) {
                    return Code.CODE_20103.getRespBase(new Object[0]);
                }
                if (cacheModel.getOrder().getHasGroupBuy() && cacheModel.getOrder().getSysPara().getSpecialGoodsType().contains(goodsInfo.getGoodsType())) {
                    return Code.CODE_20106.getRespBase(new Object[0]);
                }
                if (goodsInfo.getControlFlag()) {
                    for (Goods g : cacheModel.getGoodsList()) {
                        if (!g.getControlFlag()) continue;
                        return Code.CODE_20022.getRespBase(new Object[]{g.getBarNo()});
                    }
                    type = "2";
                }
                double qty = 1.0;
                if (getSaleGoodsInfoIn.getQty() > 0.0) {
                    qty = getSaleGoodsInfoIn.getQty();
                    isHaveQty = true;
                }
                goodsInfo.fixGoodsInfoStr();
                if ("2".equals(getSaleGoodsInfoIn.getCalcMode())) {
                    if (ManipulatePrecision.doubleCompare((double)goodsInfo.getSalePrice(), (double)0.0, (int)2) > 0 && ManipulatePrecision.doubleCompare((double)getSaleGoodsInfoIn.getRefPrice(), (double)goodsInfo.getSalePrice(), (int)2) < 0) {
                        return Code.CODE_20095.getRespBase(new Object[0]);
                    }
                    goodsInfo.setSalePrice(getSaleGoodsInfoIn.getRefPrice());
                    goodsInfo.setNoPricing("Y");
                    getSaleGoodsInfoIn.setCalcMode("0");
                }
                log.info("\u7535\u5b50\u79e4\u6807\u8bc6\uff1a" + goodsInfo.getEscaleFlag());
                if (1 == goodsInfo.getEscaleFlag() && dzc.getDzcmsl() <= 0.0 && dzc.getDzcmjg() <= 0.0 && getSaleGoodsInfoIn.getQty() <= 0.0) {
                    GetSaleGoodsInfoOut out = new GetSaleGoodsInfoOut();
                    goodsForCoice = this.goodsTransfer.transferGoodsList(goodsInfos, getSaleGoodsInfoIn.getBarNo());
                    out.setOrder(this.toGoodsForChoice(goodsForCoice));
                    for (GoodsForPos sg : out.getOrder().getGoodsList()) {
                        sg.setSalePrice(0.0);
                    }
                    out.setSaleGoodsType("4");
                    resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                    return new RespBase(Code.SUCCESS, resqVo, "FINDGOODSTIFY");
                }
                ConsumersData consumersData = cacheModel.getOrder().getConsumersData();
                log.info("\u8c03\u7528\u8425\u9500\u4e4b\u524d\u8c03\u7528CalcGoodsAmountBeforeSingle\u65b9\u6cd5");
                goods = this.posLogicService.CalcGoodsAmountBeforeSingle(goodsInfo, getSaleGoodsInfoIn.getAssistantId(), isdzcm, dzc.getDzcmsl(), dzc.getDzcmjg(), cacheModel.getEleCodeMode(), (String)originalBarNo, qty, isHaveQty, cacheModel.getPopMode().intValue());
                log.info("\u8c03\u7528CalcGoodsAmountBeforeSingle\u65b9\u6cd5\u7ed3\u675f==>{}", (Object)JSONObject.toJSONString((Object)goods));
                goods = this.getGoods(consumersData, goods, cacheModel);
                if (null == goods) {
                    if (1 == goodsInfo.getEscaleFlag()) {
                        return Code.CODE_20126.getRespBase(new Object[0]);
                    }
                    return Code.CODE_20023.getRespBase(new Object[0]);
                }
                if (goods.getQty() < 0.001) {
                    return Code.CODE_20127.getRespBase(new Object[0]);
                }
                if ("1".equals(jyms)) {
                    goods.setTempCategory(goods.getArtCode());
                }
                goods.setEatWay(order.getEatWay());
                if (getSaleGoodsInfoIn.getCalcMode().equals("3")) {
                    goods.setEatWay(getSaleGoodsInfoIn.getEatWay());
                    if (null != getSaleGoodsInfoIn.getStallCode() && getSaleGoodsInfoIn.getStallCode().length() > 0) {
                        goods.setStallCode(getSaleGoodsInfoIn.getStallCode());
                    }
                    goods.setCategoryPropertys(goodsInfo.getCategoryPropertys());
                    getSaleGoodsInfoIn.setCalcMode("0");
                }
                goods.setCalcMode(getSaleGoodsInfoIn.getCalcMode());
                goods.setGuid(UUIDUtils.buildGuid());
                goods.setFlowNo(getSaleGoodsInfoIn.getFlowNo());
                goods.setFlowId(cacheModel.getGoodsList().size() + 1);
                log.info("PRICEMODE=" + priceMode + ",DISVALUE=" + goods.getDisValue() + ",DISMODE=" + goods.getDisMode() + ",SALEAMOUNT=" + goods.getSaleAmount() + ",GOODSNO=" + goods.getGoodsNo());
                if (priceMode == 2 && ManipulatePrecision.doubleCompare((double)goods.getDisValue(), (double)0.0, (int)2) > 0) {
                    goods = this.posLogicCompoment.calcGoodsBarcodeDiscBeforeSingle(goods, disMode, disValue, discType);
                }
                if (maxGoodsCount > 0.0 && (double)cacheModel.getGoodsList().size() >= maxGoodsCount) {
                    return Code.CODE_20026.getRespBase(new Object[0]);
                }
                if (cacheModel.getMaxSaleGoodsQuantity() > 0.0 && goods.getQty() > cacheModel.getMaxSaleGoodsQuantity()) {
                    return Code.CODE_20027.getRespBase(new Object[0]);
                }
                if (cacheModel.getMaxSaleGoodsMoney() > 0.0 && goods.getSalePrice() > cacheModel.getMaxSaleGoodsMoney()) {
                    return Code.CODE_20028.getRespBase(new Object[0]);
                }
            }
            boolean isNeedRefreshBillId = false;
            if (null == cacheModel.getGoodsList() || cacheModel.getGoodsList().size() == 0) {
                isNeedRefreshBillId = true;
                String nowDateTime = TimeZoneUtil.ConvertTimeByTimeZone1((Date)new Date(), (String)order.getTimeZone(), (Boolean)this.localcache);
                if (StringUtils.isBlank((String)nowDateTime)) {
                    LocalDateTime dateTime = LocalDateTime.now();
                    DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                    nowDateTime = dateTime.format(df);
                }
                cacheModel.getOrder().setSaleDate(nowDateTime);
                cacheModel = this.changeSaleDate(cacheModel, syspara);
            }
            if (null != getSaleGoodsInfoIn.getRemark() && "" != getSaleGoodsInfoIn.getRemark()) {
                goods.setRemark(getSaleGoodsInfoIn.getRemark());
            }
            session.setEnt_id(2L);
            if (cacheModel.getPopMode() == 1) {
                log.info("\u8c03\u7528calcSinglePopService");
                RespBase respBase = this.calcPopRemoteService.calcSinglePopService(session, getSaleGoodsInfoIn.getCalcMode(), getSaleGoodsInfoIn.getGuid(), goods, vo, getSaleGoodsInfoIn.getPopDetails(), true, isNeedRefreshBillId, false);
                log.info("\u8c03\u7528\u7ed3\u675f=={}", (Object)JSONObject.toJSONString((Object)respBase));
                if (respBase.getRetflag() != 0) {
                    return respBase;
                }
                ResqVo resqVo = (ResqVo)respBase.getData();
                cacheModel = resqVo.getCacheModel();
                log.info(">>>>1.posLogicCompoment.calcOrderAmount");
                this.posLogicCompoment.calcOrderAmount(cacheModel);
                log.info("<<<<<2.posLogicCompoment.calcOrderAmount");
            } else if (cacheModel.getPopMode() == 2) {
                String calcMode = "0";
                if (StringUtils.isEmpty((String)goods.getPopFlag())) {
                    goods.setPopFlag("1");
                }
                cacheModel = this.addOneGoods(cacheModel, goods);
                log.info(">>>>5.posLogicCompoment.calcOrderAmount");
                this.posLogicCompoment.calcOrderAmount(cacheModel);
                log.info("<<<<<6.posLogicCompoment.calcOrderAmount");
                ArrayList<String> guidList = new ArrayList<String>();
                for (Goods goods1 : cacheModel.getGoodsList()) {
                    guidList.add(goods1.getGuid());
                }
                cacheModel.getOrder().setSeqNo("");
                cacheModel = this.calcOrderPop(session, calcMode, cacheModel, vo, guidList);
                if (-1 == cacheModel.getCalcResult()) {
                    errCode = "100000";
                    if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                        errCode = cacheModel.getErrCode();
                    }
                    for (Code code : Code.values()) {
                        if (code.getIndex() != Integer.parseInt(errCode)) continue;
                        return code.getRespBase(new Object[]{cacheModel.getErrMsg()});
                    }
                    return new RespBase(Integer.parseInt(errCode), cacheModel.getErrMsg(), (Object)vo);
                }
            } else {
                cacheModel = this.addOneGoods(cacheModel, goods);
                log.info(">>>>3.posLogicCompoment.calcOrderAmount");
                this.posLogicCompoment.calcOrderAmount(cacheModel);
                log.info("<<<<<4.posLogicCompoment.calcOrderAmount");
            }
            log.info("fkcxs==>{},goods.getIsExcessSale()==>{},goods.getGbmanamode()==>{}", new Object[]{fkcxs, goods.getIsExcessSale(), goods.getGbmanamode()});
            if ("N".equals(fkcxs) && 0 == goods.getIsExcessSale() && "1".equals(goods.getGbmanamode())) {
                HashSet<String> goodsCodes = new HashSet<String>();
                goodsCodes.add(goods.getGoodsCode());
                log.info("\u5224\u65ad\u662f\u5426\u5141\u8bb8\u8d1f\u5e93\u5b58\u9500\u552e\u5f00\u59cb");
                RespBase response = this.searchShopStock(session, cacheModel, goodsCodes);
                log.info("\u5224\u65ad\u662f\u5426\u5141\u8bb8\u8d1f\u5e93\u5b58\u9500\u552e\u7ed3\u675f");
                if (Code.SUCCESS.getIndex() != response.getRetflag()) {
                    return response;
                }
            }
            long beforeSaveUpdateTime = System.currentTimeMillis();
            log.info("\u6dfb\u52a0\u5546\u54c1,flowNo:\u3010{}\u3011,\u8017\u65f6\uff1a\u3010{}\u3011\u6beb\u79d2", (Object)cacheModel.getFlowNo(), (Object)(beforeSaveUpdateTime - startTime));
            if (maxBusinessVolume > 0.0) {
                log.info("\u6574\u5355\u6700\u5927\u91d1\u989dmaxBusinessVolume\uff1a " + maxBusinessVolume);
                if (cacheModel.getOrder().getOughtPay() > maxBusinessVolume) {
                    return Code.CODE_20045.getRespBase(new Object[0]);
                }
            }
            if (cacheModel.getOrder().getTempZzk() != 0.0 && -1 == (cacheModel = this.posLogicCompoment.calcOrderRebateByRate(cacheModel, cacheModel.getCurGrant().getGh(), cacheModel.getOrder().getTempZzk())).getCalcResult()) {
                errCode = "100000";
                if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                    errCode = cacheModel.getErrCode();
                }
                for (Code code : Code.values()) {
                    if (code.getIndex() != Integer.parseInt(errCode)) continue;
                    return code.getRespBase(new Object[]{cacheModel.getErrMsg()});
                }
                return new RespBase(Integer.parseInt(errCode), cacheModel.getErrMsg(), (Object)vo);
            }
            if (cacheModel.getOrder().getTempZzr() != 0.0 && -1 == (cacheModel = this.posLogicCompoment.calcOrderRebateByAmount(cacheModel, cacheModel.getCurGrant().getGh(), cacheModel.getOrder().getTempZzr())).getCalcResult()) {
                errCode = "100000";
                if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                    errCode = cacheModel.getErrCode();
                }
                for (Code code : Code.values()) {
                    if (code.getIndex() != Integer.parseInt(errCode)) continue;
                    return code.getRespBase(new Object[]{cacheModel.getErrMsg()});
                }
                return new RespBase(Integer.parseInt(errCode), cacheModel.getErrMsg(), (Object)vo);
            }
            long afterSaveUpdateTime = System.currentTimeMillis();
            log.info("\u6dfb\u52a0\u5546\u54c1,save:\u3010{}\u3011,\u8017\u65f6\uff1a\u3010{}\u3011\u6beb\u79d2", (Object)cacheModel.getFlowNo(), (Object)(afterSaveUpdateTime - beforeSaveUpdateTime));
            GetSaleGoodsInfoOut out = new GetSaleGoodsInfoOut();
            log.info(">>>>>>>>>>>>>>>>>>>>>>>");
            out.setOrder(this.orderTransfer.toOrderForPosSingle(cacheModel));
            out.setSaleGoodsType(type);
            log.info("<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
            return new RespBase(Code.SUCCESS, (Object)resqVo, "FINDGOODSTIFY");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Code.CODE_20029.getRespBase(new Object[]{Utils.getLastExceptionMessage((Exception)e)});
        }
    }

    public RespBase updateCartGoods(ServiceSession session, ResqVo vo) {
        try {
            JSONObject object3;
            JSONObject paramsObject = vo.getJsonObject();
            log.info("updateCartGoods===>{}", (Object)paramsObject.toJSONString());
            ParamsValidateUtils paramsValidate = new ParamsValidateUtils(session, paramsObject);
            if (!paramsValidate.validate()) {
                return Code.CODE_20030.getRespBase(new Object[0]);
            }
            if (!paramsObject.containsKey((Object)"barNo") || paramsObject.getString("barNo").isEmpty()) {
                return Code.CODE_20031.getRespBase(new Object[0]);
            }
            if (!paramsObject.containsKey((Object)"guid") || paramsObject.getString("guid").isEmpty()) {
                return Code.CODE_20032.getRespBase(new Object[0]);
            }
            if (!paramsObject.containsKey((Object)"calcMode") || paramsObject.getString("calcMode").isEmpty()) {
                return Code.CODE_20033.getRespBase(new Object[0]);
            }
            String flag = paramsObject.getString("flag");
            if ("0".equals(flag) && (!paramsObject.containsKey((Object)"qty") || paramsObject.getDouble("qty") == 0.0)) {
                return Code.CODE_20034.getRespBase(new Object[0]);
            }
            UpdateCartGoodsIn updateGoodsIn = (UpdateCartGoodsIn)JSON.toJavaObject((JSON)paramsObject, UpdateCartGoodsIn.class);
            String obj = this.redisUtil.get(RedisKey.CACHEID + updateGoodsIn.getShopCode() + updateGoodsIn.getTerminalNo());
            obj = this.reCacheMode(obj, paramsObject);
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
            String fkcxs = "";
            String paravalue = "1";
            JSONArray array = new JSONArray();
            List sysParaList = modeDetailsVo.getSyspara();
            JSONArray sysParaArray = JSONArray.parseArray((String)JSON.toJSONString((Object)sysParaList));
            if (sysParaArray.size() != 0) {
                for (int i = 0; i < sysParaArray.size(); ++i) {
                    JSONObject sys = sysParaArray.getJSONObject(i);
                    if (sys.get((Object)"code").equals("OZ")) {
                        array.add((Object)sys);
                    }
                    if (!sys.get((Object)"code").equals("41")) continue;
                    fkcxs = sys.getString("paravalue");
                }
            }
            if (array.size() != 0 && (object3 = array.getJSONObject(0)).containsKey((Object)"paravalue")) {
                paravalue = object3.getString("paravalue");
            }
            String[] temp = paravalue.split(",");
            double maxBusinessVolume = CastUtil.castDouble((Object)temp[4]);
            String flowNo = updateGoodsIn.getFlowNo();
            CacheModel cacheModel = vo.getCacheModel();
            session.setEnt_id(cacheModel.getOrder().getEntId());
            if (cacheModel == null) {
                return Code.CODE_20035.getRespBase(new Object[0]);
            }
            if ("Y12".equals(cacheModel.getOrder().getOrderType())) {
                return Code.CODE_20096.getRespBase(new Object[0]);
            }
            if (!cacheModel.getOrder().getAllowEditGoods()) {
                return Code.CODE_20036.getRespBase(new Object[]{flowNo});
            }
            if (cacheModel.getGoodsList() == null || cacheModel.getGoodsList().size() == 0) {
                return Code.CODE_20037.getRespBase(new Object[0]);
            }
            Goods existGoods = this.goodsTransfer.findGoods(updateGoodsIn.getGuid(), cacheModel.getGoodsList());
            double tempzkl = existGoods.getTempZkl();
            double tempzr = existGoods.getTempZrDiscount();
            double discamount = existGoods.getDiscAmount();
            if (existGoods == null) {
                return Code.CODE_20038.getRespBase(new Object[0]);
            }
            if ((!SellType.ISBACK((String)cacheModel.getOrder().getOrderType()) || null != cacheModel.getOrder().getOriginTerminalSno() && cacheModel.getOrder().getOriginTerminalSno().length() > 0) && existGoods.getGoodsType().equals("15")) {
                return Code.CODE_20097.getRespBase(new Object[0]);
            }
            if ("99".equals(existGoods.getGoodsType()) || "98".equals(existGoods.getGoodsType())) {
                return Code.CODE_20098.getRespBase(new Object[0]);
            }
            if (StringUtils.isNotBlank((String)existGoods.getEBillFlowNo())) {
                return Code.CODE_20113.getRespBase(new Object[0]);
            }
            if ("9".equals(existGoods.getFlag()) && !"0".equals(updateGoodsIn.getFlag())) {
                return Code.CODE_20107.getRespBase(new Object[0]);
            }
            if (StringUtils.isNotBlank((String)existGoods.getEBillFlowNo())) {
                return Code.CODE_20138.getRespBase(new Object[0]);
            }
            String accreditNo = paramsObject.getString("accreditNo");
            if (StringUtils.isBlank((String)accreditNo)) {
                accreditNo = cacheModel.getCurGrant().getGh();
            }
            Goods updateGoods = existGoods.deepClone();
            double oldAmount = existGoods.getSaleAmount();
            double orderTempZzk = cacheModel.getOrder().getTempZzk();
            double orderTempZzr = cacheModel.getOrder().getTempZzr();
            if ("3".equals(updateGoodsIn.getCalcMode())) {
                existGoods.setEatWay(updateGoodsIn.getEatWay());
                updateGoodsIn.setCalcMode("0");
                if (null != updateGoodsIn.getCategoryPropertys() && updateGoodsIn.getCategoryPropertys().size() > 0) {
                    existGoods.setCategoryPropertys(updateGoodsIn.getCategoryPropertys());
                } else {
                    existGoods.setCategoryPropertys(new ArrayList());
                }
            }
            if ("4".equals(updateGoodsIn.getCalcMode())) {
                if (null == cacheModel.getOrder().getConsumersData().getConsumersId() || cacheModel.getOrder().getConsumersData().getConsumersId().length() <= 0) {
                    return Code.CODE_20040.getRespBase(new Object[0]);
                }
                if (!existGoods.getFlag().equals("1") && !existGoods.getFlag().equals("7")) {
                    return Code.CODE_20041.getRespBase(new Object[0]);
                }
                if (existGoods.getFlag().equals("1")) {
                    existGoods.setFlag("7");
                } else {
                    existGoods.setFlag("1");
                    existGoods.setPopFlag("");
                }
                updateGoodsIn.setCalcMode("0");
            }
            if ("0".equals(flag)) {
                if (cacheModel.getMaxSaleGoodsQuantity() > 0.0 && (updateGoodsIn.getQty() > cacheModel.getMaxSaleGoodsQuantity() || updateGoodsIn.getQty() < 0.0)) {
                    return Code.CODE_20042.getRespBase(new Object[0]);
                }
                if ("T".equals(cacheModel.getCurGrant().getPrivqt9())) {
                    Goods sg = (Goods)cacheModel.getGoodsList().get(existGoods.getFlowId() - 1);
                    if (updateGoodsIn.getQty() < sg.getQty()) {
                        return Code.CODE_20116.getRespBase(new Object[0]);
                    }
                }
                RespBase resp = this.isAllowEditQty(cacheModel, existGoods.getFlowId(), updateGoodsIn.getQty());
                if (Code.SUCCESS.getIndex() != resp.getRetflag()) {
                    return resp;
                }
                if ((cacheModel = this.posLogicService.EditGoodsQtyBeforeSingle(cacheModel, existGoods.getFlowId(), accreditNo, updateGoodsIn.getQty())).getCalcResult() == -1) {
                    String errCode = "100000";
                    if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                        errCode = cacheModel.getErrCode();
                    }
                    for (Code code : Code.values()) {
                        if (code.getIndex() != Integer.parseInt(errCode)) continue;
                        return code.getRespBase(new Object[]{cacheModel.getErrMsg()});
                    }
                    return Code.CODE_20090.getRespBase(new Object[]{cacheModel.getErrMsg()});
                }
                log.info("\u4fee\u6539\u6570\u91cf\u7ed3\u675f");
                existGoods = (Goods)cacheModel.getGoodsList().get(existGoods.getFlowId() - 1);
            }
            if ("1".equals(flag) || "3".equals(flag)) {
                if (cacheModel.getMaxSaleGoodsMoney() > 0.0 && updateGoodsIn.getRefPrice() > cacheModel.getMaxSaleGoodsMoney()) {
                    return Code.CODE_20043.getRespBase(new Object[0]);
                }
                if (updateGoodsIn.getRefPrice() < 0.0) {
                    return Code.CODE_20128.getRespBase(new Object[0]);
                }
                if ("3".equals(flag)) {
                    log.info("\u4fee\u6539\u6210\u4ea4\u4ef7,popFlag\u6539\u4e3aJ");
                    existGoods.setPopFlag("J");
                }
                for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
                    Code[] goods = (Code[])cacheModel.getGoodsList().get(i);
                    String guid = updateGoodsIn.getGuid();
                    if (!guid.equals(goods.getGuid())) continue;
                    log.info("\u66f4\u65b0goods==>{}", (Object)existGoods);
                    cacheModel.getGoodsList().set(i, existGoods);
                }
                if (-1 == (cacheModel = this.posLogicService.EditGoodsPriceBeforeSingle(cacheModel, existGoods.getFlowId(), accreditNo, updateGoodsIn.getRefPrice())).getCalcResult()) {
                    String errCode = "100000";
                    if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                        errCode = cacheModel.getErrCode();
                    }
                    for (Code code : Code.values()) {
                        if (code.getIndex() != Integer.parseInt(errCode)) continue;
                        return code.getRespBase(new Object[]{cacheModel.getErrMsg()});
                    }
                    return new RespBase(Integer.parseInt(errCode), cacheModel.getErrMsg(), (Object)vo);
                }
                existGoods = (Goods)cacheModel.getGoodsList().get(existGoods.getFlowId() - 1);
                log.info(">>>>existGoods==>{}", (Object)JSONObject.toJSONString((Object)existGoods));
            }
            if ("2".equals(flag) || "4".equals(flag)) {
                if (cacheModel.getMaxSaleGoodsMoney() > 0.0 && updateGoodsIn.getRefPrice() > cacheModel.getMaxSaleGoodsMoney()) {
                    return Code.CODE_20044.getRespBase(new Object[0]);
                }
                if ("4".equals(flag)) {
                    existGoods.setPopFlag("J");
                    if (StringUtils.isNotBlank((String)updateGoodsIn.getFdmode())) {
                        existGoods.setFdmode(updateGoodsIn.getFdmode());
                        existGoods.setFdresult(updateGoodsIn.getFdresult());
                        existGoods.setPopzkfd(updateGoodsIn.getPopzkfd());
                    }
                }
                if (-1 == (cacheModel = this.posLogicService.FixGoodsPriceBeforeSingle(cacheModel, existGoods.getFlowId(), accreditNo, updateGoodsIn.getRefPrice())).getCalcResult()) {
                    String errCode = "100000";
                    if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                        errCode = cacheModel.getErrCode();
                    }
                    for (Code code : Code.values()) {
                        if (code.getIndex() != Integer.parseInt(errCode)) continue;
                        return code.getRespBase(new Object[]{cacheModel.getErrMsg()});
                    }
                    return new RespBase(Integer.parseInt(errCode), cacheModel.getErrMsg(), (Object)vo);
                }
                existGoods = (Goods)cacheModel.getGoodsList().get(existGoods.getFlowId() - 1);
            }
            if (((existGoods = this.getGoods(cacheModel.getOrder().getConsumersData(), existGoods, cacheModel)).getGoodsNo().startsWith("Z") || existGoods.getGoodsNo().startsWith("D") || existGoods.getGoodsNo().startsWith("B")) && ManipulatePrecision.doubleCompare((double)existGoods.getDisValue(), (double)0.0, (int)2) > 0) {
                existGoods = this.posLogicCompoment.calcGoodsBarcodeDiscBeforeSingle(existGoods, 0, 0.0, "0");
            }
            if (cacheModel.getPopMode() == 1) {
                log.info("\u5f00\u59cb\u8ba1\u7b97\u5355\u884c!");
                vo.setCacheModel(cacheModel);
                RespBase respBase = this.calcPopRemoteService.calcSinglePopService(session, updateGoodsIn.getCalcMode(), updateGoodsIn.getGuid(), existGoods, vo, null, false, false, true);
                if (respBase.getRetflag() != 0) {
                    return respBase;
                }
                ResqVo resqVo = (ResqVo)respBase.getData();
                cacheModel = resqVo.getCacheModel();
                this.posLogicCompoment.calcOrderAmount(cacheModel);
            } else if (cacheModel.getPopMode() == 2) {
                String calcMode = "0";
                Code[] guidList = new ArrayList();
                for (Code[] goods1 : cacheModel.getGoodsList()) {
                    guidList.add(goods1.getGuid());
                }
                if (-1 == (cacheModel = this.calcOrderPop(session, calcMode, cacheModel, vo, (List)guidList)).getCalcResult()) {
                    String errCode = "100000";
                    if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                        errCode = cacheModel.getErrCode();
                    }
                    for (Code code : Code.values()) {
                        if (code.getIndex() != Integer.parseInt(errCode)) continue;
                        return code.getRespBase(new Object[]{cacheModel.getErrMsg()});
                    }
                    return new RespBase(Integer.parseInt(errCode), cacheModel.getErrMsg(), (Object)vo);
                }
                this.posLogicCompoment.calcOrderAmount(cacheModel);
            } else {
                this.posLogicCompoment.calcOrderAmount(cacheModel);
            }
            if (cacheModel.getCalcResult() == -1) {
                String errCode = "100000";
                if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                    errCode = cacheModel.getErrCode();
                }
                for (Code code : Code.values()) {
                    if (code.getIndex() != Integer.parseInt(errCode)) continue;
                    return code.getRespBase(new Object[]{cacheModel.getErrMsg()});
                }
                return Code.CODE_20092.getRespBase(new Object[]{cacheModel.getErrMsg()});
            }
            if ("0".equals(updateGoodsIn.getFlag())) {
                if (ManipulatePrecision.doubleCompare((double)tempzkl, (double)100.0, (int)2) < 0) {
                    cacheModel = this.posLogicCompoment.calcGoodsRebateByRate(cacheModel, existGoods.getFlowId(), accreditNo, tempzkl);
                } else if (ManipulatePrecision.doubleCompare((double)tempzr, (double)0.0, (int)2) > 0) {
                    cacheModel = ManipulatePrecision.doubleCompare((double)discamount, (double)0.0, (int)2) > 0 ? this.posLogicCompoment.calcGoodsRebateByAmount(cacheModel, existGoods.getFlowId(), accreditNo, discamount, 1) : this.posLogicCompoment.calcGoodsRebateByAmount(cacheModel, existGoods.getFlowId(), accreditNo, tempzr);
                }
            }
            if (cacheModel.getMaxSaleMoney() > 0.0 && cacheModel.getOrder().getOughtPay() > maxBusinessVolume) {
                return Code.CODE_20045.getRespBase(new Object[0]);
            }
            Goods returnGoods = this.goodsTransfer.findGoods(updateGoodsIn.getGuid(), cacheModel.getGoodsList());
            returnGoods.setCategoryPropertys(existGoods.getCategoryPropertys());
            if (orderTempZzk != 0.0) {
                cacheModel = this.posLogicCompoment.calcOrderRebateByRate(cacheModel, cacheModel.getCurGrant().getGh(), orderTempZzk);
            }
            if (orderTempZzr != 0.0) {
                cacheModel = this.posLogicCompoment.calcOrderRebateByAmount(cacheModel, cacheModel.getCurGrant().getGh(), orderTempZzr);
            }
            double newAmount = returnGoods.getSaleAmount();
            if ("1".equals(flag) || "3".equals(flag)) {
                this.goodsTask.sendWorkLog(session, cacheModel.getOrder(), WorkLogType.editPrice, existGoods.getQty(), ManipulatePrecision.doubleConvert((double)(oldAmount - newAmount)), existGoods.getGoodsName(), existGoods.getGoodsCode());
            } else if ("2".equals(flag)) {
                this.goodsTask.sendWorkLog(session, cacheModel.getOrder(), WorkLogType.rebate, existGoods.getQty(), ManipulatePrecision.doubleConvert((double)(oldAmount - newAmount)), existGoods.getGoodsName(), existGoods.getGoodsCode());
            } else if ("0".equals(flag) && oldAmount > newAmount) {
                this.goodsTask.sendWorkLog(session, cacheModel.getOrder(), WorkLogType.editQty, existGoods.getQty(), ManipulatePrecision.doubleConvert((double)(oldAmount - newAmount)), existGoods.getGoodsName(), existGoods.getGoodsCode());
            }
            UpdateCartGoodsOut out = new UpdateCartGoodsOut();
            out.setOrder(this.orderTransfer.toOrderForPosSingle(cacheModel));
            if ("0".equals(flag)) {
                DelGoodsInfo updateGood = new DelGoodsInfo();
                updateGood.setBarNo(updateGoods.getBarNo());
                updateGood.setGoodsCode(updateGoods.getGoodsCode());
                updateGood.setGoodsDisplayName(updateGoods.getGoodsDisplayName());
                updateGood.setGoodsName(updateGoods.getGoodsName());
                updateGood.setGoodsNo(updateGoods.getGoodsNo());
                updateGood.setQty(updateGoods.getQty());
                updateGood.setSaleAmount(ManipulatePrecision.doubleConvert((double)(oldAmount - newAmount)));
                out.setUpdateGood(updateGood);
            }
            if (updateGoods.getQty() < existGoods.getQty() && "N".equals(fkcxs) && 0 == updateGoods.getIsExcessSale() && "1".equals(updateGoods.getGbmanamode())) {
                HashSet<String> goodsCodes = new HashSet<String>();
                goodsCodes.add(existGoods.getGoodsCode());
                RespBase response = this.searchShopStock(session, cacheModel, goodsCodes);
                if (Code.SUCCESS.getIndex() != response.getRetflag()) {
                    return response;
                }
            }
            ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
            return new RespBase(Code.SUCCESS, (Object)resqVo, "CHANGEGOODSTIFY");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            return Code.CODE_20046.getRespBase(new Object[]{Utils.getLastExceptionMessage((Exception)e)});
        }
    }

    public RespBase<ResqVo> queryGoodsDetail(ServiceSession session, ResqVo vo) {
        String cmjy;
        JSONObject paramsObject = vo.getJsonObject();
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validateWithOutFlowNoAndOperator()) {
            return Code.CODE_20080.getRespBase(new Object[0]);
        }
        String shopCode = paramsObject.getString("shopCode");
        if (StringUtils.isBlank((String)shopCode)) {
            return Code.CODE_20099.getRespBase(new Object[0]);
        }
        String erpCode = paramsObject.getString("erpCode");
        String eleMode = "";
        if (StringUtils.isBlank((String)erpCode)) {
            return Code.CODE_20081.getRespBase(new Object[0]);
        }
        String channel = paramsObject.getString("channel");
        if (StringUtils.isBlank((String)channel)) {
            return Code.CODE_20082.getRespBase(new Object[0]);
        }
        String barNo = paramsObject.getString("barNo");
        if (StringUtils.isBlank((String)barNo)) {
            return Code.CODE_20083.getRespBase(new Object[0]);
        }
        if (StringUtils.isBlank((String)paramsObject.getString("entId"))) {
            return Code.CODE_20084.getRespBase(new Object[0]);
        }
        int eid = Integer.parseInt(paramsObject.getString("entId"));
        session.setEnt_id((long)eid);
        QueryGoodIn queryGoodIn = (QueryGoodIn)JSON.parseObject((String)paramsObject.toJSONString(), QueryGoodIn.class);
        ArrayList<Goods> goodsList = new ArrayList<Goods>();
        ElecScaleCodeRuleIn elecScaleCodeRuleIn = new ElecScaleCodeRuleIn();
        elecScaleCodeRuleIn.setErpCode(erpCode);
        elecScaleCodeRuleIn.setMkt(paramsObject.getString("shopCode"));
        String obj = this.redisUtil.get(RedisKey.CACHEID + queryGoodIn.getShopCode() + queryGoodIn.getTerminalNo());
        obj = this.reCacheMode(obj, paramsObject);
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        List elerules = modeDetailsVo.getElecscalecoderule();
        List sysparaList = modeDetailsVo.getSyspara();
        String grantMode = ModeDetailsVo.getSysParaValue((List)sysparaList, (String)"SQMS");
        String discType = "0";
        String codeRule = "";
        String yyygzMode = "";
        if (sysparaList.size() != 0 || sysparaList != null) {
            for (int i = 0; i < sysparaList.size(); ++i) {
                Syspara syspara = (Syspara)sysparaList.get(i);
                String code = syspara.getCode();
                if ("CMJY".equals(code)) {
                    codeRule = syspara.getParavalue();
                }
                if (!"40".equals("code")) continue;
                yyygzMode = syspara.getParavalue();
            }
        }
        ArrayList<String> codes = new ArrayList<String>();
        codes.add("JYMS");
        codes.add("CWYH");
        codes.add("PRTSEQ");
        codes.add("POPPRTMODE");
        codes.add("CMJY");
        codes.add("CWYH");
        codes.add("YDZC");
        SysParaInfo sysPara = this.initSysParaInfo(sysparaList);
        boolean isdzcm = false;
        boolean isNeedFindMdm = true;
        DzcGoodsDetail dzc = null;
        boolean isNeedFindDzc = true;
        int priceMode = 0;
        Object originalBarNo = null;
        int disMode = 0;
        double disValue = 0.0;
        int barNoMode = sysPara.getBarCodeMode();
        Goods goods = new Goods();
        GoodsInfo goodsInfo = null;
        GetGoodsDetailIn getGoodsDetailIn = new GetGoodsDetailIn();
        List goodsInfos = null;
        AnalyzeBarcodeDef codeInfo = this.analyzeCodeInfo(barNoMode, queryGoodIn.getBarNo(), "0");
        if (!codeInfo.getValidate()) {
            return Code.CODE_20085.getRespBase(new Object[0]);
        }
        queryGoodIn.setBarNo(codeInfo.getBarNo());
        isNeedFindDzc = codeInfo.getIsNeedFindDzc();
        priceMode = codeInfo.getPriceMode();
        originalBarNo = codeInfo.getOriginalBarNo();
        disMode = codeInfo.getDisMode();
        disValue = codeInfo.getDisValue();
        barNoMode = codeInfo.getBarNoMode();
        if (codeInfo.getBarNo().length() <= 18 && null != (goodsInfos = this.GetGoodsInfo(getGoodsDetailIn = GetGoodsDetailIn.transferQueryGoodInToOrderQueryIn((QueryGoodIn)queryGoodIn, (int)barNoMode), session, cmjy = modeDetailsVo.getSysparaValue("CMJY"))) && goodsInfos.size() > 0 && codeInfo.getBarNo().equals(((GoodsInfo)goodsInfos.get(0)).getBarNo())) {
            isNeedFindMdm = false;
        }
        if (isNeedFindMdm) {
            if (queryGoodIn.getBarNo().startsWith("Y")) {
                boolean b = DateUtils.inTimeFrame((String)queryGoodIn.getBarNo().substring(1, 5));
                if (!b) {
                    return Code.CODE_20101.getRespBase(new Object[]{"\u8be5\u5546\u54c1\u5df2\u8fc7\u4fdd\u8d28\u671f"});
                }
                queryGoodIn.setBarNo(queryGoodIn.getBarNo().substring(5));
            } else if (queryGoodIn.getBarNo().startsWith("Z")) {
                queryGoodIn.setBarNo(queryGoodIn.getBarNo().substring(3));
                priceMode = 2;
            } else if (queryGoodIn.getBarNo().startsWith("D")) {
                priceMode = 2;
                boolean b = DateUtils.inTimeFrame1((String)queryGoodIn.getBarNo().substring(4, 8));
                if (!b) {
                    return Code.CODE_20101.getRespBase(new Object[]{"\u8be5\u5546\u54c1\u5df2\u8fc7\u4fdd\u8d28\u671f"});
                }
                queryGoodIn.setBarNo(queryGoodIn.getBarNo().substring(7));
            } else if (queryGoodIn.getBarNo().startsWith("B")) {
                String dqrq = queryGoodIn.getBarNo().substring(5, 9);
                boolean b = DateUtils.inTimeFrame1((String)dqrq);
                if (!b) {
                    return Code.CODE_20101.getRespBase(new Object[]{"\u8be5\u5546\u54c1\u5df2\u8fc7\u4fdd\u8d28\u671f"});
                }
                int bzq = CastUtil.castInt((Object)queryGoodIn.getBarNo().substring(1, 5));
                JSONObject j = new JSONObject();
                j.put("erpCode", (Object)queryGoodIn.getErpCode());
                j.put("shopCode", (Object)queryGoodIn.getShopCode());
                j.put("expDay", (Object)bzq);
                RespBase res = this.getPosdispara(session, j);
                if (Code.SUCCESS.getIndex() == res.getRetflag()) {
                    List list = (List)res.getData();
                    long id = 0L;
                    double zkl = 0.0;
                    for (int i = 0; i < list.size(); ++i) {
                        Posdispara bzqVo = (Posdispara)list.get(i);
                        double zkl1 = DateUtils.getZkl((int)bzq, (String)dqrq, (Posdispara)bzqVo);
                        if (!(zkl1 > 0.0) || bzqVo.getId() <= id) continue;
                        zkl = zkl1;
                        id = bzqVo.getId();
                    }
                    if (zkl > 0.0) {
                        priceMode = 2;
                        originalBarNo = (String)originalBarNo + "," + zkl;
                    }
                }
                queryGoodIn.setBarNo(queryGoodIn.getBarNo().substring(9));
            }
            if (elerules.size() > 0 && isNeedFindDzc) {
                dzc = this.posLogicCompoment.analyzeBarcode(queryGoodIn.getBarNo(), elerules, ((Elecscalecoderule)elerules.get(0)).getExpModeMMDDDays(), ((Elecscalecoderule)elerules.get(0)).getExpModeDDHHDays(), codeRule);
                if (dzc.getRetCode() == 2) {
                    return Code.CODE_20086.getRespBase(new Object[0]);
                }
                if (dzc.getRetCode() == 1) {
                    isdzcm = true;
                }
            }
            if (null == (goodsInfos = this.GetGoodsInfo(getGoodsDetailIn = isdzcm ? GetGoodsDetailIn.transferQueryGoodInToOrderQueryIn((QueryGoodIn)queryGoodIn, dzc, (int)barNoMode) : GetGoodsDetailIn.transferQueryGoodInToOrderQueryIn((QueryGoodIn)queryGoodIn, (int)barNoMode), session, cmjy = modeDetailsVo.getSysparaValue("CMJY"))) || goodsInfos.size() == 0) {
                if (isdzcm) {
                    return Code.CODE_20087.getRespBase(new Object[0]);
                }
                if (disValue == 0.0 && getGoodsDetailIn.getCode().length() < 13) {
                    getGoodsDetailIn.setCode(Convert.padLeft((String)getGoodsDetailIn.getCode(), (char)'0', (int)13));
                    goodsInfos = this.GetGoodsInfo(getGoodsDetailIn, session, cmjy);
                    if (null == goodsInfos || goodsInfos.size() == 0) {
                        return Code.CODE_20087.getRespBase(new Object[0]);
                    }
                } else {
                    return Code.CODE_20087.getRespBase(new Object[0]);
                }
            }
        }
        if (goodsInfos.size() >= 1 && !"1".equals(queryGoodIn.getType())) {
            ArrayList syjOrg = new ArrayList();
            List sourceitems = modeDetailsVo.getSyjmain().getSourceitem();
            log.info("sourceitems:{}", (Object)JSON.toJSONString((Object)sourceitems));
            if ("Y".equals(modeDetailsVo.getSyjmain().getIsts())) {
                sourceitems.set(0, "ALL");
            }
            if (null != sourceitems && sourceitems.size() > 0 && !"ALL".equals(sourceitems.get(0)) && !"0".equals(sourceitems.get(0))) {
                syjOrg.addAll(sourceitems);
            }
            log.info("yyygzMode:{}", (Object)yyygzMode);
            if ("Y".equals(yyygzMode)) {
                List yyyOrg = new ArrayList();
                OperUser curYyyInfo = vo.getCacheModel().getCurYyyInfo();
                log.info("getYyygz:{}", (Object)curYyyInfo.getYyygz());
                if (StringUtils.isNotBlank((String)curYyyInfo.getYyygz()) && !"ALL".equals(curYyyInfo.getYyygz()) && !"0".equals(curYyyInfo.getYyygz())) {
                    yyyOrg = curYyyInfo.getYyygzs();
                }
                if (syjOrg.size() <= 0 && yyyOrg.size() > 0) {
                    syjOrg = yyyOrg;
                } else if (syjOrg.size() > 0 && yyyOrg.size() > 0) {
                    syjOrg.retainAll(yyyOrg);
                }
                log.info("syjOrg:{}", (Object)JSON.toJSONString(syjOrg));
            }
            for (int i = 0; i < goodsInfos.size(); ++i) {
                GoodsInfo g = (GoodsInfo)goodsInfos.get(i);
                log.info("yyygzMode:{},syjOrg:{},grantMode:{}", new Object[]{yyygzMode, syjOrg, grantMode});
                if ((codeInfo.getBarNo().startsWith("Z") || codeInfo.getBarNo().startsWith("D") || codeInfo.getBarNo().startsWith("B")) && g.getPartsNum() > 1.0) {
                    return Code.CODE_20190.getRespBase(new Object[0]);
                }
                if (this.checkGzRange(g, yyygzMode, syjOrg, grantMode)) continue;
                goodsInfos.remove(i);
                --i;
            }
            if (goodsInfos.size() == 0) {
                log.info("\u67dc\u7ec4\u6821\u9a8c\u672a\u901a\u8fc7\uff0c\u5df2\u88ab\u79fb\u9664\u5546\u54c1");
                return Code.CODE_20111.getRespBase(new Object[0]);
            }
        }
        boolean isMain = false;
        if (goodsInfos.size() > 1) {
            GoodsInfo g;
            int i;
            boolean isNeedChoice = true;
            int mainCodeNum = 0;
            int mainCodeRow = 0;
            for (i = 0; i < goodsInfos.size(); ++i) {
                g = (GoodsInfo)goodsInfos.get(i);
                if (!g.getMainBarcodeFlag()) continue;
                ++mainCodeNum;
                mainCodeRow = i;
            }
            if (mainCodeNum == 1 && !((GoodsInfo)goodsInfos.get(0)).getMultiUnitFlag()) {
                goodsInfo = (GoodsInfo)goodsInfos.get(mainCodeRow);
                isNeedChoice = false;
            }
            if (isNeedChoice) {
                if (mainCodeNum > 1) {
                    for (i = 0; i < goodsInfos.size(); ++i) {
                        g = (GoodsInfo)goodsInfos.get(i);
                        if (g.getMainBarcodeFlag()) continue;
                        goodsInfos.remove(i);
                        --i;
                    }
                }
                GetSaleGoodsInfoOut out = new GetSaleGoodsInfoOut();
                List goodsForCoice = this.goodsTransfer.transferGoodsList(goodsInfos, barNo);
                out.setOrder(this.toGoodsForChoice(goodsForCoice));
                out.setSaleGoodsType("3");
                if (mainCodeNum == 0 || mainCodeNum > 1) {
                    out.setSaleGoodsType("C");
                }
                if ("32".equals(((GoodsInfo)goodsInfos.get(0)).getGoodsType()) && ((String)originalBarNo).length() < 13) {
                    for (GoodsInfo g2 : goodsInfos) {
                        if (!((String)originalBarNo).equals(g2.getGoodsCode()) || !"00".equals(g2.getGuCode())) continue;
                        goodsInfo = g2;
                        isMain = true;
                    }
                }
            }
        }
        if (!isMain) {
            goodsInfo = (GoodsInfo)goodsInfos.get(0);
        }
        if ("1".equals(queryGoodIn.getType()) && !"1".equals(goodsInfo.getGbmanamode())) {
            return Code.CODE_20112.getRespBase(new Object[0]);
        }
        goodsInfo.fixGoodsInfoStr();
        if (goodsInfo.getGoodsType().equals("41")) {
            JSONObject object = new JSONObject();
            object.put("erpCode", (Object)queryGoodIn.getErpCode());
            object.put("shopCode", (Object)queryGoodIn.getShopCode());
            object.put("code", (Object)goodsInfo.getGoodsCode());
            log.info("\u7279\u5356\u7801\u67e5\u8be2\u5165\u53c20\uff1a" + object.toJSONString());
            ServiceResponse res = this.querySpecialSale(object);
            log.info("\u7279\u5356\u7801\u67e5\u8be2\u8fd4\u56de\uff1a" + JSON.toJSONString((Object)res));
            if ("0".equals(res.getReturncode())) {
                JSONObject j = (JSONObject)res.getData();
                if ("N".equals(j.getString("status"))) {
                    return Code.CODE_20110.getRespBase(new Object[0]);
                }
                Double price = j.getDouble("price");
                goodsInfo.setSalePrice(price.doubleValue());
            }
        }
        if (isdzcm) {
            if (null == vo.getCacheModel()) {
                vo.setCacheModel(new CacheModel());
            }
            this.custDzcMethod(vo.getCacheModel(), dzc, goodsInfo);
            if (vo.getCacheModel().getErrCode().equals("20101")) {
                return Code.CODE_20101.getRespBase(new Object[]{vo.getCacheModel().getErrMsg()});
            }
            goodsInfo.setEWCCodeAmount(dzc.getDzcmjg());
            goodsInfo.setEWCCodeNum(dzc.getDzcmsl());
            goodsInfo.setExpTime(dzc.getExpTime());
            goods = this.posLogicCompoment.calcGoodsAmount(goodsInfo, queryGoodIn.getAssistantId(), true, dzc.getDzcmsl(), dzc.getDzcmjg(), eleMode, (String)originalBarNo, 1.0, false, 1);
            if (goods == null) {
                return Code.CODE_20088.getRespBase(new Object[0]);
            }
        } else {
            this.goodsTransfer.transferGoodsInfoToGoods(goodsInfo, goods, 1.0);
        }
        goods.setGoodsNo(codeInfo.getBarNo());
        goods = this.getGoods(null, goods, vo.getCacheModel());
        goods.setGuid(UUIDUtils.buildGuid());
        goods.setGoodsCode(goodsInfo.getGoodsCode());
        log.info("PRICEMODE=" + priceMode + ",DISVALUE=" + goods.getDisValue() + ",DISMODE=" + goods.getDisMode() + ",SALEAMOUNT=" + goods.getSaleAmount());
        if (priceMode == 2 && ManipulatePrecision.doubleCompare((double)goods.getDisValue(), (double)0.0, (int)2) > 0) {
            goods = this.posLogicCompoment.calcGoodsBarcodeDiscBeforeSingle(goods, disMode, disValue, discType);
        }
        if ("2".equals(queryGoodIn.getCalcMode())) {
            goods.setSalePrice(queryGoodIn.getRefPrice());
            goods.setSaleAmount(queryGoodIn.getRefPrice());
            goods.setSaleValue(queryGoodIn.getRefPrice());
        }
        goods.setGoodsNo((String)originalBarNo);
        CalcsingleIn calcsingleIn = new CalcsingleIn();
        ServiceResponse response = new ServiceResponse();
        boolean isNeedRecalc = true;
        while (isNeedRecalc) {
            int qtyRecalcFlag = goods.getQtyrecalc();
            calcsingleIn = this.calcTransfer.calcsingleInBuild(goods, queryGoodIn, sysPara.getYpopDzcMode());
            response = this.promotionCenterService.queryPriceCalcsingle(null, session, calcsingleIn);
            if ("0".equals(response.getReturncode())) {
                CalcsingleOut calcsingleOut = (CalcsingleOut)response.getData();
                BillDetail billDetail = calcsingleOut.getBillDetail();
                List sellDetails = billDetail.getSellDetails();
                SellDetail sellDetail = (SellDetail)sellDetails.get(0);
                double noDiscAmount = 0.0;
                double popDiscAmount = 0.0;
                if (sellDetail.getSellPopDetails() != null && sellDetail.getSellPopDetails().size() > 0) {
                    for (SellPopDetail sellPopDetail : sellDetail.getSellPopDetails()) {
                        if (null == sysPara.getCalcPriceType() || sysPara.getCalcPriceType().isEmpty()) continue;
                        if (StringUtils.isNotBlank((String)sellPopDetail.getPopEventType()) && sysPara.getCalcPriceType().indexOf(sellPopDetail.getPopEventType()) != -1) {
                            noDiscAmount += sellPopDetail.getDiscountAmount();
                            continue;
                        }
                        if (YPopStatusType.pop_policy_group_barcode_discA.equals(sellPopDetail.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_barcode_discB.equals(sellPopDetail.getPopPolicyGroup())) {
                            goods.setBarcodeDiscount(ManipulatePrecision.doubleConvert((double)sellPopDetail.getDiscountAmount(), (int)2, (int)1));
                            continue;
                        }
                        if (StringUtils.isNotBlank((String)sellPopDetail.getPopDescribe())) {
                            if (sellPopDetail.getPopDescribe().indexOf("\u5355\u54c1\u964d\u4ef7\u4f18\u60e0") != -1) {
                                noDiscAmount += sellPopDetail.getDiscountAmount();
                                continue;
                            }
                            if (sellPopDetail.getPopDescribe().indexOf("\u57fa\u7840\u79ef\u5206") != -1) continue;
                        }
                        popDiscAmount += sellPopDetail.getDiscountAmount();
                    }
                }
                goods.setNoDisAmountValue(ManipulatePrecision.doubleConvert((double)noDiscAmount));
                goods.setPopDiscountValue(ManipulatePrecision.doubleConvert((double)popDiscAmount));
                goods.setSaleValue(sellDetail.getListAmount());
                goods.setAdjustDiscountValue(this.posLogicCompoment.getAdjustDiscount(goods));
                goods.setTotalDiscountValue(CountZZK.getZZK((Goods)goods));
                goods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert((double)(goods.getTotalDiscountValue() - goods.getNoDisAmountValue())));
                goods.setSaleAmount(ManipulatePrecision.doubleConvert((double)(goods.getSaleValue() - goods.getTotalDiscountValue())));
                goods.setListPrice(ManipulatePrecision.doubleConvert((double)(goods.getSaleValue() - goods.getNoDisAmountValue())));
                goods.setQtyrecalc(sellDetail.getQtyrecalc());
                if (sellDetail.getQtyrecalc() == 1) {
                    goods.setQty(sellDetail.getQty());
                    if (goods.getQtyrecalc() != 0) {
                        goods.setSalePrice(sellDetail.getPrice());
                        goods.setSaleValue(goodsInfo.getEWCCodeAmount());
                        goods.setTotalDiscountValue(sellDetail.getTotalDiscount());
                    }
                }
            }
            if (qtyRecalcFlag != goods.getQtyrecalc()) continue;
            isNeedRecalc = false;
        }
        if (!((String)originalBarNo).startsWith("Z") && !((String)originalBarNo).startsWith("D") && !((String)originalBarNo).startsWith("B") && 0.0 != goods.getMemberPrice() && goods.getSalePrice() > goods.getMemberPrice()) {
            if ("Y".equals(goods.getEscaleFlag())) {
                goods.setCustomDiscountValue(ManipulatePrecision.getDetailOverFlow((double)((goods.getSalePrice() - goods.getMemberPrice()) * (goods.getQty() / 1.0)), (String)goods.getPrcutMode()));
            } else {
                goods.setCustomDiscountValue(ManipulatePrecision.getDetailOverFlow((double)((goods.getSalePrice() - goods.getMemberPrice()) * goods.getQty()), (String)goods.getPrcutMode()));
            }
        }
        calcsingleIn = this.calcTransfer.calcsingleInBuild(goods, queryGoodIn, sysPara.getYpopDzcMode());
        calcsingleIn.getBillDetail().setConsumersType("01");
        response = this.promotionCenterService.queryPriceCalcsingle(null, session, calcsingleIn);
        if (response.getReturncode().trim().equals("0")) {
            CalcsingleOut calcsingleOut = (CalcsingleOut)response.getData();
            BillDetail billDetail = calcsingleOut.getBillDetail();
            List sellDetails = billDetail.getSellDetails();
            SellDetail sellDetail = (SellDetail)sellDetails.get(0);
            if (sellDetail.getSellPopDetails() != null && sellDetail.getSellPopDetails().size() > 0) {
                for (SellPopDetail sellPopDetail : sellDetail.getSellPopDetails()) {
                    if ("9999".equals(sellPopDetail.getPopPolicyType()) || "9998".equals(sellPopDetail.getPopPolicyType()) || "96110".equals(sellPopDetail.getPopPolicyType()) || "96112".equals(sellPopDetail.getPopPolicyType())) {
                        if (!(sellPopDetail.getDiscountAmount() > 0.0)) continue;
                        goods.getPopDetailsInfo().add(this.popdetailTransfer.transferPopDetail2(sellPopDetail));
                        continue;
                    }
                    goods.getPopDetailsInfo().add(this.popdetailTransfer.transferPopDetail2(sellPopDetail));
                }
            }
            goods.setMemberPrice(ManipulatePrecision.doubleConvert((double)sellDetail.getSaleAmount()));
        }
        if (goods.getEWCCodeAmount() > 0.0) {
            goods.setListPrice(goods.getEWCCodeAmount());
        }
        goodsList.add(goods);
        BaseOutModel out = new BaseOutModel();
        OrderForPos order = new OrderForPos();
        order.setGoodsList(this.goodsTransfer.transferGoodsToPosGoodsList(goodsList, sysPara.getCalcPriceType(), true));
        out.setOrder(order);
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)vo.getCacheModel(), (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "REFCERTIFY");
    }

    public RespBase getGoodsList(ServiceSession session, JSONObject paramsObject) {
        String goodsStatus = "";
        ArrayList<Map> list1 = new ArrayList<Map>();
        if (!paramsObject.containsKey((Object)"barNos")) {
            return Code.CODE_20193.getRespBase(new Object[0]);
        }
        if (paramsObject.getJSONArray("barNos").size() == 0) {
            String str = "  {\n            \"barNo\": \"\",\n            \"categoryCode\": \"\",\n            \"escaleFlag\": 0,\n            \"gbdzcmlx\": \"0\",\n            \"goodsCode\": \"\",\n            \"goodsDisplayName\": \"\",\n            \"goodsName\": \"\",\n            \"goodsStatus\": 0,\n            \"guCode\": \"00\",\n            \"imageUrl\": \"\",\n            \"memberPrice\": 0.00,\n            \"partsNum\": 0,\n            \"rweight\": 0.0,\n            \"salePrice\": 0.00,\n            \"saleUnit\": \"\"\n        }";
            JSONObject jsonObject = JSONObject.parseObject((String)str);
            list1.add(jsonObject.getInnerMap());
            return new RespBase(Code.SUCCESS, list1);
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)(obj = this.reCacheMode(obj, paramsObject)), ModeDetailsVo.class);
        List sysParaList = modeDetailsVo.getSyspara();
        JSONArray sysParaArray = JSONArray.parseArray((String)JSON.toJSONString((Object)sysParaList));
        if (sysParaArray.size() != 0) {
            for (int i = 0; i < sysParaArray.size(); ++i) {
                JSONObject sys = sysParaArray.getJSONObject(i);
                if (!sys.get((Object)"code").equals("GSS")) continue;
                goodsStatus = sys.getString("paravalue");
            }
        }
        ArrayList<Integer> goodStauts = new ArrayList<Integer>();
        if (null != goodsStatus && !"".equals(goodsStatus)) {
            String[] slist = goodsStatus.split(",");
            for (String gs : slist) {
                goodStauts.add(Integer.valueOf(gs));
            }
            paramsObject.put("goodsStatus", goodStauts);
        }
        if (this.localcache.booleanValue()) {
            paramsObject.remove((Object)"splitCode");
        }
        ArrayList<Map> list = new ArrayList<Map>();
        for (Object b : paramsObject.getJSONArray("barNos")) {
            String goodsCode = (String)b;
            paramsObject.put("goodsCode", (Object)goodsCode);
            log.info("start getGoodsList ------- " + new Date().getTime());
            List list2 = this.saleGoodsModelService.getGoodsList(paramsObject);
            if (list2.size() > 0) {
                list.add((Map)list2.get(0));
            }
            log.info("end getGoodsList ------- " + new Date().getTime());
        }
        if (list.size() > 0) {
            ServiceResponse response = this.decorateResponseData4SaleGoodsDetail(session, paramsObject, list);
            if (!"0".equals(response.getReturncode())) {
                return Code.CODE_20079.getRespBase(new Object[0]);
            }
            return new RespBase(Code.SUCCESS, list);
        }
        return Code.CODE_20079.getRespBase(new Object[0]);
    }

    public RespBase getShorthandref(ServiceSession session, JSONObject paramsObject) {
        if (StringUtils.isBlank((String)paramsObject.getString("shopCode"))) {
            return Code.CODE_20099.getRespBase(new Object[0]);
        }
        if (StringUtils.isBlank((String)paramsObject.getString("erpCode"))) {
            return Code.CODE_20100.getRespBase(new Object[]{"erpCode"});
        }
        List list = this.saleGoodsModelService.getShorthandref(paramsObject);
        if (list.size() > 0) {
            HashMap tmpHashMap = new HashMap();
            for (Map stringObjectMap : list) {
                List<Map> tmpGoods = null;
                String goodsCode = (String)stringObjectMap.get("groupCode");
                if (!tmpHashMap.containsKey(goodsCode)) {
                    tmpGoods = new ArrayList();
                    tmpHashMap.put(goodsCode, tmpGoods);
                } else {
                    tmpGoods = (List)tmpHashMap.get(goodsCode);
                }
                tmpGoods.add(stringObjectMap);
            }
            return new RespBase(Code.SUCCESS, tmpHashMap);
        }
        return Code.CODE_20079.getRespBase(new Object[0]);
    }

    public RespBase getPosdispara(ServiceSession session, JSONObject paramsObject) {
        return this.initializationRemoteService.getPosdispara(session, paramsObject);
    }

    public static void main(String[] args) {
        String s = "B000344086955150411524";
        String substring = s.substring(5, 9);
        System.out.println(substring);
    }
}

