package com.efuture.business.vo;

import com.efuture.business.annotation.AllowNull;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author ChenHang
 */
@Data
public class GetFlowNoInVo implements Serializable {

    @NotNull(message = "scheduleCode 不能为空")
    private String scheduleCode;//班次

    @NotNull(message = "terminalOperator 不能为空")
    private String terminalOperator; // 操作员号

    @NotNull(message = "terminalNo 不能为空")
    private String terminalNo; // 终端号

    @NotNull(message = "saleDate 不能为空")
    private String saleDate; // 日期

    @NotNull(message = "orderType 不能为空")
    private String orderType; // 单据类别

    @NotNull(message = "terminalSno 不能为空")
    private String terminalSno; // 款机小票号码

    @NotNull(message = "channel 不能为空")
    private String channel; // 终端运营商

    @NotNull(message = "shopCode 不能为空")
    private String shopCode; // 门单号(单公司不唯一)

    @NotNull(message = "shopId 不能为空")
    private Long shopId; // 门店号(全局唯一)

    private String shopName; // 门店名称

    @NotNull(message = "erpCode 不能为空")
    private String erpCode; // 经营公司

    @AllowNull
    // @NotNull(message = "language 不能为空")
    private String language; // 小票语言

    @NotNull(message = "entId 不能为空")
    private Long entId; // 企业ID

    @NotNull(message = "precisionMode 不能为空")
    private String precisionMode; // 整单四舍五入方式（综合系统参数和收银机定义）

    @NotNull(message = "flag 不能为空")
    private String flag = "0"; // 默认为0

    @AllowNull
    private int popMode = 1;// 促销模块 默认为1
    @AllowNull
    private String accreditNo; // 授权卡号
    @AllowNull
    private String reason;// 退货原因
    @AllowNull
    private double maxSaleGoodsQuantity = 200; // 最大商品数量
    @AllowNull
    private double maxSaleGoodsMoney = 99999999; // 最大商品单价
    @AllowNull
    private double maxSaleMoney = 99999999;// 整单最大成交金额
    @AllowNull
    private String stallCode; // 档口编码
    @AllowNull
    private String posType = "0";// 终端类型
    @AllowNull
    private String scanGoodOperator;// 扫描员工号
    @AllowNull
    private String exerciseMode = "0";
    @AllowNull
    private String hasGroupBuy = "0"; //团购 默认为0；1为团购单据
    @AllowNull
    private String receipt;//新小票

}
