/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.dao.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.dao.PayindetailService;
import com.efuture.business.dao.PayinheadService;
import com.efuture.business.dao.impl.InitBaseServiceImpl;
import com.efuture.business.mapper.base.PayindetailMapper;
import com.efuture.business.model.PayDetails;
import com.efuture.business.model.PayindetailModel;
import com.efuture.business.model.PaymentmethodCopy;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.db.DbTools;
import com.efuture.business.util.db.MultipleDataSource;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

public class PayindetailServiceImpl
extends InitBaseServiceImpl<PayindetailMapper, PayindetailModel>
implements PayindetailService {
    private static Logger log = Logger.getLogger(PayindetailServiceImpl.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    PayinheadService payinheadService;
    @Autowired
    private DbTools dbTools;

    public int delete(String payInId) {
        MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("payindetail"));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"ppayInCode", new Object[]{payInId});
        log.info((Object)("\u660e\u7ec6\u63d2\u5165\u5931\u8d25\u5220\u9664--start:" + payInId));
        return ((PayindetailMapper)this.baseMapper).delete((Wrapper)queryWrapper);
    }

    public ServiceResponse search(ServiceSession session, JSONObject paramsObject) {
        PayDetails payDetails = (PayDetails)JSON.parseObject((String)paramsObject.toJSONString(), PayDetails.class);
        if (StringUtils.isNotBlank((String)payDetails.getPayInHeadId())) {
            return this.search1(session, paramsObject);
        }
        log.info((Object)("\u7f34\u6b3e\u8be6\u60c5-payInHeadId:" + payDetails.getPayInHeadId()));
        List list = this.listByMap((Map)paramsObject, "payindetail");
        List pdObj = this.payinheadService.getPayInHeadByKey((Map)paramsObject);
        JSONObject data = new JSONObject();
        data.put("payindetail", (Object)list);
        data.put("payinhead", pdObj.get(0));
        data.put("total_results", (Object)list.size());
        return ServiceResponse.buildSuccess((Object)data);
    }

    @Transactional(isolation=Isolation.READ_UNCOMMITTED)
    public List<Map<String, Object>> getPayindetail01(Map<String, Object> param) {
        return ((PayindetailMapper)this.baseMapper).getPayindetail01(param);
    }

    @Transactional(isolation=Isolation.READ_UNCOMMITTED)
    public List<Map<String, Object>> getPayindetail02(Map<String, Object> param) {
        return ((PayindetailMapper)this.baseMapper).getPayindetail02(param);
    }

    public int insertSelective(PayindetailModel payindetailModel) {
        MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("payindetail"));
        return ((PayindetailMapper)this.baseMapper).insertSelective(payindetailModel);
    }

    public List<PayindetailModel> selectByList(Map<String, Object> map) {
        MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("payindetail"));
        return ((PayindetailMapper)this.baseMapper).selectByList(map);
    }

    public ServiceResponse search1(ServiceSession session, JSONObject paramsObject) {
        JSONObject data = new JSONObject();
        log.info((Object)("\u7f34\u6b3e\u8be6\u60c5-payInHeadId2:" + paramsObject.getString("payInHeadId")));
        List pdObj = this.payinheadService.getPayInHeadByKey((Map)paramsObject);
        if (pdObj == null || pdObj.size() == 0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u67e5\u8be2\u7f34\u6b3e\u5355\u5934\u4fe1\u606f\u5931\u8d25");
        }
        data.put("payinhead", pdObj.get(0));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"payInId", (Object)paramsObject.getString("payInHeadId"));
        List list = this.payinheadService.list((Wrapper)queryWrapper, "payinhead");
        if (list.size() == 0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u67e5\u8be2\u660e\u7ec6\u4fe1\u606f\u5931\u8d25");
        }
        String redis = this.redisUtil.get(RedisKey.CACHEID + paramsObject.get((Object)"mkt") + paramsObject.get((Object)"syjh"));
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)redis, ModeDetailsVo.class);
        List paymode = modeDetailsVo.getPaymode();
        HashMap<String, String> paycodeMap = new HashMap<String, String>();
        for (int i = 0; i < paymode.size(); ++i) {
            PaymentmethodCopy obj = (PaymentmethodCopy)paymode.get(i);
            paycodeMap.put(obj.getPayCode(), obj.getCurrencyFlag());
        }
        QueryWrapper queryWrapper1 = new QueryWrapper();
        queryWrapper1.eq((Object)"payInHeadId", (Object)paramsObject.getString("payInHeadId"));
        List payindetails = this.list((Wrapper)queryWrapper1, "payindetail");
        log.info((Object)("payindetails:" + JSON.toJSONString((Object)payindetails)));
        ArrayList<JSONObject> list2 = new ArrayList<JSONObject>();
        for (PayindetailModel payindetail : payindetails) {
            JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)payindetail);
            String payInCode = jsonObject.get((Object)"payInCode").toString();
            jsonObject.put("currencyFlag", paycodeMap.get(payInCode));
            list2.add(jsonObject);
        }
        data.put("payindetail", list2);
        data.put("total_results", (Object)list2.size());
        return ServiceResponse.buildSuccess((Object)data);
    }
}

