/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.dao.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.dao.PayindetailService;
import com.efuture.business.dao.PayinheadService;
import com.efuture.business.dao.impl.InitBaseServiceImpl;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.mapper.base.PayinheadMapper;
import com.efuture.business.model.PayindetailModel;
import com.efuture.business.model.Payinhead;
import com.efuture.business.util.UniqueID;
import com.efuture.business.util.db.DbTools;
import com.efuture.business.util.db.MultipleDataSource;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class PayinheadServiceImpl
extends InitBaseServiceImpl<PayinheadMapper, Payinhead>
implements PayinheadService {
    private static final Logger log = LoggerFactory.getLogger(PayinheadServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(PayinheadServiceImpl.class);
    @Autowired
    PayindetailService payInDetailService;
    @Autowired
    private DbTools dbTools;
    @Autowired
    PayinheadService payinheadService;
    @Resource
    DataSourceTransactionManager dataSourceTransactionManager;
    @Resource
    TransactionDefinition transactionDefinition;

    public int insertSelective(Payinhead model) {
        MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("payindetail"));
        return ((PayinheadMapper)this.baseMapper).insertSelective(model);
    }

    public int delete(String payInId) {
        MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("payindetail"));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"payInId", new Object[]{payInId});
        log.info("\u660e\u7ec6\u63d2\u5165\u5931\u8d25\u5220\u9664\u5934--start:", (Object)payInId);
        this.payInDetailService.delete(payInId);
        return ((PayinheadMapper)this.baseMapper).delete((Wrapper)queryWrapper);
    }

    public ServiceResponse add1(ServiceSession session, JSONObject paramsObject) throws Exception {
        log.info("\u7f34\u6b3e\u8be6\u60c5==>{}", (Object)paramsObject.toJSONString());
        int rowNo = 0;
        HashMap map = new HashMap();
        JSONObject json = paramsObject.getJSONObject("payinhead");
        if ("".equals(json.get((Object)"approveTime")) || null == json.get((Object)"approveTime")) {
            json.remove((Object)"approveTime");
        }
        json.put("createDate", (Object)new Date());
        if (!json.containsKey((Object)"payInId") || json.getString("payInId").equals("")) {
            json.put("payInId", paramsObject.get((Object)"ph_key1"));
        }
        if (!json.containsKey((Object)"sourceType") || json.getString("sourceType").equals("")) {
            json.put("sourceType", (Object)"1");
        }
        json.put("approveFlag", (Object)1);
        json.put("payInTime", json.get((Object)"updateDate"));
        json.put("entId", (Object)0);
        boolean iscancel = false;
        if ("4".equals(json.getString("sourceType"))) {
            iscancel = true;
        }
        if (!json.containsKey((Object)"total")) {
            BigDecimal total = BigDecimal.ZERO;
            total = total.add(json.getBigDecimal("ecard"));
            total = total.add(json.getBigDecimal("coupon"));
            total = total.add(json.getBigDecimal("other"));
            total = total.add(json.getBigDecimal("cash"));
            total = total.add(json.getBigDecimal("cheque"));
            total = total.add(json.getBigDecimal("creditcard"));
            total = total.add(json.getBigDecimal("selloncredit"));
            if (iscancel) {
                json.put("ecard", (Object)json.getBigDecimal("ecard").negate());
                json.put("coupon", (Object)json.getBigDecimal("coupon").negate());
                json.put("other", (Object)json.getBigDecimal("other").negate());
                json.put("cash", (Object)json.getBigDecimal("cash").negate());
                json.put("cheque", (Object)json.getBigDecimal("cheque").negate());
                json.put("creditcard", (Object)json.getBigDecimal("creditcard").negate());
                json.put("selloncredit", (Object)json.getBigDecimal("selloncredit").negate());
                json.put("total", (Object)total.negate());
            } else {
                json.put("total", (Object)total);
            }
            paramsObject.put("payinhead", (Object)json);
        }
        try {
            logger.info("json" + json);
            int count = this.insertSelective((Payinhead)JSON.toJavaObject((JSON)json, Payinhead.class));
            if (count <= 0) {
                log.info("\u63d2\u5165\u7f34\u6b3e\u5355\u5934\u5931\u8d25!");
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"1", (String)"\u63d2\u5165\u7f34\u6b3e\u5355\u5934\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u63d2\u5165\u7f34\u6b3e\u5355\u5934\u5f02\u5e38:", (Throwable)e);
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"1", (String)"\u63d2\u5165\u7f34\u6b3e\u5355\u5934\u5931\u8d25");
        }
        JSONArray arr = paramsObject.getJSONArray("payindetail");
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        for (int i = 0; i < arr.size(); ++i) {
            JSONObject js = (JSONObject)arr.get(i);
            if ((!js.containsKey((Object)"amountTotal") || 0.0 == js.getDouble("amountTotal")) && (null == js.getDouble("number") || 0.0 == js.getDouble("number"))) continue;
            if (null == js.getDouble("number")) {
                js.put("number", (Object)js.getDouble("amountTotal"));
            }
            if (iscancel) {
                js.put("amountTotal", (Object)ManipulatePrecision.mul((double)js.getDouble("amountTotal"), (double)-1.0));
            }
            js.put("erpCode", (Object)json.getString("erpCode"));
            js.put("mkt", (Object)json.getString("mkt"));
            js.put("creator", (Object)json.getString("creator"));
            js.put("createDate", (Object)new Date());
            if (!js.containsKey((Object)"payInDetailId")) {
                js.put("payInDetailId", (Object)UniqueID.getUniqueID());
            }
            js.put("ppayInCode", (Object)json.getString("payInCode"));
            js.put("payInHeadId", json.get((Object)"payInId"));
            js.put("rowNo", (Object)(++rowNo));
            js.put("entId", json.get((Object)"entId"));
            js.put("updateDate", json.get((Object)"updateDate"));
            list.add(js);
            try {
                int j = this.payInDetailService.insertSelective((PayindetailModel)JSON.toJavaObject((JSON)js, PayindetailModel.class));
                if (j >= 0) continue;
                log.info("\u660e\u7ec6\u63d2\u5165\u5931\u8d25\u5220\u9664\u5934:", (Object)json.getString("payInId"));
                this.delete(json.getString("payInId"));
                log.info("\u660e\u7ec6\u63d2\u5165\u5931\u8d25\u5220\u9664\u5934--end:");
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"1", (String)"\u7f34\u6b3e\u5355\u660e\u7ec6\u63d2\u5165\u5931\u8d25");
            }
            catch (Exception e) {
                log.info("\u660e\u7ec6\u63d2\u5165\u5931\u8d25\u5220\u9664\u59342:", (Object)json.getString("payInId"));
                this.delete(json.getString("payInId"));
                log.info("\u660e\u7ec6\u63d2\u5165\u5931\u8d25\u5220\u9664\u5934--end2:");
                e.printStackTrace();
                log.info("\u63d2\u5165\u7f34\u6b3e\u660e\u7ec6\u5f02\u5e38:", (Throwable)e);
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"1", (String)"\u7f34\u6b3e\u5355\u660e\u7ec6\u63d2\u5165\u5931\u8d25");
            }
        }
        if (list.size() > 0) {
            paramsObject.put("payindetail", (Object)JSONArray.parseArray((String)JSON.toJSONString(list)));
        }
        return ServiceResponse.buildSuccess((Object)paramsObject);
    }

    public RespBase insertPayData(JSONObject paramsObject) {
        log.info("\u7ebf\u4e0a\u670d\u52a1\u5f00\u59cb\u540c\u6b65\u7ebf\u4e0b\u7f34\u6b3e\u6570\u636e2..." + paramsObject.toJSONString());
        JSONObject retunJson = new JSONObject();
        ArrayList<String> sucList = new ArrayList<String>();
        ArrayList<String> falList = new ArrayList<String>();
        if (paramsObject.containsKey((Object)"payinlist")) {
            JSONArray phArray = paramsObject.getJSONArray("payinlist");
            for (int i = 0; i < phArray.size(); ++i) {
                JSONObject payinhead = (JSONObject)JSONObject.toJSON((Object)phArray.get(i));
                Payinhead model = (Payinhead)JSON.parseObject((String)payinhead.toJSONString(), Payinhead.class);
                JSONObject json = new JSONObject();
                json.put("erpCode", (Object)model.getErpCode());
                json.put("mkt", (Object)model.getMkt());
                json.put("syjh", (Object)model.getSyjh());
                json.put("payInCode", (Object)model.getPayInCode());
                List oPayinhead = this.payinheadService.getPayInHeadByPayInCode((Map)json);
                if (null != oPayinhead && oPayinhead.size() > 0) {
                    log.info("\u7ebf\u4e0a\u670d\u52a1\u5f00\u59cb\u540c\u6b65\u7ebf\u4e0b\u7f34\u6b3e\u6570\u636e3..." + model.getTotal() + "-----" + ((Payinhead)oPayinhead.get(0)).getTotal());
                    if (model.getTotal().doubleValue() == ((Payinhead)oPayinhead.get(0)).getTotal().doubleValue()) {
                        log.info("\u7ebf\u4e0a\u670d\u52a1\u5f00\u59cb\u540c\u6b65\u7ebf\u4e0b\u7f34\u6b3e\u6570\u636e4...");
                        sucList.add(model.getPayInCode());
                        continue;
                    }
                }
                try {
                    if (!this.insertPayin(model)) {
                        falList.add(model.getPayInCode());
                        continue;
                    }
                    sucList.add(model.getPayInCode());
                    continue;
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    falList.add(model.getPayInCode());
                }
            }
        }
        retunJson.put("sucList", sucList);
        retunJson.put("falList", falList);
        return new RespBase(Code.SUCCESS, (Object)retunJson, "SYNCHRONIZDATAONLINE");
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public boolean insertPayin(Payinhead model) throws Exception {
        TransactionStatus transactionStatus = null;
        try {
            Long batchNo = UniqueID.getUniqueID();
            String synstatus = "1";
            Date synDate = new Date();
            model.setBatchNo(batchNo);
            model.setSynstatus(synstatus);
            model.setSynDate(synDate);
            transactionStatus = this.dataSourceTransactionManager.getTransaction(this.transactionDefinition);
            MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("payindetail"));
            int j = this.insertSelective(model);
            log.info("\u63d2\u5165\u7f34\u6b3e\u5355\u5934\u6570\u636e\uff1a" + model.getPayInId() + "-------" + model.getPayInCode() + "-------" + j);
            for (int z = 0; z < model.getPayindetails().size(); ++z) {
                PayindetailModel payindetailModel = (PayindetailModel)model.getPayindetails().get(z);
                payindetailModel.setBatchNo(batchNo);
                payindetailModel.setSynstatus(synstatus);
                payindetailModel.setSynDate(synDate);
                int n = this.payInDetailService.insertSelective(payindetailModel);
            }
            this.dataSourceTransactionManager.commit(transactionStatus);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.dataSourceTransactionManager.rollback(transactionStatus);
            throw new Exception("\u4fdd\u5b58\u7f34\u6b3e\u5355\u5f02\u5e38\u4fe1\u606f:" + e.getMessage());
        }
        return true;
    }

    public List<Payinhead> getPayInHeadByPayInCode(Map<String, Object> map) {
        MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("payinhead"));
        return ((PayinheadMapper)this.baseMapper).getPayInHeadByPayInCode(map);
    }

    public List<Payinhead> getPayInHeadByKey(Map<String, Object> map) {
        MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("payinhead"));
        return ((PayinheadMapper)this.baseMapper).getPayInHeadByKey(map);
    }

    public long getMaxPayInCode(Map<String, Object> map) {
        MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("payinhead"));
        return ((PayinheadMapper)this.baseMapper).getMaxPayInCode(map);
    }
}

