/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.dao.OperuserService;
import com.efuture.business.dao.PayindetailService;
import com.efuture.business.dao.PayindiffmodeService;
import com.efuture.business.dao.PayinheadService;
import com.efuture.business.dao.PosroleService;
import com.efuture.business.dao.SyjmainService;
import com.efuture.business.dao.SyncpayService;
import com.efuture.business.dao.SysparaService;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.model.Operuser;
import com.efuture.business.model.Payindiffmode;
import com.efuture.business.model.Payinhead;
import com.efuture.business.model.PosClearCore;
import com.efuture.business.model.Posrole;
import com.efuture.business.model.ProvisionaContributions;
import com.efuture.business.model.Syjmain;
import com.efuture.business.model.Syncpay;
import com.efuture.business.model.Syspara;
import com.efuture.business.service.FunctionRemoteService;
import com.efuture.business.service.OrderRemoteService;
import com.efuture.business.service.PosWorkAcountRemoteService;
import com.efuture.business.service.PosWorkLogRemoteService;
import com.efuture.business.service.SyjCashLogRemoteService;
import com.efuture.business.service.SyjMainLogRemoteService;
import com.efuture.business.service.SyjMainSaleBS;
import com.efuture.business.util.HttpClientUtils;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.UniqueID;
import com.efuture.business.util.db.DbTools;
import com.efuture.business.util.db.MultipleDataSource;
import com.efuture.redis.util.DateUtils;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;

public class SyjMainSaleBSImpl
implements SyjMainSaleBS {
    private static final Logger log = LoggerFactory.getLogger(SyjMainSaleBSImpl.class);
    protected Log logger = LogFactory.getLog(this.getClass());
    @Autowired
    private SyjmainService syjmainService;
    @Autowired
    private OperuserService operuserService;
    @Autowired
    PayinheadService payinheadService;
    @Autowired
    SysparaService sysparaService;
    @Autowired
    PayindetailService payindetailService;
    @Autowired
    private PosroleService posroleService;
    @Autowired
    private DbTools dbTools;
    @Autowired
    PayindiffmodeService payindiffmodeService;
    @SoaAnnotation(value="/apiOrderRemoteService.do")
    private OrderRemoteService orderRemoteService;
    @SoaAnnotation(value="/apiPosWorkLogRemoteService.do")
    private PosWorkLogRemoteService posWorkLogRemoteService;
    @SoaAnnotation(value="/apiSyjCashLogRemoteService.do")
    private SyjCashLogRemoteService syjCashLogRemoteService;
    @SoaAnnotation(value="/apiSyjMainLogRemoteService.do")
    private SyjMainLogRemoteService syjMainLogRemoteService;
    @SoaAnnotation(value="/apiFunctionRemoteService.do")
    private FunctionRemoteService functionRemoteService;
    @SoaAnnotation(value="/apiPosWorkAcountRemoteService.do")
    private PosWorkAcountRemoteService posWorkAcountRemoteService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SyncpayService syncpayService;
    @Value(value="${localcache.enabled}")
    private Boolean localcache;
    @Value(value="${hazelcast.enabled:false}")
    private Boolean hazelcast;

    public boolean updateByMKTAndSYJH(Syjmain syjMainModel) {
        log.info("updateByMKTAndSYJH-syjmain:{}", (Object)JSON.toJSONString((Object)syjMainModel));
        return this.syjmainService.updateByMKTAndSYJH(syjMainModel);
    }

    public boolean updateSyjmain(Syjmain syjMainModel) {
        return this.syjmainService.updateSyjmain(syjMainModel);
    }

    public Syjmain selectOneByMKTAndSYJ(Syjmain syjMainModel) {
        return this.syjmainService.selectOneByMKTAndSYJ(syjMainModel);
    }

    public RespBase cgallPosClearByMan(ServiceSession session, JSONObject param) {
        if (!param.containsKey((Object)"erpCode")) {
            return new RespBase(-1, "\u8bf7\u4e0a\u4f20\u7ecf\u8425\u516c\u53f8[erpCode]");
        }
        if (!param.containsKey((Object)"mkt")) {
            return new RespBase(-1, "\u8bf7\u4e0a\u4f20\u95e8\u5e97\u53f7[mkt]");
        }
        if (!param.containsKey((Object)"syjh")) {
            return new RespBase(-1, "\u8bf7\u4e0a\u4f20\u6536\u94f6\u673a\u53f7[syjh]");
        }
        if (!param.containsKey((Object)"operuserGh")) {
            return new RespBase(-1, "\u8bf7\u4e0a\u4f20\u6536\u94f6\u5458\u5de5\u53f7[operuserGh]");
        }
        if (!param.containsKey((Object)"authorizeGh") && !param.containsKey((Object)"operateGh")) {
            return new RespBase(-1, "\u6ca1\u6709\u6388\u6743\u4eba\uff0c\u8bf7\u4e0a\u4f20\u64cd\u4f5c\u5458\u5de5\u53f7[operateGh]");
        }
        String clearTime = this.functionRemoteService.getClearTime(param.getString("erpCode"), param.getString("mkt"), param.getString("syjh"));
        this.logger.info("clearTime" + clearTime);
        param.put("clearTime", (Object)clearTime);
        if (this.localcache.booleanValue() || this.hazelcast.booleanValue()) {
            param.put("command_id", (Object)"ALLPOSCLEARBYMANIDC");
            try {
                String res = HttpClientUtils.postJson((String)GlobalInfo.cloudUrl, (String)param.toString());
                if (null != res && !"".equals(res)) {
                    RespBase resp = (RespBase)JSONObject.parseObject((String)res, RespBase.class);
                    return resp.setCommand_id("CNAEONSYYCLEAR");
                }
                return new RespBase(-1, "\u8bf7\u6c42IDC\u6253\u5370\u8d23\u4efb\u8005X\u62a5\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            catch (Exception e) {
                return new RespBase(-1, "\u8bf7\u6c42IDC\u6253\u5370\u8d23\u4efb\u8005X\u62a5\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
        }
        return this.allPosClearBymanIDC(session, param);
    }

    public RespBase allPosClearBymanIDC(ServiceSession session, JSONObject param) {
        ServiceResponse checkResp = this.checkOperUser(session, param);
        if ("10000".equals(checkResp.getReturncode())) {
            return new RespBase(-1, "\u67e5\u8be2\u5de5\u53f7\u5931\u8d25\uff0c\u8bf7\u6838\u5bf9\u5de5\u53f7");
        }
        Syjmain syjMain = this.checkSyj(session, param);
        if (syjMain == null) {
            return new RespBase(-1, "\u67e5\u8be2\u6536\u94f6\u673a\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        String clearTime = param.getString("clearTime");
        JSONObject orderObject = new JSONObject();
        orderObject.put("createDate", (Object)clearTime);
        orderObject.put("busiTakeMarketCode", param.get((Object)"mkt"));
        orderObject.put("erpCode", param.get((Object)"erpCode"));
        orderObject.put("terminalNo", param.get((Object)"syjh"));
        orderObject.put("terminalOperator", param.get((Object)"operuserGh"));
        orderObject.put("searchType", (Object)"1");
        RespBase response = this.orderRemoteService.searchTerminalReport(session, orderObject);
        JSONObject orderResult = (JSONObject)JSONObject.toJSON((Object)response.getData());
        param.put("searchType", (Object)"1");
        List cashLog = this.syjCashLogRemoteService.countCashLog(session, param);
        this.adpter(cashLog, orderResult);
        orderResult.put("operuserGh", (Object)param.getString("operuserGh"));
        orderResult.put("authorizeGh", (Object)param.getString("authorizeGh"));
        orderResult.put("operateGh", (Object)param.getString("operateGh"));
        BigDecimal diffCash = this.getDiffCash(orderResult);
        orderResult.put("diffCash", (Object)diffCash);
        return new RespBase(Code.SUCCESS, (Object)orderResult, "");
    }

    public RespBase cgposClear(ServiceSession session, JSONObject param) {
        Syjmain syjMain = this.checkSyj(session, param);
        if (syjMain == null) {
            return new RespBase(-1, "\u67e5\u8be2\u6536\u94f6\u673a\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        RespBase result = this.posClearCore(session, param);
        if (!"0".equals(result.getRetflag())) {
            return result;
        }
        JSONObject update = new JSONObject();
        update.put("ph_key", (Object)syjMain.getPhKey());
        update.put("syjcleartime", (Object)new Date());
        update.put("syjcurinvbs", (Object)0);
        update.put("syjcurinvje", (Object)0);
        update.put("syjcurcashje", (Object)0);
        boolean b = this.syjmainService.updateSyjmain((Syjmain)JSON.toJavaObject((JSON)update, Syjmain.class));
        if (!b) {
            return new RespBase(-1, "\u6e05\u673a\u65f6\u95f4\u8bb0\u5f55\u672c\u5730\u5931\u8d25");
        }
        update.put("command_id", (Object)"UPDATECASHIERSTATUSCERTIFY");
        try {
            String res = HttpClientUtils.postJson((String)GlobalInfo.cloudUrl, (String)update.toString());
            if (null != res && !"".equals(res)) {
                JSONObject jsonObject = JSON.parseObject((String)res);
                if (0 == jsonObject.getInteger("retflag")) {
                    this.logger.info("\u6e05\u673a\u65f6\u95f4\u8bb0\u5f55IDC\u6210\u529f");
                } else {
                    this.logger.error("\u6e05\u673a\u65f6\u95f4\u8bb0\u5f55IDC\u5931\u8d25\uff0c\u4e0d\u5f71\u54cd\u6b63\u5e38\u6e05\u673a");
                }
            } else {
                this.logger.error("\u6e05\u673a\u65f6\u95f4\u8bb0\u5f55IDC\u5931\u8d25\uff0c\u4e0d\u5f71\u54cd\u6b63\u5e38\u6e05\u673a");
            }
        }
        catch (Exception e) {
            this.logger.error("\u6e05\u673a\u65f6\u95f4\u8bb0\u5f55IDC\u5931\u8d25\uff0c\u4e0d\u5f71\u54cd\u6b63\u5e38\u6e05\u673a");
        }
        return result;
    }

    public RespBase posClearCore(ServiceSession session, JSONObject param) {
        this.logger.info("posClearCore==" + JSONObject.toJSONString((Object)param));
        PosClearCore posClearCore = (PosClearCore)JSON.parseObject((String)param.toJSONString(), PosClearCore.class);
        if (StringUtils.isBlank((String)posClearCore.getErpCode())) {
            return new RespBase(-1, "\u8bf7\u4e0a\u4f20\u7ecf\u8425\u516c\u53f8[erpCode]");
        }
        if (StringUtils.isBlank((String)posClearCore.getMkt())) {
            return new RespBase(-1, "\u8bf7\u4e0a\u4f20\u95e8\u5e97\u53f7[mkt]");
        }
        if (StringUtils.isBlank((String)posClearCore.getSyjh())) {
            return new RespBase(-1, "\u8bf7\u4e0a\u4f20\u6536\u94f6\u673a\u53f7[syjh]");
        }
        if (StringUtils.isBlank((String)posClearCore.getOperuserGh())) {
            return new RespBase(-1, "\u8bf7\u4e0a\u4f20\u6536\u94f6\u5458\u5de5\u53f7[syyh]");
        }
        if (StringUtils.isBlank((String)posClearCore.getAuthorizeGh()) && StringUtils.isBlank((String)posClearCore.getOperateGh())) {
            return new RespBase(-1, "\u6ca1\u6709\u6388\u6743\u4eba\uff0c\u8bf7\u4e0a\u4f20\u64cd\u4f5c\u5458\u5de5\u53f7[operateGh]");
        }
        Syjmain syjMain = this.checkSyj(session, param);
        if (syjMain == null) {
            return new RespBase(-1, "\u67e5\u8be2\u6536\u94f6\u673a\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        ServiceResponse checkResp = this.checkOperUser(session, param);
        if ("10000".equals(checkResp.getReturncode())) {
            return new RespBase(-1, "\u67e5\u8be2\u5de5\u53f7\u5931\u8d25\uff0c\u8bf7\u6838\u5bf9\u5de5\u53f7");
        }
        Operuser o = (Operuser)checkResp.getData();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"roleid", (Object)o.getPosrole());
        queryWrapper.eq((Object)"statu", (Object)"1");
        List list = this.posroleService.list((Wrapper)queryWrapper);
        String operrange = "N";
        if (null != list && list.size() > 0) {
            operrange = ((Posrole)list.get(0)).getOperrange();
        }
        String clearTime = this.functionRemoteService.getClearTime(posClearCore.getErpCode(), posClearCore.getMkt(), posClearCore.getSyjh());
        this.logger.info("clearTime" + clearTime);
        JSONObject orderObject = new JSONObject();
        orderObject.put("createDate", (Object)clearTime);
        orderObject.put("busiTakeMarketCode", (Object)posClearCore.getMkt());
        orderObject.put("erpCode", (Object)posClearCore.getErpCode());
        orderObject.put("terminalNo", (Object)posClearCore.getSyjh());
        orderObject.put("terminalOperator", (Object)posClearCore.getOperuserGh());
        orderObject.put("searchType", (Object)"2");
        orderObject.put("operrange", (Object)operrange);
        RespBase response = this.orderRemoteService.searchTerminalReport(session, orderObject);
        JSONObject orderResult = (JSONObject)JSONObject.toJSON((Object)response.getData());
        this.logger.info("orderResult" + JSONObject.toJSONString((Object)orderResult));
        JSONObject req = new JSONObject();
        req.put("mkt", (Object)posClearCore.getMkt());
        req.put("erpCode", (Object)posClearCore.getErpCode());
        req.put("statu", (Object)"1");
        JSONArray syyReport = orderResult.getJSONArray("syyReport");
        if (null != syyReport && syyReport.size() > 0) {
            for (Object j : syyReport) {
                JSONObject jo = (JSONObject)j;
                String terminalOperator = jo.getString("terminalOperator");
                req.put("gh", (Object)terminalOperator);
                List operusers = this.operuserService.listByMap((Map)req, "operuser");
                if (operusers == null || operusers.size() == 0) {
                    return new RespBase(-1, "\u6536\u94f6\u5458\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
                }
                Operuser operuser = (Operuser)operusers.get(0);
                jo.put("cashier", (Object)operuser.getGh());
                jo.put("creator", (Object)operuser.getName());
                jo.put("terminalOperatorName", (Object)o.getName());
                jo.put("terminalOperator", (Object)posClearCore.getOperateGh());
                jo.put("mkt", (Object)posClearCore.getMkt());
                jo.put("shopName", (Object)posClearCore.getShopName());
                jo.put("syjh", (Object)posClearCore.getSyjh());
            }
        }
        orderResult.put("cashier", (Object)o.getGh());
        orderResult.put("creator", (Object)o.getName());
        orderResult.put("terminalOperatorName", (Object)o.getName());
        orderResult.put("mkt", (Object)posClearCore.getMkt());
        orderResult.put("shopName", (Object)posClearCore.getShopName());
        orderResult.put("syjh", (Object)posClearCore.getSyjh());
        orderResult.put("terminalOperator", param.get((Object)"operateGh"));
        param.put("clearTime", (Object)clearTime);
        param.put("searchType", (Object)"2");
        this.logger.info("param1==" + param.toJSONString());
        List cashLog = this.syjCashLogRemoteService.countCashLog(session, param);
        this.logger.info("cashLog==" + JSONObject.toJSONString((Object)cashLog));
        this.adpter(cashLog, orderResult);
        orderResult.put("operuserGh", (Object)posClearCore.getOperuserGh());
        orderResult.put("authorizeGh", (Object)posClearCore.getAuthorizeGh());
        orderResult.put("operateGh", (Object)posClearCore.getOperateGh());
        BigDecimal diffCash = this.getDiffCash(orderResult);
        orderResult.put("diffCash", (Object)diffCash);
        this.adpterLog(session, syjMain, "2", param.getString("authorizeGh"));
        return new RespBase(Code.SUCCESS, (Object)orderResult, "CGPOSCLEARREPORT");
    }

    private void adpterLog(ServiceSession session, Syjmain syjMain, String searchType, String authorizeGh) {
        JSONObject ob = new JSONObject();
        ob.put("ph_key", (Object)UniqueID.getUniqueID());
        ob.put("mkt", (Object)syjMain.getMkt());
        ob.put("erpCode", (Object)syjMain.getErpCode());
        ob.put("syjh", (Object)syjMain.getSyjh());
        ob.put("syjcursyyh", (Object)syjMain.getSyjcursyyh());
        ob.put("syjopentime", (Object)syjMain.getSyjopentime());
        ob.put("syjcleartime", (Object)new Date());
        ob.put("syjcurstatus", (Object)syjMain.getSyjcurstatus());
        ob.put("syjcurtime", (Object)new Date());
        ob.put("syjcurinvbs", (Object)syjMain.getSyjcurinvbs());
        ob.put("syjcurinvje", (Object)syjMain.getSyjcurinvje());
        ob.put("syjcurcashje", (Object)syjMain.getSyjcurcashje());
        ob.put("syjcurpreje", (Object)syjMain.getSyjcurpreje());
        ob.put("syjcurnum", (Object)syjMain.getSyjcurnum());
        if ("1".equals(searchType)) {
            ob.put("status", (Object)"1");
        } else if ("2".equals(searchType)) {
            ob.put("status", (Object)"2");
        } else if ("3".equals(searchType)) {
            ob.put("status", (Object)"11");
        }
        ob.put("insertprecashcount", (Object)syjMain.getInsertprecashcount());
        ob.put("syjpaycount", (Object)syjMain.getSyjpaycount());
        int i1 = this.syjMainLogRemoteService.saveEntity(ob);
        log.info("syjMainLog\u63d2\u5165\u6570\u636e" + i1 + "\u6761");
        JSONObject worklog = new JSONObject();
        worklog.put("erpCode", (Object)syjMain.getErpCode());
        worklog.put("mkt", (Object)syjMain.getMkt());
        worklog.put("syjh", (Object)syjMain.getSyjh());
        worklog.put("syyh", (Object)syjMain.getSyjcursyyh());
        worklog.put("rqsj", (Object)new Date());
        if ("1".equals(searchType)) {
            worklog.put("logtype", (Object)"8");
            worklog.put("logdesc", (Object)"\u4eba\u5458\u6e05\u673a");
        } else if ("2".equals(searchType)) {
            worklog.put("logtype", (Object)"9");
            worklog.put("logdesc", (Object)"\u6536\u94f6\u673a\u6e05\u673a");
        } else if ("3".equals(searchType)) {
            worklog.put("logtype", (Object)"44");
            worklog.put("logdesc", (Object)"\u4eba\u5458\u6e05\u673a_\u672c\u6b3e\u673a");
        }
        worklog.put("entId", (Object)session.getEnt_id());
        worklog.put("updateDate", (Object)new Date());
        this.posWorkLogRemoteService.onInsert(worklog);
        worklog.put("authorizeGh", (Object)authorizeGh);
        this.posWorkAcountRemoteService.onInsert(worklog);
    }

    public List<Map<String, Object>> getPayindetail01(Map<String, Object> param) {
        MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("payindetail"));
        return this.payindetailService.getPayindetail01(param);
    }

    public List<Map<String, Object>> getPayindetail02(Map<String, Object> param) {
        MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("payindetail"));
        return this.payindetailService.getPayindetail02(param);
    }

    public String getOutLineTime() throws Exception {
        Date newDate2;
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
        String time = "05:00:00";
        Date date = new Date();
        String newDate = format.format(date);
        Date newDate1 = format.parse(newDate);
        if (newDate1.compareTo(newDate2 = format.parse(time)) == 1 || newDate1.compareTo(newDate2) == 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String resultDate = sdf.format(date);
            return resultDate;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        date = calendar.getTime();
        String resultDate = sdf.format(date);
        return resultDate;
    }

    private BigDecimal getDiffCash(JSONObject orderResult) {
        BigDecimal enter = orderResult.getBigDecimal("enterCashAmt");
        enter = enter == null ? new BigDecimal(0) : enter;
        BigDecimal cEnter = orderResult.getBigDecimal("cancelEnterAmt");
        cEnter = cEnter == null ? new BigDecimal(0) : cEnter;
        BigDecimal sale = orderResult.getBigDecimal("cashTotalSaleAmt");
        sale = sale == null ? new BigDecimal(0) : sale;
        BigDecimal returnCash = orderResult.getBigDecimal("cashTotalReturnAmt");
        returnCash = returnCash == null ? new BigDecimal(0) : returnCash;
        BigDecimal hcSaleCash = orderResult.getBigDecimal("cashTotalHcSaleAmt");
        hcSaleCash = hcSaleCash == null ? new BigDecimal(0) : hcSaleCash;
        BigDecimal midEnter = orderResult.getBigDecimal("midEnterAmt");
        midEnter = midEnter == null ? new BigDecimal(0) : midEnter;
        BigDecimal cMidEnter = orderResult.getBigDecimal("cancelMidEnterAmt");
        cMidEnter = cMidEnter == null ? new BigDecimal(0) : cMidEnter;
        BigDecimal payment = orderResult.getBigDecimal("lastPaymentAmt");
        payment = payment == null ? new BigDecimal(0) : payment;
        BigDecimal cPayment = orderResult.getBigDecimal("cancelLastPaymentAmt");
        cPayment = cPayment == null ? new BigDecimal(0) : cPayment;
        BigDecimal cashIn = enter.add(cEnter).add(sale).add(returnCash).add(hcSaleCash);
        this.logger.info("\u8ba1\u7b97\u957f\u77ed\u6b3e\u73b0\u91d1\u6536\u5165\u603b\u548c\uff1a" + cashIn.toString());
        BigDecimal cashOut = midEnter.add(cMidEnter).add(payment).add(cPayment);
        cashOut = cashOut.negate();
        this.logger.info("\u8ba1\u7b97\u957f\u77ed\u6b3e\u73b0\u91d1\u7f34\u6b3e\u603b\u548c\uff1a" + cashOut.toString());
        BigDecimal result = cashOut.subtract(cashIn);
        this.logger.info("\u8ba1\u7b97\u957f\u77ed\u6b3e\u7ed3\u679c\uff1a" + result);
        return result;
    }

    private Syjmain checkSyj(ServiceSession session, JSONObject param) {
        JSONObject jo = new JSONObject();
        jo.put("mkt", (Object)param.getString("mkt"));
        jo.put("erpCode", (Object)param.getString("erpCode"));
        jo.put("syjh", (Object)param.getString("syjh"));
        List list = this.syjmainService.listByMap((Map)jo);
        return (Syjmain)list.get(0);
    }

    private ServiceResponse checkOperUser(ServiceSession session, JSONObject param) {
        JSONObject jo = new JSONObject();
        jo.put("gh", (Object)param.getString("operuserGh"));
        jo.put("mkt", (Object)param.getString("mkt"));
        jo.put("erpCode", (Object)param.getString("erpCode"));
        jo.put("statu", (Object)"1");
        List operusers = this.operuserService.listByMap((Map)jo, "operuser");
        if (operusers == null || operusers.size() == 0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u67e5\u8be2\u5de5\u53f7\u5931\u8d25\uff0c\u8bf7\u6838\u5bf9\u5de5\u53f7");
        }
        return ServiceResponse.buildSuccess(operusers.get(0));
    }

    public void adpter1(List<Map> countData, JSONObject result) {
        for (Map data : countData) {
            String logType = (String)data.get("logType");
            Integer count = (Integer)data.get("count");
            Double amount = (Double)data.get("amount");
            if ("17".equals(logType)) {
                result.put("pendOrderCnt", data.get("count"));
                result.put("pendOrderAmt", data.get("amount"));
            }
            if ("18".equals(logType)) {
                result.put("unPendOrderCnt", data.get("count"));
                result.put("unPpendOrderAmt", data.get("amount"));
            }
            if ("20".equals(logType)) {
                result.put("delPendOrderCnt", data.get("count"));
                result.put("delPpendOrderAmt", data.get("amount"));
            }
            if ("23".equals(logType)) {
                result.put("delGoodsCnt", data.get("count"));
                result.put("delGoodsAmt", data.get("amount"));
            }
            if ("24".equals(logType)) {
                result.put("delOrderCnt", data.get("count"));
                result.put("delOrderAmt", data.get("amount"));
            }
            if ("34".equals(logType)) {
                result.put("changePriceCnt", data.get("count"));
                result.put("changePriceAmt", data.get("amount"));
            }
            if (!"35".equals(logType)) continue;
            result.put("openBoxCnt", data.get("count"));
        }
    }

    protected void adpter(List<Map> countData, JSONObject result) {
        for (Map data : countData) {
            String status = (String)data.get("status");
            Integer count = (Integer)data.get("count");
            BigDecimal syjcurpreje = (BigDecimal)data.get("syjcurpreje");
            BigDecimal syjpaycashje = (BigDecimal)data.get("syjpaycashje");
            if (status.equals("4")) {
                result.put("enterCashCnt", (Object)count);
                result.put("enterCashAmt", (Object)syjcurpreje);
            }
            if (status.equals("11")) {
                result.put("cancelEnterCnt", (Object)count);
                result.put("cancelEnterAmt", (Object)syjcurpreje);
            }
            if (status.equals("3")) {
                result.put("midEnterCnt", (Object)count);
                result.put("midEnterAmt", (Object)syjpaycashje.negate());
            }
            if (status.equals("13")) {
                result.put("cancelMidEnterCnt", (Object)count);
                result.put("cancelMidEnterAmt", (Object)syjpaycashje.negate());
            }
            if (status.equals("14")) {
                result.put("midConvertCnt", (Object)count);
                result.put("midConvertAmt", (Object)syjpaycashje);
            }
            if (status.equals("12")) {
                result.put("lastPaymentCnt", (Object)count);
                result.put("lastPaymentAmt", (Object)syjpaycashje.negate());
            }
            if (!status.equals("15")) continue;
            result.put("cancelLastPaymentCnt", (Object)count);
            result.put("cancelLastPaymentAmt", (Object)syjpaycashje.negate());
        }
    }

    @Transactional
    public RespBase TemporaryPay1(ServiceSession session, JSONObject paramsObject) throws Exception {
        ServiceResponse response;
        String clearTime;
        if (!paramsObject.containsKey((Object)"payinhead") || paramsObject.getJSONObject("payinhead") == null) {
            return new RespBase(-1, "\u7f34\u6b3e\u5934\u6570\u636e\u7f3a\u5931,\u8bf7\u68c0\u67e5\u53c2\u6570!");
        }
        if (!paramsObject.containsKey((Object)"payindetail") || paramsObject.getJSONArray("payindetail").size() == 0) {
            return new RespBase(-1, "\u6570\u636e\u6821\u9a8c\u4e0d\u5339\u914d,\u8bf7\u68c0\u67e5\u53c2\u6570!");
        }
        ProvisionaContributions provisionaContributions = (ProvisionaContributions)JSON.parseObject((String)paramsObject.toJSONString(), ProvisionaContributions.class);
        BigDecimal cash = BigDecimal.ZERO;
        BigDecimal cheque = BigDecimal.ZERO;
        BigDecimal coupon = BigDecimal.ZERO;
        BigDecimal ecard = BigDecimal.ZERO;
        BigDecimal other = BigDecimal.ZERO;
        BigDecimal creditcard = BigDecimal.ZERO;
        BigDecimal selloncredit = BigDecimal.ZERO;
        JSONObject object = JSON.parseObject((String)JSON.toJSONString((Object)provisionaContributions.getPayinhead()));
        int entid = 0;
        String opusername = "";
        String opuser = object.getString("creator");
        try {
            String opuserstr = this.redisUtil.get(RedisKey.OPERID + object.getString("mkt") + object.getString("syjh"));
            JSONObject opuserobj = JSONObject.parseObject((String)opuserstr);
            opusername = opuserobj.getString("name");
            JSONObject modeDetailsVo = this.getRedisData(object);
            JSONObject syjmainVo = modeDetailsVo.getJSONObject("syjmain");
            entid = syjmainVo.getInteger("entId");
            JSONArray payinmode = modeDetailsVo.getJSONArray("payinmode");
            JSONArray payindiffmode = modeDetailsVo.getJSONArray("payindiffmode");
            JSONArray pd = JSON.parseArray((String)JSON.toJSONString((Object)provisionaContributions.getPayindetail()));
            for (int i = 0; i < pd.size(); ++i) {
                JSONObject payInDetail = (JSONObject)pd.get(i);
                if (!payInDetail.containsKey((Object)"payInCode") || !StringUtils.isNotBlank((String)payInDetail.getString("payInCode"))) continue;
                for (int j = 0; j < payinmode.size(); ++j) {
                    JSONObject item = (JSONObject)payinmode.get(j);
                    if (!payInDetail.getString("payInCode").equals(item.getString("paycode"))) continue;
                    String payType = "";
                    if (payindiffmode.size() > 0) {
                        for (int k = 0; k < payindiffmode.size(); ++k) {
                            JSONObject diffmode = (JSONObject)payindiffmode.get(j);
                            if (!payInDetail.getString("payInCode").equals(diffmode.getString("payCode"))) continue;
                            payType = diffmode.getString("payType");
                        }
                    }
                    log.info("\u83b7\u53d6\u7f34\u6b3epayType{}", (Object)payType);
                    if ("1".equals(payType)) {
                        cash = cash.add(payInDetail.getBigDecimal("amountTotal"));
                    } else if ("2".equals(payType)) {
                        cheque = cheque.add(payInDetail.getBigDecimal("amountTotal"));
                    } else if ("3".equals(payType)) {
                        creditcard = creditcard.add(payInDetail.getBigDecimal("amountTotal"));
                    } else if ("4".equals(payType)) {
                        ecard = ecard.add(payInDetail.getBigDecimal("amountTotal"));
                    } else if ("5".equals(payType)) {
                        coupon = coupon.add(payInDetail.getBigDecimal("amountTotal"));
                    } else if ("6".equals(payType)) {
                        selloncredit = selloncredit.add(payInDetail.getBigDecimal("amountTotal"));
                    } else if ("7".equals(payType)) {
                        other = other.add(payInDetail.getBigDecimal("amountTotal"));
                    }
                    payInDetail.put("amountTotal", (Object)0);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u7edf\u8ba1\u7f34\u6b3e\u5404\u7c7b\u6570\u636e\u53d1\u751f\u5f02\u5e38:" + e.toString());
        }
        Date time = new Date();
        object.put("cash", (Object)cash);
        object.put("cheque", (Object)cheque);
        object.put("coupon", (Object)coupon);
        object.put("ecard", (Object)ecard);
        object.put("other", (Object)other);
        object.put("creditcard", (Object)creditcard);
        object.put("selloncredit", (Object)selloncredit);
        object.put("updateDate", (Object)time);
        object.put("approver", (Object)opuser);
        object.put("creator", (Object)opusername);
        object.put("entId", (Object)entid);
        object.put("approveTime", (Object)time);
        paramsObject.put("payinhead", (Object)object);
        if (StringUtils.isEmpty((String)object.getString("sourceType"))) {
            return new RespBase(-1, "\u4ea4\u6613\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((object.getString("sourceType").equals("3") || object.getString("sourceType").equals("4")) && StringUtils.isEmpty((String)paramsObject.getString("ph_key"))) {
            return new RespBase(-1, "\u53d6\u6d88ph_key\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean flag = this.chkTemporaryPay(session, paramsObject, object);
        if (!flag) {
            return new RespBase(-1, "\u4e0d\u80fd\u91cd\u590d\u53d6\u6d88");
        }
        paramsObject.remove((Object)"ph_key");
        if (paramsObject.containsKey((Object)"clearTime")) {
            clearTime = paramsObject.getString("clearTime");
        } else {
            clearTime = this.functionRemoteService.getClearTime(object.getString("erpCode"), object.getString("mkt"), object.getString("syjh"));
            paramsObject.put("clearTime", (Object)clearTime);
        }
        String accountDate = this.getOutLineTime();
        paramsObject.put("accountDate", (Object)accountDate);
        this.logger.info("\u7f34\u6b3e\u65f6\u95f4clearTime=" + clearTime);
        this.logger.info("\u8d26\u52a1\u65e5\u671faccountDate=" + accountDate);
        if (!paramsObject.containsKey((Object)"ph_key1")) {
            paramsObject.put("ph_key1", (Object)UniqueID.getUniqueID());
        }
        if ((response = this.payinheadService.add1(session, paramsObject)).getReturncode().equals("0")) {
            long syjmainlogph_key = Long.valueOf(paramsObject.getString("ph_key1"));
            try {
                JSONObject object2 = new JSONObject();
                object2.put("erpCode", object.get((Object)"erpCode"));
                object2.put("mkt", object.get((Object)"mkt"));
                object2.put("syjh", object.get((Object)"syjh"));
                List syjmainList = this.syjmainService.listByMap((Map)object2, "syjmain");
                if (null == syjmainList && syjmainList.size() <= 0) {
                    log.info("\u63d2\u5165\u7f34\u6b3e\u6210\u529f\uff0c\u672a\u627e\u5230\u6b3e\u673a\u4fe1\u606f:");
                    this.payinheadService.delete(paramsObject.getString("ph_key1"));
                    return new RespBase(-1, "\u672c\u5730\u6570\u636e\u5f02\u5e38\uff0c\u7f34\u6b3e\u5931\u8d25");
                }
                Syjmain syjmain = (Syjmain)syjmainList.get(0);
                String syjcursyyh = "";
                syjcursyyh = paramsObject.containsKey((Object)"authsyyh") ? paramsObject.getString("authsyyh") : syjmain.getSyjcursyyh();
                JSONObject syjpaylog = new JSONObject();
                syjpaylog.put("syjcursyyh", (Object)syjcursyyh);
                syjpaylog.put("erpCode", (Object)syjmain.getErpCode());
                syjpaylog.put("mkt", (Object)syjmain.getMkt());
                syjpaylog.put("syjh", (Object)syjmain.getSyjh());
                syjpaylog.put("accountDate", (Object)accountDate);
                long syjpaycount = this.syjMainLogRemoteService.getMaxPreCount(syjpaylog);
                long ph_key = syjmain.getPhKey();
                object2.put("syjpaycount", (Object)(syjpaycount + 1L));
                object2.put("syjcurcashje", paramsObject.get((Object)"syjcurcashje"));
                object2.put("syjcurtime", (Object)new Date());
                object2.put("ph_key", (Object)ph_key);
                object2.put("syjcursyyh", (Object)syjcursyyh);
                this.syjmainService.updateSyjmain((Syjmain)JSON.toJavaObject((JSON)object2, Syjmain.class));
                JSONObject ob = new JSONObject();
                ob.put("mkt", (Object)syjmain.getMkt());
                ob.put("erpCode", (Object)syjmain.getErpCode());
                ob.put("syjh", (Object)syjmain.getSyjh());
                ob.put("syjcursyyh", (Object)syjcursyyh);
                ob.put("syjopentime", (Object)syjmain.getSyjopentime());
                ob.put("syjcleartime", (Object)syjmain.getSyjcleartime());
                ob.put("syjcurstatus", (Object)syjmain.getSyjcurstatus());
                ob.put("syjcurtime", object2.get((Object)"syjcurtime"));
                ob.put("syjcurinvbs", (Object)syjmain.getSyjcurinvbs());
                ob.put("syjcurinvje", (Object)syjmain.getSyjcurinvje());
                ob.put("syjcurcashje", paramsObject.get((Object)"syjcurcashje"));
                ob.put("syjpaycashje", paramsObject.get((Object)"syjpaycashje"));
                ob.put("syjcurpreje", (Object)syjmain.getSyjcurpreje());
                ob.put("syjcurnum", (Object)syjmain.getSyjcurnum());
                ob.put("status", (Object)3);
                ob.put("syjpaycount", (Object)(syjpaycount + 1L));
                ob.put("accountDate", (Object)accountDate);
                ob.put("updateDate", (Object)time);
                if (paramsObject.containsKey((Object)"cancelph_key")) {
                    ob.put("cancelph_key", paramsObject.get((Object)"cancelph_key"));
                }
                if (paramsObject.containsKey((Object)"ph_key1")) {
                    ob.put("ph_key", paramsObject.get((Object)"ph_key1"));
                }
                JSONObject worklog = new JSONObject();
                worklog.put("erpCode", (Object)object.getString("erpCode"));
                worklog.put("mkt", (Object)object.getString("mkt"));
                worklog.put("syjh", (Object)object.getString("syjh"));
                worklog.put("syyh", (Object)paramsObject.getString("authsyyh"));
                worklog.put("rqsj", (Object)new Date());
                worklog.put("logtype", paramsObject.get((Object)"worklog_logtype"));
                worklog.put("logdesc", paramsObject.get((Object)"worklog_logdesc"));
                worklog.put("entId", (Object)session.getEnt_id());
                worklog.put("updateDate", (Object)time);
                if (!this.localcache.booleanValue() && !this.hazelcast.booleanValue()) {
                    ob.put("synDate", (Object)time);
                    worklog.put("synDate", (Object)time);
                }
                int i1 = this.syjMainLogRemoteService.saveEntity(ob);
                log.info("syjMainLog\u63d2\u5165\u6570\u636e" + i1 + "\u6761");
                this.posWorkLogRemoteService.onInsert(worklog);
                if (this.hazelcast.booleanValue() || this.localcache.booleanValue()) {
                    log.info("\u5f00\u59cb\u5411syncpay\u8868\u63d2\u5165\u6570\u636e");
                    Syncpay syncpay = new Syncpay();
                    syncpay.setPayInCode(object.getString("payInCode"));
                    syncpay.setRqsj(object.getDate("updateDate"));
                    try {
                        this.syncpayService.insertSyncpay(syncpay);
                    }
                    catch (Exception e) {
                        log.error("syncpay\u63d2\u5165\u6570\u636e\u5f02\u5e38");
                        log.error(e.getLocalizedMessage());
                    }
                }
                JSONObject j = new JSONObject();
                j.put("erpCode", object.get((Object)"erpCode"));
                j.put("mkt", object.get((Object)"mkt"));
                j.put("code", (Object)"4C");
                List syspara = this.sysparaService.listByMap((Map)j, "syspara");
                JSONObject syjlog = new JSONObject();
                syjlog.put("syjcursyyh", (Object)paramsObject.getString("authsyyh"));
                syjlog.put("erpCode", (Object)object.getString("erpCode"));
                syjlog.put("mkt", (Object)object.getString("mkt"));
                syjlog.put("syjh", (Object)object.getString("syjh"));
                syjlog.put("accountDate", (Object)accountDate);
                if (syspara.size() == 0) {
                    this.logger.info("\u67e5\u8be2\u5f53\u65e5\u7f34\u6b3e\u53c2\u6570\uff1a" + syjlog);
                    RespBase res = this.syjMainLogRemoteService.getTemporaryPayLog(session, null, syjlog);
                    JSONObject object5 = (JSONObject)res.getData();
                    JSONArray array2 = object5.getJSONArray("todayhistory");
                    BigDecimal totalpay = new BigDecimal(0.0);
                    for (int i = 0; i < array2.size(); ++i) {
                        BigDecimal syjpaycashje = array2.getJSONObject(i).getBigDecimal("syjpaycashje");
                        totalpay = totalpay.add(syjpaycashje);
                    }
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("syjpaycount", object2.get((Object)"syjpaycount"));
                    jsonObject.put("syjtotalpaycash", (Object)totalpay);
                    jsonObject.put("todayhistory", (Object)array2);
                    jsonObject.put("clearTime", (Object)paramsObject.getString("clearTime"));
                    jsonObject.put("ph_key1", (Object)paramsObject.getString("ph_key1"));
                    JSONObject requstParam = new JSONObject();
                    requstParam.put("ph_key", (Object)syjmainlogph_key);
                    requstParam.put("payinhead", (Object)((JSONObject)response.getData()).getJSONObject("payinhead"));
                    requstParam.put("payindetail", (Object)((JSONObject)response.getData()).getJSONArray("payindetail"));
                    requstParam.put("syjpaycashje", paramsObject.get((Object)"syjpaycashje"));
                    requstParam.put("syjcurcashje", paramsObject.get((Object)"syjcurcashje"));
                    requstParam.put("syjcursyyh", paramsObject.get((Object)"syjcursyyh"));
                    jsonObject.put("requstParam", (Object)requstParam);
                    this.logger.info("\u4e2d\u9014\u7f34\u6536--->\u8bb0\u8d26\u65e5\u671faccountDate\uff1a" + accountDate);
                    return new RespBase(Code.SUCCESS, (Object)jsonObject, "TEMPORARYPAYIN");
                }
                BigDecimal paravalue = new BigDecimal(0.0);
                for (int k = 0; k < syspara.size(); ++k) {
                    Syspara sys = (Syspara)syspara.get(k);
                    if (StringUtils.isBlank((String)sys.getParavalue())) {
                        this.logger.info("\u67e5\u8be2\u5f53\u65e5\u7f34\u6b3e\u53c2\u6570\uff1a" + syjlog);
                        RespBase res1 = this.syjMainLogRemoteService.getTemporaryPayLog(session, null, syjlog);
                        JSONObject object5 = (JSONObject)res1.getData();
                        JSONArray array2 = object5.getJSONArray("todayhistory");
                        BigDecimal totalpay = new BigDecimal(0.0);
                        for (int i = 0; i < array2.size(); ++i) {
                            BigDecimal syjpaycashje = array2.getJSONObject(i).getBigDecimal("syjpaycashje");
                            totalpay = totalpay.add(syjpaycashje);
                        }
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("syjpaycount", object2.get((Object)"syjpaycount"));
                        jsonObject.put("syjtotalpaycash", (Object)totalpay);
                        jsonObject.put("todayhistory", (Object)array2);
                        jsonObject.put("clearTime", (Object)paramsObject.getString("clearTime"));
                        jsonObject.put("ph_key1", (Object)paramsObject.getString("ph_key1"));
                        JSONObject requstParam = new JSONObject();
                        requstParam.put("ph_key", (Object)syjmainlogph_key);
                        requstParam.put("payinhead", (Object)((JSONObject)response.getData()).getJSONObject("payinhead"));
                        requstParam.put("payindetail", (Object)((JSONObject)response.getData()).getJSONArray("payindetail"));
                        requstParam.put("syjpaycashje", paramsObject.get((Object)"syjpaycashje"));
                        requstParam.put("syjcurcashje", paramsObject.get((Object)"syjcurcashje"));
                        requstParam.put("syjcursyyh", paramsObject.get((Object)"syjcursyyh"));
                        jsonObject.put("requstParam", (Object)requstParam);
                        this.logger.info("\u4e2d\u9014\u7f34\u6536--->\u8bb0\u8d26\u65e5\u671faccountDate\uff1a" + accountDate);
                        return new RespBase(Code.SUCCESS, (Object)jsonObject, "TEMPORARYPAYIN");
                    }
                    paravalue = new BigDecimal(sys.getParavalue());
                }
                BigDecimal syjcurcashje = paramsObject.getBigDecimal("syjcurcashje");
                if (syjcurcashje.compareTo(paravalue) == 1) {
                    JSONObject syj = new JSONObject();
                    syj.put("ph_key", object2.get((Object)"ph_key"));
                    syj.put("syjcurstatus", (Object)"8");
                    syj.put("syjcurtime", (Object)new Date());
                    this.syjmainService.updateSyjmain((Syjmain)JSON.toJavaObject((JSON)syj, Syjmain.class));
                    this.logger.info("\u67e5\u8be2\u5f53\u65e5\u7f34\u6b3e\u53c2\u6570\uff1a" + syjlog);
                    RespBase res2 = this.syjMainLogRemoteService.getTemporaryPayLog(session, null, syjlog);
                    JSONObject object5 = (JSONObject)res2.getData();
                    JSONArray array2 = object5.getJSONArray("todayhistory");
                    BigDecimal totalpay = new BigDecimal(0.0);
                    for (int i = 0; i < array2.size(); ++i) {
                        BigDecimal syjpaycashje = array2.getJSONObject(i).getBigDecimal("syjpaycashje");
                        totalpay = totalpay.add(syjpaycashje);
                    }
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("syjpaycount", object2.get((Object)"syjpaycount"));
                    jsonObject.put("syjtotalpaycash", (Object)totalpay);
                    jsonObject.put("retMsg", (Object)"\u73b0\u91d1\u5b58\u91cf\u4f9d\u7136\u8fc7\u91cf");
                    jsonObject.put("todayhistory", (Object)array2);
                    JSONObject requstParam = new JSONObject();
                    requstParam.put("ph_key", (Object)syjmainlogph_key);
                    jsonObject.put("clearTime", (Object)paramsObject.getString("clearTime"));
                    jsonObject.put("ph_key1", (Object)paramsObject.getString("ph_key1"));
                    requstParam.put("payinhead", (Object)((JSONObject)response.getData()).getJSONObject("payinhead"));
                    requstParam.put("payindetail", (Object)((JSONObject)response.getData()).getJSONArray("payindetail"));
                    requstParam.put("syjpaycashje", paramsObject.get((Object)"syjpaycashje"));
                    requstParam.put("syjcurcashje", paramsObject.get((Object)"syjcurcashje"));
                    requstParam.put("syjcursyyh", paramsObject.get((Object)"syjcursyyh"));
                    jsonObject.put("requstParam", (Object)requstParam);
                    this.logger.info("\u4e2d\u9014\u7f34\u6536--->\u8bb0\u8d26\u65e5\u671faccountDate\uff1a" + accountDate);
                    return new RespBase(Code.SUCCESS, (Object)jsonObject, "TEMPORARYPAYIN");
                }
                this.logger.info("\u67e5\u8be2\u5f53\u65e5\u7f34\u6b3e\u53c2\u6570\uff1a" + syjlog);
                RespBase res3 = this.syjMainLogRemoteService.getTemporaryPayLog(session, null, syjlog);
                JSONObject object5 = (JSONObject)res3.getData();
                JSONArray array2 = object5.getJSONArray("todayhistory");
                BigDecimal totalpay = new BigDecimal(0.0);
                for (int i = 0; i < array2.size(); ++i) {
                    BigDecimal syjpaycashje = array2.getJSONObject(i).getBigDecimal("syjpaycashje");
                    if (null == syjpaycashje) continue;
                    totalpay = totalpay.add(syjpaycashje);
                }
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("syjpaycount", object2.get((Object)"syjpaycount"));
                jsonObject.put("syjtotalpaycash", (Object)totalpay);
                jsonObject.put("todayhistory", (Object)array2);
                JSONObject requstParam = new JSONObject();
                jsonObject.put("clearTime", (Object)paramsObject.getString("clearTime"));
                jsonObject.put("ph_key1", (Object)paramsObject.getString("ph_key1"));
                requstParam.put("ph_key", (Object)syjmainlogph_key);
                requstParam.put("payinhead", (Object)((JSONObject)response.getData()).getJSONObject("payinhead"));
                requstParam.put("payindetail", (Object)((JSONObject)response.getData()).getJSONArray("payindetail"));
                requstParam.put("syjpaycashje", paramsObject.get((Object)"syjpaycashje"));
                requstParam.put("syjcurcashje", paramsObject.get((Object)"syjcurcashje"));
                requstParam.put("syjcursyyh", paramsObject.get((Object)"syjcursyyh"));
                jsonObject.put("requstParam", (Object)requstParam);
                this.logger.info("\u4e2d\u9014\u7f34\u6536--->\u8bb0\u8d26\u65e5\u671faccountDate\uff1a" + accountDate);
                return new RespBase(Code.SUCCESS, (Object)jsonObject, "TEMPORARYPAYIN");
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info("\u63d2\u5165\u7f34\u6b3e\u6210\u529f\uff0c\u4fee\u6539\u6536\u94f6\u673a\u72b6\u6001\u5f02\u5e38:", (Throwable)e);
                this.payinheadService.delete(paramsObject.getString("ph_key1"));
                return new RespBase(-1, "\u672c\u5730\u6570\u636e\u5f02\u5e38\uff0c\u7f34\u6b3e\u5931\u8d25");
            }
        }
        return new RespBase(-1, "\u672c\u5730\u6570\u636e\u5f02\u5e38\uff0c\u7f34\u6b3e\u5931\u8d25\u3002");
    }

    @Transactional
    public RespBase synchronizDataOffline(ServiceSession session, JSONObject paramsObject) {
        if (!this.hazelcast.booleanValue() && !this.localcache.booleanValue()) {
            return new RespBase(0, "\u540c\u6b65\u6570\u636e\u63a5\u53e3\u53ea\u5141\u8bb8\u5728\u8131\u673a\u72b6\u6001\u4e0b\u8c03\u7528!");
        }
        if (!paramsObject.containsKey((Object)"syjh")) {
            return new RespBase(-1, "\u53c2\u6570\u7f3a\u5c11\u6536\u94f6\u673a\u53f7,\u8bf7\u68c0\u67e5\u53c2\u6570!");
        }
        if (!paramsObject.containsKey((Object)"mkt")) {
            return new RespBase(-1, "\u53c2\u6570\u7f3a\u5c11\u95e8\u5e97\u7f16\u7801,\u8bf7\u68c0\u67e5\u53c2\u6570!");
        }
        if (!paramsObject.containsKey((Object)"erpCode")) {
            return new RespBase(-1, "\u53c2\u6570\u7f3a\u5c11\u7ecf\u8425\u516c\u53f8\u7f16\u7801,\u8bf7\u68c0\u67e5\u53c2\u6570!");
        }
        Syjmain syQuery = (Syjmain)JSON.parseObject((String)paramsObject.toJSONString(), Syjmain.class);
        JSONObject request = new JSONObject();
        request.put("synstatus", (Object)"1");
        RespBase respBaseSyjmainlog = this.syjMainLogRemoteService.uploadData(request);
        log.info("\u4e0a\u4f20syjmainlog\u8fd4\u56de==>{}", JSONObject.toJSON((Object)respBaseSyjmainlog));
        RespBase respBasePosworklog = this.posWorkLogRemoteService.uploadData(request);
        log.info("\u4e0a\u4f20Posworklog\u8fd4\u56de==>{}", JSONObject.toJSON((Object)respBasePosworklog));
        HashMap data = new HashMap();
        JSONObject jsonObject = null;
        RespBase respBase = null;
        try {
            ArrayList phList = new ArrayList();
            ArrayList pdList = new ArrayList();
            ArrayList pwList = new ArrayList();
            int count1 = 0;
            int count2 = 0;
            boolean count3 = false;
            List syLists = this.syncpayService.querySyncpay();
            if (syLists != null && syLists.size() > 0) {
                count1 = syLists.size();
                for (Syncpay obj : syLists) {
                    String payInCode = obj.getPayInCode();
                    log.info("\u7f34\u6b3e\u5355\u53f7==>{}", (Object)payInCode);
                    HashMap<String, String> queryParams = new HashMap<String, String>();
                    queryParams.put("erpCode", syQuery.getErpCode());
                    queryParams.put("mkt", syQuery.getMkt());
                    queryParams.put("syjh", syQuery.getSyjh());
                    queryParams.put("payInCode", payInCode);
                    List pdObj = this.payinheadService.getPayInHeadByPayInCode(queryParams);
                    if (null == pdObj) {
                        log.info("\u6ca1\u6709\u67e5\u8be2\u5230\u7f34\u6b3e\u5355\u5934\u8df3\u51fa\u5faa\u73af");
                        continue;
                    }
                    HashMap<String, Object> queryParams2 = new HashMap<String, Object>();
                    queryParams2.put("erpCode", syQuery.getErpCode());
                    queryParams2.put("mkt", syQuery.getMkt());
                    queryParams2.put("payInHeadId", ((Payinhead)pdObj.get(0)).getPayInId());
                    List list2 = this.payindetailService.listByMap(queryParams2, "payindetail");
                    ((Payinhead)pdObj.get(0)).setPayindetails(list2);
                    count2 = list2.size();
                    log.info("\u7f34\u6b3e\u5355\u660e\u7ec6==>{}", (Object)list2.size());
                    phList.add(pdObj.get(0));
                }
                if (phList != null) {
                    data.put("payinlist", phList);
                }
            }
            Syjmain syjmain = this.syjmainService.selectOneByMKTAndSYJ(syQuery);
            log.info("\u8131\u673a\u72b6\u6001\u6700\u65b0syjmain==>{}", (Object)syjmain);
            if (syjmain == null) {
                return new RespBase(-1, "syjmain\u8868\u672a\u67e5\u5230\u6570\u636e!");
            }
            data.put("syjmain", syjmain);
            jsonObject = new JSONObject(data);
            log.info("\u9700\u540c\u6b65\u7f34\u6b3e\u5355\u5934\u6570\u636e==>{}", (Object)(count1 + "\u6761"));
            log.info("\u9700\u540c\u6b65\u7f34\u6b3e\u5355\u660e\u7ec6\u6570\u636e==>{}", (Object)(count2 + "\u6761"));
            if (0 == count1 && 0 == count2 && !count3) {
                log.info("\u6ca1\u6709\u9700\u8981\u540c\u6b65\u7684\u6570\u636e\uff0c\u76f4\u63a5\u8fd4\u56de\u6210\u529f");
                return new RespBase(Code.SUCCESS, (Object)"\u6ca1\u6709\u9700\u8981\u540c\u6b65\u7684\u6570\u636e", null);
            }
            respBase = this.synchronizData("SYNCHRONIZDATAONLINE", jsonObject);
            log.info("\u540c\u6b65\u7f34\u6b3e\u8fd4\u56de\uff1a" + JSON.toJSONString((Object)respBase));
            if (-1 == respBase.getRetflag()) {
                return respBase;
            }
            JSONObject json = (JSONObject)respBase.getData();
            JSONArray sucList = json.getJSONArray("sucList");
            if (null != sucList) {
                for (Object str : sucList) {
                    HashMap map = new HashMap();
                    map.put("payInCode", str);
                    log.info("\u5f00\u59cb\u5220\u9664\u4e0a\u4f20\u6210\u529f\u7f34\u6b3e\u5355\u961f\u5217==>" + str);
                    this.syncpayService.delByPayInCode(map);
                    log.info("\u5220\u9664\u7ed3\u675f==>" + str);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new RespBase(Code.FAIL.getIndex(), "POS\u7f34\u6b3e\u6570\u636e\u540c\u6b65\u5931\u8d25");
        }
        return new RespBase(Code.SUCCESS, respBase.getData(), "SYTEMPORARYPAYIN");
    }

    private RespBase synchronizData(String commandId, JSONObject param) {
        try {
            param.put("command_id", (Object)commandId);
            String res = HttpClientUtils.postJson((String)GlobalInfo.cloudUrl, (String)param.toString());
            if (null != res && !"".equals(res)) {
                RespBase resp = (RespBase)JSONObject.parseObject((String)res, RespBase.class);
                return resp.setCommand_id(commandId);
            }
            log.info("\u540c\u6b65\u7ebf\u4e0a\u6570\u636e\u5931\u8d25!");
            return new RespBase(-1, "\u540c\u6b65\u7ebf\u4e0a\u6570\u636e\u5931\u8d25,\u8bf7\u68c0\u67e5\u7f51\u7edc\u72b6\u6001");
        }
        catch (Exception e) {
            log.info("\u540c\u6b65\u7ebf\u4e0a\u6570\u636e\u53d1\u751f\u5f02\u5e38: " + e.toString());
            return new RespBase(-1, "\u540c\u6b65\u7ebf\u4e0a\u6570\u636e\u5931\u8d25,\u8bf7\u68c0\u67e5\u7f51\u7edc\u72b6\u6001!");
        }
    }

    public RespBase synchronizDataOnline(ServiceSession session, JSONObject paramsObject) {
        RespBase respBase = new RespBase();
        try {
            log.info("\u7ebf\u4e0a\u670d\u52a1\u5f00\u59cb\u540c\u6b65\u7ebf\u4e0b\u7f34\u6b3e\u6570\u636e.....");
            respBase = this.payinheadService.insertPayData(paramsObject);
            if (respBase.getRetflag() == -1) {
                return new RespBase(-1, respBase.getRetmsg());
            }
            if (paramsObject.containsKey((Object)"posWorkLog")) {
                JSONArray posWorkLogList = paramsObject.getJSONArray("posWorkLog");
                for (int i = 0; i < posWorkLogList.size(); ++i) {
                    JSONObject worklog = (JSONObject)posWorkLogList.get(i);
                    this.posWorkLogRemoteService.onInsert(worklog);
                }
            }
            JSONObject syjmain = paramsObject.getJSONObject("syjmain");
            this.syjmainService.updateByMKTAndSYJH((Syjmain)JSON.toJavaObject((JSON)syjmain, Syjmain.class));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u540c\u6b65\u7ebf\u4e0a\u6570\u636e\u5f02\u5e38==>{}", (Object)e.toString());
        }
        return new RespBase(Code.SUCCESS, respBase.getData(), "SYNCHRONIZDATAONLINE");
    }

    public boolean chkTemporaryPay(ServiceSession session, JSONObject paramsObject, JSONObject payinhead) {
        if (payinhead.getString("sourceType").equals("1")) {
            payinhead.put("payInType", (Object)"2");
            paramsObject.put("cashlog_status", (Object)"12");
            paramsObject.put("worklog_logtype", (Object)"32");
            paramsObject.put("worklog_logdesc", (Object)"\u7f34\u6b3e");
            paramsObject.put("searchflag", (Object)"1");
        }
        if (payinhead.getString("sourceType").equals("2")) {
            payinhead.put("payInType", (Object)"1");
            paramsObject.put("cashlog_status", (Object)"3");
            paramsObject.put("worklog_logtype", (Object)"16");
            paramsObject.put("worklog_logdesc", (Object)"\u4e2d\u95f4\u56de\u6536");
            paramsObject.put("searchflag", (Object)"2");
        }
        if (payinhead.getString("sourceType").equals("3")) {
            payinhead.put("payInType", (Object)"3");
            paramsObject.put("cashlog_status", (Object)"13");
            paramsObject.put("worklog_logtype", (Object)"33");
            paramsObject.put("worklog_logdesc", (Object)"\u4e2d\u95f4\u56de\u6536\u53d6\u6d88");
            paramsObject.put("searchflag", (Object)"2");
        }
        if (payinhead.getString("sourceType").equals("4")) {
            payinhead.put("payInType", (Object)"4");
            paramsObject.put("cashlog_status", (Object)"15");
            paramsObject.put("worklog_logtype", (Object)"37");
            paramsObject.put("worklog_logdesc", (Object)"\u7f34\u6b3e\u53d6\u6d88");
            paramsObject.put("searchflag", (Object)"1");
        }
        paramsObject.put("sourceType", (Object)payinhead.getString("sourceType"));
        if (payinhead.getString("sourceType").equals("1") || payinhead.getString("sourceType").equals("2")) {
            return true;
        }
        paramsObject.put("cancelph_key", (Object)paramsObject.getString("ph_key"));
        String s = this.syjMainLogRemoteService.getCashList(paramsObject);
        JSONArray objects = JSON.parseArray((String)s);
        return objects.size() <= 0;
    }

    public RespBase TemporaryPay(ServiceSession session, JSONObject paramsObject) {
        MultipleDataSource.setDataSourceKey((String)"dataSource");
        RespBase respBase = null;
        try {
            respBase = this.TemporaryPay1(session, paramsObject);
        }
        catch (Exception e) {
            log.error("\u7f34\u6b3e\u5f02\u5e38\uff1a", (Throwable)e);
            respBase = new RespBase(Code.FAIL, (Object)e.fillInStackTrace());
        }
        return respBase;
    }

    public RespBase syTemporaryPay(ServiceSession session, JSONObject paramsObject) throws Exception {
        MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("sync"));
        return this.synchronizDataOffline(session, paramsObject);
    }

    public RespBase cgposClearByMan(ServiceSession session, JSONObject param) {
        if (!param.containsKey((Object)"erpCode")) {
            return new RespBase(-1, "\u8bf7\u4e0a\u4f20\u7ecf\u8425\u516c\u53f8[erpCode]");
        }
        if (!param.containsKey((Object)"mkt")) {
            return new RespBase(-1, "\u8bf7\u4e0a\u4f20\u95e8\u5e97\u53f7[mkt]");
        }
        if (!param.containsKey((Object)"syjh")) {
            return new RespBase(-1, "\u8bf7\u4e0a\u4f20\u6536\u94f6\u673a\u53f7[syjh]");
        }
        if (!param.containsKey((Object)"operuserGh")) {
            return new RespBase(-1, "\u8bf7\u4e0a\u4f20\u6536\u94f6\u5458\u5de5\u53f7[operuserGh]");
        }
        if (!param.containsKey((Object)"authorizeGh") && !param.containsKey((Object)"operateGh")) {
            return new RespBase(-1, "\u6ca1\u6709\u6388\u6743\u4eba\uff0c\u8bf7\u4e0a\u4f20\u64cd\u4f5c\u5458\u5de5\u53f7[operateGh]");
        }
        String clearTime = this.functionRemoteService.getClearTime(param.getString("erpCode"), param.getString("mkt"), param.getString("syjh"));
        this.logger.info("clearTime" + clearTime);
        param.put("clearTime", (Object)clearTime);
        return this.posClearBymanIDC(session, param);
    }

    public RespBase posClearBymanIDC(ServiceSession session, JSONObject param) {
        ServiceResponse checkResp = this.checkOperUser(session, param);
        if ("10000".equals(checkResp.getReturncode())) {
            return new RespBase(-1, "\u67e5\u8be2\u5de5\u53f7\u5931\u8d25\uff0c\u8bf7\u6838\u5bf9\u5de5\u53f7");
        }
        Syjmain syjMain = this.checkSyj(session, param);
        if (syjMain == null) {
            return new RespBase(-1, "\u67e5\u8be2\u6536\u94f6\u673a\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        String clearTime = param.getString("clearTime");
        this.logger.info("clearTime" + clearTime);
        JSONObject orderObject = new JSONObject();
        orderObject.put("createDate", (Object)clearTime);
        orderObject.put("busiTakeMarketCode", param.get((Object)"mkt"));
        orderObject.put("erpCode", param.get((Object)"erpCode"));
        orderObject.put("terminalNo", param.get((Object)"syjh"));
        orderObject.put("terminalOperator", param.get((Object)"operuserGh"));
        orderObject.put("searchType", (Object)"3");
        RespBase response = this.orderRemoteService.searchTerminalReport(session, orderObject);
        JSONObject orderResult = (JSONObject)JSONObject.toJSON((Object)response.getData());
        param.put("searchType", (Object)"3");
        List cashLog = this.syjCashLogRemoteService.countCashLog(session, param);
        this.adpter(cashLog, orderResult);
        orderResult.put("operuserGh", (Object)param.getString("operuserGh"));
        orderResult.put("authorizeGh", (Object)param.getString("authorizeGh"));
        orderResult.put("operateGh", (Object)param.getString("operateGh"));
        BigDecimal diffCash = this.getDiffCash(orderResult);
        orderResult.put("diffCash", (Object)diffCash);
        return new RespBase(Code.SUCCESS, (Object)orderResult, "CNAEONNEWSYYCLEAR");
    }

    public RespBase posClearReport(ServiceSession session, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"erpCode")) {
            return Code.CODE_100001.getRespBase(new Object[]{"erpCode"});
        }
        if (!paramsObject.containsKey((Object)"mkt")) {
            return Code.CODE_100001.getRespBase(new Object[]{"mkt"});
        }
        if (!paramsObject.containsKey((Object)"syjh")) {
            return Code.CODE_100001.getRespBase(new Object[]{"syjh"});
        }
        if (!paramsObject.containsKey((Object)"syjcursyyh")) {
            return Code.CODE_100001.getRespBase(new Object[]{"syjcursyyh"});
        }
        JSONObject syjlog = new JSONObject();
        syjlog.put("erpCode", paramsObject.get((Object)"erpCode"));
        syjlog.put("mkt", paramsObject.get((Object)"mkt"));
        syjlog.put("syjh", paramsObject.get((Object)"syjh"));
        Syjmain syjMain = this.checkSyj(session, paramsObject);
        if (syjMain == null) {
            return Code.CODE_100002.getRespBase(new Object[]{paramsObject.getString("syjh")});
        }
        JSONObject clear = new JSONObject();
        clear.put("saleMarket", (Object)paramsObject.getString("shopName"));
        clear.put("terminalNo", (Object)paramsObject.getString("syjh"));
        clear.put("terminalOperator", paramsObject.get((Object)"syjcursyyh"));
        clear.put("shopCode", (Object)syjMain.getBusinessid());
        Date today = new Date();
        syjlog.put("today", (Object)DateUtils.formatDateTime((Date)today));
        BigDecimal totalpreje = this.syjMainLogRemoteService.getTotalPreje(syjlog);
        clear.put("loan", (Object)totalpreje);
        BigDecimal totalpay = this.syjMainLogRemoteService.getTotalPay(syjlog);
        clear.put("middleCollection", (Object)totalpay);
        clear.put("searchType", (Object)1);
        JSONObject sys = new JSONObject();
        sys.put("erpCode", paramsObject.get((Object)"erpCode"));
        sys.put("mkt", paramsObject.get((Object)"mkt"));
        sys.put("statu", (Object)"1");
        sys.put("code", (Object)"AJZF");
        List sysparas = this.sysparaService.listByMap((Map)sys);
        if (sysparas.size() != 0) {
            String paravalue = ((Syspara)sysparas.get(0)).getParavalue();
            clear.put("payCode", (Object)paravalue);
        } else {
            clear.put("payCode", (Object)"0602");
        }
        RespBase response = this.orderRemoteService.searchTerminalReport(session, clear);
        return response;
    }

    public RespBase posClearByManReport(ServiceSession session, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"erpCode")) {
            return Code.CODE_100001.getRespBase(new Object[]{"erpCode"});
        }
        if (!paramsObject.containsKey((Object)"mkt")) {
            return Code.CODE_100001.getRespBase(new Object[]{"mkt"});
        }
        if (!paramsObject.containsKey((Object)"syjh")) {
            return Code.CODE_100001.getRespBase(new Object[]{"syjh"});
        }
        if (!paramsObject.containsKey((Object)"syjcursyyh")) {
            return Code.CODE_100001.getRespBase(new Object[]{"syjcursyyh"});
        }
        JSONObject syjlog = new JSONObject();
        syjlog.put("erpCode", paramsObject.get((Object)"erpCode"));
        syjlog.put("mkt", paramsObject.get((Object)"mkt"));
        syjlog.put("syjh", paramsObject.get((Object)"syjh"));
        Syjmain syjMain = this.checkSyj(session, paramsObject);
        if (syjMain == null) {
            return Code.CODE_100002.getRespBase(new Object[]{paramsObject.getString("syjh")});
        }
        JSONObject clear = new JSONObject();
        clear.put("saleMarket", (Object)paramsObject.getString("shopName"));
        clear.put("terminalNo", (Object)paramsObject.getString("syjh"));
        clear.put("terminalOperator", paramsObject.get((Object)"syjcursyyh"));
        clear.put("shopCode", (Object)syjMain.getBusinessid());
        Date today = new Date();
        syjlog.put("today", (Object)DateUtils.formatDateTime((Date)today));
        BigDecimal totalpreje = this.syjMainLogRemoteService.getTotalPreje(syjlog);
        clear.put("loan", (Object)totalpreje);
        BigDecimal totalpay = this.syjMainLogRemoteService.getTotalPay(syjlog);
        clear.put("middleCollection", (Object)totalpay);
        clear.put("searchType", (Object)2);
        JSONObject sys = new JSONObject();
        sys.put("erpCode", paramsObject.get((Object)"erpCode"));
        sys.put("mkt", paramsObject.get((Object)"mkt"));
        sys.put("statu", (Object)"1");
        sys.put("code", (Object)"AJZF");
        List sysparas = this.sysparaService.listByMap((Map)sys);
        if (sysparas.size() != 0) {
            String paravalue = ((Syspara)sysparas.get(0)).getParavalue();
            clear.put("payCode", (Object)paravalue);
        } else {
            clear.put("payCode", (Object)"0602");
        }
        RespBase response = this.orderRemoteService.searchTerminalReport(session, clear);
        return response;
    }

    private JSONObject getRedisData(JSONObject paramsObject) {
        String obj = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("mkt") + paramsObject.getString("syjh"));
        return JSONObject.parseObject((String)obj);
    }

    private String getPayType(String payCode, String erpCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"payCode", (Object)payCode);
        queryWrapper.eq((Object)"erpCode", (Object)erpCode);
        queryWrapper.eq((Object)"reporttype", (Object)"1");
        Payindiffmode payindiffmode = (Payindiffmode)this.payindiffmodeService.getOne((Wrapper)queryWrapper);
        if (null != payindiffmode) {
            return payindiffmode.getPayType();
        }
        return "";
    }
}

