/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.WorkLogType;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.posManager.request.SendWorkLogIn;
import com.efuture.business.service.FunctionRemoteService;
import com.product.model.ServiceSession;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class InitializeTask {
    private static final Logger log = LoggerFactory.getLogger(InitializeTask.class);
    @SoaAnnotation(value="/apiFunctionRemoteService.do")
    public FunctionRemoteService functionRemoteService;

    @Async
    public void sendWorkLog(ServiceSession session, Order order, String type) {
        this.sendWorkLog(session, order, type, null, null);
    }

    @Async
    public void sendWorkLog(ServiceSession session, Order order, String type, String goodsName, String goodsCode) {
        this.sendWorkLog(session, order, type, 0.0, 0.0, goodsName, goodsCode);
    }

    @Async
    public void sendWorkLog(ServiceSession session, Order order, String type, double amount, String goodsName, String goodsCode) {
        this.sendWorkLog(session, order, type, 0.0, amount, goodsName, goodsCode);
    }

    @Async
    public void sendWorkLog(ServiceSession session, Order order, String type, double count, double amount, String goodsName, String goodsCode) {
        this.sendWorkLog(session, order, type, null, count, amount, goodsName, goodsCode);
    }

    @Async
    public void sendWorkLog(ServiceSession session, Order order, String type, double count, double amount) {
        this.sendWorkLog(session, order, type, null, count, amount, null, null);
    }

    @Async
    public void sendWorkLog(ServiceSession session, Order order, String type, String info, double count, double amount, String goodsName, String goodsCode) {
        this.sendWorkLog(session, order, type, info, count, amount, goodsName, goodsCode, false);
    }

    @Async
    public void sendWorkLog(ServiceSession session, Order order, String type, String info, double count, double amount, String goodsName, String goodsCode, boolean isOrderDisc) {
        try {
            SendWorkLogIn in = new SendWorkLogIn();
            in.setErpCode(order.getErpCode());
            in.setMkt(order.getShopCode());
            in.setSyjh(order.getTerminalNo());
            in.setSyyh(order.getTerminalOperator());
            in.setBillno(order.getTerminalSno());
            in.setEntid(Long.valueOf(order.getEntId()));
            in.setGoodsName(goodsName);
            in.setGoodsCode(goodsCode);
            in.setLogtype(type);
            in.setLogdesc(info);
            in.setCount(count);
            in.setAmount(amount);
            if (!WorkLogType.regMember.equals(type)) {
                if (WorkLogType.refund.equals(type) || WorkLogType.voidSale.equals(type)) {
                    if (!StringUtils.isBlank((String)order.getRefundAuthzCardNo()) && !order.getTerminalOperator().equals(order.getRefundAuthzCardNo())) {
                        in.setAuthorizeGh(order.getRefundAuthzCardNo());
                    }
                } else if (isOrderDisc && StringUtils.isNotBlank((String)order.getTotalDiscAuthzCardNo()) && !order.getTerminalOperator().equals(order.getTotalDiscAuthzCardNo())) {
                    in.setAuthorizeGh(order.getTotalDiscAuthzCardNo());
                } else if (!StringUtils.isBlank((String)order.getTerminalOperatorAuthzCardNo()) && !order.getTerminalOperator().equals(order.getTerminalOperatorAuthzCardNo())) {
                    in.setAuthorizeGh(order.getTerminalOperatorAuthzCardNo());
                }
            }
            if (WorkLogType.delGoods.equals(type) || WorkLogType.refund.equals(type) || WorkLogType.voidSale.equals(type)) {
                in.setRowno(order.getFlowNo());
            }
            switch (type) {
                case "1": {
                    in.setLogdesc("\u6536\u94f6\u5458\u767b\u5f55");
                    break;
                }
                case "2": {
                    in.setLogdesc("\u5f55\u5165\u5907\u7528\u91d1");
                    break;
                }
                case "3": {
                    in.setLogdesc("\u6536\u94f6\u673a\u521d\u59cb\u5316\u5c0f\u7968");
                    break;
                }
                case "11": {
                    in.setLogdesc("\u6388\u6743");
                }
                case "16": {
                    in.setLogdesc("\u7f34\u6b3e");
                    break;
                }
                case "51": {
                    in.setLogdesc("\u76d8\u70b9");
                }
            }
            LocalDateTime dateTime = LocalDateTime.now();
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String nowDateTime = dateTime.format(df).toString();
            in.setRqsj(nowDateTime);
            this.functionRemoteService.posWorkLog(session, (JSONObject)JSON.toJSON((Object)in));
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            return;
        }
    }

    @Async
    public void sendWorkLog(ServiceSession session, JSONObject object, String type, String info) {
        try {
            SendWorkLogIn in = new SendWorkLogIn();
            in.setErpCode(object.getString("erpCode"));
            in.setMkt(object.getString("mkt"));
            in.setSyjh(object.getString("syjh"));
            if (StringUtils.isNotBlank((String)object.getString("syyh"))) {
                in.setSyyh(object.getString("syyh"));
            }
            in.setEntid(Long.valueOf(session.getEnt_id()));
            in.setLogtype(type);
            in.setLogdesc(info);
            LocalDateTime dateTime = LocalDateTime.now();
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String nowDateTime = dateTime.format(df).toString();
            in.setRqsj(nowDateTime);
            this.functionRemoteService.posWorkLog(session, (JSONObject)JSON.toJSON((Object)in));
            return;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return;
        }
    }
}

