/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.dao.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.dao.AdstrategydetailService;
import com.efuture.business.dao.AdstrategytemplateService;
import com.efuture.business.dao.impl.InitBaseServiceImpl;
import com.efuture.business.mapper.base.AdstrategytemplateMapper;
import com.efuture.business.model.Adstrategytemplate;
import com.efuture.business.util.ArrayUtils;
import com.efuture.redis.util.DateUtils;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AdstrategytemplateServiceImpl
extends InitBaseServiceImpl<AdstrategytemplateMapper, Adstrategytemplate>
implements AdstrategytemplateService {
    private static final Logger log = LoggerFactory.getLogger(AdstrategytemplateServiceImpl.class);
    @Autowired
    private AdstrategydetailService adstrategydetailService;

    public ServiceResponse searchForSyj(ServiceSession session, String syjgrpid, String mkt, String erpCode) {
        JSONArray tmpList;
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("syjgrpid", syjgrpid);
        param.put("mkt", mkt);
        param.put("erpCode", erpCode);
        param.put("adStatus", "1");
        log.info("\u67e5\u8be2\u5e7f\u544a\u4fe1\u606f==>{}", JSONObject.toJSON(param));
        List tmpRst = this.listByMap(param, "adstrategytemplate");
        log.info("<=={}", JSONObject.toJSON((Object)tmpRst));
        JSONObject defaultAd = null;
        JSONObject activityAd = null;
        if (ArrayUtils.isNotEmpty((List)tmpRst) && CollectionUtils.isNotEmpty((Collection)(tmpList = JSONArray.parseArray((String)JSONArray.toJSONString((Object)tmpRst))))) {
            for (Object obj : tmpList) {
                JSONObject tmp = (JSONObject)obj;
                if ("0".equals(tmp.getString("type"))) {
                    if (StringUtils.isBlank((String)tmp.getString("version")) || StringUtils.isBlank((String)tmp.getString("versionPath"))) {
                        defaultAd = null;
                        continue;
                    }
                    HashMap<String, Long> map = new HashMap<String, Long>();
                    map.put("templateId", tmp.getLong("templateId"));
                    List detailList = this.adstrategydetailService.listByMap(map);
                    log.info("Adstrategydetail<=={}", JSONArray.toJSON((Object)detailList));
                    if (CollectionUtils.isNotEmpty((Collection)detailList)) {
                        detailList = detailList.stream().filter(detail -> StringUtils.isNotBlank((String)detail.getFtpPath())).peek(detail -> detail.setFtpPath(detail.getFtpPath().substring(detail.getFtpPath().lastIndexOf("/") + 1))).collect(Collectors.toList());
                    }
                    tmp.put("adstrategydetail", (Object)detailList);
                    defaultAd = tmp;
                    continue;
                }
                String effectiveDate = DateUtils.formatDateTime((Date)tmp.getDate("effectiveDate"));
                String expirationDate = DateUtils.formatDateTime((Date)tmp.getDate("expirationDate"));
                if (!LocalDateTime.now().isAfter(LocalDateTime.parse(effectiveDate, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")).plusDays(-1L)) || !LocalDateTime.now().isBefore(LocalDateTime.parse(expirationDate, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")).plusDays(1L))) continue;
                if (StringUtils.isBlank((String)tmp.getString("version")) || StringUtils.isBlank((String)tmp.getString("versionPath"))) {
                    activityAd = null;
                    continue;
                }
                HashMap<String, Long> map = new HashMap<String, Long>();
                map.put("templateId", tmp.getLong("templateId"));
                List detailList = this.adstrategydetailService.listByMap(map);
                if (CollectionUtils.isNotEmpty((Collection)detailList)) {
                    detailList = detailList.stream().filter(detail -> StringUtils.isNotBlank((String)detail.getFtpPath())).peek(detail -> detail.setFtpPath(detail.getFtpPath().substring(detail.getFtpPath().lastIndexOf("/") + 1))).collect(Collectors.toList());
                }
                tmp.put("adstrategydetail", (Object)detailList);
                activityAd = tmp;
            }
        }
        JSONObject rst = new JSONObject();
        rst.put("defaultAd", defaultAd);
        rst.put("activityAd", activityAd);
        return ServiceResponse.buildSuccess((Object)rst);
    }
}

