/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.dao.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.efuture.business.dao.DictionarydataService;
import com.efuture.business.dao.ErppaymentmethodService;
import com.efuture.business.dao.PaymentmethodService;
import com.efuture.business.dao.PaymentmethodposrefService;
import com.efuture.business.dao.PaymentmethodrefService;
import com.efuture.business.dao.impl.InitBaseServiceImpl;
import com.efuture.business.mapper.base.PaymentmethodMapper;
import com.efuture.business.model.Dictionarydata;
import com.efuture.business.model.Erppaymentmethod;
import com.efuture.business.model.Paymentmethod;
import com.efuture.business.model.Paymentmethodposref;
import com.efuture.business.model.Paymentmethodref;
import com.efuture.business.util.ArrayUtils;
import com.efuture.business.util.db.DbTools;
import com.efuture.business.util.db.MultipleDataSource;
import com.product.model.ServiceSession;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PaymentmethodServiceImpl
extends InitBaseServiceImpl<PaymentmethodMapper, Paymentmethod>
implements PaymentmethodService {
    private static final Logger log = LoggerFactory.getLogger(PaymentmethodServiceImpl.class);
    @Autowired
    private DbTools dbTools;
    @Autowired
    private DictionarydataService dictionarydataService;
    @Autowired
    private PaymentmethodrefService paymentmethodrefService;
    @Autowired
    private ErppaymentmethodService erppaymentmethodService;
    @Autowired
    private PaymentmethodposrefService paymentmethodposrefService;

    public List<Paymentmethod> list(Wrapper<Paymentmethod> queryWrapper) {
        MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("paymentmethod"));
        return ((PaymentmethodMapper)this.getBaseMapper()).selectList(queryWrapper);
    }

    public JSONObject getPayTemplate(ServiceSession session, List<String> payCode, String erpCode) throws Exception {
        JSONObject result = new JSONObject();
        JSONObject getPm = new JSONObject();
        getPm.put("pmid", payCode);
        getPm.put("erpCode", (Object)erpCode);
        List pmArr = this.getPm(session, payCode, erpCode);
        if (null != pmArr) {
            result.put("paymentMethod", (Object)pmArr);
            result.put("total_results", (Object)pmArr.size());
            return result;
        }
        ArrayList<String> payTypeDictArr = new ArrayList<String>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"dictDataCode", payCode);
        queryWrapper.in((Object)"erpCode", Arrays.asList(erpCode, "-1"));
        List dictionarydataList = this.dictionarydataService.list((Wrapper)queryWrapper, "dictionarydata");
        if (ArrayUtils.isNotEmpty((List)dictionarydataList)) {
            for (int i = 0; i < dictionarydataList.size(); ++i) {
                Dictionarydata model = (Dictionarydata)dictionarydataList.get(i);
                payTypeDictArr.add(model.getDictDataCode());
            }
        } else {
            log.debug("\u67e5\u8be2\u4ed8\u6b3e\u5206\u7c7b\u5931\u8d25!");
        }
        JSONObject payTypeQuery = new JSONObject();
        payTypeQuery.put("payType", payTypeDictArr);
        payTypeQuery.put("erpCode", (Object)erpCode);
        payTypeQuery.put("posAbleFlag", (Object)0);
        List payTypeArr = this.getPm2(session, payTypeDictArr, erpCode);
        if (ArrayUtils.isNotEmpty((List)payTypeArr)) {
            pmArr.addAll(payTypeArr);
        }
        if (null != pmArr && !pmArr.isEmpty()) {
            JSONArray payCodeArr = new JSONArray();
            for (int i = 0; i < pmArr.size(); ++i) {
                Paymentmethod jsonObject = (Paymentmethod)pmArr.get(i);
                if (payCodeArr.contains((Object)jsonObject.getPayCode())) continue;
                payCodeArr.add((Object)jsonObject.getPayCode());
            }
            QueryWrapper query = new QueryWrapper();
            query.in((Object)"payCode", (Collection)payCodeArr);
            query.eq((Object)"erpCode", (Object)erpCode);
            List paymentmethodrefList = this.paymentmethodrefService.list((Wrapper)query, "paymentmethodref");
            if (ArrayUtils.isNotEmpty((List)paymentmethodrefList)) {
                int i;
                ArrayList<String> queryArr = new ArrayList<String>();
                for (i = 0; i < paymentmethodrefList.size(); ++i) {
                    Paymentmethodref jsonObject = (Paymentmethodref)paymentmethodrefList.get(i);
                    if (!StringUtils.isNotBlank((String)jsonObject.getPaymentModeId()) && !StringUtils.isNotBlank((String)jsonObject.getPlatformCode()) && !StringUtils.isNotBlank((String)jsonObject.getMerchantsCode())) continue;
                    if (!queryArr.contains(jsonObject.getPaymentModeId())) {
                        queryArr.add(jsonObject.getPaymentModeId());
                        continue;
                    }
                    if (!queryArr.contains(jsonObject.getPlatformCode())) {
                        queryArr.add(jsonObject.getPlatformCode());
                        continue;
                    }
                    if (queryArr.contains(jsonObject.getMerchantsCode())) continue;
                    queryArr.add(jsonObject.getMerchantsCode());
                }
                this.getErpPm(session, erpCode, paymentmethodrefList, queryArr);
                for (i = 0; i < pmArr.size(); ++i) {
                    Paymentmethod pmJson = (Paymentmethod)pmArr.get(i);
                    for (int k = 0; k < paymentmethodrefList.size(); ++k) {
                        Paymentmethodref jsonObject = (Paymentmethodref)paymentmethodrefList.get(k);
                        if (!pmJson.getPayCode().equals(jsonObject.getPayCode())) continue;
                        pmJson = (Paymentmethod)JSONObject.parseObject((String)JSONObject.toJSONString((Object)jsonObject), Paymentmethod.class);
                    }
                }
            }
        }
        result.put("paymentMethod", (Object)pmArr);
        result.put("total_results", (Object)pmArr.size());
        return result;
    }

    public List<Paymentmethodposref> getPosref(ServiceSession session, String erpCode) {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("erpCode", erpCode);
        List paymentmethodposrefList = this.paymentmethodposrefService.listByMap(query, "paymentmethodposref");
        return paymentmethodposrefList;
    }

    private List<Paymentmethod> getPm(ServiceSession session, List<String> payCode, String erpCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"payCode", payCode);
        queryWrapper.eq((Object)"erpCode", (Object)erpCode);
        queryWrapper.eq((Object)"posAbleFlag", (Object)"1");
        List list = this.list((Wrapper)queryWrapper, "paymentmethod");
        if (ArrayUtils.isEmpty((List)list)) {
            return null;
        }
        return list;
    }

    private List<Paymentmethod> getPm2(ServiceSession session, List<String> payCode, String erpCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"payType", payCode);
        queryWrapper.eq((Object)"erpCode", (Object)erpCode);
        queryWrapper.eq((Object)"posAbleFlag", (Object)0);
        List list = this.list((Wrapper)queryWrapper, "paymentmethod");
        if (ArrayUtils.isEmpty((List)list)) {
            return null;
        }
        return list;
    }

    public void getErpPm(ServiceSession session, String erpCode, List<Paymentmethodref> refArr, List<String> queryArr) throws Exception {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"erpCode", (Object)erpCode);
        queryWrapper.in((Object)"payCode", queryArr);
        queryWrapper.eq((Object)"status", (Object)1);
        List erppaymentmethodList = this.erppaymentmethodService.list((Wrapper)queryWrapper, "erppaymentmethod");
        if (ArrayUtils.isNotEmpty((List)erppaymentmethodList)) {
            for (int i = 0; i < refArr.size(); ++i) {
                Paymentmethodref jsonObject = refArr.get(i);
                for (int j = 0; j < erppaymentmethodList.size(); ++j) {
                    Erppaymentmethod erpJson = (Erppaymentmethod)erppaymentmethodList.get(j);
                    if (StringUtils.isNotBlank((String)jsonObject.getPaymentModeId()) && !jsonObject.getPaymentModeId().equals(erpJson.getPayCode())) continue;
                }
            }
        }
    }

    public JSONArray getPaymethod(ServiceSession session, List<Map<String, Object>> list, JSONObject paramsObject, String traceId) {
        if (list.size() == 0) {
            log.info("{traceId:" + traceId + "} --> \u5e93\u4e2d\u65e0\u6b64\u67e5\u8be2\u6761\u4ef6\u5bf9\u5e94\u7684\u4ed8\u6b3e\u6a21\u7248\uff1a" + paramsObject.toString());
            return null;
        }
        ArrayList<String> payCodeList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).containsKey("paycode") || null == list.get(i).get("paycode")) continue;
            payCodeList.add((String)list.get(i).get("paycode"));
        }
        if (ArrayUtils.isEmpty(payCodeList)) {
            return JSONArray.parseArray((String)JSONArray.toJSONString(list));
        }
        JSONObject paytemp = null;
        try {
            paytemp = this.getPayTemplate(null, payCodeList, paramsObject.getString("erpCode"));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("", (Throwable)e);
        }
        JSONArray array3 = new JSONArray();
        if (paytemp != null) {
            JSONObject result = paytemp;
            JSONArray array = result.getJSONArray("paymentMethod");
            for (Map<String, Object> map : list) {
                String paycode = (String)map.get("paycode");
                int folderFlag = (Integer)map.get("folderFlag");
                for (int k = 0; k < array.size(); ++k) {
                    JSONObject j2 = array.getJSONObject(k);
                    if (!j2.containsKey((Object)"overflowFlag")) {
                        j2.put("overflowFlag", (Object)"false");
                    }
                    if (!j2.containsKey((Object)"changeFlag")) {
                        j2.put("changeFlag", (Object)"false");
                    }
                    if (!j2.containsKey((Object)"recordFlag")) {
                        j2.put("recordFlag", (Object)"false");
                    }
                    if (!j2.containsKey((Object)"invoiceFlag")) {
                        j2.put("invoiceFlag", (Object)"false");
                    }
                    if (!j2.containsKey((Object)"leafFlag")) {
                        j2.put("leafFlag", (Object)"false");
                    }
                    if (!j2.containsKey((Object)"cardPayType")) {
                        j2.put("cardPayType", (Object)"null");
                    }
                    if (!j2.containsKey((Object)"returnPayFlag")) {
                        j2.put("returnPayFlag", (Object)"false");
                    }
                    String overflowFlag = j2.getString("overflowFlag");
                    String changeFlag = j2.getString("changeFlag");
                    String recordFlag = j2.getString("recordFlag");
                    String invoiceFlag = j2.getString("invoiceFlag");
                    String leafFlag = j2.getString("leafFlag");
                    String returnPayFlag = j2.getString("returnPayFlag");
                    if ("true".equals(overflowFlag) || "1".equals(overflowFlag)) {
                        overflowFlag = "Y";
                        j2.put("overflowFlag", (Object)overflowFlag);
                    }
                    if ("false".equals(overflowFlag) || "0".equals(overflowFlag)) {
                        overflowFlag = "N";
                        j2.put("overflowFlag", (Object)overflowFlag);
                    }
                    if ("true".equals(changeFlag) || "1".equals(changeFlag)) {
                        changeFlag = "Y";
                        j2.put("changeFlag", (Object)changeFlag);
                    }
                    if ("false".equals(changeFlag) || "0".equals(changeFlag)) {
                        changeFlag = "N";
                        j2.put("changeFlag", (Object)changeFlag);
                    }
                    if ("true".equals(recordFlag) || "1".equals(recordFlag)) {
                        recordFlag = "Y";
                        j2.put("recordFlag", (Object)recordFlag);
                    }
                    if ("false".equals(recordFlag) || "0".equals(recordFlag)) {
                        recordFlag = "N";
                        j2.put("recordFlag", (Object)recordFlag);
                    }
                    if ("true".equals(invoiceFlag) || "1".equals(invoiceFlag)) {
                        invoiceFlag = "Y";
                        j2.put("invoiceFlag", (Object)invoiceFlag);
                    }
                    if ("false".equals(invoiceFlag) || "0".equals(invoiceFlag)) {
                        invoiceFlag = "N";
                        j2.put("invoiceFlag", (Object)invoiceFlag);
                    }
                    if ("true".equals(leafFlag) || "1".equals(leafFlag)) {
                        leafFlag = "Y";
                        j2.put("leafFlag", (Object)leafFlag);
                    }
                    if ("false".equals(leafFlag) || "0".equals(leafFlag)) {
                        leafFlag = "N";
                        j2.put("leafFlag", (Object)leafFlag);
                    }
                    if ("true".equals(returnPayFlag) || "1".equals(returnPayFlag)) {
                        returnPayFlag = "Y";
                        j2.put("returnPayFlag", (Object)returnPayFlag);
                    }
                    if ("false".equals(returnPayFlag) || "0".equals(returnPayFlag)) {
                        returnPayFlag = "N";
                        j2.put("returnPayFlag", (Object)returnPayFlag);
                    }
                    String payCode = j2.getString("payCode");
                    if (null == paycode || !paycode.equals(payCode)) continue;
                    array3.add((Object)j2);
                    break;
                }
                if (null != paycode || 1 != folderFlag) continue;
                JSONObject j2_file = new JSONObject();
                j2_file.put("folderName", map.get("folderName"));
                j2_file.put("children", map.get("children"));
                array3.add((Object)j2_file);
            }
        }
        return array3;
    }
}

