/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.dao.SaleOrdersDetailModelService;
import com.efuture.business.dao.SaleOrdersDetailPopModelService;
import com.efuture.business.dao.SaleOrdersExtModelService;
import com.efuture.business.dao.SaleOrdersGainDetailModelService;
import com.efuture.business.dao.SaleOrdersGainModelService;
import com.efuture.business.dao.SaleOrdersMemberModelService;
import com.efuture.business.dao.SaleOrdersModelService;
import com.efuture.business.dao.SaleOrdersPayModelService;
import com.efuture.business.dao.SaleOrdersUploadInfoModelService;
import com.efuture.business.dao.SaleOrdersUseCouponModelService;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrderDetailModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrders;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrdersExtModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrdersMemberModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrdersModel;
import com.efuture.business.service.OrderPosCommonService;
import com.efuture.business.util.RedisUtil;
import com.product.model.ServiceSession;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class SaleOrderPosCommonServiceImpl
implements OrderPosCommonService {
    private static final Logger log = LoggerFactory.getLogger(SaleOrderPosCommonServiceImpl.class);
    private final String BILL_END_TIME = " 05:00:00";
    @Autowired
    private SaleOrdersModelService orderMapper;
    @Autowired
    private SaleOrdersMemberModelService ordersMember;
    @Autowired
    private SaleOrdersDetailModelService ordersDetailMapper;
    @Autowired
    private SaleOrdersDetailPopModelService ordersDetailPopMapper;
    @Autowired
    private SaleOrdersGainModelService ordersGainMapper;
    @Autowired
    private SaleOrdersGainDetailModelService ordersGainDetail;
    @Autowired
    private SaleOrdersUseCouponModelService ordersUseCouponMapper;
    @Autowired
    private SaleOrdersPayModelService ordersPayMapper;
    @Autowired
    private SaleOrdersExtModelService ordersExtMapper;
    @Autowired
    private SaleOrdersUploadInfoModelService ordersUploadInfoMapper;
    @Value(value="${localcache.enabled}")
    private Boolean localcache;
    @Value(value="${hazelcast.enabled:false}")
    private Boolean hazelcast;
    @Autowired
    private RedisUtil redisUtil;

    public LocalDate computeBillDate(LocalDateTime nowDate) {
        try {
            String billCloseDateDf = DateTimeFormatter.ofPattern("yyyy-MM-dd").format(nowDate) + " 05:00:00";
            LocalDateTime whenDate = LocalDateTime.parse(billCloseDateDf, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            String dateText = nowDate.isAfter(whenDate) || nowDate.isEqual(whenDate) ? nowDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) : nowDate.minusDays(1L).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            return LocalDate.parse(dateText, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        catch (Exception e) {
            log.error("\u8ba2\u5355\u4e2d\u5fc3\u8ba1\u7b97\u8bb0\u8d26\u65e5\u671f\u5931\u8d25: " + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public RespBase checkOriginGoodQty(ServiceSession session, List<SaleOrderDetailModel> ordersDetails, String originSheetNo) {
        try {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("orderNo", originSheetNo);
            SaleOrdersModel originOrder = (SaleOrdersModel)this.orderMapper.selectByMap(param, "orders").get(0);
            if (originOrder == null) {
                return Code.CODE_60028.getRespBase(new Object[]{"\u68c0\u67e5\u539f\u4ea4\u6613\u5546\u54c1\u6570\u91cf:\u539f\u4ea4\u6613\u4e0d\u5b58\u5728"});
            }
            param.clear();
            param.put("oid", originOrder.getOid());
            List originOrderDetails = this.ordersDetailMapper.selectByMap(param, "ordersdetail");
            if (originOrderDetails == null || originOrderDetails.size() == 0) {
                return Code.CODE_60028.getRespBase(new Object[]{"\u68c0\u67e5\u539f\u4ea4\u6613\u5546\u54c1\u6570\u91cf:\u539f\u4ea4\u6613\u5546\u54c1\u884c\u4e0d\u5b58\u5728"});
            }
            boolean isAllReturn = true;
            ArrayList<SaleOrderDetailModel> matchModels = new ArrayList<SaleOrderDetailModel>();
            for (SaleOrderDetailModel od : originOrderDetails) {
                for (SaleOrderDetailModel or : ordersDetails) {
                    if (!or.getItemCode().equals(od.getItemCode()) || !or.getOldRowNo().equals(od.getRowNo())) continue;
                    log.info("\u5141\u8bb8\u9000\u8d27\u6570\u91cf\uff1a" + od.getAllowReturnCopies());
                    log.info("\u5f53\u524d\u6570\u91cf\uff1a" + or.getQty());
                    double allow = ManipulatePrecision.sub((double)od.getAllowReturnCopies(), (double)or.getQty());
                    log.info("\u68c0\u67e5\u539f\u4ea4\u6613\u5546\u54c1\u6570\u91cf:\u68c0\u67e5\u53ef\u9000\u5546\u54c1\u6570\u91cf[" + od.getItemCode() + "]: " + allow);
                    if (allow < 0.0) {
                        return Code.CODE_60028.getRespBase(new Object[]{"\u5546\u54c1[" + od.getItemCode() + "]\u53ef\u9000\u6570\u91cf:" + allow});
                    }
                    if (allow > 0.0) {
                        isAllReturn = false;
                    }
                    od.setAllowReturnCopies(Double.valueOf(allow));
                    od.setLastDate(new Date());
                    matchModels.add(od);
                }
            }
            JSONObject result = new JSONObject();
            result.put("isAllReturn", (Object)isAllReturn);
            result.put("matchModels", matchModels);
            return new RespBase(Code.SUCCESS, (Object)result);
        }
        catch (Exception e) {
            log.error("\u68c0\u67e5\u539f\u4ea4\u6613\u5546\u54c1\u6570\u91cf,\u9519\u8bef: " + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            return Code.CODE_60028.getRespBase(new Object[]{"\u68c0\u67e5\u539f\u4ea4\u6613\u5546\u54c1\u6570\u91cf,\u9519\u8bef: " + e.getMessage()});
        }
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public RespBase saveOrderInfoForCloud(ServiceSession session, Map<String, Object> preSaveParamInfo, SaleOrdersModel order) throws Exception {
        SaleOrders saleOrders = (SaleOrders)JSONObject.parseObject((String)JSON.toJSONString(preSaveParamInfo), SaleOrders.class);
        JSONObject result = new JSONObject();
        try {
            int i;
            long t1 = System.currentTimeMillis();
            log.info("\u6279\u91cf\u4fdd\u5b58\u8ba2\u5355\u4fe1\u606f,start ...... ");
            if (null != saleOrders.getSaleOrders()) {
                log.info("Ready to insert SaleOrdersModel...");
                SaleOrdersModel OrdersModel2 = saleOrders.getSaleOrders();
                this.orderMapper.insert((Object)OrdersModel2, "orders");
                log.info("SaleOrdersModel insert success!");
            }
            if (null != saleOrders.getSaleOrdersExt()) {
                SaleOrdersExtModel ordersExt = saleOrders.getSaleOrdersExt();
                this.ordersExtMapper.insert((Object)ordersExt, "ordersext");
                log.info("SaleOrdersExtModel insert success!");
            }
            if (null != saleOrders.getSaleOrdersMember()) {
                SaleOrdersMemberModel ordersMembers = saleOrders.getSaleOrdersMember();
                this.ordersMember.insert((Object)ordersMembers, "ordersmember");
                log.info("SaleOrdersMemberModel insert success!");
            }
            if (null != saleOrders.getSaleOrderDetail() && saleOrders.getSaleOrderDetail().size() > 0) {
                List ordersDetailList = saleOrders.getSaleOrderDetail();
                for (i = 0; i < ordersDetailList.size(); ++i) {
                    this.ordersDetailMapper.insert(ordersDetailList.get(i), "ordersdetail");
                    log.info("OrdersDetailModel insert success!");
                }
            }
            if (null != saleOrders.getSaleOrderDetailPop() && saleOrders.getSaleOrderDetailPop().size() > 0) {
                List ordersDetailPopList = saleOrders.getSaleOrderDetailPop();
                for (i = 0; i < ordersDetailPopList.size(); ++i) {
                    this.ordersDetailPopMapper.insert(ordersDetailPopList.get(i), "ordersdetailpop");
                }
                log.info("SaleOrderDetailPopModel insert success!");
            }
            if (null != saleOrders.getSaleOrderUseCoupon() && saleOrders.getSaleOrderUseCoupon().size() > 0) {
                List ordersUseCouponList = saleOrders.getSaleOrderUseCoupon();
                for (i = 0; i < ordersUseCouponList.size(); ++i) {
                    this.ordersUseCouponMapper.insert(ordersUseCouponList.get(i), "ordersUseCoupon");
                }
                log.info("SaleOrderUseCouponModel insert success!");
            }
            if (null != saleOrders.getSaleOrderGainDetail() && saleOrders.getSaleOrderGainDetail().size() > 0) {
                List ordersGainDetailList = saleOrders.getSaleOrderGainDetail();
                for (i = 0; i < ordersGainDetailList.size(); ++i) {
                    this.ordersGainDetail.insert(ordersGainDetailList.get(i), "ordersgaindetail");
                }
                log.info("SaleOrderGainDetailModel insert success!");
            }
            if (null != saleOrders.getSaleOrderGain() && saleOrders.getSaleOrderGain().size() > 0) {
                List ordersGainList = saleOrders.getSaleOrderGain();
                for (i = 0; i < ordersGainList.size(); ++i) {
                    this.ordersGainMapper.insert(ordersGainList.get(i), "ordersgainmapper");
                }
                log.info("SaleOrderGainModel insert success!");
            }
            if (null != saleOrders.getSaleOrderPay() && saleOrders.getSaleOrderPay().size() > 0) {
                List ordersPayList = saleOrders.getSaleOrderPay();
                for (i = 0; i < ordersPayList.size(); ++i) {
                    this.ordersPayMapper.insert(ordersPayList.get(i), "orderspay");
                }
                log.info("SaleOrderPayModel insert success!");
            }
            long t2 = System.currentTimeMillis();
            log.info("\u6279\u91cf\u4fdd\u5b58\u8ba2\u5355\u4fe1\u606f,\u6279\u91cf\u4fdd\u5b58,\u8017\u65f6[ms]: " + (t2 - t1));
            long t3 = System.currentTimeMillis();
            if (preSaveParamInfo.containsKey("matchOriginDetail")) {
                List martchDetails = JSON.parseArray((String)JSON.toJSONString((Object)preSaveParamInfo.get("matchOriginDetail")), SaleOrderDetailModel.class);
                for (int i2 = 0; i2 < martchDetails.size(); ++i2) {
                    ((SaleOrderDetailModel)martchDetails.get(i2)).setShardingCode(null);
                    ((SaleOrderDetailModel)martchDetails.get(i2)).setShopCode(null);
                    this.ordersDetailMapper.updateById((SaleOrderDetailModel)martchDetails.get(i2), "ordersdetail");
                }
            }
            long t4 = System.currentTimeMillis();
            log.info("\u6279\u91cf\u4fdd\u5b58\u8ba2\u5355\u4fe1\u606f,\u66f4\u65b0\u539f\u4ea4\u6613\u5546\u54c1\u6570\u91cf,\u8017\u65f6[ms]: " + (t4 - t3));
            result.clear();
            result.put("oid", (Object)order.getOid());
            result.put("sheetNo", (Object)order.getOrderNo());
            result.put("terminalSno", (Object)order.getTerminalSno());
            result.put("isAllReturn", (Object)true);
            return new RespBase(Code.SUCCESS, (Object)result);
        }
        catch (DuplicateKeyException e1) {
            if (order == null) {
                throw new Exception("\u6279\u91cf\u4fdd\u5b58\u8ba2\u5355\u4fe1\u606f:\u8ba2\u5355\u4e3b\u4f53\u6570\u636e\u7a7a");
            }
            log.error(e1.getMessage(), (Throwable)e1);
            if (e1.getMessage().contains("idx_orders_searchByPos")) {
                log.info("\u6279\u91cf\u4fdd\u5b58\u8ba2\u5355\u4fe1\u606f-\u5c0f\u7968\u53f7\u5df2\u5b58\u5728,\u5f53\u524d\u5c0f\u7968\u53f7:" + order.getTerminalSno());
                return new RespBase(Code.CODE_60034, (Object)order.getTerminalSno(), null);
            }
            if (e1.getMessage().contains("idx_orders_sheetNo")) {
                log.info("\u6279\u91cf\u4fdd\u5b58\u8ba2\u5355\u4fe1\u606f-\u8ba2\u5355\u53f7\u5df2\u5b58\u5728,\u5f53\u524d\u8ba2\u5355\u53f7:" + order.getOrderNo());
                return new RespBase(10001, "idx_orders_sheetNo");
            }
            if (e1.getMessage().contains("idx_orders_posId")) {
                log.info("\u6279\u91cf\u4fdd\u5b58\u8ba2\u5355\u4fe1\u606f-POS\u552f\u4e00\u952e\u5df2\u5b58\u5728,\u5f53\u524d\u552f\u4e00\u952e:" + order.getPosId());
                return Code.CODE_60028.getRespBase(new Object[]{"posId is exist"});
            }
            this.deleteOrdersInfoForCloud(session, order.getOid().longValue());
            throw new Exception("\u6279\u91cf\u4fdd\u5b58\u8ba2\u5355\u4fe1\u606f-\u5176\u4ed6\u9519\u8bef:" + e1.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            if (e instanceof NullPointerException) {
                throw new Exception("\u6279\u91cf\u4fdd\u5b58\u8ba2\u5355\u4fe1\u606f:\u5fc5\u586b\u5b57\u6bb5\u7a7a," + e.getMessage());
            }
            this.deleteOrdersInfoForCloud(session, order.getOid().longValue());
            throw new Exception("\u6279\u91cf\u4fdd\u5b58\u8ba2\u5355\u4fe1\u606f:" + e.getMessage());
        }
    }

    public static String captureName(String name) {
        char[] cs = name.toCharArray();
        cs[0] = (char)(cs[0] - 32);
        return String.valueOf(cs);
    }

    public RespBase deleteOrdersInfoForCloud(ServiceSession session, long oid) {
        Criteria criteria = Criteria.where((String)"oid").is((Object)oid);
        Query query1 = Query.query((CriteriaDefinition)criteria);
        int i = 0;
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("oid", oid);
        i += this.orderMapper.deleteByMap(map, "orders");
        i += this.ordersExtMapper.deleteByMap(map, "ordersext");
        i += this.ordersMember.deleteByMap(map, "ordersmember");
        i += this.ordersDetailMapper.deleteByMap(map, "ordersdetail");
        i += this.ordersDetailPopMapper.deleteByMap(map, "ordersdetailpop");
        i += this.ordersGainMapper.deleteByMap(map, "ordersgainmapper");
        i += this.ordersGainDetail.deleteByMap(map, "ordersgaindetail");
        i += this.ordersPayMapper.deleteByMap(map, "orderspay");
        log.info("\u6279\u91cf\u4fdd\u5b58\u8ba2\u5355\u4fe1\u606f,\u8ba2\u5355\u51b2\u6b63,\u5f71\u54cd\u884c\u6570: " + (i += this.ordersUseCouponMapper.deleteByMap(map, "ordersUseCoupon")));
        return new RespBase(Code.SUCCESS);
    }
}

