/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl.wslf;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.dao.wslf.OrdersDetailModelService;
import com.efuture.business.dao.wslf.OrdersDetailPopModelService;
import com.efuture.business.dao.wslf.OrdersExtModelService;
import com.efuture.business.dao.wslf.OrdersGainDetailModelService;
import com.efuture.business.dao.wslf.OrdersGainModelService;
import com.efuture.business.dao.wslf.OrdersMemberModelService;
import com.efuture.business.dao.wslf.OrdersModelService;
import com.efuture.business.dao.wslf.OrdersPayModelService;
import com.efuture.business.dao.wslf.OrdersPrintLogInfoModelService;
import com.efuture.business.dao.wslf.OrdersUseCouponModelService;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.javaPos.struct.SyncTradeModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersDetailModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersExtModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersMemberModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersPayModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersPrintLogInfoModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrderDetailModel;
import com.efuture.business.service.OrderDataLocalService;
import com.efuture.business.service.OrderPosOuterService;
import com.efuture.business.util.DateHelpUtil;
import com.efuture.business.util.HttpClientUtils;
import com.efuture.business.util.db.MultipleDataSource;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.util.ParamValidateUtil;
import com.product.util.TypeUtils;
import com.product.util.UniqueID;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

public class OrderPosOuterServiceImpl
implements OrderPosOuterService {
    private static final Logger log = LoggerFactory.getLogger(OrderPosOuterServiceImpl.class);
    @Autowired
    private OrderDataLocalService orderDataLocalActionUtil;
    @Value(value="${localcache.enabled}")
    private Boolean localcache;
    @Value(value="${hazelcast.enabled:false}")
    private Boolean hazelcast;
    @Autowired
    private OrdersModelService orderMapper;
    @Autowired
    private OrdersMemberModelService ordersMemberMapper;
    @Autowired
    private OrdersDetailModelService ordersDetailMapper;
    @Autowired
    private OrdersDetailPopModelService ordersDetailPopMapper;
    @Autowired
    private OrdersGainModelService ordersGainMapper;
    @Autowired
    private OrdersGainDetailModelService ordersGainDetail;
    @Autowired
    private OrdersUseCouponModelService ordersUseCouponMapper;
    @Autowired
    private OrdersPayModelService ordersPayMapper;
    @Autowired
    private OrdersExtModelService ordersExtMapper;
    @Autowired
    private OrdersPrintLogInfoModelService ordersPrintLogInfoMapper;
    private static final String BILL_END_TIME = " 05:00:00";
    private static final String SALE_END_TIME = " 24:00:00";

    public ServiceResponse getLocalOrders(ServiceSession session, List<SyncTradeModel> tradeList) {
        log.info("\u672a\u4e0a\u4f20\u5c0f\u7968\u5217\u8868,\u5165\u53c2:" + JSONObject.toJSONString(tradeList));
        HashMap mapByBillDate = new HashMap();
        for (SyncTradeModel obj : tradeList) {
            List<String> sheetNoList;
            if (mapByBillDate.containsKey(obj.getBillDate())) {
                sheetNoList = (List)mapByBillDate.get(obj.getBillDate());
                sheetNoList.add(obj.getTradeNo());
                continue;
            }
            sheetNoList = new ArrayList<String>();
            sheetNoList.add(obj.getTradeNo());
            mapByBillDate.put(obj.getBillDate(), sheetNoList);
        }
        ArrayList ordersModels = new ArrayList();
        for (String billDate : mapByBillDate.keySet()) {
            List orders = this.orderMapper.selectByList((List)mapByBillDate.get(billDate), "orders");
            ordersModels.addAll(orders);
        }
        log.info("ordersModels==" + JSONObject.toJSONString(ordersModels));
        if (ordersModels.size() <= 0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u6570\u636e");
        }
        return ServiceResponse.buildSuccess(ordersModels);
    }

    public RespBase syncLocalData(ServiceSession session, JSONObject paramsObject) {
        ParamValidateUtil.paramCheck((ServiceSession)session, (JSONObject)paramsObject, (String[])new String[]{"syncOrder", "type", "billDate", "tradeNo"});
        log.info("\u540c\u6b65\u672c\u5730\u6570\u636e,\u5165\u53c2:" + JSONObject.toJSONString((Object)paramsObject));
        try {
            ArrayList succList = new ArrayList();
            ArrayList failList = new ArrayList();
            JSONArray syncArray = paramsObject.getJSONArray("syncOrder");
            if (syncArray.size() == 0) {
                return Code.CODE_60028.getRespBase(new Object[]{"\u540c\u6b65\u672c\u5730\u6570\u636e:\u5f85\u540c\u6b65\u6570\u636e\u7a7a"});
            }
            syncArray.sort(Comparator.comparing(obj -> ((JSONObject)obj).getDate("billDate")));
            JSONArray syncOrderArray = new JSONArray();
            JSONArray syncPrintLogArray = new JSONArray();
            for (Object obj2 : syncArray) {
                JSONObject param = (JSONObject)obj2;
                param.put("billDate", (Object)this.computeBillDateForSearch(param.getDate("billDate")));
                param.put("sheetNo", param.get((Object)"tradeNo"));
                param.remove((Object)"tradeNo");
                syncOrderArray.add((Object)param);
            }
            if (syncOrderArray.size() > 0) {
                RespBase sr = this.syncLocalOrder(session, syncOrderArray);
                if (Code.SUCCESS.getIndex() == sr.getRetflag()) {
                    JSONObject res = (JSONObject)sr.getData();
                    List succRevList = JSONObject.parseArray((String)res.getJSONArray("success").toJSONString(), String.class);
                    succList.addAll(succRevList);
                    List failRevList = JSONObject.parseArray((String)res.getJSONArray("fail").toJSONString(), String.class);
                    failList.addAll(failRevList);
                }
            }
            JSONObject result = new JSONObject();
            result.put("success", succList);
            result.put("fail", failList);
            return new RespBase(Code.SUCCESS, (Object)result);
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u672c\u5730\u6570\u636e,\u9519\u8bef:" + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            return Code.CODE_60028.getRespBase(new Object[]{e.getMessage()});
        }
    }

    public RespBase syncLocalOrder(ServiceSession session, JSONArray syncOrderArray) {
        ArrayList succList = new ArrayList();
        ArrayList failList = new ArrayList();
        JSONObject result = new JSONObject();
        result.put("success", succList);
        result.put("fail", failList);
        try {
            HashMap mapByBillDate = new HashMap();
            for (Object obj : syncOrderArray) {
                List<String> sheetNoList;
                JSONObject param = (JSONObject)obj;
                if (mapByBillDate.containsKey(param.getString("billDate"))) {
                    sheetNoList = (List)mapByBillDate.get(param.getString("billDate"));
                    sheetNoList.add(param.getString("sheetNo"));
                    continue;
                }
                sheetNoList = new ArrayList<String>();
                sheetNoList.add(param.getString("sheetNo"));
                mapByBillDate.put(param.getString("billDate"), sheetNoList);
            }
            for (String billDate : mapByBillDate.keySet()) {
                log.info("\u540c\u6b65\u8ba2\u5355[" + billDate + "],start...");
                long t1 = System.currentTimeMillis();
                JSONArray ordersArr = new JSONArray();
                try {
                    RespBase sr = this.orderDataLocalActionUtil.selectOrderAll(session, billDate, (List)mapByBillDate.get(billDate));
                    if (Code.SUCCESS.getIndex() != sr.getRetflag()) {
                        log.error("\u540c\u6b65\u8ba2\u5355[" + billDate + "],\u67e5\u8be2\u672c\u5730\u8ba2\u5355\u9519\u8bef:" + sr.getData());
                        failList.addAll((Collection)mapByBillDate.get(billDate));
                    } else {
                        ordersArr = (JSONArray)sr.getData();
                        if (ordersArr.size() == 0) {
                            log.error("\u540c\u6b65\u8ba2\u5355[" + billDate + "],\u67e5\u8be2\u672c\u5730\u8ba2\u5355\u8fd4\u56de\u7a7a");
                            return new RespBase(Code.SUCCESS, (Object)result);
                        }
                    }
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65\u8ba2\u5355[" + billDate + "],\u67e5\u8be2\u672c\u5730\u8ba2\u5355\u9519\u8bef:" + e.getMessage());
                    log.error(e.getMessage(), (Throwable)e);
                    failList.addAll((Collection)mapByBillDate.get(billDate));
                }
                log.info("ordersArr==>" + ordersArr.toJSONString());
                long t2 = System.currentTimeMillis();
                log.info("\u540c\u6b65\u8ba2\u5355[" + billDate + "],\u67e5\u8be2\u672c\u5730\u8ba2\u5355,\u8fd4\u56de\u6570\u91cf:" + ordersArr.size());
                log.info("\u540c\u6b65\u8ba2\u5355[" + billDate + "],\u67e5\u8be2\u672c\u5730\u8ba2\u5355,\u8017\u65f6[ms]:" + (t2 - t1));
                if (ordersArr.size() <= 0) continue;
                ServiceResponse sendSr = new ServiceResponse();
                int sc = 1;
                if (ordersArr.size() > 100) {
                    sc = ordersArr.size() / 100 + 1;
                }
                JSONObject sendObject = new JSONObject();
                ArrayList<String> sendSheetNos = new ArrayList<String>();
                for (int i = 1; i <= sc; ++i) {
                    int start = (i - 1) * 100;
                    int end = i * 100;
                    if (end > ordersArr.size()) {
                        end = ordersArr.size();
                    }
                    try {
                        long m1 = System.currentTimeMillis();
                        List sendOrderArr = ordersArr.subList(start, end);
                        String shopCode = "";
                        sendSheetNos.clear();
                        for (Object obj : sendOrderArr) {
                            JSONObject orderJson = (JSONObject)obj;
                            sendSheetNos.add(orderJson.getJSONObject("orders").getString("sheetNo"));
                            shopCode = orderJson.getJSONObject("orders").getString("busiTakeMarketCode");
                        }
                        sendObject.put("orders", (Object)sendOrderArr);
                        sendObject.put("shopCode", (Object)shopCode);
                        sendObject.put("command_id", (Object)"RECEIVEORDERSYNC");
                        log.info("\u540c\u6b65\u8ba2\u5355\u5165\u53c2sendObject\uff1a" + sendObject.toJSONString());
                        String resp = HttpClientUtils.postJson((String)GlobalInfo.cloudUrl, (String)sendObject.toJSONString());
                        log.info("sendSr==>" + JSONObject.toJSONString((Object)resp));
                        sendSr = null != resp && !"".equals(resp) ? (ServiceResponse)JSONObject.parseObject((String)resp, ServiceResponse.class) : ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u540c\u6b65\u8ba2\u5355\u5931\u8d25,\u7ebf\u4e0a\u540c\u6b65\u8ba2\u5355\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
                        log.info("\u53d1\u9001\u8ba2\u5355[" + billDate + "],\u987a\u5e8f[" + start + "-" + end + "],\u8017\u65f6[ms]:" + (System.currentTimeMillis() - m1));
                        log.info("\u53d1\u9001\u8ba2\u5355[" + billDate + "],\u987a\u5e8f[" + start + "-" + end + "],\u8fd4\u56de\u7ed3\u679c:" + JSON.toJSONString((Object)sendSr));
                        log.info("sendSr==>" + JSONObject.toJSONString((Object)sendSr));
                        if (sendSr.getReturncode().equals("0")) {
                            JSONObject res = (JSONObject)sendSr.getData();
                            List succRevList = JSONObject.parseArray((String)res.getJSONArray("success").toJSONString(), String.class);
                            succList.addAll(succRevList);
                            List failRevList = JSONObject.parseArray((String)res.getJSONArray("fail").toJSONString(), String.class);
                            failList.addAll(failRevList);
                            continue;
                        }
                        log.info("\u540c\u6b65\u8ba2\u5355[" + billDate + "],\u987a\u5e8f[" + start + "-" + end + "],\u8fd4\u56de\u9519\u8bef\u7ed3\u679c:" + sendSr.getData());
                        failList.addAll(sendSheetNos);
                        continue;
                    }
                    catch (Exception e) {
                        log.error("\u540c\u6b65\u8ba2\u5355[" + billDate + "],\u987a\u5e8f[" + start + "-" + end + "],\u53d1\u9001\u8ba2\u5355\u9519\u8bef:" + e.getMessage());
                        log.error(e.getMessage(), (Throwable)e);
                        failList.addAll(sendSheetNos);
                    }
                }
                long t3 = System.currentTimeMillis();
                log.info("\u540c\u6b65\u8ba2\u5355[" + billDate + "],\u53d1\u9001\u672c\u5730\u8ba2\u5355,\u8017\u65f6[ms]:" + (t3 - t2));
                log.info("\u540c\u6b65\u8ba2\u5355[" + billDate + "],end...");
            }
            result.put("success", succList);
            result.put("fail", failList);
            return new RespBase(Code.SUCCESS, (Object)result);
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u8ba2\u5355,\u9519\u8bef: " + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            return Code.CODE_60028.getRespBase(new Object[]{"\u540c\u6b65\u8ba2\u5355,\u9519\u8bef: " + e.getMessage()});
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public ServiceResponse checkOriginGoodQty(ServiceSession session, List<SaleOrderDetailModel> ordersDetails, String originSheetNo) {
        try {
            JSONObject param = new JSONObject();
            param.put("sheetNo", (Object)originSheetNo);
            Map params = (Map)JSONObject.parseObject((String)param.toJSONString(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            OrdersModel originOrder = (OrdersModel)this.orderMapper.selectByMap((Map)param, "orders").get(0);
            if (originOrder == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"10003", (String)"\u539f\u4ea4\u6613\u4e0d\u5b58\u5728");
            }
            param.clear();
            param.put("oid", (Object)originOrder.getOid());
            List originOrderDetails = this.ordersDetailMapper.selectByMap((Map)param, "ordersdetail");
            if (originOrderDetails.size() == 0) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"10003", (String)"\u539f\u4ea4\u6613\u5546\u54c1\u884c\u4e0d\u5b58\u5728");
            }
            boolean isAllReturn = true;
            ArrayList<OrdersDetailModel> matchModels = new ArrayList<OrdersDetailModel>();
            for (OrdersDetailModel od : originOrderDetails) {
                for (SaleOrderDetailModel or : ordersDetails) {
                    if (!or.getItemCode().equals(od.getGoodsCode()) || !or.getOldRowNo().equals(od.getRowNo())) continue;
                    double allow = od.getAllowReturnCopies() - (double)or.getCopies().intValue();
                    log.info("\u68c0\u67e5\u539f\u4ea4\u6613\u5546\u54c1\u6570\u91cf:\u68c0\u67e5\u53ef\u9000\u5546\u54c1\u6570\u91cf[" + od.getGoodsCode() + "]: " + allow);
                    if (allow < 0.0) {
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)("\u5546\u54c1[" + od.getGoodsCode() + "]\u53ef\u9000\u6570\u91cf:" + allow));
                    }
                    if (allow > 0.0) {
                        isAllReturn = false;
                    }
                    od.setAllowReturnCopies(Double.valueOf(allow));
                    od.setLastDate(new Date());
                    matchModels.add(od);
                }
            }
            JSONObject result = new JSONObject();
            result.put("isAllReturn", (Object)isAllReturn);
            result.put("matchModels", matchModels);
            return ServiceResponse.buildSuccess((Object)result);
        }
        catch (Exception e) {
            log.error("\u8ba2\u5355\u4e0a\u4f20,\u68c0\u67e5\u53ef\u9000\u5546\u54c1\u6570\u91cfERROR," + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)("\u8ba2\u5355\u4e0a\u4f20,\u68c0\u67e5\u53ef\u9000\u5546\u54c1\u6570\u91cfERROR," + e.getMessage()));
        }
    }

    public ServiceResponse checkSaleDataNull(ServiceSession session, JSONObject paramsObject) {
        ArrayList<String> checkCol = new ArrayList<String>();
        checkCol.add("entId");
        checkCol.add("channel");
        checkCol.add("channelSheetNo");
        checkCol.add("terminalNo");
        checkCol.add("terminalSno");
        checkCol.add("terminalOperator");
        checkCol.add("busiTakeMarketCode");
        checkCol.add("busiTakeMarket");
        checkCol.add("overageValue");
        checkCol.add("changeValue");
        checkCol.add("orderType");
        checkCol.add("logisticsMode");
        checkCol.add("oughtPay");
        checkCol.add("factPay");
        checkCol.add("saleDate");
        checkCol.add("corporationCode");
        checkCol.add("ordersDetail");
        checkCol.add("skuName");
        checkCol.add("rowNo");
        checkCol.add("goodsCode");
        checkCol.add("barCode");
        checkCol.add("goodsFlag");
        checkCol.add("goodType");
        checkCol.add("controlGood");
        checkCol.add("listPrice");
        checkCol.add("salePrice");
        checkCol.add("copies");
        checkCol.add("factor");
        checkCol.add("qty");
        checkCol.add("saleValue");
        checkCol.add("totalDiscountValue");
        checkCol.add("adjustDiscountValue");
        checkCol.add("customDiscountValue");
        checkCol.add("payDiscountValue");
        checkCol.add("popDiscountValue");
        checkCol.add("mealDiscountValue");
        checkCol.add("saleAmount");
        checkCol.add("weight");
        checkCol.add("ordersPay");
        checkCol.add("flag");
        checkCol.add("payType");
        checkCol.add("payCode");
        checkCol.add("payName");
        checkCol.add("rate");
        checkCol.add("amount");
        checkCol.add("money");
        checkCol.add("overage");
        checkCol.add("invoiceFlag");
        ServiceResponse check = ParamValidateUtil.checkParam((ServiceSession)session, (JSONObject)paramsObject, (String[])checkCol.toArray(new String[0]));
        if (!check.getReturncode().equals("0")) {
            return check;
        }
        return ServiceResponse.buildSuccess(null);
    }

    public Date computeBillDate() {
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
        try {
            String todayDate = DateHelpUtil.getTodayDate();
            String billCloseDate = todayDate + BILL_END_TIME;
            Date nowDate = new Date();
            Date whenDate = TypeUtils.castToDate((Object)billCloseDate);
            if (nowDate.after(whenDate)) {
                return nowDate;
            }
            if (nowDate.equals(whenDate)) {
                return nowDate;
            }
            return sdf1.parse(DateHelpUtil.getYestoryDate());
        }
        catch (Exception e) {
            log.error("\u672c\u5730\u8ba2\u5355\u4e2d\u5fc3\u8ba1\u7b97\u8bb0\u8d26\u65e5\u671f\u5931\u8d25: " + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Deprecated
    public Date computeBillDate1(Date nowDate) {
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
        try {
            String billCloseDate = sdf1.format(nowDate) + BILL_END_TIME;
            Date whenDate = TypeUtils.castToDate((Object)billCloseDate);
            if (nowDate.after(whenDate)) {
                return nowDate;
            }
            return sdf1.parse(DateHelpUtil.getYestoryDate((String)sdf1.format(nowDate)));
        }
        catch (Exception e) {
            log.error("\u4e91\u7aef\u8ba2\u5355\u4e2d\u5fc3\u8ba1\u7b97\u65f6\u95f4\u8282\u70b9\u5931\u8d25: " + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public LocalDateTime computeBillDate(LocalDateTime nowDate) {
        try {
            String billCloseDateDf = DateTimeFormatter.ofPattern("yyyy-MM-dd").format(nowDate) + BILL_END_TIME;
            LocalDateTime whenDate = LocalDateTime.parse(billCloseDateDf, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            if (nowDate.compareTo(whenDate) > 1) {
                return nowDate;
            }
            String dateText = nowDate.minusDays(1L).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            return LocalDateTime.parse(dateText + " 00:00:00", DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
        catch (Exception e) {
            log.error("\u4e91\u7aef\u8ba2\u5355\u4e2d\u5fc3\u8ba1\u7b97\u65f6\u95f4\u8282\u70b9\u5931\u8d25: " + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String computeBillDateForSearch(Date createDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            String searchDate;
            Date whenDate;
            if (createDate.after(new Date())) {
                createDate = new Date();
            }
            if (createDate.after(whenDate = TypeUtils.castToDate((Object)((searchDate = dateFormat.format(createDate)) + BILL_END_TIME)))) {
                return searchDate;
            }
            if (createDate.equals(whenDate)) {
                return searchDate;
            }
            return DateHelpUtil.getYestoryDate((String)searchDate);
        }
        catch (Exception e) {
            log.error("\u8ba2\u5355\u4e2d\u5fc3\u8ba1\u7b97\u8bb0\u8d26\u65e5\u671f\u5931\u8d25: " + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public RespBase searchOrders(ServiceSession session, JSONObject paramsObject) {
        ParamValidateUtil.paramCheck((ServiceSession)session, (JSONObject)paramsObject, (String[])new String[]{"busiTakeMarketCode", "createDate", "page_size", "page_no"});
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
        session.setShop_code(paramsObject.getString("busiTakeMarketCode"));
        try {
            String billDate = this.computeBillDateForSearch(paramsObject.getDate("createDate"));
            if (billDate == null) {
                return Code.CODE_60028.getRespBase(new Object[]{"\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u9519\u8bef: \u8bb0\u8d26\u65e5\u671f\u8ba1\u7b97\u5931\u8d25"});
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"busiTakeMarketCode", (Object)paramsObject.getString("busiTakeMarketCode"));
            queryWrapper.eq((Object)"terminalNo", (Object)paramsObject.getString("terminalNo"));
            if (this.localcache.booleanValue() || this.hazelcast.booleanValue()) {
                String s = this.formatBillDate(paramsObject.getDate("createDate"));
                if (StringUtils.isEmpty((Object)s)) {
                    return Code.CODE_60028.getRespBase(new Object[]{"\u8ba1\u7b97\u8ba2\u5355\u65e5\u671f\u5931\u8d25"});
                }
                log.info("\u8131\u673a\u67e5\u5bfb\u8ba2\u5355\u5217\u8868\u65e5\u671f:" + s);
                MultipleDataSource.setLocDataSourceKey((String)s);
            } else {
                queryWrapper.ge((Object)"createDate", (Object)paramsObject.getString("createDate"));
                queryWrapper.ge((Object)"saleDate", (Object)billDate);
                queryWrapper.le((Object)"saleDate", (Object)(billDate + SALE_END_TIME));
            }
            if (null != paramsObject.getString("shardingCode") && !"".equals(paramsObject.getString("shardingCode"))) {
                queryWrapper.eq((Object)"shardingCode", (Object)paramsObject.getString("shardingCode"));
            }
            if (null != paramsObject.getString("orderType") && !"".equals(paramsObject.getString("orderType"))) {
                queryWrapper.eq((Object)"orderType", (Object)paramsObject.getString("orderType"));
            }
            queryWrapper.orderByDesc((Object)"createDate");
            log.info("paramsObject==" + JSONObject.toJSONString((Object)paramsObject));
            List ordersModels = this.orderMapper.selectList((Wrapper)queryWrapper, "orders");
            log.info("ordersModels==" + JSONObject.toJSONString((Object)ordersModels));
            if (ordersModels.size() <= 0) {
                return Code.CODE_60028.getRespBase(new Object[]{"\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u6570\u636e"});
            }
            return new RespBase(Code.SUCCESS, (Object)ordersModels);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u9519\u8bef: " + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            return Code.CODE_60028.getRespBase(new Object[]{e.getMessage()});
        }
    }

    public RespBase searchOrdersDetail(ServiceSession session, JSONObject paramsObject) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
        ParamValidateUtil.paramCheck((ServiceSession)session, (JSONObject)paramsObject, (String[])new String[]{"searchType"});
        int searchType = paramsObject.getIntValue("searchType");
        if (searchType == 4 || searchType == 2 || searchType == 5) {
            ParamValidateUtil.paramCheck((ServiceSession)session, (JSONObject)paramsObject, (String[])new String[]{"busiTakeMarketCode", "terminalNo", "terminalSno"});
        } else if (searchType == 1 || searchType == 3) {
            ParamValidateUtil.paramCheck((ServiceSession)session, (JSONObject)paramsObject, (String[])new String[]{"busiTakeMarketCode", "terminalNo", "terminalSno", "createDate"});
        } else {
            return Code.CODE_60028.getRespBase(new Object[]{"\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5\u9519\u8bef:\u975e\u6cd5\u67e5\u8be2\u7c7b\u578b"});
        }
        session.setShop_code(paramsObject.getString("busiTakeMarketCode"));
        String billDate = "";
        try {
            JSONObject searchObj;
            if (searchType == 1 || searchType == 3) {
                billDate = searchType == 1 ? this.computeBillDateForSearch(new Date()) : this.computeBillDateForSearch(paramsObject.getDate("createDate"));
                if (billDate == null) {
                    return Code.CODE_60028.getRespBase(new Object[]{"\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5\u9519\u8bef: \u8bb0\u8d26\u65e5\u671f\u8ba1\u7b97\u5931\u8d25"});
                }
                searchObj = new JSONObject();
                searchObj.put(">=", (Object)(billDate + BILL_END_TIME));
                searchObj.put("<=", (Object)(billDate + SALE_END_TIME));
                paramsObject.put("saleDate", (Object)searchObj);
                log.info("saledate:" + searchObj.toJSONString());
            }
            if (paramsObject.containsKey((Object)"page_size")) {
                paramsObject.remove((Object)"page_size");
            }
            if (paramsObject.containsKey((Object)"page_no")) {
                paramsObject.remove((Object)"page_no");
            }
            log.info("localcache:" + this.localcache);
            if (!this.localcache.booleanValue()) {
                if (searchType == 1 || searchType == 3) {
                    searchObj = new JSONObject();
                    searchObj.put(">=", (Object)(billDate + BILL_END_TIME));
                    if (searchType == 3) {
                        String afterDate = DateHelpUtil.getAfterDay((String)dateFormat.format(paramsObject.getDate("createDate"))) + " ";
                        searchObj.put("<=", (Object)(afterDate + timeFormat.format(paramsObject.getDate("createDate"))));
                    }
                    paramsObject.put("createDate", (Object)searchObj);
                } else {
                    paramsObject.remove((Object)"createDate");
                }
                return this.searchOrdersDetailFromCloud(session, paramsObject);
            }
            if (searchType == 2 || searchType == 4) {
                return Code.CODE_60028.getRespBase(new Object[]{"\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5\u9519\u8bef: \u8131\u673a\u4e0d\u652f\u6301\u9000\u8d27"});
            }
            String s = this.formatBillDate(paramsObject.getDate("createDate"));
            if (StringUtils.isEmpty((Object)s)) {
                return Code.CODE_60028.getRespBase(new Object[]{"\u8ba1\u7b97\u8ba2\u5355\u65e5\u671f\u5931\u8d25"});
            }
            MultipleDataSource.setLocDataSourceKey((String)s);
            paramsObject.remove((Object)"createDate");
            paramsObject.remove((Object)"saleDate");
            log.info("\u8131\u673a\u67e5\u8be6\u60c5\u5165\u53c2\uff1a" + paramsObject.toJSONString());
            return this.searchOrdersDetailFromCloud(session, paramsObject);
        }
        catch (Exception e) {
            log.error("POS\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5\u9519\u8bef: " + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            return Code.CODE_60028.getRespBase(new Object[]{e.getMessage()});
        }
    }

    public RespBase searchOrdersDetailFromCloud(ServiceSession session, JSONObject paramsObject) {
        JSONObject finalResult = new JSONObject();
        JSONObject result = new JSONObject();
        try {
            log.info("POS\u4e91\u7aef\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5,start... ");
            long t1 = System.currentTimeMillis();
            int searchType = paramsObject.getIntValue("searchType");
            paramsObject.remove((Object)"searchType");
            if (searchType != 4) {
                result = this.searchOrdersDetailFromCloudCommon(session, paramsObject);
                if (result == null) {
                    return Code.CODE_60028.getRespBase(new Object[]{"POS\u4e91\u7aef\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5,\u8ba2\u5355\u4e0d\u5b58\u5728"});
                }
                finalResult.put("orderInfo", (Object)result);
            }
            log.info("POS\u4e91\u7aef\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5,\u8017\u65f6[ms]:" + (System.currentTimeMillis() - t1));
            log.info("POS\u4e91\u7aef\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5,end... ");
            return new RespBase(Code.SUCCESS, (Object)finalResult);
        }
        catch (Exception e) {
            log.error("POS\u4e91\u7aef\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5,\u9519\u8bef: " + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            return Code.CODE_60028.getRespBase(new Object[]{"POS\u4e91\u7aef\u67e5\u8be2\u8ba2\u5355,\u9519\u8bef: " + e.getMessage()});
        }
    }

    public JSONObject searchOrdersDetailFromCloudCommon(ServiceSession session, JSONObject paramsObject) {
        JSONObject result = new JSONObject();
        try {
            long t1 = System.currentTimeMillis();
            QueryWrapper orderWrapper = new QueryWrapper();
            List orderRowMapList = null;
            if (paramsObject.containsKey((Object)"createDate")) {
                for (String key : paramsObject.keySet()) {
                    JSONObject json;
                    if (null == paramsObject.get((Object)key)) continue;
                    if ("createDate".equals(key)) {
                        json = (JSONObject)paramsObject.get((Object)"createDate");
                        if (json.containsKey((Object)">=")) {
                            orderWrapper.ge((Object)"createDate", (Object)json.getString(">="));
                        }
                        if (!json.containsKey((Object)"<=")) continue;
                        orderWrapper.le((Object)"createDate", (Object)json.getString("<="));
                        continue;
                    }
                    if ("saleDate".equals(key)) {
                        json = (JSONObject)paramsObject.get((Object)"saleDate");
                        if (json.containsKey((Object)">=")) {
                            orderWrapper.ge((Object)"saleDate", (Object)json.getString(">="));
                        }
                        if (!json.containsKey((Object)"<=")) continue;
                        orderWrapper.le((Object)"saleDate", (Object)json.getString("<="));
                        continue;
                    }
                    orderWrapper.eq((Object)key, (Object)paramsObject.getString(key));
                }
                orderRowMapList = this.orderMapper.selectList((Wrapper)orderWrapper, "orders");
            } else {
                Map params = (Map)JSONObject.parseObject((String)paramsObject.toJSONString(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
                orderRowMapList = this.orderMapper.selectByMap(params, "orders");
            }
            if (orderRowMapList.size() == 0) {
                return null;
            }
            JSONArray orderArr = JSON.parseArray((String)JSON.toJSONString((Object)orderRowMapList));
            JSONObject orderJson = (JSONObject)orderArr.get(0);
            String shardingCode = orderJson.getString("shardingCode");
            QueryWrapper queryWrapper = new QueryWrapper();
            QueryWrapper ordersMembersWrapper = new QueryWrapper();
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (null != shardingCode && !"".equals(shardingCode)) {
                queryWrapper.eq((Object)"shardingCode", (Object)shardingCode);
                ordersMembersWrapper.eq((Object)"shardingCode", (Object)shardingCode);
                map.put("shardingCode", shardingCode);
            }
            queryWrapper.eq((Object)"oid", (Object)orderJson.getLong("oid"));
            OrdersExtModel ordersExts = (OrdersExtModel)this.ordersExtMapper.selectOne((Wrapper)queryWrapper, "ordersext");
            ordersMembersWrapper.eq((Object)"oid", (Object)orderJson.getLong("oid"));
            log.info("ordersMembersWrapper{}", (Object)JSONObject.toJSONString((Object)ordersMembersWrapper));
            OrdersMemberModel ordersMembers = (OrdersMemberModel)this.ordersMemberMapper.selectOne((Wrapper)ordersMembersWrapper, "ordersmember");
            log.info("ordersMembers{}", (Object)JSONObject.toJSONString((Object)ordersMembers));
            map.put("oid", orderJson.getLong("oid"));
            List ordersDetails = this.ordersDetailMapper.selectByMap(map, "ordersdetail");
            List ordersDetailPops = this.ordersDetailPopMapper.selectByMap(map, "ordersdetailpop");
            List ordersGains = this.ordersGainMapper.selectByMap(map, "ordersgain");
            List ordersGainDetails = this.ordersGainDetail.selectByMap(map, "ordersgaindetail");
            List ordersUseCoupons = this.ordersUseCouponMapper.selectByMap(map, "ordersusecoupon");
            List ordersPays = this.ordersPayMapper.selectByMap(map, "orderspay");
            long t2 = System.currentTimeMillis();
            log.info("POS\u4e91\u7aef\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5,\u8017\u65f6[ms]: " + (t2 - t1));
            if (orderJson.containsKey((Object)"saleDate")) {
                orderJson.put("saleDate", (Object)DateHelpUtil.getDateStringFromMillisecond((Long)orderJson.getLongValue("saleDate")));
            }
            if (orderJson.containsKey((Object)"payDate")) {
                orderJson.put("payDate", (Object)DateHelpUtil.getDateStringFromMillisecond((Long)orderJson.getLongValue("payDate")));
            }
            if (orderJson.containsKey((Object)"createDate")) {
                orderJson.put("createDate", (Object)DateHelpUtil.getDateStringFromMillisecond((Long)orderJson.getLongValue("createDate")));
            }
            if (orderJson.containsKey((Object)"receiveDate")) {
                orderJson.put("receiveDate", (Object)DateHelpUtil.getDateStringFromMillisecond((Long)orderJson.getLongValue("receiveDate")));
            }
            if (orderJson.containsKey((Object)"billDate")) {
                orderJson.put("billDate", (Object)DateHelpUtil.getDateString2FromMillisecond((Long)orderJson.getLongValue("billDate")));
            }
            result.put("orders", (Object)orderJson);
            result.put("ordersExt", (Object)ordersExts);
            result.put("ordersMember", (Object)ordersMembers);
            result.put("ordersDetail", (Object)ordersDetails);
            result.put("ordersPay", (Object)ordersPays);
            result.put("ordersDetailPop", (Object)ordersDetailPops);
            result.put("ordersGain", (Object)ordersGains);
            result.put("ordersGainDetail", (Object)ordersGainDetails);
            result.put("ordersUseCoupon", (Object)ordersUseCoupons);
            return result;
        }
        catch (Exception e) {
            log.error("POS\u4e91\u7aef\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5\u9519\u8bef: " + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void computeOriginInfoCommon(JSONObject originResult, List<OrdersPayModel> returnPayList, List<OrdersDetailModel> returnDetailList) {
        try {
            JSONObject orderJson = originResult.getJSONObject("orders");
            ArrayList<OrdersDetailModel> newOrdersDetails = new ArrayList<OrdersDetailModel>();
            List originOrdersDetails = (List)originResult.get((Object)"saleOrderDetail");
            BigDecimal totalMoney = new BigDecimal("0");
            for (OrdersDetailModel originOd : originOrdersDetails) {
                int originOdRetCopsCompZero = originOd.getAllowReturnCopies().compareTo(0.0);
                if (originOdRetCopsCompZero != -1 && originOdRetCopsCompZero != 1) continue;
                OrdersDetailModel newOd = new OrdersDetailModel();
                BeanUtils.copyProperties((Object)originOd, (Object)newOd);
                for (OrdersDetailModel returnOd : returnDetailList) {
                    if (!returnOd.getOldRowNo().equals(originOd.getRowNo()) || !returnOd.getGoodsCode().equals(originOd.getGoodsCode())) continue;
                    BigDecimal b1 = new BigDecimal(newOd.getQty().toString());
                    BigDecimal b2 = new BigDecimal(returnOd.getQty().toString());
                    newOd.setQty(new Double(b1.subtract(b2).doubleValue()));
                    newOd.setCopies(Integer.valueOf(newOd.getCopies() - returnOd.getCopies()));
                    newOd.setSaleAmount(newOd.getSaleAmount().subtract(returnOd.getSaleAmount()));
                    newOd.setCouponValue(newOd.getCouponValue().subtract(returnOd.getCouponValue()));
                    newOd.setPopDiscountValue(newOd.getPopDiscountValue().subtract(returnOd.getPopDiscountValue()));
                    newOd.setAdjustDiscountValue(newOd.getAdjustDiscountValue().subtract(returnOd.getAdjustDiscountValue()));
                    newOd.setCustomDiscountValue(newOd.getCustomDiscountValue().subtract(returnOd.getCustomDiscountValue()));
                    newOd.setPayDiscountValue(newOd.getPayDiscountValue().subtract(returnOd.getPayDiscountValue()));
                    newOd.setMealDiscountValue(newOd.getMealDiscountValue().subtract(returnOd.getMealDiscountValue()));
                    newOd.setTotalDiscountValue(newOd.getTotalDiscountValue().subtract(returnOd.getTotalDiscountValue()));
                }
                totalMoney = totalMoney.add(newOd.getSaleAmount());
                newOrdersDetails.add(newOd);
            }
            List originOrdersPays = (List)originResult.get((Object)"saleOrderPay");
            ArrayList<OrdersPayModel> changeOrderPays = new ArrayList<OrdersPayModel>();
            for (Object model : originOrdersPays) {
                if (!model.getFlag().equals(2)) continue;
                changeOrderPays.add((OrdersPayModel)model);
            }
            if (changeOrderPays.size() > 0) {
                boolean isExistChang = originOrdersPays.removeAll(changeOrderPays);
                log.info("\u539f\u4ea4\u6613\u662f\u5426\u627e\u96f6\u884c: " + isExistChang);
                for (OrdersPayModel payModel : originOrdersPays) {
                    for (OrdersPayModel changeModel : changeOrderPays) {
                        if (!changeModel.getPayCode().equals(payModel.getPayCode()) || !changeModel.getPayType().equals(payModel.getPayType())) continue;
                        payModel.setMoney(payModel.getMoney().subtract(changeModel.getMoney()));
                        payModel.setAmount(payModel.getAmount().subtract(changeModel.getAmount()));
                        payModel.setOverage(payModel.getOverage().subtract(changeModel.getOverage()));
                    }
                }
            }
            HashMap<String, OrdersPayModel> returnPayMap = new HashMap<String, OrdersPayModel>();
            for (OrdersPayModel model : returnPayList) {
                String returnKey = model.getFlag() + "-" + model.getPayCode() + "-" + model.getPayType();
                if (returnPayMap.containsKey(returnKey)) {
                    OrdersPayModel returnPayModel = (OrdersPayModel)returnPayMap.get(returnKey);
                    returnPayModel.setAmount(returnPayModel.getAmount().add(model.getAmount()));
                    returnPayModel.setMoney(returnPayModel.getMoney().add(model.getMoney()));
                    returnPayModel.setOverage(returnPayModel.getOverage().add(model.getOverage()));
                    continue;
                }
                returnPayMap.put(returnKey, model);
            }
            ArrayList<OrdersPayModel> newOrdersPays = new ArrayList<OrdersPayModel>();
            for (OrdersPayModel originOp : originOrdersPays) {
                OrdersPayModel newOp = new OrdersPayModel();
                BeanUtils.copyProperties((Object)originOp, (Object)newOp);
                String key = originOp.getFlag() + "-" + originOp.getPayCode() + "-" + originOp.getPayType();
                if (returnPayMap.containsKey(key)) {
                    OrdersPayModel returnOp = (OrdersPayModel)returnPayMap.get(key);
                    newOp.setMoney(newOp.getMoney().subtract(returnOp.getMoney()));
                    newOp.setAmount(newOp.getAmount().subtract(returnOp.getAmount()));
                    newOp.setOverage(newOp.getOverage().subtract(returnOp.getOverage()));
                    returnPayMap.remove(key);
                    key = "2-" + originOp.getPayCode() + "-" + originOp.getPayType();
                    if (returnPayMap.containsKey(key)) {
                        returnOp = (OrdersPayModel)returnPayMap.get(key);
                        newOp.setMoney(newOp.getMoney().add(returnOp.getMoney()));
                        newOp.setAmount(newOp.getAmount().add(returnOp.getAmount()));
                        returnPayMap.remove(key);
                    }
                }
                newOrdersPays.add(newOp);
            }
            if (returnPayMap.size() > 0) {
                for (OrdersPayModel model : returnPayMap.values()) {
                    model.setAmount(model.getAmount().multiply(new BigDecimal(-1)));
                    model.setMoney(model.getMoney().multiply(new BigDecimal(-1)));
                    model.setOverage(model.getOverage().multiply(new BigDecimal(-1)));
                    newOrdersPays.add(model);
                }
            }
            BigDecimal overageTotal = new BigDecimal(0);
            ArrayList<OrdersPayModel> finalOrdersPays = new ArrayList<OrdersPayModel>();
            for (OrdersPayModel model : newOrdersPays) {
                overageTotal = overageTotal.add(model.getOverage());
                if (model.getMoney().compareTo(BigDecimal.ZERO) == 0) continue;
                finalOrdersPays.add(model);
            }
            Collections.sort(newOrdersDetails, Comparator.comparing(OrdersDetailModel::getRowNo));
            int i = 1;
            for (OrdersDetailModel model : newOrdersDetails) {
                model.setRowNo(Integer.valueOf(i));
                ++i;
            }
            originResult.put("ordersDetail", newOrdersDetails);
            originResult.put("ordersPay", finalOrdersPays);
            orderJson.put("oughtPay", (Object)totalMoney);
            orderJson.put("overageValue", (Object)overageTotal);
            orderJson.put("changeValue", (Object)0.0);
        }
        catch (Exception e) {
            log.error("POS\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5[\u8ba1\u7b97\u65b0\u5c0f\u7968\u5546\u54c1\u884c\u652f\u4ed8\u884c]\u9519\u8bef: " + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public ServiceResponse postBackPrintLog(ServiceSession session, JSONObject paramsObject) {
        ServiceResponse sr = ParamValidateUtil.checkParam((ServiceSession)session, (JSONObject)paramsObject, (String[])new String[]{"marketCode", "terminalNo", "terminalOperator", "originMarketCode", "originTerminalNo", "originTerminalSno"});
        if (!sr.getReturncode().equals("0")) {
            return sr;
        }
        try {
            JSONObject param = new JSONObject();
            param.put("busiTakeMarketCode", (Object)paramsObject.getString("originMarketCode"));
            param.put("terminalNo", (Object)paramsObject.getString("originTerminalNo"));
            param.put("terminalSno", (Object)paramsObject.getString("originTerminalSno"));
            Map params = (Map)JSONObject.parseObject((String)param.toJSONString(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            OrdersModel order = (OrdersModel)this.orderMapper.selectByMap((Map)param, "orders").get(0);
            if (order == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
            }
            OrdersPrintLogInfoModel model = new OrdersPrintLogInfoModel();
            Long opgId = paramsObject.containsKey((Object)"opgId") && !StringUtils.isEmpty((Object)paramsObject.get((Object)"opgId")) ? paramsObject.getLong("opgId") : Long.valueOf(UniqueID.getUniqueID((boolean)true));
            model.setOpgId(opgId);
            model.setOid(order.getOid());
            model.setSheetNo(order.getSheetNo());
            model.setMarketCode(paramsObject.getString("marketCode"));
            model.setTerminalNo(paramsObject.getString("terminalNo"));
            model.setTerminalOperator(paramsObject.getString("terminalOperator"));
            model.setPrintCnt(Integer.valueOf(1));
            model.setPrintTime(new Date());
            this.ordersPrintLogInfoMapper.insert((Object)model, "ordersprintloginfo");
            return ServiceResponse.buildSuccess((Object)opgId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)e.getMessage());
        }
    }

    public int searchOrderPrint(ServiceSession session, long oid) {
        try {
            JSONObject param = new JSONObject();
            param.put("oid", (Object)oid);
            List models = this.ordersPrintLogInfoMapper.selectByMap((Map)param, "ordersprintloginfo");
            if (models != null) {
                return models.size();
            }
            return 0;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public ServiceResponse searchterminalSnoByPosId(ServiceSession session, JSONObject paramsObject) {
        ParamValidateUtil.paramCheck((ServiceSession)session, (JSONObject)paramsObject, (String[])new String[]{"busiTakeMarketCode", "posId"});
        session.setShop_code(paramsObject.getString("busiTakeMarketCode"));
        paramsObject.put("fields", (Object)"posId,terminalSno");
        try {
            long t = System.currentTimeMillis();
            Map params = (Map)JSONObject.parseObject((String)paramsObject.toJSONString(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            OrdersModel ordersModel = (OrdersModel)this.orderMapper.selectByMap(params, "orders").get(0);
            log.error("POS\u603b\u90e8\u67e5\u8be2\u8ba2\u5355\u5c0f\u7968\u53f7,\u8017\u65f6[ms]: " + (System.currentTimeMillis() - t));
            return ServiceResponse.buildSuccess((Object)ordersModel);
        }
        catch (Exception e) {
            log.error("POS\u603b\u90e8\u67e5\u8be2\u8ba2\u5355\u5c0f\u7968\u53f7,\u9519\u8bef: " + e.getMessage());
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)("POS\u603b\u90e8\u67e5\u8be2\u8ba2\u5355\u5c0f\u7968\u53f7,\u9519\u8bef: " + e.getMessage()));
        }
    }

    public String formatBillDate(Date createDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        try {
            return dateFormat.format(createDate);
        }
        catch (Exception e) {
            log.error("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38: " + e.getMessage());
            return null;
        }
    }
}

