/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.localize;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.CustomAsyncScheduler;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.bean.YPopStatusType;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.exception.EfutureException;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.ConsumersData;
import com.efuture.business.javaPos.struct.Coupon;
import com.efuture.business.javaPos.struct.CouponUse;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.OperUser;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.OrderForPos;
import com.efuture.business.javaPos.struct.OrderGains;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PopDetail;
import com.efuture.business.javaPos.struct.PrintInfo;
import com.efuture.business.javaPos.struct.SaleOrderStateEnum;
import com.efuture.business.javaPos.struct.SysPara;
import com.efuture.business.javaPos.struct.orderCentre.OrderStateEnum;
import com.efuture.business.javaPos.struct.orderCentre.OrdersDetailModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersDetailPopModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersGainDetailModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersModel4Pos;
import com.efuture.business.javaPos.struct.orderCentre.OrdersPayModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersUseCouponModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrders;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrders_WSLF;
import com.efuture.business.javaPos.struct.orderCentre.request.OrderQueryIn;
import com.efuture.business.javaPos.struct.orderCentre.request.PrintLogIn;
import com.efuture.business.javaPos.struct.orderCentre.response.OrdersDetailOut;
import com.efuture.business.javaPos.struct.orderCentre.response.OrdersQueryOut;
import com.efuture.business.javaPos.struct.orderCentre.response.SaveOrdersOut;
import com.efuture.business.javaPos.struct.orderCentre.response.SyncOutData;
import com.efuture.business.javaPos.struct.posManager.request.OperUserIn;
import com.efuture.business.javaPos.struct.posManager.response.OperUserOut;
import com.efuture.business.javaPos.struct.promotionCentre.request.CouponuseConsumeIn;
import com.efuture.business.javaPos.struct.request.GetOrderIn;
import com.efuture.business.javaPos.struct.request.GetOrdersIn;
import com.efuture.business.javaPos.struct.request.RecordPrintLogIn;
import com.efuture.business.javaPos.struct.request.SaleReturnQueryIn;
import com.efuture.business.javaPos.struct.response.PayConfirmOut;
import com.efuture.business.javaPos.struct.wslf.request.QuerySaleSeqnoReqDef;
import com.efuture.business.javaPos.struct.wslf.request.SaleComReqDef;
import com.efuture.business.javaPos.struct.wslf.request.SaleHeadReqDef;
import com.efuture.business.javaPos.struct.wslf.request.SalePayReqDef;
import com.efuture.business.javaPos.struct.wslf.response.QuerySaleSeqnoRevDef;
import com.efuture.business.javaPos.struct.wslf.response.SaleHeadRevDef;
import com.efuture.business.model.Syspara;
import com.efuture.business.service.DFRemoteService;
import com.efuture.business.service.InitializationRemoteService;
import com.efuture.business.service.YktRemoteService;
import com.efuture.business.service.impl.OrderSaleBSImpl;
import com.efuture.business.util.DateHelpUtil;
import com.efuture.business.util.HttpClientUtils;
import com.efuture.business.util.HttpUtils;
import com.efuture.business.util.OrderUtil;
import com.efuture.business.util.ParamsValidateUtil;
import com.efuture.business.util.PaymentUtil;
import com.efuture.business.util.SubmitUtil;
import com.efuture.business.util.TransformationUtils;
import com.efuture.business.util.WslfTools;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.util.TypeUtils;
import com.product.util.Utils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.DigestUtils;
import org.springframework.web.client.RestTemplate;

public class OrderSaleBSImpl_WSLF
extends OrderSaleBSImpl {
    private static final Logger log = LoggerFactory.getLogger(OrderSaleBSImpl_WSLF.class);
    private static String INSERTORDERALL = "order.online.save.execute";
    private static String ONQUERY = "order.pos.searchOrders";
    private static String GETORDERALL = "order.pos.searchOrdersDetail";
    private static String ORDERPRINTLOG = "order.pos.postBackPrintLog";
    private static String SYNC = "order.online.sync.execute";
    private static final String BILL_END_TIME = " 05:00:00";
    RestTemplate restTemplate;
    @Autowired
    WslfTools wslfTools;
    @Value(value="${globalinfo.signKey:000}")
    private String signKey;
    @SoaAnnotation(value="/apiYktRemoteService.do")
    public YktRemoteService yktRemoteService;
    @SoaAnnotation(value="/apiInitializeRemoteService.do")
    private InitializationRemoteService initRemoteService;
    @SoaAnnotation(value="/apiDFRemoteService.do")
    public DFRemoteService dfRemoteService;
    @SoaAnnotation(value="/apiInitializeRemoteService.do")
    private InitializationRemoteService initializationRemoteService;

    public CacheModel saveSaleOrder(CacheModel cacheModel, ServiceSession session, String splitCode, String netType) {
        log.info("saveSaleOrder");
        RespBase response = new RespBase();
        if (cacheModel.getOrder().getConsumersData() != null && cacheModel.getOrder().getConsumersData().getConsumersCard() != null && ("2".equals(cacheModel.getOrder().getConsumersData().getCustType()) || "GRP".equals(cacheModel.getOrder().getConsumersData().getConsumersType()))) {
            log.info("\u4f1a\u5458\u4ea4\u6613\u6570\u636e\u4e0a\u9001");
            this.giveOrReverse(session, cacheModel);
        }
        cacheModel.getOrder().setPayState(2);
        cacheModel.getOrder().setOrderState(7);
        SaleOrders order = SaleOrders.fromCacheModel((CacheModel)cacheModel);
        if (null != splitCode && !"".equals(splitCode)) {
            order.getSaleOrders().setShardingCode(splitCode);
        }
        CouponuseConsumeIn couponuseConsumeIn = new CouponuseConsumeIn();
        couponuseConsumeIn.setBillno(cacheModel.getOrder().getFlowNo());
        couponuseConsumeIn.setCalcBillId(cacheModel.getOrder().getSeqNo());
        couponuseConsumeIn.setType("0");
        couponuseConsumeIn.setSaveorder("N");
        couponuseConsumeIn.setChannel(cacheModel.getOrder().getChannel());
        if (SellType.ISEXERCISE((String)cacheModel.getOrder().getOrderType())) {
            order.getSaleOrders().setSheetTypeCode("1");
        }
        if (!this.localcache.booleanValue()) {
            TransformationUtils util = new TransformationUtils();
            SaleOrders_WSLF saleOrders = util.saleOrdersToSaleOrders_WSLF(order);
            HashMap<String, SaleOrders_WSLF> map = new HashMap<String, SaleOrders_WSLF>();
            map.put("data", saleOrders);
            ServiceResponse rs = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, INSERTORDERALL, session, JSON.toJSONString(map), SaveOrdersOut.class, "\u8ba2\u5355\u4e2d\u5fc3", "\u4fdd\u5b58\u8ba2\u5355");
            response.setRetflag(Integer.parseInt(rs.getReturncode()));
            response.setData(rs.getData());
        } else {
            response = this.orderPosUploadService.receiveOrderUpload(session, order, netType);
        }
        SaveOrdersOut saveOrdersOut = null;
        String sheetNo = "";
        if (!"0".equals(String.valueOf(response.getRetflag())) && !"1".equals(String.valueOf(response.getRetflag()))) {
            if ("101".equals(String.valueOf(response.getRetflag())) || "201".equals(String.valueOf(response.getRetflag()))) {
                saveOrdersOut = (SaveOrdersOut)JSON.parseObject((String)response.getData().toString(), SaveOrdersOut.class);
                String terminalSno = saveOrdersOut.getTerminalSno();
                log.info("\u5c0f\u7968\u53f7terminalSno\uff1a" + terminalSno);
                String serviceSno = "";
                ServiceResponse sNoResponse = new ServiceResponse();
                sNoResponse.setReturncode("2002");
                sNoResponse.setData((Object)cacheModel.getOrder().getTerminalSno());
                cacheModel.setErrMsg(cacheModel.getOrder().getTerminalSno());
                List couponPayments = this.posLogicServiceImpl.getCouponPayments(cacheModel.getPayments());
                if (couponPayments != null && couponPayments.size() != 0 && (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 2 || cacheModel.getPopMode() == 3)) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.reversePromotion(session, cacheModel, couponuseConsumeIn, netType);
                }
                if (StringUtils.isNotBlank((String)terminalSno)) {
                    serviceSno = terminalSno;
                    sNoResponse.setData((Object)serviceSno);
                    cacheModel.setErrMsg(serviceSno);
                }
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("2002");
                return cacheModel;
            }
            if (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 2 || cacheModel.getPopMode() == 3) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException terminalSno) {
                    // empty catch block
                }
                List couponPayments = this.posLogicServiceImpl.getCouponPayments(cacheModel.getPayments());
                if (couponPayments != null && couponPayments.size() != 0) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException serviceSno) {
                        // empty catch block
                    }
                    ServiceResponse res = this.reversePromotion(session, cacheModel, couponuseConsumeIn, netType);
                    cacheModel.setCalcResult(-1);
                    cacheModel.setErrCode(String.valueOf(Code.CODE_60025.getIndex()));
                    if ("0".equals(res.getReturncode())) {
                        cacheModel.setErrMsg("\u8ba2\u5355\u4fdd\u5b58\u5931\u8d25\uff0c\u8425\u9500\u5238\u51b2\u6b63\u6210\u529f");
                    } else {
                        cacheModel.setErrMsg("\u8ba2\u5355\u4fdd\u5b58\u5931\u8d25\uff0c\u8425\u9500\u5238\u51b2\u6b63\u5931\u8d25");
                    }
                    return cacheModel;
                }
            }
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("100000");
            cacheModel.setErrMsg("\u8ba2\u5355\u4e2d\u5fc3\u4fdd\u5b58\u5931\u8d25:" + response.getData());
            return cacheModel;
        }
        saveOrdersOut = (SaveOrdersOut)JSON.parseObject((String)JSONObject.toJSONString((Object)response.getData()), SaveOrdersOut.class);
        sheetNo = saveOrdersOut.getSheetNo();
        Order o = cacheModel.getOrder();
        if (this.excuteZuul(String.valueOf(response.getRetflag()), sheetNo, o.getOrderType(), o.getTerminalSno(), o.getExistPay())) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode(String.valueOf(response.getRetflag()));
            if (null == response.getData() || "".equals(response.getData().toString())) {
                cacheModel.setErrMsg(response.getData().toString());
            } else {
                cacheModel.setErrMsg(response.getData().toString());
            }
            return cacheModel;
        }
        cacheModel.getOrder().setSaveStatus(String.valueOf(response.getRetflag()));
        cacheModel.getOrder().setSendSuccess(true);
        cacheModel.getOrder().setIdSheetNo(sheetNo);
        return cacheModel;
    }

    protected CacheModel saveSaleReturnOrder(CacheModel cacheModel, ServiceSession session, String newTerminalSno, String splitCode, String netType) {
        ServiceResponse response = null;
        RespBase sp = new RespBase();
        if (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 2) {
            if (!"2".equals(cacheModel.getOrder().getOrderType())) {
                RespBase respBase;
                if (cacheModel.getPayConfirmStatus() != 0 && (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 2)) {
                    response = this.couponConsume(cacheModel, session, cacheModel.getPayConfirmStatus().intValue(), netType);
                    if (null == response.getData() || "".equals(response.getData().toString())) {
                        cacheModel.setCalcResult(-1);
                        cacheModel.setErrCode(response.getReturncode());
                        cacheModel.setErrMsg(response.getData().toString());
                        return cacheModel;
                    }
                    if (!"0".equals(response.getReturncode())) {
                        cacheModel.setCalcResult(-1);
                        cacheModel.setErrCode(response.getReturncode());
                        cacheModel.setErrMsg(response.getData().toString());
                        return cacheModel;
                    }
                }
                log.info("\u51b2\u6b63\u540e\u7684cacheResult{} ,errCode{} ,errmsg{} ,", new Object[]{cacheModel.getCalcResult(), cacheModel.getErrCode(), cacheModel.getErrMsg()});
                CouponuseConsumeIn couponuseConsumeIn = new CouponuseConsumeIn();
                couponuseConsumeIn.setBillno(cacheModel.getOrder().getFlowNo());
                couponuseConsumeIn.setChannel(cacheModel.getOrder().getChannel());
                couponuseConsumeIn.setCalcBillId(cacheModel.getOrder().getSeqNo());
                couponuseConsumeIn.setSaveorder("N");
                List couponPayments = this.posLogicServiceImpl.getCouponPayments(cacheModel.getPayments());
                if (couponPayments != null && couponPayments.size() != 0) {
                    couponuseConsumeIn.setSellPayments(Payment.transferSellPayment((List)couponPayments, (boolean)SellType.ISBACK((String)cacheModel.getOrder().getOrderType())));
                    couponuseConsumeIn.setType("0");
                    cacheModel.callMarketClear();
                    respBase = this.couponRemoteService.couponAndPointsConsume(session, cacheModel, couponuseConsumeIn, netType);
                    if (0 != respBase.getRetflag()) {
                        List reversePayments = couponuseConsumeIn.getSellPayments();
                        cacheModel.setReversePayments(reversePayments);
                        response = this.couponConsume(cacheModel, session, 5, netType);
                        cacheModel.setCalcResult(-1);
                        cacheModel.setErrCode(response.getReturncode());
                        if (null == response.getData() || "".equals(response.getData().toString())) {
                            cacheModel.setErrMsg(response.getData().toString());
                        } else {
                            cacheModel.setErrMsg(response.getData().toString());
                        }
                        return cacheModel;
                    }
                }
                log.info("\u6838\u9500\u540e\u7684cacheResult{} ,errCode{} ,errmsg{} ,", new Object[]{cacheModel.getCalcResult(), cacheModel.getErrCode(), cacheModel.getErrMsg()});
                if (!(!StringUtils.isNotBlank((String)cacheModel.getOrder().getOriginSeqNo()) || SellType.isGroupbuy((String)cacheModel.getOrder().getOrderType(), (boolean)cacheModel.getOrder().getHasGroupBuy()) || SellType.isDfSale((String)cacheModel.getOrder().getOrderType()) || cacheModel.getPopMode() != 1 && cacheModel.getPopMode() != 2 && cacheModel.getPopMode() != 3 || (cacheModel = (CacheModel)(respBase = this.calcPopRemoteService.calcCouponGain(session, cacheModel, netType, newTerminalSno)).getData()).getCalcResult() != -1)) {
                    return cacheModel;
                }
            } else {
                log.info("\u7ea2\u51b2\u5f00\u59cb");
                if ((cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 2) && (cacheModel = this.cancelOrder(session, cacheModel, netType, newTerminalSno)).getCalcResult() == -1) {
                    return cacheModel;
                }
            }
        }
        if (cacheModel.getOrder().getConsumersData() != null && cacheModel.getOrder().getConsumersData().getConsumersCard() != null && ("2".equals(cacheModel.getOrder().getConsumersData().getCustType()) || "GRP".equals(cacheModel.getOrder().getConsumersData().getConsumersType()))) {
            log.info("\u9000\u8d27\u4f1a\u5458\u4ea4\u6613\u6570\u636e\u4e0a\u9001");
            this.giveOrReverse(session, cacheModel);
        }
        String orgTerminalSno = cacheModel.getOrder().getTerminalSno();
        if (null != newTerminalSno && newTerminalSno.length() > 0) {
            cacheModel = this.posLogicServiceImpl.RefreshTerminalSno(cacheModel, newTerminalSno);
        }
        SaleOrders order = SaleOrders.fromCacheModel((CacheModel)cacheModel);
        if (null != splitCode && !"".equals(splitCode)) {
            order.getSaleOrders().setShardingCode(splitCode);
        }
        order.getSaleOrders().setOrderState(Integer.valueOf(OrderStateEnum.T_YWC.getCode()));
        if (!this.localcache.booleanValue()) {
            TransformationUtils util = new TransformationUtils();
            SaleOrders_WSLF saleOrders = util.saleOrdersToSaleOrders_WSLF(order);
            HashMap<String, SaleOrders_WSLF> map = new HashMap<String, SaleOrders_WSLF>();
            map.put("data", saleOrders);
            ServiceResponse rs = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, INSERTORDERALL, session, JSON.toJSONString(map), SaveOrdersOut.class, "\u8ba2\u5355\u4e2d\u5fc3", "\u4fdd\u5b58\u8ba2\u5355");
            sp.setRetflag(Integer.parseInt(rs.getReturncode()));
            sp.setData(rs.getData());
        } else {
            sp = this.orderPosUploadService.receiveOrderUpload(session, order, netType);
        }
        SaveOrdersOut saveOrdersOut = null;
        String sheetNo = "";
        if (!"0".equals(String.valueOf(sp.getRetflag())) && !"1".equals(String.valueOf(sp.getRetflag()))) {
            if ("101".equals(String.valueOf(sp.getRetflag())) || "201".equals(String.valueOf(sp.getRetflag()))) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("2002");
                cacheModel.setErrMsg(cacheModel.getOrder().getTerminalSno());
                try {
                    saveOrdersOut = (SaveOrdersOut)JSON.parseObject((String)sp.getData().toString(), SaveOrdersOut.class);
                    String terminalSno = saveOrdersOut.getTerminalSno();
                    String serviceSno = "";
                    ServiceResponse sNoResponse = new ServiceResponse();
                    if (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 2 || cacheModel.getPopMode() == 3) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.couponConsume(cacheModel, session, cacheModel.getPayConfirmStatus().intValue(), netType);
                    }
                    if (StringUtils.isNotBlank((String)terminalSno)) {
                        serviceSno = terminalSno;
                        sNoResponse.setReturncode("2002");
                        sNoResponse.setData((Object)serviceSno);
                        this.couponConsume(cacheModel, session, 8, netType);
                        cacheModel.setCalcResult(-1);
                        cacheModel.setErrCode("2002");
                        cacheModel.setErrMsg(serviceSno);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return cacheModel;
            }
            if (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 2 || cacheModel.getPopMode() == 3) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.couponConsume(cacheModel, session, cacheModel.getPayConfirmStatus().intValue(), netType);
            }
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("100000");
            cacheModel.setErrMsg("\u8ba2\u5355\u4e2d\u5fc3\u4fdd\u5b58\u5931\u8d25" + sp.getData().toString());
            return cacheModel;
        }
        saveOrdersOut = (SaveOrdersOut)JSON.parseObject((String)JSONObject.toJSONString((Object)sp.getData()), SaveOrdersOut.class);
        sheetNo = saveOrdersOut.getSheetNo();
        Order o = cacheModel.getOrder();
        if (this.excuteZuul(String.valueOf(sp.getRetflag()), sheetNo, o.getOrderType(), o.getTerminalSno(), o.getExistPay())) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode(String.valueOf(sp.getRetflag()));
            if (null == sp.getData() || "".equals(sp.getData().toString())) {
                cacheModel.setErrMsg(sp.getData().toString());
            } else {
                cacheModel.setErrMsg(sp.getData().toString());
            }
            return cacheModel;
        }
        cacheModel.getOrder().setSaveStatus(String.valueOf(sp.getRetflag()));
        cacheModel.getOrder().setSendSuccess(true);
        cacheModel.getOrder().setIdSheetNo(sheetNo);
        return cacheModel;
    }

    public RespBase getOrders(ServiceSession session, JSONObject paramsObject) {
        String orderType;
        String shardingCode;
        if (StringUtils.isBlank((String)paramsObject.getString("shopCode"))) {
            return Code.CODE_60001.getRespBase(new Object[]{"\u95e8\u5e97\u53f7"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("entId"))) {
            return Code.CODE_60001.getRespBase(new Object[]{"\u96f6\u552e\u5546id"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("pageNo"))) {
            return Code.CODE_60001.getRespBase(new Object[]{"\u8d77\u59cb\u9875"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("pageSize"))) {
            return Code.CODE_60001.getRespBase(new Object[]{"\u5206\u9875\u6bcf\u9875\u5927\u5c0f"});
        }
        GetOrdersIn getOrdersIn = (GetOrdersIn)JSON.parseObject((String)paramsObject.toJSONString(), GetOrdersIn.class);
        if (getOrdersIn == null) {
            return Code.CODE_60015.getRespBase(new Object[]{"\u5165\u53c2\u8f6c\u6362\u5931\u8d25"});
        }
        session.setEnt_id(getOrdersIn.getEntId());
        OrderQueryIn orderQueryIn = OrderQueryIn.transferGetOrdersInToOrderQueryIn((GetOrdersIn)getOrdersIn);
        if (paramsObject.containsKey((Object)"splitCode") && StringUtils.isNotBlank((String)(shardingCode = paramsObject.getString("splitCode")))) {
            orderQueryIn.setShardingCode(shardingCode);
        }
        if (paramsObject.containsKey((Object)"orderType") && StringUtils.isNotBlank((String)(orderType = paramsObject.getString("orderType")))) {
            orderQueryIn.setOrderType(orderType);
        }
        log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)orderQueryIn));
        RespBase response = this.orderPosOuterService.searchOrders(session, (JSONObject)JSONObject.toJSON((Object)orderQueryIn));
        log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u63a5\u53e3\u8fd4\u56de\uff1a{}", (Object)JSONObject.toJSONString((Object)response));
        if (Code.SUCCESS.getIndex() == response.getRetflag()) {
            OrdersQueryOut data = new OrdersQueryOut();
            List ordersList = (List)response.getData();
            data.setOrders(ordersList);
            data.setTotal_results(ordersList.size());
            return new RespBase(Code.SUCCESS, (Object)data.transferOrderToGetOrdersOut(getOrdersIn), "ORDERLISTCERTIFY");
        }
        return response;
    }

    public RespBase getOrder(ServiceSession session, GetOrderIn getOrderIn) {
        try {
            PayConfirmOut out;
            OrderQueryIn in = new OrderQueryIn();
            in.setBusiTakeMarketCode(getOrderIn.getShopCode());
            in.setTerminalNo(getOrderIn.getTerminalNo());
            in.setTerminalSno(getOrderIn.getTerminalSno());
            in.setCreateDate(getOrderIn.getBillDate());
            in.setSearchType(getOrderIn.getSearchType());
            if (StringUtils.isNotBlank((String)getOrderIn.getShardingCode())) {
                in.setShardingCode(getOrderIn.getShardingCode());
            }
            log.info("\u8ba2\u5355\u660e\u7ec6\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)in));
            RespBase resp = this.orderPosOuterService.searchOrdersDetail(session, (JSONObject)JSONObject.toJSON((Object)in));
            log.info("\u67e5\u8ba2\u5355\u8fd4\u56de\uff1a" + JSON.toJSONString((Object)resp.getData()));
            if (Code.SUCCESS.getIndex() != resp.getRetflag()) {
                if ("60003".equals(String.valueOf(resp.getRetflag()))) {
                    return Code.CODE_60021.getRespBase(new Object[]{resp.getData()});
                }
                if ("10001".equals(String.valueOf(resp.getRetflag()))) {
                    return Code.CODE_60021.getRespBase(new Object[]{resp.getData()});
                }
                log.info("\u83b7\u53d6\u8ba2\u5355\u5931\u8d25:" + resp.getData());
                return Code.CODE_60035.getRespBase(new Object[]{resp.getData()});
            }
            OrdersDetailOut getOrdersDetailOut = (OrdersDetailOut)JSONObject.toJavaObject((JSON)((JSONObject)JSONObject.toJSON((Object)resp.getData())), OrdersDetailOut.class);
            SaleOrders_WSLF saleOrder = new SaleOrders_WSLF();
            SaleOrders_WSLF oriOrder = null;
            saleOrder = getOrdersDetailOut.getOrderInfo();
            if (null == saleOrder.getOrders()) {
                return Code.CODE_60016.getRespBase(new Object[]{resp.getData()});
            }
            if (getOrderIn.isTailMoneyPay()) {
                if (SaleOrderStateEnum.YQX.getCode() == saleOrder.getOrders().getOrderState().intValue()) {
                    return Code.CODE_60016.getRespBase(new Object[]{"\u539f\u5355\u5df2\u53d6\u6d88"});
                }
                if (!saleOrder.getOrders().isDepositSale() && !saleOrder.getOrders().isTailMoneyPay()) {
                    return Code.CODE_60016.getRespBase(new Object[]{"\u539f\u5355\u975e\u9884\u5b9a\u9500\u552e"});
                }
                if (!saleOrder.getOrders().isTailMoneyPay()) {
                    return Code.CODE_60016.getRespBase(new Object[]{"\u539f\u5355\u672a\u4ed8\u6e05\u5c3e\u6b3e,\u8bf7\u5148\u8fdb\u884c\u5c3e\u6b3e\u652f\u4ed8"});
                }
                if (saleOrder.getOrders().getOrderState() == 7) {
                    return Code.CODE_60016.getRespBase(new Object[]{"\u539f\u5355\u5df2\u63d0\u8d27"});
                }
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("erpCode", (Object)getOrderIn.getErpCode());
            jsonObject.put("mkt", (Object)getOrderIn.getShopCode());
            jsonObject.put("code", (Object)"CWYH");
            RespBase res = this.initRemoteService.getSyspara(session, jsonObject);
            ArrayList<String> calcPriceType = new ArrayList<String>();
            if (null != res && Code.SUCCESS.getIndex() == res.getRetflag()) {
                List data = (List)res.getData();
                Syspara s = (Syspara)data.get(0);
                log.info("CWYH\u7cfb\u7edf\u53c2\u6570\uff1a" + s.getParavalue());
                if (StringUtils.isNotBlank((String)s.getParavalue())) {
                    String[] values;
                    for (String code : values = s.getParavalue().split(",")) {
                        calcPriceType.add(code);
                    }
                }
            } else {
                log.info("\u672a\u627e\u5230\u8be5\u7cfb\u7edf\u53c2\u6570");
            }
            if ("5".equals(saleOrder.getOrders().getOrderType())) {
                in = new OrderQueryIn();
                in.setBusiTakeMarketCode(getOrderIn.getShopCode());
                in.setOriginSheetNo(saleOrder.getOrders().getOriginSheetNo());
                in.setSearchType(getOrderIn.getSearchType());
                in.setTerminalNo(getOrderIn.getTerminalNo());
                in.setTerminalSno(getOrderIn.getTerminalSno());
                in.setCreateDate(getOrderIn.getBillDate());
                log.info("\u8ba2\u5355\u660e\u7ec6\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)in));
                resp = this.orderPosOuterService.searchOrdersDetail(session, (JSONObject)JSONObject.toJSON((Object)in));
                log.info("\u67e5\u8ba2\u5355\u8fd4\u56de\uff1a" + JSON.toJSONString((Object)resp.getData()));
                if (Code.SUCCESS.getIndex() != resp.getRetflag()) {
                    if ("60003".equals(String.valueOf(resp.getRetflag()))) {
                        return Code.CODE_60021.getRespBase(new Object[]{resp.getData()});
                    }
                    if ("10001".equals(String.valueOf(resp.getRetflag()))) {
                        return Code.CODE_60021.getRespBase(new Object[]{resp.getData()});
                    }
                    log.info("\u83b7\u53d6\u8ba2\u5355\u5931\u8d25:" + resp.getData());
                    return Code.CODE_60035.getRespBase(new Object[]{resp.getData()});
                }
                OrdersDetailOut oriOrdersDetailOut = (OrdersDetailOut)JSONObject.toJavaObject((JSON)((JSONObject)JSONObject.toJSON((Object)resp.getData())), OrdersDetailOut.class);
                oriOrder = oriOrdersDetailOut.getOrderInfo();
            }
            boolean isReprint = true;
            if ("0".equals(getOrderIn.getType())) {
                isReprint = false;
            }
            if ((out = this.toPayConfirmOut(session, saleOrder, oriOrder, calcPriceType, isReprint)).getOrder().getConsumersData() != null && out.getOrder().getTotalPoint() != 0.0 && !"1".equals(out.getOrder().getOrderType())) {
                double totalPoint = out.getOrder().getTotalPoint() + out.getOrder().getThisTimeUsedPoint() - Math.abs(out.getOrder().getThisTimePoint());
                out.getOrder().setTotalPoint(totalPoint);
            }
            log.info("PayConfirmOut\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)out));
            return new RespBase(Code.SUCCESS, (Object)out, "GETORDERMESSCERTIFY");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u8c03\u7528\u8ba2\u5355\u5f02\u5e38", (Throwable)e);
            return new RespBase(Code.CODE_60007.getIndex(), e.getMessage());
        }
    }

    public RespBase saleReturnQuery(ServiceSession session, ResqVo vo) {
        try {
            String shardingCode;
            JSONObject paramsObject = vo.getJsonObject();
            ParamsValidateUtil paramsValidateUtil = new ParamsValidateUtil(session, paramsObject);
            if (!paramsValidateUtil.validate()) {
                return paramsValidateUtil.getRespBase();
            }
            SaleReturnQueryIn saleReturnQueryIn = (SaleReturnQueryIn)JSON.parseObject((String)paramsObject.toJSONString(), SaleReturnQueryIn.class);
            String obj = this.redisUtil.get(RedisKey.CACHEID + saleReturnQueryIn.getShopCode() + saleReturnQueryIn.getTerminalNo());
            obj = this.reCacheMode(obj, paramsObject);
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
            CacheModel cacheModel = vo.getCacheModel();
            if (null == cacheModel) {
                return Code.CODE_60003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
            }
            Order order = cacheModel.getOrder();
            OrderQueryIn orderQueryIn = new OrderQueryIn();
            orderQueryIn.setTerminalNo(saleReturnQueryIn.getOldTerminalNo());
            orderQueryIn.setTerminalSno(saleReturnQueryIn.getOldTerminalSno());
            orderQueryIn.setBusiTakeMarketCode(saleReturnQueryIn.getOldShopCode());
            orderQueryIn.setCreateDate(saleReturnQueryIn.getBillDate());
            if ("2".equals(cacheModel.getOrder().getOrderType())) {
                orderQueryIn.setSearchType(1);
            } else {
                orderQueryIn.setSearchType(2);
            }
            if (StringUtils.isBlank((String)cacheModel.getOrder().getRefundAuthzCardNo())) {
                String cardnoString = saleReturnQueryIn.getTerminalOperator();
                if (StringUtils.isNotBlank((String)saleReturnQueryIn.getAccreditNo())) {
                    cardnoString = saleReturnQueryIn.getAccreditNo();
                }
                OperUserIn posManagerOperUserIn = new OperUserIn();
                posManagerOperUserIn.setCardno(cardnoString);
                posManagerOperUserIn.setMkt(saleReturnQueryIn.getShopCode());
                posManagerOperUserIn.setErpCode(cacheModel.getOrder().getErpCode());
                posManagerOperUserIn.setFlag("N");
                posManagerOperUserIn.setSyjh(saleReturnQueryIn.getTerminalNo());
                OperUser op1 = new OperUser();
                cacheModel.setCurGrant(op1);
                JSONObject response = null;
                try {
                    response = this.initializationRemoteService.empower(session, posManagerOperUserIn);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (null == response) {
                    return Code.CODE_100023.getRespBase(new Object[]{"\u6388\u6743\u4eba\u5458\u4fe1\u606f"});
                }
                OperUserOut posManagerOperUserOut = (OperUserOut)JSONObject.parseObject((String)response.toJSONString(), OperUserOut.class);
                if (!"Y".equals(posManagerOperUserOut.getPosrole().getPrivth()) && !"T".equals(posManagerOperUserOut.getPosrole().getPrivth())) {
                    return new RespBase(-1, "\u5f53\u524d\u6536\u94f6\u5458\u6216\u6388\u6743\u4eba\u5458\u6ca1\u6709\u9000\u8d27\u6743\u9650", vo.getCacheModel().getFlowNo());
                }
                OperUser operUser = new OperUser(posManagerOperUserOut);
                cacheModel.setCurGrant(operUser);
                order.setRefundAuthzCardNo(operUser.getGh());
            }
            if (paramsObject.containsKey((Object)"splitCode") && StringUtils.isNotBlank((String)(shardingCode = paramsObject.getString("splitCode")))) {
                orderQueryIn.setShardingCode(shardingCode);
            }
            log.info("\u8ba2\u5355\u4e2d\u5fc3\u63a5\u53e3\u8ba2\u5355\u67e5\u8be2:" + JSONObject.toJSON((Object)orderQueryIn));
            RespBase resp = this.orderPosOuterService.searchOrdersDetail(session, (JSONObject)JSONObject.toJSON((Object)orderQueryIn));
            if (Code.SUCCESS.getIndex() != resp.getRetflag()) {
                if ("60003".equals(String.valueOf(resp.getRetflag()))) {
                    return Code.CODE_60021.getRespBase(new Object[]{resp.getData()});
                }
                log.info("\u8bf7\u6c42\u8ba2\u5355\u4e2d\u5fc3\u83b7\u53d6\u8ba2\u5355\u5931\u8d25:" + resp.getData());
                if ("4".equals(order.getOrderType())) {
                    return Code.CODE_60010.getRespBase(new Object[0]);
                }
                if ("2".equals(order.getOrderType())) {
                    return Code.CODE_60033.getRespBase(new Object[0]);
                }
                return resp;
            }
            OrdersDetailOut getOrdersDetailOut = (OrdersDetailOut)JSONObject.toJavaObject((JSON)((JSONObject)JSONObject.toJSON((Object)resp.getData())), OrdersDetailOut.class);
            SaleOrders_WSLF orderQueryOut = getOrdersDetailOut.getOrderInfo();
            if (null == orderQueryOut) {
                return Code.CODE_60011.getRespBase(new Object[0]);
            }
            log.info("\u67e5\u8be2\u539f\u5355\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)orderQueryOut));
            String thrq = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"QHRQ");
            if (null != thrq && thrq.trim().length() > 0) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
                DateTimeFormatter formater2 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                LocalDate thDate = LocalDate.parse(thrq, formatter);
                LocalDate orderDate = LocalDate.parse(orderQueryOut.getOrders().getSaleDate().toString(), formater2);
                if (orderDate.isBefore(thDate)) {
                    return Code.CODE_60030.getRespBase(new Object[]{thDate});
                }
            }
            double allowReturnCopies = 0.0;
            for (OrdersDetailModel detail : orderQueryOut.getOrdersDetail()) {
                if ("0".equals(detail.getGoodsFlag())) continue;
                if ("2".equals(cacheModel.getOrder().getOrderType()) && ManipulatePrecision.doubleCompare((double)detail.getAllowReturnCopies(), (double)detail.getQty(), (int)4) != 0) {
                    return Code.CODE_60019.getRespBase(new Object[]{"" + detail.getRowNo()});
                }
                allowReturnCopies += detail.getAllowReturnCopies().doubleValue();
            }
            if (allowReturnCopies <= 0.0) {
                return Code.CODE_60020.getRespBase(new Object[0]);
            }
            boolean isHc = false;
            if ("2".equals(cacheModel.getOrder().getOrderType())) {
                isHc = true;
            }
            if ("2".equals(cacheModel.getOrder().getOrderType())) {
                if (!this.isAllowHC(orderQueryOut.getOrders())) {
                    return new RespBase(Code.CODE_60013.getIndex(), "\u8be5\u8ba2\u5355\u4e0d\u5141\u8bb8\u6d88\u5355", vo.getCacheModel().getFlowNo());
                }
                log.info("\u9884\u5b9a\u5355,\u5df2\u4ed8\u5c3e\u6b3e,\u5df2\u7b7e\u6536\u7684:" + orderQueryOut.getOrders().isDepositSale() + orderQueryOut.getOrders().isTailMoneyPay() + orderQueryOut.getOrders().getLogisticsState());
                if (orderQueryOut.getOrders().isDepositSale() && orderQueryOut.getOrders().isTailMoneyPay() && 6 == orderQueryOut.getOrders().getLogisticsState()) {
                    log.info("\u5c3e\u6b3e\u652f\u4ed8\u5b8c\u6210\u8ba2\u5355\u4e0d\u5141\u8bb8\u6d88\u5355");
                    return new RespBase(Code.CODE_60013.getIndex(), "\u5c3e\u6b3e\u652f\u4ed8\u5b8c\u6210\u8ba2\u5355\u4e0d\u5141\u8bb8\u6d88\u5355", vo.getCacheModel().getFlowNo());
                }
            } else if (!this.isAllowBack(orderQueryOut.getOrders())) {
                return new RespBase(Code.CODE_60013.getIndex(), "\u8be5\u8ba2\u5355\u4e0d\u5141\u8bb8\u9000\u8d27", vo.getCacheModel().getFlowNo());
            }
            if (!SellType.ISBACK((String)order.getOrderType())) {
                return new RespBase(Code.CODE_60013.getIndex(), "\u8bf7\u786e\u8ba4\u7aef\u7684\u64cd\u4f5c\u662f\u9000\u8d27\u8bf7\u6c42", vo.getCacheModel().getFlowNo());
            }
            String paraValue = SysPara.getSysParaInfo((List)cacheModel.getSysPara(), (String)"XDFS");
            ArrayList unDisOrderPayCodes = new ArrayList();
            String payString = "";
            if (null != paraValue) {
                payString = paraValue;
            }
            if (StringUtils.isNotEmpty((String)payString)) {
                Collections.addAll(unDisOrderPayCodes, payString.split(","));
            }
            if ("2".equals(cacheModel.getOrder().getOrderType())) {
                JSONObject object3;
                String paravalue1 = "1";
                JSONArray array = new JSONArray();
                List sysParaList = modeDetailsVo.getSyspara();
                JSONArray sysParaArray = JSONArray.parseArray((String)JSON.toJSONString((Object)sysParaList));
                if (sysParaArray.size() != 0) {
                    for (int i = 0; i < sysParaArray.size(); ++i) {
                        JSONObject sys = sysParaArray.getJSONObject(i);
                        if (!"XDFS".equals(sys.get((Object)"code"))) continue;
                        array.add((Object)sys);
                    }
                }
                if (array.size() != 0 && (object3 = array.getJSONObject(0)).containsKey((Object)"paravalue")) {
                    paravalue1 = object3.getString("paravalue");
                }
                String[] temp = paravalue1.split(",");
                List payModeList = orderQueryOut.getOrdersPay();
                if (temp.length > 0) {
                    for (int j = 0; j < temp.length; ++j) {
                        for (OrdersPayModel payModel : payModeList) {
                            if (!payModel.getPayCode().equals(temp[j])) continue;
                            return Code.CODE_60032.getRespBase(new Object[0]);
                        }
                    }
                }
            }
            String authCardNo = cacheModel.getOrder().getTerminalOperatorAuthzCardNo();
            String thAuthCardNo = cacheModel.getOrder().getRefundAuthzCardNo();
            cacheModel = this.TransferCacheModelForReturn(orderQueryOut, cacheModel, isHc);
            cacheModel = this.checkRedrush(cacheModel, saleReturnQueryIn.getAccreditNo(), modeDetailsVo);
            String message = this.checkPayment(cacheModel);
            if ("i".equals(cacheModel.getOrder().getOrderType())) {
                JSONObject dfquery = new JSONObject();
                dfquery.put("flowNo", (Object)cacheModel.getFlowNo());
                dfquery.put("consNo", (Object)((Goods)cacheModel.getReturnGoodsList().get(0)).getRemark());
                RespBase respBase = this.dfRemoteService.queryOweInfo(session, ResqVo.buildReqVo((CacheModel)cacheModel), dfquery);
                log.info("\u7535\u8d39\u5355\u7ea2\u51b2\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString((Object)respBase));
                if (null == respBase || Code.SUCCESS.getIndex() != respBase.getRetflag()) {
                    return Code.CODE_60007.getRespBase(new Object[]{"\u7535\u8d39\u4fe1\u606f\u67e5\u8be2\u5f02\u5e38"});
                }
                cacheModel = (CacheModel)respBase.getData();
            }
            LocalDateTime dateTime = LocalDateTime.now();
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String nowDateTime = dateTime.format(df).toString();
            cacheModel.getOrder().setSaleDate(nowDateTime);
            cacheModel.getOrder().setTerminalOperatorAuthzCardNo(authCardNo);
            cacheModel.getOrder().setRefundAuthzCardNo(thAuthCardNo);
            return new RespBase(Code.SUCCESS, message, (Object)cacheModel, "GETRETURNMESSCERTIFY");
        }
        catch (EfutureException e) {
            throw e;
        }
        catch (Exception e) {
            log.info("\u8c03\u7528\u8ba2\u5355\u5f02\u5e38", (Throwable)e);
            return Code.CODE_60007.getRespBase(new Object[]{e.getMessage()});
        }
    }

    protected CacheModel checkRedrush(CacheModel cacheModel, String accreditNo, ModeDetailsVo modeDetailsVo) {
        return cacheModel;
    }

    protected String checkPayment(CacheModel cacheModel) {
        return "";
    }

    public RespBase recordPrintLog(ServiceSession session, JSONObject paramsObject) {
        try {
            RecordPrintLogIn in = (RecordPrintLogIn)JSONObject.toJavaObject((JSON)paramsObject, RecordPrintLogIn.class);
            PrintLogIn appLogIn = new PrintLogIn();
            appLogIn.setMarketCode(in.getShopCode());
            appLogIn.setTerminalNo(in.getTerminalNo());
            appLogIn.setTerminalOperator(in.getTerminalOperator());
            appLogIn.setOriginMarketCode(in.getPShopCode());
            appLogIn.setOriginTerminalNo(in.getPTerminalNo());
            appLogIn.setOriginTerminalSno(in.getPTerminalSno());
            ServiceResponse resp = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, ORDERPRINTLOG, session, JSON.toJSONString((Object)appLogIn), String.class, "\u8ba2\u5355\u4e2d\u5fc3", "\u91cd\u5370\u8bb0\u5f55\u56de\u4f20");
            String opgId = "";
            if (!"0".equals(resp.getReturncode()) && !"1".equals(resp.getReturncode())) {
                return new RespBase(-1, "\u8bf7\u6c42\u8ba2\u5355\u4e2d\u5fc3\u8bb0\u5f55\u91cd\u5370\u65e5\u5fd7\u5931\u8d25");
            }
            opgId = resp.getData().toString();
            String back = "success";
            return new RespBase(Code.SUCCESS, back);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new RespBase(-1, "\u7edf\u8ba1\u6253\u5370\u6b21\u6570\u5931\u8d25" + Utils.getLastExceptionMessage((Exception)e));
        }
    }

    private PayConfirmOut toPayConfirmOut(ServiceSession session, SaleOrders_WSLF saleOrder, SaleOrders_WSLF oriOrder, List<String> calcPriceType, boolean isReprint) {
        PrintInfo printInfo;
        PayConfirmOut out = new PayConfirmOut();
        OrderForPos orderOut = OrderForPos.toOrderForPos((SaleOrders_WSLF)saleOrder);
        out.setRePrintCnt(saleOrder.getRePrintCnt());
        if (null != saleOrder.getOrders().getReturnReason()) {
            orderOut.setReason(saleOrder.getOrders().getReturnReason().toString());
        }
        log.info("orderOut\u9000\u8d27\u53c2\u6570\u8f6c\u6362\u5b8c\u6210");
        ArrayList<Payment> sellPayments = new ArrayList<Payment>();
        for (OrdersPayModel s : saleOrder.getOrdersPay()) {
            Payment p = new Payment();
            Payment.SaleOrderPayToPayment((OrdersPayModel)s, (Payment)p);
            log.info("payment\u8f6c\u6362\u5b8c\u62101");
            sellPayments.add(p);
        }
        orderOut.setSalePayments(sellPayments);
        log.info("payment\u8f6c\u6362\u5b8c\u6210");
        double noDiscountValueDzc = 0.0;
        ArrayList<Goods> goodsList = new ArrayList<Goods>();
        for (OrdersDetailModel s : saleOrder.getOrdersDetail()) {
            Goods goods = new Goods();
            Goods.SaleOrderDetailToGoods((Goods)goods, (OrdersDetailModel)s);
            goodsList.add(goods);
            if (!"Y".equals(goods.getEscaleFlag())) continue;
            noDiscountValueDzc = ManipulatePrecision.doubleConvert((double)(noDiscountValueDzc + goods.getNoDisAmountValue()), (int)2, (int)1);
        }
        orderOut.setRealTotalDiscountValueDzc(ManipulatePrecision.doubleConvert((double)(orderOut.getTotalDiscountValue() - noDiscountValueDzc)));
        orderOut.setRealSaleValueDzc(ManipulatePrecision.doubleConvert((double)(orderOut.getSaleValue() - noDiscountValueDzc)));
        log.info("goods\u8f6c\u6362\u5b8c\u6210");
        if (null != saleOrder.getOrdersDetailPop() && saleOrder.getOrdersDetailPop().size() > 0) {
            for (int i = 0; i < goodsList.size(); ++i) {
                Goods goods = (Goods)goodsList.get(i);
                for (OrdersDetailPopModel orderPop : saleOrder.getOrdersDetailPop()) {
                    if (goods.getFlowId() != orderPop.getRowNo().intValue()) continue;
                    goods.getPopDetailsInfo().add(PopDetail.transferPopDetail((OrdersDetailPopModel)orderPop));
                    if (!YPopStatusType.pop_policy_group_barcode_discB.equals(orderPop.getPopPolicyGroup())) continue;
                    goods.setBarcodeDiscount(orderPop.getDiscountAmount().doubleValue());
                }
            }
        }
        log.info("orderPop\u8f6c\u6362\u5b8c\u6210");
        if ("5".equals(saleOrder.getOrders().getOrderType()) && null != oriOrder) {
            ArrayList<Goods> origoodsList = new ArrayList<Goods>();
            for (OrdersDetailModel s : oriOrder.getOrdersDetail()) {
                Goods goods = new Goods();
                Goods.SaleOrderDetailToGoods((Goods)goods, (OrdersDetailModel)s);
                origoodsList.add(goods);
                if (!"Y".equals(goods.getEscaleFlag())) continue;
                noDiscountValueDzc = ManipulatePrecision.doubleConvert((double)(noDiscountValueDzc + goods.getNoDisAmountValue()), (int)2, (int)1);
            }
            ArrayList<Payment> oriPayments = new ArrayList<Payment>();
            for (int i = 0; i < oriOrder.getOrdersPay().size() - 1; ++i) {
                OrdersPayModel s = (OrdersPayModel)oriOrder.getOrdersPay().get(i);
                Payment p = new Payment();
                Payment.SaleOrderPayToPayment((OrdersPayModel)s, (Payment)p);
                oriPayments.add(p);
            }
            oriPayments.addAll(sellPayments);
            orderOut.setSalePayments(oriPayments);
            printInfo = PrintInfo.convertPrintInfo(origoodsList);
        } else {
            printInfo = PrintInfo.convertPrintInfo(goodsList);
        }
        log.info("printInfo\u8f6c\u6362\u5b8c\u6210");
        out.setPopInfo(new ArrayList());
        out.getPopInfo().addAll(printInfo.getMergedPopDetails());
        List goodListPops = Goods.transferGoodsToPosGoodsListForSave((List)printInfo.getGoodsListForPrint(), calcPriceType, (boolean)true);
        orderOut.getGoodsList().addAll(goodListPops);
        OrderGains orderGain = OrderGains.convertOrderGains((List)Coupon.transferCoupon4((List)saleOrder.getOrdersGain()), (boolean)isReprint);
        log.info("orderGain\u8f6c\u6362\u5b8c\u6210");
        if (null != orderGain) {
            out.setCouponGain(orderGain.getOrderCouponGains());
            out.setAchievePoints(orderGain.getPoints());
            out.setExperience(orderGain.getExperience());
        }
        out.setOrder(orderOut);
        if (!"5".equals(saleOrder.getOrders().getOrderType()) && null != oriOrder) {
            OrderForPos oriOrderOut = OrderForPos.toOrderForPos((SaleOrders_WSLF)oriOrder);
            ArrayList<Payment> oriPayments = new ArrayList<Payment>();
            for (Object s : oriOrder.getOrdersPay()) {
                Payment p = new Payment();
                Payment.SaleOrderPayToPayment((OrdersPayModel)s, (Payment)p);
                log.info("payment\u8f6c\u6362\u5b8c\u62101");
                oriPayments.add(p);
            }
            oriOrderOut.setSalePayments(oriPayments);
            log.info("payment\u8f6c\u6362\u5b8c\u6210");
            noDiscountValueDzc = 0.0;
            ArrayList<Goods> origoodsList = new ArrayList<Goods>();
            for (OrdersDetailModel s : oriOrder.getOrdersDetail()) {
                Goods goods = new Goods();
                Goods.SaleOrderDetailToGoods((Goods)goods, (OrdersDetailModel)s);
                origoodsList.add(goods);
                if (!"Y".equals(goods.getEscaleFlag())) continue;
                noDiscountValueDzc = ManipulatePrecision.doubleConvert((double)(noDiscountValueDzc + goods.getNoDisAmountValue()), (int)2, (int)1);
            }
            oriOrderOut.setRealTotalDiscountValueDzc(ManipulatePrecision.doubleConvert((double)(oriOrderOut.getTotalDiscountValue() - noDiscountValueDzc)));
            oriOrderOut.setRealSaleValueDzc(ManipulatePrecision.doubleConvert((double)(oriOrderOut.getSaleValue() - noDiscountValueDzc)));
            log.info("goods\u8f6c\u6362\u5b8c\u6210");
            PrintInfo oriPrintInfo = PrintInfo.convertPrintInfo(origoodsList);
            log.info("printInfo\u8f6c\u6362\u5b8c\u6210");
            out.setOriginPopInfo(new ArrayList());
            out.getOriginPopInfo().addAll(oriPrintInfo.getMergedPopDetails());
            List oriGoodListPops = Goods.transferGoodsToPosGoodsListForSave((List)oriPrintInfo.getGoodsListForPrint(), calcPriceType, (boolean)true);
            oriOrderOut.getGoodsList().addAll(oriGoodListPops);
            out.setOriginOrder(oriOrderOut);
        }
        return out;
    }

    public CacheModel TransferCacheModelForReturn(SaleOrders_WSLF orderQueryOut, CacheModel cacheModel, boolean isHc) {
        Double totalQty = 0.0;
        ArrayList<Goods> goodslist = new ArrayList<Goods>();
        for (OrdersDetailModel saleDetail : orderQueryOut.getOrdersDetail()) {
            if (!isHc && "0".equals(saleDetail.getGoodsFlag()) || !isHc && "97".equals(saleDetail.getGoodType())) continue;
            totalQty = saleDetail.getWeighGood() != false ? Double.valueOf(totalQty + 1.0) : Double.valueOf(totalQty + saleDetail.getQty());
            goodslist.add(Goods.transferGoods2((OrdersDetailModel)saleDetail));
        }
        cacheModel.getOrder().setQty(totalQty.intValue());
        cacheModel.setReturnPayments(PaymentUtil.transferPayment((List)orderQueryOut.getOrdersPay()));
        String orderType = "4";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date saleDate = orderQueryOut.getOrders().getSaleDate();
            String billDate = this.computeBillDate(new Date());
            Date nowDate = TypeUtils.castToDate((Object)(billDate + BILL_END_TIME));
            if (cacheModel.getOrder().getOrderType().equals("2")) {
                if (saleDate.before(nowDate)) {
                    orderType = "4";
                } else {
                    orderType = "2";
                    List payments = cacheModel.getReturnPayments();
                    boolean unDis = true;
                    if (null != cacheModel.getOrder().getSysPara().getNoVoidPaymentCodes() && !cacheModel.getOrder().getSysPara().getNoVoidPaymentCodes().isEmpty()) {
                        for (Payment payment : payments) {
                            if (cacheModel.getOrder().getSysPara().getNoVoidPaymentCodes().indexOf(payment.getPayCode()) == -1) continue;
                            unDis = false;
                            break;
                        }
                    }
                    if (!unDis) {
                        orderType = "4";
                    }
                }
            }
            if (orderQueryOut.getOrders().getOrderType().equals("Y1")) {
                orderType = "Y2";
            }
            if (orderQueryOut.getOrders().getOrderType().equals("h")) {
                orderType = "i";
            } else if ("4".equals(orderType) && "Z1".equals(orderQueryOut.getOrders().getOrderType())) {
                orderType = "Z2";
            }
            if (orderQueryOut.getOrders().getOrderType().equals("YS1")) {
                orderType = isHc ? "YS2" : "YS4";
                Date bookingBillDate = orderQueryOut.getOrders().getBillDate();
                if (bookingBillDate.after(saleDate)) {
                    cacheModel.getOrder().setRealBillDate(sdf2.format(bookingBillDate));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        cacheModel.setOrder(OrderUtil.transferRetrunOrder((SaleOrders_WSLF)orderQueryOut, (Order)cacheModel.getOrder(), (String)orderType));
        double gainPoints = 0.0;
        if ("2".equals(cacheModel.getOrder().getOrderType()) && orderQueryOut.getOrdersGainDetail() != null && !orderQueryOut.getOrdersGainDetail().isEmpty()) {
            List orderGainDetails = orderQueryOut.getOrdersGainDetail();
            for (int i = 0; i < orderGainDetails.size(); ++i) {
                OrdersGainDetailModel ordersGainDetailModel = (OrdersGainDetailModel)orderGainDetails.get(i);
                if ("01".equals(ordersGainDetailModel.getCouponGroup())) {
                    gainPoints = ManipulatePrecision.add((double)gainPoints, (double)ordersGainDetailModel.getAmount().doubleValue());
                }
                for (int j = 0; j < goodslist.size(); ++j) {
                    Goods goods = (Goods)goodslist.get(j);
                    if (goods.getFlowId() != ordersGainDetailModel.getRowNo().intValue()) continue;
                    if (goods.getCouponGains() == null) {
                        goods.setCouponGains(new ArrayList());
                    }
                    goods.getCouponGains().add(Goods.transferCouponGain((OrdersGainDetailModel)ordersGainDetailModel));
                }
            }
            if (null != orderQueryOut.getOrdersMember() && StringUtils.isNotBlank((String)orderQueryOut.getOrdersMember().getCid()) && null != orderQueryOut.getOrdersMember().getThisTimeGivePoint()) {
                cacheModel.getOrder().setThisTimePoint(-1.0 * orderQueryOut.getOrdersMember().getThisTimeGivePoint());
            }
        }
        if ("2".equals(orderType) && null != orderQueryOut.getOrdersDetailPop() && orderQueryOut.getOrdersDetailPop().size() > 0) {
            for (OrdersDetailPopModel orderPop : orderQueryOut.getOrdersDetailPop()) {
                int rowNo = orderPop.getRowNo() - 1;
                if (goodslist.size() < rowNo + 1) continue;
                ((Goods)goodslist.get(rowNo)).getPopDetailsInfo().add(PopDetail.transferPopDetail((OrdersDetailPopModel)orderPop));
            }
            for (int i = 0; i < goodslist.size(); ++i) {
                Goods goods = (Goods)goodslist.get(i);
                if (!"97".equals(goods.getGoodsType())) continue;
                goodslist.remove(i);
                --i;
            }
        }
        log.info("popdetail\u884c\u6570\uff1a" + ((Goods)goodslist.get(0)).getPopDetailsInfo().size());
        if (null != orderQueryOut.getOrdersUseCoupon() && orderQueryOut.getOrdersUseCoupon().size() > 0) {
            for (OrdersDetailPopModel orderPop : orderQueryOut.getOrdersUseCoupon()) {
                int rowNo = orderPop.getRowNo() - 1;
                if (goodslist.size() < rowNo + 1) continue;
                ((Goods)goodslist.get(rowNo)).getCouponUses().add(CouponUse.transferCouponUse3((OrdersUseCouponModel)orderPop, (Order)cacheModel.getOrder()));
            }
        }
        cacheModel.setReturnGoodsList(goodslist);
        return cacheModel;
    }

    public RespBase giveOrReverse(ServiceSession session, CacheModel cacheModel) {
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", cacheModel.getFlowNo());
        }
        Order order = cacheModel.getOrder();
        ConsumersData member = order.getConsumersData();
        if (member == null) {
            return new RespBase(Code.CODE_60, (Object)"\u6ca1\u6709\u767b\u5f55\u4f1a\u5458,\u4e0d\u80fd\u64cd\u4f5c", cacheModel.getFlowNo());
        }
        String tranId = "";
        String jthy = "";
        String jgdm = "";
        try {
            String obj = this.redisUtil.get(RedisKey.CACHEID + order.getShopCode() + order.getTerminalNo());
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
            jgdm = this.wslfTools.getJGDMCode(modeDetailsVo);
            log.info("JGDM{}", (Object)jgdm);
            if ("".equals(jgdm)) {
                return new RespBase(Code.CODE_60.getIndex(), "\u672a\u914d\u7f6e\u96c6\u56e2\u4f1a\u5458\u673a\u6784\u53f7\u53c2\u6570", cacheModel.getFlowNo());
            }
            jthy = this.wslfTools.getJTHYCode(modeDetailsVo);
            log.info("JTHY{}", (Object)jthy);
            if ("".equals(jthy)) {
                return new RespBase(Code.CODE_60.getIndex(), "\u672a\u914d\u7f6e\u96c6\u56e2\u4f1a\u5458IP\u7aef\u53e3\u53c2\u6570", cacheModel.getFlowNo());
            }
            GlobalInfo.setWslfvipIp((String)jthy.split(":")[0]);
            GlobalInfo.setWslfvipPort((int)Integer.valueOf(jthy.split(":")[1]));
            JSONObject queryTranId = new JSONObject();
            queryTranId.put("shopCode", (Object)jgdm);
            queryTranId.put("terminalNo", (Object)order.getTerminalNo());
            queryTranId.put("terminalOperator", (Object)order.getTerminalOperator());
            QuerySaleSeqnoReqDef querySaleSeqnoReqDef = new QuerySaleSeqnoReqDef(queryTranId);
            log.info("\u4f1a\u5458\u4e0a\u9001ID\u5165\u53c2{}", (Object)querySaleSeqnoReqDef.toString());
            QuerySaleSeqnoRevDef querySaleSeqnoRevDef = this.wslfTools.queryTranId(querySaleSeqnoReqDef);
            log.info("\u4f1a\u5458\u4e0a\u9001ID\u8fd4\u53c2{}", (Object)JSONObject.toJSONString((Object)querySaleSeqnoRevDef));
            if ("0".equals(querySaleSeqnoRevDef.getResult())) {
                tranId = querySaleSeqnoRevDef.getTranID();
                log.info("\u8bb0\u5f55\u4f1a\u5458\u6821\u9a8cID===>", (Object)tranId);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u96c6\u56e2\u4f1a\u5458\u4ea4\u6613ID\u5f02\u5e38" + e.fillInStackTrace());
            e.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            return new RespBase(Code.CODE_60, (Object)"\u83b7\u53d6\u96c6\u56e2\u4f1a\u5458\u4ea4\u6613ID\u5f02\u5e38", cacheModel.getFlowNo());
        }
        if ("".equals(tranId)) {
            return new RespBase(Code.CODE_60, (Object)"\u83b7\u53d6\u96c6\u56e2\u4f1a\u5458\u4ea4\u6613ID\u9519\u8bef", cacheModel.getFlowNo());
        }
        try {
            SaleHeadReqDef saleHeadReqDef = new SaleHeadReqDef(cacheModel, jgdm);
            saleHeadReqDef.setTranID(tranId);
            StringBuffer sb = new StringBuffer();
            sb.append(saleHeadReqDef.toString());
            if (cacheModel.getGoodsList().size() > 0) {
                for (Goods goods : cacheModel.getGoodsList()) {
                    SaleComReqDef saleComReqDef = new SaleComReqDef(goods);
                    sb.append(saleComReqDef.toString());
                }
            }
            if (cacheModel.getPayments().size() > 0) {
                for (Payment payment : cacheModel.getPayments()) {
                    SalePayReqDef salePayReqDef = new SalePayReqDef(payment);
                    sb.append(salePayReqDef.toString());
                }
            }
            log.info("\u4f1a\u5458\u9500\u552e\u6570\u636e\u5165\u53c2{}", (Object)sb.toString());
            SaleHeadRevDef saleHeadRevDef = this.wslfTools.giveOrReverse(sb.toString());
            log.info("\u4f1a\u5458\u9500\u552e\u6570\u636e\u8fd4\u53c2{}", (Object)JSONObject.toJSONString((Object)saleHeadRevDef));
            if ("0".equals(saleHeadRevDef.getResult())) {
                order.setThisTimePoint(Double.valueOf(saleHeadRevDef.getCurPoint()).doubleValue());
                order.setTotalPoint(Double.valueOf(saleHeadRevDef.getResPoint()).doubleValue());
                if (StringUtils.isNotBlank((String)cacheModel.getOrder().getOriginTerminalSno())) {
                    order.setTotalPoint(ManipulatePrecision.doubleConvert((double)(Double.valueOf(saleHeadRevDef.getResPoint()) - Double.valueOf(saleHeadRevDef.getCurPoint()))));
                } else {
                    order.setTotalPoint(Double.valueOf(saleHeadRevDef.getResPoint()).doubleValue());
                }
            }
        }
        catch (Exception e) {
            log.info("\u4f1a\u5458\u4e0a\u4f20\u9500\u552e\u6570\u636e\u5f02\u5e38:" + e.getMessage());
            e.printStackTrace();
            return new RespBase(Code.CODE_60, (Object)"\u4f1a\u5458\u4e0a\u4f20\u9500\u552e\u6570\u636e\u5f02\u5e38", cacheModel.getFlowNo());
        }
        log.info("\u4f1a\u5458\u9500\u552e\u6570\u636e{}\u4e0a\u4f20\u5b8c\u6bd5", (Object)cacheModel.getFlowNo());
        BaseOutModel out = new BaseOutModel();
        out.setOrder(OrderForPos.toOrderForPos((CacheModel)cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        log.info("\u51fa\u53c2\u8f93\u51fa" + JSON.toJSON((Object)new RespBase(Code.SUCCESS, (Object)resqVo, "WSLFVIP")));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "WSLFVIP");
    }

    public RespBase sendVicRecharge(ServiceSession session, CacheModel cacheModel) {
        Order order = cacheModel.getOrder();
        JSONObject ob = new JSONObject();
        ob.put("codeType", (Object)"3");
        ob.put("shopCode", (Object)order.getShopCode());
        ob.put("terminalNo", (Object)order.getTerminalNo());
        ob.put("terminalOperator", (Object)order.getTerminalOperator());
        ob.put("flowNo", (Object)cacheModel.getFlowNo());
        ob.put("erpCode", (Object)order.getErpCode());
        ob.put("codeValue", (Object)cacheModel.getCodeValue());
        ob.put("terminalSno", (Object)order.getTerminalSno());
        ob.put("payCode", (Object)"");
        ob.put("password", (Object)"");
        ob.put("tradeAmt", (Object)cacheModel.getCodeAmount());
        return this.yktRemoteService.sendVicRecharge(session, ResqVo.buildReqVo((CacheModel)cacheModel), ob);
    }

    public RespBase receiveOrderSync(ServiceSession session, JSONObject paramsObject) {
        log.info("\u540c\u6b65\u8ba2\u5355\u5165\u53c2\uff1a" + paramsObject.toJSONString());
        try {
            JSONArray orderArray = paramsObject.getJSONArray("orders");
            List succList = new ArrayList();
            List failList = new ArrayList();
            String splitcode = "posshop:log:" + paramsObject.get((Object)"shopCode");
            String splitodevalue = "";
            log.info("redis\u5206\u5e93\u7801key\u503c\uff1a" + splitcode);
            if (this.redisUtil.hasKey(splitcode)) {
                splitodevalue = (String)this.redisUtil.hget(splitcode, "splitCode");
                log.info("shardingcode Value : " + splitodevalue);
                if (null == splitodevalue) {
                    splitodevalue = "";
                }
            }
            if (!this.localcache.booleanValue()) {
                HashMap<String, JSONArray> map = new HashMap<String, JSONArray>();
                map.put("data", orderArray);
                HttpUtils httpUtils = new HttpUtils();
                ServiceResponse resp = httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, SYNC, session, JSON.toJSONString(map), SyncOutData.class, "\u8ba2\u5355\u4e2d\u5fc3", "\u540c\u6b65\u8ba2\u5355");
                if ("0".equals(resp.getReturncode())) {
                    SyncOutData res = (SyncOutData)resp.getData();
                    succList = res.getSuccess();
                    failList = res.getFail();
                } else {
                    return Code.CODE_60036.getRespBase(new Object[0]);
                }
            }
            JSONObject result = new JSONObject();
            result.put("success", succList);
            result.put("fail", failList);
            return new RespBase(Code.SUCCESS, (Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new RespBase(-1, e.getMessage());
        }
    }

    public String computeBillDate(Date createDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            String searchDate = dateFormat.format(createDate);
            Date whenDate = TypeUtils.castToDate((Object)(searchDate + BILL_END_TIME));
            if (createDate.after(whenDate)) {
                return searchDate;
            }
            if (createDate.equals(whenDate)) {
                return searchDate;
            }
            return DateHelpUtil.getYestoryDate((String)searchDate);
        }
        catch (Exception e) {
            log.error("\u8ba2\u5355\u4e2d\u5fc3\u8ba1\u7b97\u8bb0\u8d26\u65e5\u671f\u5931\u8d25: " + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public RespBase payConfirm(ServiceSession session, ResqVo vo) {
        RespBase respBase = super.payConfirm(session, vo);
        CacheModel cacheModel = vo.getCacheModel();
        String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getSyjmain().getMkt() + cacheModel.getSyjmain().getSyjh());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        List sysParaList = modeDetailsVo.getSyspara();
        JSONArray sysParaArray = JSONArray.parseArray((String)JSON.toJSONString((Object)sysParaList));
        String isSendZex = "N";
        if (sysParaArray.size() != 0) {
            for (int i = 0; i < sysParaArray.size(); ++i) {
                JSONObject sys = sysParaArray.getJSONObject(i);
                if (!"ISZEX".equals(sys.get((Object)"code"))) continue;
                log.info("\u627e\u5230ISZEX==>{}", (Object)sys.getString("paravalue"));
                isSendZex = sys.getString("paravalue");
                break;
            }
        }
        log.info("\u5224\u65ad\u662f\u5426\u4e0a\u4f20\u77e5\u800c\u884c ISZEX==>{}", (Object)isSendZex);
        if ("Y".equalsIgnoreCase(isSendZex)) {
            log.info("\u5f02\u6b65\u6267\u884c\u77e5\u800c\u884c\u63d0\u4ea4\u8ba2\u5355\u63a5\u53e3\u5f00\u59cb!");
            CustomAsyncScheduler.getInstance().getChnlBackendQueryPool().execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
        log.info("Syjmode\uff1a{}", (Object)vo.getCacheModel().getSyjmain().getSyjmode());
        if ("9".equals(vo.getCacheModel().getSyjmain().getSyjmode())) {
            log.info("\u5f02\u6b65\u6267\u884c\u81ea\u52a9\u4fee\u6539\u5c0f\u7968\u53f7\u63a5\u53e3\u5f00\u59cb!");
            CustomAsyncScheduler.getInstance().getChnlBackendQueryPool().execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
        log.info("\u8ba2\u5355\u5b8c\u6210\u76f4\u63a5\u8fd4\u56de!");
        return respBase;
    }

    private void zexTransAction(ResqVo vo) {
        try {
            CacheModel cacheModel = vo.getCacheModel();
            JSONObject jsonRequest = this.getRequest(cacheModel);
            String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getSyjmain().getMkt() + cacheModel.getSyjmain().getSyjh());
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
            String zexIp = SysPara.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"ZEXIP");
            if (StringUtils.isBlank((String)zexIp)) {
                log.info("ZEXIP\u53c2\u6570\u672a\u914d\u7f6e,\u4e0d\u6267\u884c\u77e5\u800c\u884c\u63d0\u4ea4!");
                return;
            }
            if (SellType.ISBACK((String)cacheModel.getOrder().getOrderType())) {
                log.info("\u9000\u8d27\u4e0d\u63d0\u4ea4\u77e5\u800c\u884c!");
                return;
            }
            String url = zexIp + "/zex/ws/transAction";
            Map sParaTemp = SubmitUtil.paraFilter((Map)jsonRequest);
            String prestr = SubmitUtil.createLinkString((Map)sParaTemp);
            log.info("\u6392\u5e8f==>{}", (Object)prestr);
            prestr = prestr + "&" + this.signKey;
            log.info("\u6392\u5e8f\u5b8c\u6210==>{}", (Object)prestr);
            String sign = DigestUtils.md5DigestAsHex((byte[])prestr.getBytes());
            jsonRequest.put("sign", (Object)sign);
            log.info("\u77e5\u800c\u884c\u8ba2\u5355\u5b8c\u6210\u5165\u53c2==>{}", (Object)JSONObject.toJSONString((Object)jsonRequest));
            String response = HttpClientUtils.postJson((String)url, (String)"UTF-8", (String)JSONObject.toJSONString((Object)jsonRequest), (int)5000, (int)5000);
            log.info("\u77e5\u800c\u884c\u8ba2\u5355\u5b8c\u6210\u8fd4\u56de{}", (Object)response);
            if (StringUtils.isBlank((String)response)) {
                log.info("\u77e5\u800c\u884c\u8ba2\u5355\u5b8c\u6210\u5f02\u5e38\u8fd4\u56de{}", (Object)response);
            }
        }
        catch (Exception e) {
            log.info("\u77e5\u800c\u884c\u8ba2\u5355\u5b8c\u6210\u63a5\u53e3\u5f02\u5e38!", (Throwable)e);
        }
    }

    private JSONObject getRequest(CacheModel cacheModel) {
        JSONObject request = new JSONObject();
        request.put("shopId", (Object)cacheModel.getSyjmain().getMkt().substring(0, 4));
        request.put("listNo", (Object)cacheModel.getOrder().getTerminalSno());
        request.put("posNo", (Object)cacheModel.getSyjmain().getSyjh());
        if (null != cacheModel.getOrder().getConsumersData().getConsumersCard()) {
            request.put("memberCard", (Object)cacheModel.getOrder().getConsumersData().getConsumersCard());
        }
        List goodsList = cacheModel.getGoodsList();
        JSONArray zexGoodsList = new JSONArray();
        for (int i = 0; i < goodsList.size(); ++i) {
            Goods goods = (Goods)goodsList.get(i);
            JSONObject zexGoods = new JSONObject();
            zexGoods.put("lineNo", (Object)(i + 1));
            zexGoods.put("barcodeId", (Object)goods.getGoodsNo());
            zexGoods.put("price", (Object)BigDecimal.valueOf(goods.getSalePrice()));
            zexGoods.put("amount", (Object)BigDecimal.valueOf(goods.getSaleAmount()));
            zexGoods.put("num", (Object)BigDecimal.valueOf(goods.getQty()));
            zexGoods.put("goodsType", (Object)"ZY");
            zexGoods.put("moneyType", (Object)"RMB");
            zexGoods.put("goodsId", (Object)goods.getGoodsCode());
            zexGoods.put("deptId", (Object)goods.getCategoryCode());
            zexGoodsList.add((Object)zexGoods);
        }
        request.put("goodsList", (Object)zexGoodsList);
        JSONArray zexPayList = new JSONArray();
        List paymentList = cacheModel.getPayments();
        if (null != paymentList) {
            for (int i = 0; i < paymentList.size(); ++i) {
                Payment payment = (Payment)paymentList.get(i);
                JSONObject zexPay = new JSONObject();
                zexPay.put("payType", (Object)11);
                zexPay.put("cardNo", (Object)cacheModel.getOrder().getTerminalSno());
                zexPay.put("amount", (Object)BigDecimal.valueOf(payment.getAmount()));
                zexPayList.add((Object)zexPay);
            }
        }
        request.put("payList", (Object)zexPayList);
        return request;
    }

    public RespBase afterCheckOrderBalance(ServiceSession session, ResqVo vo) {
        RespBase respBase;
        CacheModel cacheModel;
        block17: {
            cacheModel = vo.getCacheModel();
            boolean upCacheModel = false;
            boolean isUseCard = false;
            List paymentList = cacheModel.getPayments();
            for (int i = 0; i < paymentList.size(); ++i) {
                if (((Payment)paymentList.get(i)).getIsSuccess()) continue;
                isUseCard = true;
                break;
            }
            if (isUseCard) {
                try {
                    RespBase respBase2 = this.yktRemoteService.cardWriteOff(session, vo);
                    if (null != respBase2 && Code.SUCCESS.getIndex() == respBase2.getRetflag()) {
                        cacheModel = (CacheModel)respBase2.getData();
                        if (cacheModel.getCalcResult() == 666) {
                            upCacheModel = true;
                            cacheModel.setCalcResult(0);
                            vo.setCacheModel(cacheModel);
                        }
                        break block17;
                    }
                    return new RespBase(Code.CODE_60038.getIndex(), "\u4e00\u5361\u901a\u96c6\u4e2d\u6838\u9500\u5931\u8d25\uff1a" + respBase2.getRetmsg(), vo.getCacheModel().getFlowNo());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return new RespBase(Code.CODE_60038.getIndex(), "\u4e00\u5361\u901a\u96c6\u4e2d\u6838\u9500\u5f02\u5e38", vo.getCacheModel().getFlowNo());
                }
            }
        }
        if ("U".equals(cacheModel.getOrder().getOrderType())) {
            log.info("\u793c\u54c1\u5361\u6fc0\u6d3b{}", (Object)(cacheModel.getFlowNo() + cacheModel.isYktFlag()));
            if (!cacheModel.isYktFlag()) {
                try {
                    RespBase respBase3 = this.sendVicRecharge(session, cacheModel);
                    if (null == respBase3 || Code.SUCCESS.getIndex() != respBase3.getRetflag()) {
                        return new RespBase(Code.CODE_50025.getIndex(), "\u793c\u54c1\u5361\u6fc0\u6d3b\u5931\u8d25\uff1a" + cacheModel.getErrMsg(), vo.getCacheModel().getFlowNo());
                    }
                    ResqVo resqVo = (ResqVo)respBase3.getData();
                    cacheModel = resqVo.getCacheModel();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return new RespBase(Code.CODE_50025.getIndex(), "\u793c\u54c1\u5361\u6fc0\u6d3b\u5931\u8d25\u5f02\u5e38", vo.getCacheModel().getFlowNo());
                }
                vo.setCacheModel(cacheModel);
            }
        }
        if (cacheModel.getOrder().getDfStatus() == 0 && "h".equals(cacheModel.getOrder().getOrderType())) {
            log.info("\u7535\u8d39\u4ee3\u6536");
            JSONObject payinfo = new JSONObject();
            payinfo.put("flowNo", (Object)cacheModel.getFlowNo());
            payinfo.put("consNo", (Object)((Goods)cacheModel.getGoodsList().get(0)).getRemark());
            if ("2".equals(((Payment)cacheModel.getPayments().get(0)).getFlag())) {
                payinfo.put("rcvAmt", (Object)ManipulatePrecision.sub((double)((Payment)cacheModel.getPayments().get(1)).getAmount(), (double)((Payment)cacheModel.getPayments().get(0)).getAmount()));
            } else {
                payinfo.put("rcvAmt", (Object)((Payment)cacheModel.getPayments().get(0)).getAmount());
            }
            payinfo.put("payFlag", (Object)"11");
            respBase = this.dfRemoteService.payment(session, ResqVo.buildReqVo((CacheModel)cacheModel), payinfo);
            log.info("\u7535\u8d39\u4ee3\u6536\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString((Object)respBase));
            if (null == respBase || Code.SUCCESS.getIndex() != respBase.getRetflag()) {
                return new RespBase(Code.CODE_50025.getIndex(), "\u7535\u8d39\u4ee3\u6536\u5f02\u5e38" + respBase.getRetmsg(), vo.getCacheModel().getFlowNo());
            }
            cacheModel = ((ResqVo)respBase.getData()).getCacheModel();
            vo.setCacheModel(cacheModel);
        }
        if (cacheModel.getOrder().getDfStatus() == 0 && "i".equals(cacheModel.getOrder().getOrderType())) {
            log.info("\u7535\u8d39\u5355\u7ea2\u51b2");
            JSONObject payinfo = new JSONObject();
            payinfo.put("flowNo", (Object)cacheModel.getFlowNo());
            payinfo.put("cannelFlowNo", (Object)cacheModel.getOrder().getExtendFt3());
            respBase = this.dfRemoteService.cancelPay(session, ResqVo.buildReqVo((CacheModel)cacheModel), payinfo);
            log.info("\u7535\u8d39\u5355\u7ea2\u51b2\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString((Object)respBase));
            if (null == respBase || Code.SUCCESS.getIndex() != respBase.getRetflag()) {
                return new RespBase(Code.CODE_50025.getIndex(), "\u7535\u8d39\u4ee3\u6536\u51b2\u6b63\u5f02\u5e38" + respBase.getRetmsg(), vo.getCacheModel().getFlowNo());
            }
            cacheModel = (CacheModel)respBase.getData();
            vo.setCacheModel(cacheModel);
        }
        return new RespBase(Code.SUCCESS, (Object)vo.getCacheModel());
    }

    private String reCacheMode(String obj, JSONObject jsonObject) {
        if ("".equals(obj) || null == obj) {
            this.initRemoteService.reSaveCacheModel(null, jsonObject);
            obj = this.redisUtil.get(RedisKey.CACHEID + jsonObject.getString("shopCode") + jsonObject.getString("terminalNo"));
        }
        return obj;
    }

    public boolean isAllowHC(OrdersModel4Pos order) {
        String saleType = order.getOrderType();
        if (SellType.ISBACK((String)saleType)) {
            return false;
        }
        if ("5".equals(saleType)) {
            return false;
        }
        if ("Y19".equals(saleType)) {
            return false;
        }
        if ("Y12".equals(saleType)) {
            return false;
        }
        if ("Y12".equals(saleType)) {
            return false;
        }
        if ("U".equals(saleType)) {
            return false;
        }
        return !"Z1".equals(saleType);
    }

    public boolean isAllowBack(OrdersModel4Pos order) {
        String saleType = order.getOrderType();
        if (SellType.ISBACK((String)saleType)) {
            return false;
        }
        if ("5".equals(saleType)) {
            return false;
        }
        if ("Y19".equals(saleType)) {
            return false;
        }
        if ("Y12".equals(saleType)) {
            return false;
        }
        if ("Y12".equals(saleType)) {
            return false;
        }
        return !"U".equals(saleType);
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static /* synthetic */ void access$100(OrderSaleBSImpl_WSLF x0, ResqVo x1) {
        x0.zexTransAction(x1);
    }
}

