/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.dao.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.efuture.business.dao.OrderBaseService;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.util.db.DbTools;
import com.efuture.business.util.db.MultipleDataSource;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class OrderBaseServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<M, T>
implements OrderBaseService<T> {
    @Autowired
    private DbTools dbTools;

    public List<T> selectByMap(Map<String, Object> columnMap, String tableName) {
        return this.selectByMap(columnMap, tableName, false);
    }

    public List<T> selectByMap(Map<String, Object> columnMap, String tableName, boolean trainingMode) {
        if ("Y".equals(GlobalInfo.centrally) && columnMap.containsKey("mkt")) {
            MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc(tableName, columnMap.get("mkt").toString()));
        } else {
            MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc(tableName));
        }
        if (trainingMode) {
            MultipleDataSource.setDataSourceKey((String)"dataSource10");
        }
        return this.getBaseMapper().selectByMap(columnMap);
    }

    public List<T> selectList(Wrapper<T> queryWrapper, String tableName) {
        return this.selectList(queryWrapper, tableName, false);
    }

    public List<T> selectList(Wrapper<T> queryWrapper, String tableName, boolean trainingMode) {
        MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc(tableName));
        if (trainingMode) {
            MultipleDataSource.setDataSourceKey((String)"dataSource10");
        }
        return this.getBaseMapper().selectList(queryWrapper);
    }

    public int insert(T entity, String tableName) {
        return this.getBaseMapper().insert(entity);
    }

    public int selectCount(QueryWrapper queryWrapper, String tableName) {
        return this.getBaseMapper().selectCount((Wrapper)queryWrapper).intValue();
    }

    public int deleteByMap(Map map, String tableName) {
        return this.deleteByMap(map, tableName, false);
    }

    public int deleteByMap(Map map, String tableName, boolean trainingMode) {
        MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc(tableName));
        if (trainingMode) {
            MultipleDataSource.setDataSourceKey((String)"dataSource10");
        }
        return this.getBaseMapper().deleteByMap(map);
    }

    public T selectOne(Wrapper<T> queryWrapper, String tableName) {
        return (T)this.selectOne(queryWrapper, tableName, false);
    }

    public T selectOne(Wrapper<T> queryWrapper, String tableName, boolean trainingMode) {
        MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc(tableName));
        if (trainingMode) {
            MultipleDataSource.setDataSourceKey((String)"dataSource10");
        }
        return (T)this.getBaseMapper().selectOne(queryWrapper);
    }

    public boolean saveBatch(Collection<T> entityList, String tableName) {
        return super.saveBatch(entityList);
    }
}

