/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.SellType;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.dao.SaleOrdersModelService;
import com.efuture.business.javaPos.commonkit.Convert;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PopDetail;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrdersModel;
import com.efuture.business.javaPos.struct.request.PayConfirmIn;
import com.efuture.business.service.OrderCheckService;
import com.efuture.business.util.ArrayUtils;
import com.efuture.business.util.DateHelpUtil;
import com.efuture.business.util.RedisUtil;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.util.ParamValidateUtil;
import com.product.util.TypeUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

public class SaleOrderCheckServiceImpl
implements OrderCheckService {
    private static Logger log = LoggerFactory.getLogger(SaleOrderCheckServiceImpl.class);
    @Autowired
    private SaleOrdersModelService orderMapper;
    private static final String BILL_END_TIME = " 05:00:00";
    @Autowired
    private RedisUtil redisUtil;
    @Value(value="${localcache.enabled}")
    private Boolean localcache;

    public static ServiceResponse checkSaleDataNull(ServiceSession session, JSONObject paramsObject) {
        ArrayList<String> checkCol = new ArrayList<String>();
        checkCol.add("entId");
        checkCol.add("channel");
        checkCol.add("channelSheetNo");
        checkCol.add("terminalNo");
        checkCol.add("terminalSno");
        checkCol.add("terminalOperator");
        checkCol.add("busiTakeMarketCode");
        checkCol.add("busiTakeMarket");
        checkCol.add("overageValue");
        checkCol.add("changeValue");
        checkCol.add("orderType");
        checkCol.add("logisticsMode");
        checkCol.add("oughtPay");
        checkCol.add("factPay");
        checkCol.add("saleDate");
        checkCol.add("corporationCode");
        checkCol.add("ordersDetail");
        checkCol.add("goodsName");
        checkCol.add("rowNo");
        checkCol.add("goodsCode");
        checkCol.add("barNo");
        checkCol.add("goodsFlag");
        checkCol.add("goodType");
        checkCol.add("controlGood");
        checkCol.add("listPrice");
        checkCol.add("salePrice");
        checkCol.add("copies");
        checkCol.add("partsNum");
        checkCol.add("qty");
        checkCol.add("saleValue");
        checkCol.add("totalDiscountValue");
        checkCol.add("adjustDiscountValue");
        checkCol.add("customDiscountValue");
        checkCol.add("payDiscountValue");
        checkCol.add("popDiscountValue");
        checkCol.add("mealDiscountValue");
        checkCol.add("saleAmount");
        checkCol.add("weight");
        checkCol.add("ordersPay");
        checkCol.add("flag");
        checkCol.add("payType");
        checkCol.add("payCode");
        checkCol.add("payName");
        checkCol.add("rate");
        checkCol.add("amount");
        checkCol.add("money");
        checkCol.add("overage");
        checkCol.add("invoiceFlag");
        ServiceResponse check = ParamValidateUtil.checkParam((ServiceSession)session, (JSONObject)paramsObject, (String[])checkCol.toArray(new String[0]));
        if (!check.getReturncode().equals("0")) {
            return check;
        }
        return ServiceResponse.buildSuccess(null);
    }

    public RespBase checkSaleBalance(ServiceSession session, PayConfirmIn in, CacheModel cacheModel) {
        if (StringUtils.isEmpty((Object)cacheModel.getOrder())) {
            return new RespBase(Code.CODE_60114, "");
        }
        String splitodevalue = "";
        try {
            Order order = cacheModel.getOrder();
            List orderDetails = cacheModel.getGoodsList();
            Object maxterminalSno = "";
            HashMap<String, String> map1 = new HashMap<String, String>();
            map1.put("saleMarketCode", order.getShopCode());
            map1.put("terminalNo", order.getTerminalNo());
            if (!this.localcache.booleanValue()) {
                map1.put("billDate", this.computeBillDateForSearch(new Date()));
            }
            if (null != (maxterminalSno = this.orderMapper.getMaxTerminalSno(map1, "orders")) && Integer.valueOf((String)maxterminalSno) >= 9999999) {
                maxterminalSno = "0";
                return Code.CODE_60034.getRespBase(new Object[0]);
            }
            double oriTotalDiscountValue = 0.0;
            double qtyTotal = 0.0;
            ArrayList popDetails = new ArrayList();
            for (Goods orderDetail : cacheModel.getGoodsList()) {
                if (!Double.isNaN(orderDetail.getAdjustDiscountValue()) && orderDetail.getAdjustDiscountValue() != 0.0) {
                    oriTotalDiscountValue = ManipulatePrecision.add((double)oriTotalDiscountValue, (double)orderDetail.getAdjustDiscountValue());
                }
                if (!Double.isNaN(orderDetail.getPopDiscountValue()) && orderDetail.getPopDiscountValue() != 0.0) {
                    oriTotalDiscountValue = ManipulatePrecision.add((double)oriTotalDiscountValue, (double)orderDetail.getPopDiscountValue());
                }
                if (!Double.isNaN(orderDetail.getCustomDiscountValue()) && orderDetail.getCustomDiscountValue() != 0.0) {
                    oriTotalDiscountValue = ManipulatePrecision.add((double)oriTotalDiscountValue, (double)orderDetail.getCustomDiscountValue());
                }
                if (!Double.isNaN(orderDetail.getPayDiscountValue()) && orderDetail.getPayDiscountValue() != 0.0) {
                    oriTotalDiscountValue = ManipulatePrecision.add((double)oriTotalDiscountValue, (double)orderDetail.getPayDiscountValue());
                }
                if (!Double.isNaN(orderDetail.getMealDiscountValue()) && orderDetail.getMealDiscountValue() != 0.0) {
                    oriTotalDiscountValue = ManipulatePrecision.add((double)oriTotalDiscountValue, (double)orderDetail.getMealDiscountValue());
                }
                if (!Double.isNaN(orderDetail.getStudentCardDiscountValue()) && orderDetail.getStudentCardDiscountValue() != 0.0) {
                    oriTotalDiscountValue = ManipulatePrecision.add((double)oriTotalDiscountValue, (double)orderDetail.getStudentCardDiscountValue());
                }
                qtyTotal += orderDetail.getQty();
                if (orderDetail.getPopDetailsInfo().size() <= 0) continue;
                popDetails.addAll(orderDetail.getPopDetailsInfo());
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            String terminalSno = order.getTerminalSno();
            if (null != in.getNewTerminalSno() && !in.getNewTerminalSno().equals("")) {
                terminalSno = in.getNewTerminalSno();
            }
            queryWrapper.eq((Object)"busiTakeMarketCode", (Object)order.getShopCode());
            queryWrapper.eq((Object)"terminalNo", (Object)order.getTerminalNo());
            queryWrapper.eq((Object)"terminalSno", (Object)terminalSno);
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)splitodevalue)) {
                queryWrapper.eq((Object)"shardingCode", (Object)splitodevalue);
            }
            List saleOrdersModels = this.orderMapper.selectList((Wrapper)queryWrapper, "orders");
            log.info("checkSaleBalance=====>" + in.getNewTerminalSno());
            if (ArrayUtils.isNotEmpty((List)saleOrdersModels)) {
                if (saleOrdersModels.size() > 1 || !((SaleOrdersModel)saleOrdersModels.get(0)).getPosId().equals(order.getFlowNo())) {
                    log.info("\u8ba2\u5355\u4e0a\u4f20\u5904\u7406-\u6700\u7ec8\u6821\u9a8c,\u5c0f\u7968\u53f7\u5df2\u5b58\u5728:" + order.getTerminalSno());
                    String obj = this.redisUtil.get(RedisKey.CACHEID + order.getShopCode() + order.getTerminalNo());
                    ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
                    if (1 == modeDetailsVo.getSysparainfo().getFphmMode()) {
                        maxterminalSno = order.getTerminalSno().substring(0, 6) + Convert.increaseCharForward((String)maxterminalSno, (char)'0', (int)modeDetailsVo.getSysparainfo().getXpws());
                    }
                    return new RespBase(Code.CODE_60006, maxterminalSno, in.getFlowNo());
                }
            } else if (in.getNewTerminalSno() != null && !in.getNewTerminalSno().equals("")) {
                cacheModel.getOrder().setTerminalSno(in.getNewTerminalSno());
            }
            if (ManipulatePrecision.sub((double)oriTotalDiscountValue, (double)order.getTotalDiscountValue()) != 0.0) {
                return Code.CODE_60031.getRespBase(new Object[]{"\u4fc3\u9500\u6570\u636e\u4e0d\u76f8\u7b49"});
            }
            log.info("\u68c0\u67e5\u5b9e\u4ed8\u91d1\u989d\u548c\u5e94\u4ed8\u91d1\u989d\u662f\u5426\u76f8\u7b49=====>");
            double factPay = ManipulatePrecision.doubleConvert((double)(order.getExistPay() - order.getChangeValue()));
            double ougthPay = ManipulatePrecision.doubleConvert((double)(order.getOughtPay() + order.getOverageValue()));
            if (ManipulatePrecision.doubleCompare((double)factPay, (double)ougthPay, (int)2) != 0) {
                return Code.CODE_60115.getRespBase(new Object[0]);
            }
            log.info("\u68c0\u67e5\u5546\u54c1\u884c\u6570\u636e\u662f\u5426\u76f8\u7b49=====>");
            double detailOugthPay = 0.0;
            if (orderDetails != null && orderDetails.size() != 0) {
                for (Goods orderDe : orderDetails) {
                    detailOugthPay = ManipulatePrecision.add((double)detailOugthPay, (double)orderDe.getSaleAmount());
                }
            } else {
                return Code.CODE_60116.getRespBase(new Object[0]);
            }
            if (ManipulatePrecision.doubleCompare((double)detailOugthPay, (double)(order.getOughtPay() + order.getRoundUpOverageValue()), (int)2) != 0) {
                return Code.CODE_60115.getRespBase(new Object[0]);
            }
            log.info("\u68c0\u67e5\u4ed8\u6b3e\u884c\u91d1\u989d=====>");
            double detailPayAll = 0.0;
            List orderPays = cacheModel.getPayments();
            if (orderPays != null && orderPays.size() > 0) {
                for (Payment pay : orderPays) {
                    if ("1".equals(pay.getFlag())) {
                        detailPayAll = ManipulatePrecision.add((double)detailPayAll, (double)pay.getMoney());
                        continue;
                    }
                    if (!"2".equals(pay.getFlag())) continue;
                    detailPayAll = ManipulatePrecision.sub((double)detailPayAll, (double)pay.getMoney());
                }
            } else {
                return Code.CODE_60117.getRespBase(new Object[0]);
            }
            if (ManipulatePrecision.doubleCompare((double)detailPayAll, (double)ougthPay, (int)2) != 0) {
                return Code.CODE_60118.getRespBase(new Object[0]);
            }
            log.info("\u6821\u9a8c\u5546\u54c1\u4fc3\u9500\u884c\u548c\u5546\u54c1\u884c\u4fc3\u9500\u662f\u5426\u5339\u914d=====>");
            if (popDetails.size() > 0) {
                for (Goods orderDetail : orderDetails) {
                    double totalDiscount = ManipulatePrecision.sub((double)orderDetail.getTotalDiscountValue(), (double)orderDetail.getCouponValue());
                    log.info("totalDiscount:{}", (Object)totalDiscount);
                    String orderType = order.getOrderType();
                    if (!(!SellType.ISSALE((String)orderType) || SellType.NOPOP((String)cacheModel.getOrder().getOrderType()) || SellType.isGroupbuy((String)cacheModel.getOrder().getOrderType(), (boolean)cacheModel.getOrder().getHasGroupBuy()) || cacheModel.getPopMode() != 1 && cacheModel.getPopMode() != 2 && cacheModel.getPopMode() != 3)) {
                        log.info("AdjustDiscountValue:{},StudentCardDiscountValue:{},CustomDiscountValue:{},BarcodeDiscount:{}", new Object[]{orderDetail.getAdjustDiscountValue(), orderDetail.getStudentCardDiscountValue(), orderDetail.getCustomDiscountValue(), orderDetail.getBarcodeDiscount()});
                        totalDiscount = ManipulatePrecision.sub((double)totalDiscount, (double)orderDetail.getAdjustDiscountValue());
                        totalDiscount = ManipulatePrecision.sub((double)totalDiscount, (double)orderDetail.getStudentCardDiscountValue());
                        totalDiscount = ManipulatePrecision.sub((double)totalDiscount, (double)orderDetail.getCustomDiscountValue());
                    }
                    log.info("totalDiscount:{}", (Object)totalDiscount);
                    double totalPops = 0.0;
                    if (orderDetail.getPopDetailsInfo().size() > 0) {
                        for (PopDetail popDetail : orderDetail.getPopDetailsInfo()) {
                            totalPops = ManipulatePrecision.add((double)totalPops, (double)popDetail.getDiscountAmount());
                        }
                    }
                    log.info("totalPops:{}", (Object)totalPops);
                    if (ManipulatePrecision.doubleCompare((double)totalDiscount, (double)totalPops, (int)2) == 0) continue;
                    return Code.CODE_60119.getRespBase(new Object[0]);
                }
            }
            return new RespBase(Code.SUCCESS);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Code.CODE_60031.getRespBase(new Object[]{"error"});
        }
    }

    public RespBase checkOrderState(CacheModel cacheModel) {
        return null;
    }

    public String computeBillDateForSearch(Date createDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            String searchDate = dateFormat.format(createDate);
            Date whenDate = TypeUtils.castToDate((Object)(searchDate + BILL_END_TIME));
            if (createDate.after(whenDate)) {
                return searchDate;
            }
            if (createDate.equals(whenDate)) {
                return searchDate;
            }
            return DateHelpUtil.getYestoryDate((String)searchDate);
        }
        catch (Exception e) {
            log.error("\u8ba2\u5355\u4e2d\u5fc3\u8ba1\u7b97\u8bb0\u8d26\u65e5\u671f\u5931\u8d25: " + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

