/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.dao.SaleOrdersDetailModelService;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.javaPos.struct.orderCentre.OrderStateEnum;
import com.efuture.business.javaPos.struct.orderCentre.OrderTypeEnum;
import com.efuture.business.javaPos.struct.orderCentre.PayStateEnum;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrderDetailModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrderDetailPopModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrderGainDetailModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrderGainModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrderPayModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrderUseCouponModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrders;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrdersExtModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrdersMemberModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrdersModel;
import com.efuture.business.service.OrderPosCommonService;
import com.efuture.business.service.OrderPosUploadService;
import com.efuture.business.util.DateHelpUtil;
import com.efuture.business.util.ExtShardingUtil;
import com.efuture.business.util.Http;
import com.efuture.business.util.LocalUtil;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.UniqueID;
import com.efuture.business.util.db.MultipleDataSource;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.util.TypeUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

public class SaleOrderPosUploadServiceImpl
implements OrderPosUploadService {
    private static final Logger log = LoggerFactory.getLogger(SaleOrderPosUploadServiceImpl.class);
    @Autowired
    private OrderPosCommonService orderPosCommonService;
    @Autowired
    private SaleOrdersDetailModelService ordersDetailMapper;
    @Autowired(required=false)
    private ExtShardingUtil extShardingUtil;
    private static final String BILL_END_TIME = " 05:00:00";
    @Value(value="${localcache.enabled}")
    private Boolean localcache;
    @Value(value="${hazelcast.enabled:false}")
    private Boolean hazelcast;
    @Autowired
    private RedisUtil redisUtil;

    public RespBase receiveOrderUpload(ServiceSession session, SaleOrders saleOrders, String netType) {
        long excuStartTime = System.currentTimeMillis();
        log.info("\u8ba2\u5355\u4e0a\u4f20\u5165\u53c2: " + JSON.toJSONString((Object)saleOrders));
        try {
            log.info("\u8ba2\u5355\u4e0a\u4f20\u5904\u7406, start ...... ");
            RespBase uploadSr = this.assemblyOrderParam(session, saleOrders);
            log.info("\u8ba2\u5355\u4e0a\u4f20\u5904\u7406,\u8fd4\u56de\u7ed3\u679c : " + uploadSr.getRetflag() + "---" + uploadSr.getData());
            JSONObject result = new JSONObject();
            if (String.valueOf(uploadSr.getRetflag()).equals("101")) {
                result.put("terminalSno", (Object)uploadSr.getData().toString());
                RespBase sr = new RespBase();
                sr.setRetflag(Integer.parseInt("101"));
                sr.setData((Object)result);
                return sr;
            }
            log.info("\u8ba2\u5355\u4e0a\u4f20,\u603b\u8017\u65f6(ms): " + (System.currentTimeMillis() - excuStartTime));
            return uploadSr;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Code.CODE_60028.getRespBase(new Object[]{e.getMessage()});
        }
    }

    public RespBase assemblyOrderParam(ServiceSession session, SaleOrders orderJson) {
        log.info("\u7ec4\u88c5\u8ba2\u5355\u4e0a\u4f20\u53c2\u6570,start ...... ");
        HashMap<String, Object> preSaveParamInfo = new HashMap<String, Object>();
        JSONObject result = new JSONObject();
        boolean isAllReturn = true;
        SaleOrdersModel order = null;
        long oid = UniqueID.getUniqueID();
        try {
            RespBase response;
            Date billDate;
            long t1 = System.currentTimeMillis();
            MultipleDataSource.setDataSourceKey((String)"dataSource01");
            order = orderJson.getSaleOrders();
            if (order == null) {
                return Code.CODE_60121.getRespBase(new Object[0]);
            }
            session.setShop_code(order.getSaleMarketCode());
            List orderDetails = orderJson.getSaleOrderDetail();
            if (orderDetails == null || orderDetails.size() == 0) {
                return Code.CODE_60116.getRespBase(new Object[0]);
            }
            SaleOrdersExtModel orderExt = orderJson.getSaleOrdersExt();
            SaleOrdersMemberModel ordersMember = orderJson.getSaleOrdersMember();
            List orderPays = orderJson.getSaleOrderPay();
            if (orderPays == null || orderPays.size() == 0) {
                return Code.CODE_60117.getRespBase(new Object[0]);
            }
            List orderPops = orderJson.getSaleOrderDetailPop();
            List orderGains = orderJson.getSaleOrderGain();
            List orderGainDetails = orderJson.getSaleOrderGainDetail();
            List orderUseCoupons = orderJson.getSaleOrderUseCoupon();
            long t2 = System.currentTimeMillis();
            log.info("\u7ec4\u88c5\u8ba2\u5355\u4e0a\u4f20\u53c2\u6570,\u8f6c\u6362\u53c2\u6570\u5bf9\u8c61,\u8017\u65f6(ms): " + (t2 - t1));
            order.setOid(Long.valueOf(oid));
            order.setUploadErp(Integer.valueOf(1));
            order.setLang("CN");
            order.setPayState(Integer.valueOf(PayStateEnum.YFK.getCode()));
            order.setOrderState(Integer.valueOf(OrderStateEnum.YWC.getCode()));
            Object orderNo = StringUtils.isEmpty((Object)order.getOrderNo()) ? "" + UniqueID.getUniqueID() : order.getOrderNo();
            order.setOrderNo((String)orderNo);
            order.setParentOrderNo((String)orderNo);
            Date nowDate = new Date();
            if (StringUtils.isEmpty((Object)order.getCreateDate())) {
                order.setCreateDate(nowDate);
                log.info("\u8ba2\u5355\u521b\u5efa\u65f6\u95f4\u8f93\u51fa2==" + nowDate + ",\u8ba2\u5355\u65f6\u95f4==" + order.getCreateDate());
            }
            boolean isTH = false;
            if (order.getSheetTypeCode().equals(OrderTypeEnum.HCLS.getCode()) || order.getSheetTypeCode().equals(OrderTypeEnum.LSTH.getCode())) {
                isTH = true;
            }
            if ((billDate = this.computeBillDate(order.getCreateDate())) == null) {
                return Code.CODE_60122.getRespBase(new Object[0]);
            }
            order.setBillDate(billDate);
            order.setReceiveDate(nowDate);
            order.setLastDate(nowDate);
            String shardingCode = "";
            if (null != order.getShardingCode()) {
                shardingCode = order.getShardingCode();
            }
            double totalQty = 0.0;
            if (orderDetails != null && orderDetails.size() > 0) {
                for (SaleOrderDetailModel sodm : orderDetails) {
                    totalQty += sodm.getQty().doubleValue();
                }
            }
            order.setReturnQty(Double.valueOf(totalQty));
            if (StringUtils.isEmpty((Object)order.getPayDiscountValue())) {
                order.setPayDiscountValue(new BigDecimal("0"));
            }
            if (StringUtils.isEmpty((Object)order.getTotalCouponValue())) {
                order.setTotalCouponValue(new BigDecimal("0"));
            }
            if (StringUtils.isEmpty((Object)order.getManulAudit())) {
                order.setManulAudit(Integer.valueOf(0));
            }
            if (StringUtils.isEmpty((Object)order.getHasBackPrint())) {
                order.setHasBackPrint(Boolean.valueOf(false));
            }
            preSaveParamInfo.put("saleOrders", order);
            for (SaleOrderDetailModel sodm : orderDetails) {
                sodm.setOdId(Long.valueOf(UniqueID.getUniqueID()));
                sodm.setEntId(order.getEntId());
                sodm.setOid(order.getOid());
                sodm.setLang("CN");
                sodm.setCreateDate(nowDate);
                sodm.setReceiveDate(nowDate);
                if (order.getSheetTypeCode().equals("1")) {
                    sodm.setAllowReturnCopies(sodm.getQty());
                } else if (order.getSheetTypeCode().equals("4") || order.getSheetTypeCode().equals("2")) {
                    sodm.setAllowReturnCopies(Double.valueOf(0.0));
                }
                sodm.setAllowReturnCopies(sodm.getQty());
                sodm.setStockoutCopies(Double.valueOf(0.0));
                sodm.setShardingCode(shardingCode);
                if (StringUtils.isEmpty((Object)sodm.getPrcutMode())) {
                    sodm.setPrcutMode("2");
                }
                if (StringUtils.isEmpty((Object)sodm.getKlm())) {
                    sodm.setKlm("1");
                }
                if (StringUtils.isEmpty((Object)sodm.getFishGoods())) {
                    sodm.setFishGoods(Integer.valueOf(0));
                }
                if (!StringUtils.isEmpty((Object)sodm.getTreasureFlag())) continue;
                sodm.setTreasureFlag(Integer.valueOf(0));
            }
            boolean hasComputeOrigin = false;
            if (isTH && !StringUtils.isEmpty((Object)order.getSourceNo())) {
                hasComputeOrigin = true;
            } else if (order.getSheetTypeCode().equals(OrderTypeEnum.HCLS.getCode()) && !StringUtils.isEmpty((Object)order.getSourceNo())) {
                hasComputeOrigin = true;
            }
            List matchModels = new ArrayList();
            if (hasComputeOrigin) {
                RespBase sr = this.orderPosCommonService.checkOriginGoodQty(session, orderDetails, order.getSourceNo());
                if (Code.SUCCESS.getIndex() != sr.getRetflag()) {
                    throw new Exception("\u7ec4\u88c5\u8ba2\u5355\u4e0a\u4f20\u53c2\u6570,\u9519\u8bef: " + sr.getData().toString());
                }
                JSONObject checkSr = (JSONObject)sr.getData();
                matchModels = (List)checkSr.get((Object)"matchModels");
            }
            preSaveParamInfo.put("saleOrderDetail", orderDetails);
            preSaveParamInfo.put("matchOriginDetail", matchModels);
            if (orderExt != null) {
                orderExt.setOeid(Long.valueOf(UniqueID.getUniqueID()));
                orderExt.setOid(order.getOid());
                orderExt.setEntId(order.getEntId());
                orderExt.setLang("CN");
                orderExt.setShardingCode(shardingCode);
                preSaveParamInfo.put("saleOrdersExt", orderExt);
            }
            if (ordersMember != null) {
                ordersMember.setOsId(Long.valueOf(UniqueID.getUniqueID()));
                ordersMember.setOid(order.getOid());
                ordersMember.setEntId(order.getEntId());
                ordersMember.setLang("CN");
                ordersMember.setCreateDate(nowDate);
                ordersMember.setShardingCode(shardingCode);
                preSaveParamInfo.put("saleOrdersMember", ordersMember);
            }
            for (SaleOrderPayModel sopm : orderPays) {
                sopm.setOpId(Long.valueOf(UniqueID.getUniqueID()));
                sopm.setOid(order.getOid());
                sopm.setEntId(order.getEntId());
                sopm.setLang("CN");
                sopm.setCreateDate(nowDate);
                sopm.setShardingCode(shardingCode);
                if (this.localcache.booleanValue() || this.hazelcast.booleanValue() || isTH) {
                    // empty if block
                }
                if (StringUtils.isEmpty((Object)sopm.getDiscountValue())) {
                    sopm.setDiscountValue(new BigDecimal("0"));
                }
                if (StringUtils.isEmpty((Object)sopm.getMerchantDiscountValue())) {
                    sopm.setMerchantDiscountValue(new BigDecimal("0"));
                }
                if (StringUtils.isEmpty((Object)sopm.getPayChannelDiscountValue())) {
                    sopm.setPayChannelDiscountValue(new BigDecimal("0"));
                }
                if (!StringUtils.isEmpty((Object)sopm.getRoundUpOverageValue())) continue;
                sopm.setRoundUpOverageValue(new BigDecimal("0"));
            }
            preSaveParamInfo.put("saleOrderPay", orderPays);
            if (orderPops != null && orderPops.size() > 0) {
                for (SaleOrderDetailPopModel sodpm : orderPops) {
                    sodpm.setOpId(Long.valueOf(UniqueID.getUniqueID()));
                    sodpm.setEntId(order.getEntId());
                    sodpm.setOid(order.getOid());
                    sodpm.setLang("CN");
                    sodpm.setReceiveDate(nowDate);
                    sodpm.setShardingCode(shardingCode);
                }
                preSaveParamInfo.put("saleOrderDetailPop", orderPops);
            }
            if (orderGains != null && orderGains.size() > 0) {
                for (SaleOrderGainModel gain : orderGains) {
                    gain.setOgId(Long.valueOf(UniqueID.getUniqueID()));
                    gain.setOid(order.getOid());
                    gain.setEntId(order.getEntId());
                    gain.setLang("CN");
                    gain.setReceiveDate(nowDate);
                    gain.setShardingCode(shardingCode);
                }
                preSaveParamInfo.put("saleOrderGain", orderGains);
            }
            if (orderGainDetails != null && orderGainDetails.size() > 0) {
                for (SaleOrderGainDetailModel gd : orderGainDetails) {
                    gd.setOgdId(Long.valueOf(UniqueID.getUniqueID()));
                    gd.setOid(order.getOid());
                    gd.setEntId(order.getEntId());
                    gd.setLang("CN");
                    gd.setReceiveDate(nowDate);
                    gd.setShardingCode(shardingCode);
                }
                preSaveParamInfo.put("saleOrderGainDetail", orderGainDetails);
            }
            if (orderUseCoupons != null && orderUseCoupons.size() > 0) {
                for (SaleOrderUseCouponModel ucm : orderUseCoupons) {
                    ucm.setOucId(Long.valueOf(UniqueID.getUniqueID()));
                    ucm.setOid(order.getOid());
                    ucm.setEntId(order.getEntId());
                    ucm.setLang("CN");
                    ucm.setReceiveDate(nowDate);
                    ucm.setShardingCode(shardingCode);
                }
                preSaveParamInfo.put("saleOrderUseCoupon", orderUseCoupons);
            }
            long t3 = System.currentTimeMillis();
            log.info("\u7ec4\u88c5\u8ba2\u5355\u4e0a\u4f20\u53c2\u6570,\u521d\u59cb\u5316\u53c2\u6570,\u8017\u65f6(ms): " + (t3 - t2));
            if (this.localcache.booleanValue()) {
                log.info("\u5f00\u59cb\u68c0\u6d4b\u672c\u5730\u5e93\u662f\u5426\u5b58\u5728!!");
                LocalUtil.checkTodayDatabase();
            }
            if (this.localcache.booleanValue() || this.hazelcast.booleanValue()) {
                String s = this.formatBillDate(billDate);
                if (StringUtils.isEmpty((Object)s)) {
                    return Code.CODE_60123.getRespBase(new Object[0]);
                }
                MultipleDataSource.setLocDataSourceKey((String)s);
            }
            RespBase uploadSr = this.orderPosCommonService.saveOrderInfoForCloud(session, null, preSaveParamInfo, order, null);
            long t4 = System.currentTimeMillis();
            log.info("\u8ba2\u5355\u6279\u91cf\u4fdd\u5b58,\u8fd4\u56de\u7ed3\u679c : " + uploadSr.getRetflag() + "---" + uploadSr.getData());
            log.info("\u7ec4\u88c5\u8ba2\u5355\u4e0a\u4f20\u53c2\u6570,\u6279\u91cf\u4fdd\u5b58,\u8017\u65f6(ms): " + (t4 - t3));
            if (Code.SUCCESS.getIndex() != uploadSr.getRetflag()) {
                if ("10001".equals(String.valueOf(uploadSr.getRetflag()))) {
                    result.clear();
                    result.put("oid", (Object)order.getOid());
                    result.put("sheetNo", (Object)order.getOrderNo());
                    result.put("terminalSno", (Object)order.getTerminalSno());
                    result.put("isAllReturn", (Object)true);
                    return new RespBase(Code.SUCCESS, (Object)result);
                }
                return uploadSr;
            }
            boolean saveForCloud = false;
            if (this.localcache.booleanValue() || this.hazelcast.booleanValue()) {
                try {
                    preSaveParamInfo.put("command_id", "SYNCLOCALORDER");
                    log.info("\u540c\u6b65\u7ebf\u4e0a\u8ba2\u5355\u5165\u53c2\uff1a" + JSON.toJSONString(preSaveParamInfo));
                    log.info("GlobalInfo.cloudUrl\uff1a" + GlobalInfo.cloudUrl);
                    Http http = new Http();
                    String res = http.httpPostData(GlobalInfo.cloudUrl, JSON.toJSONString(preSaveParamInfo), 5000, false);
                    log.info("\u540c\u6b65\u7ebf\u4e0a\u8ba2\u5355\u8fd4\u56de\uff1a" + JSON.toJSONString((Object)res));
                    if (null != res && !"".equals(res) && "0".equals((response = (ServiceResponse)JSONObject.parseObject((String)res, ServiceResponse.class)).getReturncode())) {
                        saveForCloud = true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                saveForCloud = true;
            }
            result = (JSONObject)uploadSr.getData();
            long t5 = System.currentTimeMillis();
            if (!this.localcache.booleanValue() && !this.hazelcast.booleanValue() && isTH && !StringUtils.isEmpty((Object)order.getSourceNo())) {
                double qty;
                JSONObject checkPa = new JSONObject();
                checkPa.put("sheetNo", (Object)order.getSourceNo());
                List checkAllowQtyList = this.ordersDetailMapper.searchAllowReturnQty(checkPa, "ordersdetail");
                if (checkAllowQtyList != null && checkAllowQtyList.size() > 0 && checkAllowQtyList.get(0) != null && !StringUtils.isEmpty(((Map)checkAllowQtyList.get(0)).get("qty")) && (qty = Double.parseDouble(((Map)checkAllowQtyList.get(0)).get("qty").toString())) > 0.0) {
                    isAllReturn = false;
                }
            }
            log.info("\u7ec4\u88c5\u8ba2\u5355\u4e0a\u4f20\u53c2\u6570,\u8ba1\u7b97\u662f\u5426\u5168\u5355\u9000\u8d27,\u8017\u65f6(ms): " + (t5 - t4));
            result.put("isAllReturn", (Object)isAllReturn);
            log.info("\u7ec4\u88c5\u8ba2\u5355\u4e0a\u4f20\u53c2\u6570,end ...... \u8ba2\u5355\u53f7: " + order.getOrderNo());
            if (!saveForCloud) {
                response = new RespBase();
                response.setRetflag(1);
                response.setData((Object)result);
                return response;
            }
            if (!this.localcache.booleanValue()) {
                JSONObject rightPushValue = new JSONObject();
                rightPushValue.put("entId", (Object)order.getEntId());
                rightPushValue.put("erpCode", (Object)order.getBusCompany());
                rightPushValue.put("oid", (Object)order.getOid());
                rightPushValue.put("shopCode", (Object)order.getSaleMarketCode());
                long var = this.redisUtil.rightPush("ORDER_SYSN_ERP_QUEUE", rightPushValue.toJSONString());
                log.info("\u5b58\u5165redis\u8ba2\u5355\u5e8f\u5217\uff1a" + var + rightPushValue.toString());
            }
            return new RespBase(Code.SUCCESS, (Object)result);
        }
        catch (Exception e) {
            log.error("\u7ec4\u88c5\u8ba2\u5355\u4e0a\u4f20\u53c2\u6570,\u9519\u8bef: " + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            return Code.CODE_60028.getRespBase(new Object[]{e.getMessage()});
        }
    }

    public Date computeBillDate(Date nowDate) {
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
        try {
            String billCloseDate = sdf1.format(nowDate) + BILL_END_TIME;
            Date whenDate = TypeUtils.castToDate((Object)billCloseDate);
            if (nowDate.after(whenDate)) {
                return nowDate;
            }
            return sdf1.parse(DateHelpUtil.getYestoryDate((String)sdf1.format(nowDate)));
        }
        catch (Exception e) {
            log.error("\u4e91\u7aef\u8ba2\u5355\u4e2d\u5fc3\u8ba1\u7b97\u65f6\u95f4\u8282\u70b9\u5931\u8d25: " + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String formatBillDate(Date billDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        try {
            String format = sdf.format(billDate);
            return format;
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u8ba2\u5355\u65f6\u95f4\u5931\u8d25: " + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

