/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.YPopStatusType;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.javaPos.struct.SyncTradeModel;
import com.efuture.business.mapper.base.SyncTradeMapper;
import com.efuture.business.service.SyncTradeService;
import com.efuture.business.util.db.DbTools;
import com.efuture.business.util.db.MultipleDataSource;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.rest.ServiceMethodReflect;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SyncTradeServiceImpl
implements SyncTradeService {
    private static final Logger log = LoggerFactory.getLogger(SyncTradeServiceImpl.class);
    @Autowired
    private SyncTradeMapper syncTradeMapper;
    @Autowired
    private DbTools dbTools;
    @Autowired
    private GlobalInfo globalInfo;

    public List<SyncTradeModel> getSyncTradeList() {
        MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("sync"));
        List models = this.syncTradeMapper.querySyncTrade();
        return models;
    }

    public boolean addSyncTrade(String tradeNo, String type, String billDate, String terminalSno, String existPay) {
        MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("sync"));
        SyncTradeModel syncTradeModel = new SyncTradeModel();
        syncTradeModel.setBillDate(billDate);
        syncTradeModel.setTradeNo(tradeNo);
        syncTradeModel.setType(type);
        syncTradeModel.setTerminalSno(terminalSno);
        syncTradeModel.setExistPay(existPay);
        int insertNum = this.syncTradeMapper.insertSyncTrade(syncTradeModel);
        return insertNum > 0;
    }

    public boolean deleteSyncTrade(List<String> tradeNoList) {
        MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("sync"));
        JSONObject obj = new JSONObject();
        obj.put("tradeNoList", tradeNoList);
        int deleteNum = this.syncTradeMapper.deleteSyncTrade(obj);
        return deleteNum >= 0;
    }

    public RespBase recalc(com.product.model.ServiceSession session) {
        JSONObject inParamsQuery = new JSONObject();
        JSONObject inParams = new JSONObject();
        RespBase respBase = new RespBase();
        inParams.put("billno", (Object)"ALL");
        inParams.put("calc_mode", (Object)"SEND");
        inParamsQuery.put("billno", (Object)"COUNT");
        inParamsQuery.put("calc_billid", (Object)"SEND");
        com.product.model.ServiceResponse resp = null;
        try {
            if ("1".equals(GlobalInfo.mssLocalIsOpen)) {
                ServiceMethodReflect rcm = new ServiceMethodReflect();
                log.info("recalc entid ======>" + session.getEnt_id());
                log.info("recalc  ======>" + inParams);
                ServiceSession sessionobj = new ServiceSession();
                sessionobj.setRemoteaddr("localhost");
                sessionobj.setMethod(YPopStatusType.cmdtype_sendsale);
                sessionobj.setEnt_id(session.getEnt_id());
                sessionobj.setUser_code(String.valueOf(session.getUser_id()));
                sessionobj.setUser_name(session.getUser_name());
                sessionobj.setLogkey("");
                sessionobj.setRootkey("");
                sessionobj.setParentkey("");
                ServiceResponse ocpresp = null;
                ocpresp = (ServiceResponse)rcm.executeClassMethod(YPopStatusType.cmdtype_sendsale, sessionobj, inParams.toJSONString());
                if (null != ocpresp) {
                    log.info("\u8425\u9500\u8fd4\u56de==>{}", (Object)JSONObject.toJSONString((Object)ocpresp));
                    JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)ocpresp.getData()));
                    log.info("recalc  ======>" + jsonObject.toJSONString());
                    if (StringUtils.isBlank((String)jsonObject.getString("calc_result"))) {
                        jsonObject.put("calc_result", (Object)"0");
                    }
                    resp = new com.product.model.ServiceResponse();
                    resp.setReturncode(ocpresp.getReturncode());
                    resp.setData((Object)jsonObject);
                }
            } else {
                return Code.CODE_60092.getRespBase(new Object[0]);
            }
            String code = resp.getReturncode();
            if ("0".equals(code)) {
                respBase.setData((Object)((JSONObject)JSONObject.toJSON((Object)resp.getData())));
                respBase.setRetflag(0);
                respBase.setRetmsg("success");
            } else {
                respBase.setData((Object)((JSONObject)JSONObject.toJSON((Object)resp.getData())));
                respBase.setRetflag(Integer.parseInt(code));
                respBase.setRetmsg(resp.getData() == null ? "" : resp.getData().toString());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        return respBase;
    }
}

