/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl.wslf;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.dao.wslf.OrdersDetailModelService;
import com.efuture.business.dao.wslf.OrdersDetailPopModelService;
import com.efuture.business.dao.wslf.OrdersExtModelService;
import com.efuture.business.dao.wslf.OrdersGainDetailModelService;
import com.efuture.business.dao.wslf.OrdersGainModelService;
import com.efuture.business.dao.wslf.OrdersMemberModelService;
import com.efuture.business.dao.wslf.OrdersModelService;
import com.efuture.business.dao.wslf.OrdersPayModelService;
import com.efuture.business.dao.wslf.OrdersUseCouponModelService;
import com.efuture.business.javaPos.struct.orderCentre.OrdersDetailModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersDetailPopModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersExtModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersGainDetailModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersGainModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersMemberModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersPayModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersUseCouponModel;
import com.efuture.business.service.OrderDataLocalService;
import com.efuture.business.util.db.MultipleDataSource;
import com.product.model.ServiceSession;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class OrderDataLocalServiceImpl
implements OrderDataLocalService {
    private static final Logger log = LoggerFactory.getLogger(OrderDataLocalServiceImpl.class);
    @Autowired
    private OrdersModelService orderMapper;
    @Autowired
    private OrdersMemberModelService ordersMemberMapper;
    @Autowired
    private OrdersDetailModelService ordersDetailMapper;
    @Autowired
    private OrdersDetailPopModelService ordersDetailPopMapper;
    @Autowired
    private OrdersGainModelService ordersGainMapper;
    @Autowired
    private OrdersGainDetailModelService ordersGainDetail;
    @Autowired
    private OrdersUseCouponModelService ordersUseCouponMapper;
    @Autowired
    private OrdersPayModelService ordersPayMapper;
    @Autowired
    private OrdersExtModelService ordersExtMapper;

    public RespBase selectOrderAll(ServiceSession session, String billDate, List<String> sheetNoList) {
        String newbillDate = "";
        if (!"".equals(billDate)) {
            newbillDate = billDate.replace("-", "");
        }
        log.info("newbillDate====>" + newbillDate);
        if (!"".equals(newbillDate)) {
            MultipleDataSource.setLocDataSourceKey((String)newbillDate);
        }
        long t1 = System.currentTimeMillis();
        try {
            List orders = this.orderMapper.selectByList(sheetNoList, "orders");
            if (orders.size() == 0) {
                return Code.CODE_60121.getRespBase(new Object[0]);
            }
            ArrayList<CallSite> oids = new ArrayList<CallSite>();
            for (OrdersModel order : orders) {
                oids.add((CallSite)((Object)("" + order.getOid())));
            }
            List ordersDetails = this.ordersDetailMapper.selectByList(oids, "ordersdetail");
            List ordersExts = this.ordersExtMapper.selectByList(oids, "ordersext");
            List ordersMembers = this.ordersMemberMapper.selectByList(oids, "ordersmember");
            List ordersPays = this.ordersPayMapper.selectByList(oids, "orderspay");
            List ordersDetailPops = this.ordersDetailPopMapper.selectByList(oids, "ordersdetailpop");
            List ordersGains = this.ordersGainMapper.selectByList(oids, "ordersgain");
            List ordersGainDetails = this.ordersGainDetail.selectByList(oids, "ordersgaindetail");
            List ordersUseCoupons = this.ordersUseCouponMapper.selectByList(oids, "ordersusecoupon");
            long t2 = System.currentTimeMillis();
            log.info("\u672c\u5730\u8ba2\u5355\u6570\u636e\u5e93[" + billDate + "],\u67e5\u8be2\u8017\u65f6[ms]: " + (t2 - t1));
            JSONArray ordersJson = JSON.parseArray((String)JSON.toJSONString((Object)orders));
            for (Object obj : ordersJson) {
                JSONObject json = (JSONObject)obj;
                json.put("rePrintCnt", (Object)0);
            }
            JSONArray osJson = this.parseOrderResult(ordersDetails, ordersExts, ordersMembers, ordersPays, ordersDetailPops, ordersGains, ordersGainDetails, ordersUseCoupons, ordersJson);
            long t3 = System.currentTimeMillis();
            log.info("\u672c\u5730\u8ba2\u5355\u6570\u636e\u5e93[" + billDate + "],\u7ec4\u88c5\u7ed3\u679c\u8017\u65f6[ms]: " + (t3 - t2));
            return new RespBase(Code.SUCCESS, (Object)osJson);
        }
        catch (Exception e) {
            log.info(e.getMessage(), (Throwable)e);
            log.info("\u67e5\u8be2\u672c\u5730\u8ba2\u5355\u5e93 ERROR:" + e.getMessage());
            return Code.CODE_60028.getRespBase(new Object[]{e.getMessage()});
        }
    }

    public RespBase selectOrderPay(ServiceSession session, JSONObject param) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"payNo", (Object)param.getString("payNo"));
        List orderspay = this.ordersPayMapper.selectList((Wrapper)queryWrapper, "orderspay");
        if (orderspay != null && orderspay.size() > 0) {
            return Code.CODE_50103.getRespBase(new Object[0]);
        }
        return new RespBase(Code.SUCCESS);
    }

    public JSONArray parseOrderResult(List<OrdersDetailModel> ordersDetails, List<OrdersExtModel> ordersExts, List<OrdersMemberModel> ordersMembers, List<OrdersPayModel> ordersPays, List<OrdersDetailPopModel> ordersDetailPops, List<OrdersGainModel> ordersGains, List<OrdersGainDetailModel> ordersGainDetails, List<OrdersUseCouponModel> ordersUseCoupons, JSONArray ordersJson) {
        JSONArray saleorders = new JSONArray();
        for (Object obj : ordersJson) {
            JSONArray array;
            JSONObject osJson = new JSONObject();
            JSONObject order = (JSONObject)obj;
            long oid = order.getLong("oid");
            osJson.put("orders", (Object)order);
            if (ordersDetails.size() > 0) {
                array = new JSONArray();
                for (OrdersDetailModel ordersDetailModel : ordersDetails) {
                    if (oid != ordersDetailModel.getOid()) continue;
                    array.add((Object)ordersDetailModel);
                }
                osJson.put("ordersDetail", (Object)array);
            }
            if (ordersExts.size() > 0) {
                for (OrdersExtModel ordersExtModel : ordersExts) {
                    if (oid != ordersExtModel.getOid()) continue;
                    osJson.put("ordersExt", (Object)ordersExtModel);
                    break;
                }
            }
            if (ordersMembers.size() > 0) {
                for (OrdersMemberModel ordersMemberModel : ordersMembers) {
                    if (oid != ordersMemberModel.getOid()) continue;
                    osJson.put("ordersMember", (Object)ordersMemberModel);
                    break;
                }
            }
            if (ordersPays.size() > 0) {
                array = new JSONArray();
                for (OrdersPayModel ordersPayModel : ordersPays) {
                    if (oid != ordersPayModel.getOid()) continue;
                    array.add((Object)ordersPayModel);
                }
                osJson.put("ordersPay", (Object)array);
            }
            if (ordersDetailPops.size() > 0) {
                array = new JSONArray();
                for (OrdersDetailPopModel ordersDetailPopModel : ordersDetailPops) {
                    if (oid != ordersDetailPopModel.getOid()) continue;
                    array.add((Object)ordersDetailPopModel);
                }
                osJson.put("ordersDetailPop", (Object)array);
            }
            if (ordersGains.size() > 0) {
                array = new JSONArray();
                for (OrdersGainModel ordersGainModel : ordersGains) {
                    if (oid != ordersGainModel.getOid()) continue;
                    array.add((Object)ordersGainModel);
                }
                osJson.put("ordersGain", (Object)array);
            }
            if (ordersGainDetails.size() > 0) {
                array = new JSONArray();
                for (OrdersGainDetailModel ordersGainDetailModel : ordersGainDetails) {
                    if (oid != ordersGainDetailModel.getOid()) continue;
                    array.add((Object)ordersGainDetailModel);
                }
                osJson.put("ordersGainDetail", (Object)array);
            }
            if (ordersUseCoupons.size() > 0) {
                array = new JSONArray();
                for (OrdersUseCouponModel ordersUseCouponModel : ordersUseCoupons) {
                    if (oid != ordersUseCouponModel.getOid()) continue;
                    array.add((Object)ordersUseCouponModel);
                }
                osJson.put("ordersUseCoupon", (Object)array);
            }
            saleorders.add((Object)osJson);
        }
        return saleorders;
    }
}

