/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl.wslf;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.struct.LogisticsModeEnum;
import com.efuture.business.javaPos.struct.mainDataCentre.SaleorgModel;
import com.efuture.business.mapper.wslf.OrderIndexModelMapper;
import com.efuture.business.mapper.wslf.OrderStatisticsMapper;
import com.efuture.business.model.PayModeCache;
import com.efuture.business.service.FunctionRemoteService;
import com.efuture.business.service.OrderStatisticsService;
import com.efuture.business.util.DateHelpUtil;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.db.DbTools;
import com.efuture.business.util.db.MultipleDataSource;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.util.ParamValidateUtil;
import com.product.util.Utils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class OrderStatisticsServiceImpl
implements OrderStatisticsService {
    private static final Logger log = LoggerFactory.getLogger(OrderStatisticsServiceImpl.class);
    @Autowired
    private DbTools dbTools;
    @Autowired
    OrderStatisticsMapper saleOrderStatisticsMapper;
    @Autowired
    OrderIndexModelMapper saleOrderIndexModelMapper;
    @SoaAnnotation(value="/apiFunctionRemoteService.do")
    private FunctionRemoteService functionRemoteService;
    @Value(value="${localcache.enabled}")
    private Boolean localcache;
    @Value(value="${hazelcast.enabled:false}")
    private Boolean hazelcast;
    @Autowired
    protected RedisUtil redisUtil;
    private static final String BUSINESS_CLOSE_TIME = " 05:00:00";

    public RespBase searchTerminalReport(ServiceSession session, JSONObject paramsObject) {
        String[] split;
        ParamValidateUtil.paramCheck((ServiceSession)session, (JSONObject)paramsObject, (String[])new String[]{"createDate", "busiTakeMarketCode", "terminalOperator", "erpCode", "searchType"});
        session.setShop_code(paramsObject.getString("busiTakeMarketCode"));
        int searchType = paramsObject.getIntValue("searchType");
        if (searchType == 3) {
            ParamValidateUtil.paramCheck((ServiceSession)session, (JSONObject)paramsObject, (String[])new String[]{"terminalNo"});
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("busiTakeMarketCode") + paramsObject.getString("terminalNo"));
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String yhqdm = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"YHQDM");
        boolean trainingMode = modeDetailsVo.isTrainingMode();
        if (null != yhqdm && (split = yhqdm.split(",")).length > 1) {
            paramsObject.put("yyqPayCode", (Object)split[0]);
            paramsObject.put("bmqPayCode", (Object)split[1]);
        }
        BigDecimal b = new BigDecimal("0.00");
        JSONObject result = new JSONObject();
        try {
            long t1 = System.currentTimeMillis();
            if (trainingMode) {
                MultipleDataSource.setDataSourceKey((String)"dataSource10");
            } else {
                MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("orders"));
            }
            if (this.localcache.booleanValue() || this.hazelcast.booleanValue()) {
                String s = this.formatBillDate(paramsObject.getDate("createDate"));
                if (StringUtils.isEmpty((Object)s)) {
                    return Code.CODE_60123.getRespBase(new Object[0]);
                }
                log.info("\u8131\u673a\u67e5\u5bfb\u8ba2\u5355\u5217\u8868\u65e5\u671f:" + s);
                MultipleDataSource.setLocDataSourceKey((String)s);
                paramsObject.remove((Object)"createDate");
            } else {
                String createDate = paramsObject.getString("createDate");
                String endDate = OrderStatisticsServiceImpl.computeSaleDate((String)createDate);
                paramsObject.put("endDate", (Object)endDate);
            }
            result = this.report(paramsObject);
            JSONArray syyReport = new JSONArray();
            if (searchType == 2 && "Y".equals(paramsObject.getString("operrange"))) {
                syyReport = this.syyReport(paramsObject);
            } else {
                paramsObject.put("searchType", (Object)3);
                JSONObject j = this.report(paramsObject);
                j.put("terminalOperator", (Object)paramsObject.getString("terminalOperator"));
                syyReport.add((Object)j);
            }
            result.put("syyReport", (Object)syyReport);
            log.info("POS\u603b\u90e8\u67e5\u8be2\u7ec8\u7aef\u65e5\u62a5,\u67e5\u8be2\u7c7b\u578b\uff1a" + searchType + ", \u8fd4\u56de\u6570\u636e: " + result.toJSONString());
            log.error("POS\u603b\u90e8\u67e5\u8be2\u7ec8\u7aef\u65e5\u62a5,\u8017\u65f6[ms]: " + (System.currentTimeMillis() - t1));
            return new RespBase(Code.SUCCESS, (Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            log.error("POS\u603b\u90e8\u67e5\u8be2\u7ec8\u7aef\u65e5\u62a5\u9519\u8bef: " + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            return Code.CODE_60028.getRespBase(new Object[]{e.getMessage()});
        }
    }

    public RespBase searchIntegralReport(ServiceSession session, JSONObject paramsObject) {
        try {
            MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("orders"));
            if (this.localcache.booleanValue() || this.hazelcast.booleanValue()) {
                String s = this.formatBillDate(paramsObject.getDate("createDate"));
                if (StringUtils.isEmpty((Object)s)) {
                    return Code.CODE_60123.getRespBase(new Object[0]);
                }
                log.info("\u8131\u673a\u67e5\u5bfb\u8ba2\u5355\u5217\u8868\u65e5\u671f:" + s);
                MultipleDataSource.setLocDataSourceKey((String)s);
                paramsObject.remove((Object)"createDate");
            } else {
                String createDate = paramsObject.getString("createDate");
                String endDate = OrderStatisticsServiceImpl.computeSaleDate((String)createDate);
                paramsObject.put("endDate", (Object)endDate);
            }
            String obj = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
            List syspara = modeDetailsVo.getSyspara();
            String payCode = ModeDetailsVo.getSysParaValue((List)syspara, (String)"PAS");
            if (StringUtils.isEmpty((Object)payCode)) {
                return new RespBase(Code.CODE_60107.getIndex(), "\u7edf\u8ba1\u79ef\u5206\u62a5\u8868\u5931\u8d25:\u7cfb\u7edf\u53c2\u6570PAS\u672a\u8bbe\u7f6e");
            }
            paramsObject.put("payCode", (Object)payCode);
            paramsObject.put("searchType", (Object)1);
            JSONObject res = new JSONObject();
            res = this.integralReport(paramsObject, res);
            paramsObject.put("searchType", (Object)2);
            res = this.integralReport(paramsObject, res);
            return new RespBase(Code.SUCCESS, (Object)res);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            return new RespBase(Code.CODE_60108.getIndex(), "\u7edf\u8ba1\u79ef\u5206\u62a5\u8868\u5931\u8d25" + Utils.getLastExceptionMessage((Exception)e));
        }
    }

    public RespBase searchGroupReport(ServiceSession session, JSONObject paramsObject) {
        try {
            MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("orders"));
            if (this.localcache.booleanValue() || this.hazelcast.booleanValue()) {
                String s = this.formatBillDate(paramsObject.getDate("createDate"));
                if (StringUtils.isEmpty((Object)s)) {
                    return Code.CODE_60123.getRespBase(new Object[0]);
                }
                log.info("\u8131\u673a\u67e5\u5bfb\u8ba2\u5355\u5217\u8868\u65e5\u671f:" + s);
                MultipleDataSource.setLocDataSourceKey((String)s);
                paramsObject.remove((Object)"createDate");
            } else {
                String createDate = paramsObject.getString("createDate");
                String endDate = OrderStatisticsServiceImpl.computeSaleDate((String)createDate);
                paramsObject.put("endDate", (Object)endDate);
            }
            paramsObject.put("searchType", (Object)1);
            JSONObject res = new JSONObject();
            res = this.groupReport(paramsObject, res);
            paramsObject.put("searchType", (Object)2);
            res = this.groupReport(paramsObject, res);
            return new RespBase(Code.SUCCESS, (Object)res);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            return new RespBase(Code.CODE_60108.getIndex(), "\u7edf\u8ba1\u79ef\u5206\u62a5\u8868\u5931\u8d25" + Utils.getLastExceptionMessage((Exception)e));
        }
    }

    public RespBase searchElectronicReport(ServiceSession session, JSONObject paramsObject) {
        try {
            MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("orders"));
            if (this.localcache.booleanValue() || this.hazelcast.booleanValue()) {
                String s = this.formatBillDate(paramsObject.getDate("createDate"));
                if (StringUtils.isEmpty((Object)s)) {
                    return Code.CODE_60123.getRespBase(new Object[0]);
                }
                log.info("\u8131\u673a\u67e5\u5bfb\u8ba2\u5355\u5217\u8868\u65e5\u671f:" + s);
                MultipleDataSource.setLocDataSourceKey((String)s);
                paramsObject.remove((Object)"createDate");
            } else {
                String createDate = paramsObject.getString("createDate");
                String endDate = OrderStatisticsServiceImpl.computeSaleDate((String)createDate);
                paramsObject.put("endDate", (Object)endDate);
            }
            paramsObject.put("searchType", (Object)1);
            paramsObject.put("payCode", (Object)"05");
            JSONObject res = new JSONObject();
            res = this.electronicReport(paramsObject, res);
            paramsObject.put("searchType", (Object)2);
            res = this.electronicReport(paramsObject, res);
            return new RespBase(Code.SUCCESS, (Object)res);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            return new RespBase(Code.CODE_60108.getIndex(), "\u7edf\u8ba1\u79ef\u5206\u62a5\u8868\u5931\u8d25" + Utils.getLastExceptionMessage((Exception)e));
        }
    }

    private JSONObject groupReport(JSONObject paramsObject, JSONObject res) {
        List report1;
        String type = paramsObject.getString("type");
        JSONObject out = new JSONObject();
        JSONObject orgNames = new JSONObject();
        JSONArray list = new JSONArray();
        JSONArray list1 = new JSONArray();
        ArrayList<String> terminalOperators = new ArrayList<String>();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("status", (Object)1);
        jsonObject.put("shopCode", (Object)paramsObject.getString("shopCode"));
        jsonObject.put("erpCode", (Object)paramsObject.getString("erpCode"));
        List saleorg = new ArrayList();
        try {
            saleorg = this.functionRemoteService.getSaleorg(jsonObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null != saleorg && saleorg.size() > 0) {
            for (SaleorgModel s : saleorg) {
                orgNames.put(s.getOrgCode(), (Object)s.getOrgName());
            }
        }
        if ((report1 = this.saleOrderStatisticsMapper.searchTerminalReport7(paramsObject)) != null && report1.size() > 0) {
            for (Map re : report1) {
                JSONObject j = new JSONObject();
                BigDecimal totalSaleAmt = new BigDecimal("0.00");
                int totalSaleCnt = 0;
                int totalReturnCnt = 0;
                BigDecimal totalReturnAmt = new BigDecimal("0.00");
                BigDecimal totalOuthPay = new BigDecimal("0.00");
                BigDecimal totalDiscountAmt = new BigDecimal("0.00");
                if ("0".equals(type)) {
                    totalSaleCnt = Integer.parseInt(re.get("lsxsCount").toString()) + Integer.parseInt(re.get("ztxsCount").toString());
                    totalSaleAmt = new BigDecimal(re.get("lsxsMoneySum").toString()).add(new BigDecimal(re.get("ztxsMoneySum").toString()));
                    totalReturnCnt = Integer.parseInt(re.get("lsthCount").toString()) + Integer.parseInt(re.get("ztthCount").toString());
                    totalReturnAmt = new BigDecimal(re.get("lsthMoneySum").toString()).add(new BigDecimal(re.get("ztthMoneySum").toString()));
                    totalDiscountAmt = new BigDecimal(re.get("lsxsDiscountSum").toString()).add(new BigDecimal(re.get("ztxsDiscountSum").toString())).subtract(new BigDecimal(re.get("lsthDiscountSum").toString())).subtract(new BigDecimal(re.get("ztthDiscountSum").toString()));
                } else if ("1".equals(type)) {
                    totalSaleCnt = Integer.parseInt(re.get("lsxsCount").toString());
                    totalSaleAmt = new BigDecimal(re.get("lsxsMoneySum").toString());
                    totalReturnCnt = Integer.parseInt(re.get("lsthCount").toString());
                    totalReturnAmt = new BigDecimal(re.get("lsthMoneySum").toString());
                    totalDiscountAmt = new BigDecimal(re.get("lsxsDiscountSum").toString()).subtract(new BigDecimal(re.get("lsthDiscountSum").toString()));
                } else if ("2".equals(type)) {
                    totalSaleCnt = Integer.parseInt(re.get("ztxsCount").toString());
                    totalSaleAmt = new BigDecimal(re.get("ztxsMoneySum").toString());
                    totalReturnCnt = Integer.parseInt(re.get("ztthCount").toString());
                    totalReturnAmt = new BigDecimal(re.get("ztthMoneySum").toString());
                    totalDiscountAmt = new BigDecimal(re.get("ztxsDiscountSum").toString()).subtract(new BigDecimal(re.get("ztthDiscountSum").toString()));
                }
                totalOuthPay = totalSaleAmt.subtract(totalReturnAmt);
                String orgCode = re.get("cabinetGroup").toString();
                j.put("cabinetGroup", (Object)orgCode);
                j.put("orgName", orgNames.get((Object)orgCode) == null ? "" : orgNames.get((Object)orgCode));
                j.put("totalSaleCnt", (Object)totalSaleCnt);
                j.put("totalSaleAmt", (Object)totalSaleAmt);
                j.put("totalReturnCnt", (Object)totalReturnCnt);
                j.put("totalReturnAmt", (Object)totalReturnAmt);
                j.put("totalDiscountAmt", (Object)totalDiscountAmt);
                j.put("totalOuthPay", (Object)totalOuthPay);
                if (paramsObject.getString("searchType").equals("2")) {
                    String terminalOperator = String.valueOf(re.get("terminalOperator"));
                    if (out.containsKey((Object)terminalOperator)) {
                        out.getJSONObject(terminalOperator).getJSONArray("groupReport").add((Object)j);
                        continue;
                    }
                    JSONObject object = new JSONObject();
                    JSONArray report = new JSONArray();
                    report.add((Object)j);
                    object.put("terminalOperator", (Object)terminalOperator);
                    object.put("groupReport", (Object)report);
                    out.put(terminalOperator, (Object)object);
                    terminalOperators.add(terminalOperator);
                    continue;
                }
                list.add((Object)j);
                JSONObject object = new JSONObject();
                object.put("groupReport", (Object)list);
                res.put("syjReport", (Object)object);
            }
            if (paramsObject.getString("searchType").equals("2")) {
                if (null != terminalOperators && terminalOperators.size() > 0) {
                    for (String s : terminalOperators) {
                        list1.add(out.get((Object)s));
                    }
                }
                res.put("syyReport", (Object)list1);
            }
        }
        return res;
    }

    private JSONObject integralReport(JSONObject paramsObject, JSONObject res) {
        BigDecimal totalOuthPay = new BigDecimal("0.00");
        int totalCnt = 0;
        JSONObject out = new JSONObject();
        JSONArray list = new JSONArray();
        JSONArray list1 = new JSONArray();
        ArrayList<String> terminalOperators = new ArrayList<String>();
        List report1 = this.saleOrderStatisticsMapper.searchTerminalReport6(paramsObject);
        if (report1 != null && report1.size() > 0) {
            for (Map re : report1) {
                JSONObject j = new JSONObject();
                BigDecimal outhPay = new BigDecimal(re.get("lsxsMoneySum").toString()).subtract(new BigDecimal(re.get("lsthMoneySum").toString())).subtract(new BigDecimal(re.get("hcxsMoneySum").toString()));
                int cnt = Integer.parseInt(re.get("lsxsCount").toString()) + Integer.parseInt(re.get("lsthCount").toString()) + Integer.parseInt(re.get("hcxsCount").toString());
                j.put("outhPay", (Object)outhPay);
                j.put("cnt", (Object)cnt);
                j.put("batchNo", re.get("batchNo"));
                j.put("monthlyInstallment", re.get("monthlyInstallment"));
                if (paramsObject.getString("searchType").equals("2")) {
                    String terminalOperator = String.valueOf(re.get("terminalOperator"));
                    if (out.containsKey((Object)terminalOperator)) {
                        Integer totalCnt1 = out.getJSONObject(terminalOperator).getInteger("totalCnt") + cnt;
                        BigDecimal totalOuthPay1 = out.getJSONObject(terminalOperator).getBigDecimal("totalOuthPay").add(outhPay);
                        out.getJSONObject(terminalOperator).getJSONArray("integralReport").add((Object)j);
                        out.getJSONObject(terminalOperator).put("totalCnt", (Object)totalCnt1);
                        out.getJSONObject(terminalOperator).put("totalOuthPay", (Object)totalOuthPay1);
                        continue;
                    }
                    JSONObject object = new JSONObject();
                    JSONArray report = new JSONArray();
                    report.add((Object)j);
                    object.put("terminalOperator", (Object)terminalOperator);
                    object.put("integralReport", (Object)report);
                    object.put("totalOuthPay", (Object)outhPay);
                    object.put("totalCnt", (Object)cnt);
                    out.put(terminalOperator, (Object)object);
                    terminalOperators.add(terminalOperator);
                    continue;
                }
                totalOuthPay = totalOuthPay.add(outhPay);
                totalCnt += cnt;
                list.add((Object)j);
                JSONObject object = new JSONObject();
                object.put("integralReport", (Object)list);
                object.put("totalOuthPay", (Object)totalOuthPay);
                object.put("totalCnt", (Object)totalCnt);
                res.put("syjReport", (Object)object);
            }
            if (paramsObject.getString("searchType").equals("2")) {
                if (null != terminalOperators && terminalOperators.size() > 0) {
                    for (String s : terminalOperators) {
                        list1.add(out.get((Object)s));
                    }
                }
                res.put("syyReport", (Object)list1);
            }
        }
        return res;
    }

    private JSONObject electronicReport(JSONObject paramsObject, JSONObject res) {
        BigDecimal totalOuthPay = new BigDecimal("0.00");
        int totalCnt = 0;
        JSONObject out = new JSONObject();
        JSONArray list = new JSONArray();
        JSONArray list1 = new JSONArray();
        ArrayList<String> terminalOperators = new ArrayList<String>();
        List report1 = this.saleOrderStatisticsMapper.searchTerminalReport8(paramsObject);
        log.info("\u7535\u5b50\u5238\u62a5\u8868\u67e5\u8be2\u8fd4\u56de\uff1a" + JSON.toJSONString((Object)report1));
        if (report1 != null && report1.size() > 0) {
            for (Map re : report1) {
                JSONObject j = new JSONObject();
                BigDecimal outhPay = new BigDecimal(re.get("lsxsMoneySum").toString()).subtract(new BigDecimal(re.get("lsthMoneySum").toString())).subtract(new BigDecimal(re.get("hcxsMoneySum").toString()));
                int cnt = Integer.parseInt(re.get("lsxsCount").toString()) + Integer.parseInt(re.get("lsthCount").toString()) + Integer.parseInt(re.get("hcxsCount").toString());
                j.put("outhPay", (Object)outhPay);
                j.put("cnt", (Object)cnt);
                if (StringUtils.isEmpty(re.get("couponType"))) continue;
                j.put("couponType", (Object)this.getCouponName(re.get("couponType").toString()));
                if (paramsObject.getString("searchType").equals("2")) {
                    String terminalOperator = String.valueOf(re.get("terminalOperator"));
                    if (out.containsKey((Object)terminalOperator)) {
                        Integer totalCnt1 = out.getJSONObject(terminalOperator).getInteger("totalCnt") + cnt;
                        BigDecimal totalOuthPay1 = out.getJSONObject(terminalOperator).getBigDecimal("totalOuthPay").add(outhPay);
                        out.getJSONObject(terminalOperator).getJSONArray("electronicReport").add((Object)j);
                        out.getJSONObject(terminalOperator).put("totalCnt", (Object)totalCnt1);
                        out.getJSONObject(terminalOperator).put("totalOuthPay", (Object)totalOuthPay1);
                        continue;
                    }
                    JSONObject object = new JSONObject();
                    JSONArray report = new JSONArray();
                    report.add((Object)j);
                    object.put("terminalOperator", (Object)terminalOperator);
                    object.put("electronicReport", (Object)report);
                    object.put("totalOuthPay", (Object)outhPay);
                    object.put("totalCnt", (Object)cnt);
                    out.put(terminalOperator, (Object)object);
                    terminalOperators.add(terminalOperator);
                    continue;
                }
                totalOuthPay = totalOuthPay.add(outhPay);
                totalCnt += cnt;
                list.add((Object)j);
                JSONObject object = new JSONObject();
                object.put("electronicReport", (Object)list);
                object.put("totalOuthPay", (Object)totalOuthPay);
                object.put("totalCnt", (Object)totalCnt);
                res.put("syjReport", (Object)object);
            }
            if (paramsObject.getString("searchType").equals("2")) {
                if (null != terminalOperators && terminalOperators.size() > 0) {
                    for (String s : terminalOperators) {
                        list1.add(out.get((Object)s));
                    }
                }
                res.put("syyReport", (Object)list1);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceResponse getClearingMachineInfo(ServiceSession session, JSONObject paramsObject) {
        Map dateParam;
        JSONObject param;
        ArrayList<String> ocPays;
        JSONObject result;
        long t1;
        block76: {
            t1 = System.currentTimeMillis();
            ServiceResponse check = ParamValidateUtil.checkParam((ServiceSession)session, (JSONObject)paramsObject, (String[])new String[]{"terminalNo", "terminalOperator", "saleMarket", "shopCode", "loan", "middleCollection", "searchType", "payCode", "mkt"});
            if (!check.getReturncode().equals("0")) {
                return check;
            }
            result = new JSONObject();
            ocPays = new ArrayList<String>();
            ocPays.add("0306");
            ocPays.add("0303");
            ocPays.add("0307");
            result.put("saleMarket", (Object)paramsObject.getString("saleMarket"));
            result.put("terminalNo", (Object)paramsObject.getString("terminalNo"));
            result.put("terminalOperator", (Object)paramsObject.getString("terminalOperator"));
            result.put("shopCode", (Object)paramsObject.getString("shopCode"));
            param = new JSONObject();
            param.put("terminalNo", (Object)paramsObject.getString("terminalNo"));
            dateParam = this.computesClearTime();
            if (dateParam != null) break block76;
            ServiceResponse serviceResponse = ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u8ba1\u7b97 \u6e05\u673a\u5f00\u59cb/\u7ed3\u675f\u65f6\u95f4 \u5931\u8d25");
            return serviceResponse;
        }
        try {
            List ra16;
            param.put("billStartDate", dateParam.get("startTime"));
            param.put("billEndDate", dateParam.get("endTime"));
            param.put("terminalOperator", (Object)paramsObject.getString("terminalOperator"));
            param.put("searchType", (Object)paramsObject.getString("searchType"));
            param.put("marketCode", (Object)paramsObject.getString("mkt"));
            ArrayList<String> exOrderTypeList = new ArrayList<String>();
            exOrderTypeList.add("Y3");
            exOrderTypeList.add("Y9");
            param.put("exOrderTypeList", exOrderTypeList);
            List ra1 = this.saleOrderIndexModelMapper.clearMachine01(param);
            result.put("saleOrderCount", ((Map)ra1.get(0)).get("totalCount"));
            if (ra1 != null && ra1.size() > 0 && !StringUtils.isEmpty(((Map)ra1.get(0)).get("totalMoney"))) {
                result.put("saleOrderMoney", ((Map)ra1.get(0)).get("totalMoney"));
            } else {
                result.put("saleOrderMoney", (Object)0);
            }
            exOrderTypeList.clear();
            param.remove((Object)"exOrderTypeList");
            List ra2 = this.saleOrderIndexModelMapper.clearMachine02(param);
            result.put("returnOrderCount", ((Map)ra2.get(0)).get("totalCount"));
            if (ra2 != null && ra2.size() > 0 && !StringUtils.isEmpty(((Map)ra2.get(0)).get("totalMoney"))) {
                result.put("returnOrderMoney", ((Map)ra2.get(0)).get("totalMoney"));
            } else {
                result.put("returnOrderMoney", (Object)0);
            }
            HashMap stampListInfo = new HashMap();
            exOrderTypeList.add("Y12");
            param.put("exOrderTypeList", exOrderTypeList);
            List ra12 = this.saleOrderIndexModelMapper.clearMachine01(param);
            if (ra12 != null && ra12.size() > 0 && !StringUtils.isEmpty(((Map)ra12.get(0)).get("totalElectronicStamp")) && !StringUtils.isEmpty(((Map)ra12.get(0)).get("totalPhysicalStamp"))) {
                stampListInfo.put("stampPayoutESale", ((Map)ra12.get(0)).get("totalElectronicStamp"));
                stampListInfo.put("stampPayoutPSale", ((Map)ra12.get(0)).get("totalPhysicalStamp"));
            } else {
                stampListInfo.put("stampPayoutESale", 0);
                stampListInfo.put("stampPayoutPSale", 0);
            }
            List ra13 = this.saleOrderIndexModelMapper.clearMachine02(param);
            if (ra13 != null && ra13.size() > 0 && !StringUtils.isEmpty(((Map)ra13.get(0)).get("totalElectronicStamp")) && !StringUtils.isEmpty(((Map)ra13.get(0)).get("totalPhysicalStamp"))) {
                stampListInfo.put("stampPayoutEReturn", ((Map)ra13.get(0)).get("totalElectronicStamp"));
                stampListInfo.put("stampPayoutPReturn", ((Map)ra13.get(0)).get("totalPhysicalStamp"));
            } else {
                stampListInfo.put("stampPayoutEReturn", 0);
                stampListInfo.put("stampPayoutPReturn", 0);
            }
            exOrderTypeList.clear();
            param.remove((Object)"exOrderTypeList");
            result.put("stampPayoutE", (Object)new BigDecimal(stampListInfo.get("stampPayoutESale").toString()).subtract(new BigDecimal(stampListInfo.get("stampPayoutEReturn").toString())));
            result.put("stampPayoutP", (Object)new BigDecimal(stampListInfo.get("stampPayoutPSale").toString()).subtract(new BigDecimal(stampListInfo.get("stampPayoutPReturn").toString())));
            param.remove((Object)"exOrderType");
            param.put("orderType", (Object)"Y12");
            List ra14 = this.saleOrderIndexModelMapper.clearMachine01(param);
            if (ra14 != null && ra14.size() > 0 && !StringUtils.isEmpty(((Map)ra14.get(0)).get("totalElectronicStamp")) && !StringUtils.isEmpty(((Map)ra14.get(0)).get("totalPhysicalStamp"))) {
                result.put("stampRedeemE", ((Map)ra14.get(0)).get("totalElectronicStamp"));
                result.put("stampRedeemP", ((Map)ra14.get(0)).get("totalPhysicalStamp"));
            } else {
                result.put("stampRedeemE", (Object)0);
                result.put("stampRedeemP", (Object)0);
            }
            param.remove((Object)"orderType");
            ArrayList<Integer> modeList = new ArrayList<Integer>();
            modeList.add(LogisticsModeEnum.DCSH.getCode());
            param.put("modeList", modeList);
            List ra3 = this.saleOrderIndexModelMapper.clearMachine01(param);
            List ra9 = this.saleOrderIndexModelMapper.clearMachine06(param);
            result.put("dcOrderCount", ((Map)ra3.get(0)).get("totalCount"));
            if (ra3 != null && ra3.size() > 0 && !StringUtils.isEmpty(((Map)ra3.get(0)).get("totalMoney"))) {
                result.put("dcOrderMoney", ((Map)ra3.get(0)).get("totalMoney"));
            } else {
                result.put("dcOrderMoney", (Object)0);
            }
            if (ra9 != null && ra9.size() > 0 && !StringUtils.isEmpty(((Map)ra9.get(0)).get("totalMoney"))) {
                result.put("dcOrderCount", (Object)new BigDecimal(((Map)ra3.get(0)).get("totalCount").toString()).subtract(new BigDecimal(((Map)ra9.get(0)).get("totalCount").toString())));
                BigDecimal dcOrderMoney = new BigDecimal(result.getString("dcOrderMoney"));
                result.put("dcOrderMoney", (Object)dcOrderMoney.subtract(new BigDecimal("" + ((Map)ra9.get(0)).get("totalMoney"))));
            }
            if (ocPays != null && ocPays.size() > 0) {
                param.put("ocList", ocPays);
            }
            List ra10 = this.saleOrderIndexModelMapper.clearMachine07(param);
            List ra11 = this.saleOrderIndexModelMapper.clearMachine08(param);
            if (ra10 != null && ra10.size() > 0 && !StringUtils.isEmpty(((Map)ra10.get(0)).get("totalMoney"))) {
                result.put("hpBalance", ((Map)ra10.get(0)).get("totalMoney"));
            } else {
                result.put("hpBalance", (Object)0);
            }
            if (ra11 != null && ra11.size() > 0 && !StringUtils.isEmpty(((Map)ra11.get(0)).get("totalMoney"))) {
                BigDecimal hpBalance = new BigDecimal(result.getString("hpBalance"));
                result.put("hpBalance", (Object)hpBalance.subtract(new BigDecimal("" + ((Map)ra10.get(0)).get("totalMoney"))));
            }
            param.remove((Object)"modeList");
            param.remove((Object)"ocList");
            BigDecimal neAmount = new BigDecimal(0);
            if (!StringUtils.isEmpty((Object)result.getString("saleOrderMoney"))) {
                neAmount = neAmount.add(new BigDecimal(result.getString("saleOrderMoney"))).subtract(new BigDecimal(result.getString("returnOrderMoney"))).subtract(new BigDecimal(result.getString("dcOrderMoney")));
            }
            result.put("netSales", (Object)neAmount);
            BigDecimal totalAmountByPay = new BigDecimal(0);
            String hc = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)hc, ModeDetailsVo.class);
            List payInfos = modeDetailsVo.getPaymode();
            ArrayList<String> payTicketList = new ArrayList<String>();
            if (payInfos != null && payInfos.size() > 0) {
                Map<String, Integer> payOthers;
                Object map3;
                List ra4 = this.saleOrderIndexModelMapper.clearMachine03(param);
                List ra15 = this.saleOrderIndexModelMapper.clearMachine09(param);
                ra16 = this.saleOrderIndexModelMapper.clearMachine10(param);
                if (ra15 != null && ra15.size() > 0) {
                    for (Map map2 : ra15) {
                        double i = Double.parseDouble(map2.get("factMoney").toString());
                        map2.put("factMoney", -i);
                    }
                    ra4.addAll(ra15);
                }
                if (ra16 != null && ra16.size() > 0) {
                    ra4.addAll(ra16);
                }
                ArrayList<String> payCodes = new ArrayList<String>();
                Iterator<String> payCodesOther = new ArrayList();
                ArrayList<String> payCreditsList = new ArrayList<String>();
                payCreditsList.add("0301");
                payCreditsList.add("0310");
                payCreditsList.add("0309");
                payCreditsList.add("0308");
                ArrayList<String> payAgingList = new ArrayList<String>();
                payAgingList.add("0303");
                payAgingList.add("0306");
                ArrayList<String> payMicroList = new ArrayList<String>();
                payMicroList.add("0901");
                payMicroList.add("0903");
                for (PayModeCache obj : payInfos) {
                    if (obj.getCode().equals("1")) {
                        payCodes.add(obj.getCode());
                    } else {
                        payCodesOther.add(obj.getCode());
                    }
                    if (!obj.getVirtualPayType().equals("1")) continue;
                    payTicketList.add(obj.getCode());
                }
                payCodesOther.removeAll(payCreditsList);
                payCodesOther.removeAll(payAgingList);
                payCodesOther.removeAll(payMicroList);
                BigDecimal cashAmountByPay = new BigDecimal(0);
                BigDecimal tailPayTotalAmount = new BigDecimal(0);
                HashMap<String, Map<String, Integer>> amountByPay = new HashMap<String, Map<String, Integer>>();
                HashMap<Object, Map<String, Integer>> creditByPay = new HashMap<Object, Map<String, Integer>>();
                HashMap<Object, Map<String, Integer>> agingByPay = new HashMap<Object, Map<String, Integer>>();
                HashMap<Object, Map<String, Integer>> microByPay = new HashMap<Object, Map<String, Integer>>();
                if (ra4 != null && ra4.size() > 0) {
                    for (Object map3 : ra4) {
                        if (StringUtils.isEmpty(map3.get("factMoney"))) continue;
                        BigDecimal money = new BigDecimal(map3.get("factMoney").toString());
                        if (payCodes.contains(map3.get("payCode").toString())) {
                            if (map3.get("flag").toString().equals("1")) {
                                cashAmountByPay = cashAmountByPay.add(money);
                            } else if (map3.get("flag").toString().equals("2")) {
                                cashAmountByPay = cashAmountByPay.subtract(money);
                            }
                        } else if (payCreditsList.contains(map3.get("payCode").toString())) {
                            payName = map3.get("payName").toString();
                            if (creditByPay.containsKey(payName)) {
                                payCredit = (Map)creditByPay.get(payName);
                                payCredit.put("amount", (Integer)((Object)money.add(new BigDecimal(payCredit.get("amount").toString()))));
                                payCredit.put("num", Integer.parseInt(payCredit.get("num").toString()) + 1);
                            } else {
                                payCredit = new HashMap();
                                payCredit.put("amount", (Integer)((Object)money));
                                payCredit.put("num", 1);
                                creditByPay.put(payName, payCredit);
                            }
                        } else if (payAgingList.contains(map3.get("payCode").toString())) {
                            payName = "";
                            if (map3.get("refCode").toString().equals("0")) {
                                payName = map3.get("payName") + " HP";
                            } else {
                                Object refCode = map3.get("refCode").toString();
                                if (((String)refCode).length() == 1) {
                                    refCode = "0" + (String)refCode;
                                }
                                payName = map3.get("payName") + " HP " + (String)refCode;
                            }
                            if (agingByPay.containsKey(payName)) {
                                payAging = (Map)agingByPay.get(payName);
                                payAging.put("amount", (Integer)((Object)money.add(new BigDecimal(payAging.get("amount").toString()))));
                                payAging.put("num", Integer.parseInt(payAging.get("num").toString()) + 1);
                            } else {
                                payAging = new HashMap();
                                payAging.put("amount", (Integer)((Object)money));
                                payAging.put("num", 1);
                                agingByPay.put(payName, payAging);
                            }
                        } else if (payMicroList.contains(map3.get("payCode").toString())) {
                            payName = map3.get("payName").toString();
                            if (microByPay.containsKey(payName)) {
                                payMicro = (Map)microByPay.get(payName);
                                payMicro.put("amount", (Integer)((Object)money.add(new BigDecimal(payMicro.get("amount").toString()))));
                                payMicro.put("num", Integer.parseInt(payMicro.get("num").toString()) + 1);
                            } else {
                                payMicro = new HashMap();
                                payMicro.put("amount", (Integer)((Object)money));
                                payMicro.put("num", 1);
                                microByPay.put(payName, payMicro);
                            }
                        } else if (amountByPay.containsKey(map3.get("payCode").toString())) {
                            payOthers = (Map)amountByPay.get(map3.get("payCode").toString());
                            payOthers.put("amount", (Integer)((Object)money.add(new BigDecimal(payOthers.get("amount").toString()))));
                            payOthers.put("num", Integer.parseInt(payOthers.get("num").toString()) + 1);
                        } else {
                            payOthers = new HashMap();
                            payOthers.put("amount", (Integer)((Object)money));
                            payOthers.put("num", 1);
                            amountByPay.put(map3.get("payCode").toString(), payOthers);
                        }
                        if (map3.get("payCode").toString().equals(paramsObject.getString("payCode"))) {
                            tailPayTotalAmount = tailPayTotalAmount.add(money);
                        }
                        if (map3.get("flag").toString().equals("1")) {
                            totalAmountByPay = totalAmountByPay.add(money);
                            continue;
                        }
                        totalAmountByPay = totalAmountByPay.subtract(money);
                    }
                }
                HashMap<String, Map> amountByPayAll = new HashMap<String, Map>();
                map3 = payCodesOther.iterator();
                while (map3.hasNext()) {
                    String payName = (String)map3.next();
                    if (amountByPay.containsKey(payName)) {
                        amountByPayAll.put(payName, (Map)amountByPay.get(payName));
                        continue;
                    }
                    payOthers = new HashMap<String, Number>();
                    payOthers.put("amount", 0);
                    payOthers.put("num", 0);
                    amountByPayAll.put(payName, payOthers);
                }
                HashMap creditByPayNew = new HashMap();
                creditByPayNew = creditByPay;
                for (String key : creditByPayNew.keySet()) {
                    amountByPayAll.put(key, (Map)creditByPayNew.get(key));
                }
                for (String key : agingByPay.keySet()) {
                    amountByPayAll.put(key, (Map)agingByPay.get(key));
                }
                for (String key : microByPay.keySet()) {
                    amountByPayAll.put(key, (Map)microByPay.get(key));
                }
                result.put("netCash", (Object)cashAmountByPay);
                result.put("amountByPayAll", amountByPayAll);
                result.put("actualMedia", (Object)totalAmountByPay);
                result.put("salesOnCredit", (Object)tailPayTotalAmount);
            } else {
                result.put("netCash", (Object)0);
                result.put("amountByPayAll", (Object)new JSONObject());
                result.put("actualMedia", (Object)0);
                result.put("salesOnCredit", (Object)0);
            }
            List ra5 = this.saleOrderIndexModelMapper.clearMachine04(param);
            if (ra5.get(0) != null && ((Map)ra5.get(0)).toString() != "") {
                result.put("accountPayment", ((Map)ra5.get(0)).get("totalMoney"));
            } else {
                result.put("accountPayment", (Object)0);
            }
            param.put("mode", (Object)"1");
            List ra8 = this.saleOrderIndexModelMapper.clearMachine03(param);
            ra16 = this.saleOrderIndexModelMapper.clearMachine09(param);
            BigDecimal depositsAmount = new BigDecimal(0);
            if (ra8 != null && ra8.size() > 0) {
                for (Map map : ra8) {
                    if (map.get("payCode").toString().equals(paramsObject.getString("payCode"))) continue;
                    depositsAmount = depositsAmount.add(new BigDecimal(map.get("money").toString()));
                }
            }
            if (ra16 != null && ra16.size() > 0) {
                for (Map map : ra16) {
                    if (map.get("payCode").toString().equals(paramsObject.getString("payCode"))) continue;
                    depositsAmount = depositsAmount.subtract(new BigDecimal(map.get("money").toString()));
                }
            }
            param.remove((Object)"mode");
            result.put("depositsAmount", (Object)depositsAmount);
            param.put("orderType", (Object)"Y3");
            List ra6 = this.saleOrderIndexModelMapper.clearMachine01(param);
            if (ra6 != null && ra6.size() > 0 && !StringUtils.isEmpty(((Map)ra6.get(0)).get("totalMoney"))) {
                result.put("octopusAddValue", (Object)((Map)ra6.get(0)).get("totalMoney").toString());
            } else {
                result.put("octopusAddValue", (Object)0);
            }
            param.put("orderType", (Object)"Y9");
            List ra7 = this.saleOrderIndexModelMapper.clearMachine01(param);
            if (ra7 != null && ra7.size() > 0 && !StringUtils.isEmpty(((Map)ra7.get(0)).get("totalMoney"))) {
                result.put("octopusTopUp", (Object)((Map)ra7.get(0)).get("totalMoney").toString());
            } else {
                result.put("octopusTopUp", (Object)0);
            }
            result.put("aeonWalletAddValue", (Object)0);
            BigDecimal mediaTotal = new BigDecimal(0);
            mediaTotal = mediaTotal.add(totalAmountByPay).subtract(new BigDecimal(result.getString("accountPayment"))).subtract(depositsAmount).subtract(new BigDecimal(result.getString("hpBalance"))).subtract(new BigDecimal(result.getString("octopusAddValue"))).subtract(new BigDecimal(result.getString("octopusTopUp")));
            result.put("mediaTotal", (Object)mediaTotal);
            result.put("loan", paramsObject.get((Object)"loan"));
            result.put("middleCollection", paramsObject.get((Object)"middleCollection"));
            result.put("cashOnBook", (Object)new BigDecimal(result.getString("netCash")).add(new BigDecimal(paramsObject.getString("loan"))).subtract(new BigDecimal(paramsObject.getString("middleCollection"))));
            result.put("preCommit", (Object)0);
            result.put("difference", result.get((Object)"cashOnBook"));
            if (paramsObject.getString("searchType").equals("2") && payTicketList.size() > 0) {
                param.put("ticketList", payTicketList);
                List ra15 = this.saleOrderIndexModelMapper.clearMachine05(param);
                if (ra15 != null && ra15.size() > 0 && !StringUtils.isEmpty(((Map)ra15.get(0)).get("totalMoney"))) {
                    result.put("couponTotalMoney", ((Map)ra15.get(0)).get("totalMoney"));
                } else {
                    result.put("couponTotalMoney", (Object)0);
                }
            }
            log.info("\u6e05\u673a\u8fd4\u56de\u7ed3\u679c : " + result);
            log.info("\u6e05\u673a\u8017\u65f6\uff1a " + (System.currentTimeMillis() - t1));
            ServiceResponse serviceResponse = ServiceResponse.buildSuccess((Object)result);
            return serviceResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            ServiceResponse serviceResponse = ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)e.getMessage());
            return serviceResponse;
        }
    }

    public String formatBillDate(Date createDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        try {
            return dateFormat.format(createDate);
        }
        catch (Exception e) {
            log.error("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38: " + e.getMessage());
            return null;
        }
    }

    private Map<String, String> computesClearTime() {
        HashMap<String, String> param = new HashMap<String, String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            String todayDate = DateHelpUtil.getTodayDate();
            String businessCloseDate = todayDate + " 05:00:00";
            String nowTime = DateHelpUtil.nowToString((String)"yyyy-MM-dd HH:mm:ss");
            if (sdf.parse(nowTime).after(sdf.parse(businessCloseDate))) {
                param.put("startTime", todayDate + " 05:00:00");
            } else {
                param.put("startTime", DateHelpUtil.getYestoryDate() + " 05:00:00");
            }
            param.put("endTime", nowTime);
            System.out.println(param);
            return param;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public JSONArray syyReport(JSONObject paramsObject) {
        BigDecimal b = new BigDecimal("0.00");
        JSONArray out = new JSONArray();
        List report1 = this.saleOrderStatisticsMapper.searchTerminalReport11(paramsObject);
        List report2 = this.saleOrderStatisticsMapper.searchTerminalReport12(paramsObject);
        List report3 = this.saleOrderStatisticsMapper.searchTerminalReport13(paramsObject);
        if (report1 != null && report1.size() > 0) {
            for (Map re : report1) {
                JSONObject j = new JSONObject();
                if (!StringUtils.isEmpty(re.get("lsxsCount"))) {
                    j.put("totalSaleCnt", (Object)Integer.parseInt(re.get("lsxsCount").toString()));
                } else {
                    j.put("totalSaleCnt", (Object)0);
                }
                if (!StringUtils.isEmpty(re.get("lsxsMoneySum"))) {
                    j.put("totalSaleAmt", (Object)new BigDecimal(re.get("lsxsMoneySum").toString()));
                } else {
                    j.put("totalSaleAmt", (Object)b);
                }
                if (!StringUtils.isEmpty(re.get("lsthCount"))) {
                    j.put("totalReturnCnt", (Object)Integer.parseInt(re.get("lsthCount").toString()));
                } else {
                    j.put("totalReturnCnt", (Object)0);
                }
                if (!StringUtils.isEmpty(re.get("lsthMoneySum")) && new BigDecimal(re.get("lsthMoneySum").toString()).compareTo(new BigDecimal("0")) > 0) {
                    j.put("totalReturnAmt", (Object)new BigDecimal("-" + re.get("lsthMoneySum")));
                } else {
                    j.put("totalReturnAmt", (Object)b);
                }
                if (!StringUtils.isEmpty(re.get("hcxsCount"))) {
                    j.put("totalHcSaleCnt", (Object)Integer.parseInt(re.get("hcxsCount").toString()));
                } else {
                    j.put("totalHcSaleCnt", (Object)0);
                }
                if (!StringUtils.isEmpty(re.get("hcxsMoneySum")) && new BigDecimal(re.get("hcxsMoneySum").toString()).compareTo(new BigDecimal("0")) > 0) {
                    j.put("totalHcSaleAmt", (Object)new BigDecimal("-" + re.get("hcxsMoneySum")));
                } else {
                    j.put("totalHcSaleAmt", (Object)b);
                }
                BigDecimal totalOuthPay = j.getBigDecimal("totalSaleAmt").add(j.getBigDecimal("totalReturnAmt")).add(j.getBigDecimal("totalHcSaleAmt"));
                j.put("totalOughtPay", (Object)totalOuthPay);
                String terminalOperator = String.valueOf(re.get("terminalOperator"));
                if (report2 != null && report2.size() > 0) {
                    for (Map re2 : report2) {
                        j.put("overageCnt", (Object)0);
                        j.put("overageAmt", (Object)b);
                        if (!terminalOperator.equals(String.valueOf(re2.get("terminalOperator")))) continue;
                        int ovgCount = 0;
                        BigDecimal ovgMoney = new BigDecimal(0);
                        if (!StringUtils.isEmpty(re2.get("lsxsOvgCount"))) {
                            ovgCount += Integer.parseInt(re2.get("lsxsOvgCount").toString());
                        }
                        if (!StringUtils.isEmpty(re2.get("hcxsOvgCount"))) {
                            ovgCount += Integer.parseInt(re2.get("hcxsOvgCount").toString());
                        }
                        if (!StringUtils.isEmpty(re2.get("lsthOvgCount"))) {
                            ovgCount += Integer.parseInt(re2.get("lsthOvgCount").toString());
                        }
                        if (!StringUtils.isEmpty(re2.get("lsxsOvgMoney"))) {
                            ovgMoney = ovgMoney.add(new BigDecimal(re2.get("lsxsOvgMoney").toString()));
                        }
                        if (!StringUtils.isEmpty(re2.get("hcxsOvgMoney"))) {
                            ovgMoney = ovgMoney.subtract(new BigDecimal(re2.get("hcxsOvgMoney").toString()));
                        }
                        if (!StringUtils.isEmpty(re2.get("lsthOvgMoney"))) {
                            ovgMoney = ovgMoney.subtract(new BigDecimal(re2.get("lsthOvgMoney").toString()));
                        }
                        j.put("overageCnt", (Object)ovgCount);
                        j.put("overageAmt", (Object)ovgMoney);
                    }
                } else {
                    j.put("overageCnt", (Object)0);
                    j.put("overageAmt", (Object)b);
                }
                JSONArray payReportFinal = new JSONArray();
                JSONArray cashPayFinal = new JSONArray();
                if (report3 != null && report3.size() > 0) {
                    JSONObject payDe;
                    JSONArray payReport = JSON.parseArray((String)JSON.toJSONString((Object)report3));
                    JSONArray payReportByPaying = new JSONArray();
                    JSONArray payReportByChange = new JSONArray();
                    for (Object payObj : payReport) {
                        payDe = (JSONObject)payObj;
                        if (!terminalOperator.equals(payDe.getString("terminalOperator"))) continue;
                        if (payDe.getIntValue("flag") == 1) {
                            payReportByPaying.add((Object)payDe);
                            continue;
                        }
                        if (payDe.getIntValue("flag") != 2) continue;
                        payReportByChange.add((Object)payDe);
                    }
                    HashMap<String, JSONObject> payReportByChangeMap = new HashMap<String, JSONObject>();
                    BigDecimal zlAmt = new BigDecimal("0.00");
                    int zlCnt = 0;
                    if (payReportByChange.size() > 0) {
                        for (Object payObj : payReportByChange) {
                            payDe = (JSONObject)payObj;
                            zlAmt = zlAmt.add(payDe.getBigDecimal("lsxsMoneySum")).subtract(payDe.getBigDecimal("hcxsMoneySum")).subtract(payDe.getBigDecimal("lsthMoneySum"));
                            zlCnt += payDe.getInteger("lsxsCount") + payDe.getIntValue("hcxsCount") + payDe.getIntValue("lsthCount");
                            payReportByChangeMap.put(payDe.getString("payCode"), payDe);
                        }
                    }
                    j.put("zlCnt", (Object)zlCnt);
                    j.put("zlAmt", (Object)zlAmt);
                    if (payReportByPaying.size() > 0) {
                        Object payObj;
                        payObj = payReportByPaying.iterator();
                        while (payObj.hasNext()) {
                            Object payObj2 = payObj.next();
                            payDe = (JSONObject)payObj2;
                            if (!payReportByChangeMap.containsKey(payDe.getString("payCode"))) continue;
                            JSONObject payChange = (JSONObject)payReportByChangeMap.get(payDe.getString("payCode"));
                            payDe.put("lsxsMoneySum", (Object)payDe.getBigDecimal("lsxsMoneySum").subtract(payChange.getBigDecimal("lsxsMoneySum")));
                            payDe.put("hcxsMoneySum", (Object)payDe.getBigDecimal("hcxsMoneySum").subtract(payChange.getBigDecimal("hcxsMoneySum")));
                            payDe.put("lsthMoneySum", (Object)payDe.getBigDecimal("lsthMoneySum").subtract(payChange.getBigDecimal("lsthMoneySum")));
                        }
                    }
                    BigDecimal totalExistPay = new BigDecimal("0.00");
                    if (payReportByPaying.size() > 0) {
                        for (Object payObj : payReportByPaying) {
                            JSONObject payFinal = new JSONObject();
                            payDe = (JSONObject)payObj;
                            if (payDe.getString("payType").equals("0")) {
                                cashPayFinal.add((Object)payDe);
                            }
                            BigDecimal totalAmt = new BigDecimal(0);
                            int totalCnt = payDe.getIntValue("lsxsCount") + payDe.getIntValue("hcxsCount") + payDe.getIntValue("lsthCount");
                            totalAmt = totalAmt.add(payDe.getBigDecimal("lsxsMoneySum")).subtract(payDe.getBigDecimal("hcxsMoneySum")).subtract(payDe.getBigDecimal("lsthMoneySum"));
                            payFinal.put("payType", (Object)payDe.getString("payType"));
                            payFinal.put("payCode", (Object)payDe.getString("payCode"));
                            payFinal.put("payName", (Object)payDe.getString("payName"));
                            payFinal.put("totalCnt", (Object)totalCnt);
                            payFinal.put("totalAmt", (Object)totalAmt);
                            payReportFinal.add((Object)payFinal);
                            totalExistPay = totalExistPay.add(totalAmt);
                        }
                    }
                    j.put("totalExistPay", (Object)totalExistPay);
                } else {
                    j.put("zlCnt", (Object)0);
                    j.put("zlAmt", (Object)b);
                    j.put("totalExistPay", (Object)b);
                }
                j.put("payReport", (Object)payReportFinal);
                j.put("terminalOperator", (Object)terminalOperator);
                out.add((Object)j);
            }
        }
        return out;
    }

    public JSONObject report(JSONObject paramsObject) {
        BigDecimal b = new BigDecimal("0.00");
        JSONObject result = new JSONObject();
        List report1 = this.saleOrderStatisticsMapper.searchTerminalReport1(paramsObject);
        if (report1 != null && report1.size() > 0 && report1.get(0) != null) {
            if (!StringUtils.isEmpty(((Map)report1.get(0)).get("lsxsCount"))) {
                result.put("totalSaleCnt", (Object)Integer.parseInt(((Map)report1.get(0)).get("lsxsCount").toString()));
            } else {
                result.put("totalSaleCnt", (Object)0);
            }
            if (!StringUtils.isEmpty(((Map)report1.get(0)).get("lsxsMoneySum"))) {
                result.put("totalSaleAmt", (Object)new BigDecimal(((Map)report1.get(0)).get("lsxsMoneySum").toString()));
            } else {
                result.put("totalSaleAmt", (Object)b);
            }
            if (!StringUtils.isEmpty(((Map)report1.get(0)).get("lsthCount"))) {
                result.put("totalReturnCnt", (Object)Integer.parseInt(((Map)report1.get(0)).get("lsthCount").toString()));
            } else {
                result.put("totalReturnCnt", (Object)0);
            }
            if (!StringUtils.isEmpty(((Map)report1.get(0)).get("lsthMoneySum")) && new BigDecimal(((Map)report1.get(0)).get("lsthMoneySum").toString()).compareTo(new BigDecimal("0")) > 0) {
                result.put("totalReturnAmt", (Object)new BigDecimal("-" + ((Map)report1.get(0)).get("lsthMoneySum")));
            } else {
                result.put("totalReturnAmt", (Object)b);
            }
            if (!StringUtils.isEmpty(((Map)report1.get(0)).get("hcxsCount"))) {
                result.put("totalHcSaleCnt", (Object)Integer.parseInt(((Map)report1.get(0)).get("hcxsCount").toString()));
            } else {
                result.put("totalHcSaleCnt", (Object)0);
            }
            if (!StringUtils.isEmpty(((Map)report1.get(0)).get("hcxsMoneySum")) && new BigDecimal(((Map)report1.get(0)).get("hcxsMoneySum").toString()).compareTo(new BigDecimal("0")) > 0) {
                result.put("totalHcSaleAmt", (Object)new BigDecimal("-" + ((Map)report1.get(0)).get("hcxsMoneySum")));
            } else {
                result.put("totalHcSaleAmt", (Object)b);
            }
            BigDecimal totalOuthPay = result.getBigDecimal("totalSaleAmt").add(result.getBigDecimal("totalReturnAmt")).add(result.getBigDecimal("totalHcSaleAmt"));
            result.put("totalOughtPay", (Object)totalOuthPay);
        } else {
            result.put("totalSaleCnt", (Object)0);
            result.put("totalSaleAmt", (Object)b);
            result.put("totalReturnCnt", (Object)0);
            result.put("totalReturnAmt", (Object)b);
            result.put("totalHcSaleCnt", (Object)0);
            result.put("totalHcSaleAmt", (Object)b);
            result.put("totalOughtPay", (Object)b);
        }
        List report2 = this.saleOrderStatisticsMapper.searchTerminalReport2(paramsObject);
        if (report2 != null && report2.size() > 0 && report2.get(0) != null && !StringUtils.isEmpty(((Map)report2.get(0)).get("erpCode"))) {
            int ovgCount = 0;
            BigDecimal ovgMoney = new BigDecimal(0);
            if (!StringUtils.isEmpty(((Map)report2.get(0)).get("lsxsOvgCount"))) {
                ovgCount += Integer.parseInt(((Map)report2.get(0)).get("lsxsOvgCount").toString());
            }
            if (!StringUtils.isEmpty(((Map)report2.get(0)).get("hcxsOvgCount"))) {
                ovgCount += Integer.parseInt(((Map)report2.get(0)).get("hcxsOvgCount").toString());
            }
            if (!StringUtils.isEmpty(((Map)report2.get(0)).get("lsthOvgCount"))) {
                ovgCount += Integer.parseInt(((Map)report2.get(0)).get("lsthOvgCount").toString());
            }
            if (!StringUtils.isEmpty(((Map)report2.get(0)).get("lsxsOvgMoney"))) {
                ovgMoney = ovgMoney.add(new BigDecimal(((Map)report2.get(0)).get("lsxsOvgMoney").toString()));
            }
            if (!StringUtils.isEmpty(((Map)report2.get(0)).get("hcxsOvgMoney"))) {
                ovgMoney = ovgMoney.subtract(new BigDecimal(((Map)report2.get(0)).get("hcxsOvgMoney").toString()));
            }
            if (!StringUtils.isEmpty(((Map)report2.get(0)).get("lsthOvgMoney"))) {
                ovgMoney = ovgMoney.subtract(new BigDecimal(((Map)report2.get(0)).get("lsthOvgMoney").toString()));
            }
            result.put("overageCnt", (Object)ovgCount);
            result.put("overageAmt", (Object)ovgMoney);
        } else {
            result.put("overageCnt", (Object)0);
            result.put("overageAmt", (Object)b);
        }
        JSONArray payReportFinal = new JSONArray();
        List report3 = this.saleOrderStatisticsMapper.searchTerminalReport3(paramsObject);
        JSONArray cashPayFinal = new JSONArray();
        if (report3 != null && report3.size() > 0 && report3.get(0) != null) {
            JSONObject payDe;
            JSONArray payReport = JSON.parseArray((String)JSON.toJSONString((Object)report3));
            JSONArray payReportByPaying = new JSONArray();
            JSONArray payReportByChange = new JSONArray();
            for (Object payObj : payReport) {
                payDe = (JSONObject)payObj;
                if (payDe.getIntValue("flag") == 1) {
                    payReportByPaying.add((Object)payDe);
                    continue;
                }
                if (payDe.getIntValue("flag") != 2) continue;
                payReportByChange.add((Object)payDe);
            }
            HashMap<String, JSONObject> payReportByChangeMap = new HashMap<String, JSONObject>();
            BigDecimal zlAmt = new BigDecimal("0.00");
            int zlCnt = 0;
            if (payReportByChange.size() > 0) {
                for (Object payObj : payReportByChange) {
                    payDe = (JSONObject)payObj;
                    zlAmt = zlAmt.add(payDe.getBigDecimal("lsxsMoneySum")).subtract(payDe.getBigDecimal("hcxsMoneySum")).subtract(payDe.getBigDecimal("lsthMoneySum"));
                    zlCnt += payDe.getInteger("lsxsCount") + payDe.getIntValue("hcxsCount") + payDe.getIntValue("lsthCount");
                    payReportByChangeMap.put(payDe.getString("payCode"), payDe);
                }
            }
            result.put("zlCnt", (Object)zlCnt);
            result.put("zlAmt", (Object)zlAmt);
            if (payReportByPaying.size() > 0) {
                for (Object payObj : payReportByPaying) {
                    payDe = (JSONObject)payObj;
                    if (!payReportByChangeMap.containsKey(payDe.getString("payCode"))) continue;
                    JSONObject payChange = (JSONObject)payReportByChangeMap.get(payDe.getString("payCode"));
                    payDe.put("lsxsMoneySum", (Object)payDe.getBigDecimal("lsxsMoneySum").subtract(payChange.getBigDecimal("lsxsMoneySum")));
                    payDe.put("hcxsMoneySum", (Object)payDe.getBigDecimal("hcxsMoneySum").subtract(payChange.getBigDecimal("hcxsMoneySum")));
                    payDe.put("lsthMoneySum", (Object)payDe.getBigDecimal("lsthMoneySum").subtract(payChange.getBigDecimal("lsthMoneySum")));
                }
            }
            BigDecimal totalExistPay = new BigDecimal("0.00");
            if (payReportByPaying.size() > 0) {
                for (Object payObj : payReportByPaying) {
                    JSONObject payFinal = new JSONObject();
                    payDe = (JSONObject)payObj;
                    if (payDe.getString("payType").equals("0")) {
                        cashPayFinal.add((Object)payDe);
                    }
                    BigDecimal totalAmt = new BigDecimal(0);
                    int totalCnt = payDe.getIntValue("lsxsCount") + payDe.getIntValue("hcxsCount") + payDe.getIntValue("lsthCount");
                    totalAmt = totalAmt.add(payDe.getBigDecimal("lsxsMoneySum")).subtract(payDe.getBigDecimal("hcxsMoneySum")).subtract(payDe.getBigDecimal("lsthMoneySum"));
                    payFinal.put("payType", (Object)payDe.getString("payType"));
                    payFinal.put("payCode", (Object)payDe.getString("payCode"));
                    payFinal.put("payName", (Object)payDe.getString("payName"));
                    payFinal.put("totalCnt", (Object)totalCnt);
                    payFinal.put("totalAmt", (Object)totalAmt);
                    payReportFinal.add((Object)payFinal);
                    totalExistPay = totalExistPay.add(totalAmt);
                }
            }
            result.put("totalExistPay", (Object)totalExistPay);
        } else {
            result.put("zlCnt", (Object)0);
            result.put("zlAmt", (Object)b);
            result.put("totalExistPay", (Object)b);
        }
        result.put("payReport", (Object)payReportFinal);
        return result;
    }

    public static String computeSaleDate(String start) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(dateFormat.parse(start));
            calendar.add(5, 1);
            String date = dateFormat.format(calendar.getTime());
            return date;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getCouponName(String couponType) {
        String couponName = "";
        switch (couponType) {
            case "50": {
                couponName = "\u793c\u5238";
                break;
            }
            case "51": {
                couponName = "\u7535\u5b50\u5238";
                break;
            }
            case "52": {
                couponName = "\u6e38\u620f\u8d60\u5238";
                break;
            }
            case "55": {
                couponName = "\u63d0\u8d27\u5238";
                break;
            }
            case "60": {
                couponName = "\u8d2d\u7269\u8d60\u5238";
                break;
            }
            case "65": {
                couponName = "\u79ef\u5206\u8fd4\u5229\u5238";
                break;
            }
            case "66": {
                couponName = "\u79ef\u5206\u63d0\u8d27\u5355";
            }
        }
        return couponName;
    }
}

