/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.localize;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.SellType;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.Convert;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PopDetail;
import com.efuture.business.javaPos.struct.orderCentre.OrdersModel;
import com.efuture.business.javaPos.struct.request.PayConfirmIn;
import com.efuture.business.model.Syjmain;
import com.efuture.business.service.impl.wslf.OrderCheckServiceImpl;
import com.efuture.business.util.ArrayUtils;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.DateHelpUtil;
import com.efuture.business.util.LocalUtil;
import com.product.model.ServiceSession;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class OrderCheckServiceImpl_SJGW
extends OrderCheckServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(OrderCheckServiceImpl_SJGW.class);

    public RespBase checkSaleBalance(ServiceSession session, PayConfirmIn in, CacheModel cacheModel) {
        if (StringUtils.isEmpty((Object)cacheModel.getOrder())) {
            return Code.CODE_60031.getRespBase(new Object[]{"\u8ba2\u5355\u6570\u636e\u4e0d\u5b58\u5728"});
        }
        String splitodevalue = "";
        try {
            Order order = cacheModel.getOrder();
            List orderDetails = cacheModel.getGoodsList();
            String splitcode = "posshop:log:" + order.getShopCode();
            log.info("redis\u5206\u5e93\u7801key\u503c\uff1a" + splitcode);
            if (this.redisUtil.hasKey(splitcode)) {
                splitodevalue = (String)this.redisUtil.hget(splitcode, "splitCode");
                log.info("shardingcode Value : " + splitodevalue);
            }
            if (this.localcache.booleanValue()) {
                LocalUtil.checkTodayDatabase();
            }
            List orderPays = cacheModel.getPayments();
            Object maxterminalSno = "";
            String obj = this.redisUtil.get(RedisKey.CACHEID + order.getShopCode() + order.getTerminalNo());
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("busiTakeMarketCode", order.getShopCode());
            map1.put("terminalNo", order.getTerminalNo());
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)splitodevalue)) {
                map1.put("shardingCode", splitodevalue);
            }
            if (!this.localcache.booleanValue()) {
                String today = this.computeBillDateForSearch(new Date());
                map1.put("today", today);
                String yesterday = DateHelpUtil.getYestoryDate((String)today);
                map1.put("yesterday", yesterday);
            }
            int xpws = cacheModel.getOrder().getSysPara().getXpws();
            int fphmMode = cacheModel.getOrder().getSysPara().getFphmMode();
            StringBuffer sb = new StringBuffer();
            if (xpws > 0) {
                if (fphmMode == 1) {
                    xpws += 6;
                }
                map1.put("xpws", xpws);
                for (int i = 0; i < xpws; ++i) {
                    sb.append("9");
                }
            }
            if (null != (maxterminalSno = this.orderMapper.getMaxTerminalSno(map1, "orders", modeDetailsVo.isTrainingMode()))) {
                if (xpws > 0 && Long.valueOf((String)maxterminalSno) >= CastUtil.castLong((Object)sb)) {
                    Syjmain syjmain = new Syjmain();
                    syjmain.setMkt(order.getShopCode());
                    syjmain.setErpCode(cacheModel.getOrder().getErpCode());
                    syjmain.setSyjh(order.getTerminalNo());
                    try {
                        syjObj = this.syjmainRemoteService.selectOneByMKTAndSYJ(syjmain);
                        if (null != syjObj) {
                            maxterminalSno = String.valueOf(syjObj.getSyjcurnum());
                            log.info("\u5f53\u524d\u6536\u94f6\u673a\u5c0f\u7968\u53f7:" + (String)maxterminalSno);
                        } else {
                            maxterminalSno = cacheModel.getOrder().getTerminalSno();
                        }
                    }
                    catch (Exception e) {
                        maxterminalSno = cacheModel.getOrder().getTerminalSno();
                    }
                    if (null != maxterminalSno && Long.valueOf((String)maxterminalSno) >= CastUtil.castLong((Object)sb)) {
                        return Code.CODE_60034.getRespBase(new Object[]{xpws});
                    }
                }
            } else {
                Syjmain syjmain = new Syjmain();
                syjmain.setMkt(order.getShopCode());
                syjmain.setErpCode(cacheModel.getOrder().getErpCode());
                syjmain.setSyjh(order.getTerminalNo());
                try {
                    syjObj = this.syjmainRemoteService.selectOneByMKTAndSYJ(syjmain);
                    if (null != syjObj) {
                        maxterminalSno = String.valueOf(syjObj.getSyjcurnum());
                        log.info("\u5f53\u524d\u6536\u94f6\u673a\u5c0f\u7968\u53f7:" + (String)maxterminalSno);
                    } else {
                        maxterminalSno = cacheModel.getOrder().getTerminalSno();
                    }
                }
                catch (Exception e) {
                    maxterminalSno = cacheModel.getOrder().getTerminalSno();
                }
                if (null != maxterminalSno && xpws > 0) {
                    String maxFphm = maxterminalSno;
                    if (1 == modeDetailsVo.getSysparainfo().getFphmMode() && maxFphm.length() > 6) {
                        maxFphm = maxFphm.substring(6);
                    }
                    if (Long.parseLong(maxFphm) >= CastUtil.castLong((Object)sb)) {
                        return Code.CODE_60034.getRespBase(new Object[]{xpws});
                    }
                }
            }
            log.info(">>>maxterminalSno:{}", maxterminalSno);
            double oriTotalDiscountValue = 0.0;
            double qtyTotal = 0.0;
            ArrayList popDetails = new ArrayList();
            for (Goods orderDetail : cacheModel.getGoodsList()) {
                if (orderDetail.getIsNoBackGift()) continue;
                if (!Double.isNaN(orderDetail.getAdjustDiscountValue()) && orderDetail.getAdjustDiscountValue() != 0.0) {
                    oriTotalDiscountValue = ManipulatePrecision.add((double)oriTotalDiscountValue, (double)orderDetail.getAdjustDiscountValue());
                }
                if (!Double.isNaN(orderDetail.getPopDiscountValue()) && orderDetail.getPopDiscountValue() != 0.0) {
                    oriTotalDiscountValue = ManipulatePrecision.add((double)oriTotalDiscountValue, (double)orderDetail.getPopDiscountValue());
                }
                if (!Double.isNaN(orderDetail.getCustomDiscountValue()) && orderDetail.getCustomDiscountValue() != 0.0) {
                    oriTotalDiscountValue = ManipulatePrecision.add((double)oriTotalDiscountValue, (double)orderDetail.getCustomDiscountValue());
                }
                if (!Double.isNaN(orderDetail.getPayDiscountValue()) && orderDetail.getPayDiscountValue() != 0.0) {
                    oriTotalDiscountValue = ManipulatePrecision.add((double)oriTotalDiscountValue, (double)orderDetail.getPayDiscountValue());
                }
                if (!Double.isNaN(orderDetail.getMealDiscountValue()) && orderDetail.getMealDiscountValue() != 0.0) {
                    oriTotalDiscountValue = ManipulatePrecision.add((double)oriTotalDiscountValue, (double)orderDetail.getMealDiscountValue());
                }
                if (!Double.isNaN(orderDetail.getStudentCardDiscountValue()) && orderDetail.getStudentCardDiscountValue() != 0.0) {
                    oriTotalDiscountValue = ManipulatePrecision.add((double)oriTotalDiscountValue, (double)orderDetail.getStudentCardDiscountValue());
                }
                qtyTotal += orderDetail.getQty();
                if (orderDetail.getPopDetailsInfo().size() <= 0) continue;
                popDetails.addAll(orderDetail.getPopDetailsInfo());
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            String terminalSno = order.getTerminalSno();
            if (null != in.getNewTerminalSno() && !in.getNewTerminalSno().equals("")) {
                terminalSno = in.getNewTerminalSno();
            }
            queryWrapper.eq((Object)"busiTakeMarketCode", (Object)order.getShopCode());
            queryWrapper.eq((Object)"terminalNo", (Object)order.getTerminalNo());
            queryWrapper.eq((Object)"terminalSno", (Object)terminalSno);
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)splitodevalue)) {
                queryWrapper.eq((Object)"shardingCode", (Object)splitodevalue);
            }
            List saleOrdersModels = this.orderMapper.selectList((Wrapper)queryWrapper, "orders", modeDetailsVo.isTrainingMode());
            log.info("checkSaleBalance=====>" + in.getNewTerminalSno());
            if (ArrayUtils.isNotEmpty((List)saleOrdersModels)) {
                if (saleOrdersModels.size() > 1 || !((OrdersModel)saleOrdersModels.get(0)).getPosId().equals(order.getFlowNo())) {
                    log.info("\u8ba2\u5355\u4e0a\u4f20\u5904\u7406-\u6700\u7ec8\u6821\u9a8c,\u5c0f\u7968\u53f7\u5df2\u5b58\u5728:" + order.getTerminalSno());
                    if (1 == modeDetailsVo.getSysparainfo().getFphmMode()) {
                        maxterminalSno = order.getTerminalSno().substring(0, 6) + Convert.increaseCharForward((String)maxterminalSno, (char)'0', (int)modeDetailsVo.getSysparainfo().getXpws());
                    }
                    return new RespBase(Code.CODE_60006, maxterminalSno, in.getFlowNo());
                }
            } else if (in.getNewTerminalSno() != null && !in.getNewTerminalSno().equals("")) {
                cacheModel.getOrder().setTerminalSno(in.getNewTerminalSno());
            }
            if (ManipulatePrecision.sub((double)oriTotalDiscountValue, (double)order.getTotalDiscountValue()) != 0.0) {
                return Code.CODE_60031.getRespBase(new Object[]{"\u4fc3\u9500\u6570\u636e\u4e0d\u76f8\u7b49"});
            }
            log.info("\u68c0\u67e5\u5b9e\u4ed8\u91d1\u989d\u548c\u5e94\u4ed8\u91d1\u989d\u662f\u5426\u76f8\u7b49");
            double factPay = ManipulatePrecision.sub((double)order.getExistPay(), (double)order.getChangeValue());
            double ougthPay = ManipulatePrecision.doubleConvert((double)(order.getOughtPay() + order.getOverageValue()));
            if (ManipulatePrecision.doubleCompare((double)factPay, (double)ougthPay, (int)2) != 0) {
                log.info("factPay==>{},ougthPay==>{}", (Object)factPay, (Object)ougthPay);
                return Code.CODE_60031.getRespBase(new Object[]{"\u5b9e\u4ed8\u91d1\u989d\u548c\u5e94\u4ed8\u91d1\u989d\u4e0d\u5339\u914d"});
            }
            log.info("\u68c0\u67e5\u5546\u54c1\u884c\u6570\u636e\u662f\u5426\u76f8\u7b49");
            double detailOugthPay = 0.0;
            if (orderDetails != null && orderDetails.size() != 0) {
                for (Goods orderDe : orderDetails) {
                    detailOugthPay = ManipulatePrecision.add((double)detailOugthPay, (double)orderDe.getSaleAmount());
                }
            } else {
                return Code.CODE_60031.getRespBase(new Object[]{"\u5546\u54c1\u884c\u7a7a"});
            }
            log.info("ougthPay:" + order.getOughtPay());
            if (ManipulatePrecision.doubleCompare((double)detailOugthPay, (double)(order.getOughtPay() + order.getRoundUpOverageValue()), (int)2) != 0) {
                log.info("detailOugthPay===>{},order.getOughtPay()==>{},order.getRoundUpOverageValue()==>{}", new Object[]{detailOugthPay, order.getOughtPay(), order.getRoundUpOverageValue()});
                return Code.CODE_60031.getRespBase(new Object[]{"\u5b9e\u4ed8\u91d1\u989d\u548c\u5546\u54c1\u603b\u989d\u4e0d\u5339\u914d"});
            }
            log.info("\u68c0\u67e5\u4ed8\u6b3e\u884c\u91d1\u989d=====>");
            double detailPayAll = 0.0;
            if (orderPays != null && orderPays.size() > 0) {
                for (Payment pay : orderPays) {
                    if ("1".equals(pay.getFlag())) {
                        detailPayAll = ManipulatePrecision.add((double)detailPayAll, (double)pay.getMoney());
                        continue;
                    }
                    if (!"2".equals(pay.getFlag())) continue;
                    detailPayAll = ManipulatePrecision.sub((double)detailPayAll, (double)pay.getMoney());
                }
            } else {
                return Code.CODE_60031.getRespBase(new Object[]{"\u652f\u4ed8\u884c\u7a7a"});
            }
            if (ManipulatePrecision.doubleCompare((double)detailPayAll, (double)ougthPay, (int)2) != 0) {
                return Code.CODE_60031.getRespBase(new Object[]{"\u4ed8\u6b3e\u884c\u603b\u91d1\u989d\u548c\u4ed8\u6b3e\u603b\u989d\u4e0d\u5339\u914d"});
            }
            log.info("\u6821\u9a8c\u5546\u54c1\u4fc3\u9500\u884c\u548c\u5546\u54c1\u884c\u4fc3\u9500\u662f\u5426\u5339\u914d=====>");
            if (popDetails.size() > 0) {
                for (Goods orderDetail : orderDetails) {
                    double totalDiscount = ManipulatePrecision.sub((double)orderDetail.getTotalDiscountValue(), (double)orderDetail.getCouponValue());
                    log.info("totalDiscount:{}", (Object)totalDiscount);
                    String orderType = order.getOrderType();
                    if (!(!SellType.ISSALE((String)orderType) || SellType.NOPOP((String)cacheModel.getOrder().getOrderType()) || SellType.isGroupbuy((String)cacheModel.getOrder().getOrderType(), (boolean)cacheModel.getOrder().getHasGroupBuy()) || cacheModel.getPopMode() != 1 && cacheModel.getPopMode() != 2 && cacheModel.getPopMode() != 3)) {
                        log.info("AdjustDiscountValue:{},StudentCardDiscountValue:{},CustomDiscountValue:{},BarcodeDiscount:{}", new Object[]{orderDetail.getAdjustDiscountValue(), orderDetail.getStudentCardDiscountValue(), orderDetail.getCustomDiscountValue(), orderDetail.getBarcodeDiscount()});
                        totalDiscount = ManipulatePrecision.sub((double)totalDiscount, (double)orderDetail.getAdjustDiscountValue());
                        totalDiscount = ManipulatePrecision.sub((double)totalDiscount, (double)orderDetail.getStudentCardDiscountValue());
                        totalDiscount = ManipulatePrecision.sub((double)totalDiscount, (double)orderDetail.getCustomDiscountValue());
                        totalDiscount = ManipulatePrecision.add((double)totalDiscount, (double)orderDetail.getBarcodeDiscount());
                        totalDiscount = ManipulatePrecision.add((double)totalDiscount, (double)orderDetail.getCustomDiscountValue());
                    }
                    log.info("totalDiscount:{}", (Object)totalDiscount);
                    double totalPops = 0.0;
                    if (orderDetail.getPopDetailsInfo().size() > 0) {
                        for (PopDetail popDetail : orderDetail.getPopDetailsInfo()) {
                            totalPops = ManipulatePrecision.add((double)totalPops, (double)popDetail.getDiscountAmount());
                        }
                    }
                    log.info("totalPops:{}", (Object)totalPops);
                    if (ManipulatePrecision.doubleCompare((double)totalDiscount, (double)totalPops, (int)2) == 0) continue;
                    return Code.CODE_60031.getRespBase(new Object[]{"\u5546\u54c1\u884c\u6298\u6263\u6570\u636e\u4e0d\u76f8\u7b49"});
                }
            }
            return Code.SUCCESS.getRespBase(new Object[0]);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Code.CODE_60031.getRespBase(new Object[]{"\u53d1\u751f\u5f02\u5e38" + e.getMessage()});
        }
    }
}

