/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.localize;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.dao.wslf.BinCardModelService;
import com.efuture.business.dao.wslf.EdcBankModelService;
import com.efuture.business.dao.wslf.EdcPaymentModelService;
import com.efuture.business.exception.EfutureException;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.orderCentre.EdcBankModel;
import com.efuture.business.javaPos.struct.orderCentre.EdcPaymentModel;
import com.efuture.business.javaPos.struct.orderCentre.request.OrderQueryIn;
import com.efuture.business.javaPos.struct.request.GetOrderIn;
import com.efuture.business.javaPos.struct.request.SaleReturnQueryIn;
import com.efuture.business.service.localize.OrderSaleBSImpl_WSLF;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.ParamsValidateUtil;
import com.product.model.ServiceSession;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class OrderSaleBSImpl_ERAJAYA
extends OrderSaleBSImpl_WSLF {
    private static final Logger log = LoggerFactory.getLogger(OrderSaleBSImpl_ERAJAYA.class);
    @Autowired
    private BinCardModelService binCardModelService;
    @Autowired
    private EdcBankModelService edcBankModelService;
    @Autowired
    private EdcPaymentModelService edcPaymentModelService;

    public RespBase saleReturnQuery(ServiceSession session, ResqVo vo) {
        RespBase respBase = this.returnQuery(session, vo);
        if (Code.SUCCESS.getIndex() != respBase.getRetflag()) {
            return respBase;
        }
        CacheModel cacheModel = vo.getCacheModel();
        Order order = cacheModel.getOrder();
        String obj = this.redisUtil.get(RedisKey.CACHEID + order.getShopCode() + order.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String thsj = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"THSJ");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String originSaleDate = order.getOriginSaleDate();
        try {
            int i = Integer.parseInt(thsj);
            Date startDate = dateFormat.parse(originSaleDate);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startDate);
            calendar.add(5, i + 1);
            if (calendar.getTime().before(new Date())) {
                return Code.CODE_60140.getRespBase(new Object[]{thsj});
            }
        }
        catch (Exception e) {
            log.info("\u6821\u9a8c\u65f6\u95f4\u53d1\u751f\u5f02\u5e38\uff0c\u4e0d\u63a7\u5236\u65f6\u95f4");
        }
        return respBase;
    }

    public RespBase returnQuery(ServiceSession session, ResqVo vo) {
        try {
            JSONObject paramsObject = vo.getJsonObject();
            ParamsValidateUtil paramsValidateUtil = new ParamsValidateUtil(session, paramsObject);
            if (!paramsValidateUtil.validate()) {
                return paramsValidateUtil.getRespBase();
            }
            SaleReturnQueryIn saleReturnQueryIn = (SaleReturnQueryIn)JSON.parseObject((String)paramsObject.toJSONString(), SaleReturnQueryIn.class);
            CacheModel cacheModel = vo.getCacheModel();
            if (null == cacheModel) {
                return Code.CODE_60003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
            }
            OrderQueryIn orderQueryIn = new OrderQueryIn();
            if ("2".equals(cacheModel.getOrder().getOrderType())) {
                orderQueryIn.setSearchType(1);
            } else {
                orderQueryIn.setSearchType(2);
            }
            if (StringUtils.isBlank((String)saleReturnQueryIn.getPosId())) {
                return Code.CODE_60001.getRespBase(new Object[]{"posId"});
            }
            String[] split = saleReturnQueryIn.getPosId().split("\\.");
            if (split.length < 5) {
                Order order = cacheModel.getOrder();
                String obj = this.redisUtil.get(RedisKey.CACHEID + order.getShopCode() + order.getTerminalNo());
                ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
                String xpws = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"XPWS");
                String kjws = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"KJWS");
                if (StringUtils.isBlank((String)xpws) || CastUtil.castInt((Object)xpws) < 1) {
                    return Code.CODE_50129.getRespBase(new Object[]{"XPWS"});
                }
                int i = CastUtil.castInt((Object)xpws);
                if (StringUtils.isBlank((String)kjws) || CastUtil.castInt((Object)xpws) < 1) {
                    return Code.CODE_50129.getRespBase(new Object[]{"KJWS"});
                }
                int j = CastUtil.castInt((Object)kjws);
                String posId = saleReturnQueryIn.getPosId();
                orderQueryIn.setBusiTakeMarketCode(posId.substring(0, posId.length() - i - j));
                orderQueryIn.setTerminalNo(posId.substring(posId.length() - i - j, posId.length() - i));
                orderQueryIn.setTerminalSno(posId.substring(posId.length() - i));
            } else {
                orderQueryIn.setTerminalNo(split[3]);
                orderQueryIn.setBusiTakeMarketCode(split[0]);
                orderQueryIn.setPosId(saleReturnQueryIn.getPosId());
            }
            orderQueryIn.setCreateDate(saleReturnQueryIn.getBillDate());
            return this.getReturnOrder(session, paramsObject, saleReturnQueryIn, cacheModel, orderQueryIn);
        }
        catch (EfutureException e) {
            throw e;
        }
        catch (Exception e) {
            log.info("\u8c03\u7528\u8ba2\u5355\u5f02\u5e38", (Throwable)e);
            return Code.CODE_60007.getRespBase(new Object[]{e.getMessage()});
        }
    }

    public RespBase getOrder(ServiceSession session, GetOrderIn getOrderIn) {
        try {
            if (StringUtils.isBlank((String)getOrderIn.getPosId())) {
                return Code.CODE_60001.getRespBase(new Object[]{"posId"});
            }
            OrderQueryIn in = new OrderQueryIn();
            in.setBusiTakeMarketCode(getOrderIn.getShopCode());
            in.setTerminalNo(getOrderIn.getTerminalNo());
            String[] split = getOrderIn.getPosId().split("\\.");
            if (split.length < 5) {
                String obj = this.redisUtil.get(RedisKey.CACHEID + getOrderIn.getShopCode() + getOrderIn.getTerminalNo());
                ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
                String xpws = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"XPWS");
                if (StringUtils.isBlank((String)xpws) || CastUtil.castInt((Object)xpws) < 1) {
                    return Code.CODE_50129.getRespBase(new Object[]{"XPWS"});
                }
                int i = CastUtil.castInt((Object)xpws);
                in.setTerminalSno(getOrderIn.getPosId().substring(getOrderIn.getPosId().length() - i));
            } else {
                in.setPosId(getOrderIn.getPosId());
            }
            in.setCreateDate(getOrderIn.getBillDate());
            in.setSearchType(getOrderIn.getSearchType());
            if (StringUtils.isNotBlank((String)getOrderIn.getShardingCode())) {
                in.setShardingCode(getOrderIn.getShardingCode());
            }
            return this.getOrder(session, getOrderIn, in);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u8c03\u7528\u8ba2\u5355\u5f02\u5e38", (Throwable)e);
            return new RespBase(Code.CODE_60007.getIndex(), e.getMessage());
        }
    }

    public RespBase getBinCardInfo(ServiceSession session, JSONObject paramsObject) {
        if (StringUtils.isBlank((String)paramsObject.getString("shopCode"))) {
            return Code.CODE_60001.getRespBase(new Object[]{"shopCode"});
        }
        JSONObject j = new JSONObject();
        j.put("binNumber", (Object)paramsObject.getString("binNumber"));
        List binCardModels = this.binCardModelService.selectByMap((Map)j, "orders");
        if (null == binCardModels || binCardModels.size() == 0) {
            return Code.CODE_60145.getRespBase(new Object[0]);
        }
        return new RespBase(Code.SUCCESS, binCardModels.get(0));
    }

    public RespBase getBankInfo(ServiceSession session, JSONObject paramsObject) {
        if (StringUtils.isBlank((String)paramsObject.getString("shopCode"))) {
            return Code.CODE_60001.getRespBase(new Object[]{"shopCode"});
        }
        JSONObject j = new JSONObject();
        j.put("binNumber", (Object)paramsObject.getString("binNumber"));
        List edcBankModels = this.edcBankModelService.selectList((Wrapper)new QueryWrapper(), "orders");
        if (null == edcBankModels || edcBankModels.size() == 0) {
            return Code.CODE_60146.getRespBase(new Object[0]);
        }
        List edcPaymentModels = this.edcPaymentModelService.selectList((Wrapper)new QueryWrapper(), "orders");
        if (null == edcPaymentModels || edcPaymentModels.size() == 0) {
            return Code.CODE_60146.getRespBase(new Object[0]);
        }
        for (EdcBankModel edcBankModel : edcBankModels) {
            ArrayList<EdcPaymentModel> list1 = new ArrayList<EdcPaymentModel>();
            for (EdcPaymentModel edcPaymentModel : edcPaymentModels) {
                if (edcBankModel.getId() != edcPaymentModel.getBankId()) continue;
                list1.add(edcPaymentModel);
            }
            edcBankModel.setBankPayment(list1);
        }
        return new RespBase(Code.SUCCESS, (Object)edcBankModels);
    }
}

