/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.localize;

import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.dao.gzyy.OrderPaymentDao;
import com.efuture.business.exception.EfutureException;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.model.CheckBackFLQOutDto;
import com.efuture.business.model.CheckBackFLQParamDto;
import com.efuture.business.model.Syspara;
import com.efuture.business.service.localize.OrderSaleBSImpl_WSLF;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class OrderSaleBSImpl_GZYY
extends OrderSaleBSImpl_WSLF {
    private static final Logger log = LoggerFactory.getLogger(OrderSaleBSImpl_GZYY.class);
    @Autowired
    private OrderPaymentDao orderPaymentDao;

    protected CacheModel checkRedrush(CacheModel cacheModel, String accreditNo, ModeDetailsVo modeDetailsVo) {
        if (!"2".equals(cacheModel.getOrder().getOrderType())) {
            return cacheModel;
        }
        List paymentList = cacheModel.getReturnPayments();
        boolean isCheckAccreditNo = false;
        for (Payment payment : paymentList) {
            if (!"MZK".equals(payment.getPayMemo())) continue;
            isCheckAccreditNo = true;
        }
        if (!isCheckAccreditNo) {
            return cacheModel;
        }
        List sysparaList = modeDetailsVo.getSyspara();
        String accreditNoC2 = "";
        for (Syspara syspara : sysparaList) {
            if (!"C2".equals(syspara.getCode())) continue;
            accreditNoC2 = syspara.getParavalue();
        }
        if (StringUtils.isEmpty((String)accreditNoC2)) {
            throw new EfutureException(Code.CODE_60045.getRespBase(new Object[0]));
        }
        if (!accreditNoC2.equals(accreditNo)) {
            throw new EfutureException(new RespBase(-1, "\u5f53\u524d\u6536\u94f6\u5458\u6216\u6388\u6743\u4eba\u5458\u4fe1\u606f\u65e0\u6cd5\u627e\u5230"));
        }
        return cacheModel;
    }

    protected String checkPayment(CacheModel cacheModel) {
        try {
            if (!"2".equals(cacheModel.getOrder().getOrderType()) && !"4".equals(cacheModel.getOrder().getOrderType())) {
                return "";
            }
            Order order = cacheModel.getOrder();
            CheckBackFLQParamDto checkBackFLQParamDto = new CheckBackFLQParamDto();
            checkBackFLQParamDto.setVfphm(Long.valueOf(order.getOriginTerminalSno()));
            checkBackFLQParamDto.setVmkt(order.getShopCode());
            checkBackFLQParamDto.setVsyjh(order.getTerminalNo());
            checkBackFLQParamDto.setVsyyh(order.getTerminalOperator());
            CheckBackFLQOutDto checkBackFLQOutDto = this.orderPaymentDao.checkPayment(checkBackFLQParamDto);
            if ("N".equals(checkBackFLQOutDto.getRstatus())) {
                if (StringUtils.isEmpty((String)checkBackFLQOutDto.getRmsg())) {
                    if ("2".equals(cacheModel.getOrder().getOrderType())) {
                        throw new EfutureException(Code.CODE_60028.getRespBase(new Object[]{"\u6709\u5238\u6263\u56de\u4e0d\u5141\u8bb8\u7ea2\u51b2"}));
                    }
                    if ("4".equals(cacheModel.getOrder().getOrderType())) {
                        throw new EfutureException(Code.CODE_60028.getRespBase(new Object[]{"\u6709\u5238\u6263\u56de\u4e0d\u5141\u8bb8\u9000\u8d27"}));
                    }
                }
                throw new EfutureException(Code.CODE_60028.getRespBase(new Object[]{"\u4e0d\u5141\u8bb8\u9000\u8d27/\u7ea2\u51b2[" + checkBackFLQOutDto.getRmsg() + "]"}));
            }
            return checkBackFLQOutDto.getRmsg();
        }
        catch (EfutureException e) {
            throw e;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return e.getMessage();
        }
    }

    protected boolean checkOrderType(String oldOrderType, String orderType) {
        return oldOrderType.equals(orderType);
    }
}

