/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.localize;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.bean.YPopStatusType;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.exception.EfutureException;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Coupon;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.OrderForPos;
import com.efuture.business.javaPos.struct.OrderGains;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PrintInfo;
import com.efuture.business.javaPos.struct.myshopr10.R10BackCoupon;
import com.efuture.business.javaPos.struct.myshopr10.R10BackRebate;
import com.efuture.business.javaPos.struct.myshopr10.R10Order;
import com.efuture.business.javaPos.struct.myshopr10.RectR10Info;
import com.efuture.business.javaPos.struct.myshopr10.SaveR10Info;
import com.efuture.business.javaPos.struct.orderCentre.OrderStateEnum;
import com.efuture.business.javaPos.struct.orderCentre.OrdersDetailModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersDetailPopModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersPayModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrders;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrders_WSLF;
import com.efuture.business.javaPos.struct.orderCentre.response.SaveOrdersOut;
import com.efuture.business.javaPos.struct.promotionCentre.SellCoupon;
import com.efuture.business.javaPos.struct.promotionCentre.request.CouponuseConsumeIn;
import com.efuture.business.javaPos.struct.response.PayConfirmOut;
import com.efuture.business.service.R10PayRemoteService;
import com.efuture.business.service.localize.OrderSaleBSImpl_WSLF;
import com.efuture.business.util.ArrayUtils;
import com.efuture.business.util.HttpClientUtil;
import com.efuture.business.util.HttpUtils;
import com.efuture.business.util.TransformationUtils;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderSaleBSImpl_MSR10
extends OrderSaleBSImpl_WSLF {
    private static final Logger log = LoggerFactory.getLogger(OrderSaleBSImpl_MSR10.class);
    private static String INSERTORDERALL = "order.online.save.execute";
    private static String SALEPOINTGET = "sale.point.get";
    private static String SALEPOINTSAVE = "sale.point.save";
    private static String SALEPOINTREV = "sale.coupon.reversal";
    private static String GETTOKEN = "auth.token.create";
    @SoaAnnotation(value="/apiR10PayRemoteService.do")
    private R10PayRemoteService r10PayRemoteService;

    public RespBase payConfirm(ServiceSession session, ResqVo vo) {
        RespBase respBase = super.payConfirm(session, vo);
        log.info("\u8ba2\u5355\u5b8c\u6210\u8fd4\u56de!");
        return respBase;
    }

    protected CacheModel saveSaleReturnOrder(CacheModel cacheModel, ServiceSession session, String newTerminalSno, String splitCode, String netType) {
        SaveR10Info saveR10Info;
        RespBase respBase;
        log.info(">>>>>>>>>>saveSaleReturnOrder>>>>>>>>>>>");
        ServiceResponse response = null;
        RespBase sp = new RespBase();
        String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        boolean trainingMode = modeDetailsVo.isTrainingMode();
        log.info(">>>>>>>>>>trainingMode>>>>>>>>>>>" + trainingMode);
        if (!(trainingMode || cacheModel.getPopMode() != 1 && cacheModel.getPopMode() != 2 || "2".equals(cacheModel.getOrder().getOrderType()))) {
            RespBase respBase2;
            if (cacheModel.getPayConfirmStatus() != 0 && (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 2)) {
                response = this.couponConsume(cacheModel, session, cacheModel.getPayConfirmStatus().intValue(), netType);
                if (null == response.getData() || "".equals(response.getData().toString())) {
                    cacheModel.setCalcResult(-1);
                    cacheModel.setErrCode(response.getReturncode());
                    cacheModel.setErrMsg(response.getData().toString());
                    return cacheModel;
                }
                if (!"0".equals(response.getReturncode())) {
                    cacheModel.setCalcResult(-1);
                    cacheModel.setErrCode(response.getReturncode());
                    cacheModel.setErrMsg(response.getData().toString());
                    return cacheModel;
                }
            }
            log.info("\u51b2\u6b63\u540e\u7684cacheResult{} ,errCode{} ,errmsg{} ,", new Object[]{cacheModel.getCalcResult(), cacheModel.getErrCode(), cacheModel.getErrMsg()});
            CouponuseConsumeIn couponuseConsumeIn = new CouponuseConsumeIn();
            couponuseConsumeIn.setBillno(cacheModel.getOrder().getFlowNo());
            couponuseConsumeIn.setChannel(cacheModel.getOrder().getChannel());
            couponuseConsumeIn.setCalcBillId(cacheModel.getOrder().getSeqNo());
            couponuseConsumeIn.setSaveorder("N");
            List couponPayments = this.posLogicCompoment.getCouponPayments(cacheModel.getPayments());
            if (couponPayments != null && couponPayments.size() != 0) {
                couponuseConsumeIn.setSellPayments(this.paymentTransfer.transferSellPayment(couponPayments, SellType.ISBACK((String)cacheModel.getOrder().getOrderType())));
                couponuseConsumeIn.setType("0");
                cacheModel.callMarketClear();
                respBase2 = this.couponRemoteService.couponAndPointsConsume(session, cacheModel, couponuseConsumeIn, netType);
                log.info("\u8425\u9500\u51b2\u6b63\u8fd4\u56de==>{}", (Object)JSONObject.toJSONString((Object)respBase2));
                if (0 != respBase2.getRetflag()) {
                    List reversePayments = couponuseConsumeIn.getSellPayments();
                    cacheModel.setReversePayments(reversePayments);
                    response = this.couponConsume(cacheModel, session, 5, netType);
                    cacheModel.setCalcResult(-1);
                    cacheModel.setErrCode(response.getReturncode());
                    if (null == response.getData() || "".equals(response.getData().toString())) {
                        cacheModel.setErrMsg(response.getData().toString());
                    } else {
                        cacheModel.setErrMsg(response.getData().toString());
                    }
                    return cacheModel;
                }
            }
            log.info("\u6838\u9500\u540e\u7684cacheResult{} ,errCode{} ,errmsg{} ,", new Object[]{cacheModel.getCalcResult(), cacheModel.getErrCode(), cacheModel.getErrMsg()});
            if (!(!StringUtils.isNotBlank((String)cacheModel.getOrder().getOriginSeqNo()) || SellType.isGroupbuy((String)cacheModel.getOrder().getOrderType(), (boolean)cacheModel.getOrder().getHasGroupBuy()) || SellType.isDfSale((String)cacheModel.getOrder().getOrderType()) || cacheModel.getPopMode() != 1 && cacheModel.getPopMode() != 2 && cacheModel.getPopMode() != 3)) {
                respBase2 = this.calcPopRemoteService.calcCouponGain(session, cacheModel, netType, newTerminalSno);
                log.info("\u53d1\u9001\u5230\u8425\u9500\u4e2d\u5fc3\u4fdd\u5b58\u8ba2\u5355\u8fd4\u56de==>{}", (Object)JSONObject.toJSONString((Object)respBase2));
                if (0 != respBase2.getRetflag()) {
                    cacheModel.setCalcResult(-1);
                    cacheModel.setErrMsg(Code.CODE_60138.getMsg() + respBase2.getRetmsg());
                    return cacheModel;
                }
                cacheModel = (CacheModel)respBase2.getData();
            }
        }
        List coupons = cacheModel.getOrder().getCouponDetails();
        double point = 0.0;
        if (ArrayUtils.isNotEmpty((List)coupons)) {
            for (Coupon coupon : coupons) {
                if (!"JFA".equals(coupon.getCouponType()) && !"JFXF".equals(coupon.getCouponType())) continue;
                log.info("coupon.getCouponType()==>{}", (Object)coupon.getAmount());
                point += coupon.getAmount();
            }
        }
        log.info(">>>>>>>>>>>>>\u9000\u8d27\u989d\u5916\u79ef\u5206\u79ef\u5206point==>{}", (Object)point);
        log.info(">>>>>>>>>>>>>\u9000\u8d27\u989d\u5916\u79ef\u5206cacheModel.getOrder().getTotalPoint()==>{}", (Object)cacheModel.getOrder().getTotalPoint());
        cacheModel.getOrder().setTotalPoint(ManipulatePrecision.add((double)point, (double)cacheModel.getOrder().getTotalPoint()));
        if (cacheModel.getOrder().getConsumersData() != null && cacheModel.getOrder().getConsumersData().getConsumersCard() != null && ("2".equals(cacheModel.getOrder().getConsumersData().getCustType()) || "GRP".equals(cacheModel.getOrder().getConsumersData().getConsumersType()))) {
            log.info("\u9000\u8d27\u4f1a\u5458\u4ea4\u6613\u6570\u636e\u4e0a\u9001");
            this.giveOrReverse(session, cacheModel);
        }
        if (null != newTerminalSno && newTerminalSno.length() > 0) {
            cacheModel = this.posLogicService.RefreshTerminalSno(cacheModel, newTerminalSno);
        }
        SaleOrders order = this.orderTransfer.saleOrdersFromCacheModel(cacheModel);
        if (null != splitCode && !"".equals(splitCode)) {
            order.getSaleOrders().setShardingCode(splitCode);
        }
        order.getSaleOrders().setOrderState(Integer.valueOf(OrderStateEnum.T_YWC.getCode()));
        if (!trainingMode && "2".equals(netType) && null != cacheModel.getOrder().getConsumersData() && null != cacheModel.getOrder().getConsumersData().getConsumersCard() && 0 != (respBase = this.saveR10BackRebate(session, saveR10Info = new SaveR10Info(cacheModel))).getRetflag()) {
            order.getSaleOrders().setExtendFt1("R10BackRebateFail");
        }
        if (!trainingMode && null != cacheModel.getOrder().getConsumersData() && null != cacheModel.getOrder().getConsumersData().getConsumersCard()) {
            for (Payment payment1 : cacheModel.getPayments()) {
                if (!"R10POINT".equals(payment1.getPayMemo()) && !"R10POINTVIRTUE".equals(payment1.getPayMemo())) continue;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("seqno", (Object)payment1.getRefCode());
                if ("2".equals(cacheModel.getOrder().getOrderType())) {
                    jsonObject.put("type", (Object)"02");
                }
                if ("4".equals(cacheModel.getOrder().getOrderType())) {
                    jsonObject.put("type", (Object)"03");
                }
                jsonObject.put("shopCode", (Object)cacheModel.getOrder().getShopCode());
                jsonObject.put("terminalNo", (Object)cacheModel.getOrder().getTerminalNo());
                jsonObject.put("terminalOperator", (Object)cacheModel.getOrder().getTerminalOperator());
                jsonObject.put("flowNo", (Object)cacheModel.getOrder().getFlowNo());
                jsonObject.put("terminalSno", (Object)cacheModel.getOrder().getTerminalSno());
                jsonObject.put("consumersCard", (Object)cacheModel.getOrder().getConsumersData().getConsumersCard());
                jsonObject.put("payCode", (Object)payment1.getPayCode());
                if ("R10POINTVIRTUE".equals(payment1.getPayMemo())) {
                    jsonObject.put("point", (Object)payment1.getCashCost());
                } else {
                    jsonObject.put("point", (Object)payment1.getAmount());
                }
                jsonObject.put("amount", (Object)payment1.getMoney());
                log.info("\u79ef\u5206\u51b2\u6b63\u63a5\u53e3\uff1a" + jsonObject.toJSONString());
                RespBase respBase3 = this.r10PayRemoteService.pointConsume(session, null, jsonObject);
                log.info("\u79ef\u5206\u51b2\u6b63\u63a5\u53e3\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)respBase3));
                if (0 == respBase3.getRetflag()) continue;
                order.getSaleOrders().setExtendFt1("R10BackPointFail");
            }
        }
        if (!trainingMode && !this.localcache.booleanValue()) {
            TransformationUtils util = new TransformationUtils();
            SaleOrders_WSLF saleOrders = util.saleOrdersToSaleOrders_WSLF(order);
            HashMap<String, SaleOrders_WSLF> map = new HashMap<String, SaleOrders_WSLF>();
            map.put("data", saleOrders);
            ServiceResponse rs = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, INSERTORDERALL, session, JSON.toJSONString(map), SaveOrdersOut.class, "\u8ba2\u5355\u4e2d\u5fc3", "\u4fdd\u5b58\u8ba2\u5355");
            sp.setRetflag(Integer.parseInt(rs.getReturncode()));
            sp.setData(rs.getData());
        } else {
            sp = this.orderPosUploadService.receiveOrderUpload(session, order, netType);
        }
        SaveOrdersOut saveOrdersOut = null;
        String sheetNo = "";
        if (!"0".equals(String.valueOf(sp.getRetflag())) && !"1".equals(String.valueOf(sp.getRetflag()))) {
            if ("101".equals(String.valueOf(sp.getRetflag())) || "201".equals(String.valueOf(sp.getRetflag()))) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("2002");
                cacheModel.setErrMsg(cacheModel.getOrder().getTerminalSno());
                try {
                    saveOrdersOut = (SaveOrdersOut)JSON.parseObject((String)sp.getData().toString(), SaveOrdersOut.class);
                    String terminalSno = saveOrdersOut.getTerminalSno();
                    String serviceSno = "";
                    ServiceResponse sNoResponse = new ServiceResponse();
                    if (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 2 || cacheModel.getPopMode() == 3) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.couponConsume(cacheModel, session, cacheModel.getPayConfirmStatus().intValue(), netType);
                    }
                    if (StringUtils.isNotBlank((String)terminalSno)) {
                        serviceSno = terminalSno;
                        sNoResponse.setReturncode("2002");
                        sNoResponse.setData((Object)serviceSno);
                        this.couponConsume(cacheModel, session, 8, netType);
                        cacheModel.setCalcResult(-1);
                        cacheModel.setErrCode("2002");
                        cacheModel.setErrMsg(serviceSno);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return cacheModel;
            }
            if (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 2 || cacheModel.getPopMode() == 3) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.couponConsume(cacheModel, session, cacheModel.getPayConfirmStatus().intValue(), netType);
            }
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("100000");
            cacheModel.setErrMsg(Code.CODE_60135.getMsg() + sp.getData().toString());
            return cacheModel;
        }
        saveOrdersOut = (SaveOrdersOut)JSON.parseObject((String)JSONObject.toJSONString((Object)sp.getData()), SaveOrdersOut.class);
        sheetNo = saveOrdersOut.getSheetNo();
        Order o = cacheModel.getOrder();
        if (this.excuteZuul(String.valueOf(sp.getRetflag()), sheetNo, o.getOrderType(), o.getTerminalSno(), o.getExistPay())) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode(String.valueOf(sp.getRetflag()));
            if (null == sp.getData() || "".equals(sp.getData().toString())) {
                cacheModel.setErrMsg(sp.getData().toString());
            } else {
                cacheModel.setErrMsg(sp.getData().toString());
            }
            return cacheModel;
        }
        cacheModel.getOrder().setSaveStatus(String.valueOf(sp.getRetflag()));
        cacheModel.getOrder().setSendSuccess(true);
        cacheModel.getOrder().setIdSheetNo(sheetNo);
        return cacheModel;
    }

    protected CacheModel saveOrder(CacheModel cacheModel, ServiceSession session, String newTerminalSno, String splitCode, String netType) {
        SaveR10Info saveR10Info;
        RespBase respBase;
        RespBase respBase2;
        List couponPayments;
        ServiceResponse response = null;
        log.info("cacheModel.getPayConfirmStatus[{}],cacheModel.getPopMode[{}]", (Object)cacheModel.getPayConfirmStatus(), (Object)cacheModel.getPopMode());
        if (null != cacheModel.getPayConfirmStatus() && cacheModel.getPayConfirmStatus() != 0 && (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 2 || cacheModel.getPopMode() == 3)) {
            response = this.couponConsume(cacheModel, session, cacheModel.getPayConfirmStatus().intValue(), netType);
            if ("0".equals(response.getReturncode())) {
                cacheModel.setErrMsg(Code.CODE_60136.getMsg());
            } else {
                cacheModel.setErrMsg(Code.CODE_60137.getMsg());
            }
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode(String.valueOf(Code.CODE_60025.getIndex()));
            return cacheModel;
        }
        log.info("\u8c03\u7528\u5238\u51b2\u6b63\u5b8c\u6bd5");
        if (StringUtils.isNotBlank((String)newTerminalSno)) {
            cacheModel = this.RefreshTerminalSno(cacheModel, newTerminalSno);
            cacheModel.getOrder().setSeqNo("");
            cacheModel.getOrder().setYpopBillNo(cacheModel.getOrder().getYpopBillNo() + "1");
            log.info("\u8df3\u53f7\u5904\u7406\u5b8c\u6bd5");
        }
        if ((couponPayments = this.posLogicCompoment.getCouponPayments(cacheModel.getPayments())) != null && couponPayments.size() != 0) {
            if (cacheModel.getPayConfirmStatus() == 0 && (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 2 || cacheModel.getPopMode() == 3)) {
                respBase2 = new RespBase();
                try {
                    respBase2 = this.couponRemoteService.couponuseConsumeForPay(session, cacheModel, netType);
                    cacheModel = ((ResqVo)respBase2.getData()).getCacheModel();
                }
                catch (Exception e) {
                    log.info("\u8425\u9500\u5238\u6838\u9500\u5931\u8d25\uff1a" + e.getMessage());
                    e.printStackTrace();
                }
            }
            log.info("\u8425\u9500\u5238\u6838\u9500\u5b8c\u6bd5");
        }
        if (cacheModel.getCalcResult() == -1) {
            return cacheModel;
        }
        if (null != cacheModel.getOrder().getConsumersData() && "MOHO".equals(cacheModel.getOrder().getConsumersData().getConsumersType())) {
            if (SellType.ISSALE((String)cacheModel.getOrder().getOrderType())) {
                log.info("\u6d77\u9f0e\u5238\u6838\u9500\u5f00\u59cb");
                RespBase resp = this.couponRemoteService.consumeOrderCoupon(session, cacheModel);
                if (0 != resp.getRetflag()) {
                    throw new EfutureException(resp);
                }
            }
            if (0 != (respBase2 = this.calcPopRemoteService.saveTrade(session, cacheModel)).getRetflag()) {
                log.info("\u6d77\u9f0e\u8ba2\u5355\u4e0a\u9001\u5931\u8d25==>{}", (Object)JSONObject.toJSONString((Object)respBase2));
                throw new EfutureException(respBase2);
            }
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        boolean trainingMode = modeDetailsVo.isTrainingMode();
        log.info("trainingMode>>>>>>" + trainingMode);
        if (!trainingMode) {
            RespBase respBase3;
            if (!(SellType.NOPOP((String)cacheModel.getOrder().getOrderType()) || cacheModel.getPopMode() != 1 && cacheModel.getPopMode() != 2 && cacheModel.getPopMode() != 3 || (cacheModel = (CacheModel)(respBase3 = this.calcPopRemoteService.calcCouponGain(session, cacheModel, netType, newTerminalSno)).getData()).getCalcResult() != -1)) {
                return cacheModel;
            }
            log.info("\u8425\u9500\u4fdd\u5b58\u5b8c\u6bd511111");
            if ("2".equals(netType) && "1".equals(cacheModel.getOrder().getOrderType())) {
                respBase3 = this.r10BackRebate(session, cacheModel);
                if (0 != respBase3.getRetflag()) {
                    log.info("R10 \u8fd4\u5229\u63a5\u53e3\u4e0a\u9001\u5931\u8d25==>{}", (Object)JSONObject.toJSONString((Object)respBase3));
                    throw new EfutureException(respBase3);
                }
                cacheModel = (CacheModel)respBase3.getData();
                log.info("R10 \u8fd4\u5229\u63a5\u53e3\u5b8c\u6bd5");
            }
        }
        if (null != cacheModel.getOrder().getConsumersData() && StringUtils.isNotBlank((String)cacheModel.getOrder().getConsumersData().getConsumersId())) {
            log.info("\u7d2f\u8ba1\u79ef\u5206\u8ba1\u7b97");
            cacheModel.getOrder().setTotalPoint(ManipulatePrecision.doubleConvert((double)(cacheModel.getOrder().getTotalPoint() - cacheModel.getOrder().getThisTimeUsedPoint())));
        }
        if (!trainingMode && "2".equals(netType) && null != cacheModel.getOrder().getConsumersData() && null != cacheModel.getOrder().getConsumersData().getConsumersCard() && 0 != (respBase = this.saveR10BackRebate(session, saveR10Info = new SaveR10Info(cacheModel))).getRetflag()) {
            cacheModel.getOrder().setExtendFt1("R10BackRebateFail");
        }
        if ((cacheModel = this.saveSaleOrder(cacheModel, session, splitCode, netType)).getCalcResult() == -1) {
            return cacheModel;
        }
        return cacheModel;
    }

    public CacheModel saveSaleOrder(CacheModel cacheModel, ServiceSession session, String splitCode, String netType) {
        String obj;
        ModeDetailsVo modeDetailsVo;
        boolean trainingMode;
        log.info("saveSaleOrder");
        RespBase response = new RespBase();
        if (cacheModel.getOrder().getConsumersData() != null && cacheModel.getOrder().getConsumersData().getConsumersCard() != null && ("2".equals(cacheModel.getOrder().getConsumersData().getCustType()) || "GRP".equals(cacheModel.getOrder().getConsumersData().getConsumersType()))) {
            log.info("\u4f1a\u5458\u4ea4\u6613\u6570\u636e\u4e0a\u9001");
            this.giveOrReverse(session, cacheModel);
        }
        cacheModel.getOrder().setPayState(2);
        cacheModel.getOrder().setOrderState(7);
        SaleOrders order = this.orderTransfer.saleOrdersFromCacheModel(cacheModel);
        if (null != splitCode && !"".equals(splitCode)) {
            order.getSaleOrders().setShardingCode(splitCode);
        }
        CouponuseConsumeIn couponuseConsumeIn = new CouponuseConsumeIn();
        couponuseConsumeIn.setBillno(cacheModel.getOrder().getFlowNo());
        couponuseConsumeIn.setCalcBillId(cacheModel.getOrder().getSeqNo());
        couponuseConsumeIn.setType("0");
        couponuseConsumeIn.setSaveorder("N");
        couponuseConsumeIn.setChannel(cacheModel.getOrder().getChannel());
        if (SellType.ISEXERCISE((String)cacheModel.getOrder().getOrderType())) {
            order.getSaleOrders().setSheetTypeCode("1");
        }
        if (StringUtils.isNotEmpty((String)order.getSaleOrdersExt().getGroupBuyNumber())) {
            order.getSaleOrders().setHasGroupBuy(true);
        }
        if (!(trainingMode = (modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)(obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo())), ModeDetailsVo.class)).isTrainingMode()) && !this.localcache.booleanValue()) {
            TransformationUtils util = new TransformationUtils();
            SaleOrders_WSLF saleOrders = util.saleOrdersToSaleOrders_WSLF(order);
            HashMap<String, SaleOrders_WSLF> map = new HashMap<String, SaleOrders_WSLF>();
            map.put("data", saleOrders);
            ServiceResponse rs = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, INSERTORDERALL, session, JSON.toJSONString(map), SaveOrdersOut.class, "\u8ba2\u5355\u4e2d\u5fc3", "\u4fdd\u5b58\u8ba2\u5355");
            response.setRetflag(Integer.parseInt(rs.getReturncode()));
            response.setData(rs.getData());
        } else {
            response = this.orderPosUploadService.receiveOrderUpload(session, order, netType);
        }
        SaveOrdersOut saveOrdersOut = null;
        String sheetNo = "";
        if (!"0".equals(String.valueOf(response.getRetflag())) && !"1".equals(String.valueOf(response.getRetflag()))) {
            if ("101".equals(String.valueOf(response.getRetflag())) || "201".equals(String.valueOf(response.getRetflag()))) {
                saveOrdersOut = (SaveOrdersOut)JSON.parseObject((String)response.getData().toString(), SaveOrdersOut.class);
                String terminalSno = saveOrdersOut.getTerminalSno();
                log.info("\u5c0f\u7968\u53f7terminalSno\uff1a" + terminalSno);
                String serviceSno = "";
                ServiceResponse sNoResponse = new ServiceResponse();
                sNoResponse.setReturncode("2002");
                sNoResponse.setData((Object)cacheModel.getOrder().getTerminalSno());
                cacheModel.setErrMsg(cacheModel.getOrder().getTerminalSno());
                List couponPayments = this.posLogicCompoment.getCouponPayments(cacheModel.getPayments());
                if (couponPayments != null && couponPayments.size() != 0 && (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 2 || cacheModel.getPopMode() == 3)) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.reversePromotion(session, cacheModel, couponuseConsumeIn, netType);
                }
                if (StringUtils.isNotBlank((String)terminalSno)) {
                    serviceSno = terminalSno;
                    sNoResponse.setData((Object)serviceSno);
                    cacheModel.setErrMsg(serviceSno);
                }
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("2002");
                return cacheModel;
            }
            if (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 2 || cacheModel.getPopMode() == 3) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException terminalSno) {
                    // empty catch block
                }
                List couponPayments = this.posLogicCompoment.getCouponPayments(cacheModel.getPayments());
                if (couponPayments != null && couponPayments.size() != 0) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException serviceSno) {
                        // empty catch block
                    }
                    ServiceResponse res = this.reversePromotion(session, cacheModel, couponuseConsumeIn, netType);
                    cacheModel.setCalcResult(-1);
                    cacheModel.setErrCode(String.valueOf(Code.CODE_60138.getIndex()));
                    if ("0".equals(res.getReturncode())) {
                        cacheModel.setErrMsg(Code.CODE_60135.getMsg() + Code.CODE_60136.getMsg());
                    } else {
                        cacheModel.setErrMsg(Code.CODE_60135.getMsg() + Code.CODE_60137.getMsg());
                    }
                    return cacheModel;
                }
            }
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("100000");
            if (null != response.getData()) {
                cacheModel.setErrMsg(String.valueOf(response.getData()));
            }
            return cacheModel;
        }
        saveOrdersOut = (SaveOrdersOut)JSON.parseObject((String)JSONObject.toJSONString((Object)response.getData()), SaveOrdersOut.class);
        sheetNo = saveOrdersOut.getSheetNo();
        Order o = cacheModel.getOrder();
        if (this.excuteZuul(String.valueOf(response.getRetflag()), sheetNo, o.getOrderType(), o.getTerminalSno(), o.getExistPay())) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode(String.valueOf(response.getRetflag()));
            if (null == response.getData() || "".equals(response.getData().toString())) {
                cacheModel.setErrMsg(response.getData().toString());
            } else {
                cacheModel.setErrMsg(response.getData().toString());
            }
            return cacheModel;
        }
        cacheModel.getOrder().setSaveStatus(String.valueOf(response.getRetflag()));
        cacheModel.getOrder().setSendSuccess(true);
        cacheModel.getOrder().setIdSheetNo(sheetNo);
        return cacheModel;
    }

    public RespBase r10BackRebate(ServiceSession session, CacheModel cacheModel) {
        String token = "";
        ServiceResponse response = null;
        RectR10Info rectR10Info = null;
        try {
            JSONObject jsonResponse;
            JSONObject tokenObj = new JSONObject();
            tokenObj.put("usercode", (Object)GlobalInfo.myshopTokenUseName);
            tokenObj.put("password", (Object)GlobalInfo.myshopTokenPassWord);
            log.info("\u6821\u9a8c\u8bb8\u53ef\u8bc1\u5f00\u59cb:{}", JSONObject.toJSON((Object)tokenObj));
            String res = HttpClientUtil.postJson((String)(GlobalInfo.myShopGroupUrl + "?method=" + GETTOKEN), (String)tokenObj.toJSONString());
            log.info("\u6821\u9a8c\u8bb8\u53ef\u8bc1\u8fd4\u56de:{}", (Object)res);
            if (StringUtils.isNotBlank((String)res) && "0".equals((jsonResponse = JSONObject.parseObject((String)res)).getString("returncode"))) {
                token = jsonResponse.getJSONObject("data").getString("access_token");
            }
            if (StringUtils.isBlank((String)token)) {
                return new RespBase(Code.CODE_20104.getIndex(), "\u8fd4\u5229\u63a5\u53e3\u672a\u83b7\u53d6\u5230token");
            }
            log.info("token:" + token);
            R10Order r10Order = R10Order.paseToR10Order((CacheModel)cacheModel, (String)"");
            JSONArray jsonArray = new JSONArray();
            jsonArray.add((Object)r10Order);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("data", (Object)jsonArray);
            log.info("\u8c03\u7528R10\u8fd4\u5238\u8fd4\u79ef\u5206\u63a5\u53e3  \u5165\u53c2 ==>{}", (Object)JSONObject.toJSONString((Object)r10Order));
            response = this.httpUtils.doMyshopPost(this.restTemplate, HttpUtils.RemoteService.MYSHOPBACKREBATE, SALEPOINTGET, session, jsonObject.toJSONString(), null, "myShop\u8fd4\u5238\u8fd4\u79ef\u5206", "\u8fd4\u5238\u8fd4\u79ef", token);
            log.info("\u8c03\u7528R10\u8fd4\u5238\u8fd4\u79ef\u5206\u63a5\u53e3  \u8fd4\u56de ==>{}", (Object)JSON.toJSONString((Object)response));
            rectR10Info = new RectR10Info();
            rectR10Info.setFphm(r10Order.getFphm());
            rectR10Info.setMkt(r10Order.getMkt());
            rectR10Info.setSheetno(r10Order.getSheetno());
            rectR10Info.setSyjh(r10Order.getSyjh());
            rectR10Info.setSyyh(r10Order.getSyyh());
            rectR10Info.setTransno(r10Order.getTransno());
            if ("0".equals(response.getReturncode())) {
                R10BackRebate r10BackRebate = (R10BackRebate)JSONObject.parseObject((String)JSONObject.toJSONString((Object)response.getData()), R10BackRebate.class);
                if (null == cacheModel.getOrder().getCouponDetails()) {
                    cacheModel.getOrder().setCouponDetails(new ArrayList());
                }
                if (null != r10BackRebate.getPoint() && 0.0 < r10BackRebate.getPoint().getPoint()) {
                    cacheModel.getOrder().setTotalPoint(r10BackRebate.getPoint().getTotalpoint());
                    cacheModel.getOrder().setThisTimePoint(r10BackRebate.getPoint().getPoint());
                    if ("1".equals(cacheModel.getOrder().getOrderType())) {
                        cacheModel.getOrder().getConsumersData().setPoint(r10BackRebate.getPoint().getTotalpoint());
                    } else if ("2".equals(cacheModel.getOrder().getOrderType()) || "4".equals(cacheModel.getOrder().getOrderType())) {
                        cacheModel.getOrder().getConsumersData().setPoint(r10BackRebate.getPoint().getTotalpoint());
                    }
                    SellCoupon sellCoupon = new SellCoupon();
                    sellCoupon.setCouponGroup("01");
                    sellCoupon.setCouponName("R10\u79ef\u5206");
                    sellCoupon.setFaceValue(r10BackRebate.getPoint().getPoint());
                    sellCoupon.setAmount(r10BackRebate.getPoint().getPoint());
                    sellCoupon.setAvailable(r10BackRebate.getPoint().getPoint());
                    sellCoupon.setLimit(1L);
                    Coupon coupon = this.couponTransfer.transferCoupon(sellCoupon);
                    cacheModel.getOrder().getCouponDetails().add(coupon);
                }
                if (null != r10BackRebate.getCoupons() && r10BackRebate.getCoupons().size() > 0) {
                    for (R10BackCoupon r10BackCoupon : r10BackRebate.getCoupons()) {
                        SellCoupon sellCoupon = new SellCoupon();
                        sellCoupon.setCouponType(String.valueOf(r10BackCoupon.getCouponflag()));
                        sellCoupon.setCouponGroup("02");
                        sellCoupon.setCouponName(r10BackCoupon.getInfo());
                        sellCoupon.setAccount(r10BackCoupon.getCouponno());
                        sellCoupon.setSrcAccntno(r10BackCoupon.getCouponno());
                        sellCoupon.setFaceValue(r10BackCoupon.getPrintvalue());
                        sellCoupon.setAmount(r10BackCoupon.getPrintvalue());
                        sellCoupon.setMoney(r10BackCoupon.getDiscount());
                        sellCoupon.setAvailable(r10BackCoupon.getPrintvalue());
                        sellCoupon.setLimit((long)r10BackCoupon.getQty());
                        sellCoupon.setUsageDesc(r10BackCoupon.getMemo());
                        sellCoupon.setDescribe(r10BackCoupon.getInfo());
                        sellCoupon.setEffDate(r10BackCoupon.getStartdate());
                        sellCoupon.setExpDate(r10BackCoupon.getEnddate());
                        sellCoupon.setGainEventId(Long.valueOf(r10BackCoupon.getCoupontypeid()).longValue());
                        sellCoupon.setMedia("1");
                        Coupon coupon = this.couponTransfer.transferCoupon(sellCoupon);
                        cacheModel.getOrder().getCouponDetails().add(coupon);
                    }
                }
                return new RespBase(Code.SUCCESS, (Object)cacheModel);
            }
            if ("60003".equals(response.getReturncode())) {
                this.rectR10BackRebate(session, rectR10Info);
                return new RespBase(Code.SUCCESS, (Object)cacheModel);
            }
            if ("8000".equals(response.getReturncode())) {
                return new RespBase(Integer.parseInt(response.getReturncode()), JSONObject.toJSONString((Object)response.getData()));
            }
        }
        catch (Exception e) {
            if (null != rectR10Info) {
                this.rectR10BackRebate(session, rectR10Info);
            }
            log.error(e.getMessage(), (Throwable)e);
            return new RespBase(Code.CODE_60125.getIndex(), "r10error\uff1a" + e.getMessage());
        }
        if (null != rectR10Info) {
            this.rectR10BackRebate(session, rectR10Info);
        }
        return new RespBase(Code.CODE_60125, "");
    }

    public void rectR10BackRebate(ServiceSession session, RectR10Info rectR10Info) {
        String token = "";
        ServiceResponse response = null;
        try {
            JSONObject jsonResponse;
            JSONObject tokenObj = new JSONObject();
            tokenObj.put("usercode", (Object)GlobalInfo.myshopTokenUseName);
            tokenObj.put("password", (Object)GlobalInfo.myshopTokenPassWord);
            log.info("\u6821\u9a8c\u8bb8\u53ef\u8bc1\u5f00\u59cb:{}", JSONObject.toJSON((Object)tokenObj));
            String res = HttpClientUtil.postJson((String)(GlobalInfo.myShopGroupUrl + "?method=" + GETTOKEN), (String)tokenObj.toJSONString());
            log.info("\u6821\u9a8c\u8bb8\u53ef\u8bc1\u8fd4\u56de:{}", (Object)res);
            if (StringUtils.isNotBlank((String)res) && "0".equals((jsonResponse = JSONObject.parseObject((String)res)).getString("returncode"))) {
                token = jsonResponse.getJSONObject("data").getString("access_token");
            }
            if (StringUtils.isBlank((String)token)) {
                log.error("\u8fd4\u5229\u63a5\u53e3\u672a\u83b7\u53d6\u5230token");
            }
            log.info("token:" + token);
            log.info("\u8c03\u7528R10\u79ef\u5206/\u5238\u51b2\u6b63\u63a5\u53e3  \u5165\u53c2 ==>{}", (Object)JSONObject.toJSONString((Object)rectR10Info));
            response = this.httpUtils.doMyshopPost(this.restTemplate, HttpUtils.RemoteService.MYSHOPBACKREBATE, SALEPOINTREV, session, JSONObject.toJSONString((Object)rectR10Info), null, "myShop\u8fd4\u5238\u8fd4\u79ef\u5206\u51b2\u6b63", "\u8fd4\u5238\u8fd4\u79ef\u5206\u51b2\u6b63", token);
            log.info("\u8c03\u7528R10\u79ef\u5206/\u5238\u51b2\u6b63\u63a5\u53e3  \u8fd4\u56de ==>{}", (Object)JSON.toJSONString((Object)response));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public RespBase saveR10BackRebate(ServiceSession session, SaveR10Info saveR10Info) {
        String token = "";
        ServiceResponse response = null;
        try {
            JSONObject jsonResponse;
            JSONObject tokenObj = new JSONObject();
            tokenObj.put("usercode", (Object)GlobalInfo.myshopTokenUseName);
            tokenObj.put("password", (Object)GlobalInfo.myshopTokenPassWord);
            log.info("\u6821\u9a8c\u8bb8\u53ef\u8bc1\u5f00\u59cb:{}", JSONObject.toJSON((Object)tokenObj));
            String res = HttpClientUtil.postJson((String)(GlobalInfo.myShopGroupUrl + "?method=" + GETTOKEN), (String)tokenObj.toJSONString());
            log.info("\u6821\u9a8c\u8bb8\u53ef\u8bc1\u8fd4\u56de:{}", (Object)res);
            if (StringUtils.isNotBlank((String)res) && "0".equals((jsonResponse = JSONObject.parseObject((String)res)).getString("returncode"))) {
                token = jsonResponse.getJSONObject("data").getString("access_token");
            }
            if (StringUtils.isBlank((String)token)) {
                log.error("\u672a\u83b7\u53d6\u5230token");
            }
            log.info("token:" + token);
            log.info("\u8c03\u7528R10\u79ef\u5206/\u5238\u8bb0\u8d26\u63a5\u53e3  \u5165\u53c2 ==>{}", (Object)JSONObject.toJSONString((Object)saveR10Info));
            response = this.httpUtils.doMyshopPost(this.restTemplate, HttpUtils.RemoteService.MYSHOPBACKREBATE, SALEPOINTSAVE, session, JSONObject.toJSONString((Object)saveR10Info), null, "myShop\u79ef\u5206/\u5238\u8bb0\u8d26", "\u79ef\u5206/\u5238\u8bb0\u8d26", token);
            log.info("\u8c03\u7528R10\u79ef\u5206/\u5238\u8bb0\u8d26\u63a5\u53e3  \u8fd4\u56de ==>{}", (Object)JSON.toJSONString((Object)response));
            if ("0".equals(response.getReturncode())) {
                return new RespBase(Code.SUCCESS);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new RespBase(Code.FAIL);
        }
        return new RespBase(Code.FAIL);
    }

    public RespBase afterCheckOrderBalance(ServiceSession session, ResqVo vo) {
        RespBase respBase = null;
        if ("1".equals(vo.getCacheModel().getOrder().getOrderType()) && null != vo.getCacheModel().getGoodsList() && 0 < vo.getCacheModel().getGoodsList().size() && null != vo.getCacheModel().getOrder().getConsumersData() && !"".equals(vo.getCacheModel().getOrder().getConsumersData().getConsumersCard()) && null != vo.getCacheModel().getOrder().getConsumersData().getConsumersCard()) {
            respBase = this.r10PayRemoteService.pointWriteOff(session, vo);
            if (0 != respBase.getRetflag()) {
                return respBase;
            }
            vo = (ResqVo)respBase.getData();
        }
        return new RespBase(Code.SUCCESS, (Object)vo.getCacheModel());
    }

    public PayConfirmOut toPayConfirmOut(ServiceSession session, SaleOrders_WSLF saleOrder, SaleOrders_WSLF oriOrder, List<String> calcPriceType, boolean isReprint) {
        PrintInfo printInfo;
        PayConfirmOut out = new PayConfirmOut();
        OrderForPos orderOut = this.orderTransfer.toOrderForPos(saleOrder);
        out.setRePrintCnt(saleOrder.getRePrintCnt());
        if (null != saleOrder.getOrders().getReturnReason()) {
            orderOut.setReason(saleOrder.getOrders().getReturnReason().toString());
        }
        log.info("orderOut\u9000\u8d27\u53c2\u6570\u8f6c\u6362\u5b8c\u6210");
        ArrayList<Payment> sellPayments = new ArrayList<Payment>();
        for (OrdersPayModel s : saleOrder.getOrdersPay()) {
            Payment p = new Payment();
            JSONObject extMemo = null;
            log.info("ExtMemo=====>" + s.getExtMemo());
            this.paymentTransfer.SaleOrderPayToPayment(s, p);
            if (StringUtils.isNotEmpty((String)s.getExtMemo()) && s.getExtMemo().contains("{")) {
                log.info("\u5b58\u5728\u6c47\u7387\u8f6c\u6362");
                extMemo = JSONObject.parseObject((String)s.getExtMemo());
                p.setAdditionalData(extMemo.getString("newRateAmt"));
            }
            log.info("payment\u8f6c\u6362\u5b8c\u62101");
            sellPayments.add(p);
        }
        orderOut.setSalePayments(sellPayments);
        log.info("payment\u8f6c\u6362\u5b8c\u6210");
        double noDiscountValueDzc = 0.0;
        ArrayList<Goods> goodsList = new ArrayList<Goods>();
        for (OrdersDetailModel s : saleOrder.getOrdersDetail()) {
            Object goods = new Goods();
            goods = this.goodsTransfer.SaleOrderDetailToGoods((Goods)goods, s);
            goodsList.add((Goods)goods);
            if (!"Y".equals(goods.getEscaleFlag())) continue;
            noDiscountValueDzc = ManipulatePrecision.doubleConvert((double)(noDiscountValueDzc + goods.getNoDisAmountValue()), (int)2, (int)1);
        }
        orderOut.setRealTotalDiscountValueDzc(ManipulatePrecision.doubleConvert((double)(orderOut.getTotalDiscountValue() - noDiscountValueDzc)));
        orderOut.setRealSaleValueDzc(ManipulatePrecision.doubleConvert((double)(orderOut.getSaleValue() - noDiscountValueDzc)));
        log.info("goods\u8f6c\u6362\u5b8c\u6210");
        if (null != saleOrder.getOrdersDetailPop() && saleOrder.getOrdersDetailPop().size() > 0) {
            for (int i = 0; i < goodsList.size(); ++i) {
                Goods goods = (Goods)goodsList.get(i);
                for (OrdersDetailPopModel orderPop : saleOrder.getOrdersDetailPop()) {
                    if (goods.getFlowId() != orderPop.getRowNo().intValue()) continue;
                    goods.getPopDetailsInfo().add(this.popdetailTransfer.transferPopDetail(orderPop));
                    if (!YPopStatusType.pop_policy_group_barcode_discB.equals(orderPop.getPopPolicyGroup())) continue;
                    goods.setBarcodeDiscount(orderPop.getDiscountAmount().doubleValue());
                }
            }
        }
        log.info("orderPop\u8f6c\u6362\u5b8c\u6210");
        if ("5".equals(saleOrder.getOrders().getOrderType()) && null != oriOrder) {
            ArrayList<Goods> origoodsList = new ArrayList<Goods>();
            for (OrdersDetailModel s : oriOrder.getOrdersDetail()) {
                Goods goods = new Goods();
                goods = this.goodsTransfer.SaleOrderDetailToGoods(goods, s);
                origoodsList.add(goods);
                if (!"Y".equals(goods.getEscaleFlag())) continue;
                noDiscountValueDzc = ManipulatePrecision.doubleConvert((double)(noDiscountValueDzc + goods.getNoDisAmountValue()), (int)2, (int)1);
            }
            ArrayList<Payment> oriPayments = new ArrayList<Payment>();
            for (int i = 0; i < oriOrder.getOrdersPay().size() - 1; ++i) {
                OrdersPayModel s = (OrdersPayModel)oriOrder.getOrdersPay().get(i);
                Payment p = new Payment();
                this.paymentTransfer.SaleOrderPayToPayment(s, p);
                log.info("payment\u8f6c\u6362\u5b8c\u62102");
                oriPayments.add(p);
            }
            oriPayments.addAll(sellPayments);
            orderOut.setSalePayments(oriPayments);
            printInfo = this.printTransfer.convertPrintInfo(origoodsList);
        } else {
            printInfo = this.printTransfer.convertPrintInfo(goodsList);
        }
        log.info("printInfo\u8f6c\u6362\u5b8c\u6210");
        out.setPopInfo(new ArrayList());
        out.getPopInfo().addAll(printInfo.getMergedPopDetails());
        List goodListPops = this.goodsTransfer.transferGoodsToPosGoodsListForSave(printInfo.getGoodsListForPrint(), calcPriceType, true);
        orderOut.getGoodsList().addAll(goodListPops);
        OrderGains orderGain = this.orderTransfer.convertOrderGains(this.couponTransfer.transferCoupon4(saleOrder.getOrdersGain()), isReprint);
        log.info("orderGain\u8f6c\u6362\u5b8c\u6210");
        if (null != orderGain) {
            out.setCouponGain(orderGain.getOrderCouponGains());
            out.setAchievePoints(orderGain.getPoints());
            out.setExperience(orderGain.getExperience());
        }
        out.setOrder(orderOut);
        if (!"5".equals(saleOrder.getOrders().getOrderType()) && null != oriOrder) {
            OrderForPos oriOrderOut = this.orderTransfer.toOrderForPos(oriOrder);
            ArrayList<Payment> oriPayments = new ArrayList<Payment>();
            for (Object s : oriOrder.getOrdersPay()) {
                Payment p = new Payment();
                this.paymentTransfer.SaleOrderPayToPayment((OrdersPayModel)s, p);
                log.info("payment\u8f6c\u6362\u5b8c\u62103");
                oriPayments.add(p);
            }
            oriOrderOut.setSalePayments(oriPayments);
            log.info("payment\u8f6c\u6362\u5b8c\u6210");
            noDiscountValueDzc = 0.0;
            ArrayList<Goods> origoodsList = new ArrayList<Goods>();
            for (OrdersDetailModel s : oriOrder.getOrdersDetail()) {
                Goods goods = new Goods();
                goods = this.goodsTransfer.SaleOrderDetailToGoods(goods, s);
                origoodsList.add(goods);
                if (!"Y".equals(goods.getEscaleFlag())) continue;
                noDiscountValueDzc = ManipulatePrecision.doubleConvert((double)(noDiscountValueDzc + goods.getNoDisAmountValue()), (int)2, (int)1);
            }
            oriOrderOut.setRealTotalDiscountValueDzc(ManipulatePrecision.doubleConvert((double)(oriOrderOut.getTotalDiscountValue() - noDiscountValueDzc)));
            oriOrderOut.setRealSaleValueDzc(ManipulatePrecision.doubleConvert((double)(oriOrderOut.getSaleValue() - noDiscountValueDzc)));
            log.info("goods\u8f6c\u6362\u5b8c\u6210");
            PrintInfo oriPrintInfo = this.printTransfer.convertPrintInfo(origoodsList);
            log.info("printInfo\u8f6c\u6362\u5b8c\u6210");
            out.setOriginPopInfo(new ArrayList());
            out.getOriginPopInfo().addAll(oriPrintInfo.getMergedPopDetails());
            List oriGoodListPops = this.goodsTransfer.transferGoodsToPosGoodsListForSave(oriPrintInfo.getGoodsListForPrint(), calcPriceType, true);
            oriOrderOut.getGoodsList().addAll(oriGoodListPops);
            out.setOriginOrder(oriOrderOut);
        }
        return out;
    }
}

