/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.localize;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.CustomAsyncScheduler;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.bean.YPopStatusType;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.dao.wslf.OrdersModelService;
import com.efuture.business.dao.wslf.OrdersPayModelService;
import com.efuture.business.dao.wslf.OrdersPrintLogInfoModelService;
import com.efuture.business.enums.FDCERPCODE;
import com.efuture.business.exception.EfutureException;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.ConsumersData;
import com.efuture.business.javaPos.struct.Coupon;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.OperUser;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.OrderForPos;
import com.efuture.business.javaPos.struct.OrderGains;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentMode;
import com.efuture.business.javaPos.struct.PrintInfo;
import com.efuture.business.javaPos.struct.SaleOrderStateEnum;
import com.efuture.business.javaPos.struct.SysPara;
import com.efuture.business.javaPos.struct.orderCentre.OrderStateEnum;
import com.efuture.business.javaPos.struct.orderCentre.OrdersDetailModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersDetailPopModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersGainDetailModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersGainModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersModel4Pos;
import com.efuture.business.javaPos.struct.orderCentre.OrdersPayModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersPrintLogInfoModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersUseCouponModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrders;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrders_WSLF;
import com.efuture.business.javaPos.struct.orderCentre.request.OrderQueryIn;
import com.efuture.business.javaPos.struct.orderCentre.request.PrintLogIn;
import com.efuture.business.javaPos.struct.orderCentre.response.OrdersDetailOut;
import com.efuture.business.javaPos.struct.orderCentre.response.OrdersQueryOut;
import com.efuture.business.javaPos.struct.orderCentre.response.SaveOrdersOut;
import com.efuture.business.javaPos.struct.orderCentre.response.SyncOutData;
import com.efuture.business.javaPos.struct.posManager.PosRoleManager;
import com.efuture.business.javaPos.struct.posManager.request.OperUserIn;
import com.efuture.business.javaPos.struct.posManager.response.OperUserOut;
import com.efuture.business.javaPos.struct.promotionCentre.request.CouponuseConsumeIn;
import com.efuture.business.javaPos.struct.request.GetOrderIn;
import com.efuture.business.javaPos.struct.request.GetOrdersIn;
import com.efuture.business.javaPos.struct.request.RecordPrintLogIn;
import com.efuture.business.javaPos.struct.request.SaleReturnQueryIn;
import com.efuture.business.javaPos.struct.response.PayConfirmOut;
import com.efuture.business.javaPos.struct.wslf.lpk.HttpClientCBC;
import com.efuture.business.javaPos.struct.wslf.request.QuerySaleSeqnoReqDef;
import com.efuture.business.javaPos.struct.wslf.request.SaleComReqDef;
import com.efuture.business.javaPos.struct.wslf.request.SaleHeadReqDef;
import com.efuture.business.javaPos.struct.wslf.request.SalePayReqDef;
import com.efuture.business.javaPos.struct.wslf.response.QuerySaleSeqnoRevDef;
import com.efuture.business.javaPos.struct.wslf.response.SaleHeadRevDef;
import com.efuture.business.model.CheckPayInVo;
import com.efuture.business.model.Syspara;
import com.efuture.business.service.DFRemoteService;
import com.efuture.business.service.InitializationRemoteService;
import com.efuture.business.service.YktRemoteService;
import com.efuture.business.service.impl.OrderSaleBSImpl;
import com.efuture.business.util.ArrayUtils;
import com.efuture.business.util.Convert;
import com.efuture.business.util.DateHelpUtil;
import com.efuture.business.util.DateUtils;
import com.efuture.business.util.HttpClientUtils;
import com.efuture.business.util.HttpUtils;
import com.efuture.business.util.ListUtils;
import com.efuture.business.util.ParamsValidateUtil;
import com.efuture.business.util.PayModeUtils;
import com.efuture.business.util.PaymentUtil;
import com.efuture.business.util.SubmitUtil;
import com.efuture.business.util.TimeZoneUtil;
import com.efuture.business.util.TransformationUtils;
import com.efuture.business.util.UniqueID;
import com.efuture.business.util.WslfTools;
import com.efuture.business.util.moho.HdHttpRequest;
import com.efuture.business.util.moho.MohoHttpRequest;
import com.efuture.business.util.moho.MohoHttpRequestEnum;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.util.ParamValidateUtil;
import com.product.util.TypeUtils;
import com.product.util.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.client.RestTemplate;

public class OrderSaleBSImpl_WSLF
extends OrderSaleBSImpl {
    private static final Logger log = LoggerFactory.getLogger(OrderSaleBSImpl_WSLF.class);
    private static String INSERTORDERALL = "order.online.save.execute";
    private static String ONQUERY = "order.pos.searchOrders";
    private static String GETORDERALL = "order.pos.searchOrdersDetail";
    private static String ORDERPRINTLOG = "order.pos.postBackPrintLog";
    private static String SYNC = "order.online.sync.execute";
    private static final String BILL_END_TIME = " 05:00:00";
    RestTemplate restTemplate;
    @Autowired
    WslfTools wslfTools;
    @Value(value="${globalinfo.signKey:000}")
    private String signKey;
    @SoaAnnotation(value="/apiYktRemoteService.do")
    public YktRemoteService yktRemoteService;
    @SoaAnnotation(value="/apiDFRemoteService.do")
    public DFRemoteService dfRemoteService;
    @SoaAnnotation(value="/apiInitializeRemoteService.do")
    protected InitializationRemoteService initializationRemoteService;
    @Autowired(required=false)
    private OrdersPrintLogInfoModelService ordersPrintLogInfoModelService;
    @Autowired(required=false)
    private OrdersModelService ordersModelService;
    @Autowired
    private OrdersPayModelService ordersPayModelService;
    @Value(value="${hazelcast.enabled:false}")
    private Boolean hazelcast;
    @Autowired
    PosLogicCompoment posLogicCompoment;

    public CacheModel saveSaleOrder(CacheModel cacheModel, ServiceSession session, String splitCode, String netType) {
        log.info("saveSaleOrder");
        RespBase response = new RespBase();
        if (cacheModel.getOrder().getConsumersData() != null && cacheModel.getOrder().getConsumersData().getConsumersCard() != null && ("2".equals(cacheModel.getOrder().getConsumersData().getCustType()) || "GRP".equals(cacheModel.getOrder().getConsumersData().getConsumersType()))) {
            log.info("\u4f1a\u5458\u4ea4\u6613\u6570\u636e\u4e0a\u9001");
            this.giveOrReverse(session, cacheModel);
        }
        cacheModel.getOrder().setPayState(2);
        cacheModel.getOrder().setOrderState(7);
        cacheModel.getOrder().setLogisticsState(6);
        if (SellType.ISKD((String)cacheModel.getOrder().getOrderType())) {
            cacheModel.getOrder().setOrderState(4);
            cacheModel.getOrder().setLogisticsMode(1);
            cacheModel.getOrder().setLogisticsState(1);
        }
        String objAL = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
        ModeDetailsVo modeDetailsVoAL = (ModeDetailsVo)JSONObject.parseObject((String)objAL, ModeDetailsVo.class);
        String taxRate = modeDetailsVoAL.getSysparaValue("taxrate");
        log.info("\u7a0e\u7387\u7cfb\u7edf\u53c2\u6570=>{}", (Object)taxRate);
        cacheModel.getOrder().setExtendFt6(taxRate);
        if (StringUtils.isNotBlank((String)taxRate)) {
            log.info("\u5f00\u59cb\u8ba1\u7b97\u7a0e\u989d");
            if (StringUtils.contains((String)taxRate, (String)"%")) {
                taxRate = taxRate.replace("%", "");
            }
            Double d = 0.0;
            for (String[] payment : cacheModel.getPayments()) {
                PaymentMode payMode = PayModeUtils.getPayMode((String)payment.getPayCode(), (JSONObject)JSONObject.parseObject((String)objAL));
                if (payMode != null) {
                    log.info("{}==>{}", (Object)payMode.getCode(), (Object)payMode.getRecordFlag());
                    if (!StringUtils.isBlank((String)payMode.getRecordFlag()) && "Y".equals(payMode.getRecordFlag())) continue;
                    if (1 == payment.getInstallmentTerms() && "Y".equalsIgnoreCase(payment.getIsCoupon())) {
                        log.info("{}\u5238\u8ba1\u7a0e", (Object)payment.getPayNo());
                        continue;
                    }
                    log.info("{}\u4e0d\u8ba1\u7a0e", (Object)payMode.getCode());
                    d = d + payment.getMoney();
                    continue;
                }
                log.info("{}\u652f\u4ed8\u65b9\u5f0f\u672a\u627e\u5230", (Object)payment.getPayCode());
            }
            log.info("\u8ba1\u7b97\u7a0e\u989d\u91d1\u989d===>{}", (Object)cacheModel.getOrder().getOughtPay());
            double totalAmount = cacheModel.getOrder().getOughtPay() - d;
            log.info("\u8ba1\u7b97\u7a0e\u989d\u91d1\u989d===>{}", (Object)totalAmount);
            int newScale = 2;
            if (FDCERPCODE.TW.getErpcode().equals(cacheModel.getOrder().getErpCode())) {
                newScale = 0;
            }
            BigDecimal noTaxAmount = BigDecimal.valueOf(totalAmount).divide(BigDecimal.valueOf(1.0 + Double.parseDouble(taxRate) / 100.0), 3, RoundingMode.HALF_UP);
            noTaxAmount = noTaxAmount.setScale(newScale, 4);
            BigDecimal taxAmount = BigDecimal.valueOf(totalAmount).subtract(noTaxAmount);
            taxAmount = taxAmount.setScale(newScale, 4);
            cacheModel.getOrder().setExtendFt5(noTaxAmount.toPlainString());
            cacheModel.getOrder().setExtendFt7(taxAmount.toPlainString());
        }
        cacheModel.getPayments().stream().filter(r -> {
            PaymentMode payMode = PayModeUtils.getPayMode((String)r.getPayCode(), (JSONObject)JSONObject.parseObject((String)objAL));
            if (payMode != null) {
                return "Y".equals(payMode.getRecordFlag());
            }
            return false;
        }).forEach(record -> record.setInstallmentTerms(1));
        String shouka = SysPara.getSysParaValue((List)modeDetailsVoAL.getSyspara(), (String)"SKSP");
        log.info("\u552e\u5361\u53c2\u6570:{}", (Object)shouka);
        if (StringUtils.isNotBlank((String)shouka)) {
            String[] goodsCodes;
            block7: for (String code : goodsCodes = shouka.split(",")) {
                for (Goods goods : cacheModel.getGoodsList()) {
                    if (!code.equals(goods.getGoodsCode())) continue;
                    log.info("\u5b58\u5728\u552e\u5361\u5546\u54c1==>{}", (Object)JSONObject.toJSONString((Object)goods));
                    cacheModel.getOrder().setHasBackPrint(true);
                    continue block7;
                }
            }
        }
        SaleOrders order = this.orderTransfer.saleOrdersFromCacheModel(cacheModel);
        if (null != splitCode && !"".equals(splitCode)) {
            order.getSaleOrders().setShardingCode(splitCode);
        }
        CouponuseConsumeIn couponuseConsumeIn = new CouponuseConsumeIn();
        couponuseConsumeIn.setBillno(cacheModel.getOrder().getFlowNo());
        couponuseConsumeIn.setCalcBillId(cacheModel.getOrder().getSeqNo());
        couponuseConsumeIn.setType("0");
        couponuseConsumeIn.setSaveorder("N");
        couponuseConsumeIn.setChannel(cacheModel.getOrder().getChannel());
        if (SellType.ISEXERCISE((String)cacheModel.getOrder().getOrderType())) {
            order.getSaleOrders().setSheetTypeCode("1");
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        boolean trainingMode = modeDetailsVo.isTrainingMode();
        boolean online = true;
        if (this.localcache.booleanValue()) {
            online = false;
            if (SellType.ISKD((String)cacheModel.getOrder().getOrderType())) {
                online = true;
            }
        }
        if (trainingMode) {
            online = false;
        }
        if (online) {
            TransformationUtils util = new TransformationUtils();
            SaleOrders_WSLF saleOrders = util.saleOrdersToSaleOrders_WSLF(order);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("data", saleOrders);
            String timeZone = modeDetailsVoAL.getSysparainfo().getTimeZone();
            if (StringUtils.isNotBlank((String)timeZone) && timeZone.contains(",")) {
                timeZone = timeZone.split(",")[0];
            }
            map.put("timeZone", timeZone);
            ServiceResponse rs = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, INSERTORDERALL, session, JSON.toJSONString(map), SaveOrdersOut.class, "\u8ba2\u5355\u4e2d\u5fc3", "\u4fdd\u5b58\u8ba2\u5355");
            if ("0".equals(rs.getReturncode()) || "1".equals(rs.getReturncode())) {
                SaveOrdersOut saveOrdersOut = (SaveOrdersOut)rs.getData();
                cacheModel.getOrder().setVoucherNo(saveOrdersOut.getVoucherNo());
            }
            response.setRetflag(Integer.parseInt(rs.getReturncode()));
            response.setData(rs.getData());
        } else {
            response = this.orderPosUploadService.receiveOrderUpload(session, order, netType);
        }
        SaveOrdersOut saveOrdersOut = null;
        String sheetNo = "";
        if (!"0".equals(String.valueOf(response.getRetflag())) && !"1".equals(String.valueOf(response.getRetflag()))) {
            if ("101".equals(String.valueOf(response.getRetflag())) || "201".equals(String.valueOf(response.getRetflag()))) {
                saveOrdersOut = (SaveOrdersOut)JSON.parseObject((String)response.getData().toString(), SaveOrdersOut.class);
                String terminalSno = saveOrdersOut.getTerminalSno();
                log.info("\u5c0f\u7968\u53f7terminalSno\uff1a" + terminalSno);
                String serviceSno = "";
                ServiceResponse sNoResponse = new ServiceResponse();
                sNoResponse.setReturncode("2002");
                sNoResponse.setData((Object)cacheModel.getOrder().getTerminalSno());
                cacheModel.setErrMsg(cacheModel.getOrder().getTerminalSno());
                List couponPayments = this.posLogicCompoment.getCouponPayments(cacheModel.getPayments());
                if (couponPayments != null && couponPayments.size() != 0 && (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 2 || cacheModel.getPopMode() == 3)) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.reversePromotion(session, cacheModel, couponuseConsumeIn, netType);
                }
                if (StringUtils.isNotBlank((String)terminalSno)) {
                    serviceSno = terminalSno;
                    sNoResponse.setData((Object)serviceSno);
                    cacheModel.setErrMsg(serviceSno);
                }
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("2002");
                return cacheModel;
            }
            if (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 2 || cacheModel.getPopMode() == 3) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException terminalSno) {
                    // empty catch block
                }
                List couponPayments = this.posLogicCompoment.getCouponPayments(cacheModel.getPayments());
                if (couponPayments != null && couponPayments.size() != 0) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException serviceSno) {
                        // empty catch block
                    }
                    ServiceResponse res = this.reversePromotion(session, cacheModel, couponuseConsumeIn, netType);
                    cacheModel.setCalcResult(-1);
                    cacheModel.setErrCode(String.valueOf(Code.CODE_60025.getIndex()));
                    if ("0".equals(res.getReturncode())) {
                        cacheModel.setErrMsg(Code.CODE_60135.getMsg() + Code.CODE_60136.getMsg());
                    } else {
                        cacheModel.setErrMsg(Code.CODE_60135.getMsg() + Code.CODE_60137.getMsg());
                    }
                    return cacheModel;
                }
            }
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("100000");
            if (null != response.getData()) {
                cacheModel.setErrMsg(String.valueOf(response.getData()));
            }
            return cacheModel;
        }
        saveOrdersOut = (SaveOrdersOut)JSON.parseObject((String)JSONObject.toJSONString((Object)response.getData()), SaveOrdersOut.class);
        sheetNo = saveOrdersOut.getSheetNo();
        Order o = cacheModel.getOrder();
        if (this.excuteZuul(String.valueOf(response.getRetflag()), sheetNo, o.getOrderType(), o.getTerminalSno(), o.getExistPay())) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode(String.valueOf(response.getRetflag()));
            if (null == response.getData() || "".equals(response.getData().toString())) {
                cacheModel.setErrMsg(response.getData().toString());
            } else {
                cacheModel.setErrMsg(response.getData().toString());
            }
            return cacheModel;
        }
        cacheModel.getOrder().setSaveStatus(String.valueOf(response.getRetflag()));
        cacheModel.getOrder().setSendSuccess(true);
        cacheModel.getOrder().setIdSheetNo(sheetNo);
        return cacheModel;
    }

    protected CacheModel saveSaleReturnOrder(CacheModel cacheModel, ServiceSession session, String newTerminalSno, String splitCode, String netType) {
        log.info(">>>>>>>>>>saveSaleReturnOrder>>>>>>>>>>>");
        ServiceResponse response = null;
        RespBase sp = new RespBase();
        String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        boolean trainingMode = modeDetailsVo.isTrainingMode();
        cacheModel.setCalcResult(0);
        cacheModel.setErrCode("");
        cacheModel.setErrMsg("");
        if (!this.thirdVoidPayment(session, cacheModel)) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode(String.valueOf(Code.CODE_50052.getIndex()));
            cacheModel.setErrMsg(String.valueOf(Code.CODE_50052.getMsg()));
            return cacheModel;
        }
        if (!(trainingMode || cacheModel.getPopMode() != 1 && cacheModel.getPopMode() != 2 || "2".equals(cacheModel.getOrder().getOrderType()))) {
            RespBase respBase;
            if (cacheModel.getPayConfirmStatus() != 0 && (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 2)) {
                response = this.couponConsume(cacheModel, session, cacheModel.getPayConfirmStatus().intValue(), netType);
                if (null == response.getData() || "".equals(response.getData().toString())) {
                    cacheModel.setCalcResult(-1);
                    cacheModel.setErrCode(response.getReturncode());
                    cacheModel.setErrMsg(response.getData().toString());
                    return cacheModel;
                }
                if (!"0".equals(response.getReturncode())) {
                    cacheModel.setCalcResult(-1);
                    cacheModel.setErrCode(response.getReturncode());
                    cacheModel.setErrMsg(response.getData().toString());
                    return cacheModel;
                }
            }
            log.info("\u51b2\u6b63\u540e\u7684cacheResult{} ,errCode{} ,errmsg{} ,", new Object[]{cacheModel.getCalcResult(), cacheModel.getErrCode(), cacheModel.getErrMsg()});
            CouponuseConsumeIn couponuseConsumeIn = new CouponuseConsumeIn();
            couponuseConsumeIn.setBillno(cacheModel.getOrder().getFlowNo());
            couponuseConsumeIn.setChannel(cacheModel.getOrder().getChannel());
            couponuseConsumeIn.setCalcBillId(cacheModel.getOrder().getSeqNo());
            couponuseConsumeIn.setSaveorder("N");
            List couponPayments = this.posLogicCompoment.getCouponPayments(cacheModel.getPayments());
            if (couponPayments != null && couponPayments.size() != 0) {
                couponuseConsumeIn.setSellPayments(this.paymentTransfer.transferSellPayment(couponPayments, SellType.ISBACK((String)cacheModel.getOrder().getOrderType())));
                couponuseConsumeIn.setType("0");
                cacheModel.callMarketClear();
                respBase = this.couponRemoteService.couponAndPointsConsume(session, cacheModel, couponuseConsumeIn, netType);
                log.info("\u8425\u9500\u51b2\u6b63\u8fd4\u56de==>{}", (Object)JSONObject.toJSONString((Object)respBase));
                if (0 != respBase.getRetflag()) {
                    List reversePayments = couponuseConsumeIn.getSellPayments();
                    cacheModel.setReversePayments(reversePayments);
                    response = this.couponConsume(cacheModel, session, 5, netType);
                    cacheModel.setCalcResult(-1);
                    cacheModel.setErrCode(response.getReturncode());
                    if (null == response.getData() || "".equals(response.getData().toString())) {
                        cacheModel.setErrMsg(response.getData().toString());
                    } else {
                        cacheModel.setErrMsg(response.getData().toString());
                    }
                    return cacheModel;
                }
            }
            log.info("\u6838\u9500\u540e\u7684cacheResult{} ,errCode{} ,errmsg{} ,", new Object[]{cacheModel.getCalcResult(), cacheModel.getErrCode(), cacheModel.getErrMsg()});
            if (!(!StringUtils.isNotBlank((String)cacheModel.getOrder().getOriginSeqNo()) || SellType.isGroupbuy((String)cacheModel.getOrder().getOrderType(), (boolean)cacheModel.getOrder().getHasGroupBuy()) || SellType.isDfSale((String)cacheModel.getOrder().getOrderType()) || cacheModel.getPopMode() != 1 && cacheModel.getPopMode() != 2 && cacheModel.getPopMode() != 3)) {
                respBase = this.calcPopRemoteService.calcCouponGain(session, cacheModel, netType, newTerminalSno);
                log.info("\u53d1\u9001\u5230\u8425\u9500\u4e2d\u5fc3\u4fdd\u5b58\u8ba2\u5355\u8fd4\u56de==>{}", (Object)JSONObject.toJSONString((Object)respBase));
                if (0 != respBase.getRetflag()) {
                    cacheModel.setCalcResult(-1);
                    cacheModel.setErrMsg(Code.CODE_60138.getMsg() + respBase.getRetmsg());
                    return cacheModel;
                }
                cacheModel = (CacheModel)respBase.getData();
            }
        }
        List coupons = cacheModel.getOrder().getCouponDetails();
        double point = 0.0;
        if (ArrayUtils.isNotEmpty((List)coupons)) {
            for (Coupon coupon : coupons) {
                if (!"JFA".equals(coupon.getCouponType()) && !"JFB".equals(coupon.getCouponType()) && !"JFXF".equals(coupon.getCouponType())) continue;
                point += coupon.getAmount();
            }
        } else {
            for (Payment payment : cacheModel.getPayments()) {
                if (!"JFA".equals(payment.getCouponType()) && !"JFB".equals(payment.getCouponType()) && !"JFXF".equals(payment.getCouponType())) continue;
                point += payment.getAmount();
            }
        }
        log.info(">>>>>>>>>>>>>\u9000\u8d27\u989d\u5916\u79ef\u5206\u79ef\u5206point==>{}", (Object)point);
        cacheModel.getOrder().setTotalPoint(ManipulatePrecision.add((double)point, (double)cacheModel.getOrder().getTotalPoint()));
        if (cacheModel.getOrder().getConsumersData() != null && cacheModel.getOrder().getConsumersData().getConsumersCard() != null && ("2".equals(cacheModel.getOrder().getConsumersData().getCustType()) || "GRP".equals(cacheModel.getOrder().getConsumersData().getConsumersType()))) {
            log.info("\u9000\u8d27\u4f1a\u5458\u4ea4\u6613\u6570\u636e\u4e0a\u9001");
            this.giveOrReverse(session, cacheModel);
        }
        String orgTerminalSno = cacheModel.getOrder().getTerminalSno();
        if (null != newTerminalSno && newTerminalSno.length() > 0) {
            cacheModel = this.posLogicCompoment.refreshTerminalSno(cacheModel, newTerminalSno);
        }
        log.info("\u9000\u5238\u5f00\u59cb!");
        if (null != cacheModel.getOrder().getConsumersData() && "MOHO".equals(cacheModel.getOrder().getConsumersData().getConsumersType())) {
            if (cacheModel.getOrder().getIsAllReturn()) {
                log.info("\u6d77\u9f0e\u5238\u64a4\u9500(\u6574\u5355\u9000)");
                RespBase resp = this.couponRemoteService.rollbackConsumeOrderCoupon(session, cacheModel);
                if (0 != resp.getRetflag()) {
                    throw new EfutureException(resp);
                }
            } else {
                log.info("\u90e8\u5206\u9000\u8d27\u4e0d\u9000\u5238");
            }
            RespBase respBase = this.calcPopRemoteService.saveTrade(session, cacheModel);
            if (0 != respBase.getRetflag()) {
                log.info("\u6d77\u9f0e\u8ba2\u5355\u4e0a\u9001\u5931\u8d25!");
                throw new EfutureException(respBase);
            }
        } else {
            List paymentList = cacheModel.getPayments();
            for (Payment payment : paymentList) {
                if ("HD".equals(payment.getPayMemo())) {
                    log.info("\u83b7\u53d6\u5230\u6d77\u9f0e\u5238");
                    JSONObject param = new JSONObject();
                    param.put("occuredAt", (Object)payment.getDescription());
                    param.put("occuredTime", (Object)payment.getOctopusTranscationTime());
                    param.put("terminal", (Object)payment.getTerminalNo());
                    param.put("transId", (Object)payment.getRefCode());
                    try {
                        log.info("\u8bf7\u6c42\u6d77\u9f0e\u5238\u9000\u6b3e\u5165\u53c2==>{}", (Object)JSONObject.toJSONString((Object)param));
                        String result = HdHttpRequest.doRequest((MohoHttpRequestEnum)MohoHttpRequestEnum.ROLLBACK, (String)JSONObject.parseObject((String)JSONObject.toJSONString((Object)param)).toJSONString());
                        log.info("\u8bf7\u6c42\u6d77\u9f0e\u5238\u9000\u6b3e\u51fa\u53c2==>{}", (Object)result);
                    }
                    catch (Exception e) {
                        log.info("\u9000\u5238\u5f02\u5e38", (Throwable)e);
                    }
                    continue;
                }
                if (!"LPK".equals(payment.getPayMemo())) continue;
                log.info("\u53cd\u6597\u57ce\u793c\u54c1\u5361");
                HashMap<String, String> data = new HashMap<String, String>();
                String url = "http://wechat.66card.com:8788/culsite/culapp/refundUnifyConsume";
                data.put("url", url);
                String apikey = "20230418";
                String secretKey = "AB1BEB395475A37426211475E5340064";
                String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
                data.put("secretKey", secretKey);
                data.put("apikey", apikey);
                data.put("timestamp", timestamp);
                String reverseOrderId = "UT" + System.currentTimeMillis();
                data.put("txnId", payment.getRefCode());
                data.put("refundOrderId", reverseOrderId);
                data.put("merId", "102335053110002");
                data.put("terminal", "33500022");
                data.put("machineId", "102335053110002");
                data.put("totalAmount", String.valueOf(payment.getAmount()));
                data.put("userId", cacheModel.getOrder().getTerminalOperator());
                data.put("iprfLevel", "F");
                JSONArray refundInfos = new JSONArray();
                JSONObject refund = new JSONObject();
                refund.put("cardNo", (Object)payment.getPayNo());
                refund.put("amount", (Object)String.valueOf(payment.getAmount()));
                refundInfos.add((Object)refund);
                data.put("refundInfos", refundInfos.toJSONString());
                ArrayList list = new ArrayList(data.values());
                log.info("list====>{}", (Object)JSONArray.toJSONString(list));
                Collections.sort(list);
                Object[] values = list.toArray(new String[0]);
                log.info(Arrays.toString(values));
                String mac = DigestUtils.md5Hex((String)StringUtils.join((Object[])values));
                data.put("mac", mac);
                log.info("mac:" + mac);
                HttpClientCBC hc = new HttpClientCBC(url);
                String resultString = "";
                try {
                    log.info("\u793c\u54c1\u5361\u9000\u8d27\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)data));
                    int status = hc.send((Map)data, "utf-8");
                    resultString = hc.getResult();
                    log.info("\u793c\u54c1\u5361\u9000\u8d27\u8fd4\u56de:{}", (Object)resultString);
                    if (200 == status) continue;
                    throw new EfutureException(new RespBase(500, "\u793c\u54c1\u5361\u9000\u8d27\u5931\u8d25" + hc.getResult()));
                }
                catch (Exception e) {
                    log.info("\u64a4\u9500\u6fc0\u6d3b\u5931\u8d25", (Throwable)e);
                    throw new EfutureException(new RespBase(500, "\u793c\u54c1\u5361\u9000\u8d27\u5f02\u5e38"));
                }
            }
        }
        ModeDetailsVo modeDetailsVoAL = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String taxRate = modeDetailsVoAL.getSysparaValue("taxrate");
        cacheModel.getOrder().setExtendFt6(taxRate);
        if (StringUtils.isNotBlank((String)taxRate)) {
            log.info("\u5f00\u59cb\u8ba1\u7b97\u7a0e\u989d");
            if (StringUtils.contains((String)taxRate, (String)"%")) {
                taxRate = taxRate.replace("%", "");
            }
            cacheModel.getPayments();
            Double d = 0.0;
            for (String[] payment : cacheModel.getPayments()) {
                PaymentMode payMode = PayModeUtils.getPayMode((String)payment.getPayCode(), (JSONObject)JSONObject.parseObject((String)obj));
                if (payMode != null) {
                    if (!StringUtils.isBlank((String)payMode.getRecordFlag()) && "Y".equals(payMode.getRecordFlag())) continue;
                    if (1 == payment.getInstallmentTerms()) {
                        log.info("{}\u5238\u8ba1\u7a0e", (Object)payment.getPayNo());
                        continue;
                    }
                    log.info("{}\u4e0d\u8ba1\u7a0e", (Object)payMode.getCode());
                    d = d + payment.getMoney();
                    continue;
                }
                log.info("{}\u652f\u4ed8\u65b9\u5f0f\u672a\u627e\u5230", (Object)payment.getPayCode());
            }
            double totalAmount = cacheModel.getOrder().getOughtPay() - d;
            int newScale = 2;
            if (FDCERPCODE.TW.getErpcode().equals(cacheModel.getOrder().getErpCode())) {
                newScale = 0;
            }
            BigDecimal noTaxAmount = BigDecimal.valueOf(totalAmount).divide(BigDecimal.valueOf(1.0 + Double.parseDouble(taxRate) / 100.0), 3, RoundingMode.HALF_UP);
            noTaxAmount = noTaxAmount.setScale(newScale, 4);
            BigDecimal taxAmount = BigDecimal.valueOf(totalAmount).subtract(noTaxAmount);
            taxAmount = taxAmount.setScale(newScale, 4);
            cacheModel.getOrder().setExtendFt5(noTaxAmount.toPlainString());
            cacheModel.getOrder().setExtendFt7(taxAmount.toPlainString());
        }
        cacheModel.getPayments().stream().filter(r -> {
            PaymentMode payMode = PayModeUtils.getPayMode((String)r.getPayCode(), (JSONObject)JSONObject.parseObject((String)obj));
            if (payMode != null) {
                return "Y".equals(payMode.getRecordFlag());
            }
            return false;
        }).forEach(record -> record.setInstallmentTerms(1));
        String shouka = SysPara.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"SKSP");
        log.info("\u552e\u5361\u53c2\u6570:{}", (Object)shouka);
        if (StringUtils.isNotBlank((String)shouka)) {
            String[] goodsCodes;
            block14: for (String code : goodsCodes = shouka.split(",")) {
                for (Goods goods : cacheModel.getGoodsList()) {
                    if (!code.equals(goods.getGoodsCode())) continue;
                    log.info("\u5b58\u5728\u552e\u5361\u5546\u54c1==>{}", (Object)JSONObject.toJSONString((Object)goods));
                    cacheModel.getOrder().setHasBackPrint(true);
                    continue block14;
                }
            }
        }
        SaleOrders order = this.orderTransfer.saleOrdersFromCacheModel(cacheModel);
        if (null != splitCode && !"".equals(splitCode)) {
            order.getSaleOrders().setShardingCode(splitCode);
        }
        order.getSaleOrders().setOrderState(Integer.valueOf(OrderStateEnum.T_YWC.getCode()));
        boolean online = true;
        if (this.localcache.booleanValue() || trainingMode) {
            online = false;
        }
        if (online) {
            TransformationUtils util = new TransformationUtils();
            SaleOrders_WSLF saleOrders = util.saleOrdersToSaleOrders_WSLF(order);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("data", saleOrders);
            String timeZone = modeDetailsVo.getSysparainfo().getTimeZone();
            if (StringUtils.isNotBlank((String)timeZone) && timeZone.contains(",")) {
                timeZone = timeZone.split(",")[0];
            }
            map.put("timeZone", timeZone);
            ServiceResponse rs = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, INSERTORDERALL, session, JSON.toJSONString(map), SaveOrdersOut.class, "\u8ba2\u5355\u4e2d\u5fc3", "\u4fdd\u5b58\u8ba2\u5355");
            sp.setRetflag(Integer.parseInt(rs.getReturncode()));
            sp.setData(rs.getData());
        } else {
            sp = this.orderPosUploadService.receiveOrderUpload(session, order, netType);
        }
        SaveOrdersOut saveOrdersOut = null;
        String sheetNo = "";
        if (!"0".equals(String.valueOf(sp.getRetflag())) && !"1".equals(String.valueOf(sp.getRetflag()))) {
            if ("101".equals(String.valueOf(sp.getRetflag())) || "201".equals(String.valueOf(sp.getRetflag()))) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("2002");
                cacheModel.setErrMsg(cacheModel.getOrder().getTerminalSno());
                try {
                    saveOrdersOut = (SaveOrdersOut)JSON.parseObject((String)sp.getData().toString(), SaveOrdersOut.class);
                    String terminalSno = saveOrdersOut.getTerminalSno();
                    String serviceSno = "";
                    ServiceResponse sNoResponse = new ServiceResponse();
                    if (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 2 || cacheModel.getPopMode() == 3) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.couponConsume(cacheModel, session, cacheModel.getPayConfirmStatus().intValue(), netType);
                    }
                    if (StringUtils.isNotBlank((String)terminalSno)) {
                        serviceSno = terminalSno;
                        sNoResponse.setReturncode("2002");
                        sNoResponse.setData((Object)serviceSno);
                        this.couponConsume(cacheModel, session, 8, netType);
                        cacheModel.setCalcResult(-1);
                        cacheModel.setErrCode("2002");
                        cacheModel.setErrMsg(serviceSno);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return cacheModel;
            }
            if (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 2 || cacheModel.getPopMode() == 3) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.couponConsume(cacheModel, session, cacheModel.getPayConfirmStatus().intValue(), netType);
            }
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("100000");
            cacheModel.setErrMsg(Code.CODE_60135.getMsg() + sp.getData().toString());
            return cacheModel;
        }
        saveOrdersOut = (SaveOrdersOut)JSON.parseObject((String)JSONObject.toJSONString((Object)sp.getData()), SaveOrdersOut.class);
        sheetNo = saveOrdersOut.getSheetNo();
        Order o = cacheModel.getOrder();
        if (this.excuteZuul(String.valueOf(sp.getRetflag()), sheetNo, o.getOrderType(), o.getTerminalSno(), o.getExistPay())) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode(String.valueOf(sp.getRetflag()));
            if (null == sp.getData() || "".equals(sp.getData().toString())) {
                cacheModel.setErrMsg(sp.getData().toString());
            } else {
                cacheModel.setErrMsg(sp.getData().toString());
            }
            return cacheModel;
        }
        cacheModel.getOrder().setSaveStatus(String.valueOf(sp.getRetflag()));
        cacheModel.getOrder().setSendSuccess(true);
        cacheModel.getOrder().setIdSheetNo(sheetNo);
        return cacheModel;
    }

    public boolean thirdVoidPayment(ServiceSession session, CacheModel cacheModel) {
        return true;
    }

    public RespBase getOrders(ServiceSession session, JSONObject paramsObject) {
        String orderType;
        String shardingCode;
        if (StringUtils.isBlank((String)paramsObject.getString("shopCode"))) {
            return Code.CODE_60001.getRespBase(new Object[]{"shopCode"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("entId"))) {
            return Code.CODE_60001.getRespBase(new Object[]{"entId"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("pageNo"))) {
            return Code.CODE_60001.getRespBase(new Object[]{"pageNo"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("pageSize"))) {
            return Code.CODE_60001.getRespBase(new Object[]{"pageSize"});
        }
        GetOrdersIn getOrdersIn = (GetOrdersIn)JSON.parseObject((String)paramsObject.toJSONString(), GetOrdersIn.class);
        if (getOrdersIn == null) {
            return Code.CODE_60015.getRespBase(new Object[]{"\u5165\u53c2\u8f6c\u6362\u5931\u8d25"});
        }
        session.setEnt_id(getOrdersIn.getEntId());
        OrderQueryIn orderQueryIn = OrderQueryIn.transferGetOrdersInToOrderQueryIn((GetOrdersIn)getOrdersIn);
        if (paramsObject.containsKey((Object)"splitCode") && StringUtils.isNotBlank((String)(shardingCode = paramsObject.getString("splitCode")))) {
            orderQueryIn.setShardingCode(shardingCode);
        }
        if (paramsObject.containsKey((Object)"orderType") && StringUtils.isNotBlank((String)(orderType = paramsObject.getString("orderType")))) {
            orderQueryIn.setOrderType(orderType);
        }
        log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)orderQueryIn));
        RespBase response = this.orderPosOuterService.searchOrders(session, (JSONObject)JSONObject.toJSON((Object)orderQueryIn));
        log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u63a5\u53e3\u8fd4\u56de\uff1a{}", (Object)JSONObject.toJSONString((Object)response));
        if (Code.SUCCESS.getIndex() == response.getRetflag()) {
            OrdersQueryOut data = new OrdersQueryOut();
            List ordersList = (List)response.getData();
            this.orderTransfer.transferOrderToGetOrdersOut(getOrdersIn, ordersList, ordersList.size());
            return new RespBase(Code.SUCCESS, (Object)this.orderTransfer.transferOrderToGetOrdersOut(getOrdersIn, ordersList, ordersList.size()), "ORDERLISTCERTIFY");
        }
        return response;
    }

    public RespBase getOrder(ServiceSession session, GetOrderIn getOrderIn) {
        try {
            if (StringUtils.isBlank((String)getOrderIn.getTerminalSno())) {
                return Code.CODE_60001.getRespBase(new Object[]{"terminalSno"});
            }
            OrderQueryIn in = new OrderQueryIn();
            in.setBusiTakeMarketCode(getOrderIn.getShopCode());
            in.setTerminalNo(getOrderIn.getTerminalNo());
            in.setTerminalSno(getOrderIn.getTerminalSno());
            in.setCreateDate(getOrderIn.getBillDate());
            in.setSearchType(getOrderIn.getSearchType());
            if (StringUtils.isNotBlank((String)getOrderIn.getShardingCode())) {
                in.setShardingCode(getOrderIn.getShardingCode());
            }
            return this.getOrder(session, getOrderIn, in);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u8c03\u7528\u8ba2\u5355\u5f02\u5e38", (Throwable)e);
            return new RespBase(Code.CODE_60007.getIndex(), e.getMessage());
        }
    }

    protected RespBase getOrder(ServiceSession session, GetOrderIn getOrderIn, OrderQueryIn in) {
        log.info("\u8ba2\u5355\u660e\u7ec6\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)in));
        RespBase resp = this.orderPosOuterService.searchOrdersDetail(session, (JSONObject)JSONObject.toJSON((Object)in));
        log.info("\u67e5\u9500\u552e\u8ba2\u5355\u8fd4\u56de\uff1a" + JSON.toJSONString((Object)resp.getData()));
        if (Code.SUCCESS.getIndex() != resp.getRetflag()) {
            if ("60003".equals(String.valueOf(resp.getRetflag()))) {
                return Code.CODE_60021.getRespBase(new Object[]{resp.getData()});
            }
            if ("10001".equals(String.valueOf(resp.getRetflag()))) {
                return Code.CODE_60021.getRespBase(new Object[]{resp.getData()});
            }
            log.info("\u83b7\u53d6\u8ba2\u5355\u5931\u8d25:" + resp.getData());
            return Code.CODE_60035.getRespBase(new Object[]{resp.getData()});
        }
        OrdersDetailOut getOrdersDetailOut = (OrdersDetailOut)JSONObject.toJavaObject((JSON)((JSONObject)JSONObject.toJSON((Object)resp.getData())), OrdersDetailOut.class);
        SaleOrders_WSLF saleOrder = new SaleOrders_WSLF();
        SaleOrders_WSLF oriOrder = null;
        saleOrder = getOrdersDetailOut.getOrderInfo();
        if (null == saleOrder.getOrders()) {
            return Code.CODE_60016.getRespBase(new Object[]{resp.getData()});
        }
        if (getOrderIn.isTailMoneyPay()) {
            if (SaleOrderStateEnum.YQX.getCode() == saleOrder.getOrders().getOrderState().intValue()) {
                return Code.CODE_60016.getRespBase(new Object[]{"\u539f\u5355\u5df2\u53d6\u6d88"});
            }
            if (!saleOrder.getOrders().isDepositSale() && !saleOrder.getOrders().isTailMoneyPay()) {
                return Code.CODE_60016.getRespBase(new Object[]{"\u539f\u5355\u975e\u9884\u5b9a\u9500\u552e"});
            }
            if (!saleOrder.getOrders().isTailMoneyPay()) {
                return Code.CODE_60016.getRespBase(new Object[]{"\u539f\u5355\u672a\u4ed8\u6e05\u5c3e\u6b3e,\u8bf7\u5148\u8fdb\u884c\u5c3e\u6b3e\u652f\u4ed8"});
            }
            if (saleOrder.getOrders().getOrderState() == 7) {
                return Code.CODE_60016.getRespBase(new Object[]{"\u539f\u5355\u5df2\u63d0\u8d27"});
            }
        }
        ArrayList<String> calcPriceType = new ArrayList<String>();
        if (!getOrderIn.isNoCacheModel()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("erpCode", (Object)getOrderIn.getErpCode());
            jsonObject.put("mkt", (Object)getOrderIn.getShopCode());
            jsonObject.put("code", (Object)"CWYH");
            RespBase res = this.initRemoteService.getSyspara(session, jsonObject);
            if (null != res && Code.SUCCESS.getIndex() == res.getRetflag()) {
                List data = (List)res.getData();
                Syspara s = (Syspara)data.get(0);
                log.info("CWYH\u7cfb\u7edf\u53c2\u6570\uff1a" + s.getParavalue());
                if (StringUtils.isNotBlank((String)s.getParavalue())) {
                    String[] values;
                    for (String code : values = s.getParavalue().split(",")) {
                        calcPriceType.add(code);
                    }
                }
            } else {
                log.info("\u672a\u627e\u5230\u8be5\u7cfb\u7edf\u53c2\u6570");
            }
        }
        if ("5".equals(saleOrder.getOrders().getOrderType())) {
            in = new OrderQueryIn();
            in.setBusiTakeMarketCode(getOrderIn.getShopCode());
            in.setOriginSheetNo(saleOrder.getOrders().getOriginSheetNo());
            in.setSearchType(getOrderIn.getSearchType());
            in.setTerminalNo(getOrderIn.getTerminalNo());
            in.setTerminalSno(getOrderIn.getTerminalSno());
            in.setCreateDate(getOrderIn.getBillDate());
            log.info("\u8ba2\u5355\u660e\u7ec6\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)in));
            resp = this.orderPosOuterService.searchOrdersDetail(session, (JSONObject)JSONObject.toJSON((Object)in));
            log.info(">>>\u67e5\u8ba2\u5355\u8fd4\u56de\uff1a" + JSON.toJSONString((Object)resp.getData()));
            if (Code.SUCCESS.getIndex() != resp.getRetflag()) {
                if ("60003".equals(String.valueOf(resp.getRetflag()))) {
                    return Code.CODE_60021.getRespBase(new Object[]{resp.getData()});
                }
                if ("10001".equals(String.valueOf(resp.getRetflag()))) {
                    return Code.CODE_60021.getRespBase(new Object[]{resp.getData()});
                }
                log.info("\u83b7\u53d6\u8ba2\u5355\u5931\u8d25:" + resp.getData());
                return Code.CODE_60035.getRespBase(new Object[]{resp.getData()});
            }
            OrdersDetailOut oriOrdersDetailOut = (OrdersDetailOut)JSONObject.toJavaObject((JSON)((JSONObject)JSONObject.toJSON((Object)resp.getData())), OrdersDetailOut.class);
            oriOrder = oriOrdersDetailOut.getOrderInfo();
        }
        boolean isReprint = true;
        if ("0".equals(getOrderIn.getType())) {
            isReprint = false;
        }
        PayConfirmOut out = this.toPayConfirmOut(session, saleOrder, oriOrder, calcPriceType, isReprint);
        if (3 == getOrderIn.getSearchType()) {
            double totalPoint = 0.0;
            if (null != getOrdersDetailOut.getOrderInfo().getOrdersMember()) {
                totalPoint = SellType.ISBACK((String)out.getOrder().getOrderType()) ? getOrdersDetailOut.getOrderInfo().getOrdersMember().getThisTimeUsablePoint() : out.getOrder().getConsumersData().getPoint() - out.getOrder().getThisTimeUsedPoint() + out.getOrder().getThisTimePoint();
            }
            log.info(">>>>>>>>>>>\u91cd\u6253\u5370\u79ef\u5206totalPoint==>{}", (Object)totalPoint);
            out.getOrder().setTotalPoint(totalPoint);
        } else if (out.getOrder().getConsumersData() != null && out.getOrder().getTotalPoint() != 0.0 && !"1".equals(out.getOrder().getOrderType())) {
            double totalPoint = out.getOrder().getTotalPoint() + out.getOrder().getThisTimeUsedPoint() - Math.abs(out.getOrder().getThisTimePoint());
            log.info(">>>>>>>>>>>\u79ef\u5206totalPoint==>{}", (Object)totalPoint);
            out.getOrder().setTotalPoint(totalPoint);
        }
        return new RespBase(Code.SUCCESS, (Object)out, "GETORDERMESSCERTIFY");
    }

    public RespBase saleReturnQuery(ServiceSession session, ResqVo vo) {
        try {
            JSONObject paramsObject = vo.getJsonObject();
            ParamsValidateUtil paramsValidateUtil = new ParamsValidateUtil(session, paramsObject);
            if (!paramsValidateUtil.validate()) {
                return paramsValidateUtil.getRespBase();
            }
            SaleReturnQueryIn saleReturnQueryIn = (SaleReturnQueryIn)JSON.parseObject((String)paramsObject.toJSONString(), SaleReturnQueryIn.class);
            CacheModel cacheModel = vo.getCacheModel();
            if (null == cacheModel) {
                return Code.CODE_60003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
            }
            if (StringUtils.isBlank((String)saleReturnQueryIn.getOldTerminalSno())) {
                return Code.CODE_60001.getRespBase(new Object[]{"oldTerminalSno"});
            }
            OrderQueryIn orderQueryIn = new OrderQueryIn();
            orderQueryIn.setTerminalNo(saleReturnQueryIn.getOldTerminalNo());
            orderQueryIn.setTerminalSno(saleReturnQueryIn.getOldTerminalSno());
            orderQueryIn.setBusiTakeMarketCode(saleReturnQueryIn.getOldShopCode());
            orderQueryIn.setCreateDate(saleReturnQueryIn.getBillDate());
            if ("2".equals(cacheModel.getOrder().getOrderType())) {
                if (!(saleReturnQueryIn.getShopCode().equals(saleReturnQueryIn.getOldShopCode()) && saleReturnQueryIn.getTerminalNo().equals(saleReturnQueryIn.getOldTerminalNo()) && DateUtils.isOrderToday((String)saleReturnQueryIn.getBillDate()))) {
                    return Code.CODE_60046.getRespBase(new Object[0]);
                }
                orderQueryIn.setSearchType(1);
            } else {
                orderQueryIn.setSearchType(2);
            }
            return this.getReturnOrder(session, paramsObject, saleReturnQueryIn, cacheModel, orderQueryIn);
        }
        catch (EfutureException e) {
            throw e;
        }
        catch (Exception e) {
            log.info("\u8c03\u7528\u8ba2\u5355\u5f02\u5e38", (Throwable)e);
            return Code.CODE_60007.getRespBase(new Object[]{e.getMessage()});
        }
    }

    protected CacheModel checkRedrush(CacheModel cacheModel, String accreditNo, ModeDetailsVo modeDetailsVo) {
        return cacheModel;
    }

    protected boolean checkOrderType(String oldOrderType, String orderType) {
        return true;
    }

    protected String checkPayment(CacheModel cacheModel) {
        return "";
    }

    public RespBase recordPrintLog(ServiceSession session, JSONObject paramsObject) {
        try {
            JSONObject response;
            log.info("recordPrintLog  begin--->{}", (Object)JSONObject.toJSONString((Object)paramsObject));
            RecordPrintLogIn in = (RecordPrintLogIn)JSONObject.toJavaObject((JSON)paramsObject, RecordPrintLogIn.class);
            QueryWrapper orderqueryWrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)orderqueryWrapper.eq((Object)"busiTakeMarketCode", (Object)in.getPShopCode())).eq((Object)"terminalNo", (Object)in.getPTerminalNo())).eq((Object)"terminalSno", (Object)in.getPTerminalSno());
            OrdersModel order = (OrdersModel)this.ordersModelService.selectOne((Wrapper)orderqueryWrapper, "orders");
            OperUserIn posManagerOperUserIn = new OperUserIn();
            posManagerOperUserIn.setGh(in.getTerminalOperator());
            if (this.cardIsSameWithGh()) {
                posManagerOperUserIn.setCardno(in.getTerminalOperator());
            }
            posManagerOperUserIn.setMkt(in.getShopCode());
            posManagerOperUserIn.setErpCode(order.getErpCode());
            posManagerOperUserIn.setSyjh(in.getTerminalNo());
            posManagerOperUserIn.setRandomCode(in.getTerminalOperator());
            posManagerOperUserIn.setFlag("N");
            if (1 == in.getType()) {
                posManagerOperUserIn.setFlag("Y");
            }
            if (null == (response = this.initializationRemoteService.empower(session, posManagerOperUserIn))) {
                return Code.CODE_60055.getRespBase(new Object[0]);
            }
            OperUserOut posManagerOperUserOut = (OperUserOut)JSONObject.parseObject((String)response.toJSONString(), OperUserOut.class);
            PosRoleManager role = posManagerOperUserOut.getPosrole();
            if ("Y".equals(posManagerOperUserIn.getFlag()) && "N".equals(role.getPrivdy())) {
                return Code.CODE_60102.getRespBase(new Object[0]);
            }
            int reprintnum = Convert.toInt((Object)role.getPrivqtje3());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"marketCode", (Object)in.getShopCode());
            queryWrapper.eq((Object)"sheetNo", (Object)order.getSheetNo());
            List printLogInfo = this.ordersPrintLogInfoModelService.selectList((Wrapper)queryWrapper, "ordersprintloginfo");
            int printCnt = 0;
            if (null != printLogInfo && printLogInfo.size() > 0) {
                printCnt = printLogInfo.size();
            }
            if (printCnt >= reprintnum) {
                return Code.CODE_10099.getRespBase(new Object[0]);
            }
            log.info("reprintnum:{}  \uff0cprintCnt\uff1a{}", (Object)reprintnum, (Object)printCnt);
            PrintLogIn appLogIn = new PrintLogIn();
            appLogIn.setMarketCode(in.getShopCode());
            appLogIn.setTerminalNo(in.getTerminalNo());
            appLogIn.setTerminalOperator(in.getTerminalOperator());
            appLogIn.setOriginMarketCode(in.getPShopCode());
            appLogIn.setOriginTerminalNo(in.getPTerminalNo());
            appLogIn.setOriginTerminalSno(in.getPTerminalSno());
            RespBase resp = this.postBackPrintLog(session, (JSONObject)JSON.toJSON((Object)appLogIn));
            String opgId = "";
            if (resp.getRetflag() != 0 && resp.getRetflag() != 1) {
                return Code.CODE_60103.getRespBase(new Object[0]);
            }
            opgId = resp.getData().toString();
            String back = "success";
            return new RespBase(Code.SUCCESS, back);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Code.CODE_60104.getRespBase(new Object[]{Utils.getLastExceptionMessage((Exception)e)});
        }
    }

    public boolean cardIsSameWithGh() {
        return true;
    }

    public PayConfirmOut toPayConfirmOut(ServiceSession session, SaleOrders_WSLF saleOrder, SaleOrders_WSLF oriOrder, List<String> calcPriceType, boolean isReprint) {
        PrintInfo printInfo;
        PayConfirmOut out = new PayConfirmOut();
        OrderForPos orderOut = this.orderTransfer.toOrderForPos(saleOrder);
        out.setRePrintCnt(saleOrder.getRePrintCnt());
        if (null != saleOrder.getOrders().getReturnReason()) {
            orderOut.setReason(saleOrder.getOrders().getReturnReason().toString());
        }
        log.info("orderOut\u9000\u8d27\u53c2\u6570\u8f6c\u6362\u5b8c\u6210");
        ArrayList<Payment> sellPayments = new ArrayList<Payment>();
        for (OrdersPayModel s : saleOrder.getOrdersPay()) {
            Payment p = new Payment();
            this.paymentTransfer.SaleOrderPayToPayment(s, p);
            log.info("payment\u8f6c\u6362\u5b8c\u62101");
            sellPayments.add(p);
        }
        orderOut.setSalePayments(sellPayments);
        log.info("payment\u8f6c\u6362\u5b8c\u6210");
        double noDiscountValueDzc = 0.0;
        ArrayList<Goods> goodsList = new ArrayList<Goods>();
        for (OrdersDetailModel s : saleOrder.getOrdersDetail()) {
            Object goods = new Goods();
            goods = this.goodsTransfer.SaleOrderDetailToGoods((Goods)goods, s);
            goodsList.add((Goods)goods);
            if (!"Y".equals(goods.getEscaleFlag())) continue;
            noDiscountValueDzc = ManipulatePrecision.doubleConvert((double)(noDiscountValueDzc + goods.getNoDisAmountValue()), (int)2, (int)1);
        }
        orderOut.setRealTotalDiscountValueDzc(ManipulatePrecision.doubleConvert((double)(orderOut.getTotalDiscountValue() - noDiscountValueDzc)));
        orderOut.setRealSaleValueDzc(ManipulatePrecision.doubleConvert((double)(orderOut.getSaleValue() - noDiscountValueDzc)));
        log.info("goods\u8f6c\u6362\u5b8c\u6210");
        if (null != saleOrder.getOrdersDetailPop() && saleOrder.getOrdersDetailPop().size() > 0) {
            for (int i = 0; i < goodsList.size(); ++i) {
                Goods goods = (Goods)goodsList.get(i);
                for (OrdersDetailPopModel orderPop : saleOrder.getOrdersDetailPop()) {
                    if (goods.getFlowId() != orderPop.getRowNo().intValue()) continue;
                    goods.getPopDetailsInfo().add(this.popdetailTransfer.transferPopDetail(orderPop));
                    if (YPopStatusType.pop_policy_group_barcode_discB.equals(orderPop.getPopPolicyGroup())) {
                        goods.setBarcodeDiscount(orderPop.getDiscountAmount().doubleValue());
                    }
                    goods = this.transExtendForOrderPop(orderPop, goods);
                }
            }
        }
        log.info("orderPop\u8f6c\u6362\u5b8c\u6210");
        if ("5".equals(saleOrder.getOrders().getOrderType()) && null != oriOrder) {
            ArrayList<Goods> origoodsList = new ArrayList<Goods>();
            for (OrdersDetailModel s : oriOrder.getOrdersDetail()) {
                Goods goods = new Goods();
                goods = this.goodsTransfer.SaleOrderDetailToGoods(goods, s);
                origoodsList.add(goods);
                if (!"Y".equals(goods.getEscaleFlag())) continue;
                noDiscountValueDzc = ManipulatePrecision.doubleConvert((double)(noDiscountValueDzc + goods.getNoDisAmountValue()), (int)2, (int)1);
            }
            ArrayList<Payment> oriPayments = new ArrayList<Payment>();
            for (int i = 0; i < oriOrder.getOrdersPay().size() - 1; ++i) {
                OrdersPayModel s = (OrdersPayModel)oriOrder.getOrdersPay().get(i);
                Payment p = new Payment();
                this.paymentTransfer.SaleOrderPayToPayment(s, p);
                oriPayments.add(p);
            }
            oriPayments.addAll(sellPayments);
            orderOut.setSalePayments(oriPayments);
            printInfo = this.printTransfer.convertPrintInfo(origoodsList);
        } else {
            printInfo = this.printTransfer.convertPrintInfo(goodsList);
        }
        log.info("printInfo\u8f6c\u6362\u5b8c\u6210");
        out.setPopInfo(new ArrayList());
        out.getPopInfo().addAll(printInfo.getMergedPopDetails());
        List goodListPops = this.goodsTransfer.transferGoodsToPosGoodsListForSave(printInfo.getGoodsListForPrint(), calcPriceType, true);
        orderOut.getGoodsList().addAll(goodListPops);
        OrderGains orderGain = this.orderTransfer.convertOrderGains(this.couponTransfer.transferCoupon4(saleOrder.getOrdersGain()), isReprint);
        log.info("orderGain\u8f6c\u6362\u5b8c\u6210");
        if (null != orderGain) {
            out.setCouponGain(orderGain.getOrderCouponGains());
            out.setAchievePoints(orderGain.getPoints());
            out.setExperience(orderGain.getExperience());
        }
        out.setOrder(orderOut);
        if (!"5".equals(saleOrder.getOrders().getOrderType()) && null != oriOrder) {
            OrderForPos oriOrderOut = this.orderTransfer.toOrderForPos(oriOrder);
            ArrayList<Payment> oriPayments = new ArrayList<Payment>();
            for (Object s : oriOrder.getOrdersPay()) {
                Payment p = new Payment();
                this.paymentTransfer.SaleOrderPayToPayment((OrdersPayModel)s, p);
                log.info("payment\u8f6c\u6362\u5b8c\u62101");
                oriPayments.add(p);
            }
            oriOrderOut.setSalePayments(oriPayments);
            log.info("payment\u8f6c\u6362\u5b8c\u6210");
            noDiscountValueDzc = 0.0;
            ArrayList<Goods> origoodsList = new ArrayList<Goods>();
            for (OrdersDetailModel s : oriOrder.getOrdersDetail()) {
                Goods goods = new Goods();
                goods = this.goodsTransfer.SaleOrderDetailToGoods(goods, s);
                origoodsList.add(goods);
                if (!"Y".equals(goods.getEscaleFlag())) continue;
                noDiscountValueDzc = ManipulatePrecision.doubleConvert((double)(noDiscountValueDzc + goods.getNoDisAmountValue()), (int)2, (int)1);
            }
            oriOrderOut.setRealTotalDiscountValueDzc(ManipulatePrecision.doubleConvert((double)(oriOrderOut.getTotalDiscountValue() - noDiscountValueDzc)));
            oriOrderOut.setRealSaleValueDzc(ManipulatePrecision.doubleConvert((double)(oriOrderOut.getSaleValue() - noDiscountValueDzc)));
            log.info("goods\u8f6c\u6362\u5b8c\u6210");
            PrintInfo oriPrintInfo = this.printTransfer.convertPrintInfo(origoodsList);
            log.info("printInfo\u8f6c\u6362\u5b8c\u6210");
            out.setOriginPopInfo(new ArrayList());
            out.getOriginPopInfo().addAll(oriPrintInfo.getMergedPopDetails());
            List oriGoodListPops = this.goodsTransfer.transferGoodsToPosGoodsListForSave(oriPrintInfo.getGoodsListForPrint(), calcPriceType, true);
            oriOrderOut.getGoodsList().addAll(oriGoodListPops);
            out.setOriginOrder(oriOrderOut);
        }
        return out;
    }

    public Goods transExtendForOrderPop(OrdersDetailPopModel orderPop, Goods goods) {
        return goods;
    }

    public CacheModel TransferCacheModelForReturn(SaleOrders_WSLF orderQueryOut, CacheModel cacheModel, boolean isHc) {
        Double totalQty = 0.0;
        ArrayList<Goods> goodslist = new ArrayList<Goods>();
        for (OrdersDetailModel saleDetail : orderQueryOut.getOrdersDetail()) {
            if (!isHc && "0".equals(saleDetail.getGoodsFlag()) || !isHc && "97".equals(saleDetail.getGoodType())) continue;
            totalQty = saleDetail.getWeighGood() != false && !this.posLogicCompoment.checkEscaleEditFlagForDetail((JSONObject)JSON.toJSON((Object)saleDetail)) ? Double.valueOf(totalQty + 1.0) : Double.valueOf(totalQty + saleDetail.getQty());
            goodslist.add(this.goodsTransfer.transferGoods2(saleDetail));
        }
        cacheModel.getOrder().setQty(totalQty.intValue());
        cacheModel.setReturnPayments(PaymentUtil.transferPayment((List)orderQueryOut.getOrdersPay()));
        String orderType = "4";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date saleDate = orderQueryOut.getOrders().getSaleDate();
            String billDate = this.computeBillDate(new Date());
            Date nowDate = TypeUtils.castToDate((Object)(billDate + BILL_END_TIME));
            if (cacheModel.getOrder().getOrderType().equals("2")) {
                if (saleDate.before(nowDate)) {
                    orderType = "4";
                } else {
                    orderType = "2";
                    List payments = cacheModel.getReturnPayments();
                    boolean unDis = true;
                    if (null != cacheModel.getOrder().getSysPara().getNoVoidPaymentCodes() && !cacheModel.getOrder().getSysPara().getNoVoidPaymentCodes().isEmpty()) {
                        for (Payment payment : payments) {
                            if (cacheModel.getOrder().getSysPara().getNoVoidPaymentCodes().indexOf(payment.getPayCode()) == -1) continue;
                            unDis = false;
                            break;
                        }
                    }
                    if (!unDis) {
                        orderType = "4";
                    }
                }
            }
            if (orderQueryOut.getOrders().getOrderType().equals("Y1")) {
                orderType = "Y2";
            }
            if (orderQueryOut.getOrders().getOrderType().equals("h")) {
                orderType = "i";
            } else if ("4".equals(orderType) && "Z1".equals(orderQueryOut.getOrders().getOrderType())) {
                orderType = "Z2";
            }
            if (orderQueryOut.getOrders().getOrderType().equals("YS1")) {
                orderType = isHc ? "YS2" : "YS4";
                Date bookingBillDate = orderQueryOut.getOrders().getBillDate();
                if (bookingBillDate.after(saleDate)) {
                    cacheModel.getOrder().setRealBillDate(sdf2.format(bookingBillDate));
                }
            } else if (orderQueryOut.getOrders().getOrderType().equals("KD1")) {
                orderType = isHc ? "KD2" : "KD4";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        cacheModel.setOrder(this.orderTransfer.transferRetrunOrder(orderQueryOut, cacheModel.getOrder(), orderType));
        double gainPoints = 0.0;
        if ("2".equals(cacheModel.getOrder().getOrderType()) && orderQueryOut.getOrdersGainDetail() != null && !orderQueryOut.getOrdersGainDetail().isEmpty()) {
            List orderGainDetails = orderQueryOut.getOrdersGainDetail();
            for (int i = 0; i < orderGainDetails.size(); ++i) {
                OrdersGainDetailModel ordersGainDetailModel = (OrdersGainDetailModel)orderGainDetails.get(i);
                if ("01".equals(ordersGainDetailModel.getCouponGroup())) {
                    gainPoints = ManipulatePrecision.add((double)gainPoints, (double)ordersGainDetailModel.getAmount().doubleValue());
                }
                for (int j = 0; j < goodslist.size(); ++j) {
                    Goods goods = (Goods)goodslist.get(j);
                    if (goods.getFlowId() != ordersGainDetailModel.getRowNo().intValue()) continue;
                    if (goods.getCouponGains() == null) {
                        goods.setCouponGains(new ArrayList());
                    }
                    goods.getCouponGains().add(this.goodsTransfer.transferCouponGain(ordersGainDetailModel));
                }
            }
            if (null != orderQueryOut.getOrdersMember() && StringUtils.isNotBlank((String)orderQueryOut.getOrdersMember().getCid()) && null != orderQueryOut.getOrdersMember().getThisTimeGivePoint()) {
                cacheModel.getOrder().setThisTimePoint(-1.0 * orderQueryOut.getOrdersMember().getThisTimeGivePoint());
            }
        }
        if ("2".equals(orderType) && null != orderQueryOut.getOrdersDetailPop() && orderQueryOut.getOrdersDetailPop().size() > 0) {
            for (OrdersDetailPopModel orderPop : orderQueryOut.getOrdersDetailPop()) {
                int rowNo = orderPop.getRowNo() - 1;
                if (goodslist.size() < rowNo + 1) continue;
                ((Goods)goodslist.get(rowNo)).getPopDetailsInfo().add(this.popdetailTransfer.transferPopDetail(orderPop));
            }
            for (int i = 0; i < goodslist.size(); ++i) {
                Goods goods = (Goods)goodslist.get(i);
                if (!"97".equals(goods.getGoodsType())) continue;
                goodslist.remove(i);
                --i;
            }
        }
        log.info("popdetail\u884c\u6570\uff1a" + ((Goods)goodslist.get(0)).getPopDetailsInfo().size());
        if (null != orderQueryOut.getOrdersUseCoupon() && orderQueryOut.getOrdersUseCoupon().size() > 0) {
            for (OrdersDetailPopModel orderPop : orderQueryOut.getOrdersUseCoupon()) {
                int rowNo = orderPop.getRowNo() - 1;
                if (goodslist.size() < rowNo + 1) continue;
                ((Goods)goodslist.get(rowNo)).getCouponUses().add(this.couponTransfer.transferCouponUse3((OrdersUseCouponModel)orderPop, cacheModel.getOrder()));
            }
        }
        cacheModel.setReturnGoodsList(goodslist);
        return cacheModel;
    }

    public RespBase giveOrReverse(ServiceSession session, CacheModel cacheModel) {
        if (cacheModel == null) {
            return Code.CODE_60.getRespBase(new Object[]{cacheModel.getFlowNo()});
        }
        Order order = cacheModel.getOrder();
        ConsumersData member = order.getConsumersData();
        if (member == null) {
            return Code.CODE_60056.getRespBase(new Object[0]);
        }
        String tranId = "";
        String jthy = "";
        String jgdm = "";
        try {
            String obj = this.redisUtil.get(RedisKey.CACHEID + order.getShopCode() + order.getTerminalNo());
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
            jgdm = this.wslfTools.getJGDMCode(modeDetailsVo);
            log.info("JGDM{}", (Object)jgdm);
            if ("".equals(jgdm)) {
                return Code.CODE_60057.getRespBase(new Object[0]);
            }
            jthy = this.wslfTools.getJTHYCode(modeDetailsVo);
            log.info("JTHY{}", (Object)jthy);
            if ("".equals(jthy)) {
                return Code.CODE_60105.getRespBase(new Object[0]);
            }
            GlobalInfo.wslfvipIp = jthy.split(":")[0];
            GlobalInfo.wslfvipPort = Integer.valueOf(jthy.split(":")[1]);
            JSONObject queryTranId = new JSONObject();
            queryTranId.put("shopCode", (Object)jgdm);
            queryTranId.put("terminalNo", (Object)order.getTerminalNo());
            queryTranId.put("terminalOperator", (Object)order.getTerminalOperator());
            QuerySaleSeqnoReqDef querySaleSeqnoReqDef = new QuerySaleSeqnoReqDef(queryTranId);
            log.info("\u4f1a\u5458\u4e0a\u9001ID\u5165\u53c2{}", (Object)querySaleSeqnoReqDef.toString());
            QuerySaleSeqnoRevDef querySaleSeqnoRevDef = this.wslfTools.queryTranId(querySaleSeqnoReqDef);
            log.info("\u4f1a\u5458\u4e0a\u9001ID\u8fd4\u53c2{}", (Object)JSONObject.toJSONString((Object)querySaleSeqnoRevDef));
            if ("0".equals(querySaleSeqnoRevDef.getResult())) {
                tranId = querySaleSeqnoRevDef.getTranID();
                log.info("\u8bb0\u5f55\u4f1a\u5458\u6821\u9a8cID===>", (Object)tranId);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u96c6\u56e2\u4f1a\u5458\u4ea4\u6613ID\u5f02\u5e38" + e.fillInStackTrace());
            e.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            return Code.CODE_60106.getRespBase(new Object[0]);
        }
        if ("".equals(tranId)) {
            return Code.CODE_60106.getRespBase(new Object[0]);
        }
        try {
            SaleHeadReqDef saleHeadReqDef = new SaleHeadReqDef(cacheModel, jgdm);
            saleHeadReqDef.setTranID(tranId);
            StringBuffer sb = new StringBuffer();
            sb.append(saleHeadReqDef.toString());
            if (cacheModel.getGoodsList().size() > 0) {
                for (Goods goods : cacheModel.getGoodsList()) {
                    SaleComReqDef saleComReqDef = new SaleComReqDef(goods);
                    sb.append(saleComReqDef.toString());
                }
            }
            if (cacheModel.getPayments().size() > 0) {
                for (Payment payment : cacheModel.getPayments()) {
                    SalePayReqDef salePayReqDef = new SalePayReqDef(payment);
                    sb.append(salePayReqDef.toString());
                }
            }
            log.info("\u4f1a\u5458\u9500\u552e\u6570\u636e\u5165\u53c2{}", (Object)sb.toString());
            SaleHeadRevDef saleHeadRevDef = this.wslfTools.giveOrReverse(sb.toString());
            log.info("\u4f1a\u5458\u9500\u552e\u6570\u636e\u8fd4\u53c2{}", (Object)JSONObject.toJSONString((Object)saleHeadRevDef));
            if ("0".equals(saleHeadRevDef.getResult())) {
                order.setThisTimePoint(Double.valueOf(saleHeadRevDef.getCurPoint()).doubleValue());
                order.setTotalPoint(Double.valueOf(saleHeadRevDef.getResPoint()).doubleValue());
                if (StringUtils.isNotBlank((String)cacheModel.getOrder().getOriginTerminalSno())) {
                    order.setTotalPoint(ManipulatePrecision.doubleConvert((double)(Double.valueOf(saleHeadRevDef.getResPoint()) - Double.valueOf(saleHeadRevDef.getCurPoint()))));
                } else {
                    order.setTotalPoint(Double.valueOf(saleHeadRevDef.getResPoint()).doubleValue());
                }
            }
        }
        catch (Exception e) {
            log.info("\u4f1a\u5458\u4e0a\u4f20\u9500\u552e\u6570\u636e\u5f02\u5e38:" + e.getMessage());
            e.printStackTrace();
            return new RespBase(Code.CODE_60, (Object)"\u4f1a\u5458\u4e0a\u4f20\u9500\u552e\u6570\u636e\u5f02\u5e38", cacheModel.getFlowNo());
        }
        log.info("\u4f1a\u5458\u9500\u552e\u6570\u636e{}\u4e0a\u4f20\u5b8c\u6bd5", (Object)cacheModel.getFlowNo());
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        log.info("\u51fa\u53c2\u8f93\u51fa" + JSON.toJSON((Object)new RespBase(Code.SUCCESS, (Object)resqVo, "WSLFVIP")));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "WSLFVIP");
    }

    public RespBase sendVicRecharge(ServiceSession session, CacheModel cacheModel) {
        Order order = cacheModel.getOrder();
        JSONObject ob = new JSONObject();
        ob.put("codeType", (Object)"3");
        ob.put("shopCode", (Object)order.getShopCode());
        ob.put("terminalNo", (Object)order.getTerminalNo());
        ob.put("terminalOperator", (Object)order.getTerminalOperator());
        ob.put("flowNo", (Object)cacheModel.getFlowNo());
        ob.put("erpCode", (Object)order.getErpCode());
        ob.put("codeValue", (Object)cacheModel.getCodeValue());
        ob.put("terminalSno", (Object)order.getTerminalSno());
        ob.put("payCode", (Object)"");
        ob.put("password", (Object)"");
        ob.put("tradeAmt", (Object)cacheModel.getCodeAmount());
        return this.yktRemoteService.sendVicRecharge(session, ResqVo.buildReqVo((CacheModel)cacheModel), ob);
    }

    public RespBase receiveOrderSync(ServiceSession session, JSONObject paramsObject) {
        log.info("\u540c\u6b65\u8ba2\u5355\u5165\u53c2\uff1a" + paramsObject.toJSONString());
        try {
            JSONArray orderArray = paramsObject.getJSONArray("orders");
            List succList = new ArrayList();
            List failList = new ArrayList();
            String splitcode = "posshop:log:" + paramsObject.get((Object)"shopCode");
            String splitodevalue = "";
            log.info("redis\u5206\u5e93\u7801key\u503c\uff1a" + splitcode);
            if (this.redisUtil.hasKey(splitcode)) {
                splitodevalue = (String)this.redisUtil.hget(splitcode, "splitCode");
                log.info("shardingcode Value : " + splitodevalue);
                if (null == splitodevalue) {
                    splitodevalue = "";
                }
            }
            String timeZone = "";
            boolean hqsq = false;
            if (!this.localcache.booleanValue()) {
                for (int i = 0; i < orderArray.size(); ++i) {
                    JSONObject orderJson = (JSONObject)orderArray.get(i);
                    SaleOrders_WSLF orders = (SaleOrders_WSLF)JSONObject.parseObject((String)orderJson.toJSONString(), SaleOrders_WSLF.class);
                    if (!hqsq) {
                        String obj = this.redisUtil.get(RedisKey.CACHEID + orders.getOrders().getBusiTakeMarketCode() + orders.getOrders().getTerminalNo());
                        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
                        timeZone = modeDetailsVo.getSysparainfo().getTimeZone();
                        hqsq = true;
                    }
                    if (!StringUtils.isNotBlank((String)timeZone)) continue;
                    OrdersModel4Pos order = orders.getOrders();
                    order.setPayDate(TimeZoneUtil.ConvertTimeByTimeZone((Date)order.getPayDate(), (String)timeZone));
                    order.setCreateDate(TimeZoneUtil.ConvertTimeByTimeZone((Date)order.getCreateDate(), (String)timeZone));
                    order.setSaleDate(TimeZoneUtil.ConvertTimeByTimeZone((Date)order.getSaleDate(), (String)timeZone));
                    orders.getOrdersExt().setCreateDate(TimeZoneUtil.ConvertTimeByTimeZone((Date)orders.getOrdersExt().getCreateDate(), (String)timeZone));
                    if (null != orders.getOrdersMember()) {
                        orders.getOrdersMember().setCreateDate(TimeZoneUtil.ConvertTimeByTimeZone((Date)orders.getOrdersMember().getCreateDate(), (String)timeZone));
                    }
                    if (null != orders.getOrdersDetail()) {
                        for (OrdersDetailModel saleOrderDetailModel : orders.getOrdersDetail()) {
                            saleOrderDetailModel.setCreateDate(TimeZoneUtil.ConvertTimeByTimeZone((Date)saleOrderDetailModel.getCreateDate(), (String)timeZone));
                        }
                    }
                    if (null != orders.getOrdersPay()) {
                        for (OrdersPayModel saleOrderPayModel : orders.getOrdersPay()) {
                            saleOrderPayModel.setCreateDate(TimeZoneUtil.ConvertTimeByTimeZone((Date)saleOrderPayModel.getCreateDate(), (String)timeZone));
                        }
                    }
                    orderArray.set(i, (Object)orders);
                }
                HashMap<String, JSONArray> map = new HashMap<String, JSONArray>();
                map.put("data", orderArray);
                HttpUtils httpUtils = new HttpUtils();
                ServiceResponse resp = httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, SYNC, session, JSON.toJSONString(map), SyncOutData.class, "\u8ba2\u5355\u4e2d\u5fc3", "\u540c\u6b65\u8ba2\u5355");
                if ("0".equals(resp.getReturncode())) {
                    SyncOutData res = (SyncOutData)resp.getData();
                    succList = res.getSuccess();
                    failList = res.getFail();
                } else {
                    return Code.CODE_60036.getRespBase(new Object[0]);
                }
            }
            JSONObject result = new JSONObject();
            result.put("success", succList);
            result.put("fail", failList);
            return new RespBase(Code.SUCCESS, (Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Code.FAIL.getRespBase(new Object[]{e.getMessage()});
        }
    }

    public String computeBillDate(Date createDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            String searchDate = dateFormat.format(createDate);
            Date whenDate = TypeUtils.castToDate((Object)(searchDate + BILL_END_TIME));
            if (createDate.after(whenDate)) {
                return searchDate;
            }
            if (createDate.equals(whenDate)) {
                return searchDate;
            }
            return DateHelpUtil.getYestoryDate((String)searchDate);
        }
        catch (Exception e) {
            log.error("\u8ba2\u5355\u4e2d\u5fc3\u8ba1\u7b97\u8bb0\u8d26\u65e5\u671f\u5931\u8d25: " + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public RespBase payConfirm(ServiceSession session, ResqVo vo) {
        RespBase respBase = super.payConfirm(session, vo);
        this.sendZexSYNC(vo);
        this.changeTerminalSnoSYNC(session, vo);
        this.cancelInvoiceSync(vo);
        log.info("\u8ba2\u5355\u5b8c\u6210\u8fd4\u56de!");
        return respBase;
    }

    protected void cancelInvoiceSync(ResqVo vo) {
        log.info("\u7ea2\u51b2\u53d1\u7968!");
        CacheModel cacheModel = vo.getCacheModel();
        String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getSyjmain().getMkt() + cacheModel.getSyjmain().getSyjh());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        List sysParaList = modeDetailsVo.getSyspara();
        JSONArray sysParaArray = JSONArray.parseArray((String)JSON.toJSONString((Object)sysParaList));
        String FWBB = null;
        if (sysParaArray.size() != 0) {
            for (int i = 0; i < sysParaArray.size(); ++i) {
                JSONObject sys = sysParaArray.getJSONObject(i);
                if (!"FWBB".equals(sys.get((Object)"code"))) continue;
                log.info("\u627e\u5230FWBB==>{}", (Object)sys.getString("paravalue"));
                FWBB = sys.getString("paravalue");
                break;
            }
        }
        if ("MOHO".equals(FWBB) && SellType.ISBACK((String)cacheModel.getOrder().getOrderType())) {
            log.info("MOHO\u5f00\u59cb\u7ea2\u51b2\u53d1\u7968!");
            CustomAsyncScheduler.getInstance().getChnlBackendQueryPool().execute(() -> {
                JSONObject request = new JSONObject();
                request.put("entid", (Object)"994439725063796288");
                String originTerminalSno = cacheModel.getOrder().getOriginTerminalSno();
                String refsheetid = cacheModel.getSyjmain().getMkt() + "-" + cacheModel.getSyjmain().getSyjh() + "-" + Long.parseLong(originTerminalSno);
                request.put("refsheetid", (Object)refsheetid);
                request.put("sheetid", (Object)(cacheModel.getSyjmain().getMkt() + "-" + cacheModel.getSyjmain().getSyjh() + "-" + Long.parseLong(cacheModel.getOrder().getTerminalSno())));
                request.put("shopid", (Object)cacheModel.getSyjmain().getMkt());
                log.info("IEGO\u53d6\u6d88\u53d1\u7968\u5165\u53c2==>{}", (Object)request.toJSONString());
                String encode = null;
                try {
                    encode = URLEncoder.encode(request.toJSONString(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    log.info("encode\u8f6c\u7801\u5f02\u5e38", (Throwable)e);
                }
                String encodeToString = Base64.getEncoder().encodeToString(encode.getBytes());
                log.info("encodeToString==>{}", (Object)encodeToString);
                JSONObject json = new JSONObject();
                json.put("data", (Object)encodeToString);
                String response = MohoHttpRequest.reverseInvoice((String)json.toJSONString());
                log.info("IEGO\u53d6\u6d88\u53d1\u7968\u51fa\u53c2<=={}", (Object)response);
            });
        }
    }

    private void changeTerminalSnoSYNC(ServiceSession session, ResqVo vo) {
        log.info("Syjmode\uff1a{}", (Object)vo.getCacheModel().getSyjmain().getSyjmode());
        if ("9".equals(vo.getCacheModel().getSyjmain().getSyjmode())) {
            log.info("\u5f02\u6b65\u6267\u884c\u81ea\u52a9\u4fee\u6539\u5c0f\u7968\u53f7\u63a5\u53e3\u5f00\u59cb!");
            CustomAsyncScheduler.getInstance().getChnlBackendQueryPool().execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void sendZexSYNC(ResqVo vo) {
        CacheModel cacheModel = vo.getCacheModel();
        String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getSyjmain().getMkt() + cacheModel.getSyjmain().getSyjh());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        List sysParaList = modeDetailsVo.getSyspara();
        JSONArray sysParaArray = JSONArray.parseArray((String)JSON.toJSONString((Object)sysParaList));
        String isSendZex = "N";
        if (sysParaArray.size() != 0) {
            for (int i = 0; i < sysParaArray.size(); ++i) {
                JSONObject sys = sysParaArray.getJSONObject(i);
                if (!"ISZEX".equals(sys.get((Object)"code"))) continue;
                log.info("\u627e\u5230ISZEX==>{}", (Object)sys.getString("paravalue"));
                isSendZex = sys.getString("paravalue");
                break;
            }
        }
        log.info("\u5224\u65ad\u662f\u5426\u4e0a\u4f20\u77e5\u800c\u884c ISZEX==>{}", (Object)isSendZex);
        if ("Y".equalsIgnoreCase(isSendZex)) {
            log.info("\u5f02\u6b65\u6267\u884c\u77e5\u800c\u884c\u63d0\u4ea4\u8ba2\u5355\u63a5\u53e3\u5f00\u59cb!");
            CustomAsyncScheduler.getInstance().getChnlBackendQueryPool().execute(() -> {
                log.info("OrderSaleBSImpl_WSLF ==> payConfirm method: \u6267\u884c\u5f02\u6b65\u4efb\u52a1[\u77e5\u800c\u884c]{} ", (Object)1);
                this.zexTransAction(vo);
            });
        }
    }

    private void zexTransAction(ResqVo vo) {
        try {
            CacheModel cacheModel = vo.getCacheModel();
            JSONObject jsonRequest = this.getRequest(cacheModel);
            String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getSyjmain().getMkt() + cacheModel.getSyjmain().getSyjh());
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
            String zexIp = SysPara.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"ZEXIP");
            if (StringUtils.isBlank((String)zexIp)) {
                log.info("ZEXIP\u53c2\u6570\u672a\u914d\u7f6e,\u4e0d\u6267\u884c\u77e5\u800c\u884c\u63d0\u4ea4!");
                return;
            }
            if (SellType.ISBACK((String)cacheModel.getOrder().getOrderType())) {
                log.info("\u9000\u8d27\u4e0d\u63d0\u4ea4\u77e5\u800c\u884c!");
                return;
            }
            String url = zexIp + "/zex/ws/transAction";
            Map sParaTemp = SubmitUtil.paraFilter((Map)jsonRequest);
            Object prestr = SubmitUtil.createLinkString((Map)sParaTemp);
            log.info("\u6392\u5e8f==>{}", prestr);
            prestr = (String)prestr + "&" + this.signKey;
            log.info("\u6392\u5e8f\u5b8c\u6210==>{}", prestr);
            String sign = org.springframework.util.DigestUtils.md5DigestAsHex((byte[])((String)prestr).getBytes());
            jsonRequest.put("sign", (Object)sign);
            log.info("\u77e5\u800c\u884c\u8ba2\u5355\u5b8c\u6210\u5165\u53c2==>{}", (Object)JSONObject.toJSONString((Object)jsonRequest));
            String response = HttpClientUtils.postJson((String)url, (String)"UTF-8", (String)JSONObject.toJSONString((Object)jsonRequest), (int)5000, (int)5000);
            log.info("\u77e5\u800c\u884c\u8ba2\u5355\u5b8c\u6210\u8fd4\u56de{}", (Object)response);
            if (StringUtils.isBlank((String)response)) {
                log.info("\u77e5\u800c\u884c\u8ba2\u5355\u5b8c\u6210\u5f02\u5e38\u8fd4\u56de{}", (Object)response);
            }
        }
        catch (Exception e) {
            log.info("\u77e5\u800c\u884c\u8ba2\u5355\u5b8c\u6210\u63a5\u53e3\u5f02\u5e38!", (Throwable)e);
        }
    }

    private JSONObject getRequest(CacheModel cacheModel) {
        JSONObject request = new JSONObject();
        request.put("shopId", (Object)cacheModel.getSyjmain().getMkt().substring(0, 4));
        request.put("listNo", (Object)cacheModel.getOrder().getTerminalSno());
        request.put("posNo", (Object)cacheModel.getSyjmain().getSyjh());
        if (null != cacheModel.getOrder().getConsumersData().getConsumersCard()) {
            request.put("memberCard", (Object)cacheModel.getOrder().getConsumersData().getConsumersCard());
        }
        List goodsList = cacheModel.getGoodsList();
        JSONArray zexGoodsList = new JSONArray();
        for (int i = 0; i < goodsList.size(); ++i) {
            Goods goods = (Goods)goodsList.get(i);
            JSONObject zexGoods = new JSONObject();
            zexGoods.put("lineNo", (Object)(i + 1));
            zexGoods.put("barcodeId", (Object)goods.getGoodsNo());
            zexGoods.put("price", (Object)BigDecimal.valueOf(goods.getSalePrice()));
            zexGoods.put("amount", (Object)BigDecimal.valueOf(goods.getSaleAmount()));
            zexGoods.put("num", (Object)BigDecimal.valueOf(goods.getQty()));
            zexGoods.put("goodsType", (Object)"ZY");
            zexGoods.put("moneyType", (Object)"RMB");
            zexGoods.put("goodsId", (Object)goods.getGoodsCode());
            zexGoods.put("deptId", (Object)goods.getCategoryCode());
            zexGoodsList.add((Object)zexGoods);
        }
        request.put("goodsList", (Object)zexGoodsList);
        JSONArray zexPayList = new JSONArray();
        List paymentList = cacheModel.getPayments();
        if (null != paymentList) {
            for (int i = 0; i < paymentList.size(); ++i) {
                Payment payment = (Payment)paymentList.get(i);
                JSONObject zexPay = new JSONObject();
                zexPay.put("payType", (Object)11);
                zexPay.put("cardNo", (Object)cacheModel.getOrder().getTerminalSno());
                zexPay.put("amount", (Object)BigDecimal.valueOf(payment.getAmount()));
                zexPayList.add((Object)zexPay);
            }
        }
        request.put("payList", (Object)zexPayList);
        return request;
    }

    public RespBase afterCheckOrderBalance(ServiceSession session, ResqVo vo) {
        RespBase respBase;
        CacheModel cacheModel;
        block17: {
            cacheModel = vo.getCacheModel();
            boolean upCacheModel = false;
            boolean isUseCard = false;
            List paymentList = cacheModel.getPayments();
            for (int i = 0; i < paymentList.size(); ++i) {
                if (((Payment)paymentList.get(i)).getIsSuccess()) continue;
                isUseCard = true;
                break;
            }
            if (isUseCard) {
                try {
                    RespBase respBase2 = this.yktRemoteService.cardWriteOff(session, vo);
                    if (null != respBase2 && Code.SUCCESS.getIndex() == respBase2.getRetflag()) {
                        cacheModel = (CacheModel)respBase2.getData();
                        if (cacheModel.getCalcResult() == 666) {
                            upCacheModel = true;
                            cacheModel.setCalcResult(0);
                            vo.setCacheModel(cacheModel);
                        }
                        break block17;
                    }
                    return Code.CODE_60058.getRespBase(new Object[]{respBase2.getRetmsg()});
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return Code.CODE_60059.getRespBase(new Object[]{e.getMessage()});
                }
            }
        }
        if ("U".equals(cacheModel.getOrder().getOrderType())) {
            log.info("\u793c\u54c1\u5361\u6fc0\u6d3b{}", (Object)(cacheModel.getFlowNo() + cacheModel.isYktFlag()));
            if (!cacheModel.isYktFlag()) {
                try {
                    RespBase respBase3 = this.sendVicRecharge(session, cacheModel);
                    if (null == respBase3 || Code.SUCCESS.getIndex() != respBase3.getRetflag()) {
                        return Code.CODE_60060.getRespBase(new Object[]{cacheModel.getErrMsg()});
                    }
                    ResqVo resqVo = (ResqVo)respBase3.getData();
                    cacheModel = resqVo.getCacheModel();
                }
                catch (Exception e) {
                    log.info("\u793c\u54c1\u5361\u6fc0\u6d3b\u5931\u8d25\u5f02\u5e38", (Throwable)e);
                    return Code.CODE_60060.getRespBase(new Object[]{e.getMessage()});
                }
                vo.setCacheModel(cacheModel);
            }
        }
        if (cacheModel.getOrder().getDfStatus() == 0 && "h".equals(cacheModel.getOrder().getOrderType())) {
            log.info("\u7535\u8d39\u4ee3\u6536");
            JSONObject payinfo = new JSONObject();
            payinfo.put("flowNo", (Object)cacheModel.getFlowNo());
            payinfo.put("consNo", (Object)((Goods)cacheModel.getGoodsList().get(0)).getRemark());
            if ("2".equals(((Payment)cacheModel.getPayments().get(0)).getFlag())) {
                payinfo.put("rcvAmt", (Object)ManipulatePrecision.sub((double)((Payment)cacheModel.getPayments().get(1)).getAmount(), (double)((Payment)cacheModel.getPayments().get(0)).getAmount()));
            } else {
                payinfo.put("rcvAmt", (Object)((Payment)cacheModel.getPayments().get(0)).getAmount());
            }
            payinfo.put("payFlag", (Object)"11");
            respBase = this.dfRemoteService.payment(session, ResqVo.buildReqVo((CacheModel)cacheModel), payinfo);
            log.info("\u7535\u8d39\u4ee3\u6536\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString((Object)respBase));
            if (null == respBase || Code.SUCCESS.getIndex() != respBase.getRetflag()) {
                return new RespBase(Code.CODE_50025.getIndex(), "\u7535\u8d39\u4ee3\u6536\u5f02\u5e38" + respBase.getRetmsg(), vo.getCacheModel().getFlowNo());
            }
            cacheModel = ((ResqVo)respBase.getData()).getCacheModel();
            vo.setCacheModel(cacheModel);
        }
        if (cacheModel.getOrder().getDfStatus() == 0 && "i".equals(cacheModel.getOrder().getOrderType())) {
            log.info("\u7535\u8d39\u5355\u7ea2\u51b2");
            JSONObject payinfo = new JSONObject();
            payinfo.put("flowNo", (Object)cacheModel.getFlowNo());
            payinfo.put("cannelFlowNo", (Object)cacheModel.getOrder().getExtendFt3());
            respBase = this.dfRemoteService.cancelPay(session, ResqVo.buildReqVo((CacheModel)cacheModel), payinfo);
            log.info("\u7535\u8d39\u5355\u7ea2\u51b2\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString((Object)respBase));
            if (null == respBase || Code.SUCCESS.getIndex() != respBase.getRetflag()) {
                return new RespBase(Code.CODE_50025.getIndex(), "\u7535\u8d39\u4ee3\u6536\u51b2\u6b63\u5f02\u5e38" + respBase.getRetmsg(), vo.getCacheModel().getFlowNo());
            }
            cacheModel = (CacheModel)respBase.getData();
            vo.setCacheModel(cacheModel);
        }
        return new RespBase(Code.SUCCESS, (Object)vo.getCacheModel());
    }

    public RespBase getPrintCount(ServiceSession session, JSONObject paramsObject) {
        ServiceResponse sr = ParamValidateUtil.checkParam((ServiceSession)session, (JSONObject)paramsObject, (String[])new String[]{"sheetNo", "terminalNo", "terminalOperator", "shopCode"});
        if (!sr.getReturncode().equals("0")) {
            return new RespBase(Code.SUCCESS, (Object)sr);
        }
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"marketCode", (Object)paramsObject.getString("shopCode"));
            if (this.eqOperator()) {
                queryWrapper.eq((Object)"terminalNo", (Object)paramsObject.getString("terminalNo"));
                queryWrapper.eq((Object)"terminalOperator", (Object)paramsObject.getString("terminalOperator"));
            }
            queryWrapper.eq((Object)"sheetNo", (Object)paramsObject.getString("sheetNo"));
            List printLogInfo = this.ordersPrintLogInfoModelService.selectList((Wrapper)queryWrapper, "ordersprintloginfo");
            JSONObject outobj = new JSONObject();
            int printCnt = 0;
            if (null != printLogInfo && printLogInfo.size() > 0) {
                printCnt = printLogInfo.size();
            }
            outobj.put("printCnt", (Object)printCnt);
            return new RespBase(Code.SUCCESS, (Object)outobj);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new RespBase(-1, "10000", e.getMessage());
        }
    }

    public boolean eqOperator() {
        return true;
    }

    public RespBase postBackPrintLog(ServiceSession session, JSONObject paramsObject) {
        ServiceResponse sr = ParamValidateUtil.checkParam((ServiceSession)session, (JSONObject)paramsObject, (String[])new String[]{"marketCode", "terminalNo", "terminalOperator", "originMarketCode", "originTerminalNo", "originTerminalSno"});
        if (!sr.getReturncode().equals("0")) {
            return new RespBase(Code.SUCCESS, (Object)sr);
        }
        try {
            QueryWrapper orderqueryWrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)orderqueryWrapper.eq((Object)"busiTakeMarketCode", (Object)paramsObject.getString("originMarketCode"))).eq((Object)"terminalNo", (Object)paramsObject.getString("originTerminalNo"))).eq((Object)"terminalSno", (Object)paramsObject.getString("originTerminalSno"));
            OrdersModel order = (OrdersModel)this.ordersModelService.selectOne((Wrapper)orderqueryWrapper, "orders");
            if (order == null) {
                return new RespBase(-1, "\u8ba2\u5355\u4e0d\u5b58\u5728");
            }
            OrdersPrintLogInfoModel model = new OrdersPrintLogInfoModel();
            Long opgId = paramsObject.containsKey((Object)"opgId") && !StringUtils.isEmpty((String)((String)paramsObject.get((Object)"opgId"))) ? paramsObject.getLong("opgId") : Long.valueOf(UniqueID.getUniqueID());
            model.setOpgId(opgId);
            model.setOid(order.getOid());
            model.setSheetNo(order.getSheetNo());
            model.setMarketCode(paramsObject.getString("marketCode"));
            model.setTerminalNo(paramsObject.getString("terminalNo"));
            model.setTerminalOperator(paramsObject.getString("terminalOperator"));
            model.setPrintCnt(Integer.valueOf(1));
            model.setPrintTime(new Date());
            this.ordersPrintLogInfoModelService.insert((Object)model, "ordersprintloginfo");
            return new RespBase(Code.SUCCESS, (Object)opgId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new RespBase(-1, "10000", e.getMessage());
        }
    }

    public RespBase uploadPrintLogData(ServiceSession session, JSONObject param) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((String)param.getString("mkt"))) {
            queryWrapper.eq((Object)"marketCode", (Object)param.getString("mkt"));
        }
        if (StringUtils.isNotBlank((String)param.getString("syjh"))) {
            queryWrapper.eq((Object)"terminalNo", (Object)param.getString("syjh"));
        }
        if (StringUtils.isNotBlank((String)param.getString("endTime"))) {
            queryWrapper.le((Object)"printTime", (Object)param.getString("endTime"));
        }
        List printLogInfoList = this.ordersPrintLogInfoModelService.selectList((Wrapper)queryWrapper, "ordersprintloginfo");
        log.info("\u67e5\u8be2\u5230printLog\u65e5\u5fd7\u4e3a{}\u6761", (Object)printLogInfoList.size());
        if (ArrayUtils.isNotEmpty((List)printLogInfoList)) {
            try {
                log.info("\u4e0a\u4f20\u672c\u5730printLog\u65e5\u5fd7!");
                JSONObject request = new JSONObject();
                request.put("list", (Object)printLogInfoList);
                request.put("command_id", (Object)"UPLOADPRINTLOG");
                String response = HttpClientUtils.postJson((String)GlobalInfo.cloudUrl, (String)"UTF-8", (String)JSONObject.toJSONString((Object)request), (int)5000, (int)15000);
                log.info("\u4e0a\u4f20\u672c\u5730printLog\u65e5\u5fd7\u8fd4\u56de==>{}", (Object)response);
                if (StringUtils.isNotBlank((String)response)) {
                    RespBase respBase = (RespBase)JSONObject.parseObject((String)response, RespBase.class);
                    JSONObject jsonResponse = JSONObject.parseObject((String)response);
                    int retFlag = jsonResponse.getInteger("returncode");
                    respBase.setRetflag(retFlag);
                    if (0 != retFlag) {
                        respBase.setRetmsg(jsonResponse.getString("data"));
                        return respBase;
                    }
                }
                ArrayList<Long> ids = new ArrayList<Long>();
                for (int i = 0; i < printLogInfoList.size(); ++i) {
                    ids.add(((OrdersPrintLogInfoModel)printLogInfoList.get(i)).getOpgId());
                }
                boolean b = true;
                List sprateList = ListUtils.partition(ids, (int)500);
                for (int p = 0; p < sprateList.size(); ++p) {
                    b = this.ordersPrintLogInfoModelService.removeByIds((Collection)sprateList.get(p));
                    if (b) continue;
                    log.info("\u672c\u5730printLog\u65e5\u5fd7\u5220\u9664\u5931\u8d25,\u7b2c{}\u9875", (Object)p);
                    return Code.FAIL.getRespBase(new Object[0]);
                }
                if (b) {
                    log.info("\u672c\u5730printLog\u65e5\u5fd7\u5220\u9664\u6210\u529f{}\u6761", (Object)printLogInfoList.size());
                } else {
                    log.info("\u672c\u5730printLog\u65e5\u5fd7\u5220\u9664\u5931\u8d25");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                log.info("\u7cfb\u7edf\u521d\u59cb\u5316\u8fde\u63a5\u7ebf\u4e0a\u5f02\u5e38:", (Throwable)e);
                return Code.FAIL.getRespBase(new Object[0]);
            }
        }
        return new RespBase(Code.SUCCESS, "");
    }

    public boolean savePrintLogBatch(ServiceSession session, JSONObject param) {
        log.info("savePrintLogBatch");
        JSONArray jsonList = param.getJSONArray("list");
        List list = JSONArray.parseArray((String)jsonList.toJSONString(), OrdersPrintLogInfoModel.class);
        return this.ordersPrintLogInfoModelService.saveBatch((Collection)list, "ordersprintloginfo");
    }

    protected String reCacheMode(String obj, JSONObject jsonObject) {
        if ("".equals(obj) || null == obj) {
            this.initRemoteService.reSaveCacheModel(null, jsonObject);
            obj = this.redisUtil.get(RedisKey.CACHEID + jsonObject.getString("shopCode") + jsonObject.getString("terminalNo"));
        }
        return obj;
    }

    public boolean isAllowHC(OrdersModel4Pos order) {
        String saleType = order.getOrderType();
        if (SellType.ISBACK((String)saleType)) {
            return false;
        }
        if ("5".equals(saleType)) {
            return false;
        }
        if ("Y19".equals(saleType)) {
            return false;
        }
        if ("Y12".equals(saleType)) {
            return false;
        }
        if ("U".equals(saleType)) {
            return false;
        }
        return !"Z1".equals(saleType);
    }

    public boolean isAllowBack(OrdersModel4Pos order) {
        String saleType = order.getOrderType();
        if (SellType.ISBACK((String)saleType)) {
            return false;
        }
        if ("5".equals(saleType)) {
            return false;
        }
        if ("Y19".equals(saleType)) {
            return false;
        }
        if ("Y12".equals(saleType)) {
            return false;
        }
        return !"U".equals(saleType);
    }

    public RespBase checkPay(ServiceSession session, JSONObject body) {
        CheckPayInVo inVo = (CheckPayInVo)JSONObject.parseObject((String)body.toJSONString(), CheckPayInVo.class);
        return this.doCheckPay(inVo.getOutTradeNo());
    }

    private RespBase doCheckPay(String outTradeNo) {
        String todayDate;
        String outTradeDate = outTradeNo.substring(4, 12);
        if (!outTradeDate.equals(todayDate = new SimpleDateFormat("yyyyMMdd").format(new Date()))) {
            return Code.CODE_60093.getRespBase(new Object[0]);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("payNo", outTradeNo);
        List list = this.ordersPayModelService.selectByMap(map, "orderspay");
        if (ArrayUtils.isNotEmpty((List)list)) {
            return Code.CODE_60094.getRespBase(new Object[]{outTradeNo});
        }
        return Code.SUCCESS.getRespBase(new Object[0]);
    }

    protected RespBase getReturnOrder(ServiceSession session, JSONObject paramsObject, SaleReturnQueryIn saleReturnQueryIn, CacheModel cacheModel, OrderQueryIn orderQueryIn) {
        String nowDateTime;
        String obj = this.redisUtil.get(RedisKey.CACHEID + saleReturnQueryIn.getShopCode() + saleReturnQueryIn.getTerminalNo());
        obj = this.reCacheMode(obj, paramsObject);
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        Order order = cacheModel.getOrder();
        if (StringUtils.isBlank((String)cacheModel.getOrder().getRefundAuthzCardNo())) {
            String cardnoString = saleReturnQueryIn.getTerminalOperator();
            if (StringUtils.isNotBlank((String)saleReturnQueryIn.getAccreditNo())) {
                cardnoString = saleReturnQueryIn.getAccreditNo();
            }
            OperUserIn posManagerOperUserIn = new OperUserIn();
            posManagerOperUserIn.setCardno(cardnoString);
            saleReturnQueryIn.setShopCode(posManagerOperUserIn.getMkt());
            posManagerOperUserIn.setErpCode(cacheModel.getOrder().getErpCode());
            posManagerOperUserIn.setFlag("N");
            saleReturnQueryIn.setTerminalNo(posManagerOperUserIn.getSyjh());
            OperUser op1 = new OperUser();
            cacheModel.setCurGrant(op1);
            JSONObject response = null;
            try {
                response = this.initializationRemoteService.empower(session, posManagerOperUserIn);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (null == response) {
                return Code.CODE_100023.getRespBase(new Object[]{"\u6388\u6743\u4eba\u5458\u4fe1\u606f"});
            }
            OperUserOut posManagerOperUserOut = (OperUserOut)JSONObject.parseObject((String)response.toJSONString(), OperUserOut.class);
            if (!"Y".equals(posManagerOperUserOut.getPosrole().getPrivth()) && !"T".equals(posManagerOperUserOut.getPosrole().getPrivth())) {
                return Code.CODE_60048.getRespBase(new Object[0]);
            }
            OperUser operUser = new OperUser(posManagerOperUserOut);
            cacheModel.setCurGrant(operUser);
            order.setRefundAuthzCardNo(operUser.getGh());
        }
        String splitCodeKey = "posshop:log:" + orderQueryIn.getBusiTakeMarketCode();
        log.info("redis\u5206\u5e93\u7801key\u503c\uff1a" + splitCodeKey);
        if (this.redisUtil.hasKey(splitCodeKey)) {
            String splitodevalue = (String)this.redisUtil.hget(splitCodeKey, "splitCode");
            log.info("shardingcode Value : " + splitodevalue);
            orderQueryIn.setShardingCode(splitodevalue);
        }
        log.info("\u8ba2\u5355\u4e2d\u5fc3\u63a5\u53e3\u8ba2\u5355\u67e5\u8be2:" + JSONObject.toJSON((Object)orderQueryIn));
        RespBase resp = this.orderPosOuterService.searchOrdersDetail(session, (JSONObject)JSONObject.toJSON((Object)orderQueryIn));
        if (Code.SUCCESS.getIndex() != resp.getRetflag()) {
            if ("60003".equals(String.valueOf(resp.getRetflag()))) {
                return Code.CODE_60021.getRespBase(new Object[]{resp.getData()});
            }
            log.info("\u8bf7\u6c42\u8ba2\u5355\u4e2d\u5fc3\u83b7\u53d6\u8ba2\u5355\u5931\u8d25:" + resp.getData());
            if ("4".equals(order.getOrderType())) {
                return Code.CODE_60033.getRespBase(new Object[0]);
            }
            if ("2".equals(order.getOrderType())) {
                return Code.CODE_60033.getRespBase(new Object[0]);
            }
            return resp;
        }
        OrdersDetailOut getOrdersDetailOut = (OrdersDetailOut)JSONObject.toJavaObject((JSON)((JSONObject)JSONObject.toJSON((Object)resp.getData())), OrdersDetailOut.class);
        SaleOrders_WSLF orderQueryOut = getOrdersDetailOut.getOrderInfo();
        if (!orderQueryIn.getBusiTakeMarketCode().equals(saleReturnQueryIn.getShopCode()) && paramsObject.containsKey((Object)"splitCode")) {
            String splitKey = "posshop:log:" + saleReturnQueryIn.getShopCode();
            String shardingCode = "";
            log.info(">>redis\u5206\u5e93\u7801key\u503c\uff1a" + splitKey);
            if (this.redisUtil.hasKey(splitKey)) {
                Iterator splitodevalue = (String)this.redisUtil.hget(splitKey, "splitCode");
                log.info(">>shardingcode Value : " + (String)((Object)splitodevalue));
                shardingCode = splitodevalue;
            }
            if (StringUtils.isNotBlank((String)shardingCode)) {
                if (orderQueryOut.getOrdersExt() != null) {
                    orderQueryOut.getOrdersExt().setShardingCode(shardingCode);
                }
                if (orderQueryOut.getOrdersMember() != null) {
                    orderQueryOut.getOrdersMember().setShardingCode(shardingCode);
                }
                for (OrdersDetailModel ordersDetailModel : orderQueryOut.getOrdersDetail()) {
                    ordersDetailModel.setShardingCode(shardingCode);
                }
                if (ArrayUtils.isNotEmpty((List)orderQueryOut.getOrdersDetailPop())) {
                    for (OrdersDetailPopModel ordersDetailPopModel : orderQueryOut.getOrdersDetailPop()) {
                        ordersDetailPopModel.setShardingCode(shardingCode);
                    }
                }
                if (ArrayUtils.isNotEmpty((List)orderQueryOut.getOrdersGain())) {
                    for (OrdersGainModel ordersGainModel : orderQueryOut.getOrdersGain()) {
                        ordersGainModel.setShardingCode(shardingCode);
                    }
                }
                if (ArrayUtils.isNotEmpty((List)orderQueryOut.getOrdersGainDetail())) {
                    for (OrdersGainDetailModel ordersGainDetail : orderQueryOut.getOrdersGainDetail()) {
                        ordersGainDetail.setShardingCode(shardingCode);
                    }
                }
                if (ArrayUtils.isNotEmpty((List)orderQueryOut.getOrdersUseCoupon())) {
                    for (OrdersUseCouponModel useCouponModel : orderQueryOut.getOrdersUseCoupon()) {
                        useCouponModel.setShardingCode(shardingCode);
                    }
                }
                for (OrdersPayModel ordersPay : orderQueryOut.getOrdersPay()) {
                    ordersPay.setShardingCode(shardingCode);
                }
            }
        }
        if (null == orderQueryOut) {
            return Code.CODE_60011.getRespBase(new Object[0]);
        }
        log.info("\u67e5\u8be2\u539f\u5355\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)orderQueryOut));
        String thrq = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"QHRQ");
        if (null != thrq && thrq.trim().length() > 0) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
            DateTimeFormatter formater2 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            LocalDate thDate = LocalDate.parse(thrq, formatter);
            LocalDate orderDate = LocalDate.parse(orderQueryOut.getOrders().getSaleDate().toString(), formater2);
            if (orderDate.isBefore(thDate)) {
                return Code.CODE_60030.getRespBase(new Object[]{thDate});
            }
        }
        double allowReturnCopies = 0.0;
        for (OrdersDetailModel detail : orderQueryOut.getOrdersDetail()) {
            if ("0".equals(detail.getGoodsFlag())) continue;
            if ("2".equals(cacheModel.getOrder().getOrderType()) && ManipulatePrecision.doubleCompare((double)detail.getAllowReturnCopies(), (double)detail.getQty(), (int)4) != 0) {
                return Code.CODE_60019.getRespBase(new Object[]{"" + detail.getRowNo()});
            }
            allowReturnCopies += detail.getAllowReturnCopies().doubleValue();
        }
        if (allowReturnCopies <= 0.0) {
            return Code.CODE_60020.getRespBase(new Object[0]);
        }
        boolean isHc = false;
        if ("2".equals(cacheModel.getOrder().getOrderType())) {
            isHc = true;
        }
        if ("2".equals(cacheModel.getOrder().getOrderType())) {
            if (!this.isAllowHC(orderQueryOut.getOrders())) {
                return Code.CODE_60049.getRespBase(new Object[0]);
            }
            log.info("\u9884\u5b9a\u5355,\u5df2\u4ed8\u5c3e\u6b3e,\u5df2\u7b7e\u6536\u7684:" + orderQueryOut.getOrders().isDepositSale() + orderQueryOut.getOrders().isTailMoneyPay() + orderQueryOut.getOrders().getLogisticsState());
            if (orderQueryOut.getOrders().isDepositSale() && orderQueryOut.getOrders().isTailMoneyPay() && 6 == orderQueryOut.getOrders().getLogisticsState()) {
                log.info("\u5c3e\u6b3e\u652f\u4ed8\u5b8c\u6210\u8ba2\u5355\u4e0d\u5141\u8bb8\u6d88\u5355");
                return Code.CODE_60050.getRespBase(new Object[0]);
            }
        } else if (!this.isAllowBack(orderQueryOut.getOrders())) {
            return Code.CODE_60051.getRespBase(new Object[0]);
        }
        if (!SellType.ISBACK((String)order.getOrderType())) {
            return Code.CODE_60052.getRespBase(new Object[0]);
        }
        String paraValue = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"XDFS");
        ArrayList unDisOrderPayCodes = new ArrayList();
        String payString = "";
        if (null != paraValue) {
            payString = paraValue;
        }
        if (StringUtils.isNotEmpty((String)payString)) {
            Collections.addAll(unDisOrderPayCodes, payString.split(","));
        }
        if ("2".equals(cacheModel.getOrder().getOrderType())) {
            JSONObject object3;
            String paravalue1 = "1";
            JSONArray array = new JSONArray();
            List sysParaList = modeDetailsVo.getSyspara();
            JSONArray sysParaArray = JSONArray.parseArray((String)JSON.toJSONString((Object)sysParaList));
            if (sysParaArray.size() != 0) {
                for (int i = 0; i < sysParaArray.size(); ++i) {
                    JSONObject sys = sysParaArray.getJSONObject(i);
                    if (!"XDFS".equals(sys.get((Object)"code"))) continue;
                    array.add((Object)sys);
                }
            }
            if (array.size() != 0 && (object3 = array.getJSONObject(0)).containsKey((Object)"paravalue")) {
                paravalue1 = object3.getString("paravalue");
            }
            String[] temp = paravalue1.split(",");
            List payModeList = orderQueryOut.getOrdersPay();
            if (temp.length > 0) {
                for (int j = 0; j < temp.length; ++j) {
                    for (OrdersPayModel payModel : payModeList) {
                        if (!payModel.getPayCode().equals(temp[j])) continue;
                        return Code.CODE_60032.getRespBase(new Object[0]);
                    }
                }
            }
        }
        String authCardNo = cacheModel.getOrder().getTerminalOperatorAuthzCardNo();
        String thAuthCardNo = cacheModel.getOrder().getRefundAuthzCardNo();
        String oldOrderType = cacheModel.getOrder().getOrderType();
        if (!this.checkOrderType(oldOrderType, (cacheModel = this.TransferCacheModelForReturn(orderQueryOut, cacheModel, isHc)).getOrder().getOrderType())) {
            return Code.CODE_60053.getRespBase(new Object[0]);
        }
        cacheModel = this.checkRedrush(cacheModel, saleReturnQueryIn.getAccreditNo(), modeDetailsVo);
        String message = this.checkPayment(cacheModel);
        if ("i".equals(cacheModel.getOrder().getOrderType())) {
            JSONObject dfquery = new JSONObject();
            dfquery.put("flowNo", (Object)cacheModel.getFlowNo());
            dfquery.put("consNo", (Object)((Goods)cacheModel.getReturnGoodsList().get(0)).getRemark());
            RespBase respBase = this.dfRemoteService.queryOweInfo(session, ResqVo.buildReqVo((CacheModel)cacheModel), dfquery);
            log.info("\u7535\u8d39\u5355\u7ea2\u51b2\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString((Object)respBase));
            if (null == respBase || Code.SUCCESS.getIndex() != respBase.getRetflag()) {
                return Code.CODE_60054.getRespBase(new Object[]{respBase.getRetmsg()});
            }
            cacheModel = (CacheModel)respBase.getData();
        }
        if (StringUtils.isBlank((String)(nowDateTime = TimeZoneUtil.ConvertTimeByTimeZone1((Date)new Date(), (String)order.getTimeZone(), (Boolean)this.localcache)))) {
            LocalDateTime dateTime = LocalDateTime.now();
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            nowDateTime = dateTime.format(df);
        }
        cacheModel.getOrder().setSaleDate(nowDateTime);
        cacheModel.getOrder().setTerminalOperatorAuthzCardNo(authCardNo);
        cacheModel.getOrder().setRefundAuthzCardNo(thAuthCardNo);
        return new RespBase(Code.SUCCESS, message, (Object)cacheModel, "GETRETURNMESSCERTIFY");
    }
}

