/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.dao.impl;

import com.alibaba.fastjson.JSONObject;
import com.efuture.business.dao.V3MzkSaleDao;
import com.efuture.business.model.mzk.request.V3MzkRequestDef;
import com.efuture.business.model.mzk.response.V3MzkResultDef;
import com.efuture.business.util.db.DbTools;
import com.efuture.business.util.db.MultipleDataSource;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.CallableStatementCallback;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.jdbc.core.JdbcTemplate;

public class V3MzkSaleDaoImpl
implements V3MzkSaleDao {
    private static final Logger log = LoggerFactory.getLogger(V3MzkSaleDaoImpl.class);
    @Autowired
    @Qualifier(value="jdbcTemplate")
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private DbTools dbTools;
    @Value(value="${v3_java_sendmzk:}")
    private String java_sendmzk;
    @Value(value="${v3_java_sendmzkIn:}")
    private String java_sendmzkIn;
    @Value(value="${v3_java_sendmzkOut:}")
    private String java_sendmzkOut;
    @Value(value="${v3_java_sendmzkinfo:}")
    private String java_sendmzkinfo;
    @Value(value="${v3_java_sendmzkinfoIn:}")
    private String java_sendmzkinfoIn;
    @Value(value="${v3_java_sendmzkinfoOut:}")
    private String java_sendmzkinfoOut;
    @Value(value="${v3MzkDataSource_dataCharacter:ISO8859_1#GBK}")
    protected String dataCharacter;
    String dataSource = "v3MzkDataSource";

    @Override
    public V3MzkResultDef sendmzk(V3MzkRequestDef v3MzkRequestDef) {
        final String json = JSONObject.toJSONString((Object)v3MzkRequestDef);
        MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc(this.dataSource));
        log.info("v3sendmzk_dataSource\uff1a" + this.dataSource);
        log.info("v3sendmzk_process[" + v3MzkRequestDef.getFlow_no() + "]In:" + json);
        HashMap ropValue = (HashMap)this.jdbcTemplate.execute(new CallableStatementCreator(){

            public CallableStatement createCallableStatement(Connection con) {
                try {
                    String storedProc = V3MzkSaleDaoImpl.this.java_sendmzk;
                    CallableStatement cs = con.prepareCall(storedProc);
                    return V3MzkSaleDaoImpl.this.dbTools.paseCallableStatementReq(cs, json, V3MzkSaleDaoImpl.this.java_sendmzkIn, V3MzkSaleDaoImpl.this.java_sendmzkOut, V3MzkSaleDaoImpl.this.dataCharacter);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.info("\u6267\u884c\u5b58\u50a8\u8fc7\u7a0b\u5f02\u5e38\uff1a" + e);
                    return null;
                }
            }
        }, new CallableStatementCallback(){

            public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
                try {
                    cs.execute();
                    HashMap hashMap = V3MzkSaleDaoImpl.this.dbTools.paseCallableStatementRop(cs, V3MzkSaleDaoImpl.this.java_sendmzkIn, V3MzkSaleDaoImpl.this.java_sendmzkOut, V3MzkSaleDaoImpl.this.dataCharacter);
                    return hashMap;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.info("\u6267\u884c\u5b58\u50a8\u8fc7\u7a0b\u5f02\u5e382\uff1a" + e);
                }
                finally {
                    if (null != cs) {
                        cs.close();
                    }
                }
                return null;
            }
        });
        log.info("v3sendmzk_process[" + v3MzkRequestDef.getFlow_no() + "]Out:" + ropValue);
        V3MzkResultDef vipProOut = new V3MzkResultDef();
        try {
            DbTools.ConvertToObjectNoTranscoding((Object)vipProOut, (HashMap)ropValue, (String[])V3MzkResultDef.ref);
        }
        catch (Exception e) {
            vipProOut.setRecode(1);
            log.info("Return convert to Bean error:" + e.toString());
        }
        MultipleDataSource.clearDataSource();
        return vipProOut;
    }

    @Override
    public V3MzkResultDef sendmzkinfo(V3MzkRequestDef v3MzkRequestDef) {
        final String json = JSONObject.toJSONString((Object)v3MzkRequestDef);
        MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc(this.dataSource));
        log.info("v3sendmzkinfo_dataSource\uff1a" + this.dataSource);
        log.info("v3sendmzkinfo_process[" + v3MzkRequestDef.getFlow_no() + "]In:" + json);
        HashMap ropValue = (HashMap)this.jdbcTemplate.execute(new CallableStatementCreator(){

            public CallableStatement createCallableStatement(Connection con) {
                try {
                    String storedProc = V3MzkSaleDaoImpl.this.java_sendmzkinfo;
                    CallableStatement cs = con.prepareCall(storedProc);
                    return V3MzkSaleDaoImpl.this.dbTools.paseCallableStatementReq(cs, json, V3MzkSaleDaoImpl.this.java_sendmzkinfoIn, V3MzkSaleDaoImpl.this.java_sendmzkinfoOut, V3MzkSaleDaoImpl.this.dataCharacter);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.info("\u6267\u884c\u5b58\u50a8\u8fc7\u7a0b\u5f02\u5e38\uff1a" + e);
                    return null;
                }
            }
        }, new CallableStatementCallback(){

            public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
                try {
                    cs.execute();
                    HashMap hashMap = V3MzkSaleDaoImpl.this.dbTools.paseCallableStatementRop(cs, V3MzkSaleDaoImpl.this.java_sendmzkinfoIn, V3MzkSaleDaoImpl.this.java_sendmzkinfoOut, V3MzkSaleDaoImpl.this.dataCharacter);
                    return hashMap;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.info("\u6267\u884c\u5b58\u50a8\u8fc7\u7a0b\u5f02\u5e382\uff1a" + e);
                }
                finally {
                    if (null != cs) {
                        cs.close();
                    }
                }
                return null;
            }
        });
        log.info("v3sendmzkinfo_process[" + v3MzkRequestDef.getFlow_no() + "]Out:" + ropValue);
        V3MzkResultDef vipProOut = new V3MzkResultDef();
        try {
            DbTools.ConvertToObjectNoTranscoding((Object)vipProOut, (HashMap)ropValue, (String[])V3MzkResultDef.ref);
        }
        catch (Exception e) {
            vipProOut.setRecode(1);
            log.info("Return convert to Bean error:" + e.toString());
        }
        MultipleDataSource.clearDataSource();
        return vipProOut;
    }
}

