/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.model.allVpay.request;

import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.model.allVpay.BaseRequest;
import com.efuture.business.model.allVpay.request.ZhongbaiBill;
import com.efuture.business.model.allVpay.response.ZhongbaiPaymentIn;
import com.efuture.business.util.RSAConfig;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class PayRequest
extends BaseRequest {
    private static final long serialVersionUID = 1L;

    public PayRequest(ZhongbaiPaymentIn reqIn, CacheModel cacheModel, RSAConfig rsaConfig) {
        super("1.0", rsaConfig.getMcId(), "", BaseRequest.ZBServiceType.sale.code());
        PayRequestData data = new PayRequestData(reqIn, cacheModel);
        this.setData(data);
    }

    @Override
    public String toString() {
        return "PayRequest [getTraceId()=" + this.getTraceId() + ", getVersion()=" + this.getVersion() + ", getInCharSet()=" + this.getInCharSet() + ", getOutCharSet()=" + this.getOutCharSet() + ", getMcId()=" + this.getMcId() + ", getPactId()=" + this.getPactId() + ", getService()=" + this.getService() + ", getData()=" + this.getData() + ", getClass()=" + this.getClass() + ", hashCode()=" + this.hashCode() + ", toString()=" + super.toString() + "]";
    }

    public static class PayRequestData
    extends BaseRequest.RequestData {
        private static final long serialVersionUID = 1L;
        private String listNo;
        private String cashier;
        private String orderNo;
        private String payCode;
        private String payMode;
        private long transAmt;
        private int repeat;
        private ZhongbaiBill bill;

        public String getListNo() {
            return this.listNo;
        }

        public void setListNo(String listNo) {
            this.listNo = listNo;
        }

        public String getCashier() {
            return this.cashier;
        }

        public void setCashier(String cashier) {
            this.cashier = cashier;
        }

        public String getOrderNo() {
            return this.orderNo;
        }

        public void setOrderNo(String orderNo) {
            this.orderNo = orderNo;
        }

        public String getPayCode() {
            return this.payCode;
        }

        public void setPayCode(String payCode) {
            this.payCode = payCode;
        }

        public String getPayMode() {
            return this.payMode;
        }

        public void setPayMode(String payMode) {
            this.payMode = payMode;
        }

        public long getTransAmt() {
            return this.transAmt;
        }

        public void setTransAmt(long transAmt) {
            this.transAmt = transAmt;
        }

        public int getRepeat() {
            return this.repeat;
        }

        public void setRepeat(int repeat) {
            this.repeat = repeat;
        }

        public ZhongbaiBill getBill() {
            return this.bill;
        }

        public void setBill(ZhongbaiBill bill) {
            this.bill = bill;
        }

        @Override
        public String toString() {
            return "PayRequestData [listNo=" + this.listNo + ", cashier=" + this.cashier + ", orderNo=" + this.orderNo + ", payCode=" + this.payCode + ", payMode=" + this.payMode + ", transAmt=" + this.transAmt + ", repeat=" + this.repeat + ", bill=" + this.bill + "]";
        }

        public PayRequestData(ZhongbaiPaymentIn reqIn, CacheModel cacheModel) {
            Order order = cacheModel.getOrder();
            LocalDateTime dateTime = LocalDateTime.now();
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
            String nowDateTime = dateTime.format(df).toString();
            this.setTransDate(nowDateTime);
            if ("002".equals(order.getErpCode())) {
                this.setStoreCode(reqIn.getShopCode().substring(0, 4));
            } else {
                this.setStoreCode(reqIn.getShopCode());
            }
            this.setPosId(reqIn.getTerminalNo());
            this.setListNo(order.getTerminalSno());
            this.setCashier(reqIn.getTerminalOperator());
            this.setOrderNo(reqIn.getOrderNo());
            this.setPayCode(reqIn.getPayNo());
            this.setPayMode("BARCODE");
            this.setTransAmt(ManipulatePrecision.doubleToInt((double)reqIn.getMoney(), (double)100.0));
            this.setRepeat(0);
            ZhongbaiBill bill = new ZhongbaiBill(cacheModel);
            this.setBill(bill);
        }

        public PayRequestData() {
        }
    }
}

