/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.model.allVpay.request;

import com.alibaba.fastjson.JSONObject;
import com.efuture.business.javaPos.commonkit.Convert;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.model.GetPayInfoIn;
import com.efuture.business.model.allVpay.PayCommon;
import com.efuture.business.util.AllVPayTools;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class PayRequest2
extends PayCommon {
    String messageLen;
    String exchangeCode = "01";
    String payType;
    String payShopCode;
    String terminalOperator;
    String terminalNo;
    String terminalSno;
    String idSheetNo;
    String payBarCode;
    String money;
    String createTime;
    String payMemo = "";
    String goodsDefine;
    List<GoodsPackage> goodsPackages;
    String syjip;
    String faceScanning;
    String machineCode;

    public PayRequest2(GetPayInfoIn jsonObject, List<GoodsPackage> goodsPackage) {
        this.setPayType(jsonObject.getPayType());
        if ("D1".equals(jsonObject.getPayType()) || "B9".equals(jsonObject.getPayType())) {
            this.setPayShopCode(jsonObject.getPayShopCode());
        } else {
            String payShopCode = jsonObject.getPayShopCode();
            if (payShopCode.length() > 4) {
                payShopCode = jsonObject.getPayShopCode().substring(0, 4);
            }
            this.setPayShopCode(payShopCode);
        }
        this.setTerminalNo(jsonObject.getPayTerminalNo());
        this.setTerminalOperator(jsonObject.getTerminalOperator());
        this.setTerminalSno(jsonObject.getTerminalSno());
        this.setIdSheetNo(jsonObject.getIdSheetNo());
        this.setPayBarCode(jsonObject.getPayNo());
        int amount = (int)ManipulatePrecision.doubleConvert((double)(jsonObject.getMoney() * 100.0));
        this.setMoney(String.valueOf(amount));
        this.setGoodsPackages(goodsPackage);
        this.setCreateTime(AllVPayTools.getTime());
        if (StringUtils.isNotBlank((String)jsonObject.getPayMemo())) {
            this.payMemo = jsonObject.getPayMemo();
        }
        if (StringUtils.isNotBlank((String)jsonObject.getFaceScanning())) {
            this.faceScanning = jsonObject.getFaceScanning();
        }
        this.machineCode = jsonObject.getMachineCode();
        if ("67".equals(this.payType)) {
            this.setPayShopCode(jsonObject.getPayShopCode());
            this.setTerminalNo(jsonObject.getPayTerminalNo());
        }
    }

    public PayRequest2(JSONObject jsonObject, List<GoodsPackage> goodsPackage) {
        this.setPayType(jsonObject.getString("payType"));
        this.setPayShopCode(jsonObject.getString("payShopCode").substring(0, 4));
        this.setTerminalNo(jsonObject.getString("payTerminalNo"));
        this.setTerminalOperator(jsonObject.getString("terminalOperator"));
        this.setTerminalSno(jsonObject.getString("terminalSno"));
        this.setIdSheetNo(jsonObject.getString("idSheetNo"));
        this.setPayBarCode(jsonObject.getString("payNo"));
        int amount = (int)ManipulatePrecision.doubleConvert((double)(jsonObject.getDoubleValue("money") * 100.0));
        this.setMoney(String.valueOf(amount));
        this.setGoodsPackages(goodsPackage);
        this.setCreateTime(AllVPayTools.getTime());
    }

    public String getMessageLen() {
        return this.messageLen;
    }

    public void setMessageLen(String messageLen) {
        this.messageLen = messageLen;
    }

    public String getExchangeCode() {
        return this.exchangeCode;
    }

    public void setExchangeCode(String exchangeCode) {
        this.exchangeCode = exchangeCode;
    }

    public String getPayType() {
        return this.payType;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }

    public String getPayShopCode() {
        return this.payShopCode;
    }

    public void setPayShopCode(String payShopCode) {
        this.payShopCode = payShopCode;
    }

    public List<GoodsPackage> getGoodsPackages() {
        return this.goodsPackages;
    }

    public void setGoodsPackages(List<GoodsPackage> goodsPackages) {
        this.goodsPackages = goodsPackages;
    }

    public String getTerminalOperator() {
        return this.terminalOperator;
    }

    public void setTerminalOperator(String terminalOperator) {
        this.terminalOperator = terminalOperator;
    }

    public String getTerminalNo() {
        return this.terminalNo;
    }

    public void setTerminalNo(String terminalNo) {
        this.terminalNo = terminalNo;
    }

    public String getTerminalSno() {
        return this.terminalSno;
    }

    public void setTerminalSno(String terminalSno) {
        this.terminalSno = terminalSno;
    }

    public String getIdSheetNo() {
        return this.idSheetNo;
    }

    public void setIdSheetNo(String idSheetNo) {
        this.idSheetNo = idSheetNo;
    }

    public String getPayBarCode() {
        return this.payBarCode;
    }

    public void setPayBarCode(String payBarCode) {
        this.payBarCode = payBarCode;
    }

    public String getMoney() {
        return this.money;
    }

    public void setMoney(String money) {
        this.money = money;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getPayMemo() {
        return this.payMemo;
    }

    public void setPayMemo(String payMemo) {
        this.payMemo = payMemo;
    }

    public String getGoodsDefine() {
        return this.goodsDefine;
    }

    public void setGoodsDefine(String goodsDefine) {
        this.goodsDefine = goodsDefine;
    }

    public String getSyjip() {
        return this.syjip;
    }

    public void setSyjip(String syjip) {
        this.syjip = syjip;
    }

    public String toString() {
        String str2;
        int len = this.goodsPackages.size() * 180 + 6 + 250;
        StringBuffer sb1 = new StringBuffer();
        if ("D4".equals(this.payType)) {
            String str1 = "000000";
            str2 = "";
            String str3 = "";
            String str4 = "";
            String str5 = "";
            String str6 = "000000";
            String str7 = "";
            String str8 = "";
            String str9 = "";
            JSONObject fj = new JSONObject();
            fj.put("description", (Object)"\u65e0");
            fj.put("client_ip", (Object)this.syjip);
            str9 = fj.toJSONString();
            sb1.append(str1);
            sb1.append(Convert.increaseChar((String)str3, (char)' ', (int)96));
            sb1.append(str6);
            int len1 = Convert.countLength((String)str9);
            str8 = Convert.increaseCharForward((String)String.valueOf(len1), (char)'0', (int)6);
            sb1.append(str8);
            sb1.append(str9);
            len += Convert.countLength((String)sb1.toString());
        }
        StringBuilder sb2 = new StringBuilder();
        if ("0".equals(this.faceScanning)) {
            str2 = this.machineCode;
            String lengthStr = String.valueOf(str2.length());
            String str1 = "000000".substring(0, 6 - lengthStr.length()) + lengthStr;
            sb2.append(str1);
            sb2.append(str2);
            len += Convert.countLength((String)sb2.toString());
            if (!StringUtils.contains((String)this.payMemo, (String)"   Y")) {
                this.payMemo = "   Y" + this.payBarCode;
            }
            this.payBarCode = "";
        }
        if ("B9".equals(this.payType)) {
            String space = Convert.increaseCharForward((String)"", (char)' ', (int)19);
            this.payMemo = space + this.syjip;
        }
        StringBuilder sb = new StringBuilder(Convert.increaseCharForward((String)String.valueOf(len), (char)'0', (int)6));
        sb.append(this.exchangeCode);
        sb.append(this.payType);
        sb.append(Convert.increaseChar((String)this.payShopCode, (char)' ', (int)15));
        sb.append(Convert.increaseChar((String)this.terminalOperator, (char)' ', (int)15));
        sb.append(Convert.increaseChar((String)this.terminalNo, (char)' ', (int)15));
        sb.append(Convert.increaseChar((String)this.terminalSno, (char)' ', (int)15));
        sb.append(Convert.increaseChar((String)this.idSheetNo, (char)' ', (int)64));
        sb.append(Convert.increaseChar((String)this.payBarCode, (char)' ', (int)30));
        sb.append(Convert.increaseChar((String)this.money, (char)' ', (int)12));
        sb.append(Convert.increaseChar((String)this.createTime, (char)' ', (int)14));
        sb.append(Convert.increaseChar((String)this.payMemo, (char)' ', (int)66));
        sb.append("180").append(Convert.increaseCharForward((String)String.valueOf(this.goodsPackages.size()), (char)'0', (int)3));
        for (GoodsPackage goodsPackage : this.goodsPackages) {
            sb.append(goodsPackage.toString());
        }
        if ("D4".equals(this.payType)) {
            sb.append(sb1);
        }
        if ("0".equals(this.faceScanning)) {
            sb.append((CharSequence)sb2);
        }
        return sb.toString();
    }

    public String getFaceScanning() {
        return this.faceScanning;
    }

    public String getMachineCode() {
        return this.machineCode;
    }

    public void setFaceScanning(String faceScanning) {
        this.faceScanning = faceScanning;
    }

    public void setMachineCode(String machineCode) {
        this.machineCode = machineCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PayRequest2)) {
            return false;
        }
        PayRequest2 other = (PayRequest2)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$messageLen = this.getMessageLen();
        String other$messageLen = other.getMessageLen();
        if (this$messageLen == null ? other$messageLen != null : !this$messageLen.equals(other$messageLen)) {
            return false;
        }
        String this$exchangeCode = this.getExchangeCode();
        String other$exchangeCode = other.getExchangeCode();
        if (this$exchangeCode == null ? other$exchangeCode != null : !this$exchangeCode.equals(other$exchangeCode)) {
            return false;
        }
        String this$payType = this.getPayType();
        String other$payType = other.getPayType();
        if (this$payType == null ? other$payType != null : !this$payType.equals(other$payType)) {
            return false;
        }
        String this$payShopCode = this.getPayShopCode();
        String other$payShopCode = other.getPayShopCode();
        if (this$payShopCode == null ? other$payShopCode != null : !this$payShopCode.equals(other$payShopCode)) {
            return false;
        }
        String this$terminalOperator = this.getTerminalOperator();
        String other$terminalOperator = other.getTerminalOperator();
        if (this$terminalOperator == null ? other$terminalOperator != null : !this$terminalOperator.equals(other$terminalOperator)) {
            return false;
        }
        String this$terminalNo = this.getTerminalNo();
        String other$terminalNo = other.getTerminalNo();
        if (this$terminalNo == null ? other$terminalNo != null : !this$terminalNo.equals(other$terminalNo)) {
            return false;
        }
        String this$terminalSno = this.getTerminalSno();
        String other$terminalSno = other.getTerminalSno();
        if (this$terminalSno == null ? other$terminalSno != null : !this$terminalSno.equals(other$terminalSno)) {
            return false;
        }
        String this$idSheetNo = this.getIdSheetNo();
        String other$idSheetNo = other.getIdSheetNo();
        if (this$idSheetNo == null ? other$idSheetNo != null : !this$idSheetNo.equals(other$idSheetNo)) {
            return false;
        }
        String this$payBarCode = this.getPayBarCode();
        String other$payBarCode = other.getPayBarCode();
        if (this$payBarCode == null ? other$payBarCode != null : !this$payBarCode.equals(other$payBarCode)) {
            return false;
        }
        String this$money = this.getMoney();
        String other$money = other.getMoney();
        if (this$money == null ? other$money != null : !this$money.equals(other$money)) {
            return false;
        }
        String this$createTime = this.getCreateTime();
        String other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) {
            return false;
        }
        String this$payMemo = this.getPayMemo();
        String other$payMemo = other.getPayMemo();
        if (this$payMemo == null ? other$payMemo != null : !this$payMemo.equals(other$payMemo)) {
            return false;
        }
        String this$goodsDefine = this.getGoodsDefine();
        String other$goodsDefine = other.getGoodsDefine();
        if (this$goodsDefine == null ? other$goodsDefine != null : !this$goodsDefine.equals(other$goodsDefine)) {
            return false;
        }
        List<GoodsPackage> this$goodsPackages = this.getGoodsPackages();
        List<GoodsPackage> other$goodsPackages = other.getGoodsPackages();
        if (this$goodsPackages == null ? other$goodsPackages != null : !((Object)this$goodsPackages).equals(other$goodsPackages)) {
            return false;
        }
        String this$syjip = this.getSyjip();
        String other$syjip = other.getSyjip();
        if (this$syjip == null ? other$syjip != null : !this$syjip.equals(other$syjip)) {
            return false;
        }
        String this$faceScanning = this.getFaceScanning();
        String other$faceScanning = other.getFaceScanning();
        if (this$faceScanning == null ? other$faceScanning != null : !this$faceScanning.equals(other$faceScanning)) {
            return false;
        }
        String this$machineCode = this.getMachineCode();
        String other$machineCode = other.getMachineCode();
        return !(this$machineCode == null ? other$machineCode != null : !this$machineCode.equals(other$machineCode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PayRequest2;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $messageLen = this.getMessageLen();
        result = result * 59 + ($messageLen == null ? 43 : $messageLen.hashCode());
        String $exchangeCode = this.getExchangeCode();
        result = result * 59 + ($exchangeCode == null ? 43 : $exchangeCode.hashCode());
        String $payType = this.getPayType();
        result = result * 59 + ($payType == null ? 43 : $payType.hashCode());
        String $payShopCode = this.getPayShopCode();
        result = result * 59 + ($payShopCode == null ? 43 : $payShopCode.hashCode());
        String $terminalOperator = this.getTerminalOperator();
        result = result * 59 + ($terminalOperator == null ? 43 : $terminalOperator.hashCode());
        String $terminalNo = this.getTerminalNo();
        result = result * 59 + ($terminalNo == null ? 43 : $terminalNo.hashCode());
        String $terminalSno = this.getTerminalSno();
        result = result * 59 + ($terminalSno == null ? 43 : $terminalSno.hashCode());
        String $idSheetNo = this.getIdSheetNo();
        result = result * 59 + ($idSheetNo == null ? 43 : $idSheetNo.hashCode());
        String $payBarCode = this.getPayBarCode();
        result = result * 59 + ($payBarCode == null ? 43 : $payBarCode.hashCode());
        String $money = this.getMoney();
        result = result * 59 + ($money == null ? 43 : $money.hashCode());
        String $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : $createTime.hashCode());
        String $payMemo = this.getPayMemo();
        result = result * 59 + ($payMemo == null ? 43 : $payMemo.hashCode());
        String $goodsDefine = this.getGoodsDefine();
        result = result * 59 + ($goodsDefine == null ? 43 : $goodsDefine.hashCode());
        List<GoodsPackage> $goodsPackages = this.getGoodsPackages();
        result = result * 59 + ($goodsPackages == null ? 43 : ((Object)$goodsPackages).hashCode());
        String $syjip = this.getSyjip();
        result = result * 59 + ($syjip == null ? 43 : $syjip.hashCode());
        String $faceScanning = this.getFaceScanning();
        result = result * 59 + ($faceScanning == null ? 43 : $faceScanning.hashCode());
        String $machineCode = this.getMachineCode();
        result = result * 59 + ($machineCode == null ? 43 : $machineCode.hashCode());
        return result;
    }

    public static class GoodsPackage {
        String goodsNo;
        String barcode;
        String goodsName;
        String category;
        String categoryName;
        String brandName;
        String saleAmount;
        String qty;
        String saleUnit;
        String goodsMemo = "";

        public String getGoodsNo() {
            return this.goodsNo;
        }

        public void setGoodsNo(String goodsNo) {
            this.goodsNo = goodsNo;
        }

        public String getBarcode() {
            return this.barcode;
        }

        public void setBarcode(String barcode) {
            this.barcode = barcode;
        }

        public String getGoodsName() {
            return this.goodsName;
        }

        public void setGoodsName(String goodsName) {
            this.goodsName = goodsName;
        }

        public String getCategory() {
            return this.category;
        }

        public void setCategory(String category) {
            this.category = category;
        }

        public String getCategoryName() {
            return this.categoryName;
        }

        public void setCategoryName(String categoryName) {
            this.categoryName = categoryName;
        }

        public String getBrandName() {
            return this.brandName;
        }

        public void setBrandName(String brandName) {
            this.brandName = brandName;
        }

        public String getSaleAmount() {
            return this.saleAmount;
        }

        public void setSaleAmount(String saleAmount) {
            this.saleAmount = saleAmount;
        }

        public String getQty() {
            return this.qty;
        }

        public void setQty(String qty) {
            this.qty = qty;
        }

        public String getSaleUnit() {
            return this.saleUnit;
        }

        public void setSaleUnit(String saleUnit) {
            this.saleUnit = saleUnit;
        }

        public String getGoodsMemo() {
            return this.goodsMemo;
        }

        public void setGoodsMemo(String goodsMemo) {
            this.goodsMemo = goodsMemo;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(Convert.increaseChar((String)this.goodsNo, (char)' ', (int)20));
            sb.append(Convert.increaseChar((String)this.barcode, (char)' ', (int)20));
            sb.append(Convert.appendStringSize((String)this.goodsName, (String)" ", (int)Convert.countLength((String)this.goodsName), (int)40, (int)40));
            sb.append(Convert.increaseChar((String)this.category, (char)' ', (int)12));
            sb.append(Convert.increaseChar((String)this.categoryName, (char)' ', (int)20));
            sb.append(Convert.increaseChar((String)this.brandName, (char)' ', (int)20));
            sb.append(Convert.increaseChar((String)this.saleAmount, (char)' ', (int)12));
            sb.append(Convert.increaseChar((String)this.qty, (char)' ', (int)10));
            sb.append(Convert.increaseChar((String)this.saleUnit, (char)' ', (int)10));
            sb.append(Convert.increaseChar((String)this.goodsMemo, (char)' ', (int)16));
            System.out.println(sb.toString());
            return sb.toString();
        }
    }
}

