/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.model.allVpay.request;

import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.model.allVpay.BaseRequest;
import com.efuture.business.model.allVpay.request.PayRequest;
import com.efuture.business.model.allVpay.request.RefundRequest;
import com.efuture.business.model.allVpay.request.SubmitRequest;
import com.efuture.business.model.allVpay.request.VoidRequest;
import com.efuture.business.model.allVpay.request.ZhongbaiSaleQueryIn;
import com.efuture.business.util.RSAConfig;
import java.util.Date;
import org.apache.commons.httpclient.util.DateUtil;
import org.springframework.util.StringUtils;

public class SaleQueryRequest
extends BaseRequest {
    private static final long serialVersionUID = 1L;

    public SaleQueryRequest(ZhongbaiSaleQueryIn reqIn, CacheModel cacheModel) {
        QueryRequestData data = new QueryRequestData(reqIn, cacheModel);
        this.setService(BaseRequest.ZBServiceType.query.code());
        this.setData(data);
    }

    public SaleQueryRequest(ZhongbaiSaleQueryIn reqIn, RSAConfig rsaConfig, CacheModel cacheModel) {
        super("1.0", rsaConfig.getMcId(), "", BaseRequest.ZBServiceType.query.code());
        QueryRequestData data = new QueryRequestData(reqIn, cacheModel);
        this.setData(data);
    }

    public SaleQueryRequest(PayRequest payData, RSAConfig rsaConfig) {
        super(rsaConfig.getVersion(), rsaConfig.getMcId(), rsaConfig.getPactId(), BaseRequest.ZBServiceType.query.code());
        QueryRequestData data = new QueryRequestData(payData);
        this.setData(data);
    }

    public SaleQueryRequest(RefundRequest refundReq, RSAConfig rsaConfig) {
        super(rsaConfig.getVersion(), rsaConfig.getMcId(), rsaConfig.getPactId(), BaseRequest.ZBServiceType.query.code());
        QueryRequestData data = new QueryRequestData(refundReq);
        this.setData(data);
    }

    public SaleQueryRequest(VoidRequest voidReq, RSAConfig rsaConfig) {
        super(rsaConfig.getVersion(), rsaConfig.getMcId(), rsaConfig.getPactId(), BaseRequest.ZBServiceType.query.code());
        QueryRequestData data = new QueryRequestData(voidReq);
        this.setData(data);
    }

    public SaleQueryRequest(SubmitRequest subReq, RSAConfig rsaConfig) {
        super(rsaConfig.getVersion(), rsaConfig.getMcId(), rsaConfig.getPactId(), BaseRequest.ZBServiceType.query.code());
        QueryRequestData data = new QueryRequestData(subReq);
        this.setData(data);
    }

    public static class QueryRequestData
    extends BaseRequest.RequestData {
        private static final long serialVersionUID = 1L;
        private String listNo;
        private String orderNo;
        private String refundNo;

        public String getListNo() {
            return this.listNo;
        }

        public void setListNo(String listNo) {
            this.listNo = listNo;
        }

        public String getOrderNo() {
            return this.orderNo;
        }

        public void setOrderNo(String orderNo) {
            this.orderNo = orderNo;
        }

        public String getRefundNo() {
            return this.refundNo;
        }

        public void setRefundNo(String refundNo) {
            this.refundNo = refundNo;
        }

        public QueryRequestData(ZhongbaiSaleQueryIn reqIn, CacheModel cacheModel) {
            this.setTransDate(DateUtil.formatDate((Date)new Date(), (String)"yyyyMMddHHmmss"));
            if ("002".equals(cacheModel.getOrder().getErpCode())) {
                this.setStoreCode(reqIn.getShopCode().substring(0, 4));
            } else {
                this.setStoreCode(reqIn.getShopCode());
            }
            this.setPosId(reqIn.getTerminalNo());
            this.setListNo(reqIn.getIdSheetNo());
            this.setOrderNo(reqIn.getOrderNo());
            if ("4".equals(reqIn.getQueryType())) {
                this.setRefundNo(reqIn.getRefundNo());
            }
        }

        public QueryRequestData(PayRequest payReq) {
            PayRequest.PayRequestData payData = (PayRequest.PayRequestData)payReq.getData();
            this.setTransDate(DateUtil.formatDate((Date)new Date(), (String)"yyyyMMddHHmmss"));
            this.setStoreCode(payData.getStoreCode());
            this.setPosId(payData.getPosId());
            this.setListNo(payData.getListNo());
            this.setOrderNo(payData.getOrderNo());
        }

        public QueryRequestData(RefundRequest refundReq) {
            RefundRequest.RefundRequestData refundData = (RefundRequest.RefundRequestData)refundReq.getData();
            this.setTransDate(DateUtil.formatDate((Date)new Date(), (String)"yyyyMMddHHmmss"));
            this.setStoreCode(refundData.getStoreCode());
            this.setPosId(refundData.getPosId());
            this.setListNo(refundData.getListNo());
            this.setOrderNo(refundData.getOrderNo());
            this.setRefundNo(refundData.getRefundNo());
        }

        public QueryRequestData(VoidRequest voidReq) {
            VoidRequest.VoidRequestData voidData = (VoidRequest.VoidRequestData)voidReq.getData();
            this.setTransDate(DateUtil.formatDate((Date)new Date(), (String)"yyyyMMddHHmmss"));
            this.setStoreCode(voidData.getStoreCode());
            this.setPosId(voidData.getPosId());
            this.setListNo(voidData.getListNo());
            this.setOrderNo(voidData.getOrderNo());
            if (!StringUtils.isEmpty((Object)voidData.getRefundNo())) {
                this.setRefundNo(voidData.getRefundNo());
            }
        }

        public QueryRequestData(SubmitRequest subReq) {
            VoidRequest.VoidRequestData subData = (VoidRequest.VoidRequestData)subReq.getData();
            this.setTransDate(DateUtil.formatDate((Date)new Date(), (String)"yyyyMMddHHmmss"));
            this.setStoreCode(subData.getStoreCode());
            this.setPosId(subData.getPosId());
            this.setListNo(subData.getListNo());
            this.setOrderNo(subData.getOrderNo());
            if (!StringUtils.isEmpty((Object)subData.getRefundNo())) {
                this.setRefundNo(subData.getRefundNo());
            }
        }

        public QueryRequestData() {
        }
    }
}

