/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.model.allVpay.request;

import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.model.allVpay.BaseRequest;
import com.efuture.business.model.allVpay.request.ZhongbaiBill;
import com.efuture.business.util.RSAConfig;
import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class SubmitRequest
extends BaseRequest {
    private static final long serialVersionUID = 1L;

    public SubmitRequest(CacheModel cacheModel) {
        SubmitRequestData data = new SubmitRequestData(cacheModel);
        this.setService(BaseRequest.ZBServiceType.submit.code());
        this.setData(data);
    }

    public SubmitRequest(CacheModel cacheModel, RSAConfig rsaConfig) {
        super(rsaConfig.getVersion(), rsaConfig.getMcId(), rsaConfig.getPactId(), BaseRequest.ZBServiceType.submit.code());
        SubmitRequestData data = new SubmitRequestData(cacheModel);
        this.setData(data);
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        String str = "MQ|000011|01|\u96c6\u56e2\u5361";
        System.out.println(str.length());
        System.out.println(str.getBytes("GB2312").length);
    }

    public static class SubmitRequestData
    extends BaseRequest.RequestData {
        private static final long serialVersionUID = 1L;
        private String listNo;
        private String cashier;
        private ZhongbaiBill bill;

        public ZhongbaiBill getBill() {
            return this.bill;
        }

        public void setBill(ZhongbaiBill bill) {
            this.bill = bill;
        }

        public String getListNo() {
            return this.listNo;
        }

        public void setListNo(String listNo) {
            this.listNo = listNo;
        }

        public String getCashier() {
            return this.cashier;
        }

        public void setCashier(String cashier) {
            this.cashier = cashier;
        }

        public SubmitRequestData(CacheModel cacheModel) {
            Order order = cacheModel.getOrder();
            LocalDateTime dateTime = LocalDateTime.now();
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
            String nowDateTime = dateTime.format(df).toString();
            this.setTransDate(nowDateTime);
            if ("002".equals(order.getErpCode())) {
                this.setStoreCode(order.getShopCode().substring(0, 4));
            } else {
                this.setStoreCode(order.getShopCode());
            }
            this.setPosId(order.getTerminalNo());
            this.setListNo(order.getTerminalSno());
            this.setCashier(order.getTerminalOperator());
            ZhongbaiBill bill = new ZhongbaiBill(cacheModel);
            bill.setType(order.getOrderType());
            this.setBill(bill);
        }
    }
}

